// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.shared');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('sablono.core');
goog.require('hatti.utils.om.state');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('om.core');
goog.require('hatti.utils');
hatti.shared.event_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
hatti.shared.event_multi_chan = cljs.core.async.mult(hatti.shared.event_chan);
hatti.shared.event_tap = (function hatti$shared$event_tap(){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_multi_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
});
hatti.shared.external_event_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
hatti.shared.external_event_multi_chan = cljs.core.async.mult(hatti.shared.external_event_chan);
hatti.shared.external_event_tap = (function hatti$shared$external_event_tap(){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2(hatti.shared.external_event_multi_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
});
hatti.shared.default_fields = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$full_DASH_name,"_submission_time",cljs.core.cst$kw$label,"Submission Time",cljs.core.cst$kw$name,"_submission_time",cljs.core.cst$kw$type,"datetime"], null)], null);
/**
 * An initial, empty, app-state, which can be modified to change dataviews.
 */
hatti.shared.empty_app_state = (function hatti$shared$empty_app_state(){
var G__26602 = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$api_DASH_url,cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$status,cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$chart_DASH_page,cljs.core.cst$kw$languages,cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$views,cljs.core.cst$kw$data],["//api.ona.io/api/v1/",new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_clicked,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,null], null)], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$total_DASH_records,(0),cljs.core.cst$kw$loading_QMARK_,true], null),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$visible_DASH_charts,hatti.shared.default_fields,cljs.core.cst$kw$chart_DASH_data,cljs.core.PersistentArrayMap.EMPTY], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$current,null,cljs.core.cst$kw$all,cljs.core.PersistentVector.EMPTY], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$submission_DASH_clicked,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,null], null),cljs.core.cst$kw$geofield,cljs.core.PersistentArrayMap.EMPTY], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$all,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$overview,cljs.core.cst$kw$map,cljs.core.cst$kw$table,cljs.core.cst$kw$chart,cljs.core.cst$kw$saved_DASH_charts,cljs.core.cst$kw$settings], null),cljs.core.cst$kw$selected,cljs.core.cst$kw$overview], null),cljs.core.PersistentVector.EMPTY]);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__26602) : cljs.core.atom.call(null,G__26602));
});
hatti.shared.app_state = hatti.shared.empty_app_state();
/**
 * Given a function over data, run a transact on data inside app-state.
 */
hatti.shared.transact_app_data_BANG_ = (function hatti$shared$transact_app_data_BANG_(app_state,transact_fn){
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null),transact_fn);
});
/**
 * Given `data` received from the server, update the app-state.
 * Sorts by submission time, and adds rank to the data, for table + map views.
 */
hatti.shared.update_app_data_BANG_ = (function hatti$shared$update_app_data_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___26610 = arguments.length;
var i__5628__auto___26611 = (0);
while(true){
if((i__5628__auto___26611 < len__5627__auto___26610)){
args__5634__auto__.push((arguments[i__5628__auto___26611]));

var G__26612 = (i__5628__auto___26611 + (1));
i__5628__auto___26611 = G__26612;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,data,p__26607){
var map__26608 = p__26607;
var map__26608__$1 = ((((!((map__26608 == null)))?((((map__26608.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26608.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26608):map__26608);
var rerank_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26608__$1,cljs.core.cst$kw$rerank_QMARK_);
var completed_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26608__$1,cljs.core.cst$kw$completed_QMARK_);
var sort_field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26608__$1,cljs.core.cst$kw$sort_DASH_field);
var current_start_index = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__26608__$1,cljs.core.cst$kw$current_DASH_start_DASH_index,(0));
var add_rank = ((function (map__26608,map__26608__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (i,v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v,hatti.constants._rank,(current_start_index + (i + (1))));
});})(map__26608,map__26608__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
;
var data__$1 = (cljs.core.truth_((function (){var and__4557__auto__ = rerank_QMARK_;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.seq(data);
} else {
return and__4557__auto__;
}
})())?cljs.core.vec(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(add_rank,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(((function (add_rank,map__26608,map__26608__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (p1__26603_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__26603_SHARP_,(function (){var or__4569__auto__ = sort_field;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return hatti.constants._submission_time;
}
})());
});})(add_rank,map__26608,map__26608__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
,data))):cljs.core.vec(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(add_rank,data)));
var total_records = cljs.core.count(data__$1);
hatti.shared.transact_app_data_BANG_(app_state,((function (add_rank,data__$1,total_records,map__26608,map__26608__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (_){
return data__$1;
});})(add_rank,data__$1,total_records,map__26608,map__26608__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
);

return hatti.utils.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$status], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$total_DASH_records,total_records,cljs.core.cst$kw$loading_QMARK_,cljs.core.not(completed_QMARK_)], null));
});

hatti.shared.update_app_data_BANG_.cljs$lang$maxFixedArity = (2);

hatti.shared.update_app_data_BANG_.cljs$lang$applyTo = (function (seq26604){
var G__26605 = cljs.core.first(seq26604);
var seq26604__$1 = cljs.core.next(seq26604);
var G__26606 = cljs.core.first(seq26604__$1);
var seq26604__$2 = cljs.core.next(seq26604__$1);
return hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__26605,G__26606,seq26604__$2);
});
/**
 * Add to app data.
 */
hatti.shared.add_to_app_data_BANG_ = (function hatti$shared$add_to_app_data_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___26619 = arguments.length;
var i__5628__auto___26620 = (0);
while(true){
if((i__5628__auto___26620 < len__5627__auto___26619)){
args__5634__auto__.push((arguments[i__5628__auto___26620]));

var G__26621 = (i__5628__auto___26620 + (1));
i__5628__auto___26620 = G__26621;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,data,p__26616){
var map__26617 = p__26616;
var map__26617__$1 = ((((!((map__26617 == null)))?((((map__26617.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26617.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26617):map__26617);
var completed_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26617__$1,cljs.core.cst$kw$completed_QMARK_);
var old_data = cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)));
hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(app_state,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(old_data,data),cljs.core.array_seq([cljs.core.cst$kw$rerank_QMARK_,completed_QMARK_], 0));

return hatti.utils.om.state.update_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$status,cljs.core.cst$kw$loading_QMARK_], null),cljs.core.not(completed_QMARK_));
});

hatti.shared.add_to_app_data_BANG_.cljs$lang$maxFixedArity = (2);

hatti.shared.add_to_app_data_BANG_.cljs$lang$applyTo = (function (seq26613){
var G__26614 = cljs.core.first(seq26613);
var seq26613__$1 = cljs.core.next(seq26613);
var G__26615 = cljs.core.first(seq26613__$1);
var seq26613__$2 = cljs.core.next(seq26613__$1);
return hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__26614,G__26615,seq26613__$2);
});
hatti.shared.language_cursor = (function hatti$shared$language_cursor(){
return om.core.ref_cursor(cljs.core.cst$kw$languages.cljs$core$IFn$_invoke$arity$1(om.core.root_cursor(hatti.shared.app_state)));
});
/**
 * A language selector and a following divider.
 */
hatti.shared.language_selector = (function hatti$shared$language_selector(_,owner){
if(typeof hatti.shared.t_hatti$shared26678 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.shared.t_hatti$shared26678 = (function (language_selector,_,owner,meta26679){
this.language_selector = language_selector;
this._ = _;
this.owner = owner;
this.meta26679 = meta26679;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.shared.t_hatti$shared26678.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26680,meta26679__$1){
var self__ = this;
var _26680__$1 = this;
return (new hatti.shared.t_hatti$shared26678(self__.language_selector,self__._,self__.owner,meta26679__$1));
});

hatti.shared.t_hatti$shared26678.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26680){
var self__ = this;
var _26680__$1 = this;
return self__.meta26679;
});

hatti.shared.t_hatti$shared26678.prototype.om$core$IRender$ = true;

hatti.shared.t_hatti$shared26678.prototype.om$core$IRender$render$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var map__26681 = om.core.observe(self__.owner,hatti.shared.language_cursor());
var map__26681__$1 = ((((!((map__26681 == null)))?((((map__26681.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26681.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26681):map__26681);
var ls = map__26681__$1;
var current = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26681__$1,cljs.core.cst$kw$current);
var all = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26681__$1,cljs.core.cst$kw$all);
var get_update_handler = ((function (map__26681,map__26681__$1,ls,current,all,___$2){
return (function (language){
return ((function (map__26681,map__26681__$1,ls,current,all,___$2){
return (function (event){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(ls,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$current], null),language);

return event.preventDefault();
});
;})(map__26681,map__26681__$1,ls,current,all,___$2))
});})(map__26681,map__26681__$1,ls,current,all,___$2))
;
var stringify = ((function (map__26681,map__26681__$1,ls,current,all,get_update_handler,___$2){
return (function (p1__26622_SHARP_){
if((p1__26622_SHARP_ instanceof cljs.core.Keyword)){
return cljs.core.name(p1__26622_SHARP_);
} else {
return [cljs.core.str(p1__26622_SHARP_)].join('');
}
});})(map__26681,map__26681__$1,ls,current,all,get_update_handler,___$2))
;
var G__26690 = {"className": "language-selector-inner"};
var G__26691 = (function (){var G__26693 = {"className": "dropdown drop-hover"};
var G__26694 = (function (){var G__26698 = {"style": {"marginRight": ".2em"}, "className": "fa fa-globe"};
return React.DOM.i(G__26698);
})();
var G__26695 = (function (){var attrs26685 = (cljs.core.truth_(hatti.ona.forms.english_QMARK_(current))?"EN":stringify(current));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs26685))?sablono.interpreter.attributes(attrs26685):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs26685))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs26685)], null))));
})();
var G__26696 = (function (){var G__26699 = {"style": {"marginLeft": ".5em"}, "className": "fa fa-angle-down"};
return React.DOM.i(G__26699);
})();
var G__26697 = (function (){var G__26700 = {"className": "submenu"};
var G__26701 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((function (){var iter__5341__auto__ = ((function (G__26700,G__26693,G__26694,G__26695,G__26696,G__26690,map__26681,map__26681__$1,ls,current,all,get_update_handler,stringify,___$2){
return (function hatti$shared$language_selector_$_iter__26702(s__26703){
return (new cljs.core.LazySeq(null,((function (G__26700,G__26693,G__26694,G__26695,G__26696,G__26690,map__26681,map__26681__$1,ls,current,all,get_update_handler,stringify,___$2){
return (function (){
var s__26703__$1 = s__26703;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__26703__$1);
if(temp__4425__auto__){
var s__26703__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__26703__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__26703__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__26705 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__26704 = (0);
while(true){
if((i__26704 < size__5340__auto__)){
var language = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__26704);
cljs.core.chunk_append(b__26705,(function (){var G__26722 = null;
var G__26723 = (function (){var G__26724 = {"href": "#", "onClick": get_update_handler(language)};
var G__26725 = sablono.interpreter.interpret(stringify(language));
return React.DOM.a(G__26724,G__26725);
})();
return React.DOM.li(G__26722,G__26723);
})());

var G__26733 = (i__26704 + (1));
i__26704 = G__26733;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__26705),hatti$shared$language_selector_$_iter__26702(cljs.core.chunk_rest(s__26703__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__26705),null);
}
} else {
var language = cljs.core.first(s__26703__$2);
return cljs.core.cons((function (){var G__26728 = null;
var G__26729 = (function (){var G__26730 = {"href": "#", "onClick": get_update_handler(language)};
var G__26731 = sablono.interpreter.interpret(stringify(language));
return React.DOM.a(G__26730,G__26731);
})();
return React.DOM.li(G__26728,G__26729);
})(),hatti$shared$language_selector_$_iter__26702(cljs.core.rest(s__26703__$2)));
}
} else {
return null;
}
break;
}
});})(G__26700,G__26693,G__26694,G__26695,G__26696,G__26690,map__26681,map__26681__$1,ls,current,all,get_update_handler,stringify,___$2))
,null,null));
});})(G__26700,G__26693,G__26694,G__26695,G__26696,G__26690,map__26681,map__26681__$1,ls,current,all,get_update_handler,stringify,___$2))
;
return iter__5341__auto__(all);
})());
return React.DOM.ul(G__26700,G__26701);
})();
return React.DOM.span(G__26693,G__26694,G__26695,G__26696,G__26697);
})();
var G__26692 = (function (){var G__26732 = {"className": "divider"};
return React.DOM.div(G__26732);
})();
return React.DOM.div(G__26690,G__26691,G__26692);
});

hatti.shared.t_hatti$shared26678.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$language_DASH_selector,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner], null))),cljs.core.cst$kw$doc,"A language selector and a following divider."], null)),cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta26679], null);
});

hatti.shared.t_hatti$shared26678.cljs$lang$type = true;

hatti.shared.t_hatti$shared26678.cljs$lang$ctorStr = "hatti.shared/t_hatti$shared26678";

hatti.shared.t_hatti$shared26678.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.shared/t_hatti$shared26678");
});

hatti.shared.__GT_t_hatti$shared26678 = (function hatti$shared$language_selector_$___GT_t_hatti$shared26678(language_selector__$1,___$1,owner__$1,meta26679){
return (new hatti.shared.t_hatti$shared26678(language_selector__$1,___$1,owner__$1,meta26679));
});

}

return (new hatti.shared.t_hatti$shared26678(hatti$shared$language_selector,_,owner,cljs.core.PersistentArrayMap.EMPTY));
});
