// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('c2.svg');
goog.require('cljs.core');
goog.require('c2.core');
goog.require('c2.maths');
goog.require('c2.dom');
/**
 * Ensure that coordinates (potentially map of `{:x :y}`) are a seq or vector pair.
 */
c2.svg.__GT_xy = (function c2$svg$__GT_xy(coordinates){
if((cljs.core.sequential_QMARK_(coordinates)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),cljs.core.count(coordinates)))){
return coordinates;
} else {
if(cljs.core.map_QMARK_(coordinates)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$x.cljs$core$IFn$_invoke$arity$1(coordinates),cljs.core.cst$kw$y.cljs$core$IFn$_invoke$arity$1(coordinates)], null);
} else {
return null;
}
}
});
c2.svg.translate = (function c2$svg$translate(coordinates){
var vec__42261 = c2.svg.__GT_xy(coordinates);
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42261,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42261,(1),null);
return [cljs.core.str("translate("),cljs.core.str(x),cljs.core.str(","),cljs.core.str(y),cljs.core.str(")")].join('');
});
c2.svg.scale = (function c2$svg$scale(coordinates){
if(typeof coordinates === 'number'){
return [cljs.core.str("scale("),cljs.core.str(coordinates),cljs.core.str(")")].join('');
} else {
var vec__42263 = c2.svg.__GT_xy(coordinates);
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42263,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42263,(1),null);
return [cljs.core.str("scale("),cljs.core.str(x),cljs.core.str(","),cljs.core.str(y),cljs.core.str(")")].join('');
}
});
c2.svg.rotate = (function c2$svg$rotate(var_args){
var args42264 = [];
var len__5627__auto___42268 = arguments.length;
var i__5628__auto___42269 = (0);
while(true){
if((i__5628__auto___42269 < len__5627__auto___42268)){
args42264.push((arguments[i__5628__auto___42269]));

var G__42270 = (i__5628__auto___42269 + (1));
i__5628__auto___42269 = G__42270;
continue;
} else {
}
break;
}

var G__42266 = args42264.length;
switch (G__42266) {
case 1:
return c2.svg.rotate.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.svg.rotate.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42264.length)].join('')));

}
});

c2.svg.rotate.cljs$core$IFn$_invoke$arity$1 = (function (angle){
return c2.svg.rotate.cljs$core$IFn$_invoke$arity$2(angle,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null));
});

c2.svg.rotate.cljs$core$IFn$_invoke$arity$2 = (function (angle,coordinates){
var vec__42267 = c2.svg.__GT_xy(coordinates);
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42267,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42267,(1),null);
return [cljs.core.str("rotate("),cljs.core.str(angle),cljs.core.str(","),cljs.core.str(x),cljs.core.str(","),cljs.core.str(y),cljs.core.str(")")].join('');
});

c2.svg.rotate.cljs$lang$maxFixedArity = 2;
/**
 * Returns map of `{:x :y :width :height}` containing SVG element bounding box.
 * All coordinates are in userspace. Ref [SVG spec](http://www.w3.org/TR/SVG/types.html#InterfaceSVGLocatable)
 */
c2.svg.get_bounds = (function c2$svg$get_bounds($svg_el){
var b = $svg_el.getBBox();
return new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$x,b.x,cljs.core.cst$kw$y,b.y,cljs.core.cst$kw$width,b.width,cljs.core.cst$kw$height,b.height], null);
});
/**
 * Returns a transform string that will scale and center provided element `{:width :height :x :y}` within container `{:width :height}`.
 */
c2.svg.transform_to_center = (function c2$svg$transform_to_center(element,container){
var map__42276 = element;
var map__42276__$1 = ((((!((map__42276 == null)))?((((map__42276.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42276.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42276):map__42276);
var ew = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42276__$1,cljs.core.cst$kw$width);
var eh = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42276__$1,cljs.core.cst$kw$height);
var x = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42276__$1,cljs.core.cst$kw$x);
var y = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42276__$1,cljs.core.cst$kw$y);
var map__42277 = container;
var map__42277__$1 = ((((!((map__42277 == null)))?((((map__42277.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42277.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42277):map__42277);
var w = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42277__$1,cljs.core.cst$kw$width);
var h = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42277__$1,cljs.core.cst$kw$height);
var s = (function (){var x__4907__auto__ = (h / eh);
var y__4908__auto__ = (w / ew);
return ((x__4907__auto__ < y__4908__auto__) ? x__4907__auto__ : y__4908__auto__);
})();
return [cljs.core.str(c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((w / (2)) - (s * (ew / (2)))),((h / (2)) - (s * (eh / (2))))], null))),cljs.core.str(" "),cljs.core.str(c2.svg.scale(s)),cljs.core.str(" "),cljs.core.str(c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(- x),(- y)], null)))].join('');
});
/**
 * Scales and centers `$svg-el` within its parent SVG container.
 * Uses parent's width and height attributes only.
 */
c2.svg.transform_to_center_BANG_ = (function c2$svg$transform_to_center_BANG_($svg_el){
var $svg = $svg_el.ownerSVGElement;
var t = c2.svg.transform_to_center(c2.svg.get_bounds($svg_el),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$width,(function (){var G__42282 = c2.dom.attr.cljs$core$IFn$_invoke$arity$2($svg,cljs.core.cst$kw$width);
return parseFloat(G__42282);
})(),cljs.core.cst$kw$height,(function (){var G__42283 = c2.dom.attr.cljs$core$IFn$_invoke$arity$2($svg,cljs.core.cst$kw$height);
return parseFloat(G__42283);
})()], null));
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3($svg_el,cljs.core.cst$kw$transform,t);
});
/**
 * Returns axis <g> hiccup vector for provided input `scale` and collection of `ticks` (numbers).
 * Direction away from the data frame is defined to be positive; use negative margins and widths to render axis inside of data frame.
 * 
 * Kwargs:
 * 
 * > *:orientation* &in; (`:top`, `:bottom`, `:left`, `:right`), where the axis should be relative to the data frame, defaults to `:left`
 * 
 * > *:formatter* fn run on tick values, defaults to `str`
 * 
 * > *:major-tick-width* width of ticks (minor ticks not yet implemented), defaults to 6
 * 
 * > *:text-margin* distance between axis and start of text, defaults to 9
 * 
 * > *:label* axis label, centered on axis; :left and :right orientation labels are rotated by +/- pi/2, respectively
 * 
 * > *:label-margin* distance between axis and label, defaults to 28
 */
c2.svg.axis = (function c2$svg$axis(var_args){
var args__5634__auto__ = [];
var len__5627__auto___42296 = arguments.length;
var i__5628__auto___42297 = (0);
while(true){
if((i__5628__auto___42297 < len__5627__auto___42296)){
args__5634__auto__.push((arguments[i__5628__auto___42297]));

var G__42298 = (i__5628__auto___42297 + (1));
i__5628__auto___42297 = G__42298;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return c2.svg.axis.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

c2.svg.axis.cljs$core$IFn$_invoke$arity$variadic = (function (scale,ticks,p__42287){
var map__42288 = p__42287;
var map__42288__$1 = ((((!((map__42288 == null)))?((((map__42288.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42288.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42288):map__42288);
var orientation = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__42288__$1,cljs.core.cst$kw$orientation,cljs.core.cst$kw$left);
var formatter = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__42288__$1,cljs.core.cst$kw$formatter,cljs.core.str);
var major_tick_width = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__42288__$1,cljs.core.cst$kw$major_DASH_tick_DASH_width,(6));
var text_margin = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__42288__$1,cljs.core.cst$kw$text_DASH_margin,(9));
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42288__$1,cljs.core.cst$kw$label);
var label_margin = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__42288__$1,cljs.core.cst$kw$label_DASH_margin,(28));
var vec__42290 = (function (){var G__42291 = (((orientation instanceof cljs.core.Keyword))?orientation.fqn:null);
switch (G__42291) {
case "left":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$x,cljs.core.cst$kw$y,cljs.core.cst$kw$x1,cljs.core.cst$kw$x2,cljs.core.cst$kw$y1,cljs.core.cst$kw$y2], null);

break;
case "right":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$x,cljs.core.cst$kw$y,cljs.core.cst$kw$x1,cljs.core.cst$kw$x2,cljs.core.cst$kw$y1,cljs.core.cst$kw$y2], null);

break;
case "top":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$y,cljs.core.cst$kw$x,cljs.core.cst$kw$y1,cljs.core.cst$kw$y2,cljs.core.cst$kw$x1,cljs.core.cst$kw$x2], null);

break;
case "bottom":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$y,cljs.core.cst$kw$x,cljs.core.cst$kw$y1,cljs.core.cst$kw$y2,cljs.core.cst$kw$x1,cljs.core.cst$kw$x2], null);

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(orientation)].join('')));

}
})();
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42290,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42290,(1),null);
var x1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42290,(2),null);
var x2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42290,(3),null);
var y1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42290,(4),null);
var y2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42290,(5),null);
var parity = (function (){var G__42292 = (((orientation instanceof cljs.core.Keyword))?orientation.fqn:null);
switch (G__42292) {
case "left":
return (-1);

break;
case "top":
return (-1);

break;
case "right":
return (1);

break;
case "bottom":
return (1);

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(orientation)].join('')));

}
})();
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,[cljs.core.str("axis "),cljs.core.str(cljs.core.name(orientation))].join('')], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$line$rule,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [y1,y2], null),cljs.core.cst$kw$range.cljs$core$IFn$_invoke$arity$1(scale)))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$ticks,c2.core.unify(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,ticks,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(scale)),((function (vec__42290,x,y,x1,x2,y1,y2,parity,map__42288,map__42288__$1,orientation,formatter,major_tick_width,text_margin,label,label_margin){
return (function (p__42293){
var vec__42294 = p__42293;
var d = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42294,(0),null);
var scale__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42294,(1),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$tick$major_DASH_tick,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(cljs.core.PersistentArrayMap.fromArray([x,(0),y,(scale__$1.cljs$core$IFn$_invoke$arity$1 ? scale__$1.cljs$core$IFn$_invoke$arity$1(d) : scale__$1.call(null,d))], true, false))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$text,cljs.core.PersistentArrayMap.fromArray([x,(parity * text_margin)], true, false),(formatter.cljs$core$IFn$_invoke$arity$1 ? formatter.cljs$core$IFn$_invoke$arity$1(d) : formatter.call(null,d))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$line,cljs.core.PersistentArrayMap.fromArray([x1,(0),x2,(parity * major_tick_width)], true, false)], null)], null);
});})(vec__42290,x,y,x1,x2,y1,y2,parity,map__42288,map__42288__$1,orientation,formatter,major_tick_width,text_margin,label,label_margin))
)], null),(cljs.core.truth_(label)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$text$label,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,[cljs.core.str(c2.svg.translate(cljs.core.PersistentArrayMap.fromArray([x,(parity * label_margin),y,c2.maths.mean(cljs.core.cst$kw$range.cljs$core$IFn$_invoke$arity$1(scale))], true, false))),cljs.core.str(" "),cljs.core.str((function (){var G__42295 = (((orientation instanceof cljs.core.Keyword))?orientation.fqn:null);
switch (G__42295) {
case "left":
return c2.svg.rotate.cljs$core$IFn$_invoke$arity$1((-90));

break;
case "right":
return c2.svg.rotate.cljs$core$IFn$_invoke$arity$1((90));

break;
default:
return "";

}
})())].join('')], null),label], null):null)], null);
});

c2.svg.axis.cljs$lang$maxFixedArity = (2);

c2.svg.axis.cljs$lang$applyTo = (function (seq42284){
var G__42285 = cljs.core.first(seq42284);
var seq42284__$1 = cljs.core.next(seq42284);
var G__42286 = cljs.core.first(seq42284__$1);
var seq42284__$2 = cljs.core.next(seq42284__$1);
return c2.svg.axis.cljs$core$IFn$_invoke$arity$variadic(G__42285,G__42286,seq42284__$2);
});
c2.svg.ArcMax = (c2.maths.Tau - 1.0E-7);
/**
 * Calculate SVG path data for a circle of `radius` starting at 3 o'clock and sweeping in positive y.
 */
c2.svg.circle = (function c2$svg$circle(var_args){
var args42302 = [];
var len__5627__auto___42306 = arguments.length;
var i__5628__auto___42307 = (0);
while(true){
if((i__5628__auto___42307 < len__5627__auto___42306)){
args42302.push((arguments[i__5628__auto___42307]));

var G__42308 = (i__5628__auto___42307 + (1));
i__5628__auto___42307 = G__42308;
continue;
} else {
}
break;
}

var G__42304 = args42302.length;
switch (G__42304) {
case 1:
return c2.svg.circle.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.svg.circle.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42302.length)].join('')));

}
});

c2.svg.circle.cljs$core$IFn$_invoke$arity$1 = (function (radius){
return c2.svg.circle.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),radius);
});

c2.svg.circle.cljs$core$IFn$_invoke$arity$2 = (function (coordinates,radius){
var vec__42305 = c2.svg.__GT_xy(coordinates);
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42305,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42305,(1),null);
return [cljs.core.str("M"),cljs.core.str((x + radius)),cljs.core.str(","),cljs.core.str(y),cljs.core.str("A"),cljs.core.str((x + radius)),cljs.core.str(","),cljs.core.str((y + radius)),cljs.core.str(" 0 1,1"),cljs.core.str((- (x + radius))),cljs.core.str(","),cljs.core.str(y),cljs.core.str("A"),cljs.core.str((x + radius)),cljs.core.str(","),cljs.core.str((y + radius)),cljs.core.str(" 0 1,1"),cljs.core.str((x + radius)),cljs.core.str(","),cljs.core.str(y)].join('');
});

c2.svg.circle.cljs$lang$maxFixedArity = 2;
/**
 * Calculate SVG path data for an arc.
 */
c2.svg.arc = (function c2$svg$arc(var_args){
var args__5634__auto__ = [];
var len__5627__auto___42315 = arguments.length;
var i__5628__auto___42316 = (0);
while(true){
if((i__5628__auto___42316 < len__5627__auto___42315)){
args__5634__auto__.push((arguments[i__5628__auto___42316]));

var G__42317 = (i__5628__auto___42316 + (1));
i__5628__auto___42316 = G__42317;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return c2.svg.arc.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

c2.svg.arc.cljs$core$IFn$_invoke$arity$variadic = (function (p__42311){
var map__42312 = p__42311;
var map__42312__$1 = ((((!((map__42312 == null)))?((((map__42312.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42312.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42312):map__42312);
var inner_radius = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__42312__$1,cljs.core.cst$kw$inner_DASH_radius,(0));
var outer_radius = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__42312__$1,cljs.core.cst$kw$outer_DASH_radius,(1));
var start_angle = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__42312__$1,cljs.core.cst$kw$start_DASH_angle,(0));
var end_angle = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__42312__$1,cljs.core.cst$kw$end_DASH_angle,c2.maths.Pi);
var angle_offset = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__42312__$1,cljs.core.cst$kw$angle_DASH_offset,(0));
var r0 = inner_radius;
var r1 = outer_radius;
var vec__42314 = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(angle_offset + start_angle),(angle_offset + end_angle)], null));
var a0 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42314,(0),null);
var a1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42314,(1),null);
var da = (a1 - a0);
var large_arc_flag = (((da < c2.maths.Pi))?"0":"1");
var s0 = c2.maths.sin(a0);
var c0 = c2.maths.cos(a0);
var s1 = c2.maths.sin(a1);
var c1 = c2.maths.cos(a1);
if((da >= c2.svg.ArcMax)){
return [cljs.core.str("M0,"),cljs.core.str(r1),cljs.core.str("A"),cljs.core.str(r1),cljs.core.str(","),cljs.core.str(r1),cljs.core.str(" 0 1,1 0,"),cljs.core.str((- r1)),cljs.core.str("A"),cljs.core.str(r1),cljs.core.str(","),cljs.core.str(r1),cljs.core.str(" 0 1,1 0,"),cljs.core.str(r1),cljs.core.str(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),r0))?[cljs.core.str("M0,"),cljs.core.str(r0),cljs.core.str("A"),cljs.core.str(r0),cljs.core.str(","),cljs.core.str(r0),cljs.core.str(" 0 1,0 0,"),cljs.core.str((- r0)),cljs.core.str("A"),cljs.core.str(r0),cljs.core.str(","),cljs.core.str(r0),cljs.core.str(" 0 1,0 0,"),cljs.core.str(r0)].join(''):null)),cljs.core.str("Z")].join('');
} else {
return [cljs.core.str("M"),cljs.core.str((r1 * c0)),cljs.core.str(","),cljs.core.str((r1 * s0)),cljs.core.str("A"),cljs.core.str(r1),cljs.core.str(","),cljs.core.str(r1),cljs.core.str(" 0 "),cljs.core.str(large_arc_flag),cljs.core.str(",1 "),cljs.core.str((r1 * c1)),cljs.core.str(","),cljs.core.str((r1 * s1)),cljs.core.str(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),r0))?[cljs.core.str("L"),cljs.core.str((r0 * c1)),cljs.core.str(","),cljs.core.str((r0 * s1)),cljs.core.str("A"),cljs.core.str(r0),cljs.core.str(","),cljs.core.str(r0),cljs.core.str(" 0 "),cljs.core.str(large_arc_flag),cljs.core.str(",0 "),cljs.core.str((r0 * c0)),cljs.core.str(","),cljs.core.str((r0 * s0))].join(''):"L0,0")),cljs.core.str("Z")].join('');
}
});

c2.svg.arc.cljs$lang$maxFixedArity = (0);

c2.svg.arc.cljs$lang$applyTo = (function (seq42310){
return c2.svg.arc.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42310));
});
