// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('c2.dom');
goog.require('cljs.core');
goog.require('goog.dom.forms');
goog.require('goog.dom');
goog.require('goog.dom.classes');
goog.require('singult.core');
goog.require('goog.style');
goog.require('clojure.string');
Element.prototype.matchesSelector = Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || Element.prototype.oMatchesSelector;
if(cljs.core.truth_(typeof NodeList != "undefined")){
NodeList.prototype.cljs$core$ISeqable$ = true;

NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(array__$1,(0));
});
} else {
}
HTMLCollection.prototype.cljs$core$ISeqable$ = true;

HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(array__$1,(0));
});
c2.dom.select;

/**
 * @interface
 */
c2.dom.IDom = function(){};

/**
 * Converts x to a live DOM node
 */
c2.dom.__GT_dom = (function c2$dom$__GT_dom(x){
if((!((x == null))) && (!((x.c2$dom$IDom$__GT_dom$arity$1 == null)))){
return x.c2$dom$IDom$__GT_dom$arity$1(x);
} else {
var x__5224__auto__ = (((x == null))?null:x);
var m__5225__auto__ = (c2.dom.__GT_dom[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__5225__auto__.call(null,x));
} else {
var m__5225__auto____$1 = (c2.dom.__GT_dom["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__5225__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("IDom.->dom",x);
}
}
}
});

(c2.dom.IDom["string"] = true);

(c2.dom.__GT_dom["string"] = (function (selector){
return (c2.dom.select.cljs$core$IFn$_invoke$arity$1 ? c2.dom.select.cljs$core$IFn$_invoke$arity$1(selector) : c2.dom.select.call(null,selector));
}));

cljs.core.PersistentVector.prototype.c2$dom$IDom$ = true;

cljs.core.PersistentVector.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (v){
var v__$1 = this;
return singult.core.render(v__$1);
});
if(cljs.core.truth_(typeof Node != "undefined")){
Node.prototype.c2$dom$IDom$ = true;

Node.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (node){
var node__$1 = this;
return node__$1;
});
} else {
}
/**
 * Select a single DOM node via CSS selector, optionally scoped by second arg.
 */
c2.dom.select = (function c2$dom$select(var_args){
var args42617 = [];
var len__5627__auto___42620 = arguments.length;
var i__5628__auto___42621 = (0);
while(true){
if((i__5628__auto___42621 < len__5627__auto___42620)){
args42617.push((arguments[i__5628__auto___42621]));

var G__42622 = (i__5628__auto___42621 + (1));
i__5628__auto___42621 = G__42622;
continue;
} else {
}
break;
}

var G__42619 = args42617.length;
switch (G__42619) {
case 1:
return c2.dom.select.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42617.length)].join('')));

}
});

c2.dom.select.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelector(selector);
});

c2.dom.select.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom(container).querySelector(selector);
});

c2.dom.select.cljs$lang$maxFixedArity = 2;
/**
 * Like select, but returns a collection of nodes.
 */
c2.dom.select_all = (function c2$dom$select_all(var_args){
var args42624 = [];
var len__5627__auto___42627 = arguments.length;
var i__5628__auto___42628 = (0);
while(true){
if((i__5628__auto___42628 < len__5627__auto___42627)){
args42624.push((arguments[i__5628__auto___42628]));

var G__42629 = (i__5628__auto___42628 + (1));
i__5628__auto___42628 = G__42629;
continue;
} else {
}
break;
}

var G__42626 = args42624.length;
switch (G__42626) {
case 1:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42624.length)].join('')));

}
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelectorAll(selector);
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom(container).querySelectorAll(selector);
});

c2.dom.select_all.cljs$lang$maxFixedArity = 2;
/**
 * Does live `node` match CSS `selector`?
 */
c2.dom.matches_selector_QMARK_ = (function c2$dom$matches_selector_QMARK_(node,selector){
if(cljs.core.truth_(node)){
return node.matchesSelector(selector);
} else {
return null;
}
});
/**
 * Return the children of a live DOM element.
 */
c2.dom.children = (function c2$dom$children(node){
if(cljs.core.truth_(node)){
return c2.dom.__GT_dom(node).children;
} else {
return null;
}
});
/**
 * Return parent of a live DOM node.
 */
c2.dom.parent = (function c2$dom$parent(node){
if(cljs.core.truth_(c2$dom$parent)){
return c2.dom.__GT_dom(node).parentNode;
} else {
return null;
}
});
/**
 * Make element last child of container.
 * Returns live child.
 */
c2.dom.append_BANG_ = (function c2$dom$append_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom(el);
var G__42633_42635 = c2.dom.__GT_dom(container);
var G__42634_42636 = el__$1;
goog.dom.appendChild(G__42633_42635,G__42634_42636);

return el__$1;
});
/**
 * Make element first child of container.
 * Returns live DOM child.
 */
c2.dom.prepend_BANG_ = (function c2$dom$prepend_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom(el);
var G__42640_42643 = c2.dom.__GT_dom(container);
var G__42641_42644 = el__$1;
var G__42642_42645 = (0);
goog.dom.insertChildAt(G__42640_42643,G__42641_42644,G__42642_42645);

return el__$1;
});
/**
 * Remove element from DOM and return it.
 * > *el* CSS selector or live DOM node
 */
c2.dom.remove_BANG_ = (function c2$dom$remove_BANG_(el){
var G__42647 = c2.dom.__GT_dom(el);
return goog.dom.removeNode(G__42647);
});
/**
 * Replace live DOM node with a new one, returning the latter.
 * > *old* CSS selector or live DOM node
 * > *new* CSS selector, live DOM node, or hiccup vector
 */
c2.dom.replace_BANG_ = (function c2$dom$replace_BANG_(old,new$){
var new$__$1 = c2.dom.__GT_dom(new$);
var G__42650_42652 = new$__$1;
var G__42651_42653 = c2.dom.__GT_dom(old);
goog.dom.replaceNode(G__42650_42652,G__42651_42653);

return new$__$1;
});
/**
 * Get or set inline element style.
 * 
 * `(style el)`                map of inline element styles
 * 
 * `(style el :keyword)`       value of style :keyword
 * 
 * `(style el {:keyword val})` sets inline style according to map, returns element
 * 
 * `(style el :keyword val)`   sets single style, returns element
 */
c2.dom.style = (function c2$dom$style(var_args){
var args42654 = [];
var len__5627__auto___42668 = arguments.length;
var i__5628__auto___42669 = (0);
while(true){
if((i__5628__auto___42669 < len__5627__auto___42668)){
args42654.push((arguments[i__5628__auto___42669]));

var G__42670 = (i__5628__auto___42669 + (1));
i__5628__auto___42669 = G__42670;
continue;
} else {
}
break;
}

var G__42656 = args42654.length;
switch (G__42656) {
case 1:
return c2.dom.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.style.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42654.length)].join('')));

}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$1 = (function (el){
throw (new Error("TODO: return map of element styles"));
});

c2.dom.style.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom(el);
if((x instanceof cljs.core.Keyword)){
var G__42657 = el__$1;
var G__42658 = cljs.core.name(x);
return goog.style.getComputedStyle(G__42657,G__42658);
} else {
if(cljs.core.map_QMARK_(x)){
var seq__42659_42672 = cljs.core.seq(x);
var chunk__42660_42673 = null;
var count__42661_42674 = (0);
var i__42662_42675 = (0);
while(true){
if((i__42662_42675 < count__42661_42674)){
var vec__42663_42676 = chunk__42660_42673.cljs$core$IIndexed$_nth$arity$2(null,i__42662_42675);
var k_42677 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42663_42676,(0),null);
var v_42678 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42663_42676,(1),null);
c2.dom.style.cljs$core$IFn$_invoke$arity$3(el__$1,k_42677,v_42678);

var G__42679 = seq__42659_42672;
var G__42680 = chunk__42660_42673;
var G__42681 = count__42661_42674;
var G__42682 = (i__42662_42675 + (1));
seq__42659_42672 = G__42679;
chunk__42660_42673 = G__42680;
count__42661_42674 = G__42681;
i__42662_42675 = G__42682;
continue;
} else {
var temp__4425__auto___42683 = cljs.core.seq(seq__42659_42672);
if(temp__4425__auto___42683){
var seq__42659_42684__$1 = temp__4425__auto___42683;
if(cljs.core.chunked_seq_QMARK_(seq__42659_42684__$1)){
var c__5372__auto___42685 = cljs.core.chunk_first(seq__42659_42684__$1);
var G__42686 = cljs.core.chunk_rest(seq__42659_42684__$1);
var G__42687 = c__5372__auto___42685;
var G__42688 = cljs.core.count(c__5372__auto___42685);
var G__42689 = (0);
seq__42659_42672 = G__42686;
chunk__42660_42673 = G__42687;
count__42661_42674 = G__42688;
i__42662_42675 = G__42689;
continue;
} else {
var vec__42664_42690 = cljs.core.first(seq__42659_42684__$1);
var k_42691 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42664_42690,(0),null);
var v_42692 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42664_42690,(1),null);
c2.dom.style.cljs$core$IFn$_invoke$arity$3(el__$1,k_42691,v_42692);

var G__42693 = cljs.core.next(seq__42659_42684__$1);
var G__42694 = null;
var G__42695 = (0);
var G__42696 = (0);
seq__42659_42672 = G__42693;
chunk__42660_42673 = G__42694;
count__42661_42674 = G__42695;
i__42662_42675 = G__42696;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var G__42665_42697 = c2.dom.__GT_dom(el);
var G__42666_42698 = cljs.core.name(k);
var G__42667_42699 = ((typeof v === 'string')?v:((typeof v === 'number')?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$bottom,null,cljs.core.cst$kw$top,null,cljs.core.cst$kw$width,null,cljs.core.cst$kw$right,null,cljs.core.cst$kw$height,null,cljs.core.cst$kw$left,null], null), null).call(null,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k)))?[cljs.core.str(v),cljs.core.str("px")].join(''):v):null));
goog.style.setStyle(G__42665_42697,G__42666_42698,G__42667_42699);

return el;
});

c2.dom.style.cljs$lang$maxFixedArity = 3;
/**
 * Get or set element attributes.
 * 
 * `(attr el)`                map of element attributes
 * 
 * `(attr el :keyword)`       value of attr :keyword
 * 
 * `(attr el {:keyword val})` sets element attributes according to map, returns element
 * 
 * `(attr el :keyword val)`   sets single attr, returns element
 */
c2.dom.attr = (function c2$dom$attr(var_args){
var args42700 = [];
var len__5627__auto___42715 = arguments.length;
var i__5628__auto___42716 = (0);
while(true){
if((i__5628__auto___42716 < len__5627__auto___42715)){
args42700.push((arguments[i__5628__auto___42716]));

var G__42717 = (i__5628__auto___42716 + (1));
i__5628__auto___42716 = G__42717;
continue;
} else {
}
break;
}

var G__42702 = args42700.length;
switch (G__42702) {
case 1:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42700.length)].join('')));

}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$1 = (function (el){
var attrs = c2.dom.__GT_dom(el).attributes;
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5341__auto__ = ((function (attrs){
return (function c2$dom$iter__42703(s__42704){
return (new cljs.core.LazySeq(null,((function (attrs){
return (function (){
var s__42704__$1 = s__42704;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__42704__$1);
if(temp__4425__auto__){
var s__42704__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__42704__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__42704__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__42706 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__42705 = (0);
while(true){
if((i__42705 < size__5340__auto__)){
var i = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__42705);
cljs.core.chunk_append(b__42706,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((attrs[i]).name),(attrs[i]).value], null));

var G__42719 = (i__42705 + (1));
i__42705 = G__42719;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__42706),c2$dom$iter__42703(cljs.core.chunk_rest(s__42704__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__42706),null);
}
} else {
var i = cljs.core.first(s__42704__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((attrs[i]).name),(attrs[i]).value], null),c2$dom$iter__42703(cljs.core.rest(s__42704__$2)));
}
} else {
return null;
}
break;
}
});})(attrs))
,null,null));
});})(attrs))
;
return iter__5341__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(attrs.length));
})());
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom(el);
if((x instanceof cljs.core.Keyword)){
return el__$1.getAttribute(cljs.core.name(x));
} else {
if(cljs.core.map_QMARK_(x)){
var seq__42709_42720 = cljs.core.seq(x);
var chunk__42710_42721 = null;
var count__42711_42722 = (0);
var i__42712_42723 = (0);
while(true){
if((i__42712_42723 < count__42711_42722)){
var vec__42713_42724 = chunk__42710_42721.cljs$core$IIndexed$_nth$arity$2(null,i__42712_42723);
var k_42725 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42713_42724,(0),null);
var v_42726 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42713_42724,(1),null);
c2.dom.attr.cljs$core$IFn$_invoke$arity$3(el__$1,k_42725,v_42726);

var G__42727 = seq__42709_42720;
var G__42728 = chunk__42710_42721;
var G__42729 = count__42711_42722;
var G__42730 = (i__42712_42723 + (1));
seq__42709_42720 = G__42727;
chunk__42710_42721 = G__42728;
count__42711_42722 = G__42729;
i__42712_42723 = G__42730;
continue;
} else {
var temp__4425__auto___42731 = cljs.core.seq(seq__42709_42720);
if(temp__4425__auto___42731){
var seq__42709_42732__$1 = temp__4425__auto___42731;
if(cljs.core.chunked_seq_QMARK_(seq__42709_42732__$1)){
var c__5372__auto___42733 = cljs.core.chunk_first(seq__42709_42732__$1);
var G__42734 = cljs.core.chunk_rest(seq__42709_42732__$1);
var G__42735 = c__5372__auto___42733;
var G__42736 = cljs.core.count(c__5372__auto___42733);
var G__42737 = (0);
seq__42709_42720 = G__42734;
chunk__42710_42721 = G__42735;
count__42711_42722 = G__42736;
i__42712_42723 = G__42737;
continue;
} else {
var vec__42714_42738 = cljs.core.first(seq__42709_42732__$1);
var k_42739 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42714_42738,(0),null);
var v_42740 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42714_42738,(1),null);
c2.dom.attr.cljs$core$IFn$_invoke$arity$3(el__$1,k_42739,v_42740);

var G__42741 = cljs.core.next(seq__42709_42732__$1);
var G__42742 = null;
var G__42743 = (0);
var G__42744 = (0);
seq__42709_42720 = G__42741;
chunk__42710_42721 = G__42742;
count__42711_42722 = G__42743;
i__42712_42723 = G__42744;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var el__$1 = c2.dom.__GT_dom(el);
if((v == null)){
el__$1.removeAttribute(cljs.core.name(k));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$style,k)){
c2.dom.style.cljs$core$IFn$_invoke$arity$2(el__$1,v);
} else {
el__$1.setAttribute(cljs.core.name(k),v);
}
}

return el__$1;
});

c2.dom.attr.cljs$lang$maxFixedArity = 3;
/**
 * Get or set element text, returning element
 */
c2.dom.text = (function c2$dom$text(var_args){
var args42745 = [];
var len__5627__auto___42749 = arguments.length;
var i__5628__auto___42750 = (0);
while(true){
if((i__5628__auto___42750 < len__5627__auto___42749)){
args42745.push((arguments[i__5628__auto___42750]));

var G__42751 = (i__5628__auto___42750 + (1));
i__5628__auto___42750 = G__42751;
continue;
} else {
}
break;
}

var G__42747 = args42745.length;
switch (G__42747) {
case 1:
return c2.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42745.length)].join('')));

}
});

c2.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__42748 = c2.dom.__GT_dom(el);
return goog.dom.getTextContent(G__42748);
});

c2.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom(el);
goog.dom.setTextContent(el__$1,v);

return el__$1;
});

c2.dom.text.cljs$lang$maxFixedArity = 2;
/**
 * Get or set element value.
 */
c2.dom.val = (function c2$dom$val(var_args){
var args42753 = [];
var len__5627__auto___42757 = arguments.length;
var i__5628__auto___42758 = (0);
while(true){
if((i__5628__auto___42758 < len__5627__auto___42757)){
args42753.push((arguments[i__5628__auto___42758]));

var G__42759 = (i__5628__auto___42758 + (1));
i__5628__auto___42758 = G__42759;
continue;
} else {
}
break;
}

var G__42755 = args42753.length;
switch (G__42755) {
case 1:
return c2.dom.val.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.val.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42753.length)].join('')));

}
});

c2.dom.val.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__42756 = c2.dom.__GT_dom(el);
return goog.dom.forms.getValue(G__42756);
});

c2.dom.val.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom(el);
goog.dom.forms.setValue(el__$1,v);

return el__$1;
});

c2.dom.val.cljs$lang$maxFixedArity = 2;
/**
 * Add or remove `class` to element based on boolean `classed?`, returning element.
 */
c2.dom.classed_BANG_ = (function c2$dom$classed_BANG_(el,class$,classed_QMARK_){
var G__42764_42767 = c2.dom.__GT_dom(el);
var G__42765_42768 = cljs.core.name(class$);
var G__42766_42769 = classed_QMARK_;
goog.dom.classes.enable(G__42764_42767,G__42765_42768,G__42766_42769);

return el;
});
c2.dom.add_class_BANG_ = (function c2$dom$add_class_BANG_(el,class$){
return c2.dom.classed_BANG_(el,class$,true);
});
c2.dom.remove_class_BANG_ = (function c2$dom$remove_class_BANG_(el,class$){
return c2.dom.classed_BANG_(el,class$,false);
});
c2.dom.request_animation_frame = (function (){var or__4569__auto__ = window.requestAnimationFrame;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
var or__4569__auto____$1 = window.webkitRequestAnimationFrame;
if(cljs.core.truth_(or__4569__auto____$1)){
return or__4569__auto____$1;
} else {
return ((function (or__4569__auto____$1,or__4569__auto__){
return (function (p1__42770_SHARP_){
var G__42771 = ((function (or__4569__auto____$1,or__4569__auto__){
return (function (){
return (p1__42770_SHARP_.cljs$core$IFn$_invoke$arity$0 ? p1__42770_SHARP_.cljs$core$IFn$_invoke$arity$0() : p1__42770_SHARP_.call(null));
});})(or__4569__auto____$1,or__4569__auto__))
;
var G__42772 = (10);
return setTimeout(G__42771,G__42772);
});
;})(or__4569__auto____$1,or__4569__auto__))
}
}
})();
