// Compiled by ClojureScript 1.8.51 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args27127 = [];
var len__7280__auto___27133 = arguments.length;
var i__7281__auto___27134 = (0);
while(true){
if((i__7281__auto___27134 < len__7280__auto___27133)){
args27127.push((arguments[i__7281__auto___27134]));

var G__27135 = (i__7281__auto___27134 + (1));
i__7281__auto___27134 = G__27135;
continue;
} else {
}
break;
}

var G__27129 = args27127.length;
switch (G__27129) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27127.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async27130 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27130 = (function (f,blockable,meta27131){
this.f = f;
this.blockable = blockable;
this.meta27131 = meta27131;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async27130.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27132,meta27131__$1){
var self__ = this;
var _27132__$1 = this;
return (new cljs.core.async.t_cljs$core$async27130(self__.f,self__.blockable,meta27131__$1));
});

cljs.core.async.t_cljs$core$async27130.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27132){
var self__ = this;
var _27132__$1 = this;
return self__.meta27131;
});

cljs.core.async.t_cljs$core$async27130.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async27130.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async27130.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async27130.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async27130.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta27131], null);
});

cljs.core.async.t_cljs$core$async27130.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async27130.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27130";

cljs.core.async.t_cljs$core$async27130.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"cljs.core.async/t_cljs$core$async27130");
});

cljs.core.async.__GT_t_cljs$core$async27130 = (function cljs$core$async$__GT_t_cljs$core$async27130(f__$1,blockable__$1,meta27131){
return (new cljs.core.async.t_cljs$core$async27130(f__$1,blockable__$1,meta27131));
});

}

return (new cljs.core.async.t_cljs$core$async27130(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args27139 = [];
var len__7280__auto___27142 = arguments.length;
var i__7281__auto___27143 = (0);
while(true){
if((i__7281__auto___27143 < len__7280__auto___27142)){
args27139.push((arguments[i__7281__auto___27143]));

var G__27144 = (i__7281__auto___27143 + (1));
i__7281__auto___27143 = G__27144;
continue;
} else {
}
break;
}

var G__27141 = args27139.length;
switch (G__27141) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27139.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args27146 = [];
var len__7280__auto___27149 = arguments.length;
var i__7281__auto___27150 = (0);
while(true){
if((i__7281__auto___27150 < len__7280__auto___27149)){
args27146.push((arguments[i__7281__auto___27150]));

var G__27151 = (i__7281__auto___27150 + (1));
i__7281__auto___27150 = G__27151;
continue;
} else {
}
break;
}

var G__27148 = args27146.length;
switch (G__27148) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27146.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args27153 = [];
var len__7280__auto___27156 = arguments.length;
var i__7281__auto___27157 = (0);
while(true){
if((i__7281__auto___27157 < len__7280__auto___27156)){
args27153.push((arguments[i__7281__auto___27157]));

var G__27158 = (i__7281__auto___27157 + (1));
i__7281__auto___27157 = G__27158;
continue;
} else {
}
break;
}

var G__27155 = args27153.length;
switch (G__27155) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27153.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_27160 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_27160) : fn1.call(null,val_27160));
} else {
cljs.core.async.impl.dispatch.run(((function (val_27160,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_27160) : fn1.call(null,val_27160));
});})(val_27160,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args27161 = [];
var len__7280__auto___27164 = arguments.length;
var i__7281__auto___27165 = (0);
while(true){
if((i__7281__auto___27165 < len__7280__auto___27164)){
args27161.push((arguments[i__7281__auto___27165]));

var G__27166 = (i__7281__auto___27165 + (1));
i__7281__auto___27165 = G__27166;
continue;
} else {
}
break;
}

var G__27163 = args27161.length;
switch (G__27163) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27161.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4655__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7125__auto___27168 = n;
var x_27169 = (0);
while(true){
if((x_27169 < n__7125__auto___27168)){
(a[x_27169] = (0));

var G__27170 = (x_27169 + (1));
x_27169 = G__27170;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__27171 = (i + (1));
i = G__27171;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async27175 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27175 = (function (alt_flag,flag,meta27176){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta27176 = meta27176;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async27175.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_27177,meta27176__$1){
var self__ = this;
var _27177__$1 = this;
return (new cljs.core.async.t_cljs$core$async27175(self__.alt_flag,self__.flag,meta27176__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async27175.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_27177){
var self__ = this;
var _27177__$1 = this;
return self__.meta27176;
});})(flag))
;

cljs.core.async.t_cljs$core$async27175.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async27175.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async27175.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async27175.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async27175.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_flag,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$meta27176], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async27175.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async27175.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27175";

cljs.core.async.t_cljs$core$async27175.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"cljs.core.async/t_cljs$core$async27175");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async27175 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async27175(alt_flag__$1,flag__$1,meta27176){
return (new cljs.core.async.t_cljs$core$async27175(alt_flag__$1,flag__$1,meta27176));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async27175(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async27181 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27181 = (function (alt_handler,flag,cb,meta27182){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta27182 = meta27182;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async27181.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27183,meta27182__$1){
var self__ = this;
var _27183__$1 = this;
return (new cljs.core.async.t_cljs$core$async27181(self__.alt_handler,self__.flag,self__.cb,meta27182__$1));
});

cljs.core.async.t_cljs$core$async27181.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27183){
var self__ = this;
var _27183__$1 = this;
return self__.meta27182;
});

cljs.core.async.t_cljs$core$async27181.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async27181.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async27181.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async27181.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async27181.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_handler,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb], null)))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta27182], null);
});

cljs.core.async.t_cljs$core$async27181.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async27181.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27181";

cljs.core.async.t_cljs$core$async27181.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"cljs.core.async/t_cljs$core$async27181");
});

cljs.core.async.__GT_t_cljs$core$async27181 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async27181(alt_handler__$1,flag__$1,cb__$1,meta27182){
return (new cljs.core.async.t_cljs$core$async27181(alt_handler__$1,flag__$1,cb__$1,meta27182));
});

}

return (new cljs.core.async.t_cljs$core$async27181(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__27184_SHARP_){
var G__27188 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__27184_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__27188) : fret.call(null,G__27188));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__27185_SHARP_){
var G__27189 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__27185_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__27189) : fret.call(null,G__27189));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__6210__auto__ = wport;
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
return port;
}
})()], null));
} else {
var G__27190 = (i + (1));
i = G__27190;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6210__auto__ = ret;
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__4657__auto__ = (function (){var and__6198__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__6198__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__6198__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7287__auto__ = [];
var len__7280__auto___27196 = arguments.length;
var i__7281__auto___27197 = (0);
while(true){
if((i__7281__auto___27197 < len__7280__auto___27196)){
args__7287__auto__.push((arguments[i__7281__auto___27197]));

var G__27198 = (i__7281__auto___27197 + (1));
i__7281__auto___27197 = G__27198;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__27193){
var map__27194 = p__27193;
var map__27194__$1 = ((((!((map__27194 == null)))?((((map__27194.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27194.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27194):map__27194);
var opts = map__27194__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq27191){
var G__27192 = cljs.core.first(seq27191);
var seq27191__$1 = cljs.core.next(seq27191);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__27192,seq27191__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args27199 = [];
var len__7280__auto___27249 = arguments.length;
var i__7281__auto___27250 = (0);
while(true){
if((i__7281__auto___27250 < len__7280__auto___27249)){
args27199.push((arguments[i__7281__auto___27250]));

var G__27251 = (i__7281__auto___27250 + (1));
i__7281__auto___27250 = G__27251;
continue;
} else {
}
break;
}

var G__27201 = args27199.length;
switch (G__27201) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27199.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11856__auto___27253 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11856__auto___27253){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___27253){
return (function (state_27225){
var state_val_27226 = (state_27225[(1)]);
if((state_val_27226 === (7))){
var inst_27221 = (state_27225[(2)]);
var state_27225__$1 = state_27225;
var statearr_27227_27254 = state_27225__$1;
(statearr_27227_27254[(2)] = inst_27221);

(statearr_27227_27254[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27226 === (1))){
var state_27225__$1 = state_27225;
var statearr_27228_27255 = state_27225__$1;
(statearr_27228_27255[(2)] = null);

(statearr_27228_27255[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27226 === (4))){
var inst_27204 = (state_27225[(7)]);
var inst_27204__$1 = (state_27225[(2)]);
var inst_27205 = (inst_27204__$1 == null);
var state_27225__$1 = (function (){var statearr_27229 = state_27225;
(statearr_27229[(7)] = inst_27204__$1);

return statearr_27229;
})();
if(cljs.core.truth_(inst_27205)){
var statearr_27230_27256 = state_27225__$1;
(statearr_27230_27256[(1)] = (5));

} else {
var statearr_27231_27257 = state_27225__$1;
(statearr_27231_27257[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27226 === (13))){
var state_27225__$1 = state_27225;
var statearr_27232_27258 = state_27225__$1;
(statearr_27232_27258[(2)] = null);

(statearr_27232_27258[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27226 === (6))){
var inst_27204 = (state_27225[(7)]);
var state_27225__$1 = state_27225;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27225__$1,(11),to,inst_27204);
} else {
if((state_val_27226 === (3))){
var inst_27223 = (state_27225[(2)]);
var state_27225__$1 = state_27225;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27225__$1,inst_27223);
} else {
if((state_val_27226 === (12))){
var state_27225__$1 = state_27225;
var statearr_27233_27259 = state_27225__$1;
(statearr_27233_27259[(2)] = null);

(statearr_27233_27259[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27226 === (2))){
var state_27225__$1 = state_27225;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27225__$1,(4),from);
} else {
if((state_val_27226 === (11))){
var inst_27214 = (state_27225[(2)]);
var state_27225__$1 = state_27225;
if(cljs.core.truth_(inst_27214)){
var statearr_27234_27260 = state_27225__$1;
(statearr_27234_27260[(1)] = (12));

} else {
var statearr_27235_27261 = state_27225__$1;
(statearr_27235_27261[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27226 === (9))){
var state_27225__$1 = state_27225;
var statearr_27236_27262 = state_27225__$1;
(statearr_27236_27262[(2)] = null);

(statearr_27236_27262[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27226 === (5))){
var state_27225__$1 = state_27225;
if(cljs.core.truth_(close_QMARK_)){
var statearr_27237_27263 = state_27225__$1;
(statearr_27237_27263[(1)] = (8));

} else {
var statearr_27238_27264 = state_27225__$1;
(statearr_27238_27264[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27226 === (14))){
var inst_27219 = (state_27225[(2)]);
var state_27225__$1 = state_27225;
var statearr_27239_27265 = state_27225__$1;
(statearr_27239_27265[(2)] = inst_27219);

(statearr_27239_27265[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27226 === (10))){
var inst_27211 = (state_27225[(2)]);
var state_27225__$1 = state_27225;
var statearr_27240_27266 = state_27225__$1;
(statearr_27240_27266[(2)] = inst_27211);

(statearr_27240_27266[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27226 === (8))){
var inst_27208 = cljs.core.async.close_BANG_(to);
var state_27225__$1 = state_27225;
var statearr_27241_27267 = state_27225__$1;
(statearr_27241_27267[(2)] = inst_27208);

(statearr_27241_27267[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto___27253))
;
return ((function (switch__11791__auto__,c__11856__auto___27253){
return (function() {
var cljs$core$async$state_machine__11792__auto__ = null;
var cljs$core$async$state_machine__11792__auto____0 = (function (){
var statearr_27245 = [null,null,null,null,null,null,null,null];
(statearr_27245[(0)] = cljs$core$async$state_machine__11792__auto__);

(statearr_27245[(1)] = (1));

return statearr_27245;
});
var cljs$core$async$state_machine__11792__auto____1 = (function (state_27225){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__(state_27225);
if(cljs.core.keyword_identical_QMARK_(result__11794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e27246){if((e27246 instanceof Object)){
var ex__11795__auto__ = e27246;
var statearr_27247_27268 = state_27225;
(statearr_27247_27268[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27225);

return cljs.core.cst$kw$recur;
} else {
throw e27246;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11793__auto__,cljs.core.cst$kw$recur)){
var G__27269 = state_27225;
state_27225 = G__27269;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$state_machine__11792__auto__ = function(state_27225){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11792__auto____1.call(this,state_27225);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11792__auto____0;
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11792__auto____1;
return cljs$core$async$state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___27253))
})();
var state__11858__auto__ = (function (){var statearr_27248 = (f__11857__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11857__auto__.cljs$core$IFn$_invoke$arity$0() : f__11857__auto__.call(null));
(statearr_27248[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___27253);

return statearr_27248;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11858__auto__);
});})(c__11856__auto___27253))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__27453){
var vec__27454 = p__27453;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27454,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27454,(1),null);
var job = vec__27454;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__11856__auto___27636 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11856__auto___27636,res,vec__27454,v,p,job,jobs,results){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___27636,res,vec__27454,v,p,job,jobs,results){
return (function (state_27459){
var state_val_27460 = (state_27459[(1)]);
if((state_val_27460 === (1))){
var state_27459__$1 = state_27459;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27459__$1,(2),res,v);
} else {
if((state_val_27460 === (2))){
var inst_27456 = (state_27459[(2)]);
var inst_27457 = cljs.core.async.close_BANG_(res);
var state_27459__$1 = (function (){var statearr_27461 = state_27459;
(statearr_27461[(7)] = inst_27456);

return statearr_27461;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_27459__$1,inst_27457);
} else {
return null;
}
}
});})(c__11856__auto___27636,res,vec__27454,v,p,job,jobs,results))
;
return ((function (switch__11791__auto__,c__11856__auto___27636,res,vec__27454,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0 = (function (){
var statearr_27465 = [null,null,null,null,null,null,null,null];
(statearr_27465[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__);

(statearr_27465[(1)] = (1));

return statearr_27465;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1 = (function (state_27459){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__(state_27459);
if(cljs.core.keyword_identical_QMARK_(result__11794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e27466){if((e27466 instanceof Object)){
var ex__11795__auto__ = e27466;
var statearr_27467_27637 = state_27459;
(statearr_27467_27637[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27459);

return cljs.core.cst$kw$recur;
} else {
throw e27466;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11793__auto__,cljs.core.cst$kw$recur)){
var G__27638 = state_27459;
state_27459 = G__27638;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__ = function(state_27459){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1.call(this,state_27459);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___27636,res,vec__27454,v,p,job,jobs,results))
})();
var state__11858__auto__ = (function (){var statearr_27468 = (f__11857__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11857__auto__.cljs$core$IFn$_invoke$arity$0() : f__11857__auto__.call(null));
(statearr_27468[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___27636);

return statearr_27468;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11858__auto__);
});})(c__11856__auto___27636,res,vec__27454,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__27469){
var vec__27470 = p__27469;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27470,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27470,(1),null);
var job = vec__27470;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__7125__auto___27639 = n;
var __27640 = (0);
while(true){
if((__27640 < n__7125__auto___27639)){
var G__27471_27641 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__27471_27641) {
case "compute":
var c__11856__auto___27643 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__27640,c__11856__auto___27643,G__27471_27641,n__7125__auto___27639,jobs,results,process,async){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (__27640,c__11856__auto___27643,G__27471_27641,n__7125__auto___27639,jobs,results,process,async){
return (function (state_27484){
var state_val_27485 = (state_27484[(1)]);
if((state_val_27485 === (1))){
var state_27484__$1 = state_27484;
var statearr_27486_27644 = state_27484__$1;
(statearr_27486_27644[(2)] = null);

(statearr_27486_27644[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27485 === (2))){
var state_27484__$1 = state_27484;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27484__$1,(4),jobs);
} else {
if((state_val_27485 === (3))){
var inst_27482 = (state_27484[(2)]);
var state_27484__$1 = state_27484;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27484__$1,inst_27482);
} else {
if((state_val_27485 === (4))){
var inst_27474 = (state_27484[(2)]);
var inst_27475 = process(inst_27474);
var state_27484__$1 = state_27484;
if(cljs.core.truth_(inst_27475)){
var statearr_27487_27645 = state_27484__$1;
(statearr_27487_27645[(1)] = (5));

} else {
var statearr_27488_27646 = state_27484__$1;
(statearr_27488_27646[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27485 === (5))){
var state_27484__$1 = state_27484;
var statearr_27489_27647 = state_27484__$1;
(statearr_27489_27647[(2)] = null);

(statearr_27489_27647[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27485 === (6))){
var state_27484__$1 = state_27484;
var statearr_27490_27648 = state_27484__$1;
(statearr_27490_27648[(2)] = null);

(statearr_27490_27648[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27485 === (7))){
var inst_27480 = (state_27484[(2)]);
var state_27484__$1 = state_27484;
var statearr_27491_27649 = state_27484__$1;
(statearr_27491_27649[(2)] = inst_27480);

(statearr_27491_27649[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__27640,c__11856__auto___27643,G__27471_27641,n__7125__auto___27639,jobs,results,process,async))
;
return ((function (__27640,switch__11791__auto__,c__11856__auto___27643,G__27471_27641,n__7125__auto___27639,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0 = (function (){
var statearr_27495 = [null,null,null,null,null,null,null];
(statearr_27495[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__);

(statearr_27495[(1)] = (1));

return statearr_27495;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1 = (function (state_27484){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__(state_27484);
if(cljs.core.keyword_identical_QMARK_(result__11794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e27496){if((e27496 instanceof Object)){
var ex__11795__auto__ = e27496;
var statearr_27497_27650 = state_27484;
(statearr_27497_27650[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27484);

return cljs.core.cst$kw$recur;
} else {
throw e27496;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11793__auto__,cljs.core.cst$kw$recur)){
var G__27651 = state_27484;
state_27484 = G__27651;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__ = function(state_27484){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1.call(this,state_27484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__;
})()
;})(__27640,switch__11791__auto__,c__11856__auto___27643,G__27471_27641,n__7125__auto___27639,jobs,results,process,async))
})();
var state__11858__auto__ = (function (){var statearr_27498 = (f__11857__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11857__auto__.cljs$core$IFn$_invoke$arity$0() : f__11857__auto__.call(null));
(statearr_27498[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___27643);

return statearr_27498;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11858__auto__);
});})(__27640,c__11856__auto___27643,G__27471_27641,n__7125__auto___27639,jobs,results,process,async))
);


break;
case "async":
var c__11856__auto___27652 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__27640,c__11856__auto___27652,G__27471_27641,n__7125__auto___27639,jobs,results,process,async){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (__27640,c__11856__auto___27652,G__27471_27641,n__7125__auto___27639,jobs,results,process,async){
return (function (state_27511){
var state_val_27512 = (state_27511[(1)]);
if((state_val_27512 === (1))){
var state_27511__$1 = state_27511;
var statearr_27513_27653 = state_27511__$1;
(statearr_27513_27653[(2)] = null);

(statearr_27513_27653[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27512 === (2))){
var state_27511__$1 = state_27511;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27511__$1,(4),jobs);
} else {
if((state_val_27512 === (3))){
var inst_27509 = (state_27511[(2)]);
var state_27511__$1 = state_27511;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27511__$1,inst_27509);
} else {
if((state_val_27512 === (4))){
var inst_27501 = (state_27511[(2)]);
var inst_27502 = async(inst_27501);
var state_27511__$1 = state_27511;
if(cljs.core.truth_(inst_27502)){
var statearr_27514_27654 = state_27511__$1;
(statearr_27514_27654[(1)] = (5));

} else {
var statearr_27515_27655 = state_27511__$1;
(statearr_27515_27655[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27512 === (5))){
var state_27511__$1 = state_27511;
var statearr_27516_27656 = state_27511__$1;
(statearr_27516_27656[(2)] = null);

(statearr_27516_27656[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27512 === (6))){
var state_27511__$1 = state_27511;
var statearr_27517_27657 = state_27511__$1;
(statearr_27517_27657[(2)] = null);

(statearr_27517_27657[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27512 === (7))){
var inst_27507 = (state_27511[(2)]);
var state_27511__$1 = state_27511;
var statearr_27518_27658 = state_27511__$1;
(statearr_27518_27658[(2)] = inst_27507);

(statearr_27518_27658[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__27640,c__11856__auto___27652,G__27471_27641,n__7125__auto___27639,jobs,results,process,async))
;
return ((function (__27640,switch__11791__auto__,c__11856__auto___27652,G__27471_27641,n__7125__auto___27639,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0 = (function (){
var statearr_27522 = [null,null,null,null,null,null,null];
(statearr_27522[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__);

(statearr_27522[(1)] = (1));

return statearr_27522;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1 = (function (state_27511){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__(state_27511);
if(cljs.core.keyword_identical_QMARK_(result__11794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e27523){if((e27523 instanceof Object)){
var ex__11795__auto__ = e27523;
var statearr_27524_27659 = state_27511;
(statearr_27524_27659[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27511);

return cljs.core.cst$kw$recur;
} else {
throw e27523;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11793__auto__,cljs.core.cst$kw$recur)){
var G__27660 = state_27511;
state_27511 = G__27660;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__ = function(state_27511){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1.call(this,state_27511);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__;
})()
;})(__27640,switch__11791__auto__,c__11856__auto___27652,G__27471_27641,n__7125__auto___27639,jobs,results,process,async))
})();
var state__11858__auto__ = (function (){var statearr_27525 = (f__11857__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11857__auto__.cljs$core$IFn$_invoke$arity$0() : f__11857__auto__.call(null));
(statearr_27525[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___27652);

return statearr_27525;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11858__auto__);
});})(__27640,c__11856__auto___27652,G__27471_27641,n__7125__auto___27639,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__27661 = (__27640 + (1));
__27640 = G__27661;
continue;
} else {
}
break;
}

var c__11856__auto___27662 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11856__auto___27662,jobs,results,process,async){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___27662,jobs,results,process,async){
return (function (state_27547){
var state_val_27548 = (state_27547[(1)]);
if((state_val_27548 === (1))){
var state_27547__$1 = state_27547;
var statearr_27549_27663 = state_27547__$1;
(statearr_27549_27663[(2)] = null);

(statearr_27549_27663[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27548 === (2))){
var state_27547__$1 = state_27547;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27547__$1,(4),from);
} else {
if((state_val_27548 === (3))){
var inst_27545 = (state_27547[(2)]);
var state_27547__$1 = state_27547;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27547__$1,inst_27545);
} else {
if((state_val_27548 === (4))){
var inst_27528 = (state_27547[(7)]);
var inst_27528__$1 = (state_27547[(2)]);
var inst_27529 = (inst_27528__$1 == null);
var state_27547__$1 = (function (){var statearr_27550 = state_27547;
(statearr_27550[(7)] = inst_27528__$1);

return statearr_27550;
})();
if(cljs.core.truth_(inst_27529)){
var statearr_27551_27664 = state_27547__$1;
(statearr_27551_27664[(1)] = (5));

} else {
var statearr_27552_27665 = state_27547__$1;
(statearr_27552_27665[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27548 === (5))){
var inst_27531 = cljs.core.async.close_BANG_(jobs);
var state_27547__$1 = state_27547;
var statearr_27553_27666 = state_27547__$1;
(statearr_27553_27666[(2)] = inst_27531);

(statearr_27553_27666[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27548 === (6))){
var inst_27533 = (state_27547[(8)]);
var inst_27528 = (state_27547[(7)]);
var inst_27533__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_27534 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27535 = [inst_27528,inst_27533__$1];
var inst_27536 = (new cljs.core.PersistentVector(null,2,(5),inst_27534,inst_27535,null));
var state_27547__$1 = (function (){var statearr_27554 = state_27547;
(statearr_27554[(8)] = inst_27533__$1);

return statearr_27554;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27547__$1,(8),jobs,inst_27536);
} else {
if((state_val_27548 === (7))){
var inst_27543 = (state_27547[(2)]);
var state_27547__$1 = state_27547;
var statearr_27555_27667 = state_27547__$1;
(statearr_27555_27667[(2)] = inst_27543);

(statearr_27555_27667[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27548 === (8))){
var inst_27533 = (state_27547[(8)]);
var inst_27538 = (state_27547[(2)]);
var state_27547__$1 = (function (){var statearr_27556 = state_27547;
(statearr_27556[(9)] = inst_27538);

return statearr_27556;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27547__$1,(9),results,inst_27533);
} else {
if((state_val_27548 === (9))){
var inst_27540 = (state_27547[(2)]);
var state_27547__$1 = (function (){var statearr_27557 = state_27547;
(statearr_27557[(10)] = inst_27540);

return statearr_27557;
})();
var statearr_27558_27668 = state_27547__$1;
(statearr_27558_27668[(2)] = null);

(statearr_27558_27668[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__11856__auto___27662,jobs,results,process,async))
;
return ((function (switch__11791__auto__,c__11856__auto___27662,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0 = (function (){
var statearr_27562 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27562[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__);

(statearr_27562[(1)] = (1));

return statearr_27562;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1 = (function (state_27547){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__(state_27547);
if(cljs.core.keyword_identical_QMARK_(result__11794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e27563){if((e27563 instanceof Object)){
var ex__11795__auto__ = e27563;
var statearr_27564_27669 = state_27547;
(statearr_27564_27669[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27547);

return cljs.core.cst$kw$recur;
} else {
throw e27563;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11793__auto__,cljs.core.cst$kw$recur)){
var G__27670 = state_27547;
state_27547 = G__27670;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__ = function(state_27547){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1.call(this,state_27547);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___27662,jobs,results,process,async))
})();
var state__11858__auto__ = (function (){var statearr_27565 = (f__11857__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11857__auto__.cljs$core$IFn$_invoke$arity$0() : f__11857__auto__.call(null));
(statearr_27565[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___27662);

return statearr_27565;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11858__auto__);
});})(c__11856__auto___27662,jobs,results,process,async))
);


var c__11856__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11856__auto__,jobs,results,process,async){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto__,jobs,results,process,async){
return (function (state_27603){
var state_val_27604 = (state_27603[(1)]);
if((state_val_27604 === (7))){
var inst_27599 = (state_27603[(2)]);
var state_27603__$1 = state_27603;
var statearr_27605_27671 = state_27603__$1;
(statearr_27605_27671[(2)] = inst_27599);

(statearr_27605_27671[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27604 === (20))){
var state_27603__$1 = state_27603;
var statearr_27606_27672 = state_27603__$1;
(statearr_27606_27672[(2)] = null);

(statearr_27606_27672[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27604 === (1))){
var state_27603__$1 = state_27603;
var statearr_27607_27673 = state_27603__$1;
(statearr_27607_27673[(2)] = null);

(statearr_27607_27673[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27604 === (4))){
var inst_27568 = (state_27603[(7)]);
var inst_27568__$1 = (state_27603[(2)]);
var inst_27569 = (inst_27568__$1 == null);
var state_27603__$1 = (function (){var statearr_27608 = state_27603;
(statearr_27608[(7)] = inst_27568__$1);

return statearr_27608;
})();
if(cljs.core.truth_(inst_27569)){
var statearr_27609_27674 = state_27603__$1;
(statearr_27609_27674[(1)] = (5));

} else {
var statearr_27610_27675 = state_27603__$1;
(statearr_27610_27675[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27604 === (15))){
var inst_27581 = (state_27603[(8)]);
var state_27603__$1 = state_27603;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27603__$1,(18),to,inst_27581);
} else {
if((state_val_27604 === (21))){
var inst_27594 = (state_27603[(2)]);
var state_27603__$1 = state_27603;
var statearr_27611_27676 = state_27603__$1;
(statearr_27611_27676[(2)] = inst_27594);

(statearr_27611_27676[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27604 === (13))){
var inst_27596 = (state_27603[(2)]);
var state_27603__$1 = (function (){var statearr_27612 = state_27603;
(statearr_27612[(9)] = inst_27596);

return statearr_27612;
})();
var statearr_27613_27677 = state_27603__$1;
(statearr_27613_27677[(2)] = null);

(statearr_27613_27677[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27604 === (6))){
var inst_27568 = (state_27603[(7)]);
var state_27603__$1 = state_27603;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27603__$1,(11),inst_27568);
} else {
if((state_val_27604 === (17))){
var inst_27589 = (state_27603[(2)]);
var state_27603__$1 = state_27603;
if(cljs.core.truth_(inst_27589)){
var statearr_27614_27678 = state_27603__$1;
(statearr_27614_27678[(1)] = (19));

} else {
var statearr_27615_27679 = state_27603__$1;
(statearr_27615_27679[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27604 === (3))){
var inst_27601 = (state_27603[(2)]);
var state_27603__$1 = state_27603;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27603__$1,inst_27601);
} else {
if((state_val_27604 === (12))){
var inst_27578 = (state_27603[(10)]);
var state_27603__$1 = state_27603;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27603__$1,(14),inst_27578);
} else {
if((state_val_27604 === (2))){
var state_27603__$1 = state_27603;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27603__$1,(4),results);
} else {
if((state_val_27604 === (19))){
var state_27603__$1 = state_27603;
var statearr_27616_27680 = state_27603__$1;
(statearr_27616_27680[(2)] = null);

(statearr_27616_27680[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27604 === (11))){
var inst_27578 = (state_27603[(2)]);
var state_27603__$1 = (function (){var statearr_27617 = state_27603;
(statearr_27617[(10)] = inst_27578);

return statearr_27617;
})();
var statearr_27618_27681 = state_27603__$1;
(statearr_27618_27681[(2)] = null);

(statearr_27618_27681[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27604 === (9))){
var state_27603__$1 = state_27603;
var statearr_27619_27682 = state_27603__$1;
(statearr_27619_27682[(2)] = null);

(statearr_27619_27682[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27604 === (5))){
var state_27603__$1 = state_27603;
if(cljs.core.truth_(close_QMARK_)){
var statearr_27620_27683 = state_27603__$1;
(statearr_27620_27683[(1)] = (8));

} else {
var statearr_27621_27684 = state_27603__$1;
(statearr_27621_27684[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27604 === (14))){
var inst_27581 = (state_27603[(8)]);
var inst_27583 = (state_27603[(11)]);
var inst_27581__$1 = (state_27603[(2)]);
var inst_27582 = (inst_27581__$1 == null);
var inst_27583__$1 = cljs.core.not(inst_27582);
var state_27603__$1 = (function (){var statearr_27622 = state_27603;
(statearr_27622[(8)] = inst_27581__$1);

(statearr_27622[(11)] = inst_27583__$1);

return statearr_27622;
})();
if(inst_27583__$1){
var statearr_27623_27685 = state_27603__$1;
(statearr_27623_27685[(1)] = (15));

} else {
var statearr_27624_27686 = state_27603__$1;
(statearr_27624_27686[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27604 === (16))){
var inst_27583 = (state_27603[(11)]);
var state_27603__$1 = state_27603;
var statearr_27625_27687 = state_27603__$1;
(statearr_27625_27687[(2)] = inst_27583);

(statearr_27625_27687[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27604 === (10))){
var inst_27575 = (state_27603[(2)]);
var state_27603__$1 = state_27603;
var statearr_27626_27688 = state_27603__$1;
(statearr_27626_27688[(2)] = inst_27575);

(statearr_27626_27688[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27604 === (18))){
var inst_27586 = (state_27603[(2)]);
var state_27603__$1 = state_27603;
var statearr_27627_27689 = state_27603__$1;
(statearr_27627_27689[(2)] = inst_27586);

(statearr_27627_27689[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27604 === (8))){
var inst_27572 = cljs.core.async.close_BANG_(to);
var state_27603__$1 = state_27603;
var statearr_27628_27690 = state_27603__$1;
(statearr_27628_27690[(2)] = inst_27572);

(statearr_27628_27690[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto__,jobs,results,process,async))
;
return ((function (switch__11791__auto__,c__11856__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0 = (function (){
var statearr_27632 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27632[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__);

(statearr_27632[(1)] = (1));

return statearr_27632;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1 = (function (state_27603){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__(state_27603);
if(cljs.core.keyword_identical_QMARK_(result__11794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e27633){if((e27633 instanceof Object)){
var ex__11795__auto__ = e27633;
var statearr_27634_27691 = state_27603;
(statearr_27634_27691[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27603);

return cljs.core.cst$kw$recur;
} else {
throw e27633;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11793__auto__,cljs.core.cst$kw$recur)){
var G__27692 = state_27603;
state_27603 = G__27692;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__ = function(state_27603){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1.call(this,state_27603);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11792__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto__,jobs,results,process,async))
})();
var state__11858__auto__ = (function (){var statearr_27635 = (f__11857__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11857__auto__.cljs$core$IFn$_invoke$arity$0() : f__11857__auto__.call(null));
(statearr_27635[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto__);

return statearr_27635;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11858__auto__);
});})(c__11856__auto__,jobs,results,process,async))
);

return c__11856__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args27693 = [];
var len__7280__auto___27696 = arguments.length;
var i__7281__auto___27697 = (0);
while(true){
if((i__7281__auto___27697 < len__7280__auto___27696)){
args27693.push((arguments[i__7281__auto___27697]));

var G__27698 = (i__7281__auto___27697 + (1));
i__7281__auto___27697 = G__27698;
continue;
} else {
}
break;
}

var G__27695 = args27693.length;
switch (G__27695) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27693.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args27700 = [];
var len__7280__auto___27703 = arguments.length;
var i__7281__auto___27704 = (0);
while(true){
if((i__7281__auto___27704 < len__7280__auto___27703)){
args27700.push((arguments[i__7281__auto___27704]));

var G__27705 = (i__7281__auto___27704 + (1));
i__7281__auto___27704 = G__27705;
continue;
} else {
}
break;
}

var G__27702 = args27700.length;
switch (G__27702) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27700.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args27707 = [];
var len__7280__auto___27760 = arguments.length;
var i__7281__auto___27761 = (0);
while(true){
if((i__7281__auto___27761 < len__7280__auto___27760)){
args27707.push((arguments[i__7281__auto___27761]));

var G__27762 = (i__7281__auto___27761 + (1));
i__7281__auto___27761 = G__27762;
continue;
} else {
}
break;
}

var G__27709 = args27707.length;
switch (G__27709) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27707.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__11856__auto___27764 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11856__auto___27764,tc,fc){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___27764,tc,fc){
return (function (state_27735){
var state_val_27736 = (state_27735[(1)]);
if((state_val_27736 === (7))){
var inst_27731 = (state_27735[(2)]);
var state_27735__$1 = state_27735;
var statearr_27737_27765 = state_27735__$1;
(statearr_27737_27765[(2)] = inst_27731);

(statearr_27737_27765[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27736 === (1))){
var state_27735__$1 = state_27735;
var statearr_27738_27766 = state_27735__$1;
(statearr_27738_27766[(2)] = null);

(statearr_27738_27766[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27736 === (4))){
var inst_27712 = (state_27735[(7)]);
var inst_27712__$1 = (state_27735[(2)]);
var inst_27713 = (inst_27712__$1 == null);
var state_27735__$1 = (function (){var statearr_27739 = state_27735;
(statearr_27739[(7)] = inst_27712__$1);

return statearr_27739;
})();
if(cljs.core.truth_(inst_27713)){
var statearr_27740_27767 = state_27735__$1;
(statearr_27740_27767[(1)] = (5));

} else {
var statearr_27741_27768 = state_27735__$1;
(statearr_27741_27768[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27736 === (13))){
var state_27735__$1 = state_27735;
var statearr_27742_27769 = state_27735__$1;
(statearr_27742_27769[(2)] = null);

(statearr_27742_27769[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27736 === (6))){
var inst_27712 = (state_27735[(7)]);
var inst_27718 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_27712) : p.call(null,inst_27712));
var state_27735__$1 = state_27735;
if(cljs.core.truth_(inst_27718)){
var statearr_27743_27770 = state_27735__$1;
(statearr_27743_27770[(1)] = (9));

} else {
var statearr_27744_27771 = state_27735__$1;
(statearr_27744_27771[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27736 === (3))){
var inst_27733 = (state_27735[(2)]);
var state_27735__$1 = state_27735;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27735__$1,inst_27733);
} else {
if((state_val_27736 === (12))){
var state_27735__$1 = state_27735;
var statearr_27745_27772 = state_27735__$1;
(statearr_27745_27772[(2)] = null);

(statearr_27745_27772[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27736 === (2))){
var state_27735__$1 = state_27735;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27735__$1,(4),ch);
} else {
if((state_val_27736 === (11))){
var inst_27712 = (state_27735[(7)]);
var inst_27722 = (state_27735[(2)]);
var state_27735__$1 = state_27735;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27735__$1,(8),inst_27722,inst_27712);
} else {
if((state_val_27736 === (9))){
var state_27735__$1 = state_27735;
var statearr_27746_27773 = state_27735__$1;
(statearr_27746_27773[(2)] = tc);

(statearr_27746_27773[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27736 === (5))){
var inst_27715 = cljs.core.async.close_BANG_(tc);
var inst_27716 = cljs.core.async.close_BANG_(fc);
var state_27735__$1 = (function (){var statearr_27747 = state_27735;
(statearr_27747[(8)] = inst_27715);

return statearr_27747;
})();
var statearr_27748_27774 = state_27735__$1;
(statearr_27748_27774[(2)] = inst_27716);

(statearr_27748_27774[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27736 === (14))){
var inst_27729 = (state_27735[(2)]);
var state_27735__$1 = state_27735;
var statearr_27749_27775 = state_27735__$1;
(statearr_27749_27775[(2)] = inst_27729);

(statearr_27749_27775[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27736 === (10))){
var state_27735__$1 = state_27735;
var statearr_27750_27776 = state_27735__$1;
(statearr_27750_27776[(2)] = fc);

(statearr_27750_27776[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27736 === (8))){
var inst_27724 = (state_27735[(2)]);
var state_27735__$1 = state_27735;
if(cljs.core.truth_(inst_27724)){
var statearr_27751_27777 = state_27735__$1;
(statearr_27751_27777[(1)] = (12));

} else {
var statearr_27752_27778 = state_27735__$1;
(statearr_27752_27778[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto___27764,tc,fc))
;
return ((function (switch__11791__auto__,c__11856__auto___27764,tc,fc){
return (function() {
var cljs$core$async$state_machine__11792__auto__ = null;
var cljs$core$async$state_machine__11792__auto____0 = (function (){
var statearr_27756 = [null,null,null,null,null,null,null,null,null];
(statearr_27756[(0)] = cljs$core$async$state_machine__11792__auto__);

(statearr_27756[(1)] = (1));

return statearr_27756;
});
var cljs$core$async$state_machine__11792__auto____1 = (function (state_27735){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__(state_27735);
if(cljs.core.keyword_identical_QMARK_(result__11794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e27757){if((e27757 instanceof Object)){
var ex__11795__auto__ = e27757;
var statearr_27758_27779 = state_27735;
(statearr_27758_27779[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27735);

return cljs.core.cst$kw$recur;
} else {
throw e27757;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11793__auto__,cljs.core.cst$kw$recur)){
var G__27780 = state_27735;
state_27735 = G__27780;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$state_machine__11792__auto__ = function(state_27735){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11792__auto____1.call(this,state_27735);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11792__auto____0;
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11792__auto____1;
return cljs$core$async$state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___27764,tc,fc))
})();
var state__11858__auto__ = (function (){var statearr_27759 = (f__11857__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11857__auto__.cljs$core$IFn$_invoke$arity$0() : f__11857__auto__.call(null));
(statearr_27759[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___27764);

return statearr_27759;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11858__auto__);
});})(c__11856__auto___27764,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11856__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11856__auto__){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto__){
return (function (state_27844){
var state_val_27845 = (state_27844[(1)]);
if((state_val_27845 === (7))){
var inst_27840 = (state_27844[(2)]);
var state_27844__$1 = state_27844;
var statearr_27846_27867 = state_27844__$1;
(statearr_27846_27867[(2)] = inst_27840);

(statearr_27846_27867[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27845 === (1))){
var inst_27824 = init;
var state_27844__$1 = (function (){var statearr_27847 = state_27844;
(statearr_27847[(7)] = inst_27824);

return statearr_27847;
})();
var statearr_27848_27868 = state_27844__$1;
(statearr_27848_27868[(2)] = null);

(statearr_27848_27868[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27845 === (4))){
var inst_27827 = (state_27844[(8)]);
var inst_27827__$1 = (state_27844[(2)]);
var inst_27828 = (inst_27827__$1 == null);
var state_27844__$1 = (function (){var statearr_27849 = state_27844;
(statearr_27849[(8)] = inst_27827__$1);

return statearr_27849;
})();
if(cljs.core.truth_(inst_27828)){
var statearr_27850_27869 = state_27844__$1;
(statearr_27850_27869[(1)] = (5));

} else {
var statearr_27851_27870 = state_27844__$1;
(statearr_27851_27870[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27845 === (6))){
var inst_27824 = (state_27844[(7)]);
var inst_27831 = (state_27844[(9)]);
var inst_27827 = (state_27844[(8)]);
var inst_27831__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_27824,inst_27827) : f.call(null,inst_27824,inst_27827));
var inst_27832 = cljs.core.reduced_QMARK_(inst_27831__$1);
var state_27844__$1 = (function (){var statearr_27852 = state_27844;
(statearr_27852[(9)] = inst_27831__$1);

return statearr_27852;
})();
if(inst_27832){
var statearr_27853_27871 = state_27844__$1;
(statearr_27853_27871[(1)] = (8));

} else {
var statearr_27854_27872 = state_27844__$1;
(statearr_27854_27872[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27845 === (3))){
var inst_27842 = (state_27844[(2)]);
var state_27844__$1 = state_27844;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27844__$1,inst_27842);
} else {
if((state_val_27845 === (2))){
var state_27844__$1 = state_27844;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27844__$1,(4),ch);
} else {
if((state_val_27845 === (9))){
var inst_27831 = (state_27844[(9)]);
var inst_27824 = inst_27831;
var state_27844__$1 = (function (){var statearr_27855 = state_27844;
(statearr_27855[(7)] = inst_27824);

return statearr_27855;
})();
var statearr_27856_27873 = state_27844__$1;
(statearr_27856_27873[(2)] = null);

(statearr_27856_27873[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27845 === (5))){
var inst_27824 = (state_27844[(7)]);
var state_27844__$1 = state_27844;
var statearr_27857_27874 = state_27844__$1;
(statearr_27857_27874[(2)] = inst_27824);

(statearr_27857_27874[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27845 === (10))){
var inst_27838 = (state_27844[(2)]);
var state_27844__$1 = state_27844;
var statearr_27858_27875 = state_27844__$1;
(statearr_27858_27875[(2)] = inst_27838);

(statearr_27858_27875[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27845 === (8))){
var inst_27831 = (state_27844[(9)]);
var inst_27834 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inst_27831) : cljs.core.deref.call(null,inst_27831));
var state_27844__$1 = state_27844;
var statearr_27859_27876 = state_27844__$1;
(statearr_27859_27876[(2)] = inst_27834);

(statearr_27859_27876[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto__))
;
return ((function (switch__11791__auto__,c__11856__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__11792__auto__ = null;
var cljs$core$async$reduce_$_state_machine__11792__auto____0 = (function (){
var statearr_27863 = [null,null,null,null,null,null,null,null,null,null];
(statearr_27863[(0)] = cljs$core$async$reduce_$_state_machine__11792__auto__);

(statearr_27863[(1)] = (1));

return statearr_27863;
});
var cljs$core$async$reduce_$_state_machine__11792__auto____1 = (function (state_27844){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__(state_27844);
if(cljs.core.keyword_identical_QMARK_(result__11794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e27864){if((e27864 instanceof Object)){
var ex__11795__auto__ = e27864;
var statearr_27865_27877 = state_27844;
(statearr_27865_27877[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27844);

return cljs.core.cst$kw$recur;
} else {
throw e27864;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11793__auto__,cljs.core.cst$kw$recur)){
var G__27878 = state_27844;
state_27844 = G__27878;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__11792__auto__ = function(state_27844){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__11792__auto____1.call(this,state_27844);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__11792__auto____0;
cljs$core$async$reduce_$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__11792__auto____1;
return cljs$core$async$reduce_$_state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto__))
})();
var state__11858__auto__ = (function (){var statearr_27866 = (f__11857__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11857__auto__.cljs$core$IFn$_invoke$arity$0() : f__11857__auto__.call(null));
(statearr_27866[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto__);

return statearr_27866;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11858__auto__);
});})(c__11856__auto__))
);

return c__11856__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args27879 = [];
var len__7280__auto___27931 = arguments.length;
var i__7281__auto___27932 = (0);
while(true){
if((i__7281__auto___27932 < len__7280__auto___27931)){
args27879.push((arguments[i__7281__auto___27932]));

var G__27933 = (i__7281__auto___27932 + (1));
i__7281__auto___27932 = G__27933;
continue;
} else {
}
break;
}

var G__27881 = args27879.length;
switch (G__27881) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27879.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11856__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11856__auto__){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto__){
return (function (state_27906){
var state_val_27907 = (state_27906[(1)]);
if((state_val_27907 === (7))){
var inst_27888 = (state_27906[(2)]);
var state_27906__$1 = state_27906;
var statearr_27908_27935 = state_27906__$1;
(statearr_27908_27935[(2)] = inst_27888);

(statearr_27908_27935[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27907 === (1))){
var inst_27882 = cljs.core.seq(coll);
var inst_27883 = inst_27882;
var state_27906__$1 = (function (){var statearr_27909 = state_27906;
(statearr_27909[(7)] = inst_27883);

return statearr_27909;
})();
var statearr_27910_27936 = state_27906__$1;
(statearr_27910_27936[(2)] = null);

(statearr_27910_27936[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27907 === (4))){
var inst_27883 = (state_27906[(7)]);
var inst_27886 = cljs.core.first(inst_27883);
var state_27906__$1 = state_27906;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27906__$1,(7),ch,inst_27886);
} else {
if((state_val_27907 === (13))){
var inst_27900 = (state_27906[(2)]);
var state_27906__$1 = state_27906;
var statearr_27911_27937 = state_27906__$1;
(statearr_27911_27937[(2)] = inst_27900);

(statearr_27911_27937[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27907 === (6))){
var inst_27891 = (state_27906[(2)]);
var state_27906__$1 = state_27906;
if(cljs.core.truth_(inst_27891)){
var statearr_27912_27938 = state_27906__$1;
(statearr_27912_27938[(1)] = (8));

} else {
var statearr_27913_27939 = state_27906__$1;
(statearr_27913_27939[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27907 === (3))){
var inst_27904 = (state_27906[(2)]);
var state_27906__$1 = state_27906;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27906__$1,inst_27904);
} else {
if((state_val_27907 === (12))){
var state_27906__$1 = state_27906;
var statearr_27914_27940 = state_27906__$1;
(statearr_27914_27940[(2)] = null);

(statearr_27914_27940[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27907 === (2))){
var inst_27883 = (state_27906[(7)]);
var state_27906__$1 = state_27906;
if(cljs.core.truth_(inst_27883)){
var statearr_27915_27941 = state_27906__$1;
(statearr_27915_27941[(1)] = (4));

} else {
var statearr_27916_27942 = state_27906__$1;
(statearr_27916_27942[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27907 === (11))){
var inst_27897 = cljs.core.async.close_BANG_(ch);
var state_27906__$1 = state_27906;
var statearr_27917_27943 = state_27906__$1;
(statearr_27917_27943[(2)] = inst_27897);

(statearr_27917_27943[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27907 === (9))){
var state_27906__$1 = state_27906;
if(cljs.core.truth_(close_QMARK_)){
var statearr_27918_27944 = state_27906__$1;
(statearr_27918_27944[(1)] = (11));

} else {
var statearr_27919_27945 = state_27906__$1;
(statearr_27919_27945[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27907 === (5))){
var inst_27883 = (state_27906[(7)]);
var state_27906__$1 = state_27906;
var statearr_27920_27946 = state_27906__$1;
(statearr_27920_27946[(2)] = inst_27883);

(statearr_27920_27946[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27907 === (10))){
var inst_27902 = (state_27906[(2)]);
var state_27906__$1 = state_27906;
var statearr_27921_27947 = state_27906__$1;
(statearr_27921_27947[(2)] = inst_27902);

(statearr_27921_27947[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27907 === (8))){
var inst_27883 = (state_27906[(7)]);
var inst_27893 = cljs.core.next(inst_27883);
var inst_27883__$1 = inst_27893;
var state_27906__$1 = (function (){var statearr_27922 = state_27906;
(statearr_27922[(7)] = inst_27883__$1);

return statearr_27922;
})();
var statearr_27923_27948 = state_27906__$1;
(statearr_27923_27948[(2)] = null);

(statearr_27923_27948[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto__))
;
return ((function (switch__11791__auto__,c__11856__auto__){
return (function() {
var cljs$core$async$state_machine__11792__auto__ = null;
var cljs$core$async$state_machine__11792__auto____0 = (function (){
var statearr_27927 = [null,null,null,null,null,null,null,null];
(statearr_27927[(0)] = cljs$core$async$state_machine__11792__auto__);

(statearr_27927[(1)] = (1));

return statearr_27927;
});
var cljs$core$async$state_machine__11792__auto____1 = (function (state_27906){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__(state_27906);
if(cljs.core.keyword_identical_QMARK_(result__11794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e27928){if((e27928 instanceof Object)){
var ex__11795__auto__ = e27928;
var statearr_27929_27949 = state_27906;
(statearr_27929_27949[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27906);

return cljs.core.cst$kw$recur;
} else {
throw e27928;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11793__auto__,cljs.core.cst$kw$recur)){
var G__27950 = state_27906;
state_27906 = G__27950;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$state_machine__11792__auto__ = function(state_27906){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11792__auto____1.call(this,state_27906);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11792__auto____0;
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11792__auto____1;
return cljs$core$async$state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto__))
})();
var state__11858__auto__ = (function (){var statearr_27930 = (f__11857__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11857__auto__.cljs$core$IFn$_invoke$arity$0() : f__11857__auto__.call(null));
(statearr_27930[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto__);

return statearr_27930;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11858__auto__);
});})(c__11856__auto__))
);

return c__11856__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__6873__auto__ = (((_ == null))?null:_);
var m__6874__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__6874__auto__.call(null,_));
} else {
var m__6874__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__6874__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__6874__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__6874__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__6874__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6874__auto__.call(null,m,ch));
} else {
var m__6874__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6874__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__6874__auto__.call(null,m));
} else {
var m__6874__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__6874__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__28175 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__28175) : cljs.core.atom.call(null,G__28175));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async28176 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28176 = (function (mult,ch,cs,meta28177){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta28177 = meta28177;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async28176.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_28178,meta28177__$1){
var self__ = this;
var _28178__$1 = this;
return (new cljs.core.async.t_cljs$core$async28176(self__.mult,self__.ch,self__.cs,meta28177__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async28176.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_28178){
var self__ = this;
var _28178__$1 = this;
return self__.meta28177;
});})(cs))
;

cljs.core.async.t_cljs$core$async28176.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async28176.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async28176.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async28176.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async28176.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async28176.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__28179_28399 = self__.cs;
var G__28180_28400 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__28179_28399,G__28180_28400) : cljs.core.reset_BANG_.call(null,G__28179_28399,G__28180_28400));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async28176.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mult,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta28177], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async28176.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28176.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28176";

cljs.core.async.t_cljs$core$async28176.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"cljs.core.async/t_cljs$core$async28176");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async28176 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async28176(mult__$1,ch__$1,cs__$1,meta28177){
return (new cljs.core.async.t_cljs$core$async28176(mult__$1,ch__$1,cs__$1,meta28177));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async28176(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__11856__auto___28401 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11856__auto___28401,cs,m,dchan,dctr,done){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___28401,cs,m,dchan,dctr,done){
return (function (state_28311){
var state_val_28312 = (state_28311[(1)]);
if((state_val_28312 === (7))){
var inst_28307 = (state_28311[(2)]);
var state_28311__$1 = state_28311;
var statearr_28313_28402 = state_28311__$1;
(statearr_28313_28402[(2)] = inst_28307);

(statearr_28313_28402[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (20))){
var inst_28212 = (state_28311[(7)]);
var inst_28222 = cljs.core.first(inst_28212);
var inst_28223 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28222,(0),null);
var inst_28224 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28222,(1),null);
var state_28311__$1 = (function (){var statearr_28314 = state_28311;
(statearr_28314[(8)] = inst_28223);

return statearr_28314;
})();
if(cljs.core.truth_(inst_28224)){
var statearr_28315_28403 = state_28311__$1;
(statearr_28315_28403[(1)] = (22));

} else {
var statearr_28316_28404 = state_28311__$1;
(statearr_28316_28404[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (27))){
var inst_28259 = (state_28311[(9)]);
var inst_28254 = (state_28311[(10)]);
var inst_28252 = (state_28311[(11)]);
var inst_28183 = (state_28311[(12)]);
var inst_28259__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_28252,inst_28254);
var inst_28260 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_28259__$1,inst_28183,done);
var state_28311__$1 = (function (){var statearr_28317 = state_28311;
(statearr_28317[(9)] = inst_28259__$1);

return statearr_28317;
})();
if(cljs.core.truth_(inst_28260)){
var statearr_28318_28405 = state_28311__$1;
(statearr_28318_28405[(1)] = (30));

} else {
var statearr_28319_28406 = state_28311__$1;
(statearr_28319_28406[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (1))){
var state_28311__$1 = state_28311;
var statearr_28320_28407 = state_28311__$1;
(statearr_28320_28407[(2)] = null);

(statearr_28320_28407[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (24))){
var inst_28212 = (state_28311[(7)]);
var inst_28229 = (state_28311[(2)]);
var inst_28230 = cljs.core.next(inst_28212);
var inst_28192 = inst_28230;
var inst_28193 = null;
var inst_28194 = (0);
var inst_28195 = (0);
var state_28311__$1 = (function (){var statearr_28321 = state_28311;
(statearr_28321[(13)] = inst_28193);

(statearr_28321[(14)] = inst_28229);

(statearr_28321[(15)] = inst_28195);

(statearr_28321[(16)] = inst_28194);

(statearr_28321[(17)] = inst_28192);

return statearr_28321;
})();
var statearr_28322_28408 = state_28311__$1;
(statearr_28322_28408[(2)] = null);

(statearr_28322_28408[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (39))){
var state_28311__$1 = state_28311;
var statearr_28326_28409 = state_28311__$1;
(statearr_28326_28409[(2)] = null);

(statearr_28326_28409[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (4))){
var inst_28183 = (state_28311[(12)]);
var inst_28183__$1 = (state_28311[(2)]);
var inst_28184 = (inst_28183__$1 == null);
var state_28311__$1 = (function (){var statearr_28327 = state_28311;
(statearr_28327[(12)] = inst_28183__$1);

return statearr_28327;
})();
if(cljs.core.truth_(inst_28184)){
var statearr_28328_28410 = state_28311__$1;
(statearr_28328_28410[(1)] = (5));

} else {
var statearr_28329_28411 = state_28311__$1;
(statearr_28329_28411[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (15))){
var inst_28193 = (state_28311[(13)]);
var inst_28195 = (state_28311[(15)]);
var inst_28194 = (state_28311[(16)]);
var inst_28192 = (state_28311[(17)]);
var inst_28208 = (state_28311[(2)]);
var inst_28209 = (inst_28195 + (1));
var tmp28323 = inst_28193;
var tmp28324 = inst_28194;
var tmp28325 = inst_28192;
var inst_28192__$1 = tmp28325;
var inst_28193__$1 = tmp28323;
var inst_28194__$1 = tmp28324;
var inst_28195__$1 = inst_28209;
var state_28311__$1 = (function (){var statearr_28330 = state_28311;
(statearr_28330[(13)] = inst_28193__$1);

(statearr_28330[(15)] = inst_28195__$1);

(statearr_28330[(16)] = inst_28194__$1);

(statearr_28330[(17)] = inst_28192__$1);

(statearr_28330[(18)] = inst_28208);

return statearr_28330;
})();
var statearr_28331_28412 = state_28311__$1;
(statearr_28331_28412[(2)] = null);

(statearr_28331_28412[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (21))){
var inst_28233 = (state_28311[(2)]);
var state_28311__$1 = state_28311;
var statearr_28335_28413 = state_28311__$1;
(statearr_28335_28413[(2)] = inst_28233);

(statearr_28335_28413[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (31))){
var inst_28259 = (state_28311[(9)]);
var inst_28263 = done(null);
var inst_28264 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_28259);
var state_28311__$1 = (function (){var statearr_28336 = state_28311;
(statearr_28336[(19)] = inst_28263);

return statearr_28336;
})();
var statearr_28337_28414 = state_28311__$1;
(statearr_28337_28414[(2)] = inst_28264);

(statearr_28337_28414[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (32))){
var inst_28253 = (state_28311[(20)]);
var inst_28254 = (state_28311[(10)]);
var inst_28252 = (state_28311[(11)]);
var inst_28251 = (state_28311[(21)]);
var inst_28266 = (state_28311[(2)]);
var inst_28267 = (inst_28254 + (1));
var tmp28332 = inst_28253;
var tmp28333 = inst_28252;
var tmp28334 = inst_28251;
var inst_28251__$1 = tmp28334;
var inst_28252__$1 = tmp28333;
var inst_28253__$1 = tmp28332;
var inst_28254__$1 = inst_28267;
var state_28311__$1 = (function (){var statearr_28338 = state_28311;
(statearr_28338[(20)] = inst_28253__$1);

(statearr_28338[(10)] = inst_28254__$1);

(statearr_28338[(11)] = inst_28252__$1);

(statearr_28338[(22)] = inst_28266);

(statearr_28338[(21)] = inst_28251__$1);

return statearr_28338;
})();
var statearr_28339_28415 = state_28311__$1;
(statearr_28339_28415[(2)] = null);

(statearr_28339_28415[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (40))){
var inst_28279 = (state_28311[(23)]);
var inst_28283 = done(null);
var inst_28284 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_28279);
var state_28311__$1 = (function (){var statearr_28340 = state_28311;
(statearr_28340[(24)] = inst_28283);

return statearr_28340;
})();
var statearr_28341_28416 = state_28311__$1;
(statearr_28341_28416[(2)] = inst_28284);

(statearr_28341_28416[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (33))){
var inst_28270 = (state_28311[(25)]);
var inst_28272 = cljs.core.chunked_seq_QMARK_(inst_28270);
var state_28311__$1 = state_28311;
if(inst_28272){
var statearr_28342_28417 = state_28311__$1;
(statearr_28342_28417[(1)] = (36));

} else {
var statearr_28343_28418 = state_28311__$1;
(statearr_28343_28418[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (13))){
var inst_28202 = (state_28311[(26)]);
var inst_28205 = cljs.core.async.close_BANG_(inst_28202);
var state_28311__$1 = state_28311;
var statearr_28344_28419 = state_28311__$1;
(statearr_28344_28419[(2)] = inst_28205);

(statearr_28344_28419[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (22))){
var inst_28223 = (state_28311[(8)]);
var inst_28226 = cljs.core.async.close_BANG_(inst_28223);
var state_28311__$1 = state_28311;
var statearr_28345_28420 = state_28311__$1;
(statearr_28345_28420[(2)] = inst_28226);

(statearr_28345_28420[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (36))){
var inst_28270 = (state_28311[(25)]);
var inst_28274 = cljs.core.chunk_first(inst_28270);
var inst_28275 = cljs.core.chunk_rest(inst_28270);
var inst_28276 = cljs.core.count(inst_28274);
var inst_28251 = inst_28275;
var inst_28252 = inst_28274;
var inst_28253 = inst_28276;
var inst_28254 = (0);
var state_28311__$1 = (function (){var statearr_28346 = state_28311;
(statearr_28346[(20)] = inst_28253);

(statearr_28346[(10)] = inst_28254);

(statearr_28346[(11)] = inst_28252);

(statearr_28346[(21)] = inst_28251);

return statearr_28346;
})();
var statearr_28347_28421 = state_28311__$1;
(statearr_28347_28421[(2)] = null);

(statearr_28347_28421[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (41))){
var inst_28270 = (state_28311[(25)]);
var inst_28286 = (state_28311[(2)]);
var inst_28287 = cljs.core.next(inst_28270);
var inst_28251 = inst_28287;
var inst_28252 = null;
var inst_28253 = (0);
var inst_28254 = (0);
var state_28311__$1 = (function (){var statearr_28348 = state_28311;
(statearr_28348[(20)] = inst_28253);

(statearr_28348[(10)] = inst_28254);

(statearr_28348[(11)] = inst_28252);

(statearr_28348[(27)] = inst_28286);

(statearr_28348[(21)] = inst_28251);

return statearr_28348;
})();
var statearr_28349_28422 = state_28311__$1;
(statearr_28349_28422[(2)] = null);

(statearr_28349_28422[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (43))){
var state_28311__$1 = state_28311;
var statearr_28350_28423 = state_28311__$1;
(statearr_28350_28423[(2)] = null);

(statearr_28350_28423[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (29))){
var inst_28295 = (state_28311[(2)]);
var state_28311__$1 = state_28311;
var statearr_28351_28424 = state_28311__$1;
(statearr_28351_28424[(2)] = inst_28295);

(statearr_28351_28424[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (44))){
var inst_28304 = (state_28311[(2)]);
var state_28311__$1 = (function (){var statearr_28352 = state_28311;
(statearr_28352[(28)] = inst_28304);

return statearr_28352;
})();
var statearr_28353_28425 = state_28311__$1;
(statearr_28353_28425[(2)] = null);

(statearr_28353_28425[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (6))){
var inst_28243 = (state_28311[(29)]);
var inst_28242 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_28243__$1 = cljs.core.keys(inst_28242);
var inst_28244 = cljs.core.count(inst_28243__$1);
var inst_28245 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_28244) : cljs.core.reset_BANG_.call(null,dctr,inst_28244));
var inst_28250 = cljs.core.seq(inst_28243__$1);
var inst_28251 = inst_28250;
var inst_28252 = null;
var inst_28253 = (0);
var inst_28254 = (0);
var state_28311__$1 = (function (){var statearr_28354 = state_28311;
(statearr_28354[(20)] = inst_28253);

(statearr_28354[(10)] = inst_28254);

(statearr_28354[(11)] = inst_28252);

(statearr_28354[(29)] = inst_28243__$1);

(statearr_28354[(30)] = inst_28245);

(statearr_28354[(21)] = inst_28251);

return statearr_28354;
})();
var statearr_28355_28426 = state_28311__$1;
(statearr_28355_28426[(2)] = null);

(statearr_28355_28426[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (28))){
var inst_28270 = (state_28311[(25)]);
var inst_28251 = (state_28311[(21)]);
var inst_28270__$1 = cljs.core.seq(inst_28251);
var state_28311__$1 = (function (){var statearr_28356 = state_28311;
(statearr_28356[(25)] = inst_28270__$1);

return statearr_28356;
})();
if(inst_28270__$1){
var statearr_28357_28427 = state_28311__$1;
(statearr_28357_28427[(1)] = (33));

} else {
var statearr_28358_28428 = state_28311__$1;
(statearr_28358_28428[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (25))){
var inst_28253 = (state_28311[(20)]);
var inst_28254 = (state_28311[(10)]);
var inst_28256 = (inst_28254 < inst_28253);
var inst_28257 = inst_28256;
var state_28311__$1 = state_28311;
if(cljs.core.truth_(inst_28257)){
var statearr_28359_28429 = state_28311__$1;
(statearr_28359_28429[(1)] = (27));

} else {
var statearr_28360_28430 = state_28311__$1;
(statearr_28360_28430[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (34))){
var state_28311__$1 = state_28311;
var statearr_28361_28431 = state_28311__$1;
(statearr_28361_28431[(2)] = null);

(statearr_28361_28431[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (17))){
var state_28311__$1 = state_28311;
var statearr_28362_28432 = state_28311__$1;
(statearr_28362_28432[(2)] = null);

(statearr_28362_28432[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (3))){
var inst_28309 = (state_28311[(2)]);
var state_28311__$1 = state_28311;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28311__$1,inst_28309);
} else {
if((state_val_28312 === (12))){
var inst_28238 = (state_28311[(2)]);
var state_28311__$1 = state_28311;
var statearr_28363_28433 = state_28311__$1;
(statearr_28363_28433[(2)] = inst_28238);

(statearr_28363_28433[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (2))){
var state_28311__$1 = state_28311;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28311__$1,(4),ch);
} else {
if((state_val_28312 === (23))){
var state_28311__$1 = state_28311;
var statearr_28364_28434 = state_28311__$1;
(statearr_28364_28434[(2)] = null);

(statearr_28364_28434[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (35))){
var inst_28293 = (state_28311[(2)]);
var state_28311__$1 = state_28311;
var statearr_28365_28435 = state_28311__$1;
(statearr_28365_28435[(2)] = inst_28293);

(statearr_28365_28435[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (19))){
var inst_28212 = (state_28311[(7)]);
var inst_28216 = cljs.core.chunk_first(inst_28212);
var inst_28217 = cljs.core.chunk_rest(inst_28212);
var inst_28218 = cljs.core.count(inst_28216);
var inst_28192 = inst_28217;
var inst_28193 = inst_28216;
var inst_28194 = inst_28218;
var inst_28195 = (0);
var state_28311__$1 = (function (){var statearr_28366 = state_28311;
(statearr_28366[(13)] = inst_28193);

(statearr_28366[(15)] = inst_28195);

(statearr_28366[(16)] = inst_28194);

(statearr_28366[(17)] = inst_28192);

return statearr_28366;
})();
var statearr_28367_28436 = state_28311__$1;
(statearr_28367_28436[(2)] = null);

(statearr_28367_28436[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (11))){
var inst_28212 = (state_28311[(7)]);
var inst_28192 = (state_28311[(17)]);
var inst_28212__$1 = cljs.core.seq(inst_28192);
var state_28311__$1 = (function (){var statearr_28368 = state_28311;
(statearr_28368[(7)] = inst_28212__$1);

return statearr_28368;
})();
if(inst_28212__$1){
var statearr_28369_28437 = state_28311__$1;
(statearr_28369_28437[(1)] = (16));

} else {
var statearr_28370_28438 = state_28311__$1;
(statearr_28370_28438[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (9))){
var inst_28240 = (state_28311[(2)]);
var state_28311__$1 = state_28311;
var statearr_28371_28439 = state_28311__$1;
(statearr_28371_28439[(2)] = inst_28240);

(statearr_28371_28439[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (5))){
var inst_28190 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_28191 = cljs.core.seq(inst_28190);
var inst_28192 = inst_28191;
var inst_28193 = null;
var inst_28194 = (0);
var inst_28195 = (0);
var state_28311__$1 = (function (){var statearr_28372 = state_28311;
(statearr_28372[(13)] = inst_28193);

(statearr_28372[(15)] = inst_28195);

(statearr_28372[(16)] = inst_28194);

(statearr_28372[(17)] = inst_28192);

return statearr_28372;
})();
var statearr_28373_28440 = state_28311__$1;
(statearr_28373_28440[(2)] = null);

(statearr_28373_28440[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (14))){
var state_28311__$1 = state_28311;
var statearr_28374_28441 = state_28311__$1;
(statearr_28374_28441[(2)] = null);

(statearr_28374_28441[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (45))){
var inst_28301 = (state_28311[(2)]);
var state_28311__$1 = state_28311;
var statearr_28375_28442 = state_28311__$1;
(statearr_28375_28442[(2)] = inst_28301);

(statearr_28375_28442[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (26))){
var inst_28243 = (state_28311[(29)]);
var inst_28297 = (state_28311[(2)]);
var inst_28298 = cljs.core.seq(inst_28243);
var state_28311__$1 = (function (){var statearr_28376 = state_28311;
(statearr_28376[(31)] = inst_28297);

return statearr_28376;
})();
if(inst_28298){
var statearr_28377_28443 = state_28311__$1;
(statearr_28377_28443[(1)] = (42));

} else {
var statearr_28378_28444 = state_28311__$1;
(statearr_28378_28444[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (16))){
var inst_28212 = (state_28311[(7)]);
var inst_28214 = cljs.core.chunked_seq_QMARK_(inst_28212);
var state_28311__$1 = state_28311;
if(inst_28214){
var statearr_28379_28445 = state_28311__$1;
(statearr_28379_28445[(1)] = (19));

} else {
var statearr_28380_28446 = state_28311__$1;
(statearr_28380_28446[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (38))){
var inst_28290 = (state_28311[(2)]);
var state_28311__$1 = state_28311;
var statearr_28381_28447 = state_28311__$1;
(statearr_28381_28447[(2)] = inst_28290);

(statearr_28381_28447[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (30))){
var state_28311__$1 = state_28311;
var statearr_28382_28448 = state_28311__$1;
(statearr_28382_28448[(2)] = null);

(statearr_28382_28448[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (10))){
var inst_28193 = (state_28311[(13)]);
var inst_28195 = (state_28311[(15)]);
var inst_28201 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_28193,inst_28195);
var inst_28202 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28201,(0),null);
var inst_28203 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28201,(1),null);
var state_28311__$1 = (function (){var statearr_28383 = state_28311;
(statearr_28383[(26)] = inst_28202);

return statearr_28383;
})();
if(cljs.core.truth_(inst_28203)){
var statearr_28384_28449 = state_28311__$1;
(statearr_28384_28449[(1)] = (13));

} else {
var statearr_28385_28450 = state_28311__$1;
(statearr_28385_28450[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (18))){
var inst_28236 = (state_28311[(2)]);
var state_28311__$1 = state_28311;
var statearr_28386_28451 = state_28311__$1;
(statearr_28386_28451[(2)] = inst_28236);

(statearr_28386_28451[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (42))){
var state_28311__$1 = state_28311;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28311__$1,(45),dchan);
} else {
if((state_val_28312 === (37))){
var inst_28279 = (state_28311[(23)]);
var inst_28183 = (state_28311[(12)]);
var inst_28270 = (state_28311[(25)]);
var inst_28279__$1 = cljs.core.first(inst_28270);
var inst_28280 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_28279__$1,inst_28183,done);
var state_28311__$1 = (function (){var statearr_28387 = state_28311;
(statearr_28387[(23)] = inst_28279__$1);

return statearr_28387;
})();
if(cljs.core.truth_(inst_28280)){
var statearr_28388_28452 = state_28311__$1;
(statearr_28388_28452[(1)] = (39));

} else {
var statearr_28389_28453 = state_28311__$1;
(statearr_28389_28453[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28312 === (8))){
var inst_28195 = (state_28311[(15)]);
var inst_28194 = (state_28311[(16)]);
var inst_28197 = (inst_28195 < inst_28194);
var inst_28198 = inst_28197;
var state_28311__$1 = state_28311;
if(cljs.core.truth_(inst_28198)){
var statearr_28390_28454 = state_28311__$1;
(statearr_28390_28454[(1)] = (10));

} else {
var statearr_28391_28455 = state_28311__$1;
(statearr_28391_28455[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto___28401,cs,m,dchan,dctr,done))
;
return ((function (switch__11791__auto__,c__11856__auto___28401,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__11792__auto__ = null;
var cljs$core$async$mult_$_state_machine__11792__auto____0 = (function (){
var statearr_28395 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28395[(0)] = cljs$core$async$mult_$_state_machine__11792__auto__);

(statearr_28395[(1)] = (1));

return statearr_28395;
});
var cljs$core$async$mult_$_state_machine__11792__auto____1 = (function (state_28311){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__(state_28311);
if(cljs.core.keyword_identical_QMARK_(result__11794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e28396){if((e28396 instanceof Object)){
var ex__11795__auto__ = e28396;
var statearr_28397_28456 = state_28311;
(statearr_28397_28456[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28311);

return cljs.core.cst$kw$recur;
} else {
throw e28396;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11793__auto__,cljs.core.cst$kw$recur)){
var G__28457 = state_28311;
state_28311 = G__28457;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__11792__auto__ = function(state_28311){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__11792__auto____1.call(this,state_28311);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__11792__auto____0;
cljs$core$async$mult_$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__11792__auto____1;
return cljs$core$async$mult_$_state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___28401,cs,m,dchan,dctr,done))
})();
var state__11858__auto__ = (function (){var statearr_28398 = (f__11857__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11857__auto__.cljs$core$IFn$_invoke$arity$0() : f__11857__auto__.call(null));
(statearr_28398[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___28401);

return statearr_28398;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11858__auto__);
});})(c__11856__auto___28401,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args28458 = [];
var len__7280__auto___28461 = arguments.length;
var i__7281__auto___28462 = (0);
while(true){
if((i__7281__auto___28462 < len__7280__auto___28461)){
args28458.push((arguments[i__7281__auto___28462]));

var G__28463 = (i__7281__auto___28462 + (1));
i__7281__auto___28462 = G__28463;
continue;
} else {
}
break;
}

var G__28460 = args28458.length;
switch (G__28460) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28458.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6874__auto__.call(null,m,ch));
} else {
var m__6874__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6874__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6874__auto__.call(null,m,ch));
} else {
var m__6874__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6874__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__6874__auto__.call(null,m));
} else {
var m__6874__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__6874__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__6874__auto__.call(null,m,state_map));
} else {
var m__6874__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__6874__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__6874__auto__.call(null,m,mode));
} else {
var m__6874__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__6874__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7287__auto__ = [];
var len__7280__auto___28475 = arguments.length;
var i__7281__auto___28476 = (0);
while(true){
if((i__7281__auto___28476 < len__7280__auto___28475)){
args__7287__auto__.push((arguments[i__7281__auto___28476]));

var G__28477 = (i__7281__auto___28476 + (1));
i__7281__auto___28476 = G__28477;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((3) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7288__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__28469){
var map__28470 = p__28469;
var map__28470__$1 = ((((!((map__28470 == null)))?((((map__28470.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28470.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28470):map__28470);
var opts = map__28470__$1;
var statearr_28472_28478 = state;
(statearr_28472_28478[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts(((function (map__28470,map__28470__$1,opts){
return (function (val){
var statearr_28473_28479 = state;
(statearr_28473_28479[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__28470,map__28470__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_28474_28480 = state;
(statearr_28474_28480[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq28465){
var G__28466 = cljs.core.first(seq28465);
var seq28465__$1 = cljs.core.next(seq28465);
var G__28467 = cljs.core.first(seq28465__$1);
var seq28465__$2 = cljs.core.next(seq28465__$1);
var G__28468 = cljs.core.first(seq28465__$2);
var seq28465__$3 = cljs.core.next(seq28465__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__28466,G__28467,G__28468,seq28465__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__28647 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__28647) : cljs.core.atom.call(null,G__28647));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute) : cljs.core.atom.call(null,cljs.core.cst$kw$mute));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async28648 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28648 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta28649){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta28649 = meta28649;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async28648.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_28650,meta28649__$1){
var self__ = this;
var _28650__$1 = this;
return (new cljs.core.async.t_cljs$core$async28648(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta28649__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28648.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_28650){
var self__ = this;
var _28650__$1 = this;
return self__.meta28649;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28648.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async28648.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28648.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async28648.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28648.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28648.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__28651_28813 = self__.cs;
var G__28652_28814 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__28651_28813,G__28652_28814) : cljs.core.reset_BANG_.call(null,G__28651_28813,G__28652_28814));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28648.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28648.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28648.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.with_meta(cljs.core.cst$sym$mix,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out], null))),cljs.core.cst$kw$doc,"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta28649], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28648.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28648.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28648";

cljs.core.async.t_cljs$core$async28648.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"cljs.core.async/t_cljs$core$async28648");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async28648 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async28648(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta28649){
return (new cljs.core.async.t_cljs$core$async28648(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta28649));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async28648(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11856__auto___28815 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11856__auto___28815,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___28815,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_28750){
var state_val_28751 = (state_28750[(1)]);
if((state_val_28751 === (7))){
var inst_28668 = (state_28750[(2)]);
var state_28750__$1 = state_28750;
var statearr_28752_28816 = state_28750__$1;
(statearr_28752_28816[(2)] = inst_28668);

(statearr_28752_28816[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (20))){
var inst_28680 = (state_28750[(7)]);
var state_28750__$1 = state_28750;
var statearr_28753_28817 = state_28750__$1;
(statearr_28753_28817[(2)] = inst_28680);

(statearr_28753_28817[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (27))){
var state_28750__$1 = state_28750;
var statearr_28754_28818 = state_28750__$1;
(statearr_28754_28818[(2)] = null);

(statearr_28754_28818[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (1))){
var inst_28656 = (state_28750[(8)]);
var inst_28656__$1 = calc_state();
var inst_28658 = (inst_28656__$1 == null);
var inst_28659 = cljs.core.not(inst_28658);
var state_28750__$1 = (function (){var statearr_28755 = state_28750;
(statearr_28755[(8)] = inst_28656__$1);

return statearr_28755;
})();
if(inst_28659){
var statearr_28756_28819 = state_28750__$1;
(statearr_28756_28819[(1)] = (2));

} else {
var statearr_28757_28820 = state_28750__$1;
(statearr_28757_28820[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (24))){
var inst_28724 = (state_28750[(9)]);
var inst_28703 = (state_28750[(10)]);
var inst_28710 = (state_28750[(11)]);
var inst_28724__$1 = (inst_28703.cljs$core$IFn$_invoke$arity$1 ? inst_28703.cljs$core$IFn$_invoke$arity$1(inst_28710) : inst_28703.call(null,inst_28710));
var state_28750__$1 = (function (){var statearr_28758 = state_28750;
(statearr_28758[(9)] = inst_28724__$1);

return statearr_28758;
})();
if(cljs.core.truth_(inst_28724__$1)){
var statearr_28759_28821 = state_28750__$1;
(statearr_28759_28821[(1)] = (29));

} else {
var statearr_28760_28822 = state_28750__$1;
(statearr_28760_28822[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (4))){
var inst_28671 = (state_28750[(2)]);
var state_28750__$1 = state_28750;
if(cljs.core.truth_(inst_28671)){
var statearr_28761_28823 = state_28750__$1;
(statearr_28761_28823[(1)] = (8));

} else {
var statearr_28762_28824 = state_28750__$1;
(statearr_28762_28824[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (15))){
var inst_28697 = (state_28750[(2)]);
var state_28750__$1 = state_28750;
if(cljs.core.truth_(inst_28697)){
var statearr_28763_28825 = state_28750__$1;
(statearr_28763_28825[(1)] = (19));

} else {
var statearr_28764_28826 = state_28750__$1;
(statearr_28764_28826[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (21))){
var inst_28702 = (state_28750[(12)]);
var inst_28702__$1 = (state_28750[(2)]);
var inst_28703 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28702__$1,cljs.core.cst$kw$solos);
var inst_28704 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28702__$1,cljs.core.cst$kw$mutes);
var inst_28705 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28702__$1,cljs.core.cst$kw$reads);
var state_28750__$1 = (function (){var statearr_28765 = state_28750;
(statearr_28765[(13)] = inst_28704);

(statearr_28765[(12)] = inst_28702__$1);

(statearr_28765[(10)] = inst_28703);

return statearr_28765;
})();
return cljs.core.async.ioc_alts_BANG_(state_28750__$1,(22),inst_28705);
} else {
if((state_val_28751 === (31))){
var inst_28732 = (state_28750[(2)]);
var state_28750__$1 = state_28750;
if(cljs.core.truth_(inst_28732)){
var statearr_28766_28827 = state_28750__$1;
(statearr_28766_28827[(1)] = (32));

} else {
var statearr_28767_28828 = state_28750__$1;
(statearr_28767_28828[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (32))){
var inst_28709 = (state_28750[(14)]);
var state_28750__$1 = state_28750;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28750__$1,(35),out,inst_28709);
} else {
if((state_val_28751 === (33))){
var inst_28702 = (state_28750[(12)]);
var inst_28680 = inst_28702;
var state_28750__$1 = (function (){var statearr_28768 = state_28750;
(statearr_28768[(7)] = inst_28680);

return statearr_28768;
})();
var statearr_28769_28829 = state_28750__$1;
(statearr_28769_28829[(2)] = null);

(statearr_28769_28829[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (13))){
var inst_28680 = (state_28750[(7)]);
var inst_28687 = inst_28680.cljs$lang$protocol_mask$partition0$;
var inst_28688 = (inst_28687 & (64));
var inst_28689 = inst_28680.cljs$core$ISeq$;
var inst_28690 = (inst_28688) || (inst_28689);
var state_28750__$1 = state_28750;
if(cljs.core.truth_(inst_28690)){
var statearr_28770_28830 = state_28750__$1;
(statearr_28770_28830[(1)] = (16));

} else {
var statearr_28771_28831 = state_28750__$1;
(statearr_28771_28831[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (22))){
var inst_28709 = (state_28750[(14)]);
var inst_28710 = (state_28750[(11)]);
var inst_28708 = (state_28750[(2)]);
var inst_28709__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28708,(0),null);
var inst_28710__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28708,(1),null);
var inst_28711 = (inst_28709__$1 == null);
var inst_28712 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_28710__$1,change);
var inst_28713 = (inst_28711) || (inst_28712);
var state_28750__$1 = (function (){var statearr_28772 = state_28750;
(statearr_28772[(14)] = inst_28709__$1);

(statearr_28772[(11)] = inst_28710__$1);

return statearr_28772;
})();
if(cljs.core.truth_(inst_28713)){
var statearr_28773_28832 = state_28750__$1;
(statearr_28773_28832[(1)] = (23));

} else {
var statearr_28774_28833 = state_28750__$1;
(statearr_28774_28833[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (36))){
var inst_28702 = (state_28750[(12)]);
var inst_28680 = inst_28702;
var state_28750__$1 = (function (){var statearr_28775 = state_28750;
(statearr_28775[(7)] = inst_28680);

return statearr_28775;
})();
var statearr_28776_28834 = state_28750__$1;
(statearr_28776_28834[(2)] = null);

(statearr_28776_28834[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (29))){
var inst_28724 = (state_28750[(9)]);
var state_28750__$1 = state_28750;
var statearr_28777_28835 = state_28750__$1;
(statearr_28777_28835[(2)] = inst_28724);

(statearr_28777_28835[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (6))){
var state_28750__$1 = state_28750;
var statearr_28778_28836 = state_28750__$1;
(statearr_28778_28836[(2)] = false);

(statearr_28778_28836[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (28))){
var inst_28720 = (state_28750[(2)]);
var inst_28721 = calc_state();
var inst_28680 = inst_28721;
var state_28750__$1 = (function (){var statearr_28779 = state_28750;
(statearr_28779[(7)] = inst_28680);

(statearr_28779[(15)] = inst_28720);

return statearr_28779;
})();
var statearr_28780_28837 = state_28750__$1;
(statearr_28780_28837[(2)] = null);

(statearr_28780_28837[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (25))){
var inst_28746 = (state_28750[(2)]);
var state_28750__$1 = state_28750;
var statearr_28781_28838 = state_28750__$1;
(statearr_28781_28838[(2)] = inst_28746);

(statearr_28781_28838[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (34))){
var inst_28744 = (state_28750[(2)]);
var state_28750__$1 = state_28750;
var statearr_28782_28839 = state_28750__$1;
(statearr_28782_28839[(2)] = inst_28744);

(statearr_28782_28839[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (17))){
var state_28750__$1 = state_28750;
var statearr_28783_28840 = state_28750__$1;
(statearr_28783_28840[(2)] = false);

(statearr_28783_28840[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (3))){
var state_28750__$1 = state_28750;
var statearr_28784_28841 = state_28750__$1;
(statearr_28784_28841[(2)] = false);

(statearr_28784_28841[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (12))){
var inst_28748 = (state_28750[(2)]);
var state_28750__$1 = state_28750;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28750__$1,inst_28748);
} else {
if((state_val_28751 === (2))){
var inst_28656 = (state_28750[(8)]);
var inst_28661 = inst_28656.cljs$lang$protocol_mask$partition0$;
var inst_28662 = (inst_28661 & (64));
var inst_28663 = inst_28656.cljs$core$ISeq$;
var inst_28664 = (inst_28662) || (inst_28663);
var state_28750__$1 = state_28750;
if(cljs.core.truth_(inst_28664)){
var statearr_28785_28842 = state_28750__$1;
(statearr_28785_28842[(1)] = (5));

} else {
var statearr_28786_28843 = state_28750__$1;
(statearr_28786_28843[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (23))){
var inst_28709 = (state_28750[(14)]);
var inst_28715 = (inst_28709 == null);
var state_28750__$1 = state_28750;
if(cljs.core.truth_(inst_28715)){
var statearr_28787_28844 = state_28750__$1;
(statearr_28787_28844[(1)] = (26));

} else {
var statearr_28788_28845 = state_28750__$1;
(statearr_28788_28845[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (35))){
var inst_28735 = (state_28750[(2)]);
var state_28750__$1 = state_28750;
if(cljs.core.truth_(inst_28735)){
var statearr_28789_28846 = state_28750__$1;
(statearr_28789_28846[(1)] = (36));

} else {
var statearr_28790_28847 = state_28750__$1;
(statearr_28790_28847[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (19))){
var inst_28680 = (state_28750[(7)]);
var inst_28699 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_28680);
var state_28750__$1 = state_28750;
var statearr_28791_28848 = state_28750__$1;
(statearr_28791_28848[(2)] = inst_28699);

(statearr_28791_28848[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (11))){
var inst_28680 = (state_28750[(7)]);
var inst_28684 = (inst_28680 == null);
var inst_28685 = cljs.core.not(inst_28684);
var state_28750__$1 = state_28750;
if(inst_28685){
var statearr_28792_28849 = state_28750__$1;
(statearr_28792_28849[(1)] = (13));

} else {
var statearr_28793_28850 = state_28750__$1;
(statearr_28793_28850[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (9))){
var inst_28656 = (state_28750[(8)]);
var state_28750__$1 = state_28750;
var statearr_28794_28851 = state_28750__$1;
(statearr_28794_28851[(2)] = inst_28656);

(statearr_28794_28851[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (5))){
var state_28750__$1 = state_28750;
var statearr_28795_28852 = state_28750__$1;
(statearr_28795_28852[(2)] = true);

(statearr_28795_28852[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (14))){
var state_28750__$1 = state_28750;
var statearr_28796_28853 = state_28750__$1;
(statearr_28796_28853[(2)] = false);

(statearr_28796_28853[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (26))){
var inst_28710 = (state_28750[(11)]);
var inst_28717 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_28710);
var state_28750__$1 = state_28750;
var statearr_28797_28854 = state_28750__$1;
(statearr_28797_28854[(2)] = inst_28717);

(statearr_28797_28854[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (16))){
var state_28750__$1 = state_28750;
var statearr_28798_28855 = state_28750__$1;
(statearr_28798_28855[(2)] = true);

(statearr_28798_28855[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (38))){
var inst_28740 = (state_28750[(2)]);
var state_28750__$1 = state_28750;
var statearr_28799_28856 = state_28750__$1;
(statearr_28799_28856[(2)] = inst_28740);

(statearr_28799_28856[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (30))){
var inst_28704 = (state_28750[(13)]);
var inst_28703 = (state_28750[(10)]);
var inst_28710 = (state_28750[(11)]);
var inst_28727 = cljs.core.empty_QMARK_(inst_28703);
var inst_28728 = (inst_28704.cljs$core$IFn$_invoke$arity$1 ? inst_28704.cljs$core$IFn$_invoke$arity$1(inst_28710) : inst_28704.call(null,inst_28710));
var inst_28729 = cljs.core.not(inst_28728);
var inst_28730 = (inst_28727) && (inst_28729);
var state_28750__$1 = state_28750;
var statearr_28800_28857 = state_28750__$1;
(statearr_28800_28857[(2)] = inst_28730);

(statearr_28800_28857[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (10))){
var inst_28656 = (state_28750[(8)]);
var inst_28676 = (state_28750[(2)]);
var inst_28677 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28676,cljs.core.cst$kw$solos);
var inst_28678 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28676,cljs.core.cst$kw$mutes);
var inst_28679 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28676,cljs.core.cst$kw$reads);
var inst_28680 = inst_28656;
var state_28750__$1 = (function (){var statearr_28801 = state_28750;
(statearr_28801[(16)] = inst_28677);

(statearr_28801[(7)] = inst_28680);

(statearr_28801[(17)] = inst_28679);

(statearr_28801[(18)] = inst_28678);

return statearr_28801;
})();
var statearr_28802_28858 = state_28750__$1;
(statearr_28802_28858[(2)] = null);

(statearr_28802_28858[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (18))){
var inst_28694 = (state_28750[(2)]);
var state_28750__$1 = state_28750;
var statearr_28803_28859 = state_28750__$1;
(statearr_28803_28859[(2)] = inst_28694);

(statearr_28803_28859[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (37))){
var state_28750__$1 = state_28750;
var statearr_28804_28860 = state_28750__$1;
(statearr_28804_28860[(2)] = null);

(statearr_28804_28860[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28751 === (8))){
var inst_28656 = (state_28750[(8)]);
var inst_28673 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_28656);
var state_28750__$1 = state_28750;
var statearr_28805_28861 = state_28750__$1;
(statearr_28805_28861[(2)] = inst_28673);

(statearr_28805_28861[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto___28815,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__11791__auto__,c__11856__auto___28815,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__11792__auto__ = null;
var cljs$core$async$mix_$_state_machine__11792__auto____0 = (function (){
var statearr_28809 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28809[(0)] = cljs$core$async$mix_$_state_machine__11792__auto__);

(statearr_28809[(1)] = (1));

return statearr_28809;
});
var cljs$core$async$mix_$_state_machine__11792__auto____1 = (function (state_28750){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__(state_28750);
if(cljs.core.keyword_identical_QMARK_(result__11794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e28810){if((e28810 instanceof Object)){
var ex__11795__auto__ = e28810;
var statearr_28811_28862 = state_28750;
(statearr_28811_28862[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28750);

return cljs.core.cst$kw$recur;
} else {
throw e28810;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11793__auto__,cljs.core.cst$kw$recur)){
var G__28863 = state_28750;
state_28750 = G__28863;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__11792__auto__ = function(state_28750){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__11792__auto____1.call(this,state_28750);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__11792__auto____0;
cljs$core$async$mix_$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__11792__auto____1;
return cljs$core$async$mix_$_state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___28815,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__11858__auto__ = (function (){var statearr_28812 = (f__11857__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11857__auto__.cljs$core$IFn$_invoke$arity$0() : f__11857__auto__.call(null));
(statearr_28812[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___28815);

return statearr_28812;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11858__auto__);
});})(c__11856__auto___28815,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__6873__auto__ = (((p == null))?null:p);
var m__6874__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$4 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__6874__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__6874__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__6874__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__6873__auto__ = (((p == null))?null:p);
var m__6874__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__6874__auto__.call(null,p,v,ch));
} else {
var m__6874__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__6874__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args28864 = [];
var len__7280__auto___28867 = arguments.length;
var i__7281__auto___28868 = (0);
while(true){
if((i__7281__auto___28868 < len__7280__auto___28867)){
args28864.push((arguments[i__7281__auto___28868]));

var G__28869 = (i__7281__auto___28868 + (1));
i__7281__auto___28868 = G__28869;
continue;
} else {
}
break;
}

var G__28866 = args28864.length;
switch (G__28866) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28864.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__6873__auto__ = (((p == null))?null:p);
var m__6874__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__6874__auto__.call(null,p));
} else {
var m__6874__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__6874__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__6873__auto__ = (((p == null))?null:p);
var m__6874__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__6874__auto__.call(null,p,v));
} else {
var m__6874__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__6874__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args28872 = [];
var len__7280__auto___29000 = arguments.length;
var i__7281__auto___29001 = (0);
while(true){
if((i__7281__auto___29001 < len__7280__auto___29000)){
args28872.push((arguments[i__7281__auto___29001]));

var G__29002 = (i__7281__auto___29001 + (1));
i__7281__auto___29001 = G__29002;
continue;
} else {
}
break;
}

var G__28874 = args28872.length;
switch (G__28874) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28872.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__28875 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__28875) : cljs.core.atom.call(null,G__28875));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__6210__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__6210__auto__,mults){
return (function (p1__28871_SHARP_){
if(cljs.core.truth_((p1__28871_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__28871_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__28871_SHARP_.call(null,topic)))){
return p1__28871_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__28871_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__6210__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async28876 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28876 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta28877){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta28877 = meta28877;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async28876.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_28878,meta28877__$1){
var self__ = this;
var _28878__$1 = this;
return (new cljs.core.async.t_cljs$core$async28876(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta28877__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28876.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_28878){
var self__ = this;
var _28878__$1 = this;
return self__.meta28877;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28876.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async28876.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28876.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async28876.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28876.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28876.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__28879 = self__.mults;
var G__28880 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__28879,G__28880) : cljs.core.reset_BANG_.call(null,G__28879,G__28880));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28876.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28876.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta28877], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28876.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28876.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28876";

cljs.core.async.t_cljs$core$async28876.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"cljs.core.async/t_cljs$core$async28876");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async28876 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async28876(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta28877){
return (new cljs.core.async.t_cljs$core$async28876(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta28877));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async28876(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11856__auto___29004 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11856__auto___29004,mults,ensure_mult,p){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___29004,mults,ensure_mult,p){
return (function (state_28952){
var state_val_28953 = (state_28952[(1)]);
if((state_val_28953 === (7))){
var inst_28948 = (state_28952[(2)]);
var state_28952__$1 = state_28952;
var statearr_28954_29005 = state_28952__$1;
(statearr_28954_29005[(2)] = inst_28948);

(statearr_28954_29005[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28953 === (20))){
var state_28952__$1 = state_28952;
var statearr_28955_29006 = state_28952__$1;
(statearr_28955_29006[(2)] = null);

(statearr_28955_29006[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28953 === (1))){
var state_28952__$1 = state_28952;
var statearr_28956_29007 = state_28952__$1;
(statearr_28956_29007[(2)] = null);

(statearr_28956_29007[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28953 === (24))){
var inst_28931 = (state_28952[(7)]);
var inst_28940 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_28931);
var state_28952__$1 = state_28952;
var statearr_28957_29008 = state_28952__$1;
(statearr_28957_29008[(2)] = inst_28940);

(statearr_28957_29008[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28953 === (4))){
var inst_28883 = (state_28952[(8)]);
var inst_28883__$1 = (state_28952[(2)]);
var inst_28884 = (inst_28883__$1 == null);
var state_28952__$1 = (function (){var statearr_28958 = state_28952;
(statearr_28958[(8)] = inst_28883__$1);

return statearr_28958;
})();
if(cljs.core.truth_(inst_28884)){
var statearr_28959_29009 = state_28952__$1;
(statearr_28959_29009[(1)] = (5));

} else {
var statearr_28960_29010 = state_28952__$1;
(statearr_28960_29010[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28953 === (15))){
var inst_28925 = (state_28952[(2)]);
var state_28952__$1 = state_28952;
var statearr_28961_29011 = state_28952__$1;
(statearr_28961_29011[(2)] = inst_28925);

(statearr_28961_29011[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28953 === (21))){
var inst_28945 = (state_28952[(2)]);
var state_28952__$1 = (function (){var statearr_28962 = state_28952;
(statearr_28962[(9)] = inst_28945);

return statearr_28962;
})();
var statearr_28963_29012 = state_28952__$1;
(statearr_28963_29012[(2)] = null);

(statearr_28963_29012[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28953 === (13))){
var inst_28907 = (state_28952[(10)]);
var inst_28909 = cljs.core.chunked_seq_QMARK_(inst_28907);
var state_28952__$1 = state_28952;
if(inst_28909){
var statearr_28964_29013 = state_28952__$1;
(statearr_28964_29013[(1)] = (16));

} else {
var statearr_28965_29014 = state_28952__$1;
(statearr_28965_29014[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28953 === (22))){
var inst_28937 = (state_28952[(2)]);
var state_28952__$1 = state_28952;
if(cljs.core.truth_(inst_28937)){
var statearr_28966_29015 = state_28952__$1;
(statearr_28966_29015[(1)] = (23));

} else {
var statearr_28967_29016 = state_28952__$1;
(statearr_28967_29016[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28953 === (6))){
var inst_28931 = (state_28952[(7)]);
var inst_28883 = (state_28952[(8)]);
var inst_28933 = (state_28952[(11)]);
var inst_28931__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_28883) : topic_fn.call(null,inst_28883));
var inst_28932 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_28933__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28932,inst_28931__$1);
var state_28952__$1 = (function (){var statearr_28968 = state_28952;
(statearr_28968[(7)] = inst_28931__$1);

(statearr_28968[(11)] = inst_28933__$1);

return statearr_28968;
})();
if(cljs.core.truth_(inst_28933__$1)){
var statearr_28969_29017 = state_28952__$1;
(statearr_28969_29017[(1)] = (19));

} else {
var statearr_28970_29018 = state_28952__$1;
(statearr_28970_29018[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28953 === (25))){
var inst_28942 = (state_28952[(2)]);
var state_28952__$1 = state_28952;
var statearr_28971_29019 = state_28952__$1;
(statearr_28971_29019[(2)] = inst_28942);

(statearr_28971_29019[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28953 === (17))){
var inst_28907 = (state_28952[(10)]);
var inst_28916 = cljs.core.first(inst_28907);
var inst_28917 = cljs.core.async.muxch_STAR_(inst_28916);
var inst_28918 = cljs.core.async.close_BANG_(inst_28917);
var inst_28919 = cljs.core.next(inst_28907);
var inst_28893 = inst_28919;
var inst_28894 = null;
var inst_28895 = (0);
var inst_28896 = (0);
var state_28952__$1 = (function (){var statearr_28972 = state_28952;
(statearr_28972[(12)] = inst_28895);

(statearr_28972[(13)] = inst_28896);

(statearr_28972[(14)] = inst_28894);

(statearr_28972[(15)] = inst_28918);

(statearr_28972[(16)] = inst_28893);

return statearr_28972;
})();
var statearr_28973_29020 = state_28952__$1;
(statearr_28973_29020[(2)] = null);

(statearr_28973_29020[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28953 === (3))){
var inst_28950 = (state_28952[(2)]);
var state_28952__$1 = state_28952;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28952__$1,inst_28950);
} else {
if((state_val_28953 === (12))){
var inst_28927 = (state_28952[(2)]);
var state_28952__$1 = state_28952;
var statearr_28974_29021 = state_28952__$1;
(statearr_28974_29021[(2)] = inst_28927);

(statearr_28974_29021[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28953 === (2))){
var state_28952__$1 = state_28952;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28952__$1,(4),ch);
} else {
if((state_val_28953 === (23))){
var state_28952__$1 = state_28952;
var statearr_28975_29022 = state_28952__$1;
(statearr_28975_29022[(2)] = null);

(statearr_28975_29022[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28953 === (19))){
var inst_28883 = (state_28952[(8)]);
var inst_28933 = (state_28952[(11)]);
var inst_28935 = cljs.core.async.muxch_STAR_(inst_28933);
var state_28952__$1 = state_28952;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28952__$1,(22),inst_28935,inst_28883);
} else {
if((state_val_28953 === (11))){
var inst_28907 = (state_28952[(10)]);
var inst_28893 = (state_28952[(16)]);
var inst_28907__$1 = cljs.core.seq(inst_28893);
var state_28952__$1 = (function (){var statearr_28976 = state_28952;
(statearr_28976[(10)] = inst_28907__$1);

return statearr_28976;
})();
if(inst_28907__$1){
var statearr_28977_29023 = state_28952__$1;
(statearr_28977_29023[(1)] = (13));

} else {
var statearr_28978_29024 = state_28952__$1;
(statearr_28978_29024[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28953 === (9))){
var inst_28929 = (state_28952[(2)]);
var state_28952__$1 = state_28952;
var statearr_28979_29025 = state_28952__$1;
(statearr_28979_29025[(2)] = inst_28929);

(statearr_28979_29025[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28953 === (5))){
var inst_28890 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_28891 = cljs.core.vals(inst_28890);
var inst_28892 = cljs.core.seq(inst_28891);
var inst_28893 = inst_28892;
var inst_28894 = null;
var inst_28895 = (0);
var inst_28896 = (0);
var state_28952__$1 = (function (){var statearr_28980 = state_28952;
(statearr_28980[(12)] = inst_28895);

(statearr_28980[(13)] = inst_28896);

(statearr_28980[(14)] = inst_28894);

(statearr_28980[(16)] = inst_28893);

return statearr_28980;
})();
var statearr_28981_29026 = state_28952__$1;
(statearr_28981_29026[(2)] = null);

(statearr_28981_29026[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28953 === (14))){
var state_28952__$1 = state_28952;
var statearr_28985_29027 = state_28952__$1;
(statearr_28985_29027[(2)] = null);

(statearr_28985_29027[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28953 === (16))){
var inst_28907 = (state_28952[(10)]);
var inst_28911 = cljs.core.chunk_first(inst_28907);
var inst_28912 = cljs.core.chunk_rest(inst_28907);
var inst_28913 = cljs.core.count(inst_28911);
var inst_28893 = inst_28912;
var inst_28894 = inst_28911;
var inst_28895 = inst_28913;
var inst_28896 = (0);
var state_28952__$1 = (function (){var statearr_28986 = state_28952;
(statearr_28986[(12)] = inst_28895);

(statearr_28986[(13)] = inst_28896);

(statearr_28986[(14)] = inst_28894);

(statearr_28986[(16)] = inst_28893);

return statearr_28986;
})();
var statearr_28987_29028 = state_28952__$1;
(statearr_28987_29028[(2)] = null);

(statearr_28987_29028[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28953 === (10))){
var inst_28895 = (state_28952[(12)]);
var inst_28896 = (state_28952[(13)]);
var inst_28894 = (state_28952[(14)]);
var inst_28893 = (state_28952[(16)]);
var inst_28901 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_28894,inst_28896);
var inst_28902 = cljs.core.async.muxch_STAR_(inst_28901);
var inst_28903 = cljs.core.async.close_BANG_(inst_28902);
var inst_28904 = (inst_28896 + (1));
var tmp28982 = inst_28895;
var tmp28983 = inst_28894;
var tmp28984 = inst_28893;
var inst_28893__$1 = tmp28984;
var inst_28894__$1 = tmp28983;
var inst_28895__$1 = tmp28982;
var inst_28896__$1 = inst_28904;
var state_28952__$1 = (function (){var statearr_28988 = state_28952;
(statearr_28988[(12)] = inst_28895__$1);

(statearr_28988[(17)] = inst_28903);

(statearr_28988[(13)] = inst_28896__$1);

(statearr_28988[(14)] = inst_28894__$1);

(statearr_28988[(16)] = inst_28893__$1);

return statearr_28988;
})();
var statearr_28989_29029 = state_28952__$1;
(statearr_28989_29029[(2)] = null);

(statearr_28989_29029[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28953 === (18))){
var inst_28922 = (state_28952[(2)]);
var state_28952__$1 = state_28952;
var statearr_28990_29030 = state_28952__$1;
(statearr_28990_29030[(2)] = inst_28922);

(statearr_28990_29030[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28953 === (8))){
var inst_28895 = (state_28952[(12)]);
var inst_28896 = (state_28952[(13)]);
var inst_28898 = (inst_28896 < inst_28895);
var inst_28899 = inst_28898;
var state_28952__$1 = state_28952;
if(cljs.core.truth_(inst_28899)){
var statearr_28991_29031 = state_28952__$1;
(statearr_28991_29031[(1)] = (10));

} else {
var statearr_28992_29032 = state_28952__$1;
(statearr_28992_29032[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto___29004,mults,ensure_mult,p))
;
return ((function (switch__11791__auto__,c__11856__auto___29004,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__11792__auto__ = null;
var cljs$core$async$state_machine__11792__auto____0 = (function (){
var statearr_28996 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28996[(0)] = cljs$core$async$state_machine__11792__auto__);

(statearr_28996[(1)] = (1));

return statearr_28996;
});
var cljs$core$async$state_machine__11792__auto____1 = (function (state_28952){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__(state_28952);
if(cljs.core.keyword_identical_QMARK_(result__11794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e28997){if((e28997 instanceof Object)){
var ex__11795__auto__ = e28997;
var statearr_28998_29033 = state_28952;
(statearr_28998_29033[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28952);

return cljs.core.cst$kw$recur;
} else {
throw e28997;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11793__auto__,cljs.core.cst$kw$recur)){
var G__29034 = state_28952;
state_28952 = G__29034;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$state_machine__11792__auto__ = function(state_28952){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11792__auto____1.call(this,state_28952);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11792__auto____0;
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11792__auto____1;
return cljs$core$async$state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___29004,mults,ensure_mult,p))
})();
var state__11858__auto__ = (function (){var statearr_28999 = (f__11857__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11857__auto__.cljs$core$IFn$_invoke$arity$0() : f__11857__auto__.call(null));
(statearr_28999[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___29004);

return statearr_28999;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11858__auto__);
});})(c__11856__auto___29004,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args29035 = [];
var len__7280__auto___29038 = arguments.length;
var i__7281__auto___29039 = (0);
while(true){
if((i__7281__auto___29039 < len__7280__auto___29038)){
args29035.push((arguments[i__7281__auto___29039]));

var G__29040 = (i__7281__auto___29039 + (1));
i__7281__auto___29039 = G__29040;
continue;
} else {
}
break;
}

var G__29037 = args29035.length;
switch (G__29037) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29035.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args29042 = [];
var len__7280__auto___29045 = arguments.length;
var i__7281__auto___29046 = (0);
while(true){
if((i__7281__auto___29046 < len__7280__auto___29045)){
args29042.push((arguments[i__7281__auto___29046]));

var G__29047 = (i__7281__auto___29046 + (1));
i__7281__auto___29046 = G__29047;
continue;
} else {
}
break;
}

var G__29044 = args29042.length;
switch (G__29044) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29042.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args29049 = [];
var len__7280__auto___29120 = arguments.length;
var i__7281__auto___29121 = (0);
while(true){
if((i__7281__auto___29121 < len__7280__auto___29120)){
args29049.push((arguments[i__7281__auto___29121]));

var G__29122 = (i__7281__auto___29121 + (1));
i__7281__auto___29121 = G__29122;
continue;
} else {
}
break;
}

var G__29051 = args29049.length;
switch (G__29051) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29049.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__11856__auto___29124 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11856__auto___29124,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___29124,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_29090){
var state_val_29091 = (state_29090[(1)]);
if((state_val_29091 === (7))){
var state_29090__$1 = state_29090;
var statearr_29092_29125 = state_29090__$1;
(statearr_29092_29125[(2)] = null);

(statearr_29092_29125[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29091 === (1))){
var state_29090__$1 = state_29090;
var statearr_29093_29126 = state_29090__$1;
(statearr_29093_29126[(2)] = null);

(statearr_29093_29126[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29091 === (4))){
var inst_29054 = (state_29090[(7)]);
var inst_29056 = (inst_29054 < cnt);
var state_29090__$1 = state_29090;
if(cljs.core.truth_(inst_29056)){
var statearr_29094_29127 = state_29090__$1;
(statearr_29094_29127[(1)] = (6));

} else {
var statearr_29095_29128 = state_29090__$1;
(statearr_29095_29128[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29091 === (15))){
var inst_29086 = (state_29090[(2)]);
var state_29090__$1 = state_29090;
var statearr_29096_29129 = state_29090__$1;
(statearr_29096_29129[(2)] = inst_29086);

(statearr_29096_29129[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29091 === (13))){
var inst_29079 = cljs.core.async.close_BANG_(out);
var state_29090__$1 = state_29090;
var statearr_29097_29130 = state_29090__$1;
(statearr_29097_29130[(2)] = inst_29079);

(statearr_29097_29130[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29091 === (6))){
var state_29090__$1 = state_29090;
var statearr_29098_29131 = state_29090__$1;
(statearr_29098_29131[(2)] = null);

(statearr_29098_29131[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29091 === (3))){
var inst_29088 = (state_29090[(2)]);
var state_29090__$1 = state_29090;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29090__$1,inst_29088);
} else {
if((state_val_29091 === (12))){
var inst_29076 = (state_29090[(8)]);
var inst_29076__$1 = (state_29090[(2)]);
var inst_29077 = cljs.core.some(cljs.core.nil_QMARK_,inst_29076__$1);
var state_29090__$1 = (function (){var statearr_29099 = state_29090;
(statearr_29099[(8)] = inst_29076__$1);

return statearr_29099;
})();
if(cljs.core.truth_(inst_29077)){
var statearr_29100_29132 = state_29090__$1;
(statearr_29100_29132[(1)] = (13));

} else {
var statearr_29101_29133 = state_29090__$1;
(statearr_29101_29133[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29091 === (2))){
var inst_29053 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_29054 = (0);
var state_29090__$1 = (function (){var statearr_29102 = state_29090;
(statearr_29102[(7)] = inst_29054);

(statearr_29102[(9)] = inst_29053);

return statearr_29102;
})();
var statearr_29103_29134 = state_29090__$1;
(statearr_29103_29134[(2)] = null);

(statearr_29103_29134[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29091 === (11))){
var inst_29054 = (state_29090[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_29090,(10),Object,null,(9));
var inst_29063 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_29054) : chs__$1.call(null,inst_29054));
var inst_29064 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_29054) : done.call(null,inst_29054));
var inst_29065 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_29063,inst_29064);
var state_29090__$1 = state_29090;
var statearr_29104_29135 = state_29090__$1;
(statearr_29104_29135[(2)] = inst_29065);


cljs.core.async.impl.ioc_helpers.process_exception(state_29090__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_29091 === (9))){
var inst_29054 = (state_29090[(7)]);
var inst_29067 = (state_29090[(2)]);
var inst_29068 = (inst_29054 + (1));
var inst_29054__$1 = inst_29068;
var state_29090__$1 = (function (){var statearr_29105 = state_29090;
(statearr_29105[(10)] = inst_29067);

(statearr_29105[(7)] = inst_29054__$1);

return statearr_29105;
})();
var statearr_29106_29136 = state_29090__$1;
(statearr_29106_29136[(2)] = null);

(statearr_29106_29136[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29091 === (5))){
var inst_29074 = (state_29090[(2)]);
var state_29090__$1 = (function (){var statearr_29107 = state_29090;
(statearr_29107[(11)] = inst_29074);

return statearr_29107;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29090__$1,(12),dchan);
} else {
if((state_val_29091 === (14))){
var inst_29076 = (state_29090[(8)]);
var inst_29081 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_29076);
var state_29090__$1 = state_29090;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29090__$1,(16),out,inst_29081);
} else {
if((state_val_29091 === (16))){
var inst_29083 = (state_29090[(2)]);
var state_29090__$1 = (function (){var statearr_29108 = state_29090;
(statearr_29108[(12)] = inst_29083);

return statearr_29108;
})();
var statearr_29109_29137 = state_29090__$1;
(statearr_29109_29137[(2)] = null);

(statearr_29109_29137[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29091 === (10))){
var inst_29058 = (state_29090[(2)]);
var inst_29059 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_29090__$1 = (function (){var statearr_29110 = state_29090;
(statearr_29110[(13)] = inst_29058);

return statearr_29110;
})();
var statearr_29111_29138 = state_29090__$1;
(statearr_29111_29138[(2)] = inst_29059);


cljs.core.async.impl.ioc_helpers.process_exception(state_29090__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_29091 === (8))){
var inst_29072 = (state_29090[(2)]);
var state_29090__$1 = state_29090;
var statearr_29112_29139 = state_29090__$1;
(statearr_29112_29139[(2)] = inst_29072);

(statearr_29112_29139[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto___29124,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__11791__auto__,c__11856__auto___29124,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__11792__auto__ = null;
var cljs$core$async$state_machine__11792__auto____0 = (function (){
var statearr_29116 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29116[(0)] = cljs$core$async$state_machine__11792__auto__);

(statearr_29116[(1)] = (1));

return statearr_29116;
});
var cljs$core$async$state_machine__11792__auto____1 = (function (state_29090){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__(state_29090);
if(cljs.core.keyword_identical_QMARK_(result__11794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e29117){if((e29117 instanceof Object)){
var ex__11795__auto__ = e29117;
var statearr_29118_29140 = state_29090;
(statearr_29118_29140[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29090);

return cljs.core.cst$kw$recur;
} else {
throw e29117;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11793__auto__,cljs.core.cst$kw$recur)){
var G__29141 = state_29090;
state_29090 = G__29141;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$state_machine__11792__auto__ = function(state_29090){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11792__auto____1.call(this,state_29090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11792__auto____0;
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11792__auto____1;
return cljs$core$async$state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___29124,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__11858__auto__ = (function (){var statearr_29119 = (f__11857__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11857__auto__.cljs$core$IFn$_invoke$arity$0() : f__11857__auto__.call(null));
(statearr_29119[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___29124);

return statearr_29119;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11858__auto__);
});})(c__11856__auto___29124,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args29143 = [];
var len__7280__auto___29199 = arguments.length;
var i__7281__auto___29200 = (0);
while(true){
if((i__7281__auto___29200 < len__7280__auto___29199)){
args29143.push((arguments[i__7281__auto___29200]));

var G__29201 = (i__7281__auto___29200 + (1));
i__7281__auto___29200 = G__29201;
continue;
} else {
}
break;
}

var G__29145 = args29143.length;
switch (G__29145) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29143.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11856__auto___29203 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11856__auto___29203,out){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___29203,out){
return (function (state_29175){
var state_val_29176 = (state_29175[(1)]);
if((state_val_29176 === (7))){
var inst_29155 = (state_29175[(7)]);
var inst_29154 = (state_29175[(8)]);
var inst_29154__$1 = (state_29175[(2)]);
var inst_29155__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29154__$1,(0),null);
var inst_29156 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29154__$1,(1),null);
var inst_29157 = (inst_29155__$1 == null);
var state_29175__$1 = (function (){var statearr_29177 = state_29175;
(statearr_29177[(7)] = inst_29155__$1);

(statearr_29177[(9)] = inst_29156);

(statearr_29177[(8)] = inst_29154__$1);

return statearr_29177;
})();
if(cljs.core.truth_(inst_29157)){
var statearr_29178_29204 = state_29175__$1;
(statearr_29178_29204[(1)] = (8));

} else {
var statearr_29179_29205 = state_29175__$1;
(statearr_29179_29205[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29176 === (1))){
var inst_29146 = cljs.core.vec(chs);
var inst_29147 = inst_29146;
var state_29175__$1 = (function (){var statearr_29180 = state_29175;
(statearr_29180[(10)] = inst_29147);

return statearr_29180;
})();
var statearr_29181_29206 = state_29175__$1;
(statearr_29181_29206[(2)] = null);

(statearr_29181_29206[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29176 === (4))){
var inst_29147 = (state_29175[(10)]);
var state_29175__$1 = state_29175;
return cljs.core.async.ioc_alts_BANG_(state_29175__$1,(7),inst_29147);
} else {
if((state_val_29176 === (6))){
var inst_29171 = (state_29175[(2)]);
var state_29175__$1 = state_29175;
var statearr_29182_29207 = state_29175__$1;
(statearr_29182_29207[(2)] = inst_29171);

(statearr_29182_29207[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29176 === (3))){
var inst_29173 = (state_29175[(2)]);
var state_29175__$1 = state_29175;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29175__$1,inst_29173);
} else {
if((state_val_29176 === (2))){
var inst_29147 = (state_29175[(10)]);
var inst_29149 = cljs.core.count(inst_29147);
var inst_29150 = (inst_29149 > (0));
var state_29175__$1 = state_29175;
if(cljs.core.truth_(inst_29150)){
var statearr_29184_29208 = state_29175__$1;
(statearr_29184_29208[(1)] = (4));

} else {
var statearr_29185_29209 = state_29175__$1;
(statearr_29185_29209[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29176 === (11))){
var inst_29147 = (state_29175[(10)]);
var inst_29164 = (state_29175[(2)]);
var tmp29183 = inst_29147;
var inst_29147__$1 = tmp29183;
var state_29175__$1 = (function (){var statearr_29186 = state_29175;
(statearr_29186[(10)] = inst_29147__$1);

(statearr_29186[(11)] = inst_29164);

return statearr_29186;
})();
var statearr_29187_29210 = state_29175__$1;
(statearr_29187_29210[(2)] = null);

(statearr_29187_29210[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29176 === (9))){
var inst_29155 = (state_29175[(7)]);
var state_29175__$1 = state_29175;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29175__$1,(11),out,inst_29155);
} else {
if((state_val_29176 === (5))){
var inst_29169 = cljs.core.async.close_BANG_(out);
var state_29175__$1 = state_29175;
var statearr_29188_29211 = state_29175__$1;
(statearr_29188_29211[(2)] = inst_29169);

(statearr_29188_29211[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29176 === (10))){
var inst_29167 = (state_29175[(2)]);
var state_29175__$1 = state_29175;
var statearr_29189_29212 = state_29175__$1;
(statearr_29189_29212[(2)] = inst_29167);

(statearr_29189_29212[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29176 === (8))){
var inst_29155 = (state_29175[(7)]);
var inst_29147 = (state_29175[(10)]);
var inst_29156 = (state_29175[(9)]);
var inst_29154 = (state_29175[(8)]);
var inst_29159 = (function (){var cs = inst_29147;
var vec__29152 = inst_29154;
var v = inst_29155;
var c = inst_29156;
return ((function (cs,vec__29152,v,c,inst_29155,inst_29147,inst_29156,inst_29154,state_val_29176,c__11856__auto___29203,out){
return (function (p1__29142_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__29142_SHARP_);
});
;})(cs,vec__29152,v,c,inst_29155,inst_29147,inst_29156,inst_29154,state_val_29176,c__11856__auto___29203,out))
})();
var inst_29160 = cljs.core.filterv(inst_29159,inst_29147);
var inst_29147__$1 = inst_29160;
var state_29175__$1 = (function (){var statearr_29190 = state_29175;
(statearr_29190[(10)] = inst_29147__$1);

return statearr_29190;
})();
var statearr_29191_29213 = state_29175__$1;
(statearr_29191_29213[(2)] = null);

(statearr_29191_29213[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto___29203,out))
;
return ((function (switch__11791__auto__,c__11856__auto___29203,out){
return (function() {
var cljs$core$async$state_machine__11792__auto__ = null;
var cljs$core$async$state_machine__11792__auto____0 = (function (){
var statearr_29195 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29195[(0)] = cljs$core$async$state_machine__11792__auto__);

(statearr_29195[(1)] = (1));

return statearr_29195;
});
var cljs$core$async$state_machine__11792__auto____1 = (function (state_29175){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__(state_29175);
if(cljs.core.keyword_identical_QMARK_(result__11794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e29196){if((e29196 instanceof Object)){
var ex__11795__auto__ = e29196;
var statearr_29197_29214 = state_29175;
(statearr_29197_29214[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29175);

return cljs.core.cst$kw$recur;
} else {
throw e29196;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11793__auto__,cljs.core.cst$kw$recur)){
var G__29215 = state_29175;
state_29175 = G__29215;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$state_machine__11792__auto__ = function(state_29175){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11792__auto____1.call(this,state_29175);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11792__auto____0;
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11792__auto____1;
return cljs$core$async$state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___29203,out))
})();
var state__11858__auto__ = (function (){var statearr_29198 = (f__11857__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11857__auto__.cljs$core$IFn$_invoke$arity$0() : f__11857__auto__.call(null));
(statearr_29198[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___29203);

return statearr_29198;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11858__auto__);
});})(c__11856__auto___29203,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args29216 = [];
var len__7280__auto___29265 = arguments.length;
var i__7281__auto___29266 = (0);
while(true){
if((i__7281__auto___29266 < len__7280__auto___29265)){
args29216.push((arguments[i__7281__auto___29266]));

var G__29267 = (i__7281__auto___29266 + (1));
i__7281__auto___29266 = G__29267;
continue;
} else {
}
break;
}

var G__29218 = args29216.length;
switch (G__29218) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29216.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11856__auto___29269 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11856__auto___29269,out){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___29269,out){
return (function (state_29242){
var state_val_29243 = (state_29242[(1)]);
if((state_val_29243 === (7))){
var inst_29224 = (state_29242[(7)]);
var inst_29224__$1 = (state_29242[(2)]);
var inst_29225 = (inst_29224__$1 == null);
var inst_29226 = cljs.core.not(inst_29225);
var state_29242__$1 = (function (){var statearr_29244 = state_29242;
(statearr_29244[(7)] = inst_29224__$1);

return statearr_29244;
})();
if(inst_29226){
var statearr_29245_29270 = state_29242__$1;
(statearr_29245_29270[(1)] = (8));

} else {
var statearr_29246_29271 = state_29242__$1;
(statearr_29246_29271[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29243 === (1))){
var inst_29219 = (0);
var state_29242__$1 = (function (){var statearr_29247 = state_29242;
(statearr_29247[(8)] = inst_29219);

return statearr_29247;
})();
var statearr_29248_29272 = state_29242__$1;
(statearr_29248_29272[(2)] = null);

(statearr_29248_29272[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29243 === (4))){
var state_29242__$1 = state_29242;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29242__$1,(7),ch);
} else {
if((state_val_29243 === (6))){
var inst_29237 = (state_29242[(2)]);
var state_29242__$1 = state_29242;
var statearr_29249_29273 = state_29242__$1;
(statearr_29249_29273[(2)] = inst_29237);

(statearr_29249_29273[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29243 === (3))){
var inst_29239 = (state_29242[(2)]);
var inst_29240 = cljs.core.async.close_BANG_(out);
var state_29242__$1 = (function (){var statearr_29250 = state_29242;
(statearr_29250[(9)] = inst_29239);

return statearr_29250;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_29242__$1,inst_29240);
} else {
if((state_val_29243 === (2))){
var inst_29219 = (state_29242[(8)]);
var inst_29221 = (inst_29219 < n);
var state_29242__$1 = state_29242;
if(cljs.core.truth_(inst_29221)){
var statearr_29251_29274 = state_29242__$1;
(statearr_29251_29274[(1)] = (4));

} else {
var statearr_29252_29275 = state_29242__$1;
(statearr_29252_29275[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29243 === (11))){
var inst_29219 = (state_29242[(8)]);
var inst_29229 = (state_29242[(2)]);
var inst_29230 = (inst_29219 + (1));
var inst_29219__$1 = inst_29230;
var state_29242__$1 = (function (){var statearr_29253 = state_29242;
(statearr_29253[(8)] = inst_29219__$1);

(statearr_29253[(10)] = inst_29229);

return statearr_29253;
})();
var statearr_29254_29276 = state_29242__$1;
(statearr_29254_29276[(2)] = null);

(statearr_29254_29276[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29243 === (9))){
var state_29242__$1 = state_29242;
var statearr_29255_29277 = state_29242__$1;
(statearr_29255_29277[(2)] = null);

(statearr_29255_29277[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29243 === (5))){
var state_29242__$1 = state_29242;
var statearr_29256_29278 = state_29242__$1;
(statearr_29256_29278[(2)] = null);

(statearr_29256_29278[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29243 === (10))){
var inst_29234 = (state_29242[(2)]);
var state_29242__$1 = state_29242;
var statearr_29257_29279 = state_29242__$1;
(statearr_29257_29279[(2)] = inst_29234);

(statearr_29257_29279[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29243 === (8))){
var inst_29224 = (state_29242[(7)]);
var state_29242__$1 = state_29242;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29242__$1,(11),out,inst_29224);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto___29269,out))
;
return ((function (switch__11791__auto__,c__11856__auto___29269,out){
return (function() {
var cljs$core$async$state_machine__11792__auto__ = null;
var cljs$core$async$state_machine__11792__auto____0 = (function (){
var statearr_29261 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29261[(0)] = cljs$core$async$state_machine__11792__auto__);

(statearr_29261[(1)] = (1));

return statearr_29261;
});
var cljs$core$async$state_machine__11792__auto____1 = (function (state_29242){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__(state_29242);
if(cljs.core.keyword_identical_QMARK_(result__11794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e29262){if((e29262 instanceof Object)){
var ex__11795__auto__ = e29262;
var statearr_29263_29280 = state_29242;
(statearr_29263_29280[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29242);

return cljs.core.cst$kw$recur;
} else {
throw e29262;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11793__auto__,cljs.core.cst$kw$recur)){
var G__29281 = state_29242;
state_29242 = G__29281;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$state_machine__11792__auto__ = function(state_29242){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11792__auto____1.call(this,state_29242);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11792__auto____0;
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11792__auto____1;
return cljs$core$async$state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___29269,out))
})();
var state__11858__auto__ = (function (){var statearr_29264 = (f__11857__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11857__auto__.cljs$core$IFn$_invoke$arity$0() : f__11857__auto__.call(null));
(statearr_29264[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___29269);

return statearr_29264;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11858__auto__);
});})(c__11856__auto___29269,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async29291 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29291 = (function (map_LT_,f,ch,meta29292){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta29292 = meta29292;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29291.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29293,meta29292__$1){
var self__ = this;
var _29293__$1 = this;
return (new cljs.core.async.t_cljs$core$async29291(self__.map_LT_,self__.f,self__.ch,meta29292__$1));
});

cljs.core.async.t_cljs$core$async29291.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29293){
var self__ = this;
var _29293__$1 = this;
return self__.meta29292;
});

cljs.core.async.t_cljs$core$async29291.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async29291.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async29291.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async29291.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async29291.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async29294 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29294 = (function (map_LT_,f,ch,meta29292,_,fn1,meta29295){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta29292 = meta29292;
this._ = _;
this.fn1 = fn1;
this.meta29295 = meta29295;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29294.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_29296,meta29295__$1){
var self__ = this;
var _29296__$1 = this;
return (new cljs.core.async.t_cljs$core$async29294(self__.map_LT_,self__.f,self__.ch,self__.meta29292,self__._,self__.fn1,meta29295__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async29294.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_29296){
var self__ = this;
var _29296__$1 = this;
return self__.meta29295;
});})(___$1))
;

cljs.core.async.t_cljs$core$async29294.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async29294.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async29294.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async29294.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__29282_SHARP_){
var G__29297 = (((p1__29282_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__29282_SHARP_) : self__.f.call(null,p1__29282_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__29297) : f1.call(null,G__29297));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async29294.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta29292,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async29291], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta29295], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async29294.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29294.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29294";

cljs.core.async.t_cljs$core$async29294.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"cljs.core.async/t_cljs$core$async29294");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async29294 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async29294(map_LT___$1,f__$1,ch__$1,meta29292__$1,___$2,fn1__$1,meta29295){
return (new cljs.core.async.t_cljs$core$async29294(map_LT___$1,f__$1,ch__$1,meta29292__$1,___$2,fn1__$1,meta29295));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async29294(self__.map_LT_,self__.f,self__.ch,self__.meta29292,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6198__auto__ = ret;
if(cljs.core.truth_(and__6198__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__6198__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__29298 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__29298) : self__.f.call(null,G__29298));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async29291.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async29291.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async29291.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta29292], null);
});

cljs.core.async.t_cljs$core$async29291.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29291.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29291";

cljs.core.async.t_cljs$core$async29291.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"cljs.core.async/t_cljs$core$async29291");
});

cljs.core.async.__GT_t_cljs$core$async29291 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async29291(map_LT___$1,f__$1,ch__$1,meta29292){
return (new cljs.core.async.t_cljs$core$async29291(map_LT___$1,f__$1,ch__$1,meta29292));
});

}

return (new cljs.core.async.t_cljs$core$async29291(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async29302 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29302 = (function (map_GT_,f,ch,meta29303){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta29303 = meta29303;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29302.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29304,meta29303__$1){
var self__ = this;
var _29304__$1 = this;
return (new cljs.core.async.t_cljs$core$async29302(self__.map_GT_,self__.f,self__.ch,meta29303__$1));
});

cljs.core.async.t_cljs$core$async29302.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29304){
var self__ = this;
var _29304__$1 = this;
return self__.meta29303;
});

cljs.core.async.t_cljs$core$async29302.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async29302.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async29302.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async29302.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async29302.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async29302.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async29302.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta29303], null);
});

cljs.core.async.t_cljs$core$async29302.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29302.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29302";

cljs.core.async.t_cljs$core$async29302.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"cljs.core.async/t_cljs$core$async29302");
});

cljs.core.async.__GT_t_cljs$core$async29302 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async29302(map_GT___$1,f__$1,ch__$1,meta29303){
return (new cljs.core.async.t_cljs$core$async29302(map_GT___$1,f__$1,ch__$1,meta29303));
});

}

return (new cljs.core.async.t_cljs$core$async29302(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async29308 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29308 = (function (filter_GT_,p,ch,meta29309){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta29309 = meta29309;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29308.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29310,meta29309__$1){
var self__ = this;
var _29310__$1 = this;
return (new cljs.core.async.t_cljs$core$async29308(self__.filter_GT_,self__.p,self__.ch,meta29309__$1));
});

cljs.core.async.t_cljs$core$async29308.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29310){
var self__ = this;
var _29310__$1 = this;
return self__.meta29309;
});

cljs.core.async.t_cljs$core$async29308.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async29308.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async29308.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async29308.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async29308.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async29308.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async29308.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async29308.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$filter_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta29309], null);
});

cljs.core.async.t_cljs$core$async29308.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29308.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29308";

cljs.core.async.t_cljs$core$async29308.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"cljs.core.async/t_cljs$core$async29308");
});

cljs.core.async.__GT_t_cljs$core$async29308 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async29308(filter_GT___$1,p__$1,ch__$1,meta29309){
return (new cljs.core.async.t_cljs$core$async29308(filter_GT___$1,p__$1,ch__$1,meta29309));
});

}

return (new cljs.core.async.t_cljs$core$async29308(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args29311 = [];
var len__7280__auto___29355 = arguments.length;
var i__7281__auto___29356 = (0);
while(true){
if((i__7281__auto___29356 < len__7280__auto___29355)){
args29311.push((arguments[i__7281__auto___29356]));

var G__29357 = (i__7281__auto___29356 + (1));
i__7281__auto___29356 = G__29357;
continue;
} else {
}
break;
}

var G__29313 = args29311.length;
switch (G__29313) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29311.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11856__auto___29359 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11856__auto___29359,out){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___29359,out){
return (function (state_29334){
var state_val_29335 = (state_29334[(1)]);
if((state_val_29335 === (7))){
var inst_29330 = (state_29334[(2)]);
var state_29334__$1 = state_29334;
var statearr_29336_29360 = state_29334__$1;
(statearr_29336_29360[(2)] = inst_29330);

(statearr_29336_29360[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29335 === (1))){
var state_29334__$1 = state_29334;
var statearr_29337_29361 = state_29334__$1;
(statearr_29337_29361[(2)] = null);

(statearr_29337_29361[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29335 === (4))){
var inst_29316 = (state_29334[(7)]);
var inst_29316__$1 = (state_29334[(2)]);
var inst_29317 = (inst_29316__$1 == null);
var state_29334__$1 = (function (){var statearr_29338 = state_29334;
(statearr_29338[(7)] = inst_29316__$1);

return statearr_29338;
})();
if(cljs.core.truth_(inst_29317)){
var statearr_29339_29362 = state_29334__$1;
(statearr_29339_29362[(1)] = (5));

} else {
var statearr_29340_29363 = state_29334__$1;
(statearr_29340_29363[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29335 === (6))){
var inst_29316 = (state_29334[(7)]);
var inst_29321 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_29316) : p.call(null,inst_29316));
var state_29334__$1 = state_29334;
if(cljs.core.truth_(inst_29321)){
var statearr_29341_29364 = state_29334__$1;
(statearr_29341_29364[(1)] = (8));

} else {
var statearr_29342_29365 = state_29334__$1;
(statearr_29342_29365[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29335 === (3))){
var inst_29332 = (state_29334[(2)]);
var state_29334__$1 = state_29334;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29334__$1,inst_29332);
} else {
if((state_val_29335 === (2))){
var state_29334__$1 = state_29334;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29334__$1,(4),ch);
} else {
if((state_val_29335 === (11))){
var inst_29324 = (state_29334[(2)]);
var state_29334__$1 = state_29334;
var statearr_29343_29366 = state_29334__$1;
(statearr_29343_29366[(2)] = inst_29324);

(statearr_29343_29366[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29335 === (9))){
var state_29334__$1 = state_29334;
var statearr_29344_29367 = state_29334__$1;
(statearr_29344_29367[(2)] = null);

(statearr_29344_29367[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29335 === (5))){
var inst_29319 = cljs.core.async.close_BANG_(out);
var state_29334__$1 = state_29334;
var statearr_29345_29368 = state_29334__$1;
(statearr_29345_29368[(2)] = inst_29319);

(statearr_29345_29368[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29335 === (10))){
var inst_29327 = (state_29334[(2)]);
var state_29334__$1 = (function (){var statearr_29346 = state_29334;
(statearr_29346[(8)] = inst_29327);

return statearr_29346;
})();
var statearr_29347_29369 = state_29334__$1;
(statearr_29347_29369[(2)] = null);

(statearr_29347_29369[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29335 === (8))){
var inst_29316 = (state_29334[(7)]);
var state_29334__$1 = state_29334;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29334__$1,(11),out,inst_29316);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto___29359,out))
;
return ((function (switch__11791__auto__,c__11856__auto___29359,out){
return (function() {
var cljs$core$async$state_machine__11792__auto__ = null;
var cljs$core$async$state_machine__11792__auto____0 = (function (){
var statearr_29351 = [null,null,null,null,null,null,null,null,null];
(statearr_29351[(0)] = cljs$core$async$state_machine__11792__auto__);

(statearr_29351[(1)] = (1));

return statearr_29351;
});
var cljs$core$async$state_machine__11792__auto____1 = (function (state_29334){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__(state_29334);
if(cljs.core.keyword_identical_QMARK_(result__11794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e29352){if((e29352 instanceof Object)){
var ex__11795__auto__ = e29352;
var statearr_29353_29370 = state_29334;
(statearr_29353_29370[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29334);

return cljs.core.cst$kw$recur;
} else {
throw e29352;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11793__auto__,cljs.core.cst$kw$recur)){
var G__29371 = state_29334;
state_29334 = G__29371;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$state_machine__11792__auto__ = function(state_29334){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11792__auto____1.call(this,state_29334);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11792__auto____0;
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11792__auto____1;
return cljs$core$async$state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___29359,out))
})();
var state__11858__auto__ = (function (){var statearr_29354 = (f__11857__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11857__auto__.cljs$core$IFn$_invoke$arity$0() : f__11857__auto__.call(null));
(statearr_29354[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___29359);

return statearr_29354;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11858__auto__);
});})(c__11856__auto___29359,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args29372 = [];
var len__7280__auto___29375 = arguments.length;
var i__7281__auto___29376 = (0);
while(true){
if((i__7281__auto___29376 < len__7280__auto___29375)){
args29372.push((arguments[i__7281__auto___29376]));

var G__29377 = (i__7281__auto___29376 + (1));
i__7281__auto___29376 = G__29377;
continue;
} else {
}
break;
}

var G__29374 = args29372.length;
switch (G__29374) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29372.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11856__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11856__auto__){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto__){
return (function (state_29544){
var state_val_29545 = (state_29544[(1)]);
if((state_val_29545 === (7))){
var inst_29540 = (state_29544[(2)]);
var state_29544__$1 = state_29544;
var statearr_29546_29587 = state_29544__$1;
(statearr_29546_29587[(2)] = inst_29540);

(statearr_29546_29587[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29545 === (20))){
var inst_29510 = (state_29544[(7)]);
var inst_29521 = (state_29544[(2)]);
var inst_29522 = cljs.core.next(inst_29510);
var inst_29496 = inst_29522;
var inst_29497 = null;
var inst_29498 = (0);
var inst_29499 = (0);
var state_29544__$1 = (function (){var statearr_29547 = state_29544;
(statearr_29547[(8)] = inst_29521);

(statearr_29547[(9)] = inst_29497);

(statearr_29547[(10)] = inst_29498);

(statearr_29547[(11)] = inst_29496);

(statearr_29547[(12)] = inst_29499);

return statearr_29547;
})();
var statearr_29548_29588 = state_29544__$1;
(statearr_29548_29588[(2)] = null);

(statearr_29548_29588[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29545 === (1))){
var state_29544__$1 = state_29544;
var statearr_29549_29589 = state_29544__$1;
(statearr_29549_29589[(2)] = null);

(statearr_29549_29589[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29545 === (4))){
var inst_29485 = (state_29544[(13)]);
var inst_29485__$1 = (state_29544[(2)]);
var inst_29486 = (inst_29485__$1 == null);
var state_29544__$1 = (function (){var statearr_29550 = state_29544;
(statearr_29550[(13)] = inst_29485__$1);

return statearr_29550;
})();
if(cljs.core.truth_(inst_29486)){
var statearr_29551_29590 = state_29544__$1;
(statearr_29551_29590[(1)] = (5));

} else {
var statearr_29552_29591 = state_29544__$1;
(statearr_29552_29591[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29545 === (15))){
var state_29544__$1 = state_29544;
var statearr_29556_29592 = state_29544__$1;
(statearr_29556_29592[(2)] = null);

(statearr_29556_29592[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29545 === (21))){
var state_29544__$1 = state_29544;
var statearr_29557_29593 = state_29544__$1;
(statearr_29557_29593[(2)] = null);

(statearr_29557_29593[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29545 === (13))){
var inst_29497 = (state_29544[(9)]);
var inst_29498 = (state_29544[(10)]);
var inst_29496 = (state_29544[(11)]);
var inst_29499 = (state_29544[(12)]);
var inst_29506 = (state_29544[(2)]);
var inst_29507 = (inst_29499 + (1));
var tmp29553 = inst_29497;
var tmp29554 = inst_29498;
var tmp29555 = inst_29496;
var inst_29496__$1 = tmp29555;
var inst_29497__$1 = tmp29553;
var inst_29498__$1 = tmp29554;
var inst_29499__$1 = inst_29507;
var state_29544__$1 = (function (){var statearr_29558 = state_29544;
(statearr_29558[(9)] = inst_29497__$1);

(statearr_29558[(14)] = inst_29506);

(statearr_29558[(10)] = inst_29498__$1);

(statearr_29558[(11)] = inst_29496__$1);

(statearr_29558[(12)] = inst_29499__$1);

return statearr_29558;
})();
var statearr_29559_29594 = state_29544__$1;
(statearr_29559_29594[(2)] = null);

(statearr_29559_29594[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29545 === (22))){
var state_29544__$1 = state_29544;
var statearr_29560_29595 = state_29544__$1;
(statearr_29560_29595[(2)] = null);

(statearr_29560_29595[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29545 === (6))){
var inst_29485 = (state_29544[(13)]);
var inst_29494 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_29485) : f.call(null,inst_29485));
var inst_29495 = cljs.core.seq(inst_29494);
var inst_29496 = inst_29495;
var inst_29497 = null;
var inst_29498 = (0);
var inst_29499 = (0);
var state_29544__$1 = (function (){var statearr_29561 = state_29544;
(statearr_29561[(9)] = inst_29497);

(statearr_29561[(10)] = inst_29498);

(statearr_29561[(11)] = inst_29496);

(statearr_29561[(12)] = inst_29499);

return statearr_29561;
})();
var statearr_29562_29596 = state_29544__$1;
(statearr_29562_29596[(2)] = null);

(statearr_29562_29596[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29545 === (17))){
var inst_29510 = (state_29544[(7)]);
var inst_29514 = cljs.core.chunk_first(inst_29510);
var inst_29515 = cljs.core.chunk_rest(inst_29510);
var inst_29516 = cljs.core.count(inst_29514);
var inst_29496 = inst_29515;
var inst_29497 = inst_29514;
var inst_29498 = inst_29516;
var inst_29499 = (0);
var state_29544__$1 = (function (){var statearr_29563 = state_29544;
(statearr_29563[(9)] = inst_29497);

(statearr_29563[(10)] = inst_29498);

(statearr_29563[(11)] = inst_29496);

(statearr_29563[(12)] = inst_29499);

return statearr_29563;
})();
var statearr_29564_29597 = state_29544__$1;
(statearr_29564_29597[(2)] = null);

(statearr_29564_29597[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29545 === (3))){
var inst_29542 = (state_29544[(2)]);
var state_29544__$1 = state_29544;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29544__$1,inst_29542);
} else {
if((state_val_29545 === (12))){
var inst_29530 = (state_29544[(2)]);
var state_29544__$1 = state_29544;
var statearr_29565_29598 = state_29544__$1;
(statearr_29565_29598[(2)] = inst_29530);

(statearr_29565_29598[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29545 === (2))){
var state_29544__$1 = state_29544;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29544__$1,(4),in$);
} else {
if((state_val_29545 === (23))){
var inst_29538 = (state_29544[(2)]);
var state_29544__$1 = state_29544;
var statearr_29566_29599 = state_29544__$1;
(statearr_29566_29599[(2)] = inst_29538);

(statearr_29566_29599[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29545 === (19))){
var inst_29525 = (state_29544[(2)]);
var state_29544__$1 = state_29544;
var statearr_29567_29600 = state_29544__$1;
(statearr_29567_29600[(2)] = inst_29525);

(statearr_29567_29600[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29545 === (11))){
var inst_29496 = (state_29544[(11)]);
var inst_29510 = (state_29544[(7)]);
var inst_29510__$1 = cljs.core.seq(inst_29496);
var state_29544__$1 = (function (){var statearr_29568 = state_29544;
(statearr_29568[(7)] = inst_29510__$1);

return statearr_29568;
})();
if(inst_29510__$1){
var statearr_29569_29601 = state_29544__$1;
(statearr_29569_29601[(1)] = (14));

} else {
var statearr_29570_29602 = state_29544__$1;
(statearr_29570_29602[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29545 === (9))){
var inst_29532 = (state_29544[(2)]);
var inst_29533 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_29544__$1 = (function (){var statearr_29571 = state_29544;
(statearr_29571[(15)] = inst_29532);

return statearr_29571;
})();
if(cljs.core.truth_(inst_29533)){
var statearr_29572_29603 = state_29544__$1;
(statearr_29572_29603[(1)] = (21));

} else {
var statearr_29573_29604 = state_29544__$1;
(statearr_29573_29604[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29545 === (5))){
var inst_29488 = cljs.core.async.close_BANG_(out);
var state_29544__$1 = state_29544;
var statearr_29574_29605 = state_29544__$1;
(statearr_29574_29605[(2)] = inst_29488);

(statearr_29574_29605[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29545 === (14))){
var inst_29510 = (state_29544[(7)]);
var inst_29512 = cljs.core.chunked_seq_QMARK_(inst_29510);
var state_29544__$1 = state_29544;
if(inst_29512){
var statearr_29575_29606 = state_29544__$1;
(statearr_29575_29606[(1)] = (17));

} else {
var statearr_29576_29607 = state_29544__$1;
(statearr_29576_29607[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29545 === (16))){
var inst_29528 = (state_29544[(2)]);
var state_29544__$1 = state_29544;
var statearr_29577_29608 = state_29544__$1;
(statearr_29577_29608[(2)] = inst_29528);

(statearr_29577_29608[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29545 === (10))){
var inst_29497 = (state_29544[(9)]);
var inst_29499 = (state_29544[(12)]);
var inst_29504 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_29497,inst_29499);
var state_29544__$1 = state_29544;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29544__$1,(13),out,inst_29504);
} else {
if((state_val_29545 === (18))){
var inst_29510 = (state_29544[(7)]);
var inst_29519 = cljs.core.first(inst_29510);
var state_29544__$1 = state_29544;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29544__$1,(20),out,inst_29519);
} else {
if((state_val_29545 === (8))){
var inst_29498 = (state_29544[(10)]);
var inst_29499 = (state_29544[(12)]);
var inst_29501 = (inst_29499 < inst_29498);
var inst_29502 = inst_29501;
var state_29544__$1 = state_29544;
if(cljs.core.truth_(inst_29502)){
var statearr_29578_29609 = state_29544__$1;
(statearr_29578_29609[(1)] = (10));

} else {
var statearr_29579_29610 = state_29544__$1;
(statearr_29579_29610[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto__))
;
return ((function (switch__11791__auto__,c__11856__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__11792__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__11792__auto____0 = (function (){
var statearr_29583 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29583[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__11792__auto__);

(statearr_29583[(1)] = (1));

return statearr_29583;
});
var cljs$core$async$mapcat_STAR__$_state_machine__11792__auto____1 = (function (state_29544){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__(state_29544);
if(cljs.core.keyword_identical_QMARK_(result__11794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e29584){if((e29584 instanceof Object)){
var ex__11795__auto__ = e29584;
var statearr_29585_29611 = state_29544;
(statearr_29585_29611[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29544);

return cljs.core.cst$kw$recur;
} else {
throw e29584;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11793__auto__,cljs.core.cst$kw$recur)){
var G__29612 = state_29544;
state_29544 = G__29612;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__11792__auto__ = function(state_29544){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__11792__auto____1.call(this,state_29544);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__11792__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__11792__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto__))
})();
var state__11858__auto__ = (function (){var statearr_29586 = (f__11857__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11857__auto__.cljs$core$IFn$_invoke$arity$0() : f__11857__auto__.call(null));
(statearr_29586[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto__);

return statearr_29586;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11858__auto__);
});})(c__11856__auto__))
);

return c__11856__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args29613 = [];
var len__7280__auto___29616 = arguments.length;
var i__7281__auto___29617 = (0);
while(true){
if((i__7281__auto___29617 < len__7280__auto___29616)){
args29613.push((arguments[i__7281__auto___29617]));

var G__29618 = (i__7281__auto___29617 + (1));
i__7281__auto___29617 = G__29618;
continue;
} else {
}
break;
}

var G__29615 = args29613.length;
switch (G__29615) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29613.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args29620 = [];
var len__7280__auto___29623 = arguments.length;
var i__7281__auto___29624 = (0);
while(true){
if((i__7281__auto___29624 < len__7280__auto___29623)){
args29620.push((arguments[i__7281__auto___29624]));

var G__29625 = (i__7281__auto___29624 + (1));
i__7281__auto___29624 = G__29625;
continue;
} else {
}
break;
}

var G__29622 = args29620.length;
switch (G__29622) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29620.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args29627 = [];
var len__7280__auto___29678 = arguments.length;
var i__7281__auto___29679 = (0);
while(true){
if((i__7281__auto___29679 < len__7280__auto___29678)){
args29627.push((arguments[i__7281__auto___29679]));

var G__29680 = (i__7281__auto___29679 + (1));
i__7281__auto___29679 = G__29680;
continue;
} else {
}
break;
}

var G__29629 = args29627.length;
switch (G__29629) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29627.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11856__auto___29682 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11856__auto___29682,out){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___29682,out){
return (function (state_29653){
var state_val_29654 = (state_29653[(1)]);
if((state_val_29654 === (7))){
var inst_29648 = (state_29653[(2)]);
var state_29653__$1 = state_29653;
var statearr_29655_29683 = state_29653__$1;
(statearr_29655_29683[(2)] = inst_29648);

(statearr_29655_29683[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29654 === (1))){
var inst_29630 = null;
var state_29653__$1 = (function (){var statearr_29656 = state_29653;
(statearr_29656[(7)] = inst_29630);

return statearr_29656;
})();
var statearr_29657_29684 = state_29653__$1;
(statearr_29657_29684[(2)] = null);

(statearr_29657_29684[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29654 === (4))){
var inst_29633 = (state_29653[(8)]);
var inst_29633__$1 = (state_29653[(2)]);
var inst_29634 = (inst_29633__$1 == null);
var inst_29635 = cljs.core.not(inst_29634);
var state_29653__$1 = (function (){var statearr_29658 = state_29653;
(statearr_29658[(8)] = inst_29633__$1);

return statearr_29658;
})();
if(inst_29635){
var statearr_29659_29685 = state_29653__$1;
(statearr_29659_29685[(1)] = (5));

} else {
var statearr_29660_29686 = state_29653__$1;
(statearr_29660_29686[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29654 === (6))){
var state_29653__$1 = state_29653;
var statearr_29661_29687 = state_29653__$1;
(statearr_29661_29687[(2)] = null);

(statearr_29661_29687[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29654 === (3))){
var inst_29650 = (state_29653[(2)]);
var inst_29651 = cljs.core.async.close_BANG_(out);
var state_29653__$1 = (function (){var statearr_29662 = state_29653;
(statearr_29662[(9)] = inst_29650);

return statearr_29662;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_29653__$1,inst_29651);
} else {
if((state_val_29654 === (2))){
var state_29653__$1 = state_29653;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29653__$1,(4),ch);
} else {
if((state_val_29654 === (11))){
var inst_29633 = (state_29653[(8)]);
var inst_29642 = (state_29653[(2)]);
var inst_29630 = inst_29633;
var state_29653__$1 = (function (){var statearr_29663 = state_29653;
(statearr_29663[(10)] = inst_29642);

(statearr_29663[(7)] = inst_29630);

return statearr_29663;
})();
var statearr_29664_29688 = state_29653__$1;
(statearr_29664_29688[(2)] = null);

(statearr_29664_29688[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29654 === (9))){
var inst_29633 = (state_29653[(8)]);
var state_29653__$1 = state_29653;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29653__$1,(11),out,inst_29633);
} else {
if((state_val_29654 === (5))){
var inst_29630 = (state_29653[(7)]);
var inst_29633 = (state_29653[(8)]);
var inst_29637 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29633,inst_29630);
var state_29653__$1 = state_29653;
if(inst_29637){
var statearr_29666_29689 = state_29653__$1;
(statearr_29666_29689[(1)] = (8));

} else {
var statearr_29667_29690 = state_29653__$1;
(statearr_29667_29690[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29654 === (10))){
var inst_29645 = (state_29653[(2)]);
var state_29653__$1 = state_29653;
var statearr_29668_29691 = state_29653__$1;
(statearr_29668_29691[(2)] = inst_29645);

(statearr_29668_29691[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29654 === (8))){
var inst_29630 = (state_29653[(7)]);
var tmp29665 = inst_29630;
var inst_29630__$1 = tmp29665;
var state_29653__$1 = (function (){var statearr_29669 = state_29653;
(statearr_29669[(7)] = inst_29630__$1);

return statearr_29669;
})();
var statearr_29670_29692 = state_29653__$1;
(statearr_29670_29692[(2)] = null);

(statearr_29670_29692[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto___29682,out))
;
return ((function (switch__11791__auto__,c__11856__auto___29682,out){
return (function() {
var cljs$core$async$state_machine__11792__auto__ = null;
var cljs$core$async$state_machine__11792__auto____0 = (function (){
var statearr_29674 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29674[(0)] = cljs$core$async$state_machine__11792__auto__);

(statearr_29674[(1)] = (1));

return statearr_29674;
});
var cljs$core$async$state_machine__11792__auto____1 = (function (state_29653){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__(state_29653);
if(cljs.core.keyword_identical_QMARK_(result__11794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e29675){if((e29675 instanceof Object)){
var ex__11795__auto__ = e29675;
var statearr_29676_29693 = state_29653;
(statearr_29676_29693[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29653);

return cljs.core.cst$kw$recur;
} else {
throw e29675;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11793__auto__,cljs.core.cst$kw$recur)){
var G__29694 = state_29653;
state_29653 = G__29694;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$state_machine__11792__auto__ = function(state_29653){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11792__auto____1.call(this,state_29653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11792__auto____0;
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11792__auto____1;
return cljs$core$async$state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___29682,out))
})();
var state__11858__auto__ = (function (){var statearr_29677 = (f__11857__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11857__auto__.cljs$core$IFn$_invoke$arity$0() : f__11857__auto__.call(null));
(statearr_29677[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___29682);

return statearr_29677;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11858__auto__);
});})(c__11856__auto___29682,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args29695 = [];
var len__7280__auto___29765 = arguments.length;
var i__7281__auto___29766 = (0);
while(true){
if((i__7281__auto___29766 < len__7280__auto___29765)){
args29695.push((arguments[i__7281__auto___29766]));

var G__29767 = (i__7281__auto___29766 + (1));
i__7281__auto___29766 = G__29767;
continue;
} else {
}
break;
}

var G__29697 = args29695.length;
switch (G__29697) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29695.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11856__auto___29769 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11856__auto___29769,out){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___29769,out){
return (function (state_29735){
var state_val_29736 = (state_29735[(1)]);
if((state_val_29736 === (7))){
var inst_29731 = (state_29735[(2)]);
var state_29735__$1 = state_29735;
var statearr_29737_29770 = state_29735__$1;
(statearr_29737_29770[(2)] = inst_29731);

(statearr_29737_29770[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29736 === (1))){
var inst_29698 = (new Array(n));
var inst_29699 = inst_29698;
var inst_29700 = (0);
var state_29735__$1 = (function (){var statearr_29738 = state_29735;
(statearr_29738[(7)] = inst_29700);

(statearr_29738[(8)] = inst_29699);

return statearr_29738;
})();
var statearr_29739_29771 = state_29735__$1;
(statearr_29739_29771[(2)] = null);

(statearr_29739_29771[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29736 === (4))){
var inst_29703 = (state_29735[(9)]);
var inst_29703__$1 = (state_29735[(2)]);
var inst_29704 = (inst_29703__$1 == null);
var inst_29705 = cljs.core.not(inst_29704);
var state_29735__$1 = (function (){var statearr_29740 = state_29735;
(statearr_29740[(9)] = inst_29703__$1);

return statearr_29740;
})();
if(inst_29705){
var statearr_29741_29772 = state_29735__$1;
(statearr_29741_29772[(1)] = (5));

} else {
var statearr_29742_29773 = state_29735__$1;
(statearr_29742_29773[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29736 === (15))){
var inst_29725 = (state_29735[(2)]);
var state_29735__$1 = state_29735;
var statearr_29743_29774 = state_29735__$1;
(statearr_29743_29774[(2)] = inst_29725);

(statearr_29743_29774[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29736 === (13))){
var state_29735__$1 = state_29735;
var statearr_29744_29775 = state_29735__$1;
(statearr_29744_29775[(2)] = null);

(statearr_29744_29775[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29736 === (6))){
var inst_29700 = (state_29735[(7)]);
var inst_29721 = (inst_29700 > (0));
var state_29735__$1 = state_29735;
if(cljs.core.truth_(inst_29721)){
var statearr_29745_29776 = state_29735__$1;
(statearr_29745_29776[(1)] = (12));

} else {
var statearr_29746_29777 = state_29735__$1;
(statearr_29746_29777[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29736 === (3))){
var inst_29733 = (state_29735[(2)]);
var state_29735__$1 = state_29735;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29735__$1,inst_29733);
} else {
if((state_val_29736 === (12))){
var inst_29699 = (state_29735[(8)]);
var inst_29723 = cljs.core.vec(inst_29699);
var state_29735__$1 = state_29735;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29735__$1,(15),out,inst_29723);
} else {
if((state_val_29736 === (2))){
var state_29735__$1 = state_29735;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29735__$1,(4),ch);
} else {
if((state_val_29736 === (11))){
var inst_29715 = (state_29735[(2)]);
var inst_29716 = (new Array(n));
var inst_29699 = inst_29716;
var inst_29700 = (0);
var state_29735__$1 = (function (){var statearr_29747 = state_29735;
(statearr_29747[(10)] = inst_29715);

(statearr_29747[(7)] = inst_29700);

(statearr_29747[(8)] = inst_29699);

return statearr_29747;
})();
var statearr_29748_29778 = state_29735__$1;
(statearr_29748_29778[(2)] = null);

(statearr_29748_29778[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29736 === (9))){
var inst_29699 = (state_29735[(8)]);
var inst_29713 = cljs.core.vec(inst_29699);
var state_29735__$1 = state_29735;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29735__$1,(11),out,inst_29713);
} else {
if((state_val_29736 === (5))){
var inst_29708 = (state_29735[(11)]);
var inst_29703 = (state_29735[(9)]);
var inst_29700 = (state_29735[(7)]);
var inst_29699 = (state_29735[(8)]);
var inst_29707 = (inst_29699[inst_29700] = inst_29703);
var inst_29708__$1 = (inst_29700 + (1));
var inst_29709 = (inst_29708__$1 < n);
var state_29735__$1 = (function (){var statearr_29749 = state_29735;
(statearr_29749[(11)] = inst_29708__$1);

(statearr_29749[(12)] = inst_29707);

return statearr_29749;
})();
if(cljs.core.truth_(inst_29709)){
var statearr_29750_29779 = state_29735__$1;
(statearr_29750_29779[(1)] = (8));

} else {
var statearr_29751_29780 = state_29735__$1;
(statearr_29751_29780[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29736 === (14))){
var inst_29728 = (state_29735[(2)]);
var inst_29729 = cljs.core.async.close_BANG_(out);
var state_29735__$1 = (function (){var statearr_29753 = state_29735;
(statearr_29753[(13)] = inst_29728);

return statearr_29753;
})();
var statearr_29754_29781 = state_29735__$1;
(statearr_29754_29781[(2)] = inst_29729);

(statearr_29754_29781[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29736 === (10))){
var inst_29719 = (state_29735[(2)]);
var state_29735__$1 = state_29735;
var statearr_29755_29782 = state_29735__$1;
(statearr_29755_29782[(2)] = inst_29719);

(statearr_29755_29782[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29736 === (8))){
var inst_29708 = (state_29735[(11)]);
var inst_29699 = (state_29735[(8)]);
var tmp29752 = inst_29699;
var inst_29699__$1 = tmp29752;
var inst_29700 = inst_29708;
var state_29735__$1 = (function (){var statearr_29756 = state_29735;
(statearr_29756[(7)] = inst_29700);

(statearr_29756[(8)] = inst_29699__$1);

return statearr_29756;
})();
var statearr_29757_29783 = state_29735__$1;
(statearr_29757_29783[(2)] = null);

(statearr_29757_29783[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto___29769,out))
;
return ((function (switch__11791__auto__,c__11856__auto___29769,out){
return (function() {
var cljs$core$async$state_machine__11792__auto__ = null;
var cljs$core$async$state_machine__11792__auto____0 = (function (){
var statearr_29761 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29761[(0)] = cljs$core$async$state_machine__11792__auto__);

(statearr_29761[(1)] = (1));

return statearr_29761;
});
var cljs$core$async$state_machine__11792__auto____1 = (function (state_29735){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__(state_29735);
if(cljs.core.keyword_identical_QMARK_(result__11794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e29762){if((e29762 instanceof Object)){
var ex__11795__auto__ = e29762;
var statearr_29763_29784 = state_29735;
(statearr_29763_29784[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29735);

return cljs.core.cst$kw$recur;
} else {
throw e29762;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11793__auto__,cljs.core.cst$kw$recur)){
var G__29785 = state_29735;
state_29735 = G__29785;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$state_machine__11792__auto__ = function(state_29735){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11792__auto____1.call(this,state_29735);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11792__auto____0;
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11792__auto____1;
return cljs$core$async$state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___29769,out))
})();
var state__11858__auto__ = (function (){var statearr_29764 = (f__11857__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11857__auto__.cljs$core$IFn$_invoke$arity$0() : f__11857__auto__.call(null));
(statearr_29764[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___29769);

return statearr_29764;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11858__auto__);
});})(c__11856__auto___29769,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args29786 = [];
var len__7280__auto___29860 = arguments.length;
var i__7281__auto___29861 = (0);
while(true){
if((i__7281__auto___29861 < len__7280__auto___29860)){
args29786.push((arguments[i__7281__auto___29861]));

var G__29862 = (i__7281__auto___29861 + (1));
i__7281__auto___29861 = G__29862;
continue;
} else {
}
break;
}

var G__29788 = args29786.length;
switch (G__29788) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29786.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11856__auto___29864 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11856__auto___29864,out){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto___29864,out){
return (function (state_29830){
var state_val_29831 = (state_29830[(1)]);
if((state_val_29831 === (7))){
var inst_29826 = (state_29830[(2)]);
var state_29830__$1 = state_29830;
var statearr_29832_29865 = state_29830__$1;
(statearr_29832_29865[(2)] = inst_29826);

(statearr_29832_29865[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29831 === (1))){
var inst_29789 = [];
var inst_29790 = inst_29789;
var inst_29791 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_29830__$1 = (function (){var statearr_29833 = state_29830;
(statearr_29833[(7)] = inst_29790);

(statearr_29833[(8)] = inst_29791);

return statearr_29833;
})();
var statearr_29834_29866 = state_29830__$1;
(statearr_29834_29866[(2)] = null);

(statearr_29834_29866[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29831 === (4))){
var inst_29794 = (state_29830[(9)]);
var inst_29794__$1 = (state_29830[(2)]);
var inst_29795 = (inst_29794__$1 == null);
var inst_29796 = cljs.core.not(inst_29795);
var state_29830__$1 = (function (){var statearr_29835 = state_29830;
(statearr_29835[(9)] = inst_29794__$1);

return statearr_29835;
})();
if(inst_29796){
var statearr_29836_29867 = state_29830__$1;
(statearr_29836_29867[(1)] = (5));

} else {
var statearr_29837_29868 = state_29830__$1;
(statearr_29837_29868[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29831 === (15))){
var inst_29820 = (state_29830[(2)]);
var state_29830__$1 = state_29830;
var statearr_29838_29869 = state_29830__$1;
(statearr_29838_29869[(2)] = inst_29820);

(statearr_29838_29869[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29831 === (13))){
var state_29830__$1 = state_29830;
var statearr_29839_29870 = state_29830__$1;
(statearr_29839_29870[(2)] = null);

(statearr_29839_29870[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29831 === (6))){
var inst_29790 = (state_29830[(7)]);
var inst_29815 = inst_29790.length;
var inst_29816 = (inst_29815 > (0));
var state_29830__$1 = state_29830;
if(cljs.core.truth_(inst_29816)){
var statearr_29840_29871 = state_29830__$1;
(statearr_29840_29871[(1)] = (12));

} else {
var statearr_29841_29872 = state_29830__$1;
(statearr_29841_29872[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29831 === (3))){
var inst_29828 = (state_29830[(2)]);
var state_29830__$1 = state_29830;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29830__$1,inst_29828);
} else {
if((state_val_29831 === (12))){
var inst_29790 = (state_29830[(7)]);
var inst_29818 = cljs.core.vec(inst_29790);
var state_29830__$1 = state_29830;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29830__$1,(15),out,inst_29818);
} else {
if((state_val_29831 === (2))){
var state_29830__$1 = state_29830;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29830__$1,(4),ch);
} else {
if((state_val_29831 === (11))){
var inst_29794 = (state_29830[(9)]);
var inst_29798 = (state_29830[(10)]);
var inst_29808 = (state_29830[(2)]);
var inst_29809 = [];
var inst_29810 = inst_29809.push(inst_29794);
var inst_29790 = inst_29809;
var inst_29791 = inst_29798;
var state_29830__$1 = (function (){var statearr_29842 = state_29830;
(statearr_29842[(11)] = inst_29808);

(statearr_29842[(7)] = inst_29790);

(statearr_29842[(8)] = inst_29791);

(statearr_29842[(12)] = inst_29810);

return statearr_29842;
})();
var statearr_29843_29873 = state_29830__$1;
(statearr_29843_29873[(2)] = null);

(statearr_29843_29873[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29831 === (9))){
var inst_29790 = (state_29830[(7)]);
var inst_29806 = cljs.core.vec(inst_29790);
var state_29830__$1 = state_29830;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29830__$1,(11),out,inst_29806);
} else {
if((state_val_29831 === (5))){
var inst_29791 = (state_29830[(8)]);
var inst_29794 = (state_29830[(9)]);
var inst_29798 = (state_29830[(10)]);
var inst_29798__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_29794) : f.call(null,inst_29794));
var inst_29799 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29798__$1,inst_29791);
var inst_29800 = cljs.core.keyword_identical_QMARK_(inst_29791,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_29801 = (inst_29799) || (inst_29800);
var state_29830__$1 = (function (){var statearr_29844 = state_29830;
(statearr_29844[(10)] = inst_29798__$1);

return statearr_29844;
})();
if(cljs.core.truth_(inst_29801)){
var statearr_29845_29874 = state_29830__$1;
(statearr_29845_29874[(1)] = (8));

} else {
var statearr_29846_29875 = state_29830__$1;
(statearr_29846_29875[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29831 === (14))){
var inst_29823 = (state_29830[(2)]);
var inst_29824 = cljs.core.async.close_BANG_(out);
var state_29830__$1 = (function (){var statearr_29848 = state_29830;
(statearr_29848[(13)] = inst_29823);

return statearr_29848;
})();
var statearr_29849_29876 = state_29830__$1;
(statearr_29849_29876[(2)] = inst_29824);

(statearr_29849_29876[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29831 === (10))){
var inst_29813 = (state_29830[(2)]);
var state_29830__$1 = state_29830;
var statearr_29850_29877 = state_29830__$1;
(statearr_29850_29877[(2)] = inst_29813);

(statearr_29850_29877[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29831 === (8))){
var inst_29790 = (state_29830[(7)]);
var inst_29794 = (state_29830[(9)]);
var inst_29798 = (state_29830[(10)]);
var inst_29803 = inst_29790.push(inst_29794);
var tmp29847 = inst_29790;
var inst_29790__$1 = tmp29847;
var inst_29791 = inst_29798;
var state_29830__$1 = (function (){var statearr_29851 = state_29830;
(statearr_29851[(7)] = inst_29790__$1);

(statearr_29851[(8)] = inst_29791);

(statearr_29851[(14)] = inst_29803);

return statearr_29851;
})();
var statearr_29852_29878 = state_29830__$1;
(statearr_29852_29878[(2)] = null);

(statearr_29852_29878[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto___29864,out))
;
return ((function (switch__11791__auto__,c__11856__auto___29864,out){
return (function() {
var cljs$core$async$state_machine__11792__auto__ = null;
var cljs$core$async$state_machine__11792__auto____0 = (function (){
var statearr_29856 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29856[(0)] = cljs$core$async$state_machine__11792__auto__);

(statearr_29856[(1)] = (1));

return statearr_29856;
});
var cljs$core$async$state_machine__11792__auto____1 = (function (state_29830){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__(state_29830);
if(cljs.core.keyword_identical_QMARK_(result__11794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e29857){if((e29857 instanceof Object)){
var ex__11795__auto__ = e29857;
var statearr_29858_29879 = state_29830;
(statearr_29858_29879[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29830);

return cljs.core.cst$kw$recur;
} else {
throw e29857;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11793__auto__,cljs.core.cst$kw$recur)){
var G__29880 = state_29830;
state_29830 = G__29880;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
cljs$core$async$state_machine__11792__auto__ = function(state_29830){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11792__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11792__auto____1.call(this,state_29830);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11792__auto____0;
cljs$core$async$state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11792__auto____1;
return cljs$core$async$state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto___29864,out))
})();
var state__11858__auto__ = (function (){var statearr_29859 = (f__11857__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11857__auto__.cljs$core$IFn$_invoke$arity$0() : f__11857__auto__.call(null));
(statearr_29859[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto___29864);

return statearr_29859;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11858__auto__);
});})(c__11856__auto___29864,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
