// Compiled by ClojureScript 1.8.51 {:static-fns true, :optimize-constants true}
goog.provide('c2.dom');
goog.require('cljs.core');
goog.require('goog.dom.forms');
goog.require('goog.dom');
goog.require('goog.dom.classes');
goog.require('singult.core');
goog.require('goog.style');
goog.require('clojure.string');
Element.prototype.matchesSelector = Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || Element.prototype.oMatchesSelector;
if(cljs.core.truth_(typeof NodeList != "undefined")){
NodeList.prototype.cljs$core$ISeqable$ = true;

NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(array__$1,(0));
});
} else {
}
HTMLCollection.prototype.cljs$core$ISeqable$ = true;

HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(array__$1,(0));
});

/**
 * @interface
 */
c2.dom.IDom = function(){};

/**
 * Converts x to a live DOM node
 */
c2.dom.__GT_dom = (function c2$dom$__GT_dom(x){
if((!((x == null))) && (!((x.c2$dom$IDom$__GT_dom$arity$1 == null)))){
return x.c2$dom$IDom$__GT_dom$arity$1(x);
} else {
var x__6873__auto__ = (((x == null))?null:x);
var m__6874__auto__ = (c2.dom.__GT_dom[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__6874__auto__.call(null,x));
} else {
var m__6874__auto____$1 = (c2.dom.__GT_dom["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__6874__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("IDom.->dom",x);
}
}
}
});

(c2.dom.IDom["string"] = true);

(c2.dom.__GT_dom["string"] = (function (selector){
return (c2.dom.select.cljs$core$IFn$_invoke$arity$1 ? c2.dom.select.cljs$core$IFn$_invoke$arity$1(selector) : c2.dom.select.call(null,selector));
}));

cljs.core.PersistentVector.prototype.c2$dom$IDom$ = true;

cljs.core.PersistentVector.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (v){
var v__$1 = this;
return singult.core.render(v__$1);
});
if(cljs.core.truth_(typeof Node != "undefined")){
Node.prototype.c2$dom$IDom$ = true;

Node.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (node){
var node__$1 = this;
return node__$1;
});
} else {
}
/**
 * Select a single DOM node via CSS selector, optionally scoped by second arg.
 */
c2.dom.select = (function c2$dom$select(var_args){
var args31833 = [];
var len__7280__auto___31836 = arguments.length;
var i__7281__auto___31837 = (0);
while(true){
if((i__7281__auto___31837 < len__7280__auto___31836)){
args31833.push((arguments[i__7281__auto___31837]));

var G__31838 = (i__7281__auto___31837 + (1));
i__7281__auto___31837 = G__31838;
continue;
} else {
}
break;
}

var G__31835 = args31833.length;
switch (G__31835) {
case 1:
return c2.dom.select.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31833.length)].join('')));

}
});

c2.dom.select.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelector(selector);
});

c2.dom.select.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom(container).querySelector(selector);
});

c2.dom.select.cljs$lang$maxFixedArity = 2;
/**
 * Like select, but returns a collection of nodes.
 */
c2.dom.select_all = (function c2$dom$select_all(var_args){
var args31840 = [];
var len__7280__auto___31843 = arguments.length;
var i__7281__auto___31844 = (0);
while(true){
if((i__7281__auto___31844 < len__7280__auto___31843)){
args31840.push((arguments[i__7281__auto___31844]));

var G__31845 = (i__7281__auto___31844 + (1));
i__7281__auto___31844 = G__31845;
continue;
} else {
}
break;
}

var G__31842 = args31840.length;
switch (G__31842) {
case 1:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31840.length)].join('')));

}
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelectorAll(selector);
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom(container).querySelectorAll(selector);
});

c2.dom.select_all.cljs$lang$maxFixedArity = 2;
/**
 * Does live `node` match CSS `selector`?
 */
c2.dom.matches_selector_QMARK_ = (function c2$dom$matches_selector_QMARK_(node,selector){
if(cljs.core.truth_(node)){
return node.matchesSelector(selector);
} else {
return null;
}
});
/**
 * Return the children of a live DOM element.
 */
c2.dom.children = (function c2$dom$children(node){
if(cljs.core.truth_(node)){
return c2.dom.__GT_dom(node).children;
} else {
return null;
}
});
/**
 * Return parent of a live DOM node.
 */
c2.dom.parent = (function c2$dom$parent(node){
if(cljs.core.truth_(c2$dom$parent)){
return c2.dom.__GT_dom(node).parentNode;
} else {
return null;
}
});
/**
 * Make element last child of container.
 * Returns live child.
 */
c2.dom.append_BANG_ = (function c2$dom$append_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom(el);
var G__31849_31851 = c2.dom.__GT_dom(container);
var G__31850_31852 = el__$1;
goog.dom.appendChild(G__31849_31851,G__31850_31852);

return el__$1;
});
/**
 * Make element first child of container.
 * Returns live DOM child.
 */
c2.dom.prepend_BANG_ = (function c2$dom$prepend_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom(el);
var G__31856_31859 = c2.dom.__GT_dom(container);
var G__31857_31860 = el__$1;
var G__31858_31861 = (0);
goog.dom.insertChildAt(G__31856_31859,G__31857_31860,G__31858_31861);

return el__$1;
});
/**
 * Remove element from DOM and return it.
 * > *el* CSS selector or live DOM node
 */
c2.dom.remove_BANG_ = (function c2$dom$remove_BANG_(el){
var G__31863 = c2.dom.__GT_dom(el);
return goog.dom.removeNode(G__31863);
});
/**
 * Replace live DOM node with a new one, returning the latter.
 * > *old* CSS selector or live DOM node
 * > *new* CSS selector, live DOM node, or hiccup vector
 */
c2.dom.replace_BANG_ = (function c2$dom$replace_BANG_(old,new$){
var new$__$1 = c2.dom.__GT_dom(new$);
var G__31866_31868 = new$__$1;
var G__31867_31869 = c2.dom.__GT_dom(old);
goog.dom.replaceNode(G__31866_31868,G__31867_31869);

return new$__$1;
});
/**
 * Get or set inline element style.
 * 
 * `(style el)`                map of inline element styles
 * 
 * `(style el :keyword)`       value of style :keyword
 * 
 * `(style el {:keyword val})` sets inline style according to map, returns element
 * 
 * `(style el :keyword val)`   sets single style, returns element
 */
c2.dom.style = (function c2$dom$style(var_args){
var args31870 = [];
var len__7280__auto___31884 = arguments.length;
var i__7281__auto___31885 = (0);
while(true){
if((i__7281__auto___31885 < len__7280__auto___31884)){
args31870.push((arguments[i__7281__auto___31885]));

var G__31886 = (i__7281__auto___31885 + (1));
i__7281__auto___31885 = G__31886;
continue;
} else {
}
break;
}

var G__31872 = args31870.length;
switch (G__31872) {
case 1:
return c2.dom.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.style.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31870.length)].join('')));

}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$1 = (function (el){
throw (new Error("TODO: return map of element styles"));
});

c2.dom.style.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom(el);
if((x instanceof cljs.core.Keyword)){
var G__31873 = el__$1;
var G__31874 = cljs.core.name(x);
return goog.style.getComputedStyle(G__31873,G__31874);
} else {
if(cljs.core.map_QMARK_(x)){
var seq__31875_31888 = cljs.core.seq(x);
var chunk__31876_31889 = null;
var count__31877_31890 = (0);
var i__31878_31891 = (0);
while(true){
if((i__31878_31891 < count__31877_31890)){
var vec__31879_31892 = chunk__31876_31889.cljs$core$IIndexed$_nth$arity$2(null,i__31878_31891);
var k_31893 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31879_31892,(0),null);
var v_31894 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31879_31892,(1),null);
c2.dom.style.cljs$core$IFn$_invoke$arity$3(el__$1,k_31893,v_31894);

var G__31895 = seq__31875_31888;
var G__31896 = chunk__31876_31889;
var G__31897 = count__31877_31890;
var G__31898 = (i__31878_31891 + (1));
seq__31875_31888 = G__31895;
chunk__31876_31889 = G__31896;
count__31877_31890 = G__31897;
i__31878_31891 = G__31898;
continue;
} else {
var temp__4657__auto___31899 = cljs.core.seq(seq__31875_31888);
if(temp__4657__auto___31899){
var seq__31875_31900__$1 = temp__4657__auto___31899;
if(cljs.core.chunked_seq_QMARK_(seq__31875_31900__$1)){
var c__7021__auto___31901 = cljs.core.chunk_first(seq__31875_31900__$1);
var G__31902 = cljs.core.chunk_rest(seq__31875_31900__$1);
var G__31903 = c__7021__auto___31901;
var G__31904 = cljs.core.count(c__7021__auto___31901);
var G__31905 = (0);
seq__31875_31888 = G__31902;
chunk__31876_31889 = G__31903;
count__31877_31890 = G__31904;
i__31878_31891 = G__31905;
continue;
} else {
var vec__31880_31906 = cljs.core.first(seq__31875_31900__$1);
var k_31907 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31880_31906,(0),null);
var v_31908 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31880_31906,(1),null);
c2.dom.style.cljs$core$IFn$_invoke$arity$3(el__$1,k_31907,v_31908);

var G__31909 = cljs.core.next(seq__31875_31900__$1);
var G__31910 = null;
var G__31911 = (0);
var G__31912 = (0);
seq__31875_31888 = G__31909;
chunk__31876_31889 = G__31910;
count__31877_31890 = G__31911;
i__31878_31891 = G__31912;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var G__31881_31913 = c2.dom.__GT_dom(el);
var G__31882_31914 = cljs.core.name(k);
var G__31883_31915 = ((typeof v === 'string')?v:((typeof v === 'number')?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$bottom,null,cljs.core.cst$kw$top,null,cljs.core.cst$kw$width,null,cljs.core.cst$kw$right,null,cljs.core.cst$kw$height,null,cljs.core.cst$kw$left,null], null), null).call(null,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k)))?[cljs.core.str(v),cljs.core.str("px")].join(''):v):null));
goog.style.setStyle(G__31881_31913,G__31882_31914,G__31883_31915);

return el;
});

c2.dom.style.cljs$lang$maxFixedArity = 3;
/**
 * Get or set element attributes.
 * 
 * `(attr el)`                map of element attributes
 * 
 * `(attr el :keyword)`       value of attr :keyword
 * 
 * `(attr el {:keyword val})` sets element attributes according to map, returns element
 * 
 * `(attr el :keyword val)`   sets single attr, returns element
 */
c2.dom.attr = (function c2$dom$attr(var_args){
var args31916 = [];
var len__7280__auto___31931 = arguments.length;
var i__7281__auto___31932 = (0);
while(true){
if((i__7281__auto___31932 < len__7280__auto___31931)){
args31916.push((arguments[i__7281__auto___31932]));

var G__31933 = (i__7281__auto___31932 + (1));
i__7281__auto___31932 = G__31933;
continue;
} else {
}
break;
}

var G__31918 = args31916.length;
switch (G__31918) {
case 1:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31916.length)].join('')));

}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$1 = (function (el){
var attrs = c2.dom.__GT_dom(el).attributes;
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__6990__auto__ = ((function (attrs){
return (function c2$dom$iter__31919(s__31920){
return (new cljs.core.LazySeq(null,((function (attrs){
return (function (){
var s__31920__$1 = s__31920;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__31920__$1);
if(temp__4657__auto__){
var s__31920__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__31920__$2)){
var c__6988__auto__ = cljs.core.chunk_first(s__31920__$2);
var size__6989__auto__ = cljs.core.count(c__6988__auto__);
var b__31922 = cljs.core.chunk_buffer(size__6989__auto__);
if((function (){var i__31921 = (0);
while(true){
if((i__31921 < size__6989__auto__)){
var i = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6988__auto__,i__31921);
cljs.core.chunk_append(b__31922,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((attrs[i]).name),(attrs[i]).value], null));

var G__31935 = (i__31921 + (1));
i__31921 = G__31935;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__31922),c2$dom$iter__31919(cljs.core.chunk_rest(s__31920__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__31922),null);
}
} else {
var i = cljs.core.first(s__31920__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((attrs[i]).name),(attrs[i]).value], null),c2$dom$iter__31919(cljs.core.rest(s__31920__$2)));
}
} else {
return null;
}
break;
}
});})(attrs))
,null,null));
});})(attrs))
;
return iter__6990__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(attrs.length));
})());
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom(el);
if((x instanceof cljs.core.Keyword)){
return el__$1.getAttribute(cljs.core.name(x));
} else {
if(cljs.core.map_QMARK_(x)){
var seq__31925_31936 = cljs.core.seq(x);
var chunk__31926_31937 = null;
var count__31927_31938 = (0);
var i__31928_31939 = (0);
while(true){
if((i__31928_31939 < count__31927_31938)){
var vec__31929_31940 = chunk__31926_31937.cljs$core$IIndexed$_nth$arity$2(null,i__31928_31939);
var k_31941 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31929_31940,(0),null);
var v_31942 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31929_31940,(1),null);
c2.dom.attr.cljs$core$IFn$_invoke$arity$3(el__$1,k_31941,v_31942);

var G__31943 = seq__31925_31936;
var G__31944 = chunk__31926_31937;
var G__31945 = count__31927_31938;
var G__31946 = (i__31928_31939 + (1));
seq__31925_31936 = G__31943;
chunk__31926_31937 = G__31944;
count__31927_31938 = G__31945;
i__31928_31939 = G__31946;
continue;
} else {
var temp__4657__auto___31947 = cljs.core.seq(seq__31925_31936);
if(temp__4657__auto___31947){
var seq__31925_31948__$1 = temp__4657__auto___31947;
if(cljs.core.chunked_seq_QMARK_(seq__31925_31948__$1)){
var c__7021__auto___31949 = cljs.core.chunk_first(seq__31925_31948__$1);
var G__31950 = cljs.core.chunk_rest(seq__31925_31948__$1);
var G__31951 = c__7021__auto___31949;
var G__31952 = cljs.core.count(c__7021__auto___31949);
var G__31953 = (0);
seq__31925_31936 = G__31950;
chunk__31926_31937 = G__31951;
count__31927_31938 = G__31952;
i__31928_31939 = G__31953;
continue;
} else {
var vec__31930_31954 = cljs.core.first(seq__31925_31948__$1);
var k_31955 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31930_31954,(0),null);
var v_31956 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31930_31954,(1),null);
c2.dom.attr.cljs$core$IFn$_invoke$arity$3(el__$1,k_31955,v_31956);

var G__31957 = cljs.core.next(seq__31925_31948__$1);
var G__31958 = null;
var G__31959 = (0);
var G__31960 = (0);
seq__31925_31936 = G__31957;
chunk__31926_31937 = G__31958;
count__31927_31938 = G__31959;
i__31928_31939 = G__31960;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var el__$1 = c2.dom.__GT_dom(el);
if((v == null)){
el__$1.removeAttribute(cljs.core.name(k));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$style,k)){
c2.dom.style.cljs$core$IFn$_invoke$arity$2(el__$1,v);
} else {
el__$1.setAttribute(cljs.core.name(k),v);
}
}

return el__$1;
});

c2.dom.attr.cljs$lang$maxFixedArity = 3;
/**
 * Get or set element text, returning element
 */
c2.dom.text = (function c2$dom$text(var_args){
var args31961 = [];
var len__7280__auto___31965 = arguments.length;
var i__7281__auto___31966 = (0);
while(true){
if((i__7281__auto___31966 < len__7280__auto___31965)){
args31961.push((arguments[i__7281__auto___31966]));

var G__31967 = (i__7281__auto___31966 + (1));
i__7281__auto___31966 = G__31967;
continue;
} else {
}
break;
}

var G__31963 = args31961.length;
switch (G__31963) {
case 1:
return c2.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31961.length)].join('')));

}
});

c2.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__31964 = c2.dom.__GT_dom(el);
return goog.dom.getTextContent(G__31964);
});

c2.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom(el);
goog.dom.setTextContent(el__$1,v);

return el__$1;
});

c2.dom.text.cljs$lang$maxFixedArity = 2;
/**
 * Get or set element value.
 */
c2.dom.val = (function c2$dom$val(var_args){
var args31969 = [];
var len__7280__auto___31973 = arguments.length;
var i__7281__auto___31974 = (0);
while(true){
if((i__7281__auto___31974 < len__7280__auto___31973)){
args31969.push((arguments[i__7281__auto___31974]));

var G__31975 = (i__7281__auto___31974 + (1));
i__7281__auto___31974 = G__31975;
continue;
} else {
}
break;
}

var G__31971 = args31969.length;
switch (G__31971) {
case 1:
return c2.dom.val.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.val.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31969.length)].join('')));

}
});

c2.dom.val.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__31972 = c2.dom.__GT_dom(el);
return goog.dom.forms.getValue(G__31972);
});

c2.dom.val.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom(el);
goog.dom.forms.setValue(el__$1,v);

return el__$1;
});

c2.dom.val.cljs$lang$maxFixedArity = 2;
/**
 * Add or remove `class` to element based on boolean `classed?`, returning element.
 */
c2.dom.classed_BANG_ = (function c2$dom$classed_BANG_(el,class$,classed_QMARK_){
var G__31980_31983 = c2.dom.__GT_dom(el);
var G__31981_31984 = cljs.core.name(class$);
var G__31982_31985 = classed_QMARK_;
goog.dom.classes.enable(G__31980_31983,G__31981_31984,G__31982_31985);

return el;
});
c2.dom.add_class_BANG_ = (function c2$dom$add_class_BANG_(el,class$){
return c2.dom.classed_BANG_(el,class$,true);
});
c2.dom.remove_class_BANG_ = (function c2$dom$remove_class_BANG_(el,class$){
return c2.dom.classed_BANG_(el,class$,false);
});
c2.dom.request_animation_frame = (function (){var or__6210__auto__ = window.requestAnimationFrame;
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
var or__6210__auto____$1 = window.webkitRequestAnimationFrame;
if(cljs.core.truth_(or__6210__auto____$1)){
return or__6210__auto____$1;
} else {
return ((function (or__6210__auto____$1,or__6210__auto__){
return (function (p1__31986_SHARP_){
var G__31987 = ((function (or__6210__auto____$1,or__6210__auto__){
return (function (){
return (p1__31986_SHARP_.cljs$core$IFn$_invoke$arity$0 ? p1__31986_SHARP_.cljs$core$IFn$_invoke$arity$0() : p1__31986_SHARP_.call(null));
});})(or__6210__auto____$1,or__6210__auto__))
;
var G__31988 = (10);
return setTimeout(G__31987,G__31988);
});
;})(or__6210__auto____$1,or__6210__auto__))
}
}
})();
