// Compiled by ClojureScript 1.8.51 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__15467__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__15466 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var tag = cljs.core.nth.call(null,vec__15466,(0),null);
var body = cljs.core.nthnext.call(null,vec__15466,(1));
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__15467 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__15468__i = 0, G__15468__a = new Array(arguments.length -  0);
while (G__15468__i < G__15468__a.length) {G__15468__a[G__15468__i] = arguments[G__15468__i + 0]; ++G__15468__i;}
  args = new cljs.core.IndexedSeq(G__15468__a,0);
} 
return G__15467__delegate.call(this,args);};
G__15467.cljs$lang$maxFixedArity = 0;
G__15467.cljs$lang$applyTo = (function (arglist__15469){
var args = cljs.core.seq(arglist__15469);
return G__15467__delegate(args);
});
G__15467.cljs$core$IFn$_invoke$arity$variadic = G__15467__delegate;
return G__15467;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__6990__auto__ = (function sablono$core$update_arglists_$_iter__15474(s__15475){
return (new cljs.core.LazySeq(null,(function (){
var s__15475__$1 = s__15475;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__15475__$1);
if(temp__4657__auto__){
var s__15475__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__15475__$2)){
var c__6988__auto__ = cljs.core.chunk_first.call(null,s__15475__$2);
var size__6989__auto__ = cljs.core.count.call(null,c__6988__auto__);
var b__15477 = cljs.core.chunk_buffer.call(null,size__6989__auto__);
if((function (){var i__15476 = (0);
while(true){
if((i__15476 < size__6989__auto__)){
var args = cljs.core._nth.call(null,c__6988__auto__,i__15476);
cljs.core.chunk_append.call(null,b__15477,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__15478 = (i__15476 + (1));
i__15476 = G__15478;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15477),sablono$core$update_arglists_$_iter__15474.call(null,cljs.core.chunk_rest.call(null,s__15475__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15477),null);
}
} else {
var args = cljs.core.first.call(null,s__15475__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__15474.call(null,cljs.core.rest.call(null,s__15475__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__6990__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__7287__auto__ = [];
var len__7280__auto___15484 = arguments.length;
var i__7281__auto___15485 = (0);
while(true){
if((i__7281__auto___15485 < len__7280__auto___15484)){
args__7287__auto__.push((arguments[i__7281__auto___15485]));

var G__15486 = (i__7281__auto___15485 + (1));
i__7281__auto___15485 = G__15486;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((0) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__7288__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__6990__auto__ = (function sablono$core$iter__15480(s__15481){
return (new cljs.core.LazySeq(null,(function (){
var s__15481__$1 = s__15481;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__15481__$1);
if(temp__4657__auto__){
var s__15481__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__15481__$2)){
var c__6988__auto__ = cljs.core.chunk_first.call(null,s__15481__$2);
var size__6989__auto__ = cljs.core.count.call(null,c__6988__auto__);
var b__15483 = cljs.core.chunk_buffer.call(null,size__6989__auto__);
if((function (){var i__15482 = (0);
while(true){
if((i__15482 < size__6989__auto__)){
var style = cljs.core._nth.call(null,c__6988__auto__,i__15482);
cljs.core.chunk_append.call(null,b__15483,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__15487 = (i__15482 + (1));
i__15482 = G__15487;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15483),sablono$core$iter__15480.call(null,cljs.core.chunk_rest.call(null,s__15481__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15483),null);
}
} else {
var style = cljs.core.first.call(null,s__15481__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__15480.call(null,cljs.core.rest.call(null,s__15481__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__6990__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq15479){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq15479));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",{"src": src}));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to15488 = (function sablono$core$link_to15488(var_args){
var args__7287__auto__ = [];
var len__7280__auto___15491 = arguments.length;
var i__7281__auto___15492 = (0);
while(true){
if((i__7281__auto___15492 < len__7280__auto___15491)){
args__7287__auto__.push((arguments[i__7281__auto___15492]));

var G__15493 = (i__7281__auto___15492 + (1));
i__7281__auto___15492 = G__15493;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to15488.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

sablono.core.link_to15488.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to15488.cljs$lang$maxFixedArity = (1);

sablono.core.link_to15488.cljs$lang$applyTo = (function (seq15489){
var G__15490 = cljs.core.first.call(null,seq15489);
var seq15489__$1 = cljs.core.next.call(null,seq15489);
return sablono.core.link_to15488.cljs$core$IFn$_invoke$arity$variadic(G__15490,seq15489__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to15488);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to15494 = (function sablono$core$mail_to15494(var_args){
var args__7287__auto__ = [];
var len__7280__auto___15499 = arguments.length;
var i__7281__auto___15500 = (0);
while(true){
if((i__7281__auto___15500 < len__7280__auto___15499)){
args__7287__auto__.push((arguments[i__7281__auto___15500]));

var G__15501 = (i__7281__auto___15500 + (1));
i__7281__auto___15500 = G__15501;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to15494.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

sablono.core.mail_to15494.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__15497){
var vec__15498 = p__15497;
var content = cljs.core.nth.call(null,vec__15498,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__6210__auto__ = content;
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to15494.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to15494.cljs$lang$applyTo = (function (seq15495){
var G__15496 = cljs.core.first.call(null,seq15495);
var seq15495__$1 = cljs.core.next.call(null,seq15495);
return sablono.core.mail_to15494.cljs$core$IFn$_invoke$arity$variadic(G__15496,seq15495__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to15494);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list15502 = (function sablono$core$unordered_list15502(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__6990__auto__ = (function sablono$core$unordered_list15502_$_iter__15507(s__15508){
return (new cljs.core.LazySeq(null,(function (){
var s__15508__$1 = s__15508;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__15508__$1);
if(temp__4657__auto__){
var s__15508__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__15508__$2)){
var c__6988__auto__ = cljs.core.chunk_first.call(null,s__15508__$2);
var size__6989__auto__ = cljs.core.count.call(null,c__6988__auto__);
var b__15510 = cljs.core.chunk_buffer.call(null,size__6989__auto__);
if((function (){var i__15509 = (0);
while(true){
if((i__15509 < size__6989__auto__)){
var x = cljs.core._nth.call(null,c__6988__auto__,i__15509);
cljs.core.chunk_append.call(null,b__15510,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__15511 = (i__15509 + (1));
i__15509 = G__15511;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15510),sablono$core$unordered_list15502_$_iter__15507.call(null,cljs.core.chunk_rest.call(null,s__15508__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15510),null);
}
} else {
var x = cljs.core.first.call(null,s__15508__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list15502_$_iter__15507.call(null,cljs.core.rest.call(null,s__15508__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__6990__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list15502);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list15512 = (function sablono$core$ordered_list15512(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__6990__auto__ = (function sablono$core$ordered_list15512_$_iter__15517(s__15518){
return (new cljs.core.LazySeq(null,(function (){
var s__15518__$1 = s__15518;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__15518__$1);
if(temp__4657__auto__){
var s__15518__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__15518__$2)){
var c__6988__auto__ = cljs.core.chunk_first.call(null,s__15518__$2);
var size__6989__auto__ = cljs.core.count.call(null,c__6988__auto__);
var b__15520 = cljs.core.chunk_buffer.call(null,size__6989__auto__);
if((function (){var i__15519 = (0);
while(true){
if((i__15519 < size__6989__auto__)){
var x = cljs.core._nth.call(null,c__6988__auto__,i__15519);
cljs.core.chunk_append.call(null,b__15520,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__15521 = (i__15519 + (1));
i__15519 = G__15521;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15520),sablono$core$ordered_list15512_$_iter__15517.call(null,cljs.core.chunk_rest.call(null,s__15518__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15520),null);
}
} else {
var x = cljs.core.first.call(null,s__15518__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list15512_$_iter__15517.call(null,cljs.core.rest.call(null,s__15518__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__6990__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list15512);
/**
 * Create an image element.
 */
sablono.core.image15522 = (function sablono$core$image15522(var_args){
var args15523 = [];
var len__7280__auto___15526 = arguments.length;
var i__7281__auto___15527 = (0);
while(true){
if((i__7281__auto___15527 < len__7280__auto___15526)){
args15523.push((arguments[i__7281__auto___15527]));

var G__15528 = (i__7281__auto___15527 + (1));
i__7281__auto___15527 = G__15528;
continue;
} else {
}
break;
}

var G__15525 = args15523.length;
switch (G__15525) {
case 1:
return sablono.core.image15522.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image15522.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15523.length)].join('')));

}
});

sablono.core.image15522.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image15522.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image15522.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image15522);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__15530_SHARP_,p2__15531_SHARP_){
return [cljs.core.str(p1__15530_SHARP_),cljs.core.str("["),cljs.core.str(p2__15531_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__15532_SHARP_,p2__15533_SHARP_){
return [cljs.core.str(p1__15532_SHARP_),cljs.core.str("-"),cljs.core.str(p2__15533_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field15534 = (function sablono$core$color_field15534(var_args){
var args15535 = [];
var len__7280__auto___15602 = arguments.length;
var i__7281__auto___15603 = (0);
while(true){
if((i__7281__auto___15603 < len__7280__auto___15602)){
args15535.push((arguments[i__7281__auto___15603]));

var G__15604 = (i__7281__auto___15603 + (1));
i__7281__auto___15603 = G__15604;
continue;
} else {
}
break;
}

var G__15537 = args15535.length;
switch (G__15537) {
case 1:
return sablono.core.color_field15534.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field15534.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15535.length)].join('')));

}
});

sablono.core.color_field15534.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.color_field15534.call(null,name__15385__auto__,null);
});

sablono.core.color_field15534.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.color_field15534.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field15534);

/**
 * Creates a date input field.
 */
sablono.core.date_field15538 = (function sablono$core$date_field15538(var_args){
var args15539 = [];
var len__7280__auto___15606 = arguments.length;
var i__7281__auto___15607 = (0);
while(true){
if((i__7281__auto___15607 < len__7280__auto___15606)){
args15539.push((arguments[i__7281__auto___15607]));

var G__15608 = (i__7281__auto___15607 + (1));
i__7281__auto___15607 = G__15608;
continue;
} else {
}
break;
}

var G__15541 = args15539.length;
switch (G__15541) {
case 1:
return sablono.core.date_field15538.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field15538.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15539.length)].join('')));

}
});

sablono.core.date_field15538.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.date_field15538.call(null,name__15385__auto__,null);
});

sablono.core.date_field15538.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.date_field15538.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field15538);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field15542 = (function sablono$core$datetime_field15542(var_args){
var args15543 = [];
var len__7280__auto___15610 = arguments.length;
var i__7281__auto___15611 = (0);
while(true){
if((i__7281__auto___15611 < len__7280__auto___15610)){
args15543.push((arguments[i__7281__auto___15611]));

var G__15612 = (i__7281__auto___15611 + (1));
i__7281__auto___15611 = G__15612;
continue;
} else {
}
break;
}

var G__15545 = args15543.length;
switch (G__15545) {
case 1:
return sablono.core.datetime_field15542.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field15542.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15543.length)].join('')));

}
});

sablono.core.datetime_field15542.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.datetime_field15542.call(null,name__15385__auto__,null);
});

sablono.core.datetime_field15542.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.datetime_field15542.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field15542);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field15546 = (function sablono$core$datetime_local_field15546(var_args){
var args15547 = [];
var len__7280__auto___15614 = arguments.length;
var i__7281__auto___15615 = (0);
while(true){
if((i__7281__auto___15615 < len__7280__auto___15614)){
args15547.push((arguments[i__7281__auto___15615]));

var G__15616 = (i__7281__auto___15615 + (1));
i__7281__auto___15615 = G__15616;
continue;
} else {
}
break;
}

var G__15549 = args15547.length;
switch (G__15549) {
case 1:
return sablono.core.datetime_local_field15546.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field15546.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15547.length)].join('')));

}
});

sablono.core.datetime_local_field15546.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.datetime_local_field15546.call(null,name__15385__auto__,null);
});

sablono.core.datetime_local_field15546.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.datetime_local_field15546.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field15546);

/**
 * Creates a email input field.
 */
sablono.core.email_field15550 = (function sablono$core$email_field15550(var_args){
var args15551 = [];
var len__7280__auto___15618 = arguments.length;
var i__7281__auto___15619 = (0);
while(true){
if((i__7281__auto___15619 < len__7280__auto___15618)){
args15551.push((arguments[i__7281__auto___15619]));

var G__15620 = (i__7281__auto___15619 + (1));
i__7281__auto___15619 = G__15620;
continue;
} else {
}
break;
}

var G__15553 = args15551.length;
switch (G__15553) {
case 1:
return sablono.core.email_field15550.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field15550.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15551.length)].join('')));

}
});

sablono.core.email_field15550.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.email_field15550.call(null,name__15385__auto__,null);
});

sablono.core.email_field15550.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.email_field15550.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field15550);

/**
 * Creates a file input field.
 */
sablono.core.file_field15554 = (function sablono$core$file_field15554(var_args){
var args15555 = [];
var len__7280__auto___15622 = arguments.length;
var i__7281__auto___15623 = (0);
while(true){
if((i__7281__auto___15623 < len__7280__auto___15622)){
args15555.push((arguments[i__7281__auto___15623]));

var G__15624 = (i__7281__auto___15623 + (1));
i__7281__auto___15623 = G__15624;
continue;
} else {
}
break;
}

var G__15557 = args15555.length;
switch (G__15557) {
case 1:
return sablono.core.file_field15554.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field15554.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15555.length)].join('')));

}
});

sablono.core.file_field15554.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.file_field15554.call(null,name__15385__auto__,null);
});

sablono.core.file_field15554.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.file_field15554.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field15554);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field15558 = (function sablono$core$hidden_field15558(var_args){
var args15559 = [];
var len__7280__auto___15626 = arguments.length;
var i__7281__auto___15627 = (0);
while(true){
if((i__7281__auto___15627 < len__7280__auto___15626)){
args15559.push((arguments[i__7281__auto___15627]));

var G__15628 = (i__7281__auto___15627 + (1));
i__7281__auto___15627 = G__15628;
continue;
} else {
}
break;
}

var G__15561 = args15559.length;
switch (G__15561) {
case 1:
return sablono.core.hidden_field15558.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field15558.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15559.length)].join('')));

}
});

sablono.core.hidden_field15558.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.hidden_field15558.call(null,name__15385__auto__,null);
});

sablono.core.hidden_field15558.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.hidden_field15558.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field15558);

/**
 * Creates a month input field.
 */
sablono.core.month_field15562 = (function sablono$core$month_field15562(var_args){
var args15563 = [];
var len__7280__auto___15630 = arguments.length;
var i__7281__auto___15631 = (0);
while(true){
if((i__7281__auto___15631 < len__7280__auto___15630)){
args15563.push((arguments[i__7281__auto___15631]));

var G__15632 = (i__7281__auto___15631 + (1));
i__7281__auto___15631 = G__15632;
continue;
} else {
}
break;
}

var G__15565 = args15563.length;
switch (G__15565) {
case 1:
return sablono.core.month_field15562.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field15562.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15563.length)].join('')));

}
});

sablono.core.month_field15562.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.month_field15562.call(null,name__15385__auto__,null);
});

sablono.core.month_field15562.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.month_field15562.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field15562);

/**
 * Creates a number input field.
 */
sablono.core.number_field15566 = (function sablono$core$number_field15566(var_args){
var args15567 = [];
var len__7280__auto___15634 = arguments.length;
var i__7281__auto___15635 = (0);
while(true){
if((i__7281__auto___15635 < len__7280__auto___15634)){
args15567.push((arguments[i__7281__auto___15635]));

var G__15636 = (i__7281__auto___15635 + (1));
i__7281__auto___15635 = G__15636;
continue;
} else {
}
break;
}

var G__15569 = args15567.length;
switch (G__15569) {
case 1:
return sablono.core.number_field15566.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field15566.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15567.length)].join('')));

}
});

sablono.core.number_field15566.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.number_field15566.call(null,name__15385__auto__,null);
});

sablono.core.number_field15566.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.number_field15566.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field15566);

/**
 * Creates a password input field.
 */
sablono.core.password_field15570 = (function sablono$core$password_field15570(var_args){
var args15571 = [];
var len__7280__auto___15638 = arguments.length;
var i__7281__auto___15639 = (0);
while(true){
if((i__7281__auto___15639 < len__7280__auto___15638)){
args15571.push((arguments[i__7281__auto___15639]));

var G__15640 = (i__7281__auto___15639 + (1));
i__7281__auto___15639 = G__15640;
continue;
} else {
}
break;
}

var G__15573 = args15571.length;
switch (G__15573) {
case 1:
return sablono.core.password_field15570.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field15570.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15571.length)].join('')));

}
});

sablono.core.password_field15570.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.password_field15570.call(null,name__15385__auto__,null);
});

sablono.core.password_field15570.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.password_field15570.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field15570);

/**
 * Creates a range input field.
 */
sablono.core.range_field15574 = (function sablono$core$range_field15574(var_args){
var args15575 = [];
var len__7280__auto___15642 = arguments.length;
var i__7281__auto___15643 = (0);
while(true){
if((i__7281__auto___15643 < len__7280__auto___15642)){
args15575.push((arguments[i__7281__auto___15643]));

var G__15644 = (i__7281__auto___15643 + (1));
i__7281__auto___15643 = G__15644;
continue;
} else {
}
break;
}

var G__15577 = args15575.length;
switch (G__15577) {
case 1:
return sablono.core.range_field15574.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field15574.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15575.length)].join('')));

}
});

sablono.core.range_field15574.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.range_field15574.call(null,name__15385__auto__,null);
});

sablono.core.range_field15574.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.range_field15574.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field15574);

/**
 * Creates a search input field.
 */
sablono.core.search_field15578 = (function sablono$core$search_field15578(var_args){
var args15579 = [];
var len__7280__auto___15646 = arguments.length;
var i__7281__auto___15647 = (0);
while(true){
if((i__7281__auto___15647 < len__7280__auto___15646)){
args15579.push((arguments[i__7281__auto___15647]));

var G__15648 = (i__7281__auto___15647 + (1));
i__7281__auto___15647 = G__15648;
continue;
} else {
}
break;
}

var G__15581 = args15579.length;
switch (G__15581) {
case 1:
return sablono.core.search_field15578.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field15578.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15579.length)].join('')));

}
});

sablono.core.search_field15578.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.search_field15578.call(null,name__15385__auto__,null);
});

sablono.core.search_field15578.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.search_field15578.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field15578);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field15582 = (function sablono$core$tel_field15582(var_args){
var args15583 = [];
var len__7280__auto___15650 = arguments.length;
var i__7281__auto___15651 = (0);
while(true){
if((i__7281__auto___15651 < len__7280__auto___15650)){
args15583.push((arguments[i__7281__auto___15651]));

var G__15652 = (i__7281__auto___15651 + (1));
i__7281__auto___15651 = G__15652;
continue;
} else {
}
break;
}

var G__15585 = args15583.length;
switch (G__15585) {
case 1:
return sablono.core.tel_field15582.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field15582.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15583.length)].join('')));

}
});

sablono.core.tel_field15582.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.tel_field15582.call(null,name__15385__auto__,null);
});

sablono.core.tel_field15582.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.tel_field15582.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field15582);

/**
 * Creates a text input field.
 */
sablono.core.text_field15586 = (function sablono$core$text_field15586(var_args){
var args15587 = [];
var len__7280__auto___15654 = arguments.length;
var i__7281__auto___15655 = (0);
while(true){
if((i__7281__auto___15655 < len__7280__auto___15654)){
args15587.push((arguments[i__7281__auto___15655]));

var G__15656 = (i__7281__auto___15655 + (1));
i__7281__auto___15655 = G__15656;
continue;
} else {
}
break;
}

var G__15589 = args15587.length;
switch (G__15589) {
case 1:
return sablono.core.text_field15586.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field15586.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15587.length)].join('')));

}
});

sablono.core.text_field15586.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.text_field15586.call(null,name__15385__auto__,null);
});

sablono.core.text_field15586.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.text_field15586.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field15586);

/**
 * Creates a time input field.
 */
sablono.core.time_field15590 = (function sablono$core$time_field15590(var_args){
var args15591 = [];
var len__7280__auto___15658 = arguments.length;
var i__7281__auto___15659 = (0);
while(true){
if((i__7281__auto___15659 < len__7280__auto___15658)){
args15591.push((arguments[i__7281__auto___15659]));

var G__15660 = (i__7281__auto___15659 + (1));
i__7281__auto___15659 = G__15660;
continue;
} else {
}
break;
}

var G__15593 = args15591.length;
switch (G__15593) {
case 1:
return sablono.core.time_field15590.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field15590.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15591.length)].join('')));

}
});

sablono.core.time_field15590.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.time_field15590.call(null,name__15385__auto__,null);
});

sablono.core.time_field15590.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.time_field15590.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field15590);

/**
 * Creates a url input field.
 */
sablono.core.url_field15594 = (function sablono$core$url_field15594(var_args){
var args15595 = [];
var len__7280__auto___15662 = arguments.length;
var i__7281__auto___15663 = (0);
while(true){
if((i__7281__auto___15663 < len__7280__auto___15662)){
args15595.push((arguments[i__7281__auto___15663]));

var G__15664 = (i__7281__auto___15663 + (1));
i__7281__auto___15663 = G__15664;
continue;
} else {
}
break;
}

var G__15597 = args15595.length;
switch (G__15597) {
case 1:
return sablono.core.url_field15594.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field15594.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15595.length)].join('')));

}
});

sablono.core.url_field15594.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.url_field15594.call(null,name__15385__auto__,null);
});

sablono.core.url_field15594.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.url_field15594.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field15594);

/**
 * Creates a week input field.
 */
sablono.core.week_field15598 = (function sablono$core$week_field15598(var_args){
var args15599 = [];
var len__7280__auto___15666 = arguments.length;
var i__7281__auto___15667 = (0);
while(true){
if((i__7281__auto___15667 < len__7280__auto___15666)){
args15599.push((arguments[i__7281__auto___15667]));

var G__15668 = (i__7281__auto___15667 + (1));
i__7281__auto___15667 = G__15668;
continue;
} else {
}
break;
}

var G__15601 = args15599.length;
switch (G__15601) {
case 1:
return sablono.core.week_field15598.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field15598.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15599.length)].join('')));

}
});

sablono.core.week_field15598.cljs$core$IFn$_invoke$arity$1 = (function (name__15385__auto__){
return sablono.core.week_field15598.call(null,name__15385__auto__,null);
});

sablono.core.week_field15598.cljs$core$IFn$_invoke$arity$2 = (function (name__15385__auto__,value__15386__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__15385__auto__,value__15386__auto__);
});

sablono.core.week_field15598.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field15598);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box15670 = (function sablono$core$check_box15670(var_args){
var args15671 = [];
var len__7280__auto___15674 = arguments.length;
var i__7281__auto___15675 = (0);
while(true){
if((i__7281__auto___15675 < len__7280__auto___15674)){
args15671.push((arguments[i__7281__auto___15675]));

var G__15676 = (i__7281__auto___15675 + (1));
i__7281__auto___15675 = G__15676;
continue;
} else {
}
break;
}

var G__15673 = args15671.length;
switch (G__15673) {
case 1:
return sablono.core.check_box15670.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box15670.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box15670.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15671.length)].join('')));

}
});

sablono.core.check_box15670.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box15670.call(null,name,null);
});

sablono.core.check_box15670.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box15670.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box15670.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box15670.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box15670);
/**
 * Creates a radio button.
 */
sablono.core.radio_button15678 = (function sablono$core$radio_button15678(var_args){
var args15679 = [];
var len__7280__auto___15682 = arguments.length;
var i__7281__auto___15683 = (0);
while(true){
if((i__7281__auto___15683 < len__7280__auto___15682)){
args15679.push((arguments[i__7281__auto___15683]));

var G__15684 = (i__7281__auto___15683 + (1));
i__7281__auto___15683 = G__15684;
continue;
} else {
}
break;
}

var G__15681 = args15679.length;
switch (G__15681) {
case 1:
return sablono.core.radio_button15678.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button15678.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button15678.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15679.length)].join('')));

}
});

sablono.core.radio_button15678.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button15678.call(null,group,null);
});

sablono.core.radio_button15678.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button15678.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button15678.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button15678.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button15678);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options15686 = (function sablono$core$select_options15686(var_args){
var args15687 = [];
var len__7280__auto___15698 = arguments.length;
var i__7281__auto___15699 = (0);
while(true){
if((i__7281__auto___15699 < len__7280__auto___15698)){
args15687.push((arguments[i__7281__auto___15699]));

var G__15700 = (i__7281__auto___15699 + (1));
i__7281__auto___15699 = G__15700;
continue;
} else {
}
break;
}

var G__15689 = args15687.length;
switch (G__15689) {
case 1:
return sablono.core.select_options15686.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options15686.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15687.length)].join('')));

}
});

sablono.core.select_options15686.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options15686.call(null,coll,null);
});

sablono.core.select_options15686.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__6990__auto__ = (function sablono$core$iter__15690(s__15691){
return (new cljs.core.LazySeq(null,(function (){
var s__15691__$1 = s__15691;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__15691__$1);
if(temp__4657__auto__){
var s__15691__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__15691__$2)){
var c__6988__auto__ = cljs.core.chunk_first.call(null,s__15691__$2);
var size__6989__auto__ = cljs.core.count.call(null,c__6988__auto__);
var b__15693 = cljs.core.chunk_buffer.call(null,size__6989__auto__);
if((function (){var i__15692 = (0);
while(true){
if((i__15692 < size__6989__auto__)){
var x = cljs.core._nth.call(null,c__6988__auto__,i__15692);
cljs.core.chunk_append.call(null,b__15693,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__15696 = x;
var text = cljs.core.nth.call(null,vec__15696,(0),null);
var val = cljs.core.nth.call(null,vec__15696,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__15696,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options15686.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)));

var G__15702 = (i__15692 + (1));
i__15692 = G__15702;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15693),sablono$core$iter__15690.call(null,cljs.core.chunk_rest.call(null,s__15691__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15693),null);
}
} else {
var x = cljs.core.first.call(null,s__15691__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__15697 = x;
var text = cljs.core.nth.call(null,vec__15697,(0),null);
var val = cljs.core.nth.call(null,vec__15697,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__15697,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options15686.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)),sablono$core$iter__15690.call(null,cljs.core.rest.call(null,s__15691__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__6990__auto__.call(null,coll);
});

sablono.core.select_options15686.cljs$lang$maxFixedArity = 2;

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options15686);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down15703 = (function sablono$core$drop_down15703(var_args){
var args15704 = [];
var len__7280__auto___15707 = arguments.length;
var i__7281__auto___15708 = (0);
while(true){
if((i__7281__auto___15708 < len__7280__auto___15707)){
args15704.push((arguments[i__7281__auto___15708]));

var G__15709 = (i__7281__auto___15708 + (1));
i__7281__auto___15708 = G__15709;
continue;
} else {
}
break;
}

var G__15706 = args15704.length;
switch (G__15706) {
case 2:
return sablono.core.drop_down15703.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down15703.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15704.length)].join('')));

}
});

sablono.core.drop_down15703.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down15703.call(null,name,options,null);
});

sablono.core.drop_down15703.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down15703.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down15703);
/**
 * Creates a text area element.
 */
sablono.core.text_area15711 = (function sablono$core$text_area15711(var_args){
var args15712 = [];
var len__7280__auto___15715 = arguments.length;
var i__7281__auto___15716 = (0);
while(true){
if((i__7281__auto___15716 < len__7280__auto___15715)){
args15712.push((arguments[i__7281__auto___15716]));

var G__15717 = (i__7281__auto___15716 + (1));
i__7281__auto___15716 = G__15717;
continue;
} else {
}
break;
}

var G__15714 = args15712.length;
switch (G__15714) {
case 1:
return sablono.core.text_area15711.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area15711.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15712.length)].join('')));

}
});

sablono.core.text_area15711.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area15711.call(null,name,null);
});

sablono.core.text_area15711.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area15711.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area15711);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label15719 = (function sablono$core$label15719(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label15719);
/**
 * Creates a submit button.
 */
sablono.core.submit_button15720 = (function sablono$core$submit_button15720(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button15720);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button15721 = (function sablono$core$reset_button15721(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button15721);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to15722 = (function sablono$core$form_to15722(var_args){
var args__7287__auto__ = [];
var len__7280__auto___15727 = arguments.length;
var i__7281__auto___15728 = (0);
while(true){
if((i__7281__auto___15728 < len__7280__auto___15727)){
args__7287__auto__.push((arguments[i__7281__auto___15728]));

var G__15729 = (i__7281__auto___15728 + (1));
i__7281__auto___15728 = G__15729;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to15722.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

sablono.core.form_to15722.cljs$core$IFn$_invoke$arity$variadic = (function (p__15725,body){
var vec__15726 = p__15725;
var method = cljs.core.nth.call(null,vec__15726,(0),null);
var action = cljs.core.nth.call(null,vec__15726,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,"_method",method_str)], null)),body));
});

sablono.core.form_to15722.cljs$lang$maxFixedArity = (1);

sablono.core.form_to15722.cljs$lang$applyTo = (function (seq15723){
var G__15724 = cljs.core.first.call(null,seq15723);
var seq15723__$1 = cljs.core.next.call(null,seq15723);
return sablono.core.form_to15722.cljs$core$IFn$_invoke$arity$variadic(G__15724,seq15723__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to15722);
