// Compiled by ClojureScript 1.8.51 {}
goog.provide('hatti.charting');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('c2.layout.histogram');
goog.require('hatti.maths');
goog.require('cljs_time.coerce');
goog.require('c2.scale');
goog.require('cljs_time.format');
goog.require('hatti.ona.forms');
goog.require('c2.svg');
goog.require('clojure.string');
hatti.charting.millis_in_day = (86400000);
/**
 * Parse an integer from a string.
 */
hatti.charting.parse_int = (function hatti$charting$parse_int(st){
var ans = parseInt(st);
if(cljs.core.truth_(isNaN(ans))){
return null;
} else {
return ans;
}
});
/**
 * Converts string to integer, for typ (int|date).
 */
hatti.charting.str__GT_int = (function hatti$charting$str__GT_int(typ){
var G__17314 = typ;
switch (G__17314) {
case "int":
return hatti.charting.parse_int;

break;
case "date":
return ((function (G__17314){
return (function (date_string){
if(cljs.core.truth_(date_string)){
return hatti.maths.floor.call(null,(cljs_time.coerce.to_long.call(null,(new Date(date_string))) / hatti.charting.millis_in_day));
} else {
return null;
}
});
;})(G__17314))

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(typ)].join('')));

}
});
/**
 * Converts integers to strings, for type (int|date).
 * Optional digits parameter = number of digits after decimal, default is 1.
 */
hatti.charting.int__GT_str = (function hatti$charting$int__GT_str(var_args){
var args__7287__auto__ = [];
var len__7280__auto___17326 = arguments.length;
var i__7281__auto___17327 = (0);
while(true){
if((i__7281__auto___17327 < len__7280__auto___17326)){
args__7287__auto__.push((arguments[i__7281__auto___17327]));

var G__17328 = (i__7281__auto___17327 + (1));
i__7281__auto___17327 = G__17328;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic = (function (typ,p__17322){
var map__17323 = p__17322;
var map__17323__$1 = ((((!((map__17323 == null)))?((((map__17323.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17323.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17323):map__17323);
var digits = cljs.core.get.call(null,map__17323__$1,new cljs.core.Keyword(null,"digits","digits",-1134635061),(1));
var int_fmt_s = [cljs.core.str("%."),cljs.core.str(digits),cljs.core.str("f")].join('');
var d__GT_millis = ((function (int_fmt_s,map__17323,map__17323__$1,digits){
return (function (p1__17316_SHARP_){
return (hatti.charting.millis_in_day * p1__17316_SHARP_);
});})(int_fmt_s,map__17323,map__17323__$1,digits))
;
var date__GT_str = ((function (int_fmt_s,d__GT_millis,map__17323,map__17323__$1,digits){
return (function (p1__17317_SHARP_){
if(cljs.core.truth_(p1__17317_SHARP_)){
return moment(p1__17317_SHARP_).format("ll");
} else {
return null;
}
});})(int_fmt_s,d__GT_millis,map__17323,map__17323__$1,digits))
;
var G__17325 = typ;
switch (G__17325) {
case "int":
return ((function (G__17325,int_fmt_s,d__GT_millis,date__GT_str,map__17323,map__17323__$1,digits){
return (function (p1__17318_SHARP_){
return chimera.js_interop.format.call(null,int_fmt_s,p1__17318_SHARP_);
});
;})(G__17325,int_fmt_s,d__GT_millis,date__GT_str,map__17323,map__17323__$1,digits))

break;
case "date":
return ((function (G__17325,int_fmt_s,d__GT_millis,date__GT_str,map__17323,map__17323__$1,digits){
return (function (p1__17319_SHARP_){
return date__GT_str.call(null,d__GT_millis.call(null,p1__17319_SHARP_));
});
;})(G__17325,int_fmt_s,d__GT_millis,date__GT_str,map__17323,map__17323__$1,digits))

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(typ)].join('')));

}
});

hatti.charting.int__GT_str.cljs$lang$maxFixedArity = (1);

hatti.charting.int__GT_str.cljs$lang$applyTo = (function (seq17320){
var G__17321 = cljs.core.first.call(null,seq17320);
var seq17320__$1 = cljs.core.next.call(null,seq17320);
return hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic(G__17321,seq17320__$1);
});
/**
 * Converts a range of typ (int|date) to a string.
 */
hatti.charting.range__GT_str = (function hatti$charting$range__GT_str(p__17330,typ){
var vec__17333 = p__17330;
var mn = cljs.core.nth.call(null,vec__17333,(0),null);
var mx = cljs.core.nth.call(null,vec__17333,(1),null);
var vec__17334 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [hatti.maths.ceil.call(null,mn),hatti.maths.floor.call(null,mx)], null);
var mn__$1 = cljs.core.nth.call(null,vec__17334,(0),null);
var mx__$1 = cljs.core.nth.call(null,vec__17334,(1),null);
var fmt = hatti.charting.int__GT_str.call(null,typ,new cljs.core.Keyword(null,"digits","digits",-1134635061),(0));
if((mx__$1 <= mn__$1)){
return fmt.call(null,mn__$1);
} else {
return clojure.string.join.call(null," to ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fmt.call(null,mn__$1),fmt.call(null,mx__$1)], null));
}
});
/**
 * Given a list of answers, returns each one as a bin, in string form.
 * nil is mapped to nil. The bins, in order, are returned as metadata.
 * eg. (evenly-spaced-bins [1 2 10] 5 'int') => ['1 to 2' '1 to 2' '9 to 10']
 * metadata of this above value would be:
 * {:bins ['1 to 2', '3 to 4', '5 to 6', '7 to 8', '9 to 10']}
 */
hatti.charting.evenly_spaced_bins = (function hatti$charting$evenly_spaced_bins(answers,bins,typ){
var numbers = cljs.core.map.call(null,hatti.charting.str__GT_int.call(null,typ),answers);
var mx = cljs.core.reduce.call(null,cljs.core.max,cljs.core.remove.call(null,cljs.core.nil_QMARK_,numbers));
var mn = cljs.core.reduce.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,numbers));
var s = c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [mn,mx], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(bins - ((1) / (10000)))], null));
var is = cljs.core.map.call(null,hatti.maths.floor,cljs.core.map.call(null,((function (numbers,mx,mn,s){
return (function (p1__17335_SHARP_){
if(cljs.core.truth_(p1__17335_SHARP_)){
return s.call(null,p1__17335_SHARP_);
} else {
return null;
}
});})(numbers,mx,mn,s))
,numbers));
var t = c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),bins], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [mn,mx], null));
var lbounds = cljs.core.distinct.call(null,cljs.core.map.call(null,cljs.core.float$,cljs.core.map.call(null,t,cljs.core.range.call(null,bins))));
var ubounds = cljs.core.conj.call(null,cljs.core.mapv.call(null,((function (numbers,mx,mn,s,is,t,lbounds){
return (function (p1__17336_SHARP_){
if(cljs.core._EQ_.call(null,p1__17336_SHARP_,hatti.maths.floor.call(null,p1__17336_SHARP_))){
return (p1__17336_SHARP_ - (1));
} else {
return p1__17336_SHARP_;
}
});})(numbers,mx,mn,s,is,t,lbounds))
,cljs.core.drop.call(null,(1),lbounds)),mx);
var fmt = hatti.charting.int__GT_str.call(null,typ,new cljs.core.Keyword(null,"digits","digits",-1134635061),(0));
var strings = cljs.core.mapv.call(null,((function (numbers,mx,mn,s,is,t,lbounds,ubounds,fmt){
return (function (p1__17337_SHARP_,p2__17338_SHARP_){
return hatti.charting.range__GT_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17337_SHARP_,p2__17338_SHARP_], null),typ);
});})(numbers,mx,mn,s,is,t,lbounds,ubounds,fmt))
,lbounds,ubounds);
var results = cljs.core.map.call(null,((function (numbers,mx,mn,s,is,t,lbounds,ubounds,fmt,strings){
return (function (i){
if(cljs.core.truth_(i)){
return cljs.core.get.call(null,strings,(i | (0)));
} else {
return null;
}
});})(numbers,mx,mn,s,is,t,lbounds,ubounds,fmt,strings))
,is);
var strings__$1 = cljs.core.vec.call(null,cljs.core.distinct.call(null,strings));
return cljs.core.with_meta.call(null,results,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bins","bins",1670395210),((cljs.core.contains_QMARK_.call(null,cljs.core.set.call(null,answers),null))?cljs.core.conj.call(null,strings__$1,null):strings__$1)], null));
});
/**
 * Take chart-data from the ona API, returns label->count map.
 * eg. Input: {:field_xpath 'D' :data [{:count 2 :D ['Option_1']}]}
 * Output: {:Option_1 2}
 * eg. Input: {:field_xpath 'D' :data [{:count 1 :D ['O1' 'O_2']
 * :count 2 :D ['O1']}]}
 * Output: {:Option_1 3 :O_2 1}
 */
hatti.charting.label_count_pairs = (function hatti$charting$label_count_pairs(var_args){
var args17341 = [];
var len__7280__auto___17350 = arguments.length;
var i__7281__auto___17351 = (0);
while(true){
if((i__7281__auto___17351 < len__7280__auto___17350)){
args17341.push((arguments[i__7281__auto___17351]));

var G__17352 = (i__7281__auto___17351 + (1));
i__7281__auto___17351 = G__17352;
continue;
} else {
}
break;
}

var G__17343 = args17341.length;
switch (G__17343) {
case 1:
return hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17341.length)].join('')));

}
});

hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$1 = (function (chart_data){
return hatti.charting.label_count_pairs.call(null,chart_data,null);
});

hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2 = (function (chart_data,language){
var map__17344 = chart_data;
var map__17344__$1 = ((((!((map__17344 == null)))?((((map__17344.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17344.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17344):map__17344);
var data = cljs.core.get.call(null,map__17344__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var field_xpath = cljs.core.get.call(null,map__17344__$1,new cljs.core.Keyword(null,"field_xpath","field_xpath",1282029284));
var unboxed = (function (){var iter__6990__auto__ = ((function (map__17344,map__17344__$1,data,field_xpath){
return (function hatti$charting$iter__17346(s__17347){
return (new cljs.core.LazySeq(null,((function (map__17344,map__17344__$1,data,field_xpath){
return (function (){
var s__17347__$1 = s__17347;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__17347__$1);
if(temp__4657__auto__){
var s__17347__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__17347__$2)){
var c__6988__auto__ = cljs.core.chunk_first.call(null,s__17347__$2);
var size__6989__auto__ = cljs.core.count.call(null,c__6988__auto__);
var b__17349 = cljs.core.chunk_buffer.call(null,size__6989__auto__);
if((function (){var i__17348 = (0);
while(true){
if((i__17348 < size__6989__auto__)){
var data_item = cljs.core._nth.call(null,c__6988__auto__,i__17348);
cljs.core.chunk_append.call(null,b__17349,(function (){var labels = cljs.core.keyword.call(null,field_xpath).call(null,data_item);
var count = new cljs.core.Keyword(null,"count","count",2139924085).cljs$core$IFn$_invoke$arity$1(data_item);
var labelify = ((function (i__17348,labels,count,data_item,c__6988__auto__,size__6989__auto__,b__17349,s__17347__$2,temp__4657__auto__,map__17344,map__17344__$1,data,field_xpath){
return (function (p1__17339_SHARP_){
return hatti.ona.forms.get_label.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),p1__17339_SHARP_], null),language);
});})(i__17348,labels,count,data_item,c__6988__auto__,size__6989__auto__,b__17349,s__17347__$2,temp__4657__auto__,map__17344,map__17344__$1,data,field_xpath))
;
return cljs.core.map.call(null,((function (i__17348,labels,count,labelify,data_item,c__6988__auto__,size__6989__auto__,b__17349,s__17347__$2,temp__4657__auto__,map__17344,map__17344__$1,data,field_xpath){
return (function (p1__17340_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([labelify.call(null,p1__17340_SHARP_)],[count]);
});})(i__17348,labels,count,labelify,data_item,c__6988__auto__,size__6989__auto__,b__17349,s__17347__$2,temp__4657__auto__,map__17344,map__17344__$1,data,field_xpath))
,labels);
})());

var G__17354 = (i__17348 + (1));
i__17348 = G__17354;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17349),hatti$charting$iter__17346.call(null,cljs.core.chunk_rest.call(null,s__17347__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17349),null);
}
} else {
var data_item = cljs.core.first.call(null,s__17347__$2);
return cljs.core.cons.call(null,(function (){var labels = cljs.core.keyword.call(null,field_xpath).call(null,data_item);
var count = new cljs.core.Keyword(null,"count","count",2139924085).cljs$core$IFn$_invoke$arity$1(data_item);
var labelify = ((function (labels,count,data_item,s__17347__$2,temp__4657__auto__,map__17344,map__17344__$1,data,field_xpath){
return (function (p1__17339_SHARP_){
return hatti.ona.forms.get_label.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),p1__17339_SHARP_], null),language);
});})(labels,count,data_item,s__17347__$2,temp__4657__auto__,map__17344,map__17344__$1,data,field_xpath))
;
return cljs.core.map.call(null,((function (labels,count,labelify,data_item,s__17347__$2,temp__4657__auto__,map__17344,map__17344__$1,data,field_xpath){
return (function (p1__17340_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([labelify.call(null,p1__17340_SHARP_)],[count]);
});})(labels,count,labelify,data_item,s__17347__$2,temp__4657__auto__,map__17344,map__17344__$1,data,field_xpath))
,labels);
})(),hatti$charting$iter__17346.call(null,cljs.core.rest.call(null,s__17347__$2)));
}
} else {
return null;
}
break;
}
});})(map__17344,map__17344__$1,data,field_xpath))
,null,null));
});})(map__17344,map__17344__$1,data,field_xpath))
;
return iter__6990__auto__.call(null,data);
})();
return cljs.core.sort_by.call(null,cljs.core.last,cljs.core._GT_,cljs.core.apply.call(null,cljs.core.merge_with,cljs.core._PLUS_,cljs.core.flatten.call(null,unboxed)));
});

hatti.charting.label_count_pairs.cljs$lang$maxFixedArity = 2;
/**
 * Determine number of bins if there are n possible of values of data.
 *   Custom algorithm, based on a pleasant range of bins being between
 *   roughly 7 and 15 (though customizable). Idea is that we try to divide
 *   n into a number between 
 */
hatti.charting.num_bins = (function hatti$charting$num_bins(var_args){
var args__7287__auto__ = [];
var len__7280__auto___17360 = arguments.length;
var i__7281__auto___17361 = (0);
while(true){
if((i__7281__auto___17361 < len__7280__auto___17360)){
args__7287__auto__.push((arguments[i__7281__auto___17361]));

var G__17362 = (i__7281__auto___17361 + (1));
i__7281__auto___17361 = G__17362;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic = (function (n,p__17357){
var map__17358 = p__17357;
var map__17358__$1 = ((((!((map__17358 == null)))?((((map__17358.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17358.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17358):map__17358);
var data_type = cljs.core.get.call(null,map__17358__$1,new cljs.core.Keyword(null,"data-type","data-type",-326421468),"int");
var rough_min = (7);
var rough_max = (15);
var real_max = (24);
var full_range = cljs.core.range.call(null,rough_min,rough_max);
var best_guess = cljs.core.apply.call(null,cljs.core.max,cljs.core.map.call(null,cljs.core.partial.call(null,hatti.maths.gcd,n),full_range));
if((best_guess < rough_min)){
return cljs.core.apply.call(null,cljs.core.partial.call(null,cljs.core.min,real_max,n),cljs.core.map.call(null,cljs.core.partial.call(null,hatti.maths.lcm,n),full_range));
} else {
return best_guess;
}
});

hatti.charting.num_bins.cljs$lang$maxFixedArity = (1);

hatti.charting.num_bins.cljs$lang$applyTo = (function (seq17355){
var G__17356 = cljs.core.first.call(null,seq17355);
var seq17355__$1 = cljs.core.next.call(null,seq17355);
return hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic(G__17356,seq17355__$1);
});
/**
 * Turn numerical / date chart-data from ona API histogram-friendly.
 *   Return data looks like [(x dx y)] with-meta {:bins num-bins}.
 */
hatti.charting.extract_data_for_histogram = (function hatti$charting$extract_data_for_histogram(var_args){
var args__7287__auto__ = [];
var len__7280__auto___17374 = arguments.length;
var i__7281__auto___17375 = (0);
while(true){
if((i__7281__auto___17375 < len__7280__auto___17374)){
args__7287__auto__.push((arguments[i__7281__auto___17375]));

var G__17376 = (i__7281__auto___17375 + (1));
i__7281__auto___17375 = G__17376;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic = (function (chart_data,p__17365){
var map__17366 = p__17365;
var map__17366__$1 = ((((!((map__17366 == null)))?((((map__17366.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17366.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17366):map__17366);
var data_type = cljs.core.get.call(null,map__17366__$1,new cljs.core.Keyword(null,"data-type","data-type",-326421468),"int");
var map__17368 = chart_data;
var map__17368__$1 = ((((!((map__17368 == null)))?((((map__17368.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17368.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17368):map__17368);
var data = cljs.core.get.call(null,map__17368__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var field_xpath = cljs.core.get.call(null,map__17368__$1,new cljs.core.Keyword(null,"field_xpath","field_xpath",1282029284));
var retype_fn = hatti.charting.str__GT_int.call(null,data_type);
var qn_key = cljs.core.keyword.call(null,field_xpath);
var retyped_data = cljs.core.map.call(null,((function (map__17368,map__17368__$1,data,field_xpath,retype_fn,qn_key,map__17366,map__17366__$1,data_type){
return (function (el){
return cljs.core.update_in.call(null,el,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [qn_key], null),retype_fn);
});})(map__17368,map__17368__$1,data,field_xpath,retype_fn,qn_key,map__17366,map__17366__$1,data_type))
,data);
var data_range = (cljs.core.apply.call(null,cljs.core.max,cljs.core.map.call(null,qn_key,retyped_data)) - cljs.core.apply.call(null,cljs.core.min,cljs.core.map.call(null,qn_key,retyped_data)));
var bins = (((data_range === (0)))?(1):hatti.charting.num_bins.call(null,data_range,new cljs.core.Keyword(null,"data-type","data-type",-326421468),data_type));
var binned_data = c2.layout.histogram.histogram.call(null,retyped_data,new cljs.core.Keyword(null,"value","value",305978217),qn_key,new cljs.core.Keyword(null,"bins","bins",1670395210),bins);
return cljs.core.with_meta.call(null,(function (){var iter__6990__auto__ = ((function (map__17368,map__17368__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__17366,map__17366__$1,data_type){
return (function hatti$charting$iter__17370(s__17371){
return (new cljs.core.LazySeq(null,((function (map__17368,map__17368__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__17366,map__17366__$1,data_type){
return (function (){
var s__17371__$1 = s__17371;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__17371__$1);
if(temp__4657__auto__){
var s__17371__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__17371__$2)){
var c__6988__auto__ = cljs.core.chunk_first.call(null,s__17371__$2);
var size__6989__auto__ = cljs.core.count.call(null,c__6988__auto__);
var b__17373 = cljs.core.chunk_buffer.call(null,size__6989__auto__);
if((function (){var i__17372 = (0);
while(true){
if((i__17372 < size__6989__auto__)){
var data_item = cljs.core._nth.call(null,c__6988__auto__,i__17372);
cljs.core.chunk_append.call(null,b__17373,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,data_item)),new cljs.core.Keyword(null,"dx","dx",-381796732).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,data_item)),cljs.core.apply.call(null,cljs.core._PLUS_,cljs.core.map.call(null,new cljs.core.Keyword(null,"count","count",2139924085),data_item))], null));

var G__17377 = (i__17372 + (1));
i__17372 = G__17377;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17373),hatti$charting$iter__17370.call(null,cljs.core.chunk_rest.call(null,s__17371__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17373),null);
}
} else {
var data_item = cljs.core.first.call(null,s__17371__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,data_item)),new cljs.core.Keyword(null,"dx","dx",-381796732).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,data_item)),cljs.core.apply.call(null,cljs.core._PLUS_,cljs.core.map.call(null,new cljs.core.Keyword(null,"count","count",2139924085),data_item))], null),hatti$charting$iter__17370.call(null,cljs.core.rest.call(null,s__17371__$2)));
}
} else {
return null;
}
break;
}
});})(map__17368,map__17368__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__17366,map__17366__$1,data_type))
,null,null));
});})(map__17368,map__17368__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__17366,map__17366__$1,data_type))
;
return iter__6990__auto__.call(null,binned_data);
})(),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bins","bins",1670395210),bins], null));
});

hatti.charting.extract_data_for_histogram.cljs$lang$maxFixedArity = (1);

hatti.charting.extract_data_for_histogram.cljs$lang$applyTo = (function (seq17363){
var G__17364 = cljs.core.first.call(null,seq17363);
var seq17363__$1 = cljs.core.next.call(null,seq17363);
return hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic(G__17364,seq17363__$1);
});
/**
 * Produces a linear mapping [0,max-count] -> [0, max-length], for data which
 * is a vector, each element a map with key :count. If total-asmax?, then
 * linear map is [0,total-count] -> [0, max-length].
 */
hatti.charting.counts__GT_lengths = (function hatti$charting$counts__GT_lengths(var_args){
var args__7287__auto__ = [];
var len__7280__auto___17384 = arguments.length;
var i__7281__auto___17385 = (0);
while(true){
if((i__7281__auto___17385 < len__7280__auto___17384)){
args__7287__auto__.push((arguments[i__7281__auto___17385]));

var G__17386 = (i__7281__auto___17385 + (1));
i__7281__auto___17385 = G__17386;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((2) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((2)),(0),null)):null);
return hatti.charting.counts__GT_lengths.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7288__auto__);
});

hatti.charting.counts__GT_lengths.cljs$core$IFn$_invoke$arity$variadic = (function (data,max_length,p__17381){
var map__17382 = p__17381;
var map__17382__$1 = ((((!((map__17382 == null)))?((((map__17382.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17382.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17382):map__17382);
var total_as_max_QMARK_ = cljs.core.get.call(null,map__17382__$1,new cljs.core.Keyword(null,"total-as-max?","total-as-max?",-1709426453));
var datamin_as_min_QMARK_ = cljs.core.get.call(null,map__17382__$1,new cljs.core.Keyword(null,"datamin-as-min?","datamin-as-min?",1074079715));
var counts = cljs.core.map.call(null,new cljs.core.Keyword(null,"count","count",2139924085),data);
var xmax = (cljs.core.truth_(total_as_max_QMARK_)?cljs.core.reduce.call(null,cljs.core._PLUS_,(0),counts):cljs.core.reduce.call(null,cljs.core.max,(0),counts));
var xmin = (cljs.core.truth_(datamin_as_min_QMARK_)?cljs.core.reduce.call(null,cljs.core.min,(0),counts):(0));
var scale = c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [xmin,xmax], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),max_length], null));
return cljs.core.map.call(null,scale,counts);
});

hatti.charting.counts__GT_lengths.cljs$lang$maxFixedArity = (2);

hatti.charting.counts__GT_lengths.cljs$lang$applyTo = (function (seq17378){
var G__17379 = cljs.core.first.call(null,seq17378);
var seq17378__$1 = cljs.core.next.call(null,seq17378);
var G__17380 = cljs.core.first.call(null,seq17378__$1);
var seq17378__$2 = cljs.core.next.call(null,seq17378__$1);
return hatti.charting.counts__GT_lengths.cljs$core$IFn$_invoke$arity$variadic(G__17379,G__17380,seq17378__$2);
});
hatti.charting.response_count_message = (function hatti$charting$response_count_message(response_count){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.t-right.t-grey","div.t-right.t-grey",-2075084293),[cljs.core.str("Based on "),cljs.core.str(response_count),cljs.core.str(" responses.")].join('')], null);
});
/**
 * Create numeric (or date) chart out of some chart-data from ona API.
 */
hatti.charting.numeric_chart = (function hatti$charting$numeric_chart(var_args){
var args__7287__auto__ = [];
var len__7280__auto___17411 = arguments.length;
var i__7281__auto___17412 = (0);
while(true){
if((i__7281__auto___17412 < len__7280__auto___17411)){
args__7287__auto__.push((arguments[i__7281__auto___17412]));

var G__17413 = (i__7281__auto___17412 + (1));
i__7281__auto___17412 = G__17413;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic = (function (chart_data,p__17389){
var map__17390 = p__17389;
var map__17390__$1 = ((((!((map__17390 == null)))?((((map__17390.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17390.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17390):map__17390);
var data_type = cljs.core.get.call(null,map__17390__$1,new cljs.core.Keyword(null,"data-type","data-type",-326421468),"int");
var chart_width = 700.0;
var chart_height = 300.0;
var margin = 33.0;
var small_margin = 2.0;
var y_lim = 8.0;
var neg_margin = (-15);
var extracted_data = hatti.charting.extract_data_for_histogram.call(null,chart_data,new cljs.core.Keyword(null,"data-type","data-type",-326421468),data_type);
var map__17392 = cljs.core.meta.call(null,chart_data);
var map__17392__$1 = ((((!((map__17392 == null)))?((((map__17392.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17392.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17392):map__17392);
var nil_count = cljs.core.get.call(null,map__17392__$1,new cljs.core.Keyword(null,"nil-count","nil-count",785567731));
var non_nil_count = cljs.core.get.call(null,map__17392__$1,new cljs.core.Keyword(null,"non-nil-count","non-nil-count",-593781457));
var bins = new cljs.core.Keyword(null,"bins","bins",1670395210).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,extracted_data));
var x_series = cljs.core.map.call(null,cljs.core.first,extracted_data);
var dx_series = cljs.core.map.call(null,cljs.core.second,extracted_data);
var y_series = cljs.core.map.call(null,cljs.core.last,extracted_data);
var xmin = cljs.core.apply.call(null,cljs.core.min,x_series);
var xmax = (cljs.core.apply.call(null,cljs.core.max,x_series) + cljs.core.last.call(null,dx_series));
var x_scale = c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [xmin,xmax], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),chart_width], null));
var y_scale = c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),cljs.core.apply.call(null,cljs.core.max,y_series)], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),chart_height], null));
var bin_width = hatti.maths.floor.call(null,((chart_width / bins) - small_margin));
var x_ticks = cljs.core.take_nth.call(null,(2),cljs.core.rest.call(null,x_series));
var fmt = hatti.charting.int__GT_str.call(null,data_type);
if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,extracted_data))){
var vec__17394 = cljs.core.first.call(null,extracted_data);
var value = cljs.core.nth.call(null,vec__17394,(0),null);
var _ = cljs.core.nth.call(null,vec__17394,(1),null);
var total = cljs.core.nth.call(null,vec__17394,(2),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),total," records have identical value: ",fmt.call(null,value)], null)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"width","width",-384071477),(margin + chart_width),new cljs.core.Keyword(null,"height","height",1025178622),(margin + chart_height)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.chart","g.chart",376683303),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [margin,(0)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g","g",1738089905),(function (){var iter__6990__auto__ = ((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__17392,map__17392__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__17390,map__17390__$1,data_type){
return (function hatti$charting$iter__17395(s__17396){
return (new cljs.core.LazySeq(null,((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__17392,map__17392__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__17390,map__17390__$1,data_type){
return (function (){
var s__17396__$1 = s__17396;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__17396__$1);
if(temp__4657__auto__){
var s__17396__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__17396__$2)){
var c__6988__auto__ = cljs.core.chunk_first.call(null,s__17396__$2);
var size__6989__auto__ = cljs.core.count.call(null,c__6988__auto__);
var b__17398 = cljs.core.chunk_buffer.call(null,size__6989__auto__);
if((function (){var i__17397 = (0);
while(true){
if((i__17397 < size__6989__auto__)){
var vec__17403 = cljs.core._nth.call(null,c__6988__auto__,i__17397);
var x = cljs.core.nth.call(null,vec__17403,(0),null);
var dx = cljs.core.nth.call(null,vec__17403,(1),null);
var y = cljs.core.nth.call(null,vec__17403,(2),null);
cljs.core.chunk_append.call(null,b__17398,(function (){var x_scaled = x_scale.call(null,x);
var y_scaled = y_scale.call(null,y);
var vec__17404 = (((((0) < y_scaled)) && ((y_scaled < y_lim)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [small_margin,neg_margin,"out-of-bar"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [y_scaled,small_margin,"in-bar"], null));
var y_scaled__$1 = cljs.core.nth.call(null,vec__17404,(0),null);
var txt_ht = cljs.core.nth.call(null,vec__17404,(1),null);
var txt_cls = cljs.core.nth.call(null,vec__17404,(2),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.bars","g.bars",-1370310225),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_scaled,(chart_height - y_scaled__$1)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g","g",1738089905),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rect","rect",-108902628),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"x","x",2099068185),(1),new cljs.core.Keyword(null,"height","height",1025178622),y_scaled__$1,new cljs.core.Keyword(null,"width","width",-384071477),bin_width], null)], null)], null),(((y_scaled__$1 > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"y","y",-1757859776),txt_ht,new cljs.core.Keyword(null,"x","x",2099068185),(bin_width / 2.0),new cljs.core.Keyword(null,"dy","dy",1719547243),"1em",new cljs.core.Keyword(null,"text-anchor","text-anchor",585613696),"middle",new cljs.core.Keyword(null,"class","class",-2030961996),txt_cls], null),y], null):null)], null);
})());

var G__17414 = (i__17397 + (1));
i__17397 = G__17414;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17398),hatti$charting$iter__17395.call(null,cljs.core.chunk_rest.call(null,s__17396__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17398),null);
}
} else {
var vec__17405 = cljs.core.first.call(null,s__17396__$2);
var x = cljs.core.nth.call(null,vec__17405,(0),null);
var dx = cljs.core.nth.call(null,vec__17405,(1),null);
var y = cljs.core.nth.call(null,vec__17405,(2),null);
return cljs.core.cons.call(null,(function (){var x_scaled = x_scale.call(null,x);
var y_scaled = y_scale.call(null,y);
var vec__17406 = (((((0) < y_scaled)) && ((y_scaled < y_lim)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [small_margin,neg_margin,"out-of-bar"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [y_scaled,small_margin,"in-bar"], null));
var y_scaled__$1 = cljs.core.nth.call(null,vec__17406,(0),null);
var txt_ht = cljs.core.nth.call(null,vec__17406,(1),null);
var txt_cls = cljs.core.nth.call(null,vec__17406,(2),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.bars","g.bars",-1370310225),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_scaled,(chart_height - y_scaled__$1)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g","g",1738089905),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rect","rect",-108902628),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"x","x",2099068185),(1),new cljs.core.Keyword(null,"height","height",1025178622),y_scaled__$1,new cljs.core.Keyword(null,"width","width",-384071477),bin_width], null)], null)], null),(((y_scaled__$1 > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"y","y",-1757859776),txt_ht,new cljs.core.Keyword(null,"x","x",2099068185),(bin_width / 2.0),new cljs.core.Keyword(null,"dy","dy",1719547243),"1em",new cljs.core.Keyword(null,"text-anchor","text-anchor",585613696),"middle",new cljs.core.Keyword(null,"class","class",-2030961996),txt_cls], null),y], null):null)], null);
})(),hatti$charting$iter__17395.call(null,cljs.core.rest.call(null,s__17396__$2)));
}
} else {
return null;
}
break;
}
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__17392,map__17392__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__17390,map__17390__$1,data_type))
,null,null));
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__17392,map__17392__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__17390,map__17390__$1,data_type))
;
return iter__6990__auto__.call(null,extracted_data);
})()], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.axis","g.axis",837167470),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),chart_height], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"x1","x1",-1863922247),(0),new cljs.core.Keyword(null,"x2","x2",-1362513475),chart_width], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g","g",1738089905),(function (){var iter__6990__auto__ = ((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__17392,map__17392__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__17390,map__17390__$1,data_type){
return (function hatti$charting$iter__17407(s__17408){
return (new cljs.core.LazySeq(null,((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__17392,map__17392__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__17390,map__17390__$1,data_type){
return (function (){
var s__17408__$1 = s__17408;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__17408__$1);
if(temp__4657__auto__){
var s__17408__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__17408__$2)){
var c__6988__auto__ = cljs.core.chunk_first.call(null,s__17408__$2);
var size__6989__auto__ = cljs.core.count.call(null,c__6988__auto__);
var b__17410 = cljs.core.chunk_buffer.call(null,size__6989__auto__);
if((function (){var i__17409 = (0);
while(true){
if((i__17409 < size__6989__auto__)){
var x = cljs.core._nth.call(null,c__6988__auto__,i__17409);
cljs.core.chunk_append.call(null,b__17410,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.tick","g.tick",368840735),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_scale.call(null,x),(0)], null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"y","y",-1757859776),(25),new cljs.core.Keyword(null,"text-anchor","text-anchor",585613696),"middle",new cljs.core.Keyword(null,"class","class",-2030961996),data_type], null),fmt.call(null,x)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"class","class",-2030961996),"tick",new cljs.core.Keyword(null,"y2","y2",-718691301),(10),new cljs.core.Keyword(null,"x2","x2",-1362513475),(0)], null)], null)], null));

var G__17415 = (i__17409 + (1));
i__17409 = G__17415;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17410),hatti$charting$iter__17407.call(null,cljs.core.chunk_rest.call(null,s__17408__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17410),null);
}
} else {
var x = cljs.core.first.call(null,s__17408__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.tick","g.tick",368840735),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_scale.call(null,x),(0)], null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"y","y",-1757859776),(25),new cljs.core.Keyword(null,"text-anchor","text-anchor",585613696),"middle",new cljs.core.Keyword(null,"class","class",-2030961996),data_type], null),fmt.call(null,x)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"class","class",-2030961996),"tick",new cljs.core.Keyword(null,"y2","y2",-718691301),(10),new cljs.core.Keyword(null,"x2","x2",-1362513475),(0)], null)], null)], null),hatti$charting$iter__17407.call(null,cljs.core.rest.call(null,s__17408__$2)));
}
} else {
return null;
}
break;
}
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__17392,map__17392__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__17390,map__17390__$1,data_type))
,null,null));
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__17392,map__17392__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__17390,map__17390__$1,data_type))
;
return iter__6990__auto__.call(null,x_ticks);
})()], null)], null)], null)], null),hatti.charting.response_count_message.call(null,non_nil_count)], null);
}
});

hatti.charting.numeric_chart.cljs$lang$maxFixedArity = (1);

hatti.charting.numeric_chart.cljs$lang$applyTo = (function (seq17387){
var G__17388 = cljs.core.first.call(null,seq17387);
var seq17387__$1 = cljs.core.next.call(null,seq17387);
return hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic(G__17388,seq17387__$1);
});
/**
 * Create category bar chart out of some data + count data. Data of form:
 *   {'Label1' 1 'Label2' 2}, etc. where the numbers are counts.
 */
hatti.charting.table_chart_h = (function hatti$charting$table_chart_h(data,nil_count,non_nil_count,field_type){
var max_count = cljs.core.apply.call(null,cljs.core.max,cljs.core.vals.call(null,data));
var percent_s = ((function (max_count){
return (function (n,total){
var s = c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),total], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(100)], null));
return [cljs.core.str(chimera.js_interop.format.call(null,"%.1f",s.call(null,n))),cljs.core.str("%")].join('');
});})(max_count))
;
var select_mult_QMARK_ = cljs.core._EQ_.call(null,field_type,"select all that apply");
var bar_div = ((select_mult_QMARK_)?new cljs.core.Keyword(null,"div.bars.select-mult","div.bars.select-mult",514551318):new cljs.core.Keyword(null,"div.bars.select-one","div.bars.select-one",-235690381));
var tdr = new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table#bar-chart.table","table#bar-chart.table",-82390780),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"thead","thead",-291875296),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th.t-right","th.t-right",-959248017),"Count"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th.t-right","th.t-right",-959248017),"Percent"], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tfoot","tfoot",-701599890),((select_mult_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr.t-grey","tr.t-grey",1706085529),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"col-span","col-span",-232603210),(4)], null),hatti.charting.response_count_message.call(null,non_nil_count)], null)], null):new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr.t-grey","tr.t-grey",1706085529),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,"Total"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,non_nil_count], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,"100%"], null)], null)),(((!(select_mult_QMARK_)) && ((nil_count > (0))))?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr.t-grey","tr.t-grey",1706085529),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218),"No response"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218),nil_count], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353)], null)], null):null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tbody","tbody",-80678300),(function (){var iter__6990__auto__ = ((function (max_count,percent_s,select_mult_QMARK_,bar_div,tdr){
return (function hatti$charting$table_chart_h_$_iter__17424(s__17425){
return (new cljs.core.LazySeq(null,((function (max_count,percent_s,select_mult_QMARK_,bar_div,tdr){
return (function (){
var s__17425__$1 = s__17425;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__17425__$1);
if(temp__4657__auto__){
var s__17425__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__17425__$2)){
var c__6988__auto__ = cljs.core.chunk_first.call(null,s__17425__$2);
var size__6989__auto__ = cljs.core.count.call(null,c__6988__auto__);
var b__17427 = cljs.core.chunk_buffer.call(null,size__6989__auto__);
if((function (){var i__17426 = (0);
while(true){
if((i__17426 < size__6989__auto__)){
var vec__17430 = cljs.core._nth.call(null,c__6988__auto__,i__17426);
var label = cljs.core.nth.call(null,vec__17430,(0),null);
var val = cljs.core.nth.call(null,vec__17430,(1),null);
cljs.core.chunk_append.call(null,b__17427,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"title","title",636505583),label], null),label], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bar_div,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"width","width",-384071477),percent_s.call(null,val,max_count)], null)], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218),val], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218),percent_s.call(null,val,non_nil_count)], null)], null));

var G__17432 = (i__17426 + (1));
i__17426 = G__17432;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17427),hatti$charting$table_chart_h_$_iter__17424.call(null,cljs.core.chunk_rest.call(null,s__17425__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17427),null);
}
} else {
var vec__17431 = cljs.core.first.call(null,s__17425__$2);
var label = cljs.core.nth.call(null,vec__17431,(0),null);
var val = cljs.core.nth.call(null,vec__17431,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"title","title",636505583),label], null),label], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bar_div,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"width","width",-384071477),percent_s.call(null,val,max_count)], null)], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218),val], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218),percent_s.call(null,val,non_nil_count)], null)], null),hatti$charting$table_chart_h_$_iter__17424.call(null,cljs.core.rest.call(null,s__17425__$2)));
}
} else {
return null;
}
break;
}
});})(max_count,percent_s,select_mult_QMARK_,bar_div,tdr))
,null,null));
});})(max_count,percent_s,select_mult_QMARK_,bar_div,tdr))
;
return iter__6990__auto__.call(null,data);
})()], null)], null);
});
/**
 * Removes nil from Ona API chart data; adds nil- and non-nil-count metadata.
 * ex. Input:  {:field_xpath 'D' :data [{:D nil :count 5} {:D 1 :count 10}]}
 *     Output: {:field_xpath 'D' :data [{:D 1 :count 10}]}
 *             w/ metadata: {:nil-count 5 :non-nil-count 10}
 */
hatti.charting.extract_nil = (function hatti$charting$extract_nil(chart_data){
var map__17438 = chart_data;
var map__17438__$1 = ((((!((map__17438 == null)))?((((map__17438.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17438.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17438):map__17438);
var field_xpath = cljs.core.get.call(null,map__17438__$1,new cljs.core.Keyword(null,"field_xpath","field_xpath",1282029284));
var data = cljs.core.get.call(null,map__17438__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var na_QMARK_ = ((function (map__17438,map__17438__$1,field_xpath,data){
return (function (p1__17433_SHARP_){
return ((p1__17433_SHARP_ == null)) || (cljs.core._EQ_.call(null,cljs.core.PersistentVector.EMPTY,p1__17433_SHARP_));
});})(map__17438,map__17438__$1,field_xpath,data))
;
var nil_data = cljs.core.first.call(null,cljs.core.filter.call(null,((function (map__17438,map__17438__$1,field_xpath,data,na_QMARK_){
return (function (p1__17434_SHARP_){
return na_QMARK_.call(null,cljs.core.keyword.call(null,field_xpath).call(null,p1__17434_SHARP_));
});})(map__17438,map__17438__$1,field_xpath,data,na_QMARK_))
,data));
var non_nil_data = cljs.core.remove.call(null,((function (map__17438,map__17438__$1,field_xpath,data,na_QMARK_,nil_data){
return (function (p1__17435_SHARP_){
return na_QMARK_.call(null,cljs.core.keyword.call(null,field_xpath).call(null,p1__17435_SHARP_));
});})(map__17438,map__17438__$1,field_xpath,data,na_QMARK_,nil_data))
,data);
var nil_count = (function (){var temp__4655__auto__ = new cljs.core.Keyword(null,"count","count",2139924085).cljs$core$IFn$_invoke$arity$1(nil_data);
if(cljs.core.truth_(temp__4655__auto__)){
var n = temp__4655__auto__;
return n;
} else {
return (0);
}
})();
var non_nil_count = cljs.core.apply.call(null,cljs.core._PLUS_,cljs.core.map.call(null,new cljs.core.Keyword(null,"count","count",2139924085),non_nil_data));
return cljs.core.with_meta.call(null,cljs.core.assoc.call(null,chart_data,new cljs.core.Keyword(null,"data","data",-232669377),non_nil_data),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"nil-count","nil-count",785567731),nil_count,new cljs.core.Keyword(null,"non-nil-count","non-nil-count",-593781457),non_nil_count], null));
});
/**
 * Make chart depending on datatype.
 */
hatti.charting.make_chart = (function hatti$charting$make_chart(var_args){
var args17441 = [];
var len__7280__auto___17449 = arguments.length;
var i__7281__auto___17450 = (0);
while(true){
if((i__7281__auto___17450 < len__7280__auto___17449)){
args17441.push((arguments[i__7281__auto___17450]));

var G__17451 = (i__7281__auto___17450 + (1));
i__7281__auto___17450 = G__17451;
continue;
} else {
}
break;
}

var G__17443 = args17441.length;
switch (G__17443) {
case 1:
return hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17441.length)].join('')));

}
});

hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$1 = (function (chart_data){
return hatti.charting.make_chart.call(null,chart_data,null);
});

hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$2 = (function (chart_data,language){
var map__17444 = chart_data;
var map__17444__$1 = ((((!((map__17444 == null)))?((((map__17444.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17444.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17444):map__17444);
var field_label = cljs.core.get.call(null,map__17444__$1,new cljs.core.Keyword(null,"field_label","field_label",-690619633));
var data_type = cljs.core.get.call(null,map__17444__$1,new cljs.core.Keyword(null,"data_type","data_type",1391137078));
var field_xpath = cljs.core.get.call(null,map__17444__$1,new cljs.core.Keyword(null,"field_xpath","field_xpath",1282029284));
var field_type = cljs.core.get.call(null,map__17444__$1,new cljs.core.Keyword(null,"field_type","field_type",1135193526));
var chart_data__$1 = hatti.charting.extract_nil.call(null,chart_data);
var map__17445 = cljs.core.meta.call(null,chart_data__$1);
var map__17445__$1 = ((((!((map__17445 == null)))?((((map__17445.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17445.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17445):map__17445);
var nil_count = cljs.core.get.call(null,map__17445__$1,new cljs.core.Keyword(null,"nil-count","nil-count",785567731));
var non_nil_count = cljs.core.get.call(null,map__17445__$1,new cljs.core.Keyword(null,"non-nil-count","non-nil-count",-593781457));
var not_supported = ((function (map__17444,map__17444__$1,field_label,data_type,field_xpath,field_type,chart_data__$1,map__17445,map__17445__$1,nil_count,non_nil_count){
return (function (p1__17440_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"div.t-red","div.t-red",-489419212),[cljs.core.str("Aplogies. At the moment, making a chart of\n                                     this data type ("),cljs.core.str(p1__17440_SHARP_),cljs.core.str(") is not supported.")].join('')],null));
});})(map__17444,map__17444__$1,field_label,data_type,field_xpath,field_type,chart_data__$1,map__17445,map__17445__$1,nil_count,non_nil_count))
;
var chart = (((non_nil_count === (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),"No data"], null):(function (){var G__17448 = data_type;
switch (G__17448) {
case "categorized":
return hatti.charting.table_chart_h.call(null,hatti.charting.label_count_pairs.call(null,chart_data__$1,language),nil_count,non_nil_count,field_type);

break;
case "time_based":
return hatti.charting.numeric_chart.call(null,chart_data__$1,new cljs.core.Keyword(null,"data-type","data-type",-326421468),"date");

break;
case "numeric":
return hatti.charting.numeric_chart.call(null,chart_data__$1);

break;
default:
return not_supported.call(null,data_type);

}
})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"label","label",1718410804),field_label,new cljs.core.Keyword(null,"name","name",1843675177),field_xpath,new cljs.core.Keyword(null,"chart","chart",1173225425),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),chart], null)], null);
});

hatti.charting.make_chart.cljs$lang$maxFixedArity = 2;
