// Compiled by ClojureScript 1.8.51 {:static-fns true, :optimize-constants true}
goog.provide('c2.scale');
goog.require('cljs.core');
goog.require('c2.maths');

/**
 * @interface
 */
c2.scale.IInvertable = function(){};

/**
 * Inverted scale
 */
c2.scale.invert = (function c2$scale$invert(scale){
if((!((scale == null))) && (!((scale.c2$scale$IInvertable$invert$arity$1 == null)))){
return scale.c2$scale$IInvertable$invert$arity$1(scale);
} else {
var x__6873__auto__ = (((scale == null))?null:scale);
var m__6874__auto__ = (c2.scale.invert[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$1(scale) : m__6874__auto__.call(null,scale));
} else {
var m__6874__auto____$1 = (c2.scale.invert["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$1(scale) : m__6874__auto____$1.call(null,scale));
} else {
throw cljs.core.missing_protocol("IInvertable.invert",scale);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {c2.scale.IInvertable}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
c2.scale._linear = (function (domain,range,__meta,__extmap,__hash){
this.domain = domain;
this.range = range;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667595;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
c2.scale._linear.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__6832__auto__,k__6833__auto__){
var self__ = this;
var this__6832__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__6832__auto____$1,k__6833__auto__,null);
});

c2.scale._linear.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__6834__auto__,k31039,else__6835__auto__){
var self__ = this;
var this__6834__auto____$1 = this;
var G__31042 = (((k31039 instanceof cljs.core.Keyword))?k31039.fqn:null);
switch (G__31042) {
case "domain":
return self__.domain;

break;
case "range":
return self__.range;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k31039,else__6835__auto__);

}
});

c2.scale._linear.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__6846__auto__,writer__6847__auto__,opts__6848__auto__){
var self__ = this;
var this__6846__auto____$1 = this;
var pr_pair__6849__auto__ = ((function (this__6846__auto____$1){
return (function (keyval__6850__auto__){
return cljs.core.pr_sequential_writer(writer__6847__auto__,cljs.core.pr_writer,""," ","",opts__6848__auto__,keyval__6850__auto__);
});})(this__6846__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__6847__auto__,pr_pair__6849__auto__,"#c2.scale._linear{",", ","}",opts__6848__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$domain,self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$range,self__.range],null))], null),self__.__extmap));
});

c2.scale._linear.prototype.cljs$core$IIterable$ = true;

c2.scale._linear.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31038){
var self__ = this;
var G__31038__$1 = this;
return (new cljs.core.RecordIter((0),G__31038__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$domain,cljs.core.cst$kw$range], null),cljs.core._iterator(self__.__extmap)));
});

c2.scale._linear.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__6830__auto__){
var self__ = this;
var this__6830__auto____$1 = this;
return self__.__meta;
});

c2.scale._linear.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__6826__auto__){
var self__ = this;
var this__6826__auto____$1 = this;
return (new c2.scale._linear(self__.domain,self__.range,self__.__meta,self__.__extmap,self__.__hash));
});

c2.scale._linear.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__6836__auto__){
var self__ = this;
var this__6836__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

c2.scale._linear.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__6827__auto__){
var self__ = this;
var this__6827__auto____$1 = this;
var h__6645__auto__ = self__.__hash;
if(!((h__6645__auto__ == null))){
return h__6645__auto__;
} else {
var h__6645__auto____$1 = cljs.core.hash_imap(this__6827__auto____$1);
self__.__hash = h__6645__auto____$1;

return h__6645__auto____$1;
}
});

c2.scale._linear.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__6828__auto__,other__6829__auto__){
var self__ = this;
var this__6828__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6198__auto__ = other__6829__auto__;
if(cljs.core.truth_(and__6198__auto__)){
var and__6198__auto____$1 = (this__6828__auto____$1.constructor === other__6829__auto__.constructor);
if(and__6198__auto____$1){
return cljs.core.equiv_map(this__6828__auto____$1,other__6829__auto__);
} else {
return and__6198__auto____$1;
}
} else {
return and__6198__auto__;
}
})())){
return true;
} else {
return false;
}
});

c2.scale._linear.prototype.c2$scale$IInvertable$ = true;

c2.scale._linear.prototype.c2$scale$IInvertable$invert$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(this$__$1,cljs.core.cst$kw$domain,self__.range,cljs.core.array_seq([cljs.core.cst$kw$range,self__.domain], 0));
});

c2.scale._linear.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__6841__auto__,k__6842__auto__){
var self__ = this;
var this__6841__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$domain,null,cljs.core.cst$kw$range,null], null), null),k__6842__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__6841__auto____$1),self__.__meta),k__6842__auto__);
} else {
return (new c2.scale._linear(self__.domain,self__.range,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__6842__auto__)),null));
}
});

c2.scale._linear.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__6839__auto__,k__6840__auto__,G__31038){
var self__ = this;
var this__6839__auto____$1 = this;
var pred__31043 = cljs.core.keyword_identical_QMARK_;
var expr__31044 = k__6840__auto__;
if(cljs.core.truth_((pred__31043.cljs$core$IFn$_invoke$arity$2 ? pred__31043.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$domain,expr__31044) : pred__31043.call(null,cljs.core.cst$kw$domain,expr__31044)))){
return (new c2.scale._linear(G__31038,self__.range,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31043.cljs$core$IFn$_invoke$arity$2 ? pred__31043.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$range,expr__31044) : pred__31043.call(null,cljs.core.cst$kw$range,expr__31044)))){
return (new c2.scale._linear(self__.domain,G__31038,self__.__meta,self__.__extmap,null));
} else {
return (new c2.scale._linear(self__.domain,self__.range,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__6840__auto__,G__31038),null));
}
}
});

c2.scale._linear.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__6844__auto__){
var self__ = this;
var this__6844__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$domain,self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$range,self__.range],null))], null),self__.__extmap));
});

c2.scale._linear.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__6831__auto__,G__31038){
var self__ = this;
var this__6831__auto____$1 = this;
return (new c2.scale._linear(self__.domain,self__.range,G__31038,self__.__extmap,self__.__hash));
});

c2.scale._linear.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__6837__auto__,entry__6838__auto__){
var self__ = this;
var this__6837__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__6838__auto__)){
return cljs.core._assoc(this__6837__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__6838__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__6838__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__6837__auto____$1,entry__6838__auto__);
}
});

c2.scale._linear.prototype.call = (function (self__,x){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var domain_length = (cljs.core.last(self__.domain) - cljs.core.first(self__.domain));
var range_length = (cljs.core.last(self__.range) - cljs.core.first(self__.range));
return (cljs.core.first(self__.range) + (range_length * ((x - cljs.core.first(self__.domain)) / domain_length)));
});

c2.scale._linear.prototype.apply = (function (self__,args31041){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args31041)));
});

c2.scale._linear.prototype.cljs$core$IFn$_invoke$arity$1 = (function (x){
var self__ = this;
var _ = this;
var domain_length = (cljs.core.last(self__.domain) - cljs.core.first(self__.domain));
var range_length = (cljs.core.last(self__.range) - cljs.core.first(self__.range));
return (cljs.core.first(self__.range) + (range_length * ((x - cljs.core.first(self__.domain)) / domain_length)));
});

c2.scale._linear.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$domain,cljs.core.cst$sym$range], null);
});

c2.scale._linear.cljs$lang$type = true;

c2.scale._linear.cljs$lang$ctorPrSeq = (function (this__6866__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"c2.scale/_linear");
});

c2.scale._linear.cljs$lang$ctorPrWriter = (function (this__6866__auto__,writer__6867__auto__){
return cljs.core._write(writer__6867__auto__,"c2.scale/_linear");
});

c2.scale.__GT__linear = (function c2$scale$__GT__linear(domain,range){
return (new c2.scale._linear(domain,range,null,null,null));
});

c2.scale.map__GT__linear = (function c2$scale$map__GT__linear(G__31040){
return (new c2.scale._linear(cljs.core.cst$kw$domain.cljs$core$IFn$_invoke$arity$1(G__31040),cljs.core.cst$kw$range.cljs$core$IFn$_invoke$arity$1(G__31040),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__31040,cljs.core.cst$kw$domain,cljs.core.array_seq([cljs.core.cst$kw$range], 0)),null));
});


c2.scale.linear = (function c2$scale$linear(var_args){
var args__7287__auto__ = [];
var len__7280__auto___31048 = arguments.length;
var i__7281__auto___31049 = (0);
while(true){
if((i__7281__auto___31049 < len__7280__auto___31048)){
args__7287__auto__.push((arguments[i__7281__auto___31049]));

var G__31050 = (i__7281__auto___31049 + (1));
i__7281__auto___31049 = G__31050;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((0) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((0)),(0),null)):null);
return c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(argseq__7288__auto__);
});

c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic = (function (kwargs){
return c2.scale.map__GT__linear(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null)], null),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,kwargs)], 0)));
});

c2.scale.linear.cljs$lang$maxFixedArity = (0);

c2.scale.linear.cljs$lang$applyTo = (function (seq31046){
return c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq31046));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
c2.scale._power = (function (domain,range,__meta,__extmap,__hash){
this.domain = domain;
this.range = range;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667595;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
c2.scale._power.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__6832__auto__,k__6833__auto__){
var self__ = this;
var this__6832__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__6832__auto____$1,k__6833__auto__,null);
});

c2.scale._power.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__6834__auto__,k31052,else__6835__auto__){
var self__ = this;
var this__6834__auto____$1 = this;
var G__31055 = (((k31052 instanceof cljs.core.Keyword))?k31052.fqn:null);
switch (G__31055) {
case "domain":
return self__.domain;

break;
case "range":
return self__.range;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k31052,else__6835__auto__);

}
});

c2.scale._power.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__6846__auto__,writer__6847__auto__,opts__6848__auto__){
var self__ = this;
var this__6846__auto____$1 = this;
var pr_pair__6849__auto__ = ((function (this__6846__auto____$1){
return (function (keyval__6850__auto__){
return cljs.core.pr_sequential_writer(writer__6847__auto__,cljs.core.pr_writer,""," ","",opts__6848__auto__,keyval__6850__auto__);
});})(this__6846__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__6847__auto__,pr_pair__6849__auto__,"#c2.scale._power{",", ","}",opts__6848__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$domain,self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$range,self__.range],null))], null),self__.__extmap));
});

c2.scale._power.prototype.cljs$core$IIterable$ = true;

c2.scale._power.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31051){
var self__ = this;
var G__31051__$1 = this;
return (new cljs.core.RecordIter((0),G__31051__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$domain,cljs.core.cst$kw$range], null),cljs.core._iterator(self__.__extmap)));
});

c2.scale._power.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__6830__auto__){
var self__ = this;
var this__6830__auto____$1 = this;
return self__.__meta;
});

c2.scale._power.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__6826__auto__){
var self__ = this;
var this__6826__auto____$1 = this;
return (new c2.scale._power(self__.domain,self__.range,self__.__meta,self__.__extmap,self__.__hash));
});

c2.scale._power.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__6836__auto__){
var self__ = this;
var this__6836__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

c2.scale._power.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__6827__auto__){
var self__ = this;
var this__6827__auto____$1 = this;
var h__6645__auto__ = self__.__hash;
if(!((h__6645__auto__ == null))){
return h__6645__auto__;
} else {
var h__6645__auto____$1 = cljs.core.hash_imap(this__6827__auto____$1);
self__.__hash = h__6645__auto____$1;

return h__6645__auto____$1;
}
});

c2.scale._power.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__6828__auto__,other__6829__auto__){
var self__ = this;
var this__6828__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6198__auto__ = other__6829__auto__;
if(cljs.core.truth_(and__6198__auto__)){
var and__6198__auto____$1 = (this__6828__auto____$1.constructor === other__6829__auto__.constructor);
if(and__6198__auto____$1){
return cljs.core.equiv_map(this__6828__auto____$1,other__6829__auto__);
} else {
return and__6198__auto____$1;
}
} else {
return and__6198__auto__;
}
})())){
return true;
} else {
return false;
}
});

c2.scale._power.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__6841__auto__,k__6842__auto__){
var self__ = this;
var this__6841__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$domain,null,cljs.core.cst$kw$range,null], null), null),k__6842__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__6841__auto____$1),self__.__meta),k__6842__auto__);
} else {
return (new c2.scale._power(self__.domain,self__.range,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__6842__auto__)),null));
}
});

c2.scale._power.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__6839__auto__,k__6840__auto__,G__31051){
var self__ = this;
var this__6839__auto____$1 = this;
var pred__31056 = cljs.core.keyword_identical_QMARK_;
var expr__31057 = k__6840__auto__;
if(cljs.core.truth_((pred__31056.cljs$core$IFn$_invoke$arity$2 ? pred__31056.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$domain,expr__31057) : pred__31056.call(null,cljs.core.cst$kw$domain,expr__31057)))){
return (new c2.scale._power(G__31051,self__.range,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31056.cljs$core$IFn$_invoke$arity$2 ? pred__31056.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$range,expr__31057) : pred__31056.call(null,cljs.core.cst$kw$range,expr__31057)))){
return (new c2.scale._power(self__.domain,G__31051,self__.__meta,self__.__extmap,null));
} else {
return (new c2.scale._power(self__.domain,self__.range,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__6840__auto__,G__31051),null));
}
}
});

c2.scale._power.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__6844__auto__){
var self__ = this;
var this__6844__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$domain,self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$range,self__.range],null))], null),self__.__extmap));
});

c2.scale._power.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__6831__auto__,G__31051){
var self__ = this;
var this__6831__auto____$1 = this;
return (new c2.scale._power(self__.domain,self__.range,G__31051,self__.__extmap,self__.__hash));
});

c2.scale._power.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__6837__auto__,entry__6838__auto__){
var self__ = this;
var this__6837__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__6838__auto__)){
return cljs.core._assoc(this__6837__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__6838__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__6838__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__6837__auto____$1,entry__6838__auto__);
}
});

c2.scale._power.prototype.call = (function (self__,x){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,cljs.core.map.cljs$core$IFn$_invoke$arity$2(c2.maths.expt,self__.domain),cljs.core.cst$kw$range,self__.range], 0)),c2.maths.expt).call(null,x);
});

c2.scale._power.prototype.apply = (function (self__,args31054){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args31054)));
});

c2.scale._power.prototype.cljs$core$IFn$_invoke$arity$1 = (function (x){
var self__ = this;
var _ = this;
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,cljs.core.map.cljs$core$IFn$_invoke$arity$2(c2.maths.expt,self__.domain),cljs.core.cst$kw$range,self__.range], 0)),c2.maths.expt).call(null,x);
});

c2.scale._power.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$domain,cljs.core.cst$sym$range], null);
});

c2.scale._power.cljs$lang$type = true;

c2.scale._power.cljs$lang$ctorPrSeq = (function (this__6866__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"c2.scale/_power");
});

c2.scale._power.cljs$lang$ctorPrWriter = (function (this__6866__auto__,writer__6867__auto__){
return cljs.core._write(writer__6867__auto__,"c2.scale/_power");
});

c2.scale.__GT__power = (function c2$scale$__GT__power(domain,range){
return (new c2.scale._power(domain,range,null,null,null));
});

c2.scale.map__GT__power = (function c2$scale$map__GT__power(G__31053){
return (new c2.scale._power(cljs.core.cst$kw$domain.cljs$core$IFn$_invoke$arity$1(G__31053),cljs.core.cst$kw$range.cljs$core$IFn$_invoke$arity$1(G__31053),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__31053,cljs.core.cst$kw$domain,cljs.core.array_seq([cljs.core.cst$kw$range], 0)),null));
});


c2.scale.power = (function c2$scale$power(var_args){
var args__7287__auto__ = [];
var len__7280__auto___31061 = arguments.length;
var i__7281__auto___31062 = (0);
while(true){
if((i__7281__auto___31062 < len__7280__auto___31061)){
args__7287__auto__.push((arguments[i__7281__auto___31062]));

var G__31063 = (i__7281__auto___31062 + (1));
i__7281__auto___31062 = G__31063;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((0) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((0)),(0),null)):null);
return c2.scale.power.cljs$core$IFn$_invoke$arity$variadic(argseq__7288__auto__);
});

c2.scale.power.cljs$core$IFn$_invoke$arity$variadic = (function (kwargs){
return c2.scale.map__GT__power(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null)], null),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,kwargs)], 0)));
});

c2.scale.power.cljs$lang$maxFixedArity = (0);

c2.scale.power.cljs$lang$applyTo = (function (seq31059){
return c2.scale.power.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq31059));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
c2.scale._log = (function (domain,range,__meta,__extmap,__hash){
this.domain = domain;
this.range = range;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667595;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
c2.scale._log.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__6832__auto__,k__6833__auto__){
var self__ = this;
var this__6832__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__6832__auto____$1,k__6833__auto__,null);
});

c2.scale._log.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__6834__auto__,k31065,else__6835__auto__){
var self__ = this;
var this__6834__auto____$1 = this;
var G__31068 = (((k31065 instanceof cljs.core.Keyword))?k31065.fqn:null);
switch (G__31068) {
case "domain":
return self__.domain;

break;
case "range":
return self__.range;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k31065,else__6835__auto__);

}
});

c2.scale._log.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__6846__auto__,writer__6847__auto__,opts__6848__auto__){
var self__ = this;
var this__6846__auto____$1 = this;
var pr_pair__6849__auto__ = ((function (this__6846__auto____$1){
return (function (keyval__6850__auto__){
return cljs.core.pr_sequential_writer(writer__6847__auto__,cljs.core.pr_writer,""," ","",opts__6848__auto__,keyval__6850__auto__);
});})(this__6846__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__6847__auto__,pr_pair__6849__auto__,"#c2.scale._log{",", ","}",opts__6848__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$domain,self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$range,self__.range],null))], null),self__.__extmap));
});

c2.scale._log.prototype.cljs$core$IIterable$ = true;

c2.scale._log.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31064){
var self__ = this;
var G__31064__$1 = this;
return (new cljs.core.RecordIter((0),G__31064__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$domain,cljs.core.cst$kw$range], null),cljs.core._iterator(self__.__extmap)));
});

c2.scale._log.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__6830__auto__){
var self__ = this;
var this__6830__auto____$1 = this;
return self__.__meta;
});

c2.scale._log.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__6826__auto__){
var self__ = this;
var this__6826__auto____$1 = this;
return (new c2.scale._log(self__.domain,self__.range,self__.__meta,self__.__extmap,self__.__hash));
});

c2.scale._log.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__6836__auto__){
var self__ = this;
var this__6836__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

c2.scale._log.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__6827__auto__){
var self__ = this;
var this__6827__auto____$1 = this;
var h__6645__auto__ = self__.__hash;
if(!((h__6645__auto__ == null))){
return h__6645__auto__;
} else {
var h__6645__auto____$1 = cljs.core.hash_imap(this__6827__auto____$1);
self__.__hash = h__6645__auto____$1;

return h__6645__auto____$1;
}
});

c2.scale._log.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__6828__auto__,other__6829__auto__){
var self__ = this;
var this__6828__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6198__auto__ = other__6829__auto__;
if(cljs.core.truth_(and__6198__auto__)){
var and__6198__auto____$1 = (this__6828__auto____$1.constructor === other__6829__auto__.constructor);
if(and__6198__auto____$1){
return cljs.core.equiv_map(this__6828__auto____$1,other__6829__auto__);
} else {
return and__6198__auto____$1;
}
} else {
return and__6198__auto__;
}
})())){
return true;
} else {
return false;
}
});

c2.scale._log.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__6841__auto__,k__6842__auto__){
var self__ = this;
var this__6841__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$domain,null,cljs.core.cst$kw$range,null], null), null),k__6842__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__6841__auto____$1),self__.__meta),k__6842__auto__);
} else {
return (new c2.scale._log(self__.domain,self__.range,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__6842__auto__)),null));
}
});

c2.scale._log.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__6839__auto__,k__6840__auto__,G__31064){
var self__ = this;
var this__6839__auto____$1 = this;
var pred__31069 = cljs.core.keyword_identical_QMARK_;
var expr__31070 = k__6840__auto__;
if(cljs.core.truth_((pred__31069.cljs$core$IFn$_invoke$arity$2 ? pred__31069.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$domain,expr__31070) : pred__31069.call(null,cljs.core.cst$kw$domain,expr__31070)))){
return (new c2.scale._log(G__31064,self__.range,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31069.cljs$core$IFn$_invoke$arity$2 ? pred__31069.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$range,expr__31070) : pred__31069.call(null,cljs.core.cst$kw$range,expr__31070)))){
return (new c2.scale._log(self__.domain,G__31064,self__.__meta,self__.__extmap,null));
} else {
return (new c2.scale._log(self__.domain,self__.range,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__6840__auto__,G__31064),null));
}
}
});

c2.scale._log.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__6844__auto__){
var self__ = this;
var this__6844__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$domain,self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$range,self__.range],null))], null),self__.__extmap));
});

c2.scale._log.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__6831__auto__,G__31064){
var self__ = this;
var this__6831__auto____$1 = this;
return (new c2.scale._log(self__.domain,self__.range,G__31064,self__.__extmap,self__.__hash));
});

c2.scale._log.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__6837__auto__,entry__6838__auto__){
var self__ = this;
var this__6837__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__6838__auto__)){
return cljs.core._assoc(this__6837__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__6838__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__6838__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__6837__auto____$1,entry__6838__auto__);
}
});

c2.scale._log.prototype.call = (function (self__,x){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,cljs.core.map.cljs$core$IFn$_invoke$arity$2(c2.maths.log,self__.domain),cljs.core.cst$kw$range,self__.range], 0)),c2.maths.log).call(null,x);
});

c2.scale._log.prototype.apply = (function (self__,args31067){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args31067)));
});

c2.scale._log.prototype.cljs$core$IFn$_invoke$arity$1 = (function (x){
var self__ = this;
var _ = this;
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,cljs.core.map.cljs$core$IFn$_invoke$arity$2(c2.maths.log,self__.domain),cljs.core.cst$kw$range,self__.range], 0)),c2.maths.log).call(null,x);
});

c2.scale._log.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$domain,cljs.core.cst$sym$range], null);
});

c2.scale._log.cljs$lang$type = true;

c2.scale._log.cljs$lang$ctorPrSeq = (function (this__6866__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"c2.scale/_log");
});

c2.scale._log.cljs$lang$ctorPrWriter = (function (this__6866__auto__,writer__6867__auto__){
return cljs.core._write(writer__6867__auto__,"c2.scale/_log");
});

c2.scale.__GT__log = (function c2$scale$__GT__log(domain,range){
return (new c2.scale._log(domain,range,null,null,null));
});

c2.scale.map__GT__log = (function c2$scale$map__GT__log(G__31066){
return (new c2.scale._log(cljs.core.cst$kw$domain.cljs$core$IFn$_invoke$arity$1(G__31066),cljs.core.cst$kw$range.cljs$core$IFn$_invoke$arity$1(G__31066),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__31066,cljs.core.cst$kw$domain,cljs.core.array_seq([cljs.core.cst$kw$range], 0)),null));
});


c2.scale.log = (function c2$scale$log(var_args){
var args__7287__auto__ = [];
var len__7280__auto___31074 = arguments.length;
var i__7281__auto___31075 = (0);
while(true){
if((i__7281__auto___31075 < len__7280__auto___31074)){
args__7287__auto__.push((arguments[i__7281__auto___31075]));

var G__31076 = (i__7281__auto___31075 + (1));
i__7281__auto___31075 = G__31076;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((0) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((0)),(0),null)):null);
return c2.scale.log.cljs$core$IFn$_invoke$arity$variadic(argseq__7288__auto__);
});

c2.scale.log.cljs$core$IFn$_invoke$arity$variadic = (function (kwargs){
return c2.scale.map__GT__log(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(10)], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null)], null),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,kwargs)], 0)));
});

c2.scale.log.cljs$lang$maxFixedArity = (0);

c2.scale.log.cljs$lang$applyTo = (function (seq31072){
return c2.scale.log.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq31072));
});
