// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Extra fields that will be displayed on the table.
 */
hatti.views.table.get_extra_fields = (function hatti$views$table$get_extra_fields(is_filtered_dataview_QMARK_){
var extra_field = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$full_DASH_name,hatti.constants._id,cljs.core.cst$kw$label,"id",cljs.core.cst$kw$name,hatti.constants._id,cljs.core.cst$kw$type,"integer"], null)], null);
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
return extra_field;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(extra_field,hatti.ona.forms.submission_time_field);
}
});
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(var_args){
var args__5634__auto__ = [];
var len__5627__auto___28837 = arguments.length;
var i__5628__auto___28838 = (0);
while(true){
if((i__5628__auto___28838 < len__5627__auto___28837)){
args__5634__auto__.push((arguments[i__5628__auto___28838]));

var G__28839 = (i__5628__auto___28838 + (1));
i__5628__auto___28838 = G__28839;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__28834){
var map__28835 = p__28834;
var map__28835__$1 = ((((!((map__28835 == null)))?((((map__28835.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28835.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28835):map__28835);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28835__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.has_data_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(hatti.views.table.get_extra_fields(is_filtered_dataview_QMARK_),hatti.ona.forms.non_meta_fields(form),cljs.core.array_seq([hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,cljs.core.not(is_filtered_dataview_QMARK_)], 0))], 0))));
});

hatti.views.table.all_fields.cljs$lang$maxFixedArity = (1);

hatti.views.table.all_fields.cljs$lang$applyTo = (function (seq28832){
var G__28833 = cljs.core.first(seq28832);
var seq28832__$1 = cljs.core.next(seq28832);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(G__28833,seq28832__$1);
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__28840_SHARP_){
if(typeof p1__28840_SHARP_ === 'string'){
return clojure.string.lower_case(p1__28840_SHARP_);
} else {
return p1__28840_SHARP_;
}
});})(col))
;
var aval = lower((a[(col["field"])]));
var bval = lower((b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not(args)){
return true;
} else {
var indexed_form = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full_DASH_name,form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__28844){
var vec__28845 = p__28844;
var fname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28845,(0),null);
var answer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28845,(1),null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(indexed_form,fname),answer,null,true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (indexed_form,query,fmt_subitem){
return (function (p1__28841_SHARP_){
return cljs.core.re_find(hatti.utils.safe_regex(query),[cljs.core.str(p1__28841_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fmt_subitem,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(item))));
return cljs.core.seq(filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(value,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4(field,clj_value,language,true);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args28846 = [];
var len__5627__auto___28870 = arguments.length;
var i__5628__auto___28871 = (0);
while(true){
if((i__5628__auto___28871 < len__5627__auto___28870)){
args28846.push((arguments[i__5628__auto___28871]));

var G__28872 = (i__5628__auto___28871 + (1));
i__5628__auto___28871 = G__28872;
continue;
} else {
}
break;
}

var G__28852 = args28846.length;
switch (G__28852) {
case 1:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args28846.slice((3)),(0)));
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5646__auto__);

}
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1 = (function (form){
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2(form,true);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2 = (function (form,get_label_QMARK_){
return hatti.views.table.flat_form__GT_sg_columns(form,get_label_QMARK_,null);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,get_label_QMARK_,language,p__28853){
var map__28854 = p__28853;
var map__28854__$1 = ((((!((map__28854 == null)))?((((map__28854.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28854.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28854):map__28854);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28854__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
return cljs.core.clj__GT_js((function (){var iter__5341__auto__ = ((function (map__28854,map__28854__$1,is_filtered_dataview_QMARK_){
return (function hatti$views$table$iter__28856(s__28857){
return (new cljs.core.LazySeq(null,((function (map__28854,map__28854__$1,is_filtered_dataview_QMARK_){
return (function (){
var s__28857__$1 = s__28857;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__28857__$1);
if(temp__4425__auto__){
var s__28857__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__28857__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__28857__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__28859 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__28858 = (0);
while(true){
if((i__28858 < size__5340__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__28858);
cljs.core.chunk_append(b__28859,(function (){var map__28866 = field;
var map__28866__$1 = ((((!((map__28866 == null)))?((((map__28866.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28866.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28866):map__28866);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28866__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28866__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28866__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hatti.ona.forms.get_column_class(field),label,cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class(field),label]);
})());

var G__28874 = (i__28858 + (1));
i__28858 = G__28874;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__28859),hatti$views$table$iter__28856(cljs.core.chunk_rest(s__28857__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__28859),null);
}
} else {
var field = cljs.core.first(s__28857__$2);
return cljs.core.cons((function (){var map__28868 = field;
var map__28868__$1 = ((((!((map__28868 == null)))?((((map__28868.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28868.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28868):map__28868);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28868__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28868__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28868__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hatti.ona.forms.get_column_class(field),label,cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class(field),label]);
})(),hatti$views$table$iter__28856(cljs.core.rest(s__28857__$2)));
}
} else {
return null;
}
break;
}
});})(map__28854,map__28854__$1,is_filtered_dataview_QMARK_))
,null,null));
});})(map__28854,map__28854__$1,is_filtered_dataview_QMARK_))
;
return iter__5341__auto__(hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], 0)));
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq28847){
var G__28848 = cljs.core.first(seq28847);
var seq28847__$1 = cljs.core.next(seq28847);
var G__28849 = cljs.core.first(seq28847__$1);
var seq28847__$2 = cljs.core.next(seq28847__$1);
var G__28850 = cljs.core.first(seq28847__$2);
var seq28847__$3 = cljs.core.next(seq28847__$2);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__28848,G__28849,G__28850,seq28847__$3);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (3);
hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,(function (){var G__28876 = [cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join('');
return jQuery(G__28876);
})()));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = {"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false};
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__28887(s__28888){
return (new cljs.core.LazySeq(null,(function (){
var s__28888__$1 = s__28888;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__28888__$1);
if(temp__4425__auto__){
var s__28888__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__28888__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__28888__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__28890 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__28889 = (0);
while(true){
if((i__28889 < size__5340__auto__)){
var vec__28895 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__28889);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28895,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28895,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append(b__28890,event.subscribe(handler_function));

var G__28897 = (i__28889 + (1));
i__28889 = G__28897;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__28890),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__28887(cljs.core.chunk_rest(s__28888__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__28890),null);
}
} else {
var vec__28896 = cljs.core.first(s__28888__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28896,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28896,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__28887(cljs.core.rest(s__28888__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__28908(s__28909){
return (new cljs.core.LazySeq(null,(function (){
var s__28909__$1 = s__28909;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__28909__$1);
if(temp__4425__auto__){
var s__28909__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__28909__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__28909__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__28911 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__28910 = (0);
while(true){
if((i__28910 < size__5340__auto__)){
var vec__28916 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__28910);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28916,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28916,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append(b__28911,event.subscribe(handler_function));

var G__28918 = (i__28910 + (1));
i__28910 = G__28918;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__28911),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__28908(cljs.core.chunk_rest(s__28909__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__28911),null);
}
} else {
var vec__28917 = cljs.core.first(s__28909__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28917,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28917,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__28908(cljs.core.rest(s__28909__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,is_filtered_dataview_QMARK_,p__28919){
var map__28928 = p__28919;
var map__28928__$1 = ((((!((map__28928 == null)))?((((map__28928.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28928.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28928):map__28928);
var grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28928__$1,cljs.core.cst$kw$grid_DASH_event_DASH_handlers);
var dataview_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28928__$1,cljs.core.cst$kw$dataview_DASH_event_DASH_handlers);
var columns = hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(form,true,current_language,cljs.core.array_seq([cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], 0));
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
var map__28930 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__28930__$1 = ((((!((map__28930 == null)))?((((map__28930.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28930.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28930):map__28930);
var map__28931 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28930__$1,cljs.core.cst$kw$table_DASH_page);
var map__28931__$1 = ((((!((map__28931 == null)))?((((map__28931.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28931.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28931):map__28931);
var map__28932 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28931__$1,cljs.core.cst$kw$paging);
var map__28932__$1 = ((((!((map__28932 == null)))?((((map__28932.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28932.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28932):map__28932);
var num_displayed_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28932__$1,cljs.core.cst$kw$num_DASH_displayed_DASH_records);
var total_page_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28932__$1,cljs.core.cst$kw$total_DASH_page_DASH_count);
hatti.views.table.bind_external_sg_grid_event_handlers(grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers(dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__28930,map__28930__$1,map__28931,map__28931__$1,map__28932,map__28932__$1,num_displayed_records,total_page_count,map__28928,map__28928__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__28930,map__28930__$1,map__28931,map__28931__$1,map__28932,map__28932__$1,num_displayed_records,total_page_count,map__28928,map__28928__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__28930,map__28930__$1,map__28931,map__28931__$1,map__28932,map__28932__$1,num_displayed_records,total_page_count,map__28928,map__28928__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__28930,map__28930__$1,map__28931,map__28931__$1,map__28932,map__28932__$1,num_displayed_records,total_page_count,map__28928,map__28928__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__28930,map__28930__$1,map__28931,map__28931__$1,map__28932,map__28932__$1,num_displayed_records,total_page_count,map__28928,map__28928__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
});})(columns,SlickGrid,DataView,dataview,grid,map__28930,map__28930__$1,map__28931,map__28931__$1,map__28932,map__28932__$1,num_displayed_records,total_page_count,map__28928,map__28928__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager(grid,dataview);

dataview.setPagingOptions({"pageSize": (function (){var or__4569__auto__ = num_displayed_records;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count});

dataview.setFilter(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js(data),hatti.constants._id);

hatti.views.table.resizeColumns(grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap();
var c__7694__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7694__auto__,event_chan){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto__,event_chan){
return (function (state_29197){
var state_val_29198 = (state_29197[(1)]);
if((state_val_29198 === (7))){
var inst_29106 = (state_29197[(7)]);
var inst_29106__$1 = (state_29197[(2)]);
var inst_29108 = (inst_29106__$1 == null);
var inst_29109 = cljs.core.not(inst_29108);
var state_29197__$1 = (function (){var statearr_29199 = state_29197;
(statearr_29199[(7)] = inst_29106__$1);

return statearr_29199;
})();
if(inst_29109){
var statearr_29200_29267 = state_29197__$1;
(statearr_29200_29267[(1)] = (8));

} else {
var statearr_29201_29268 = state_29197__$1;
(statearr_29201_29268[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (20))){
var inst_29128 = (state_29197[(8)]);
var inst_29136 = (state_29197[(9)]);
var inst_29145 = (inst_29136.cljs$core$IFn$_invoke$arity$1 ? inst_29136.cljs$core$IFn$_invoke$arity$1(inst_29128) : inst_29136.call(null,inst_29128));
var state_29197__$1 = state_29197;
var statearr_29202_29269 = state_29197__$1;
(statearr_29202_29269[(2)] = inst_29145);

(statearr_29202_29269[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (27))){
var state_29197__$1 = state_29197;
var statearr_29203_29270 = state_29197__$1;
(statearr_29203_29270[(2)] = null);

(statearr_29203_29270[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (1))){
var state_29197__$1 = state_29197;
var statearr_29204_29271 = state_29197__$1;
(statearr_29204_29271[(2)] = null);

(statearr_29204_29271[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (24))){
var state_29197__$1 = state_29197;
var statearr_29205_29272 = state_29197__$1;
(statearr_29205_29272[(2)] = null);

(statearr_29205_29272[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (4))){
var state_29197__$1 = state_29197;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29197__$1,(7),event_chan);
} else {
if((state_val_29198 === (15))){
var inst_29106 = (state_29197[(7)]);
var state_29197__$1 = state_29197;
var statearr_29206_29273 = state_29197__$1;
(statearr_29206_29273[(2)] = inst_29106);

(statearr_29206_29273[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (21))){
var state_29197__$1 = state_29197;
var statearr_29207_29274 = state_29197__$1;
(statearr_29207_29274[(2)] = null);

(statearr_29207_29274[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (31))){
var inst_29132 = (state_29197[(10)]);
var inst_29170 = (state_29197[(2)]);
var inst_29171 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29132,cljs.core.cst$kw$table);
var state_29197__$1 = (function (){var statearr_29208 = state_29197;
(statearr_29208[(11)] = inst_29170);

return statearr_29208;
})();
if(inst_29171){
var statearr_29209_29275 = state_29197__$1;
(statearr_29209_29275[(1)] = (32));

} else {
var statearr_29210_29276 = state_29197__$1;
(statearr_29210_29276[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (32))){
var inst_29127 = (state_29197[(12)]);
var inst_29130 = (state_29197[(13)]);
var inst_29128 = (state_29197[(8)]);
var inst_29131 = (state_29197[(14)]);
var inst_29132 = (state_29197[(10)]);
var inst_29126 = (state_29197[(15)]);
var inst_29129 = (state_29197[(16)]);
var inst_29136 = (state_29197[(9)]);
var inst_29106 = (state_29197[(7)]);
var inst_29137 = (state_29197[(17)]);
var inst_29184 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_29185 = (function (){var new_columns = inst_29131;
var submission_clicked = inst_29128;
var submission_unclicked = inst_29129;
var get_submission_data = inst_29137;
var re_render = inst_29132;
var update_data_BANG_ = inst_29136;
var c__7694__auto____$1 = inst_29184;
var submission_to_rank = inst_29127;
var e = inst_29106;
var map__29104 = inst_29126;
var filter_by = inst_29130;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__7694__auto____$1,submission_to_rank,e,map__29104,filter_by,inst_29127,inst_29130,inst_29128,inst_29131,inst_29132,inst_29126,inst_29129,inst_29136,inst_29106,inst_29137,inst_29184,state_val_29198,c__7694__auto__,event_chan){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__7694__auto____$1,submission_to_rank,e,map__29104,filter_by,inst_29127,inst_29130,inst_29128,inst_29131,inst_29132,inst_29126,inst_29129,inst_29136,inst_29106,inst_29137,inst_29184,state_val_29198,c__7694__auto__,event_chan){
return (function (state_29182){
var state_val_29183 = (state_29182[(1)]);
if((state_val_29183 === (1))){
var inst_29173 = cljs.core.async.timeout((20));
var state_29182__$1 = state_29182;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29182__$1,(2),inst_29173);
} else {
if((state_val_29183 === (2))){
var inst_29175 = (state_29182[(2)]);
var inst_29176 = grid.resizeCanvas();
var inst_29177 = grid.invalidateAllRows();
var inst_29178 = hatti.views.table.resizeColumns(grid);
var inst_29179 = grid.render();
var inst_29180 = hatti.views.table.init_sg_pager(grid,dataview);
var state_29182__$1 = (function (){var statearr_29211 = state_29182;
(statearr_29211[(7)] = inst_29178);

(statearr_29211[(8)] = inst_29177);

(statearr_29211[(9)] = inst_29176);

(statearr_29211[(10)] = inst_29175);

(statearr_29211[(11)] = inst_29179);

return statearr_29211;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_29182__$1,inst_29180);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__7694__auto____$1,submission_to_rank,e,map__29104,filter_by,inst_29127,inst_29130,inst_29128,inst_29131,inst_29132,inst_29126,inst_29129,inst_29136,inst_29106,inst_29137,inst_29184,state_val_29198,c__7694__auto__,event_chan))
;
return ((function (switch__7673__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__7694__auto____$1,submission_to_rank,e,map__29104,filter_by,inst_29127,inst_29130,inst_29128,inst_29131,inst_29132,inst_29126,inst_29129,inst_29136,inst_29106,inst_29137,inst_29184,state_val_29198,c__7694__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__7674__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__7674__auto____0 = (function (){
var statearr_29215 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29215[(0)] = hatti$views$table$handle_table_events_$_state_machine__7674__auto__);

(statearr_29215[(1)] = (1));

return statearr_29215;
});
var hatti$views$table$handle_table_events_$_state_machine__7674__auto____1 = (function (state_29182){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__(state_29182);
if(cljs.core.keyword_identical_QMARK_(result__7676__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e29216){if((e29216 instanceof Object)){
var ex__7677__auto__ = e29216;
var statearr_29217_29277 = state_29182;
(statearr_29217_29277[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29182);

return cljs.core.cst$kw$recur;
} else {
throw e29216;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7675__auto__,cljs.core.cst$kw$recur)){
var G__29278 = state_29182;
state_29182 = G__29278;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__7674__auto__ = function(state_29182){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__7674__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__7674__auto____1.call(this,state_29182);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__7674__auto____0;
hatti$views$table$handle_table_events_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__7674__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__7694__auto____$1,submission_to_rank,e,map__29104,filter_by,inst_29127,inst_29130,inst_29128,inst_29131,inst_29132,inst_29126,inst_29129,inst_29136,inst_29106,inst_29137,inst_29184,state_val_29198,c__7694__auto__,event_chan))
})();
var state__7696__auto__ = (function (){var statearr_29218 = (f__7695__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7695__auto__.cljs$core$IFn$_invoke$arity$0() : f__7695__auto__.call(null));
(statearr_29218[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto____$1);

return statearr_29218;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7696__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__7694__auto____$1,submission_to_rank,e,map__29104,filter_by,inst_29127,inst_29130,inst_29128,inst_29131,inst_29132,inst_29126,inst_29129,inst_29136,inst_29106,inst_29137,inst_29184,state_val_29198,c__7694__auto__,event_chan))
})();
var inst_29186 = cljs.core.async.impl.dispatch.run(inst_29185);
var state_29197__$1 = (function (){var statearr_29219 = state_29197;
(statearr_29219[(18)] = inst_29186);

return statearr_29219;
})();
var statearr_29220_29279 = state_29197__$1;
(statearr_29220_29279[(2)] = inst_29184);

(statearr_29220_29279[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (33))){
var state_29197__$1 = state_29197;
var statearr_29221_29280 = state_29197__$1;
(statearr_29221_29280[(2)] = null);

(statearr_29221_29280[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (13))){
var inst_29118 = (state_29197[(2)]);
var state_29197__$1 = state_29197;
var statearr_29222_29281 = state_29197__$1;
(statearr_29222_29281[(2)] = inst_29118);

(statearr_29222_29281[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (22))){
var inst_29129 = (state_29197[(16)]);
var inst_29148 = (state_29197[(2)]);
var state_29197__$1 = (function (){var statearr_29223 = state_29197;
(statearr_29223[(19)] = inst_29148);

return statearr_29223;
})();
if(cljs.core.truth_(inst_29129)){
var statearr_29224_29282 = state_29197__$1;
(statearr_29224_29282[(1)] = (23));

} else {
var statearr_29225_29283 = state_29197__$1;
(statearr_29225_29283[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (29))){
var inst_29130 = (state_29197[(13)]);
var inst_29162 = [cljs.core.cst$kw$query];
var inst_29163 = [inst_29130];
var inst_29164 = cljs.core.PersistentHashMap.fromArrays(inst_29162,inst_29163);
var inst_29165 = cljs.core.clj__GT_js(inst_29164);
var inst_29166 = dataview.setFilterArgs(inst_29165);
var inst_29167 = dataview.refresh();
var state_29197__$1 = (function (){var statearr_29226 = state_29197;
(statearr_29226[(20)] = inst_29166);

return statearr_29226;
})();
var statearr_29227_29284 = state_29197__$1;
(statearr_29227_29284[(2)] = inst_29167);

(statearr_29227_29284[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (6))){
var inst_29193 = (state_29197[(2)]);
var state_29197__$1 = state_29197;
var statearr_29228_29285 = state_29197__$1;
(statearr_29228_29285[(2)] = inst_29193);

(statearr_29228_29285[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (28))){
var inst_29130 = (state_29197[(13)]);
var inst_29160 = (state_29197[(2)]);
var state_29197__$1 = (function (){var statearr_29229 = state_29197;
(statearr_29229[(21)] = inst_29160);

return statearr_29229;
})();
if(cljs.core.truth_(inst_29130)){
var statearr_29230_29286 = state_29197__$1;
(statearr_29230_29286[(1)] = (29));

} else {
var statearr_29231_29287 = state_29197__$1;
(statearr_29231_29287[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (25))){
var inst_29131 = (state_29197[(14)]);
var inst_29153 = (state_29197[(2)]);
var state_29197__$1 = (function (){var statearr_29232 = state_29197;
(statearr_29232[(22)] = inst_29153);

return statearr_29232;
})();
if(cljs.core.truth_(inst_29131)){
var statearr_29233_29288 = state_29197__$1;
(statearr_29233_29288[(1)] = (26));

} else {
var statearr_29234_29289 = state_29197__$1;
(statearr_29234_29289[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (34))){
var inst_29189 = (state_29197[(2)]);
var state_29197__$1 = (function (){var statearr_29235 = state_29197;
(statearr_29235[(23)] = inst_29189);

return statearr_29235;
})();
var statearr_29236_29290 = state_29197__$1;
(statearr_29236_29290[(2)] = null);

(statearr_29236_29290[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (17))){
var inst_29127 = (state_29197[(12)]);
var inst_29136 = (state_29197[(9)]);
var inst_29137 = (state_29197[(17)]);
var inst_29139 = (inst_29137.cljs$core$IFn$_invoke$arity$2 ? inst_29137.cljs$core$IFn$_invoke$arity$2(hatti.constants._rank,inst_29127) : inst_29137.call(null,hatti.constants._rank,inst_29127));
var inst_29140 = (inst_29136.cljs$core$IFn$_invoke$arity$1 ? inst_29136.cljs$core$IFn$_invoke$arity$1(inst_29139) : inst_29136.call(null,inst_29139));
var state_29197__$1 = state_29197;
var statearr_29237_29291 = state_29197__$1;
(statearr_29237_29291[(2)] = inst_29140);

(statearr_29237_29291[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (3))){
var inst_29195 = (state_29197[(2)]);
var state_29197__$1 = state_29197;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29197__$1,inst_29195);
} else {
if((state_val_29198 === (12))){
var state_29197__$1 = state_29197;
var statearr_29238_29292 = state_29197__$1;
(statearr_29238_29292[(2)] = false);

(statearr_29238_29292[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (2))){
var state_29197__$1 = state_29197;
var statearr_29239_29293 = state_29197__$1;
(statearr_29239_29293[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (23))){
var inst_29136 = (state_29197[(9)]);
var inst_29150 = (inst_29136.cljs$core$IFn$_invoke$arity$1 ? inst_29136.cljs$core$IFn$_invoke$arity$1(null) : inst_29136.call(null,null));
var state_29197__$1 = state_29197;
var statearr_29241_29294 = state_29197__$1;
(statearr_29241_29294[(2)] = inst_29150);

(statearr_29241_29294[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (19))){
var inst_29128 = (state_29197[(8)]);
var inst_29143 = (state_29197[(2)]);
var state_29197__$1 = (function (){var statearr_29242 = state_29197;
(statearr_29242[(24)] = inst_29143);

return statearr_29242;
})();
if(cljs.core.truth_(inst_29128)){
var statearr_29243_29295 = state_29197__$1;
(statearr_29243_29295[(1)] = (20));

} else {
var statearr_29244_29296 = state_29197__$1;
(statearr_29244_29296[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (11))){
var state_29197__$1 = state_29197;
var statearr_29245_29297 = state_29197__$1;
(statearr_29245_29297[(2)] = true);

(statearr_29245_29297[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (9))){
var state_29197__$1 = state_29197;
var statearr_29246_29298 = state_29197__$1;
(statearr_29246_29298[(2)] = false);

(statearr_29246_29298[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (5))){
var state_29197__$1 = state_29197;
var statearr_29247_29299 = state_29197__$1;
(statearr_29247_29299[(2)] = null);

(statearr_29247_29299[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (14))){
var inst_29106 = (state_29197[(7)]);
var inst_29123 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_29106);
var state_29197__$1 = state_29197;
var statearr_29248_29300 = state_29197__$1;
(statearr_29248_29300[(2)] = inst_29123);

(statearr_29248_29300[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (26))){
var inst_29131 = (state_29197[(14)]);
var inst_29155 = grid.setColumns(inst_29131);
var inst_29156 = hatti.views.table.resizeColumns(grid);
var inst_29157 = grid.render();
var state_29197__$1 = (function (){var statearr_29249 = state_29197;
(statearr_29249[(25)] = inst_29155);

(statearr_29249[(26)] = inst_29156);

return statearr_29249;
})();
var statearr_29250_29301 = state_29197__$1;
(statearr_29250_29301[(2)] = inst_29157);

(statearr_29250_29301[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (16))){
var inst_29127 = (state_29197[(12)]);
var inst_29130 = (state_29197[(13)]);
var inst_29128 = (state_29197[(8)]);
var inst_29131 = (state_29197[(14)]);
var inst_29132 = (state_29197[(10)]);
var inst_29126 = (state_29197[(15)]);
var inst_29129 = (state_29197[(16)]);
var inst_29136 = (state_29197[(9)]);
var inst_29106 = (state_29197[(7)]);
var inst_29126__$1 = (state_29197[(2)]);
var inst_29127__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29126__$1,cljs.core.cst$kw$submission_DASH_to_DASH_rank);
var inst_29128__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29126__$1,cljs.core.cst$kw$submission_DASH_clicked);
var inst_29129__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29126__$1,cljs.core.cst$kw$submission_DASH_unclicked);
var inst_29130__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29126__$1,cljs.core.cst$kw$filter_DASH_by);
var inst_29131__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29126__$1,cljs.core.cst$kw$new_DASH_columns);
var inst_29132__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29126__$1,cljs.core.cst$kw$re_DASH_render);
var inst_29133 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29134 = [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$data];
var inst_29135 = (new cljs.core.PersistentVector(null,3,(5),inst_29133,inst_29134,null));
var inst_29136__$1 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(om.core.update_BANG_,app_state,inst_29135);
var inst_29137 = (function (){var e = inst_29106;
var map__29104 = inst_29126__$1;
var submission_to_rank = inst_29127__$1;
var submission_clicked = inst_29128__$1;
var submission_unclicked = inst_29129__$1;
var filter_by = inst_29130__$1;
var new_columns = inst_29131__$1;
var re_render = inst_29132__$1;
var update_data_BANG_ = inst_29136__$1;
return ((function (e,map__29104,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_29127,inst_29130,inst_29128,inst_29131,inst_29132,inst_29126,inst_29129,inst_29136,inst_29106,inst_29126__$1,inst_29127__$1,inst_29128__$1,inst_29129__$1,inst_29130__$1,inst_29131__$1,inst_29132__$1,inst_29133,inst_29134,inst_29135,inst_29136__$1,state_val_29198,c__7694__auto__,event_chan){
return (function (field,value){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (e,map__29104,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_29127,inst_29130,inst_29128,inst_29131,inst_29132,inst_29126,inst_29129,inst_29136,inst_29106,inst_29126__$1,inst_29127__$1,inst_29128__$1,inst_29129__$1,inst_29130__$1,inst_29131__$1,inst_29132__$1,inst_29133,inst_29134,inst_29135,inst_29136__$1,state_val_29198,c__7694__auto__,event_chan){
return (function (p1__28936_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__28936_SHARP_,field));
});})(e,map__29104,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_29127,inst_29130,inst_29128,inst_29131,inst_29132,inst_29126,inst_29129,inst_29136,inst_29106,inst_29126__$1,inst_29127__$1,inst_29128__$1,inst_29129__$1,inst_29130__$1,inst_29131__$1,inst_29132__$1,inst_29133,inst_29134,inst_29135,inst_29136__$1,state_val_29198,c__7694__auto__,event_chan))
,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null))));
});
;})(e,map__29104,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_29127,inst_29130,inst_29128,inst_29131,inst_29132,inst_29126,inst_29129,inst_29136,inst_29106,inst_29126__$1,inst_29127__$1,inst_29128__$1,inst_29129__$1,inst_29130__$1,inst_29131__$1,inst_29132__$1,inst_29133,inst_29134,inst_29135,inst_29136__$1,state_val_29198,c__7694__auto__,event_chan))
})();
var state_29197__$1 = (function (){var statearr_29251 = state_29197;
(statearr_29251[(12)] = inst_29127__$1);

(statearr_29251[(13)] = inst_29130__$1);

(statearr_29251[(8)] = inst_29128__$1);

(statearr_29251[(14)] = inst_29131__$1);

(statearr_29251[(10)] = inst_29132__$1);

(statearr_29251[(15)] = inst_29126__$1);

(statearr_29251[(16)] = inst_29129__$1);

(statearr_29251[(9)] = inst_29136__$1);

(statearr_29251[(17)] = inst_29137);

return statearr_29251;
})();
if(cljs.core.truth_(inst_29127__$1)){
var statearr_29252_29302 = state_29197__$1;
(statearr_29252_29302[(1)] = (17));

} else {
var statearr_29253_29303 = state_29197__$1;
(statearr_29253_29303[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (30))){
var state_29197__$1 = state_29197;
var statearr_29254_29304 = state_29197__$1;
(statearr_29254_29304[(2)] = null);

(statearr_29254_29304[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (10))){
var inst_29121 = (state_29197[(2)]);
var state_29197__$1 = state_29197;
if(cljs.core.truth_(inst_29121)){
var statearr_29255_29305 = state_29197__$1;
(statearr_29255_29305[(1)] = (14));

} else {
var statearr_29256_29306 = state_29197__$1;
(statearr_29256_29306[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (18))){
var state_29197__$1 = state_29197;
var statearr_29257_29307 = state_29197__$1;
(statearr_29257_29307[(2)] = null);

(statearr_29257_29307[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29198 === (8))){
var inst_29106 = (state_29197[(7)]);
var inst_29111 = inst_29106.cljs$lang$protocol_mask$partition0$;
var inst_29112 = (inst_29111 & (64));
var inst_29113 = inst_29106.cljs$core$ISeq$;
var inst_29114 = (inst_29112) || (inst_29113);
var state_29197__$1 = state_29197;
if(cljs.core.truth_(inst_29114)){
var statearr_29258_29308 = state_29197__$1;
(statearr_29258_29308[(1)] = (11));

} else {
var statearr_29259_29309 = state_29197__$1;
(statearr_29259_29309[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto__,event_chan))
;
return ((function (switch__7673__auto__,c__7694__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__7674__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__7674__auto____0 = (function (){
var statearr_29263 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29263[(0)] = hatti$views$table$handle_table_events_$_state_machine__7674__auto__);

(statearr_29263[(1)] = (1));

return statearr_29263;
});
var hatti$views$table$handle_table_events_$_state_machine__7674__auto____1 = (function (state_29197){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__(state_29197);
if(cljs.core.keyword_identical_QMARK_(result__7676__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e29264){if((e29264 instanceof Object)){
var ex__7677__auto__ = e29264;
var statearr_29265_29310 = state_29197;
(statearr_29265_29310[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29197);

return cljs.core.cst$kw$recur;
} else {
throw e29264;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7675__auto__,cljs.core.cst$kw$recur)){
var G__29311 = state_29197;
state_29197 = G__29311;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__7674__auto__ = function(state_29197){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__7674__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__7674__auto____1.call(this,state_29197);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__7674__auto____0;
hatti$views$table$handle_table_events_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__7674__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto__,event_chan))
})();
var state__7696__auto__ = (function (){var statearr_29266 = (f__7695__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7695__auto__.cljs$core$IFn$_invoke$arity$0() : f__7695__auto__.call(null));
(statearr_29266[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto__);

return statearr_29266;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7696__auto__);
});})(c__7694__auto__,event_chan))
);

return c__7694__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$name_DASH_or_DASH_label,k);

return (colset_BANG_.cljs$core$IFn$_invoke$arity$1 ? colset_BANG_.cljs$core$IFn$_invoke$arity$1(k) : colset_BANG_.call(null,k));
});
var iter__5341__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__29322(s__29323){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__29323__$1 = s__29323;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__29323__$1);
if(temp__4425__auto__){
var s__29323__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__29323__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__29323__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__29325 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__29324 = (0);
while(true){
if((i__29324 < size__5340__auto__)){
var vec__29330 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__29324);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29330,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29330,(1),null);
cljs.core.chunk_append(b__29325,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (i__29324,vec__29330,k,v,c__5339__auto__,size__5340__auto__,b__29325,s__29323__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(i__29324,vec__29330,k,v,c__5339__auto__,size__5340__auto__,b__29325,s__29323__$2,temp__4425__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null));

var G__29332 = (i__29324 + (1));
i__29324 = G__29332;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__29325),hatti$views$table$render_options_$_iter__29322(cljs.core.chunk_rest(s__29323__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__29325),null);
}
} else {
var vec__29331 = cljs.core.first(s__29323__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29331,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29331,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (vec__29331,k,v,s__29323__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(vec__29331,k,v,s__29323__$2,temp__4425__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__29322(cljs.core.rest(s__29323__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__5341__auto__(options);
});
hatti.views.label_changer.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table29334 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table29334 = (function (_,owner,meta29335){
this._ = _;
this.owner = owner;
this.meta29335 = meta29335;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table29334.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29336,meta29335__$1){
var self__ = this;
var _29336__$1 = this;
return (new hatti.views.table.t_hatti$views$table29334(self__._,self__.owner,meta29335__$1));
});

hatti.views.table.t_hatti$views$table29334.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29336){
var self__ = this;
var _29336__$1 = this;
return self__.meta29335;
});

hatti.views.table.t_hatti$views$table29334.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table29334.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name_DASH_or_DASH_label,cljs.core.cst$kw$label], null);
});

hatti.views.table.t_hatti$views$table29334.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table29334.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__29337){
var self__ = this;
var map__29338 = p__29337;
var map__29338__$1 = ((((!((map__29338 == null)))?((((map__29338.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29338.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29338):map__29338);
var name_or_label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29338__$1,cljs.core.cst$kw$name_DASH_or_DASH_label);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29338__$1,cljs.core.cst$kw$language);
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Label"], null),cljs.core.cst$kw$name,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Name"], null)], null);
var map__29340 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__29340__$1 = ((((!((map__29340 == null)))?((((map__29340.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29340.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29340):map__29340);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29340__$1,cljs.core.cst$kw$flat_DASH_form);
var new_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var colset_BANG_ = ((function (options,map__29340,map__29340__$1,flat_form,new_language,___$2,map__29338,map__29338__$1,name_or_label,language){
return (function (p1__29333_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$new_DASH_columns,hatti.views.table.flat_form__GT_sg_columns(flat_form,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$label,p1__29333_SHARP_),new_language)], null));
});})(options,map__29340,map__29340__$1,flat_form,new_language,___$2,map__29338,map__29338__$1,name_or_label,language))
;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new_language,language)){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$language,new_language);

colset_BANG_(name_or_label);
} else {
}

var G__29349 = {"className": "label-changer"};
var G__29350 = (function (){var G__29352 = {"className": "label-changer-label"};
var G__29353 = "Show:";
return React.DOM.span(G__29352,G__29353);
})();
var G__29351 = (function (){var G__29354 = {"id": "header-display-dropdown", "className": "drop-hover"};
var G__29355 = (function (){var attrs29344 = (options.cljs$core$IFn$_invoke$arity$1 ? options.cljs$core$IFn$_invoke$arity$1(name_or_label) : options.call(null,name_or_label));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs29344))?sablono.interpreter.attributes(attrs29344):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs29344))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__29357 = {"className": "fa fa-angle-down"};
return React.DOM.i(G__29357);
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs29344),(function (){var G__29358 = {"className": "fa fa-angle-down"};
return React.DOM.i(G__29358);
})()], null))));
})();
var G__29356 = (function (){var G__29359 = {"className": "submenu no-dot"};
var G__29360 = sablono.interpreter.interpret(hatti.views.table.render_options(options,self__.owner,colset_BANG_));
return React.DOM.ul(G__29359,G__29360);
})();
return React.DOM.div(G__29354,G__29355,G__29356);
})();
return React.DOM.div(G__29349,G__29350,G__29351);
});

hatti.views.table.t_hatti$views$table29334.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta29335], null);
});

hatti.views.table.t_hatti$views$table29334.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table29334.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table29334";

hatti.views.table.t_hatti$views$table29334.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table29334");
});

hatti.views.table.__GT_t_hatti$views$table29334 = (function hatti$views$table$__GT_t_hatti$views$table29334(___$1,owner__$1,meta29335){
return (new hatti.views.table.t_hatti$views$table29334(___$1,owner__$1,meta29335));
});

}

return (new hatti.views.table.t_hatti$views$table29334(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__7694__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7694__auto__,query){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto__,query){
return (function (state_29403){
var state_val_29404 = (state_29403[(1)]);
if((state_val_29404 === (1))){
var inst_29389 = cljs.core.async.timeout((150));
var state_29403__$1 = state_29403;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29403__$1,(2),inst_29389);
} else {
if((state_val_29404 === (2))){
var inst_29391 = (state_29403[(2)]);
var inst_29392 = input.value;
var inst_29393 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query,inst_29392);
var state_29403__$1 = (function (){var statearr_29405 = state_29403;
(statearr_29405[(7)] = inst_29391);

return statearr_29405;
})();
if(inst_29393){
var statearr_29406_29417 = state_29403__$1;
(statearr_29406_29417[(1)] = (3));

} else {
var statearr_29407_29418 = state_29403__$1;
(statearr_29407_29418[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29404 === (3))){
var inst_29395 = [query_event_key];
var inst_29396 = [query];
var inst_29397 = cljs.core.PersistentHashMap.fromArrays(inst_29395,inst_29396);
var inst_29398 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,inst_29397);
var state_29403__$1 = state_29403;
var statearr_29408_29419 = state_29403__$1;
(statearr_29408_29419[(2)] = inst_29398);

(statearr_29408_29419[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29404 === (4))){
var state_29403__$1 = state_29403;
var statearr_29409_29420 = state_29403__$1;
(statearr_29409_29420[(2)] = null);

(statearr_29409_29420[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29404 === (5))){
var inst_29401 = (state_29403[(2)]);
var state_29403__$1 = state_29403;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29403__$1,inst_29401);
} else {
return null;
}
}
}
}
}
});})(c__7694__auto__,query))
;
return ((function (switch__7673__auto__,c__7694__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__7674__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__7674__auto____0 = (function (){
var statearr_29413 = [null,null,null,null,null,null,null,null];
(statearr_29413[(0)] = hatti$views$table$delayed_search_$_state_machine__7674__auto__);

(statearr_29413[(1)] = (1));

return statearr_29413;
});
var hatti$views$table$delayed_search_$_state_machine__7674__auto____1 = (function (state_29403){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__(state_29403);
if(cljs.core.keyword_identical_QMARK_(result__7676__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e29414){if((e29414 instanceof Object)){
var ex__7677__auto__ = e29414;
var statearr_29415_29421 = state_29403;
(statearr_29415_29421[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29403);

return cljs.core.cst$kw$recur;
} else {
throw e29414;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7675__auto__,cljs.core.cst$kw$recur)){
var G__29422 = state_29403;
state_29403 = G__29422;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__7674__auto__ = function(state_29403){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__7674__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__7674__auto____1.call(this,state_29403);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__7674__auto____0;
hatti$views$table$delayed_search_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__7674__auto____1;
return hatti$views$table$delayed_search_$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto__,query))
})();
var state__7696__auto__ = (function (){var statearr_29416 = (f__7695__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7695__auto__.cljs$core$IFn$_invoke$arity$0() : f__7695__auto__.call(null));
(statearr_29416[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto__);

return statearr_29416;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7696__auto__);
});})(c__7694__auto__,query))
);

return c__7694__auto__;
});
hatti.views.table_search.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table29424 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table29424 = (function (_,owner,meta29425){
this._ = _;
this.owner = owner;
this.meta29425 = meta29425;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table29424.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29426,meta29425__$1){
var self__ = this;
var _29426__$1 = this;
return (new hatti.views.table.t_hatti$views$table29424(self__._,self__.owner,meta29425__$1));
});

hatti.views.table.t_hatti$views$table29424.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29426){
var self__ = this;
var _29426__$1 = this;
return self__.meta29425;
});

hatti.views.table.t_hatti$views$table29424.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table29424.prototype.om$core$IRender$render$arity$1 = (function (this__6323__auto__){
var self__ = this;
var this__6323__auto____$1 = this;
var G__29429 = {"className": "table-search"};
var G__29430 = (function (){var G__29432 = {"className": "fa fa-search"};
return React.DOM.i(G__29432);
})();
var G__29431 = (function (){var G__29433 = {"type": "text", "placeholder": "Search", "onChange": ((function (G__29429,G__29430,this__6323__auto____$1){
return (function (p1__29423_SHARP_){
return hatti.views.table.delayed_search(p1__29423_SHARP_.target,cljs.core.cst$kw$filter_DASH_by);
});})(G__29429,G__29430,this__6323__auto____$1))
};
return (sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1 ? sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1(G__29433) : sablono.interpreter.input.call(null,G__29433));
})();
return React.DOM.div(G__29429,G__29430,G__29431);
});

hatti.views.table.t_hatti$views$table29424.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta29425], null);
});

hatti.views.table.t_hatti$views$table29424.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table29424.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table29424";

hatti.views.table.t_hatti$views$table29424.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table29424");
});

hatti.views.table.__GT_t_hatti$views$table29424 = (function hatti$views$table$__GT_t_hatti$views$table29424(___$1,owner__$1,meta29425){
return (new hatti.views.table.t_hatti$views$table29424(___$1,owner__$1,meta29425));
});

}

return (new hatti.views.table.t_hatti$views$table29424(_,owner,null));
}));
hatti.views.table_header.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner){
if(typeof hatti.views.table.t_hatti$views$table29434 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table29434 = (function (app_state,owner,meta29435){
this.app_state = app_state;
this.owner = owner;
this.meta29435 = meta29435;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table29434.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29436,meta29435__$1){
var self__ = this;
var _29436__$1 = this;
return (new hatti.views.table.t_hatti$views$table29434(self__.app_state,self__.owner,meta29435__$1));
});

hatti.views.table.t_hatti$views$table29434.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29436){
var self__ = this;
var _29436__$1 = this;
return self__.meta29435;
});

hatti.views.table.t_hatti$views$table29434.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table29434.prototype.om$core$IRender$render$arity$1 = (function (this__6323__auto__){
var self__ = this;
var this__6323__auto____$1 = this;
var G__29439 = {"className": "topbar"};
var G__29440 = (function (){var G__29444 = {"id": hatti.views.table.pager_id};
return React.DOM.div(G__29444);
})();
var G__29441 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.label_changer,null));
var G__29442 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_search,self__.app_state));
var G__29443 = (function (){var G__29445 = {"style": {"clear": "both"}};
return React.DOM.div(G__29445);
})();
return React.DOM.div(G__29439,G__29440,G__29441,G__29442,G__29443);
});

hatti.views.table.t_hatti$views$table29434.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta29435], null);
});

hatti.views.table.t_hatti$views$table29434.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table29434.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table29434";

hatti.views.table.t_hatti$views$table29434.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table29434");
});

hatti.views.table.__GT_t_hatti$views$table29434 = (function hatti$views$table$__GT_t_hatti$views$table29434(app_state__$1,owner__$1,meta29435){
return (new hatti.views.table.t_hatti$views$table29434(app_state__$1,owner__$1,meta29435));
});

}

return (new hatti.views.table.t_hatti$views$table29434(app_state,owner,null));
}));
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){

if(cljs.core.seq(data)){
var map__29449 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(owner);
var map__29449__$1 = ((((!((map__29449 == null)))?((((map__29449.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29449.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29449):map__29449);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29449__$1,cljs.core.cst$kw$flat_DASH_form);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29449__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var current_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(owner,hatti.shared.language_cursor()));
var vec__29450 = hatti.views.table.sg_init(data,flat_form,current_language,is_filtered_dataview_QMARK_,slick_grid_event_handlers);
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29450,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29450,(1),null);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$grid,grid);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$dataview,dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table_page.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner,p__29453){
var map__29454 = p__29453;
var map__29454__$1 = ((((!((map__29454 == null)))?((((map__29454.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29454.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29454):map__29454);
var opts = map__29454__$1;
var slick_grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29454__$1,cljs.core.cst$kw$slick_DASH_grid_DASH_event_DASH_handlers);

if(typeof hatti.views.table.t_hatti$views$table29456 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table29456 = (function (app_state,owner,p__29453,map__29454,opts,slick_grid_event_handlers,meta29457){
this.app_state = app_state;
this.owner = owner;
this.p__29453 = p__29453;
this.map__29454 = map__29454;
this.opts = opts;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.meta29457 = meta29457;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table29456.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__29454,map__29454__$1,opts,slick_grid_event_handlers){
return (function (_29458,meta29457__$1){
var self__ = this;
var _29458__$1 = this;
return (new hatti.views.table.t_hatti$views$table29456(self__.app_state,self__.owner,self__.p__29453,self__.map__29454,self__.opts,self__.slick_grid_event_handlers,meta29457__$1));
});})(map__29454,map__29454__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table29456.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__29454,map__29454__$1,opts,slick_grid_event_handlers){
return (function (_29458){
var self__ = this;
var _29458__$1 = this;
return self__.meta29457;
});})(map__29454,map__29454__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table29456.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table29456.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__29454,map__29454__$1,opts,slick_grid_event_handlers){
return (function (_,___$1){
var self__ = this;
var ___$2 = this;
var no_data_QMARK_ = cljs.core.empty_QMARK_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null)));
var map__29459 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state);
var map__29459__$1 = ((((!((map__29459 == null)))?((((map__29459.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29459.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29459):map__29459);
var dataset_info = map__29459__$1;
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29459__$1,cljs.core.cst$kw$num_of_submissions);
var with_info = ((function (no_data_QMARK_,map__29459,map__29459__$1,dataset_info,num_of_submissions,___$2,map__29454,map__29454__$1,opts,slick_grid_event_handlers){
return (function (p1__29452_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__29452_SHARP_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$dataset_DASH_info,dataset_info], null)], 0));
});})(no_data_QMARK_,map__29459,map__29459__$1,dataset_info,num_of_submissions,___$2,map__29454,map__29454__$1,opts,slick_grid_event_handlers))
;
var attrs29461 = om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.submission_view,with_info(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked], null))),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.select_keys(self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$role,null,cljs.core.cst$kw$delete_DASH_record_BANG_,null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,cljs.core.cst$kw$table], null)], 0))], null));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs29461))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["table-view"], null)], null),attrs29461], 0))):{"className": "table-view"}),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs29461))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.app_state)),(function (){var G__29462 = {"id": hatti.views.table.table_id, "className": "slickgrid"};
var G__29463 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__29468 = {"className": "empty-state"};
var G__29469 = "No data";
return React.DOM.span(G__29468,G__29469);
})():(function (){var G__29471 = null;
var G__29472 = (function (){var G__29474 = {"className": "fa fa-spinner fa-pulse"};
return React.DOM.i(G__29474);
})();
var G__29473 = "Loading...";
return React.DOM.span(G__29471,G__29472,G__29473);
})());
return React.DOM.div(G__29462,G__29463);
})()], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs29461),sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.app_state)),(function (){var G__29475 = {"id": hatti.views.table.table_id, "className": "slickgrid"};
var G__29476 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__29481 = {"className": "empty-state"};
var G__29482 = "No data";
return React.DOM.span(G__29481,G__29482);
})():(function (){var G__29484 = null;
var G__29485 = (function (){var G__29487 = {"className": "fa fa-spinner fa-pulse"};
return React.DOM.i(G__29487);
})();
var G__29486 = "Loading...";
return React.DOM.span(G__29484,G__29485,G__29486);
})());
return React.DOM.div(G__29475,G__29476);
})()], null))));
});})(map__29454,map__29454__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table29456.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table29456.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (map__29454,map__29454__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_(data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__29488 = temp__4425__auto__;
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29488,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29488,(1),null);
return hatti.views.table.handle_table_events(self__.app_state,grid,dataview);
} else {
return null;
}
});})(map__29454,map__29454__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table29456.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table29456.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (map__29454,map__29454__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

var old_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(om.core.get_props.cljs$core$IFn$_invoke$arity$1(self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var new_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var map__29489 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__29489__$1 = ((((!((map__29489 == null)))?((((map__29489.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29489.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29489):map__29489);
var grid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29489__$1,cljs.core.cst$kw$grid);
var dataview = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29489__$1,cljs.core.cst$kw$dataview);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_data,new_data)){
if(cljs.core.empty_QMARK_(old_data)){
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_(new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__29491 = temp__4425__auto__;
var grid__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29491,(0),null);
var dataview__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29491,(1),null);
return hatti.views.table.handle_table_events(self__.app_state,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js(new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
});})(map__29454,map__29454__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table29456.getBasis = ((function (map__29454,map__29454__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__29453,cljs.core.cst$sym$map__29454,cljs.core.cst$sym$opts,cljs.core.cst$sym$slick_DASH_grid_DASH_event_DASH_handlers,cljs.core.cst$sym$meta29457], null);
});})(map__29454,map__29454__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table29456.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table29456.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table29456";

hatti.views.table.t_hatti$views$table29456.cljs$lang$ctorPrWriter = ((function (map__29454,map__29454__$1,opts,slick_grid_event_handlers){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table29456");
});})(map__29454,map__29454__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table29456 = ((function (map__29454,map__29454__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table29456(app_state__$1,owner__$1,p__29453__$1,map__29454__$2,opts__$1,slick_grid_event_handlers__$1,meta29457){
return (new hatti.views.table.t_hatti$views$table29456(app_state__$1,owner__$1,p__29453__$1,map__29454__$2,opts__$1,slick_grid_event_handlers__$1,meta29457));
});})(map__29454,map__29454__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table29456(app_state,owner,p__29453,map__29454__$1,opts,slick_grid_event_handlers,cljs.core.PersistentArrayMap.EMPTY));
}));
