// Compiled by ClojureScript 1.7.145 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__23378__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__23377 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var tag = cljs.core.nth.call(null,vec__23377,(0),null);
var body = cljs.core.nthnext.call(null,vec__23377,(1));
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__23378 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__23379__i = 0, G__23379__a = new Array(arguments.length -  0);
while (G__23379__i < G__23379__a.length) {G__23379__a[G__23379__i] = arguments[G__23379__i + 0]; ++G__23379__i;}
  args = new cljs.core.IndexedSeq(G__23379__a,0);
} 
return G__23378__delegate.call(this,args);};
G__23378.cljs$lang$maxFixedArity = 0;
G__23378.cljs$lang$applyTo = (function (arglist__23380){
var args = cljs.core.seq(arglist__23380);
return G__23378__delegate(args);
});
G__23378.cljs$core$IFn$_invoke$arity$variadic = G__23378__delegate;
return G__23378;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__5341__auto__ = (function sablono$core$update_arglists_$_iter__23385(s__23386){
return (new cljs.core.LazySeq(null,(function (){
var s__23386__$1 = s__23386;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__23386__$1);
if(temp__4425__auto__){
var s__23386__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23386__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__23386__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__23388 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__23387 = (0);
while(true){
if((i__23387 < size__5340__auto__)){
var args = cljs.core._nth.call(null,c__5339__auto__,i__23387);
cljs.core.chunk_append.call(null,b__23388,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__23389 = (i__23387 + (1));
i__23387 = G__23389;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23388),sablono$core$update_arglists_$_iter__23385.call(null,cljs.core.chunk_rest.call(null,s__23386__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23388),null);
}
} else {
var args = cljs.core.first.call(null,s__23386__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__23385.call(null,cljs.core.rest.call(null,s__23386__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__5634__auto__ = [];
var len__5627__auto___23395 = arguments.length;
var i__5628__auto___23396 = (0);
while(true){
if((i__5628__auto___23396 < len__5627__auto___23395)){
args__5634__auto__.push((arguments[i__5628__auto___23396]));

var G__23397 = (i__5628__auto___23396 + (1));
i__5628__auto___23396 = G__23397;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__5341__auto__ = (function sablono$core$iter__23391(s__23392){
return (new cljs.core.LazySeq(null,(function (){
var s__23392__$1 = s__23392;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__23392__$1);
if(temp__4425__auto__){
var s__23392__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23392__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__23392__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__23394 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__23393 = (0);
while(true){
if((i__23393 < size__5340__auto__)){
var style = cljs.core._nth.call(null,c__5339__auto__,i__23393);
cljs.core.chunk_append.call(null,b__23394,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__23398 = (i__23393 + (1));
i__23393 = G__23398;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23394),sablono$core$iter__23391.call(null,cljs.core.chunk_rest.call(null,s__23392__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23394),null);
}
} else {
var style = cljs.core.first.call(null,s__23392__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__23391.call(null,cljs.core.rest.call(null,s__23392__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq23390){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq23390));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",{"src": src}));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to23399 = (function sablono$core$link_to23399(var_args){
var args__5634__auto__ = [];
var len__5627__auto___23402 = arguments.length;
var i__5628__auto___23403 = (0);
while(true){
if((i__5628__auto___23403 < len__5627__auto___23402)){
args__5634__auto__.push((arguments[i__5628__auto___23403]));

var G__23404 = (i__5628__auto___23403 + (1));
i__5628__auto___23403 = G__23404;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return sablono.core.link_to23399.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

sablono.core.link_to23399.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to23399.cljs$lang$maxFixedArity = (1);

sablono.core.link_to23399.cljs$lang$applyTo = (function (seq23400){
var G__23401 = cljs.core.first.call(null,seq23400);
var seq23400__$1 = cljs.core.next.call(null,seq23400);
return sablono.core.link_to23399.cljs$core$IFn$_invoke$arity$variadic(G__23401,seq23400__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to23399);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to23405 = (function sablono$core$mail_to23405(var_args){
var args__5634__auto__ = [];
var len__5627__auto___23410 = arguments.length;
var i__5628__auto___23411 = (0);
while(true){
if((i__5628__auto___23411 < len__5627__auto___23410)){
args__5634__auto__.push((arguments[i__5628__auto___23411]));

var G__23412 = (i__5628__auto___23411 + (1));
i__5628__auto___23411 = G__23412;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return sablono.core.mail_to23405.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

sablono.core.mail_to23405.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__23408){
var vec__23409 = p__23408;
var content = cljs.core.nth.call(null,vec__23409,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__4569__auto__ = content;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to23405.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to23405.cljs$lang$applyTo = (function (seq23406){
var G__23407 = cljs.core.first.call(null,seq23406);
var seq23406__$1 = cljs.core.next.call(null,seq23406);
return sablono.core.mail_to23405.cljs$core$IFn$_invoke$arity$variadic(G__23407,seq23406__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to23405);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list23413 = (function sablono$core$unordered_list23413(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__5341__auto__ = (function sablono$core$unordered_list23413_$_iter__23418(s__23419){
return (new cljs.core.LazySeq(null,(function (){
var s__23419__$1 = s__23419;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__23419__$1);
if(temp__4425__auto__){
var s__23419__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23419__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__23419__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__23421 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__23420 = (0);
while(true){
if((i__23420 < size__5340__auto__)){
var x = cljs.core._nth.call(null,c__5339__auto__,i__23420);
cljs.core.chunk_append.call(null,b__23421,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__23422 = (i__23420 + (1));
i__23420 = G__23422;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23421),sablono$core$unordered_list23413_$_iter__23418.call(null,cljs.core.chunk_rest.call(null,s__23419__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23421),null);
}
} else {
var x = cljs.core.first.call(null,s__23419__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list23413_$_iter__23418.call(null,cljs.core.rest.call(null,s__23419__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list23413);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list23423 = (function sablono$core$ordered_list23423(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__5341__auto__ = (function sablono$core$ordered_list23423_$_iter__23428(s__23429){
return (new cljs.core.LazySeq(null,(function (){
var s__23429__$1 = s__23429;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__23429__$1);
if(temp__4425__auto__){
var s__23429__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23429__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__23429__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__23431 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__23430 = (0);
while(true){
if((i__23430 < size__5340__auto__)){
var x = cljs.core._nth.call(null,c__5339__auto__,i__23430);
cljs.core.chunk_append.call(null,b__23431,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__23432 = (i__23430 + (1));
i__23430 = G__23432;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23431),sablono$core$ordered_list23423_$_iter__23428.call(null,cljs.core.chunk_rest.call(null,s__23429__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23431),null);
}
} else {
var x = cljs.core.first.call(null,s__23429__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list23423_$_iter__23428.call(null,cljs.core.rest.call(null,s__23429__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list23423);
/**
 * Create an image element.
 */
sablono.core.image23433 = (function sablono$core$image23433(var_args){
var args23434 = [];
var len__5627__auto___23437 = arguments.length;
var i__5628__auto___23438 = (0);
while(true){
if((i__5628__auto___23438 < len__5627__auto___23437)){
args23434.push((arguments[i__5628__auto___23438]));

var G__23439 = (i__5628__auto___23438 + (1));
i__5628__auto___23438 = G__23439;
continue;
} else {
}
break;
}

var G__23436 = args23434.length;
switch (G__23436) {
case 1:
return sablono.core.image23433.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image23433.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23434.length)].join('')));

}
});

sablono.core.image23433.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image23433.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image23433.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image23433);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__23441_SHARP_,p2__23442_SHARP_){
return [cljs.core.str(p1__23441_SHARP_),cljs.core.str("["),cljs.core.str(p2__23442_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__23443_SHARP_,p2__23444_SHARP_){
return [cljs.core.str(p1__23443_SHARP_),cljs.core.str("-"),cljs.core.str(p2__23444_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field23445 = (function sablono$core$color_field23445(var_args){
var args23446 = [];
var len__5627__auto___23513 = arguments.length;
var i__5628__auto___23514 = (0);
while(true){
if((i__5628__auto___23514 < len__5627__auto___23513)){
args23446.push((arguments[i__5628__auto___23514]));

var G__23515 = (i__5628__auto___23514 + (1));
i__5628__auto___23514 = G__23515;
continue;
} else {
}
break;
}

var G__23448 = args23446.length;
switch (G__23448) {
case 1:
return sablono.core.color_field23445.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field23445.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23446.length)].join('')));

}
});

sablono.core.color_field23445.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.color_field23445.call(null,name__7494__auto__,null);
});

sablono.core.color_field23445.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.color_field23445.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field23445);

/**
 * Creates a date input field.
 */
sablono.core.date_field23449 = (function sablono$core$date_field23449(var_args){
var args23450 = [];
var len__5627__auto___23517 = arguments.length;
var i__5628__auto___23518 = (0);
while(true){
if((i__5628__auto___23518 < len__5627__auto___23517)){
args23450.push((arguments[i__5628__auto___23518]));

var G__23519 = (i__5628__auto___23518 + (1));
i__5628__auto___23518 = G__23519;
continue;
} else {
}
break;
}

var G__23452 = args23450.length;
switch (G__23452) {
case 1:
return sablono.core.date_field23449.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field23449.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23450.length)].join('')));

}
});

sablono.core.date_field23449.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.date_field23449.call(null,name__7494__auto__,null);
});

sablono.core.date_field23449.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.date_field23449.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field23449);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field23453 = (function sablono$core$datetime_field23453(var_args){
var args23454 = [];
var len__5627__auto___23521 = arguments.length;
var i__5628__auto___23522 = (0);
while(true){
if((i__5628__auto___23522 < len__5627__auto___23521)){
args23454.push((arguments[i__5628__auto___23522]));

var G__23523 = (i__5628__auto___23522 + (1));
i__5628__auto___23522 = G__23523;
continue;
} else {
}
break;
}

var G__23456 = args23454.length;
switch (G__23456) {
case 1:
return sablono.core.datetime_field23453.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field23453.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23454.length)].join('')));

}
});

sablono.core.datetime_field23453.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.datetime_field23453.call(null,name__7494__auto__,null);
});

sablono.core.datetime_field23453.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.datetime_field23453.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field23453);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field23457 = (function sablono$core$datetime_local_field23457(var_args){
var args23458 = [];
var len__5627__auto___23525 = arguments.length;
var i__5628__auto___23526 = (0);
while(true){
if((i__5628__auto___23526 < len__5627__auto___23525)){
args23458.push((arguments[i__5628__auto___23526]));

var G__23527 = (i__5628__auto___23526 + (1));
i__5628__auto___23526 = G__23527;
continue;
} else {
}
break;
}

var G__23460 = args23458.length;
switch (G__23460) {
case 1:
return sablono.core.datetime_local_field23457.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field23457.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23458.length)].join('')));

}
});

sablono.core.datetime_local_field23457.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.datetime_local_field23457.call(null,name__7494__auto__,null);
});

sablono.core.datetime_local_field23457.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.datetime_local_field23457.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field23457);

/**
 * Creates a email input field.
 */
sablono.core.email_field23461 = (function sablono$core$email_field23461(var_args){
var args23462 = [];
var len__5627__auto___23529 = arguments.length;
var i__5628__auto___23530 = (0);
while(true){
if((i__5628__auto___23530 < len__5627__auto___23529)){
args23462.push((arguments[i__5628__auto___23530]));

var G__23531 = (i__5628__auto___23530 + (1));
i__5628__auto___23530 = G__23531;
continue;
} else {
}
break;
}

var G__23464 = args23462.length;
switch (G__23464) {
case 1:
return sablono.core.email_field23461.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field23461.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23462.length)].join('')));

}
});

sablono.core.email_field23461.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.email_field23461.call(null,name__7494__auto__,null);
});

sablono.core.email_field23461.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.email_field23461.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field23461);

/**
 * Creates a file input field.
 */
sablono.core.file_field23465 = (function sablono$core$file_field23465(var_args){
var args23466 = [];
var len__5627__auto___23533 = arguments.length;
var i__5628__auto___23534 = (0);
while(true){
if((i__5628__auto___23534 < len__5627__auto___23533)){
args23466.push((arguments[i__5628__auto___23534]));

var G__23535 = (i__5628__auto___23534 + (1));
i__5628__auto___23534 = G__23535;
continue;
} else {
}
break;
}

var G__23468 = args23466.length;
switch (G__23468) {
case 1:
return sablono.core.file_field23465.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field23465.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23466.length)].join('')));

}
});

sablono.core.file_field23465.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.file_field23465.call(null,name__7494__auto__,null);
});

sablono.core.file_field23465.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.file_field23465.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field23465);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field23469 = (function sablono$core$hidden_field23469(var_args){
var args23470 = [];
var len__5627__auto___23537 = arguments.length;
var i__5628__auto___23538 = (0);
while(true){
if((i__5628__auto___23538 < len__5627__auto___23537)){
args23470.push((arguments[i__5628__auto___23538]));

var G__23539 = (i__5628__auto___23538 + (1));
i__5628__auto___23538 = G__23539;
continue;
} else {
}
break;
}

var G__23472 = args23470.length;
switch (G__23472) {
case 1:
return sablono.core.hidden_field23469.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field23469.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23470.length)].join('')));

}
});

sablono.core.hidden_field23469.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.hidden_field23469.call(null,name__7494__auto__,null);
});

sablono.core.hidden_field23469.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.hidden_field23469.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field23469);

/**
 * Creates a month input field.
 */
sablono.core.month_field23473 = (function sablono$core$month_field23473(var_args){
var args23474 = [];
var len__5627__auto___23541 = arguments.length;
var i__5628__auto___23542 = (0);
while(true){
if((i__5628__auto___23542 < len__5627__auto___23541)){
args23474.push((arguments[i__5628__auto___23542]));

var G__23543 = (i__5628__auto___23542 + (1));
i__5628__auto___23542 = G__23543;
continue;
} else {
}
break;
}

var G__23476 = args23474.length;
switch (G__23476) {
case 1:
return sablono.core.month_field23473.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field23473.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23474.length)].join('')));

}
});

sablono.core.month_field23473.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.month_field23473.call(null,name__7494__auto__,null);
});

sablono.core.month_field23473.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.month_field23473.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field23473);

/**
 * Creates a number input field.
 */
sablono.core.number_field23477 = (function sablono$core$number_field23477(var_args){
var args23478 = [];
var len__5627__auto___23545 = arguments.length;
var i__5628__auto___23546 = (0);
while(true){
if((i__5628__auto___23546 < len__5627__auto___23545)){
args23478.push((arguments[i__5628__auto___23546]));

var G__23547 = (i__5628__auto___23546 + (1));
i__5628__auto___23546 = G__23547;
continue;
} else {
}
break;
}

var G__23480 = args23478.length;
switch (G__23480) {
case 1:
return sablono.core.number_field23477.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field23477.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23478.length)].join('')));

}
});

sablono.core.number_field23477.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.number_field23477.call(null,name__7494__auto__,null);
});

sablono.core.number_field23477.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.number_field23477.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field23477);

/**
 * Creates a password input field.
 */
sablono.core.password_field23481 = (function sablono$core$password_field23481(var_args){
var args23482 = [];
var len__5627__auto___23549 = arguments.length;
var i__5628__auto___23550 = (0);
while(true){
if((i__5628__auto___23550 < len__5627__auto___23549)){
args23482.push((arguments[i__5628__auto___23550]));

var G__23551 = (i__5628__auto___23550 + (1));
i__5628__auto___23550 = G__23551;
continue;
} else {
}
break;
}

var G__23484 = args23482.length;
switch (G__23484) {
case 1:
return sablono.core.password_field23481.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field23481.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23482.length)].join('')));

}
});

sablono.core.password_field23481.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.password_field23481.call(null,name__7494__auto__,null);
});

sablono.core.password_field23481.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.password_field23481.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field23481);

/**
 * Creates a range input field.
 */
sablono.core.range_field23485 = (function sablono$core$range_field23485(var_args){
var args23486 = [];
var len__5627__auto___23553 = arguments.length;
var i__5628__auto___23554 = (0);
while(true){
if((i__5628__auto___23554 < len__5627__auto___23553)){
args23486.push((arguments[i__5628__auto___23554]));

var G__23555 = (i__5628__auto___23554 + (1));
i__5628__auto___23554 = G__23555;
continue;
} else {
}
break;
}

var G__23488 = args23486.length;
switch (G__23488) {
case 1:
return sablono.core.range_field23485.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field23485.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23486.length)].join('')));

}
});

sablono.core.range_field23485.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.range_field23485.call(null,name__7494__auto__,null);
});

sablono.core.range_field23485.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.range_field23485.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field23485);

/**
 * Creates a search input field.
 */
sablono.core.search_field23489 = (function sablono$core$search_field23489(var_args){
var args23490 = [];
var len__5627__auto___23557 = arguments.length;
var i__5628__auto___23558 = (0);
while(true){
if((i__5628__auto___23558 < len__5627__auto___23557)){
args23490.push((arguments[i__5628__auto___23558]));

var G__23559 = (i__5628__auto___23558 + (1));
i__5628__auto___23558 = G__23559;
continue;
} else {
}
break;
}

var G__23492 = args23490.length;
switch (G__23492) {
case 1:
return sablono.core.search_field23489.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field23489.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23490.length)].join('')));

}
});

sablono.core.search_field23489.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.search_field23489.call(null,name__7494__auto__,null);
});

sablono.core.search_field23489.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.search_field23489.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field23489);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field23493 = (function sablono$core$tel_field23493(var_args){
var args23494 = [];
var len__5627__auto___23561 = arguments.length;
var i__5628__auto___23562 = (0);
while(true){
if((i__5628__auto___23562 < len__5627__auto___23561)){
args23494.push((arguments[i__5628__auto___23562]));

var G__23563 = (i__5628__auto___23562 + (1));
i__5628__auto___23562 = G__23563;
continue;
} else {
}
break;
}

var G__23496 = args23494.length;
switch (G__23496) {
case 1:
return sablono.core.tel_field23493.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field23493.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23494.length)].join('')));

}
});

sablono.core.tel_field23493.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.tel_field23493.call(null,name__7494__auto__,null);
});

sablono.core.tel_field23493.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.tel_field23493.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field23493);

/**
 * Creates a text input field.
 */
sablono.core.text_field23497 = (function sablono$core$text_field23497(var_args){
var args23498 = [];
var len__5627__auto___23565 = arguments.length;
var i__5628__auto___23566 = (0);
while(true){
if((i__5628__auto___23566 < len__5627__auto___23565)){
args23498.push((arguments[i__5628__auto___23566]));

var G__23567 = (i__5628__auto___23566 + (1));
i__5628__auto___23566 = G__23567;
continue;
} else {
}
break;
}

var G__23500 = args23498.length;
switch (G__23500) {
case 1:
return sablono.core.text_field23497.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field23497.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23498.length)].join('')));

}
});

sablono.core.text_field23497.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.text_field23497.call(null,name__7494__auto__,null);
});

sablono.core.text_field23497.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.text_field23497.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field23497);

/**
 * Creates a time input field.
 */
sablono.core.time_field23501 = (function sablono$core$time_field23501(var_args){
var args23502 = [];
var len__5627__auto___23569 = arguments.length;
var i__5628__auto___23570 = (0);
while(true){
if((i__5628__auto___23570 < len__5627__auto___23569)){
args23502.push((arguments[i__5628__auto___23570]));

var G__23571 = (i__5628__auto___23570 + (1));
i__5628__auto___23570 = G__23571;
continue;
} else {
}
break;
}

var G__23504 = args23502.length;
switch (G__23504) {
case 1:
return sablono.core.time_field23501.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field23501.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23502.length)].join('')));

}
});

sablono.core.time_field23501.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.time_field23501.call(null,name__7494__auto__,null);
});

sablono.core.time_field23501.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.time_field23501.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field23501);

/**
 * Creates a url input field.
 */
sablono.core.url_field23505 = (function sablono$core$url_field23505(var_args){
var args23506 = [];
var len__5627__auto___23573 = arguments.length;
var i__5628__auto___23574 = (0);
while(true){
if((i__5628__auto___23574 < len__5627__auto___23573)){
args23506.push((arguments[i__5628__auto___23574]));

var G__23575 = (i__5628__auto___23574 + (1));
i__5628__auto___23574 = G__23575;
continue;
} else {
}
break;
}

var G__23508 = args23506.length;
switch (G__23508) {
case 1:
return sablono.core.url_field23505.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field23505.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23506.length)].join('')));

}
});

sablono.core.url_field23505.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.url_field23505.call(null,name__7494__auto__,null);
});

sablono.core.url_field23505.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.url_field23505.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field23505);

/**
 * Creates a week input field.
 */
sablono.core.week_field23509 = (function sablono$core$week_field23509(var_args){
var args23510 = [];
var len__5627__auto___23577 = arguments.length;
var i__5628__auto___23578 = (0);
while(true){
if((i__5628__auto___23578 < len__5627__auto___23577)){
args23510.push((arguments[i__5628__auto___23578]));

var G__23579 = (i__5628__auto___23578 + (1));
i__5628__auto___23578 = G__23579;
continue;
} else {
}
break;
}

var G__23512 = args23510.length;
switch (G__23512) {
case 1:
return sablono.core.week_field23509.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field23509.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23510.length)].join('')));

}
});

sablono.core.week_field23509.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.week_field23509.call(null,name__7494__auto__,null);
});

sablono.core.week_field23509.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.week_field23509.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field23509);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box23581 = (function sablono$core$check_box23581(var_args){
var args23582 = [];
var len__5627__auto___23585 = arguments.length;
var i__5628__auto___23586 = (0);
while(true){
if((i__5628__auto___23586 < len__5627__auto___23585)){
args23582.push((arguments[i__5628__auto___23586]));

var G__23587 = (i__5628__auto___23586 + (1));
i__5628__auto___23586 = G__23587;
continue;
} else {
}
break;
}

var G__23584 = args23582.length;
switch (G__23584) {
case 1:
return sablono.core.check_box23581.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box23581.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box23581.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23582.length)].join('')));

}
});

sablono.core.check_box23581.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box23581.call(null,name,null);
});

sablono.core.check_box23581.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box23581.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box23581.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box23581.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box23581);
/**
 * Creates a radio button.
 */
sablono.core.radio_button23589 = (function sablono$core$radio_button23589(var_args){
var args23590 = [];
var len__5627__auto___23593 = arguments.length;
var i__5628__auto___23594 = (0);
while(true){
if((i__5628__auto___23594 < len__5627__auto___23593)){
args23590.push((arguments[i__5628__auto___23594]));

var G__23595 = (i__5628__auto___23594 + (1));
i__5628__auto___23594 = G__23595;
continue;
} else {
}
break;
}

var G__23592 = args23590.length;
switch (G__23592) {
case 1:
return sablono.core.radio_button23589.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button23589.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button23589.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23590.length)].join('')));

}
});

sablono.core.radio_button23589.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button23589.call(null,group,null);
});

sablono.core.radio_button23589.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button23589.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button23589.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button23589.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button23589);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options23597 = (function sablono$core$select_options23597(var_args){
var args23598 = [];
var len__5627__auto___23609 = arguments.length;
var i__5628__auto___23610 = (0);
while(true){
if((i__5628__auto___23610 < len__5627__auto___23609)){
args23598.push((arguments[i__5628__auto___23610]));

var G__23611 = (i__5628__auto___23610 + (1));
i__5628__auto___23610 = G__23611;
continue;
} else {
}
break;
}

var G__23600 = args23598.length;
switch (G__23600) {
case 1:
return sablono.core.select_options23597.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options23597.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23598.length)].join('')));

}
});

sablono.core.select_options23597.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options23597.call(null,coll,null);
});

sablono.core.select_options23597.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__5341__auto__ = (function sablono$core$iter__23601(s__23602){
return (new cljs.core.LazySeq(null,(function (){
var s__23602__$1 = s__23602;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__23602__$1);
if(temp__4425__auto__){
var s__23602__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23602__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__23602__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__23604 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__23603 = (0);
while(true){
if((i__23603 < size__5340__auto__)){
var x = cljs.core._nth.call(null,c__5339__auto__,i__23603);
cljs.core.chunk_append.call(null,b__23604,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__23607 = x;
var text = cljs.core.nth.call(null,vec__23607,(0),null);
var val = cljs.core.nth.call(null,vec__23607,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__23607,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options23597.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)));

var G__23613 = (i__23603 + (1));
i__23603 = G__23613;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23604),sablono$core$iter__23601.call(null,cljs.core.chunk_rest.call(null,s__23602__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23604),null);
}
} else {
var x = cljs.core.first.call(null,s__23602__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__23608 = x;
var text = cljs.core.nth.call(null,vec__23608,(0),null);
var val = cljs.core.nth.call(null,vec__23608,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__23608,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options23597.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)),sablono$core$iter__23601.call(null,cljs.core.rest.call(null,s__23602__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,coll);
});

sablono.core.select_options23597.cljs$lang$maxFixedArity = 2;

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options23597);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down23614 = (function sablono$core$drop_down23614(var_args){
var args23615 = [];
var len__5627__auto___23618 = arguments.length;
var i__5628__auto___23619 = (0);
while(true){
if((i__5628__auto___23619 < len__5627__auto___23618)){
args23615.push((arguments[i__5628__auto___23619]));

var G__23620 = (i__5628__auto___23619 + (1));
i__5628__auto___23619 = G__23620;
continue;
} else {
}
break;
}

var G__23617 = args23615.length;
switch (G__23617) {
case 2:
return sablono.core.drop_down23614.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down23614.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23615.length)].join('')));

}
});

sablono.core.drop_down23614.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down23614.call(null,name,options,null);
});

sablono.core.drop_down23614.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down23614.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down23614);
/**
 * Creates a text area element.
 */
sablono.core.text_area23622 = (function sablono$core$text_area23622(var_args){
var args23623 = [];
var len__5627__auto___23626 = arguments.length;
var i__5628__auto___23627 = (0);
while(true){
if((i__5628__auto___23627 < len__5627__auto___23626)){
args23623.push((arguments[i__5628__auto___23627]));

var G__23628 = (i__5628__auto___23627 + (1));
i__5628__auto___23627 = G__23628;
continue;
} else {
}
break;
}

var G__23625 = args23623.length;
switch (G__23625) {
case 1:
return sablono.core.text_area23622.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area23622.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23623.length)].join('')));

}
});

sablono.core.text_area23622.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area23622.call(null,name,null);
});

sablono.core.text_area23622.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area23622.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area23622);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label23630 = (function sablono$core$label23630(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label23630);
/**
 * Creates a submit button.
 */
sablono.core.submit_button23631 = (function sablono$core$submit_button23631(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button23631);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button23632 = (function sablono$core$reset_button23632(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button23632);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to23633 = (function sablono$core$form_to23633(var_args){
var args__5634__auto__ = [];
var len__5627__auto___23638 = arguments.length;
var i__5628__auto___23639 = (0);
while(true){
if((i__5628__auto___23639 < len__5627__auto___23638)){
args__5634__auto__.push((arguments[i__5628__auto___23639]));

var G__23640 = (i__5628__auto___23639 + (1));
i__5628__auto___23639 = G__23640;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return sablono.core.form_to23633.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

sablono.core.form_to23633.cljs$core$IFn$_invoke$arity$variadic = (function (p__23636,body){
var vec__23637 = p__23636;
var method = cljs.core.nth.call(null,vec__23637,(0),null);
var action = cljs.core.nth.call(null,vec__23637,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,"_method",method_str)], null)),body));
});

sablono.core.form_to23633.cljs$lang$maxFixedArity = (1);

sablono.core.form_to23633.cljs$lang$applyTo = (function (seq23634){
var G__23635 = cljs.core.first.call(null,seq23634);
var seq23634__$1 = cljs.core.next.call(null,seq23634);
return sablono.core.form_to23633.cljs$core$IFn$_invoke$arity$variadic(G__23635,seq23634__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to23633);
