// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Extra fields that will be displayed on the table.
 */
hatti.views.table.get_extra_fields = (function hatti$views$table$get_extra_fields(is_filtered_dataview_QMARK_){
var extra_field = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"full-name","full-name",408178550),hatti.constants._id,new cljs.core.Keyword(null,"label","label",1718410804),"id",new cljs.core.Keyword(null,"name","name",1843675177),hatti.constants._id,new cljs.core.Keyword(null,"type","type",1174270348),"integer"], null)], null);
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
return extra_field;
} else {
return cljs.core.conj.call(null,extra_field,hatti.ona.forms.submission_time_field);
}
});
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(var_args){
var args__5634__auto__ = [];
var len__5627__auto___14574 = arguments.length;
var i__5628__auto___14575 = (0);
while(true){
if((i__5628__auto___14575 < len__5627__auto___14574)){
args__5634__auto__.push((arguments[i__5628__auto___14575]));

var G__14576 = (i__5628__auto___14575 + (1));
i__5628__auto___14575 = G__14576;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__14571){
var map__14572 = p__14571;
var map__14572__$1 = ((((!((map__14572 == null)))?((((map__14572.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14572.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14572):map__14572);
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__14572__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
return cljs.core.distinct.call(null,cljs.core.filter.call(null,hatti.ona.forms.has_data_QMARK_,cljs.core.concat.call(null,hatti.views.table.get_extra_fields.call(null,is_filtered_dataview_QMARK_),hatti.ona.forms.non_meta_fields.call(null,form),hatti.ona.forms.meta_fields.call(null,form,new cljs.core.Keyword(null,"with-submission-details?","with-submission-details?",524960549),cljs.core.not.call(null,is_filtered_dataview_QMARK_)))));
});

hatti.views.table.all_fields.cljs$lang$maxFixedArity = (1);

hatti.views.table.all_fields.cljs$lang$applyTo = (function (seq14569){
var G__14570 = cljs.core.first.call(null,seq14569);
var seq14569__$1 = cljs.core.next.call(null,seq14569);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(G__14570,seq14569__$1);
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__14577_SHARP_){
if(typeof p1__14577_SHARP_ === 'string'){
return clojure.string.lower_case.call(null,p1__14577_SHARP_);
} else {
return p1__14577_SHARP_;
}
});})(col))
;
var aval = lower.call(null,(a[(col["field"])]));
var bval = lower.call(null,(b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not.call(null,args)){
return true;
} else {
var indexed_form = cljs.core.zipmap.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550),form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__14581){
var vec__14582 = p__14581;
var fname = cljs.core.nth.call(null,vec__14582,(0),null);
var answer = cljs.core.nth.call(null,vec__14582,(1),null);
return hatti.ona.forms.format_answer.call(null,cljs.core.get.call(null,indexed_form,fname),answer,null,true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map.call(null,((function (indexed_form,query,fmt_subitem){
return (function (p1__14578_SHARP_){
return cljs.core.re_find.call(null,hatti.utils.safe_regex.call(null,query),[cljs.core.str(p1__14578_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.call(null,fmt_subitem,cljs.core.js__GT_clj.call(null,item))));
return cljs.core.seq.call(null,filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.call(null,value,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return hatti.ona.forms.format_answer.call(null,field,clj_value,language,true);
});
cljs.core._add_method.call(null,hatti.views.action_buttons,new cljs.core.Keyword(null,"default","default",-1987822328),(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__14583 = new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state));
var map__14583__$1 = ((((!((map__14583 == null)))?((((map__14583.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14583.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14583):map__14583);
var owner__$1 = cljs.core.get.call(null,map__14583__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var project = cljs.core.get.call(null,map__14583__$1,new cljs.core.Keyword(null,"project","project",1124394579));
var formid = cljs.core.get.call(null,map__14583__$1,new cljs.core.Keyword(null,"formid","formid",-2121398991));
var form_owner = hatti.utils.last_url_param.call(null,owner__$1);
var project_id = hatti.utils.last_url_param.call(null,project);
var edit_link = hatti.utils.url.call(null,form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join(''));
return hatti.utils.generate_html.call(null,(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip.middle-right","li.tooltip.middle-right",-548323211),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info","span.tip-info",147552832),"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.view-record","a.view-record",235834372),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-clone","i.fa.fa-clone",1946695810),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip","li.tooltip",-1420587330),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info","span.tip-info",147552832),"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.edit-record","a.edit-record",698797771),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value,new cljs.core.Keyword(null,"target","target",253001721),"_blank",new cljs.core.Keyword(null,"href","href",-793805698),edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-pencil-square-o","i.fa.fa-pencil-square-o",1550650091)], null)], null)], null)], null):null));
});
}));
hatti.views.table.actions_column = (function hatti$views$table$actions_column(owner){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"maxWidth","maxWidth",-1375124795),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],["record-actions header",(70),"",hatti.views.action_buttons.call(null,owner),hatti.constants._id,"text","actions",false,"record-actions",""]);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args14585 = [];
var len__5627__auto___14607 = arguments.length;
var i__5628__auto___14608 = (0);
while(true){
if((i__5628__auto___14608 < len__5627__auto___14607)){
args14585.push((arguments[i__5628__auto___14608]));

var G__14609 = (i__5628__auto___14608 + (1));
i__5628__auto___14608 = G__14609;
continue;
} else {
}
break;
}

var G__14591 = args14585.length;
switch (G__14591) {
case 1:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args14585.slice((3)),(0)));
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5646__auto__);

}
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1 = (function (form){
return hatti.views.table.flat_form__GT_sg_columns.call(null,form,true);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2 = (function (form,get_label_QMARK_){
return hatti.views.table.flat_form__GT_sg_columns.call(null,form,get_label_QMARK_,null);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,get_label_QMARK_,language,p__14592){
var map__14593 = p__14592;
var map__14593__$1 = ((((!((map__14593 == null)))?((((map__14593.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14593.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14593):map__14593);
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__14593__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
var owner = cljs.core.get.call(null,map__14593__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var columns = (function (){var iter__5341__auto__ = ((function (map__14593,map__14593__$1,is_filtered_dataview_QMARK_,owner){
return (function hatti$views$table$iter__14595(s__14596){
return (new cljs.core.LazySeq(null,((function (map__14593,map__14593__$1,is_filtered_dataview_QMARK_,owner){
return (function (){
var s__14596__$1 = s__14596;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__14596__$1);
if(temp__4425__auto__){
var s__14596__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__14596__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__14596__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__14598 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__14597 = (0);
while(true){
if((i__14597 < size__5340__auto__)){
var field = cljs.core._nth.call(null,c__5339__auto__,i__14597);
cljs.core.chunk_append.call(null,b__14598,(function (){var map__14603 = field;
var map__14603__$1 = ((((!((map__14603 == null)))?((((map__14603.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14603.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14603):map__14603);
var name = cljs.core.get.call(null,map__14603__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__14603__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__14603__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hatti.ona.forms.get_column_class.call(null,field),label,cljs.core.partial.call(null,hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class.call(null,field),label]);
})());

var G__14611 = (i__14597 + (1));
i__14597 = G__14611;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__14598),hatti$views$table$iter__14595.call(null,cljs.core.chunk_rest.call(null,s__14596__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__14598),null);
}
} else {
var field = cljs.core.first.call(null,s__14596__$2);
return cljs.core.cons.call(null,(function (){var map__14605 = field;
var map__14605__$1 = ((((!((map__14605 == null)))?((((map__14605.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14605.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14605):map__14605);
var name = cljs.core.get.call(null,map__14605__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__14605__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__14605__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hatti.ona.forms.get_column_class.call(null,field),label,cljs.core.partial.call(null,hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class.call(null,field),label]);
})(),hatti$views$table$iter__14595.call(null,cljs.core.rest.call(null,s__14596__$2)));
}
} else {
return null;
}
break;
}
});})(map__14593,map__14593__$1,is_filtered_dataview_QMARK_,owner))
,null,null));
});})(map__14593,map__14593__$1,is_filtered_dataview_QMARK_,owner))
;
return iter__5341__auto__.call(null,hatti.views.table.all_fields.call(null,form,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746),is_filtered_dataview_QMARK_));
})();
return cljs.core.clj__GT_js.call(null,columns);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq14586){
var G__14587 = cljs.core.first.call(null,seq14586);
var seq14586__$1 = cljs.core.next.call(null,seq14586);
var G__14588 = cljs.core.first.call(null,seq14586__$1);
var seq14586__$2 = cljs.core.next.call(null,seq14586__$1);
var G__14589 = cljs.core.first.call(null,seq14586__$2);
var seq14586__$3 = cljs.core.next.call(null,seq14586__$2);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__14587,G__14588,G__14589,seq14586__$3);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (3);
hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,jQuery([cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join(''))));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = {"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false};
/**
 * Fixes the first column on slick table on horizontal scroll
 */
hatti.views.table.freeze_action_column_BANG_ = (function hatti$views$table$freeze_action_column_BANG_(){
var actions = document.getElementsByClassName("record-actions");
var sg_viewport = cljs.core.first.call(null,document.getElementsByClassName("slick-viewport"));
var seq__14617 = cljs.core.seq.call(null,actions);
var chunk__14618 = null;
var count__14619 = (0);
var i__14620 = (0);
while(true){
if((i__14620 < count__14619)){
var action = cljs.core._nth.call(null,chunk__14618,i__14620);
var leftOffset_14621 = parseInt(action.offsetLeft);
sg_viewport.addEventListener("scroll",((function (seq__14617,chunk__14618,count__14619,i__14620,leftOffset_14621,action,actions,sg_viewport){
return (function (){
var sl = sg_viewport.scrollLeft;
var set_border_BANG_ = ((function (seq__14617,chunk__14618,count__14619,i__14620,sl,leftOffset_14621,action,actions,sg_viewport){
return (function (p1__14612_SHARP_){
return action.style.borderRight = p1__14612_SHARP_;
});})(seq__14617,chunk__14618,count__14619,i__14620,sl,leftOffset_14621,action,actions,sg_viewport))
;
if((sl === (0))){
set_border_BANG_.call(null,"1px dotted #ededed");
} else {
set_border_BANG_.call(null,"1px solid silver");
}

return action.style.left = [cljs.core.str((sl + leftOffset_14621)),cljs.core.str("px")].join('');
});})(seq__14617,chunk__14618,count__14619,i__14620,leftOffset_14621,action,actions,sg_viewport))
);

var G__14622 = seq__14617;
var G__14623 = chunk__14618;
var G__14624 = count__14619;
var G__14625 = (i__14620 + (1));
seq__14617 = G__14622;
chunk__14618 = G__14623;
count__14619 = G__14624;
i__14620 = G__14625;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__14617);
if(temp__4425__auto__){
var seq__14617__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__14617__$1)){
var c__5372__auto__ = cljs.core.chunk_first.call(null,seq__14617__$1);
var G__14626 = cljs.core.chunk_rest.call(null,seq__14617__$1);
var G__14627 = c__5372__auto__;
var G__14628 = cljs.core.count.call(null,c__5372__auto__);
var G__14629 = (0);
seq__14617 = G__14626;
chunk__14618 = G__14627;
count__14619 = G__14628;
i__14620 = G__14629;
continue;
} else {
var action = cljs.core.first.call(null,seq__14617__$1);
var leftOffset_14630 = parseInt(action.offsetLeft);
sg_viewport.addEventListener("scroll",((function (seq__14617,chunk__14618,count__14619,i__14620,leftOffset_14630,action,seq__14617__$1,temp__4425__auto__,actions,sg_viewport){
return (function (){
var sl = sg_viewport.scrollLeft;
var set_border_BANG_ = ((function (seq__14617,chunk__14618,count__14619,i__14620,sl,leftOffset_14630,action,seq__14617__$1,temp__4425__auto__,actions,sg_viewport){
return (function (p1__14612_SHARP_){
return action.style.borderRight = p1__14612_SHARP_;
});})(seq__14617,chunk__14618,count__14619,i__14620,sl,leftOffset_14630,action,seq__14617__$1,temp__4425__auto__,actions,sg_viewport))
;
if((sl === (0))){
set_border_BANG_.call(null,"1px dotted #ededed");
} else {
set_border_BANG_.call(null,"1px solid silver");
}

return action.style.left = [cljs.core.str((sl + leftOffset_14630)),cljs.core.str("px")].join('');
});})(seq__14617,chunk__14618,count__14619,i__14620,leftOffset_14630,action,seq__14617__$1,temp__4425__auto__,actions,sg_viewport))
);

var G__14631 = cljs.core.next.call(null,seq__14617__$1);
var G__14632 = null;
var G__14633 = (0);
var G__14634 = (0);
seq__14617 = G__14631;
chunk__14618 = G__14632;
count__14619 = G__14633;
i__14620 = G__14634;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__14643(s__14644){
return (new cljs.core.LazySeq(null,(function (){
var s__14644__$1 = s__14644;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__14644__$1);
if(temp__4425__auto__){
var s__14644__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__14644__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__14644__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__14646 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__14645 = (0);
while(true){
if((i__14645 < size__5340__auto__)){
var vec__14649 = cljs.core._nth.call(null,c__5339__auto__,i__14645);
var handler_key = cljs.core.nth.call(null,vec__14649,(0),null);
var handler_function = cljs.core.nth.call(null,vec__14649,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append.call(null,b__14646,event.subscribe(handler_function));

var G__14651 = (i__14645 + (1));
i__14645 = G__14651;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__14646),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__14643.call(null,cljs.core.chunk_rest.call(null,s__14644__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__14646),null);
}
} else {
var vec__14650 = cljs.core.first.call(null,s__14644__$2);
var handler_key = cljs.core.nth.call(null,vec__14650,(0),null);
var handler_function = cljs.core.nth.call(null,vec__14650,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__14643.call(null,cljs.core.rest.call(null,s__14644__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__14660(s__14661){
return (new cljs.core.LazySeq(null,(function (){
var s__14661__$1 = s__14661;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__14661__$1);
if(temp__4425__auto__){
var s__14661__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__14661__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__14661__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__14663 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__14662 = (0);
while(true){
if((i__14662 < size__5340__auto__)){
var vec__14666 = cljs.core._nth.call(null,c__5339__auto__,i__14662);
var handler_key = cljs.core.nth.call(null,vec__14666,(0),null);
var handler_function = cljs.core.nth.call(null,vec__14666,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append.call(null,b__14663,event.subscribe(handler_function));

var G__14668 = (i__14662 + (1));
i__14662 = G__14668;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__14663),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__14660.call(null,cljs.core.chunk_rest.call(null,s__14661__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__14663),null);
}
} else {
var vec__14667 = cljs.core.first.call(null,s__14661__$2);
var handler_key = cljs.core.nth.call(null,vec__14667,(0),null);
var handler_function = cljs.core.nth.call(null,vec__14667,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__14660.call(null,cljs.core.rest.call(null,s__14661__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,is_filtered_dataview_QMARK_,owner,p__14669){
var map__14678 = p__14669;
var map__14678__$1 = ((((!((map__14678 == null)))?((((map__14678.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14678.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14678):map__14678);
var grid_event_handlers = cljs.core.get.call(null,map__14678__$1,new cljs.core.Keyword(null,"grid-event-handlers","grid-event-handlers",1413592355));
var dataview_event_handlers = cljs.core.get.call(null,map__14678__$1,new cljs.core.Keyword(null,"dataview-event-handlers","dataview-event-handlers",-916375885));
var columns = hatti.views.table.flat_form__GT_sg_columns.call(null,form,true,current_language,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746),is_filtered_dataview_QMARK_,new cljs.core.Keyword(null,"owner","owner",-392611939),owner);
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
var map__14680 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__14680__$1 = ((((!((map__14680 == null)))?((((map__14680.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14680.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14680):map__14680);
var map__14681 = cljs.core.get.call(null,map__14680__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__14681__$1 = ((((!((map__14681 == null)))?((((map__14681.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14681.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14681):map__14681);
var map__14682 = cljs.core.get.call(null,map__14681__$1,new cljs.core.Keyword(null,"paging","paging",1716279728));
var map__14682__$1 = ((((!((map__14682 == null)))?((((map__14682.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14682.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14682):map__14682);
var num_displayed_records = cljs.core.get.call(null,map__14682__$1,new cljs.core.Keyword(null,"num-displayed-records","num-displayed-records",213046400));
var total_page_count = cljs.core.get.call(null,map__14682__$1,new cljs.core.Keyword(null,"total-page-count","total-page-count",582341740));
hatti.views.table.bind_external_sg_grid_event_handlers.call(null,grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers.call(null,dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__14680,map__14680__$1,map__14681,map__14681__$1,map__14682,map__14682__$1,num_displayed_records,total_page_count,map__14678,map__14678__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__14680,map__14680__$1,map__14681,map__14681__$1,map__14682,map__14682__$1,num_displayed_records,total_page_count,map__14678,map__14678__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__14680,map__14680__$1,map__14681,map__14681__$1,map__14682,map__14682__$1,num_displayed_records,total_page_count,map__14678,map__14678__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__14680,map__14680__$1,map__14681,map__14681__$1,map__14682,map__14682__$1,num_displayed_records,total_page_count,map__14678,map__14678__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__14680,map__14680__$1,map__14681,map__14681__$1,map__14682,map__14682__$1,num_displayed_records,total_page_count,map__14678,map__14678__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
});})(columns,SlickGrid,DataView,dataview,grid,map__14680,map__14680__$1,map__14681,map__14681__$1,map__14682,map__14682__$1,num_displayed_records,total_page_count,map__14678,map__14678__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__14680,map__14680__$1,map__14681,map__14681__$1,map__14682,map__14682__$1,num_displayed_records,total_page_count,map__14678,map__14678__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?parseInt(elem.getAttribute("data-id")):null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
if(cljs.core._EQ_.call(null,id,data_id)){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
} else {
return null;
}
});})(columns,SlickGrid,DataView,dataview,grid,map__14680,map__14680__$1,map__14681,map__14681__$1,map__14682,map__14682__$1,num_displayed_records,total_page_count,map__14678,map__14678__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager.call(null,grid,dataview);

dataview.setPagingOptions({"pageSize": (function (){var or__4569__auto__ = num_displayed_records;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count});

dataview.setFilter(cljs.core.partial.call(null,hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js.call(null,data),hatti.constants._id);

hatti.views.table.resizeColumns.call(null,grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap.call(null);
var c__9230__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto__,event_chan){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto__,event_chan){
return (function (state_14947){
var state_val_14948 = (state_14947[(1)]);
if((state_val_14948 === (7))){
var inst_14856 = (state_14947[(7)]);
var inst_14856__$1 = (state_14947[(2)]);
var inst_14858 = (inst_14856__$1 == null);
var inst_14859 = cljs.core.not.call(null,inst_14858);
var state_14947__$1 = (function (){var statearr_14949 = state_14947;
(statearr_14949[(7)] = inst_14856__$1);

return statearr_14949;
})();
if(inst_14859){
var statearr_14950_15017 = state_14947__$1;
(statearr_14950_15017[(1)] = (8));

} else {
var statearr_14951_15018 = state_14947__$1;
(statearr_14951_15018[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (20))){
var inst_14886 = (state_14947[(8)]);
var inst_14878 = (state_14947[(9)]);
var inst_14895 = inst_14886.call(null,inst_14878);
var state_14947__$1 = state_14947;
var statearr_14952_15019 = state_14947__$1;
(statearr_14952_15019[(2)] = inst_14895);

(statearr_14952_15019[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (27))){
var state_14947__$1 = state_14947;
var statearr_14953_15020 = state_14947__$1;
(statearr_14953_15020[(2)] = null);

(statearr_14953_15020[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (1))){
var state_14947__$1 = state_14947;
var statearr_14954_15021 = state_14947__$1;
(statearr_14954_15021[(2)] = null);

(statearr_14954_15021[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (24))){
var state_14947__$1 = state_14947;
var statearr_14955_15022 = state_14947__$1;
(statearr_14955_15022[(2)] = null);

(statearr_14955_15022[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (4))){
var state_14947__$1 = state_14947;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14947__$1,(7),event_chan);
} else {
if((state_val_14948 === (15))){
var inst_14856 = (state_14947[(7)]);
var state_14947__$1 = state_14947;
var statearr_14956_15023 = state_14947__$1;
(statearr_14956_15023[(2)] = inst_14856);

(statearr_14956_15023[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (21))){
var state_14947__$1 = state_14947;
var statearr_14957_15024 = state_14947__$1;
(statearr_14957_15024[(2)] = null);

(statearr_14957_15024[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (31))){
var inst_14882 = (state_14947[(10)]);
var inst_14920 = (state_14947[(2)]);
var inst_14921 = cljs.core._EQ_.call(null,inst_14882,new cljs.core.Keyword(null,"table","table",-564943036));
var state_14947__$1 = (function (){var statearr_14958 = state_14947;
(statearr_14958[(11)] = inst_14920);

return statearr_14958;
})();
if(inst_14921){
var statearr_14959_15025 = state_14947__$1;
(statearr_14959_15025[(1)] = (32));

} else {
var statearr_14960_15026 = state_14947__$1;
(statearr_14960_15026[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (32))){
var inst_14886 = (state_14947[(8)]);
var inst_14879 = (state_14947[(12)]);
var inst_14882 = (state_14947[(10)]);
var inst_14878 = (state_14947[(9)]);
var inst_14887 = (state_14947[(13)]);
var inst_14880 = (state_14947[(14)]);
var inst_14881 = (state_14947[(15)]);
var inst_14877 = (state_14947[(16)]);
var inst_14876 = (state_14947[(17)]);
var inst_14856 = (state_14947[(7)]);
var inst_14934 = cljs.core.async.chan.call(null,(1));
var inst_14935 = (function (){var map__14854 = inst_14876;
var new_columns = inst_14881;
var c__9230__auto____$1 = inst_14934;
var submission_clicked = inst_14878;
var submission_unclicked = inst_14879;
var get_submission_data = inst_14887;
var re_render = inst_14882;
var update_data_BANG_ = inst_14886;
var submission_to_rank = inst_14877;
var e = inst_14856;
var filter_by = inst_14880;
return ((function (map__14854,new_columns,c__9230__auto____$1,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_14886,inst_14879,inst_14882,inst_14878,inst_14887,inst_14880,inst_14881,inst_14877,inst_14876,inst_14856,inst_14934,state_val_14948,c__9230__auto__,event_chan){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (map__14854,new_columns,c__9230__auto____$1,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_14886,inst_14879,inst_14882,inst_14878,inst_14887,inst_14880,inst_14881,inst_14877,inst_14876,inst_14856,inst_14934,state_val_14948,c__9230__auto__,event_chan){
return (function (state_14932){
var state_val_14933 = (state_14932[(1)]);
if((state_val_14933 === (1))){
var inst_14923 = cljs.core.async.timeout.call(null,(20));
var state_14932__$1 = state_14932;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14932__$1,(2),inst_14923);
} else {
if((state_val_14933 === (2))){
var inst_14925 = (state_14932[(2)]);
var inst_14926 = grid.resizeCanvas();
var inst_14927 = grid.invalidateAllRows();
var inst_14928 = hatti.views.table.resizeColumns.call(null,grid);
var inst_14929 = grid.render();
var inst_14930 = hatti.views.table.init_sg_pager.call(null,grid,dataview);
var state_14932__$1 = (function (){var statearr_14961 = state_14932;
(statearr_14961[(7)] = inst_14925);

(statearr_14961[(8)] = inst_14929);

(statearr_14961[(9)] = inst_14926);

(statearr_14961[(10)] = inst_14928);

(statearr_14961[(11)] = inst_14927);

return statearr_14961;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14932__$1,inst_14930);
} else {
return null;
}
}
});})(map__14854,new_columns,c__9230__auto____$1,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_14886,inst_14879,inst_14882,inst_14878,inst_14887,inst_14880,inst_14881,inst_14877,inst_14876,inst_14856,inst_14934,state_val_14948,c__9230__auto__,event_chan))
;
return ((function (switch__9165__auto__,map__14854,new_columns,c__9230__auto____$1,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_14886,inst_14879,inst_14882,inst_14878,inst_14887,inst_14880,inst_14881,inst_14877,inst_14876,inst_14856,inst_14934,state_val_14948,c__9230__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__9166__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__9166__auto____0 = (function (){
var statearr_14965 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14965[(0)] = hatti$views$table$handle_table_events_$_state_machine__9166__auto__);

(statearr_14965[(1)] = (1));

return statearr_14965;
});
var hatti$views$table$handle_table_events_$_state_machine__9166__auto____1 = (function (state_14932){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_14932);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e14966){if((e14966 instanceof Object)){
var ex__9169__auto__ = e14966;
var statearr_14967_15027 = state_14932;
(statearr_14967_15027[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14932);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14966;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15028 = state_14932;
state_14932 = G__15028;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__9166__auto__ = function(state_14932){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__9166__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__9166__auto____1.call(this,state_14932);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__9166__auto____0;
hatti$views$table$handle_table_events_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__9166__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,map__14854,new_columns,c__9230__auto____$1,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_14886,inst_14879,inst_14882,inst_14878,inst_14887,inst_14880,inst_14881,inst_14877,inst_14876,inst_14856,inst_14934,state_val_14948,c__9230__auto__,event_chan))
})();
var state__9232__auto__ = (function (){var statearr_14968 = f__9231__auto__.call(null);
(statearr_14968[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto____$1);

return statearr_14968;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});
;})(map__14854,new_columns,c__9230__auto____$1,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_14886,inst_14879,inst_14882,inst_14878,inst_14887,inst_14880,inst_14881,inst_14877,inst_14876,inst_14856,inst_14934,state_val_14948,c__9230__auto__,event_chan))
})();
var inst_14936 = cljs.core.async.impl.dispatch.run.call(null,inst_14935);
var state_14947__$1 = (function (){var statearr_14969 = state_14947;
(statearr_14969[(18)] = inst_14936);

return statearr_14969;
})();
var statearr_14970_15029 = state_14947__$1;
(statearr_14970_15029[(2)] = inst_14934);

(statearr_14970_15029[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (33))){
var state_14947__$1 = state_14947;
var statearr_14971_15030 = state_14947__$1;
(statearr_14971_15030[(2)] = null);

(statearr_14971_15030[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (13))){
var inst_14868 = (state_14947[(2)]);
var state_14947__$1 = state_14947;
var statearr_14972_15031 = state_14947__$1;
(statearr_14972_15031[(2)] = inst_14868);

(statearr_14972_15031[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (22))){
var inst_14879 = (state_14947[(12)]);
var inst_14898 = (state_14947[(2)]);
var state_14947__$1 = (function (){var statearr_14973 = state_14947;
(statearr_14973[(19)] = inst_14898);

return statearr_14973;
})();
if(cljs.core.truth_(inst_14879)){
var statearr_14974_15032 = state_14947__$1;
(statearr_14974_15032[(1)] = (23));

} else {
var statearr_14975_15033 = state_14947__$1;
(statearr_14975_15033[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (29))){
var inst_14880 = (state_14947[(14)]);
var inst_14912 = [new cljs.core.Keyword(null,"query","query",-1288509510)];
var inst_14913 = [inst_14880];
var inst_14914 = cljs.core.PersistentHashMap.fromArrays(inst_14912,inst_14913);
var inst_14915 = cljs.core.clj__GT_js.call(null,inst_14914);
var inst_14916 = dataview.setFilterArgs(inst_14915);
var inst_14917 = dataview.refresh();
var state_14947__$1 = (function (){var statearr_14976 = state_14947;
(statearr_14976[(20)] = inst_14916);

return statearr_14976;
})();
var statearr_14977_15034 = state_14947__$1;
(statearr_14977_15034[(2)] = inst_14917);

(statearr_14977_15034[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (6))){
var inst_14943 = (state_14947[(2)]);
var state_14947__$1 = state_14947;
var statearr_14978_15035 = state_14947__$1;
(statearr_14978_15035[(2)] = inst_14943);

(statearr_14978_15035[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (28))){
var inst_14880 = (state_14947[(14)]);
var inst_14910 = (state_14947[(2)]);
var state_14947__$1 = (function (){var statearr_14979 = state_14947;
(statearr_14979[(21)] = inst_14910);

return statearr_14979;
})();
if(cljs.core.truth_(inst_14880)){
var statearr_14980_15036 = state_14947__$1;
(statearr_14980_15036[(1)] = (29));

} else {
var statearr_14981_15037 = state_14947__$1;
(statearr_14981_15037[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (25))){
var inst_14881 = (state_14947[(15)]);
var inst_14903 = (state_14947[(2)]);
var state_14947__$1 = (function (){var statearr_14982 = state_14947;
(statearr_14982[(22)] = inst_14903);

return statearr_14982;
})();
if(cljs.core.truth_(inst_14881)){
var statearr_14983_15038 = state_14947__$1;
(statearr_14983_15038[(1)] = (26));

} else {
var statearr_14984_15039 = state_14947__$1;
(statearr_14984_15039[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (34))){
var inst_14939 = (state_14947[(2)]);
var state_14947__$1 = (function (){var statearr_14985 = state_14947;
(statearr_14985[(23)] = inst_14939);

return statearr_14985;
})();
var statearr_14986_15040 = state_14947__$1;
(statearr_14986_15040[(2)] = null);

(statearr_14986_15040[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (17))){
var inst_14886 = (state_14947[(8)]);
var inst_14887 = (state_14947[(13)]);
var inst_14877 = (state_14947[(16)]);
var inst_14889 = inst_14887.call(null,hatti.constants._rank,inst_14877);
var inst_14890 = inst_14886.call(null,inst_14889);
var state_14947__$1 = state_14947;
var statearr_14987_15041 = state_14947__$1;
(statearr_14987_15041[(2)] = inst_14890);

(statearr_14987_15041[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (3))){
var inst_14945 = (state_14947[(2)]);
var state_14947__$1 = state_14947;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14947__$1,inst_14945);
} else {
if((state_val_14948 === (12))){
var state_14947__$1 = state_14947;
var statearr_14988_15042 = state_14947__$1;
(statearr_14988_15042[(2)] = false);

(statearr_14988_15042[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (2))){
var state_14947__$1 = state_14947;
var statearr_14989_15043 = state_14947__$1;
(statearr_14989_15043[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (23))){
var inst_14886 = (state_14947[(8)]);
var inst_14900 = inst_14886.call(null,null);
var state_14947__$1 = state_14947;
var statearr_14991_15044 = state_14947__$1;
(statearr_14991_15044[(2)] = inst_14900);

(statearr_14991_15044[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (19))){
var inst_14878 = (state_14947[(9)]);
var inst_14893 = (state_14947[(2)]);
var state_14947__$1 = (function (){var statearr_14992 = state_14947;
(statearr_14992[(24)] = inst_14893);

return statearr_14992;
})();
if(cljs.core.truth_(inst_14878)){
var statearr_14993_15045 = state_14947__$1;
(statearr_14993_15045[(1)] = (20));

} else {
var statearr_14994_15046 = state_14947__$1;
(statearr_14994_15046[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (11))){
var state_14947__$1 = state_14947;
var statearr_14995_15047 = state_14947__$1;
(statearr_14995_15047[(2)] = true);

(statearr_14995_15047[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (9))){
var state_14947__$1 = state_14947;
var statearr_14996_15048 = state_14947__$1;
(statearr_14996_15048[(2)] = false);

(statearr_14996_15048[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (5))){
var state_14947__$1 = state_14947;
var statearr_14997_15049 = state_14947__$1;
(statearr_14997_15049[(2)] = null);

(statearr_14997_15049[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (14))){
var inst_14856 = (state_14947[(7)]);
var inst_14873 = cljs.core.apply.call(null,cljs.core.hash_map,inst_14856);
var state_14947__$1 = state_14947;
var statearr_14998_15050 = state_14947__$1;
(statearr_14998_15050[(2)] = inst_14873);

(statearr_14998_15050[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (26))){
var inst_14881 = (state_14947[(15)]);
var inst_14905 = grid.setColumns(inst_14881);
var inst_14906 = hatti.views.table.resizeColumns.call(null,grid);
var inst_14907 = grid.render();
var state_14947__$1 = (function (){var statearr_14999 = state_14947;
(statearr_14999[(25)] = inst_14906);

(statearr_14999[(26)] = inst_14905);

return statearr_14999;
})();
var statearr_15000_15051 = state_14947__$1;
(statearr_15000_15051[(2)] = inst_14907);

(statearr_15000_15051[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (16))){
var inst_14886 = (state_14947[(8)]);
var inst_14879 = (state_14947[(12)]);
var inst_14882 = (state_14947[(10)]);
var inst_14878 = (state_14947[(9)]);
var inst_14880 = (state_14947[(14)]);
var inst_14881 = (state_14947[(15)]);
var inst_14877 = (state_14947[(16)]);
var inst_14876 = (state_14947[(17)]);
var inst_14856 = (state_14947[(7)]);
var inst_14876__$1 = (state_14947[(2)]);
var inst_14877__$1 = cljs.core.get.call(null,inst_14876__$1,new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797));
var inst_14878__$1 = cljs.core.get.call(null,inst_14876__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var inst_14879__$1 = cljs.core.get.call(null,inst_14876__$1,new cljs.core.Keyword(null,"submission-unclicked","submission-unclicked",-2099539520));
var inst_14880__$1 = cljs.core.get.call(null,inst_14876__$1,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
var inst_14881__$1 = cljs.core.get.call(null,inst_14876__$1,new cljs.core.Keyword(null,"new-columns","new-columns",-887765797));
var inst_14882__$1 = cljs.core.get.call(null,inst_14876__$1,new cljs.core.Keyword(null,"re-render","re-render",1133553258));
var inst_14883 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14884 = [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.Keyword(null,"data","data",-232669377)];
var inst_14885 = (new cljs.core.PersistentVector(null,3,(5),inst_14883,inst_14884,null));
var inst_14886__$1 = cljs.core.partial.call(null,om.core.update_BANG_,app_state,inst_14885);
var inst_14887 = (function (){var e = inst_14856;
var map__14854 = inst_14876__$1;
var submission_to_rank = inst_14877__$1;
var submission_clicked = inst_14878__$1;
var submission_unclicked = inst_14879__$1;
var filter_by = inst_14880__$1;
var new_columns = inst_14881__$1;
var re_render = inst_14882__$1;
var update_data_BANG_ = inst_14886__$1;
return ((function (e,map__14854,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_14886,inst_14879,inst_14882,inst_14878,inst_14880,inst_14881,inst_14877,inst_14876,inst_14856,inst_14876__$1,inst_14877__$1,inst_14878__$1,inst_14879__$1,inst_14880__$1,inst_14881__$1,inst_14882__$1,inst_14883,inst_14884,inst_14885,inst_14886__$1,state_val_14948,c__9230__auto__,event_chan){
return (function (field,value){
return cljs.core.first.call(null,cljs.core.filter.call(null,((function (e,map__14854,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_14886,inst_14879,inst_14882,inst_14878,inst_14880,inst_14881,inst_14877,inst_14876,inst_14856,inst_14876__$1,inst_14877__$1,inst_14878__$1,inst_14879__$1,inst_14880__$1,inst_14881__$1,inst_14882__$1,inst_14883,inst_14884,inst_14885,inst_14886__$1,state_val_14948,c__9230__auto__,event_chan){
return (function (p1__14686_SHARP_){
return cljs.core._EQ_.call(null,value,cljs.core.get.call(null,p1__14686_SHARP_,field));
});})(e,map__14854,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_14886,inst_14879,inst_14882,inst_14878,inst_14880,inst_14881,inst_14877,inst_14876,inst_14856,inst_14876__$1,inst_14877__$1,inst_14878__$1,inst_14879__$1,inst_14880__$1,inst_14881__$1,inst_14882__$1,inst_14883,inst_14884,inst_14885,inst_14886__$1,state_val_14948,c__9230__auto__,event_chan))
,cljs.core.get_in.call(null,cljs.core.deref.call(null,app_state),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null))));
});
;})(e,map__14854,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_14886,inst_14879,inst_14882,inst_14878,inst_14880,inst_14881,inst_14877,inst_14876,inst_14856,inst_14876__$1,inst_14877__$1,inst_14878__$1,inst_14879__$1,inst_14880__$1,inst_14881__$1,inst_14882__$1,inst_14883,inst_14884,inst_14885,inst_14886__$1,state_val_14948,c__9230__auto__,event_chan))
})();
var state_14947__$1 = (function (){var statearr_15001 = state_14947;
(statearr_15001[(8)] = inst_14886__$1);

(statearr_15001[(12)] = inst_14879__$1);

(statearr_15001[(10)] = inst_14882__$1);

(statearr_15001[(9)] = inst_14878__$1);

(statearr_15001[(13)] = inst_14887);

(statearr_15001[(14)] = inst_14880__$1);

(statearr_15001[(15)] = inst_14881__$1);

(statearr_15001[(16)] = inst_14877__$1);

(statearr_15001[(17)] = inst_14876__$1);

return statearr_15001;
})();
if(cljs.core.truth_(inst_14877__$1)){
var statearr_15002_15052 = state_14947__$1;
(statearr_15002_15052[(1)] = (17));

} else {
var statearr_15003_15053 = state_14947__$1;
(statearr_15003_15053[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (30))){
var state_14947__$1 = state_14947;
var statearr_15004_15054 = state_14947__$1;
(statearr_15004_15054[(2)] = null);

(statearr_15004_15054[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (10))){
var inst_14871 = (state_14947[(2)]);
var state_14947__$1 = state_14947;
if(cljs.core.truth_(inst_14871)){
var statearr_15005_15055 = state_14947__$1;
(statearr_15005_15055[(1)] = (14));

} else {
var statearr_15006_15056 = state_14947__$1;
(statearr_15006_15056[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (18))){
var state_14947__$1 = state_14947;
var statearr_15007_15057 = state_14947__$1;
(statearr_15007_15057[(2)] = null);

(statearr_15007_15057[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14948 === (8))){
var inst_14856 = (state_14947[(7)]);
var inst_14861 = inst_14856.cljs$lang$protocol_mask$partition0$;
var inst_14862 = (inst_14861 & (64));
var inst_14863 = inst_14856.cljs$core$ISeq$;
var inst_14864 = (inst_14862) || (inst_14863);
var state_14947__$1 = state_14947;
if(cljs.core.truth_(inst_14864)){
var statearr_15008_15058 = state_14947__$1;
(statearr_15008_15058[(1)] = (11));

} else {
var statearr_15009_15059 = state_14947__$1;
(statearr_15009_15059[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto__,event_chan))
;
return ((function (switch__9165__auto__,c__9230__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__9166__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__9166__auto____0 = (function (){
var statearr_15013 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15013[(0)] = hatti$views$table$handle_table_events_$_state_machine__9166__auto__);

(statearr_15013[(1)] = (1));

return statearr_15013;
});
var hatti$views$table$handle_table_events_$_state_machine__9166__auto____1 = (function (state_14947){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_14947);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e15014){if((e15014 instanceof Object)){
var ex__9169__auto__ = e15014;
var statearr_15015_15060 = state_14947;
(statearr_15015_15060[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14947);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15014;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15061 = state_14947;
state_14947 = G__15061;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__9166__auto__ = function(state_14947){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__9166__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__9166__auto____1.call(this,state_14947);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__9166__auto____0;
hatti$views$table$handle_table_events_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__9166__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto__,event_chan))
})();
var state__9232__auto__ = (function (){var statearr_15016 = f__9231__auto__.call(null);
(statearr_15016[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto__);

return statearr_15016;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto__,event_chan))
);

return c__9230__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208),k);

return colset_BANG_.call(null,k);
});
var iter__5341__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__15070(s__15071){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__15071__$1 = s__15071;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__15071__$1);
if(temp__4425__auto__){
var s__15071__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__15071__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__15071__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__15073 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__15072 = (0);
while(true){
if((i__15072 < size__5340__auto__)){
var vec__15076 = cljs.core._nth.call(null,c__5339__auto__,i__15072);
var k = cljs.core.nth.call(null,vec__15076,(0),null);
var v = cljs.core.nth.call(null,vec__15076,(1),null);
cljs.core.chunk_append.call(null,b__15073,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (i__15072,vec__15076,k,v,c__5339__auto__,size__5340__auto__,b__15073,s__15071__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(i__15072,vec__15076,k,v,c__5339__auto__,size__5340__auto__,b__15073,s__15071__$2,temp__4425__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null));

var G__15078 = (i__15072 + (1));
i__15072 = G__15078;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15073),hatti$views$table$render_options_$_iter__15070.call(null,cljs.core.chunk_rest.call(null,s__15071__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15073),null);
}
} else {
var vec__15077 = cljs.core.first.call(null,s__15071__$2);
var k = cljs.core.nth.call(null,vec__15077,(0),null);
var v = cljs.core.nth.call(null,vec__15077,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (vec__15077,k,v,s__15071__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(vec__15077,k,v,s__15071__$2,temp__4425__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__15070.call(null,cljs.core.rest.call(null,s__15071__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__5341__auto__.call(null,options);
});
cljs.core._add_method.call(null,hatti.views.label_changer,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table15080 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table15080 = (function (_,owner,meta15081){
this._ = _;
this.owner = owner;
this.meta15081 = meta15081;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table15080.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15082,meta15081__$1){
var self__ = this;
var _15082__$1 = this;
return (new hatti.views.table.t_hatti$views$table15080(self__._,self__.owner,meta15081__$1));
});

hatti.views.table.t_hatti$views$table15080.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15082){
var self__ = this;
var _15082__$1 = this;
return self__.meta15081;
});

hatti.views.table.t_hatti$views$table15080.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table15080.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208),new cljs.core.Keyword(null,"label","label",1718410804)], null);
});

hatti.views.table.t_hatti$views$table15080.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table15080.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__15083){
var self__ = this;
var map__15084 = p__15083;
var map__15084__$1 = ((((!((map__15084 == null)))?((((map__15084.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15084.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15084):map__15084);
var name_or_label = cljs.core.get.call(null,map__15084__$1,new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208));
var language = cljs.core.get.call(null,map__15084__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Label"], null),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Name"], null)], null);
var map__15086 = om.core.get_shared.call(null,self__.owner);
var map__15086__$1 = ((((!((map__15086 == null)))?((((map__15086.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15086.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15086):map__15086);
var flat_form = cljs.core.get.call(null,map__15086__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var new_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,self__.owner,hatti.shared.language_cursor.call(null)));
var colset_BANG_ = ((function (options,map__15086,map__15086__$1,flat_form,new_language,___$2,map__15084,map__15084__$1,name_or_label,language){
return (function (p1__15079_SHARP_){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"new-columns","new-columns",-887765797),hatti.views.table.flat_form__GT_sg_columns.call(null,flat_form,cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"label","label",1718410804),p1__15079_SHARP_),new_language)], null));
});})(options,map__15086,map__15086__$1,flat_form,new_language,___$2,map__15084,map__15084__$1,name_or_label,language))
;
if(cljs.core.not_EQ_.call(null,new_language,language)){
om.core.set_state_BANG_.call(null,self__.owner,new cljs.core.Keyword(null,"language","language",-1591107564),new_language);

colset_BANG_.call(null,name_or_label);
} else {
}

return React.DOM.div({"className": "label-changer"},React.DOM.span({"className": "label-changer-label"},"Show:"),React.DOM.div({"id": "header-display-dropdown", "className": "drop-hover"},(function (){var attrs15090 = options.call(null,name_or_label);
return cljs.core.apply.call(null,React.DOM.span,((cljs.core.map_QMARK_.call(null,attrs15090))?sablono.interpreter.attributes.call(null,attrs15090):null),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs15090))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [React.DOM.i({"className": "fa fa-angle-down"})], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs15090),React.DOM.i({"className": "fa fa-angle-down"})], null))));
})(),React.DOM.ul({"className": "submenu no-dot"},sablono.interpreter.interpret.call(null,hatti.views.table.render_options.call(null,options,self__.owner,colset_BANG_)))));
});

hatti.views.table.t_hatti$views$table15080.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta15081","meta15081",-1458359102,null)], null);
});

hatti.views.table.t_hatti$views$table15080.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table15080.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table15080";

hatti.views.table.t_hatti$views$table15080.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"hatti.views.table/t_hatti$views$table15080");
});

hatti.views.table.__GT_t_hatti$views$table15080 = (function hatti$views$table$__GT_t_hatti$views$table15080(___$1,owner__$1,meta15081){
return (new hatti.views.table.t_hatti$views$table15080(___$1,owner__$1,meta15081));
});

}

return (new hatti.views.table.t_hatti$views$table15080(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__9230__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto__,query){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto__,query){
return (function (state_15137){
var state_val_15138 = (state_15137[(1)]);
if((state_val_15138 === (1))){
var inst_15123 = cljs.core.async.timeout.call(null,(150));
var state_15137__$1 = state_15137;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15137__$1,(2),inst_15123);
} else {
if((state_val_15138 === (2))){
var inst_15125 = (state_15137[(2)]);
var inst_15126 = input.value;
var inst_15127 = cljs.core._EQ_.call(null,query,inst_15126);
var state_15137__$1 = (function (){var statearr_15139 = state_15137;
(statearr_15139[(7)] = inst_15125);

return statearr_15139;
})();
if(inst_15127){
var statearr_15140_15151 = state_15137__$1;
(statearr_15140_15151[(1)] = (3));

} else {
var statearr_15141_15152 = state_15137__$1;
(statearr_15141_15152[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15138 === (3))){
var inst_15129 = [query_event_key];
var inst_15130 = [query];
var inst_15131 = cljs.core.PersistentHashMap.fromArrays(inst_15129,inst_15130);
var inst_15132 = cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,inst_15131);
var state_15137__$1 = state_15137;
var statearr_15142_15153 = state_15137__$1;
(statearr_15142_15153[(2)] = inst_15132);

(statearr_15142_15153[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15138 === (4))){
var state_15137__$1 = state_15137;
var statearr_15143_15154 = state_15137__$1;
(statearr_15143_15154[(2)] = null);

(statearr_15143_15154[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15138 === (5))){
var inst_15135 = (state_15137[(2)]);
var state_15137__$1 = state_15137;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15137__$1,inst_15135);
} else {
return null;
}
}
}
}
}
});})(c__9230__auto__,query))
;
return ((function (switch__9165__auto__,c__9230__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__9166__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__9166__auto____0 = (function (){
var statearr_15147 = [null,null,null,null,null,null,null,null];
(statearr_15147[(0)] = hatti$views$table$delayed_search_$_state_machine__9166__auto__);

(statearr_15147[(1)] = (1));

return statearr_15147;
});
var hatti$views$table$delayed_search_$_state_machine__9166__auto____1 = (function (state_15137){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_15137);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e15148){if((e15148 instanceof Object)){
var ex__9169__auto__ = e15148;
var statearr_15149_15155 = state_15137;
(statearr_15149_15155[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15137);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15148;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15156 = state_15137;
state_15137 = G__15156;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__9166__auto__ = function(state_15137){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__9166__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__9166__auto____1.call(this,state_15137);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__9166__auto____0;
hatti$views$table$delayed_search_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__9166__auto____1;
return hatti$views$table$delayed_search_$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto__,query))
})();
var state__9232__auto__ = (function (){var statearr_15150 = f__9231__auto__.call(null);
(statearr_15150[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto__);

return statearr_15150;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto__,query))
);

return c__9230__auto__;
});
cljs.core._add_method.call(null,hatti.views.table_search,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table15158 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table15158 = (function (_,owner,meta15159){
this._ = _;
this.owner = owner;
this.meta15159 = meta15159;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table15158.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15160,meta15159__$1){
var self__ = this;
var _15160__$1 = this;
return (new hatti.views.table.t_hatti$views$table15158(self__._,self__.owner,meta15159__$1));
});

hatti.views.table.t_hatti$views$table15158.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15160){
var self__ = this;
var _15160__$1 = this;
return self__.meta15159;
});

hatti.views.table.t_hatti$views$table15158.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table15158.prototype.om$core$IRender$render$arity$1 = (function (this__6567__auto__){
var self__ = this;
var this__6567__auto____$1 = this;
return React.DOM.div({"className": "table-search"},React.DOM.i({"className": "fa fa-search"}),sablono.interpreter.input.call(null,{"type": "text", "placeholder": "Search", "onChange": ((function (this__6567__auto____$1){
return (function (p1__15157_SHARP_){
return hatti.views.table.delayed_search.call(null,p1__15157_SHARP_.target,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
});})(this__6567__auto____$1))
}));
});

hatti.views.table.t_hatti$views$table15158.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta15159","meta15159",-1990624139,null)], null);
});

hatti.views.table.t_hatti$views$table15158.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table15158.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table15158";

hatti.views.table.t_hatti$views$table15158.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"hatti.views.table/t_hatti$views$table15158");
});

hatti.views.table.__GT_t_hatti$views$table15158 = (function hatti$views$table$__GT_t_hatti$views$table15158(___$1,owner__$1,meta15159){
return (new hatti.views.table.t_hatti$views$table15158(___$1,owner__$1,meta15159));
});

}

return (new hatti.views.table.t_hatti$views$table15158(_,owner,null));
}));
cljs.core._add_method.call(null,hatti.views.table_header,new cljs.core.Keyword(null,"default","default",-1987822328),(function (app_state,owner){
if(typeof hatti.views.table.t_hatti$views$table15163 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table15163 = (function (app_state,owner,meta15164){
this.app_state = app_state;
this.owner = owner;
this.meta15164 = meta15164;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table15163.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15165,meta15164__$1){
var self__ = this;
var _15165__$1 = this;
return (new hatti.views.table.t_hatti$views$table15163(self__.app_state,self__.owner,meta15164__$1));
});

hatti.views.table.t_hatti$views$table15163.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15165){
var self__ = this;
var _15165__$1 = this;
return self__.meta15164;
});

hatti.views.table.t_hatti$views$table15163.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table15163.prototype.om$core$IRender$render$arity$1 = (function (this__6567__auto__){
var self__ = this;
var this__6567__auto____$1 = this;
return React.DOM.div({"className": "topbar"},React.DOM.div({"id": hatti.views.table.pager_id}),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.label_changer,null)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_search,self__.app_state)),React.DOM.div({"style": {"clear": "both"}}));
});

hatti.views.table.t_hatti$views$table15163.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"app-state","app-state",130568249,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta15164","meta15164",-246047895,null)], null);
});

hatti.views.table.t_hatti$views$table15163.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table15163.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table15163";

hatti.views.table.t_hatti$views$table15163.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"hatti.views.table/t_hatti$views$table15163");
});

hatti.views.table.__GT_t_hatti$views$table15163 = (function hatti$views$table$__GT_t_hatti$views$table15163(app_state__$1,owner__$1,meta15164){
return (new hatti.views.table.t_hatti$views$table15163(app_state__$1,owner__$1,meta15164));
});

}

return (new hatti.views.table.t_hatti$views$table15163(app_state,owner,null));
}));
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){

if(cljs.core.seq.call(null,data)){
var map__15171 = om.core.get_shared.call(null,owner);
var map__15171__$1 = ((((!((map__15171 == null)))?((((map__15171.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15171.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15171):map__15171);
var flat_form = cljs.core.get.call(null,map__15171__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__15171__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
var current_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,owner,hatti.shared.language_cursor.call(null)));
var vec__15172 = hatti.views.table.sg_init.call(null,data,flat_form,current_language,is_filtered_dataview_QMARK_,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.call(null,vec__15172,(0),null);
var dataview = cljs.core.nth.call(null,vec__15172,(1),null);
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"grid","grid",402978600),grid);

om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"dataview","dataview",91765671),dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table.get_table_view_height = (function hatti$views$table$get_table_view_height(){
return (document.querySelector("body").clientHeight - document.querySelector(".tab-page").getBoundingClientRect().top);
});
hatti.views.table.set_window_resize_handler = (function hatti$views$table$set_window_resize_handler(owner){
var resize_handler = (function (event){
return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"table-view-height","table-view-height",-951800901),hatti.views.table.get_table_view_height.call(null));
});
window.addEventListener("resize",resize_handler);

return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"resize-handler","resize-handler",-169459881),resize_handler);
});
cljs.core._add_method.call(null,hatti.views.table_page,new cljs.core.Keyword(null,"default","default",-1987822328),(function (app_state,owner,p__15175){
var map__15176 = p__15175;
var map__15176__$1 = ((((!((map__15176 == null)))?((((map__15176.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15176.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15176):map__15176);
var opts = map__15176__$1;
var slick_grid_event_handlers = cljs.core.get.call(null,map__15176__$1,new cljs.core.Keyword(null,"slick-grid-event-handlers","slick-grid-event-handlers",1990034724));

if(typeof hatti.views.table.t_hatti$views$table15178 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table15178 = (function (app_state,owner,p__15175,map__15176,opts,slick_grid_event_handlers,meta15179){
this.app_state = app_state;
this.owner = owner;
this.p__15175 = p__15175;
this.map__15176 = map__15176;
this.opts = opts;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.meta15179 = meta15179;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table15178.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__15176,map__15176__$1,opts,slick_grid_event_handlers){
return (function (_15180,meta15179__$1){
var self__ = this;
var _15180__$1 = this;
return (new hatti.views.table.t_hatti$views$table15178(self__.app_state,self__.owner,self__.p__15175,self__.map__15176,self__.opts,self__.slick_grid_event_handlers,meta15179__$1));
});})(map__15176,map__15176__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table15178.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__15176,map__15176__$1,opts,slick_grid_event_handlers){
return (function (_15180){
var self__ = this;
var _15180__$1 = this;
return self__.meta15179;
});})(map__15176,map__15176__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table15178.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table15178.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (map__15176,map__15176__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
hatti.views.table.set_window_resize_handler.call(null,self__.owner);

var data = cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_.call(null,data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__15181 = temp__4425__auto__;
var grid = cljs.core.nth.call(null,vec__15181,(0),null);
var dataview = cljs.core.nth.call(null,vec__15181,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.app_state,grid,dataview);
} else {
return null;
}
});})(map__15176,map__15176__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table15178.prototype.om$core$IWillUnmount$ = true;

hatti.views.table.t_hatti$views$table15178.prototype.om$core$IWillUnmount$will_unmount$arity$1 = ((function (map__15176,map__15176__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
return window.removeEventListener("resize",om.core.get_state.call(null,self__.owner,new cljs.core.Keyword(null,"resize-handler","resize-handler",-169459881)));
});})(map__15176,map__15176__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table15178.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table15178.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (map__15176,map__15176__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

var old_data = cljs.core.get_in.call(null,om.core.get_props.call(null,self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var new_data = cljs.core.get_in.call(null,next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var map__15182 = om.core.get_state.call(null,self__.owner);
var map__15182__$1 = ((((!((map__15182 == null)))?((((map__15182.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15182.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15182):map__15182);
var grid = cljs.core.get.call(null,map__15182__$1,new cljs.core.Keyword(null,"grid","grid",402978600));
var dataview = cljs.core.get.call(null,map__15182__$1,new cljs.core.Keyword(null,"dataview","dataview",91765671));
if(cljs.core.not_EQ_.call(null,old_data,new_data)){
if(cljs.core.empty_QMARK_.call(null,old_data)){
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_.call(null,new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__15184 = temp__4425__auto__;
var grid__$1 = cljs.core.nth.call(null,vec__15184,(0),null);
var dataview__$1 = cljs.core.nth.call(null,vec__15184,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.app_state,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js.call(null,new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
});})(map__15176,map__15176__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table15178.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table15178.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__15176,map__15176__$1,opts,slick_grid_event_handlers){
return (function (_,p__15185){
var self__ = this;
var map__15186 = p__15185;
var map__15186__$1 = ((((!((map__15186 == null)))?((((map__15186.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15186.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15186):map__15186);
var table_view_height = cljs.core.get.call(null,map__15186__$1,new cljs.core.Keyword(null,"table-view-height","table-view-height",-951800901));
var ___$1 = this;
var map__15188 = self__.app_state;
var map__15188__$1 = ((((!((map__15188 == null)))?((((map__15188.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15188.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15188):map__15188);
var map__15189 = cljs.core.get.call(null,map__15188__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__15189__$1 = ((((!((map__15189 == null)))?((((map__15189.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15189.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15189):map__15189);
var prevent_scrolling_in_table_view_QMARK_ = cljs.core.get.call(null,map__15189__$1,new cljs.core.Keyword(null,"prevent-scrolling-in-table-view?","prevent-scrolling-in-table-view?",2053296532));
var submission_clicked = cljs.core.get.call(null,map__15189__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var data = cljs.core.get.call(null,map__15188__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var dataset_info = cljs.core.get.call(null,map__15188__$1,new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563));
var map__15190 = dataset_info;
var map__15190__$1 = ((((!((map__15190 == null)))?((((map__15190.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15190.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15190):map__15190);
var num_of_submissions = cljs.core.get.call(null,map__15190__$1,new cljs.core.Keyword(null,"num_of_submissions","num_of_submissions",-1720943091));
var no_data_QMARK_ = cljs.core.empty_QMARK_.call(null,data);
var with_info = ((function (map__15188,map__15188__$1,map__15189,map__15189__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__15190,map__15190__$1,num_of_submissions,no_data_QMARK_,___$1,map__15186,map__15186__$1,table_view_height,map__15176,map__15176__$1,opts,slick_grid_event_handlers){
return (function (p1__15174_SHARP_){
return cljs.core.merge.call(null,p1__15174_SHARP_,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563),dataset_info], null));
});})(map__15188,map__15188__$1,map__15189,map__15189__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__15190,map__15190__$1,num_of_submissions,no_data_QMARK_,___$1,map__15186,map__15186__$1,table_view_height,map__15176,map__15176__$1,opts,slick_grid_event_handlers))
;
return React.DOM.div({"style": cljs.core.clj__GT_js.call(null,(cljs.core.truth_(prevent_scrolling_in_table_view_QMARK_)?new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"height","height",1025178622),(function (){var or__4569__auto__ = table_view_height;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return hatti.views.table.get_table_view_height.call(null);
}
})(),new cljs.core.Keyword(null,"overflow","overflow",2058931880),"hidden"], null):null)), "className": "table-view"},sablono.interpreter.interpret.call(null,(cljs.core.truth_(new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(submission_clicked))?om.core.build.call(null,hatti.views.submission_view,with_info.call(null,submission_clicked),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge.call(null,cljs.core.select_keys.call(null,self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"role","role",-736691072),null,new cljs.core.Keyword(null,"delete-record!","delete-record!",1411848194),null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"table","table",-564943036)], null))], null)):null)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.app_state)),React.DOM.div({"id": hatti.views.table.table_id, "className": "slickgrid"},(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.span({"className": "empty-state"},"No data"):React.DOM.span(null,React.DOM.i({"className": "fa fa-spinner fa-pulse"}),"Loading..."))));
});})(map__15176,map__15176__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table15178.getBasis = ((function (map__15176,map__15176__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"app-state","app-state",130568249,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__15175","p__15175",443217614,null),new cljs.core.Symbol(null,"map__15176","map__15176",-2098051715,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"slick-grid-event-handlers","slick-grid-event-handlers",-664401045,null),new cljs.core.Symbol(null,"meta15179","meta15179",1860424189,null)], null);
});})(map__15176,map__15176__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table15178.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table15178.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table15178";

hatti.views.table.t_hatti$views$table15178.cljs$lang$ctorPrWriter = ((function (map__15176,map__15176__$1,opts,slick_grid_event_handlers){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"hatti.views.table/t_hatti$views$table15178");
});})(map__15176,map__15176__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table15178 = ((function (map__15176,map__15176__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table15178(app_state__$1,owner__$1,p__15175__$1,map__15176__$2,opts__$1,slick_grid_event_handlers__$1,meta15179){
return (new hatti.views.table.t_hatti$views$table15178(app_state__$1,owner__$1,p__15175__$1,map__15176__$2,opts__$1,slick_grid_event_handlers__$1,meta15179));
});})(map__15176,map__15176__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table15178(app_state,owner,p__15175,map__15176__$1,opts,slick_grid_event_handlers,cljs.core.PersistentArrayMap.EMPTY));
}));
