// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.shared');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('sablono.core');
goog.require('hatti.utils.om.state');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('om.core');
goog.require('hatti.utils');
hatti.shared.event_chan = cljs.core.async.chan.call(null);
hatti.shared.event_multi_chan = cljs.core.async.mult.call(null,hatti.shared.event_chan);
hatti.shared.event_tap = (function hatti$shared$event_tap(){
return cljs.core.async.tap.call(null,hatti.shared.event_multi_chan,cljs.core.async.chan.call(null));
});
hatti.shared.external_event_chan = cljs.core.async.chan.call(null);
hatti.shared.external_event_multi_chan = cljs.core.async.mult.call(null,hatti.shared.external_event_chan);
hatti.shared.external_event_tap = (function hatti$shared$external_event_tap(){
return cljs.core.async.tap.call(null,hatti.shared.external_event_multi_chan,cljs.core.async.chan.call(null));
});
hatti.shared.default_fields = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"full-name","full-name",408178550),"_submission_time",new cljs.core.Keyword(null,"label","label",1718410804),"Submission Time",new cljs.core.Keyword(null,"name","name",1843675177),"_submission_time",new cljs.core.Keyword(null,"type","type",1174270348),"datetime"], null)], null);
/**
 * An initial, empty, app-state, which can be modified to change dataviews.
 */
hatti.shared.empty_app_state = (function hatti$shared$empty_app_state(){
return cljs.core.atom.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"api-url","api-url",2037917643),new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563),new cljs.core.Keyword(null,"chart-page","chart-page",14505465),new cljs.core.Keyword(null,"languages","languages",1471910331),new cljs.core.Keyword(null,"map-page","map-page",108547100),new cljs.core.Keyword(null,"views","views",1450155487),new cljs.core.Keyword(null,"data","data",-232669377)],["//api.ona.io/api/v1/",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),null], null)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"total-records","total-records",-1940276645),(0),new cljs.core.Keyword(null,"loading?","loading?",1905707049),true], null),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"visible-charts","visible-charts",-1864927735),hatti.shared.default_fields,new cljs.core.Keyword(null,"chart-data","chart-data",-1181877206),cljs.core.PersistentArrayMap.EMPTY], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"current","current",-1088038603),null,new cljs.core.Keyword(null,"all","all",892129742),cljs.core.PersistentVector.EMPTY], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),null], null),new cljs.core.Keyword(null,"geofield","geofield",578715548),cljs.core.PersistentArrayMap.EMPTY], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"all","all",892129742),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"overview","overview",-435037267),new cljs.core.Keyword(null,"map","map",1371690461),new cljs.core.Keyword(null,"table","table",-564943036),new cljs.core.Keyword(null,"chart","chart",1173225425),new cljs.core.Keyword(null,"saved-charts","saved-charts",2129251691),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"report-view","report-view",-1592707414),new cljs.core.Keyword(null,"user-guide","user-guide",774875009)], null),new cljs.core.Keyword(null,"selected","selected",574897764),new cljs.core.Keyword(null,"overview","overview",-435037267)], null),cljs.core.PersistentVector.EMPTY]));
});
hatti.shared.app_state = hatti.shared.empty_app_state.call(null);
/**
 * Given a function over data, run a transact on data inside app-state.
 */
hatti.shared.transact_app_data_BANG_ = (function hatti$shared$transact_app_data_BANG_(app_state,transact_fn){
return hatti.utils.om.state.transact_app_state_BANG_.call(null,app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null),transact_fn);
});
/**
 * Given `data` received from the server, update the app-state.
 * Sorts by submission time, and adds rank to the data, for table + map views.
 */
hatti.shared.update_app_data_BANG_ = (function hatti$shared$update_app_data_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___12706 = arguments.length;
var i__5628__auto___12707 = (0);
while(true){
if((i__5628__auto___12707 < len__5627__auto___12706)){
args__5634__auto__.push((arguments[i__5628__auto___12707]));

var G__12708 = (i__5628__auto___12707 + (1));
i__5628__auto___12707 = G__12708;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,data,p__12703){
var map__12704 = p__12703;
var map__12704__$1 = ((((!((map__12704 == null)))?((((map__12704.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12704.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12704):map__12704);
var rerank_QMARK_ = cljs.core.get.call(null,map__12704__$1,new cljs.core.Keyword(null,"rerank?","rerank?",-177233089));
var completed_QMARK_ = cljs.core.get.call(null,map__12704__$1,new cljs.core.Keyword(null,"completed?","completed?",946828354));
var sort_field = cljs.core.get.call(null,map__12704__$1,new cljs.core.Keyword(null,"sort-field","sort-field",-941433793));
var current_start_index = cljs.core.get.call(null,map__12704__$1,new cljs.core.Keyword(null,"current-start-index","current-start-index",-285076643),(0));
var add_rank = ((function (map__12704,map__12704__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (i,v){
return cljs.core.assoc.call(null,v,hatti.constants._rank,(current_start_index + (i + (1))));
});})(map__12704,map__12704__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
;
var data__$1 = (cljs.core.truth_((function (){var and__4557__auto__ = rerank_QMARK_;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.seq.call(null,data);
} else {
return and__4557__auto__;
}
})())?cljs.core.vec.call(null,cljs.core.map_indexed.call(null,add_rank,cljs.core.sort_by.call(null,((function (add_rank,map__12704,map__12704__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (p1__12699_SHARP_){
return cljs.core.get.call(null,p1__12699_SHARP_,(function (){var or__4569__auto__ = sort_field;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return hatti.constants._submission_time;
}
})());
});})(add_rank,map__12704,map__12704__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
,data))):cljs.core.vec.call(null,cljs.core.map_indexed.call(null,add_rank,data)));
var total_records = cljs.core.count.call(null,data__$1);
hatti.shared.transact_app_data_BANG_.call(null,app_state,((function (add_rank,data__$1,total_records,map__12704,map__12704__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (_){
return data__$1;
});})(add_rank,data__$1,total_records,map__12704,map__12704__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
);

return hatti.utils.om.state.merge_into_app_state_BANG_.call(null,app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"status","status",-1997798413)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"total-records","total-records",-1940276645),total_records,new cljs.core.Keyword(null,"loading?","loading?",1905707049),cljs.core.not.call(null,completed_QMARK_)], null));
});

hatti.shared.update_app_data_BANG_.cljs$lang$maxFixedArity = (2);

hatti.shared.update_app_data_BANG_.cljs$lang$applyTo = (function (seq12700){
var G__12701 = cljs.core.first.call(null,seq12700);
var seq12700__$1 = cljs.core.next.call(null,seq12700);
var G__12702 = cljs.core.first.call(null,seq12700__$1);
var seq12700__$2 = cljs.core.next.call(null,seq12700__$1);
return hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12701,G__12702,seq12700__$2);
});
/**
 * Add to app data.
 */
hatti.shared.add_to_app_data_BANG_ = (function hatti$shared$add_to_app_data_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___12715 = arguments.length;
var i__5628__auto___12716 = (0);
while(true){
if((i__5628__auto___12716 < len__5627__auto___12715)){
args__5634__auto__.push((arguments[i__5628__auto___12716]));

var G__12717 = (i__5628__auto___12716 + (1));
i__5628__auto___12716 = G__12717;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,data,p__12712){
var map__12713 = p__12712;
var map__12713__$1 = ((((!((map__12713 == null)))?((((map__12713.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12713.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12713):map__12713);
var completed_QMARK_ = cljs.core.get.call(null,map__12713__$1,new cljs.core.Keyword(null,"completed?","completed?",946828354));
var old_data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,app_state));
hatti.shared.update_app_data_BANG_.call(null,app_state,cljs.core.concat.call(null,old_data,data),new cljs.core.Keyword(null,"rerank?","rerank?",-177233089),completed_QMARK_);

return hatti.utils.om.state.update_app_state_BANG_.call(null,app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"loading?","loading?",1905707049)], null),cljs.core.not.call(null,completed_QMARK_));
});

hatti.shared.add_to_app_data_BANG_.cljs$lang$maxFixedArity = (2);

hatti.shared.add_to_app_data_BANG_.cljs$lang$applyTo = (function (seq12709){
var G__12710 = cljs.core.first.call(null,seq12709);
var seq12709__$1 = cljs.core.next.call(null,seq12709);
var G__12711 = cljs.core.first.call(null,seq12709__$1);
var seq12709__$2 = cljs.core.next.call(null,seq12709__$1);
return hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12710,G__12711,seq12709__$2);
});
hatti.shared.language_cursor = (function hatti$shared$language_cursor(){
return om.core.ref_cursor.call(null,new cljs.core.Keyword(null,"languages","languages",1471910331).cljs$core$IFn$_invoke$arity$1(om.core.root_cursor.call(null,hatti.shared.app_state)));
});
/**
 * A language selector and a following divider.
 */
hatti.shared.language_selector = (function hatti$shared$language_selector(_,owner){
if(typeof hatti.shared.t_hatti$shared12735 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.shared.t_hatti$shared12735 = (function (language_selector,_,owner,meta12736){
this.language_selector = language_selector;
this._ = _;
this.owner = owner;
this.meta12736 = meta12736;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.shared.t_hatti$shared12735.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12737,meta12736__$1){
var self__ = this;
var _12737__$1 = this;
return (new hatti.shared.t_hatti$shared12735(self__.language_selector,self__._,self__.owner,meta12736__$1));
});

hatti.shared.t_hatti$shared12735.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12737){
var self__ = this;
var _12737__$1 = this;
return self__.meta12736;
});

hatti.shared.t_hatti$shared12735.prototype.om$core$IRender$ = true;

hatti.shared.t_hatti$shared12735.prototype.om$core$IRender$render$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var map__12738 = om.core.observe.call(null,self__.owner,hatti.shared.language_cursor.call(null));
var map__12738__$1 = ((((!((map__12738 == null)))?((((map__12738.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12738.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12738):map__12738);
var ls = map__12738__$1;
var current = cljs.core.get.call(null,map__12738__$1,new cljs.core.Keyword(null,"current","current",-1088038603));
var all = cljs.core.get.call(null,map__12738__$1,new cljs.core.Keyword(null,"all","all",892129742));
var get_update_handler = ((function (map__12738,map__12738__$1,ls,current,all,___$2){
return (function (language){
return ((function (map__12738,map__12738__$1,ls,current,all,___$2){
return (function (event){
om.core.update_BANG_.call(null,ls,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current","current",-1088038603)], null),language);

return event.preventDefault();
});
;})(map__12738,map__12738__$1,ls,current,all,___$2))
});})(map__12738,map__12738__$1,ls,current,all,___$2))
;
var stringify = ((function (map__12738,map__12738__$1,ls,current,all,get_update_handler,___$2){
return (function (p1__12718_SHARP_){
if((p1__12718_SHARP_ instanceof cljs.core.Keyword)){
return cljs.core.name.call(null,p1__12718_SHARP_);
} else {
return [cljs.core.str(p1__12718_SHARP_)].join('');
}
});})(map__12738,map__12738__$1,ls,current,all,get_update_handler,___$2))
;
return React.DOM.div({"className": "language-selector-inner"},React.DOM.span({"className": "dropdown drop-hover"},React.DOM.i({"style": {"marginRight": ".2em"}, "className": "fa fa-globe"}),(function (){var attrs12742 = (cljs.core.truth_(hatti.ona.forms.english_QMARK_.call(null,current))?"EN":stringify.call(null,current));
return cljs.core.apply.call(null,React.DOM.span,((cljs.core.map_QMARK_.call(null,attrs12742))?sablono.interpreter.attributes.call(null,attrs12742):null),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs12742))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs12742)], null))));
})(),React.DOM.i({"style": {"marginLeft": ".5em"}, "className": "fa fa-angle-down"}),React.DOM.ul({"className": "submenu"},cljs.core.into_array.call(null,(function (){var iter__5341__auto__ = ((function (map__12738,map__12738__$1,ls,current,all,get_update_handler,stringify,___$2){
return (function hatti$shared$language_selector_$_iter__12747(s__12748){
return (new cljs.core.LazySeq(null,((function (map__12738,map__12738__$1,ls,current,all,get_update_handler,stringify,___$2){
return (function (){
var s__12748__$1 = s__12748;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__12748__$1);
if(temp__4425__auto__){
var s__12748__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__12748__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__12748__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__12750 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__12749 = (0);
while(true){
if((i__12749 < size__5340__auto__)){
var language = cljs.core._nth.call(null,c__5339__auto__,i__12749);
cljs.core.chunk_append.call(null,b__12750,React.DOM.li(null,React.DOM.a({"href": "#", "onClick": get_update_handler.call(null,language)},sablono.interpreter.interpret.call(null,stringify.call(null,language)))));

var G__12751 = (i__12749 + (1));
i__12749 = G__12751;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12750),hatti$shared$language_selector_$_iter__12747.call(null,cljs.core.chunk_rest.call(null,s__12748__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12750),null);
}
} else {
var language = cljs.core.first.call(null,s__12748__$2);
return cljs.core.cons.call(null,React.DOM.li(null,React.DOM.a({"href": "#", "onClick": get_update_handler.call(null,language)},sablono.interpreter.interpret.call(null,stringify.call(null,language)))),hatti$shared$language_selector_$_iter__12747.call(null,cljs.core.rest.call(null,s__12748__$2)));
}
} else {
return null;
}
break;
}
});})(map__12738,map__12738__$1,ls,current,all,get_update_handler,stringify,___$2))
,null,null));
});})(map__12738,map__12738__$1,ls,current,all,get_update_handler,stringify,___$2))
;
return iter__5341__auto__.call(null,all);
})()))),React.DOM.div({"className": "divider"}));
});

hatti.shared.t_hatti$shared12735.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"language-selector","language-selector",-1895427281,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"A language selector and a following divider."], null)),new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta12736","meta12736",430916736,null)], null);
});

hatti.shared.t_hatti$shared12735.cljs$lang$type = true;

hatti.shared.t_hatti$shared12735.cljs$lang$ctorStr = "hatti.shared/t_hatti$shared12735";

hatti.shared.t_hatti$shared12735.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"hatti.shared/t_hatti$shared12735");
});

hatti.shared.__GT_t_hatti$shared12735 = (function hatti$shared$language_selector_$___GT_t_hatti$shared12735(language_selector__$1,___$1,owner__$1,meta12736){
return (new hatti.shared.t_hatti$shared12735(language_selector__$1,___$1,owner__$1,meta12736));
});

}

return (new hatti.shared.t_hatti$shared12735(hatti$shared$language_selector,_,owner,cljs.core.PersistentArrayMap.EMPTY));
});
