// Compiled by ClojureScript 1.7.145 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t_cljs$core$async17639 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17639 = (function (fn_handler,f,meta17640){
this.fn_handler = fn_handler;
this.f = f;
this.meta17640 = meta17640;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17639.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17641,meta17640__$1){
var self__ = this;
var _17641__$1 = this;
return (new cljs.core.async.t_cljs$core$async17639(self__.fn_handler,self__.f,meta17640__$1));
});

cljs.core.async.t_cljs$core$async17639.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17641){
var self__ = this;
var _17641__$1 = this;
return self__.meta17640;
});

cljs.core.async.t_cljs$core$async17639.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17639.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17639.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async17639.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"fn-handler","fn-handler",648785851,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null)))], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"meta17640","meta17640",-959738892,null)], null);
});

cljs.core.async.t_cljs$core$async17639.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17639.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17639";

cljs.core.async.t_cljs$core$async17639.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async17639");
});

cljs.core.async.__GT_t_cljs$core$async17639 = (function cljs$core$async$fn_handler_$___GT_t_cljs$core$async17639(fn_handler__$1,f__$1,meta17640){
return (new cljs.core.async.t_cljs$core$async17639(fn_handler__$1,f__$1,meta17640));
});

}

return (new cljs.core.async.t_cljs$core$async17639(cljs$core$async$fn_handler,f,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args17644 = [];
var len__5627__auto___17647 = arguments.length;
var i__5628__auto___17648 = (0);
while(true){
if((i__5628__auto___17648 < len__5627__auto___17647)){
args17644.push((arguments[i__5628__auto___17648]));

var G__17649 = (i__5628__auto___17648 + (1));
i__5628__auto___17648 = G__17649;
continue;
} else {
}
break;
}

var G__17646 = args17644.length;
switch (G__17646) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17644.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args17651 = [];
var len__5627__auto___17654 = arguments.length;
var i__5628__auto___17655 = (0);
while(true){
if((i__5628__auto___17655 < len__5627__auto___17654)){
args17651.push((arguments[i__5628__auto___17655]));

var G__17656 = (i__5628__auto___17655 + (1));
i__5628__auto___17655 = G__17656;
continue;
} else {
}
break;
}

var G__17653 = args17651.length;
switch (G__17653) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17651.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_17658 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_17658);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_17658,ret){
return (function (){
return fn1.call(null,val_17658);
});})(val_17658,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args17659 = [];
var len__5627__auto___17662 = arguments.length;
var i__5628__auto___17663 = (0);
while(true){
if((i__5628__auto___17663 < len__5627__auto___17662)){
args17659.push((arguments[i__5628__auto___17663]));

var G__17664 = (i__5628__auto___17663 + (1));
i__5628__auto___17663 = G__17664;
continue;
} else {
}
break;
}

var G__17661 = args17659.length;
switch (G__17661) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17659.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5472__auto___17666 = n;
var x_17667 = (0);
while(true){
if((x_17667 < n__5472__auto___17666)){
(a[x_17667] = (0));

var G__17668 = (x_17667 + (1));
x_17667 = G__17668;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__17669 = (i + (1));
i = G__17669;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async17673 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17673 = (function (alt_flag,flag,meta17674){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta17674 = meta17674;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17673.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_17675,meta17674__$1){
var self__ = this;
var _17675__$1 = this;
return (new cljs.core.async.t_cljs$core$async17673(self__.alt_flag,self__.flag,meta17674__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async17673.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_17675){
var self__ = this;
var _17675__$1 = this;
return self__.meta17674;
});})(flag))
;

cljs.core.async.t_cljs$core$async17673.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17673.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async17673.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17673.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta17674","meta17674",-2144880411,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async17673.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17673.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17673";

cljs.core.async.t_cljs$core$async17673.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async17673");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async17673 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async17673(alt_flag__$1,flag__$1,meta17674){
return (new cljs.core.async.t_cljs$core$async17673(alt_flag__$1,flag__$1,meta17674));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async17673(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async17679 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17679 = (function (alt_handler,flag,cb,meta17680){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta17680 = meta17680;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17679.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17681,meta17680__$1){
var self__ = this;
var _17681__$1 = this;
return (new cljs.core.async.t_cljs$core$async17679(self__.alt_handler,self__.flag,self__.cb,meta17680__$1));
});

cljs.core.async.t_cljs$core$async17679.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17681){
var self__ = this;
var _17681__$1 = this;
return self__.meta17680;
});

cljs.core.async.t_cljs$core$async17679.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17679.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async17679.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async17679.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta17680","meta17680",-748455979,null)], null);
});

cljs.core.async.t_cljs$core$async17679.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17679.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17679";

cljs.core.async.t_cljs$core$async17679.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async17679");
});

cljs.core.async.__GT_t_cljs$core$async17679 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async17679(alt_handler__$1,flag__$1,cb__$1,meta17680){
return (new cljs.core.async.t_cljs$core$async17679(alt_handler__$1,flag__$1,cb__$1,meta17680));
});

}

return (new cljs.core.async.t_cljs$core$async17679(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17682_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17682_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17683_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17683_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4569__auto__ = wport;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17684 = (i + (1));
i = G__17684;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4569__auto__ = ret;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4557__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___17690 = arguments.length;
var i__5628__auto___17691 = (0);
while(true){
if((i__5628__auto___17691 < len__5627__auto___17690)){
args__5634__auto__.push((arguments[i__5628__auto___17691]));

var G__17692 = (i__5628__auto___17691 + (1));
i__5628__auto___17691 = G__17692;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__17687){
var map__17688 = p__17687;
var map__17688__$1 = ((((!((map__17688 == null)))?((((map__17688.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17688.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17688):map__17688);
var opts = map__17688__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq17685){
var G__17686 = cljs.core.first.call(null,seq17685);
var seq17685__$1 = cljs.core.next.call(null,seq17685);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17686,seq17685__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args17693 = [];
var len__5627__auto___17743 = arguments.length;
var i__5628__auto___17744 = (0);
while(true){
if((i__5628__auto___17744 < len__5627__auto___17743)){
args17693.push((arguments[i__5628__auto___17744]));

var G__17745 = (i__5628__auto___17744 + (1));
i__5628__auto___17744 = G__17745;
continue;
} else {
}
break;
}

var G__17695 = args17693.length;
switch (G__17695) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17693.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__9230__auto___17747 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___17747){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___17747){
return (function (state_17719){
var state_val_17720 = (state_17719[(1)]);
if((state_val_17720 === (7))){
var inst_17715 = (state_17719[(2)]);
var state_17719__$1 = state_17719;
var statearr_17721_17748 = state_17719__$1;
(statearr_17721_17748[(2)] = inst_17715);

(statearr_17721_17748[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17720 === (1))){
var state_17719__$1 = state_17719;
var statearr_17722_17749 = state_17719__$1;
(statearr_17722_17749[(2)] = null);

(statearr_17722_17749[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17720 === (4))){
var inst_17698 = (state_17719[(7)]);
var inst_17698__$1 = (state_17719[(2)]);
var inst_17699 = (inst_17698__$1 == null);
var state_17719__$1 = (function (){var statearr_17723 = state_17719;
(statearr_17723[(7)] = inst_17698__$1);

return statearr_17723;
})();
if(cljs.core.truth_(inst_17699)){
var statearr_17724_17750 = state_17719__$1;
(statearr_17724_17750[(1)] = (5));

} else {
var statearr_17725_17751 = state_17719__$1;
(statearr_17725_17751[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17720 === (13))){
var state_17719__$1 = state_17719;
var statearr_17726_17752 = state_17719__$1;
(statearr_17726_17752[(2)] = null);

(statearr_17726_17752[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17720 === (6))){
var inst_17698 = (state_17719[(7)]);
var state_17719__$1 = state_17719;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17719__$1,(11),to,inst_17698);
} else {
if((state_val_17720 === (3))){
var inst_17717 = (state_17719[(2)]);
var state_17719__$1 = state_17719;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17719__$1,inst_17717);
} else {
if((state_val_17720 === (12))){
var state_17719__$1 = state_17719;
var statearr_17727_17753 = state_17719__$1;
(statearr_17727_17753[(2)] = null);

(statearr_17727_17753[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17720 === (2))){
var state_17719__$1 = state_17719;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17719__$1,(4),from);
} else {
if((state_val_17720 === (11))){
var inst_17708 = (state_17719[(2)]);
var state_17719__$1 = state_17719;
if(cljs.core.truth_(inst_17708)){
var statearr_17728_17754 = state_17719__$1;
(statearr_17728_17754[(1)] = (12));

} else {
var statearr_17729_17755 = state_17719__$1;
(statearr_17729_17755[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17720 === (9))){
var state_17719__$1 = state_17719;
var statearr_17730_17756 = state_17719__$1;
(statearr_17730_17756[(2)] = null);

(statearr_17730_17756[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17720 === (5))){
var state_17719__$1 = state_17719;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17731_17757 = state_17719__$1;
(statearr_17731_17757[(1)] = (8));

} else {
var statearr_17732_17758 = state_17719__$1;
(statearr_17732_17758[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17720 === (14))){
var inst_17713 = (state_17719[(2)]);
var state_17719__$1 = state_17719;
var statearr_17733_17759 = state_17719__$1;
(statearr_17733_17759[(2)] = inst_17713);

(statearr_17733_17759[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17720 === (10))){
var inst_17705 = (state_17719[(2)]);
var state_17719__$1 = state_17719;
var statearr_17734_17760 = state_17719__$1;
(statearr_17734_17760[(2)] = inst_17705);

(statearr_17734_17760[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17720 === (8))){
var inst_17702 = cljs.core.async.close_BANG_.call(null,to);
var state_17719__$1 = state_17719;
var statearr_17735_17761 = state_17719__$1;
(statearr_17735_17761[(2)] = inst_17702);

(statearr_17735_17761[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___17747))
;
return ((function (switch__9165__auto__,c__9230__auto___17747){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_17739 = [null,null,null,null,null,null,null,null];
(statearr_17739[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_17739[(1)] = (1));

return statearr_17739;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_17719){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_17719);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e17740){if((e17740 instanceof Object)){
var ex__9169__auto__ = e17740;
var statearr_17741_17762 = state_17719;
(statearr_17741_17762[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17719);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17740;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17763 = state_17719;
state_17719 = G__17763;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_17719){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_17719);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___17747))
})();
var state__9232__auto__ = (function (){var statearr_17742 = f__9231__auto__.call(null);
(statearr_17742[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___17747);

return statearr_17742;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___17747))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__17947){
var vec__17948 = p__17947;
var v = cljs.core.nth.call(null,vec__17948,(0),null);
var p = cljs.core.nth.call(null,vec__17948,(1),null);
var job = vec__17948;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__9230__auto___18130 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___18130,res,vec__17948,v,p,job,jobs,results){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___18130,res,vec__17948,v,p,job,jobs,results){
return (function (state_17953){
var state_val_17954 = (state_17953[(1)]);
if((state_val_17954 === (1))){
var state_17953__$1 = state_17953;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17953__$1,(2),res,v);
} else {
if((state_val_17954 === (2))){
var inst_17950 = (state_17953[(2)]);
var inst_17951 = cljs.core.async.close_BANG_.call(null,res);
var state_17953__$1 = (function (){var statearr_17955 = state_17953;
(statearr_17955[(7)] = inst_17950);

return statearr_17955;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17953__$1,inst_17951);
} else {
return null;
}
}
});})(c__9230__auto___18130,res,vec__17948,v,p,job,jobs,results))
;
return ((function (switch__9165__auto__,c__9230__auto___18130,res,vec__17948,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0 = (function (){
var statearr_17959 = [null,null,null,null,null,null,null,null];
(statearr_17959[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__);

(statearr_17959[(1)] = (1));

return statearr_17959;
});
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1 = (function (state_17953){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_17953);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e17960){if((e17960 instanceof Object)){
var ex__9169__auto__ = e17960;
var statearr_17961_18131 = state_17953;
(statearr_17961_18131[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17953);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17960;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18132 = state_17953;
state_17953 = G__18132;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = function(state_17953){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1.call(this,state_17953);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___18130,res,vec__17948,v,p,job,jobs,results))
})();
var state__9232__auto__ = (function (){var statearr_17962 = f__9231__auto__.call(null);
(statearr_17962[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___18130);

return statearr_17962;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___18130,res,vec__17948,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__17963){
var vec__17964 = p__17963;
var v = cljs.core.nth.call(null,vec__17964,(0),null);
var p = cljs.core.nth.call(null,vec__17964,(1),null);
var job = vec__17964;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5472__auto___18133 = n;
var __18134 = (0);
while(true){
if((__18134 < n__5472__auto___18133)){
var G__17965_18135 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__17965_18135) {
case "compute":
var c__9230__auto___18137 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__18134,c__9230__auto___18137,G__17965_18135,n__5472__auto___18133,jobs,results,process,async){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (__18134,c__9230__auto___18137,G__17965_18135,n__5472__auto___18133,jobs,results,process,async){
return (function (state_17978){
var state_val_17979 = (state_17978[(1)]);
if((state_val_17979 === (1))){
var state_17978__$1 = state_17978;
var statearr_17980_18138 = state_17978__$1;
(statearr_17980_18138[(2)] = null);

(statearr_17980_18138[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (2))){
var state_17978__$1 = state_17978;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17978__$1,(4),jobs);
} else {
if((state_val_17979 === (3))){
var inst_17976 = (state_17978[(2)]);
var state_17978__$1 = state_17978;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17978__$1,inst_17976);
} else {
if((state_val_17979 === (4))){
var inst_17968 = (state_17978[(2)]);
var inst_17969 = process.call(null,inst_17968);
var state_17978__$1 = state_17978;
if(cljs.core.truth_(inst_17969)){
var statearr_17981_18139 = state_17978__$1;
(statearr_17981_18139[(1)] = (5));

} else {
var statearr_17982_18140 = state_17978__$1;
(statearr_17982_18140[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (5))){
var state_17978__$1 = state_17978;
var statearr_17983_18141 = state_17978__$1;
(statearr_17983_18141[(2)] = null);

(statearr_17983_18141[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (6))){
var state_17978__$1 = state_17978;
var statearr_17984_18142 = state_17978__$1;
(statearr_17984_18142[(2)] = null);

(statearr_17984_18142[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17979 === (7))){
var inst_17974 = (state_17978[(2)]);
var state_17978__$1 = state_17978;
var statearr_17985_18143 = state_17978__$1;
(statearr_17985_18143[(2)] = inst_17974);

(statearr_17985_18143[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__18134,c__9230__auto___18137,G__17965_18135,n__5472__auto___18133,jobs,results,process,async))
;
return ((function (__18134,switch__9165__auto__,c__9230__auto___18137,G__17965_18135,n__5472__auto___18133,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0 = (function (){
var statearr_17989 = [null,null,null,null,null,null,null];
(statearr_17989[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__);

(statearr_17989[(1)] = (1));

return statearr_17989;
});
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1 = (function (state_17978){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_17978);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e17990){if((e17990 instanceof Object)){
var ex__9169__auto__ = e17990;
var statearr_17991_18144 = state_17978;
(statearr_17991_18144[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17978);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17990;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18145 = state_17978;
state_17978 = G__18145;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = function(state_17978){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1.call(this,state_17978);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__;
})()
;})(__18134,switch__9165__auto__,c__9230__auto___18137,G__17965_18135,n__5472__auto___18133,jobs,results,process,async))
})();
var state__9232__auto__ = (function (){var statearr_17992 = f__9231__auto__.call(null);
(statearr_17992[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___18137);

return statearr_17992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(__18134,c__9230__auto___18137,G__17965_18135,n__5472__auto___18133,jobs,results,process,async))
);


break;
case "async":
var c__9230__auto___18146 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__18134,c__9230__auto___18146,G__17965_18135,n__5472__auto___18133,jobs,results,process,async){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (__18134,c__9230__auto___18146,G__17965_18135,n__5472__auto___18133,jobs,results,process,async){
return (function (state_18005){
var state_val_18006 = (state_18005[(1)]);
if((state_val_18006 === (1))){
var state_18005__$1 = state_18005;
var statearr_18007_18147 = state_18005__$1;
(statearr_18007_18147[(2)] = null);

(statearr_18007_18147[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18006 === (2))){
var state_18005__$1 = state_18005;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18005__$1,(4),jobs);
} else {
if((state_val_18006 === (3))){
var inst_18003 = (state_18005[(2)]);
var state_18005__$1 = state_18005;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18005__$1,inst_18003);
} else {
if((state_val_18006 === (4))){
var inst_17995 = (state_18005[(2)]);
var inst_17996 = async.call(null,inst_17995);
var state_18005__$1 = state_18005;
if(cljs.core.truth_(inst_17996)){
var statearr_18008_18148 = state_18005__$1;
(statearr_18008_18148[(1)] = (5));

} else {
var statearr_18009_18149 = state_18005__$1;
(statearr_18009_18149[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18006 === (5))){
var state_18005__$1 = state_18005;
var statearr_18010_18150 = state_18005__$1;
(statearr_18010_18150[(2)] = null);

(statearr_18010_18150[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18006 === (6))){
var state_18005__$1 = state_18005;
var statearr_18011_18151 = state_18005__$1;
(statearr_18011_18151[(2)] = null);

(statearr_18011_18151[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18006 === (7))){
var inst_18001 = (state_18005[(2)]);
var state_18005__$1 = state_18005;
var statearr_18012_18152 = state_18005__$1;
(statearr_18012_18152[(2)] = inst_18001);

(statearr_18012_18152[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__18134,c__9230__auto___18146,G__17965_18135,n__5472__auto___18133,jobs,results,process,async))
;
return ((function (__18134,switch__9165__auto__,c__9230__auto___18146,G__17965_18135,n__5472__auto___18133,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0 = (function (){
var statearr_18016 = [null,null,null,null,null,null,null];
(statearr_18016[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__);

(statearr_18016[(1)] = (1));

return statearr_18016;
});
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1 = (function (state_18005){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_18005);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e18017){if((e18017 instanceof Object)){
var ex__9169__auto__ = e18017;
var statearr_18018_18153 = state_18005;
(statearr_18018_18153[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18005);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18017;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18154 = state_18005;
state_18005 = G__18154;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = function(state_18005){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1.call(this,state_18005);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__;
})()
;})(__18134,switch__9165__auto__,c__9230__auto___18146,G__17965_18135,n__5472__auto___18133,jobs,results,process,async))
})();
var state__9232__auto__ = (function (){var statearr_18019 = f__9231__auto__.call(null);
(statearr_18019[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___18146);

return statearr_18019;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(__18134,c__9230__auto___18146,G__17965_18135,n__5472__auto___18133,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__18155 = (__18134 + (1));
__18134 = G__18155;
continue;
} else {
}
break;
}

var c__9230__auto___18156 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___18156,jobs,results,process,async){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___18156,jobs,results,process,async){
return (function (state_18041){
var state_val_18042 = (state_18041[(1)]);
if((state_val_18042 === (1))){
var state_18041__$1 = state_18041;
var statearr_18043_18157 = state_18041__$1;
(statearr_18043_18157[(2)] = null);

(statearr_18043_18157[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18042 === (2))){
var state_18041__$1 = state_18041;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18041__$1,(4),from);
} else {
if((state_val_18042 === (3))){
var inst_18039 = (state_18041[(2)]);
var state_18041__$1 = state_18041;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18041__$1,inst_18039);
} else {
if((state_val_18042 === (4))){
var inst_18022 = (state_18041[(7)]);
var inst_18022__$1 = (state_18041[(2)]);
var inst_18023 = (inst_18022__$1 == null);
var state_18041__$1 = (function (){var statearr_18044 = state_18041;
(statearr_18044[(7)] = inst_18022__$1);

return statearr_18044;
})();
if(cljs.core.truth_(inst_18023)){
var statearr_18045_18158 = state_18041__$1;
(statearr_18045_18158[(1)] = (5));

} else {
var statearr_18046_18159 = state_18041__$1;
(statearr_18046_18159[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18042 === (5))){
var inst_18025 = cljs.core.async.close_BANG_.call(null,jobs);
var state_18041__$1 = state_18041;
var statearr_18047_18160 = state_18041__$1;
(statearr_18047_18160[(2)] = inst_18025);

(statearr_18047_18160[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18042 === (6))){
var inst_18022 = (state_18041[(7)]);
var inst_18027 = (state_18041[(8)]);
var inst_18027__$1 = cljs.core.async.chan.call(null,(1));
var inst_18028 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18029 = [inst_18022,inst_18027__$1];
var inst_18030 = (new cljs.core.PersistentVector(null,2,(5),inst_18028,inst_18029,null));
var state_18041__$1 = (function (){var statearr_18048 = state_18041;
(statearr_18048[(8)] = inst_18027__$1);

return statearr_18048;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18041__$1,(8),jobs,inst_18030);
} else {
if((state_val_18042 === (7))){
var inst_18037 = (state_18041[(2)]);
var state_18041__$1 = state_18041;
var statearr_18049_18161 = state_18041__$1;
(statearr_18049_18161[(2)] = inst_18037);

(statearr_18049_18161[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18042 === (8))){
var inst_18027 = (state_18041[(8)]);
var inst_18032 = (state_18041[(2)]);
var state_18041__$1 = (function (){var statearr_18050 = state_18041;
(statearr_18050[(9)] = inst_18032);

return statearr_18050;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18041__$1,(9),results,inst_18027);
} else {
if((state_val_18042 === (9))){
var inst_18034 = (state_18041[(2)]);
var state_18041__$1 = (function (){var statearr_18051 = state_18041;
(statearr_18051[(10)] = inst_18034);

return statearr_18051;
})();
var statearr_18052_18162 = state_18041__$1;
(statearr_18052_18162[(2)] = null);

(statearr_18052_18162[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___18156,jobs,results,process,async))
;
return ((function (switch__9165__auto__,c__9230__auto___18156,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0 = (function (){
var statearr_18056 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18056[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__);

(statearr_18056[(1)] = (1));

return statearr_18056;
});
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1 = (function (state_18041){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_18041);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e18057){if((e18057 instanceof Object)){
var ex__9169__auto__ = e18057;
var statearr_18058_18163 = state_18041;
(statearr_18058_18163[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18041);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18057;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18164 = state_18041;
state_18041 = G__18164;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = function(state_18041){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1.call(this,state_18041);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___18156,jobs,results,process,async))
})();
var state__9232__auto__ = (function (){var statearr_18059 = f__9231__auto__.call(null);
(statearr_18059[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___18156);

return statearr_18059;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___18156,jobs,results,process,async))
);


var c__9230__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto__,jobs,results,process,async){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto__,jobs,results,process,async){
return (function (state_18097){
var state_val_18098 = (state_18097[(1)]);
if((state_val_18098 === (7))){
var inst_18093 = (state_18097[(2)]);
var state_18097__$1 = state_18097;
var statearr_18099_18165 = state_18097__$1;
(statearr_18099_18165[(2)] = inst_18093);

(statearr_18099_18165[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18098 === (20))){
var state_18097__$1 = state_18097;
var statearr_18100_18166 = state_18097__$1;
(statearr_18100_18166[(2)] = null);

(statearr_18100_18166[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18098 === (1))){
var state_18097__$1 = state_18097;
var statearr_18101_18167 = state_18097__$1;
(statearr_18101_18167[(2)] = null);

(statearr_18101_18167[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18098 === (4))){
var inst_18062 = (state_18097[(7)]);
var inst_18062__$1 = (state_18097[(2)]);
var inst_18063 = (inst_18062__$1 == null);
var state_18097__$1 = (function (){var statearr_18102 = state_18097;
(statearr_18102[(7)] = inst_18062__$1);

return statearr_18102;
})();
if(cljs.core.truth_(inst_18063)){
var statearr_18103_18168 = state_18097__$1;
(statearr_18103_18168[(1)] = (5));

} else {
var statearr_18104_18169 = state_18097__$1;
(statearr_18104_18169[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18098 === (15))){
var inst_18075 = (state_18097[(8)]);
var state_18097__$1 = state_18097;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18097__$1,(18),to,inst_18075);
} else {
if((state_val_18098 === (21))){
var inst_18088 = (state_18097[(2)]);
var state_18097__$1 = state_18097;
var statearr_18105_18170 = state_18097__$1;
(statearr_18105_18170[(2)] = inst_18088);

(statearr_18105_18170[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18098 === (13))){
var inst_18090 = (state_18097[(2)]);
var state_18097__$1 = (function (){var statearr_18106 = state_18097;
(statearr_18106[(9)] = inst_18090);

return statearr_18106;
})();
var statearr_18107_18171 = state_18097__$1;
(statearr_18107_18171[(2)] = null);

(statearr_18107_18171[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18098 === (6))){
var inst_18062 = (state_18097[(7)]);
var state_18097__$1 = state_18097;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18097__$1,(11),inst_18062);
} else {
if((state_val_18098 === (17))){
var inst_18083 = (state_18097[(2)]);
var state_18097__$1 = state_18097;
if(cljs.core.truth_(inst_18083)){
var statearr_18108_18172 = state_18097__$1;
(statearr_18108_18172[(1)] = (19));

} else {
var statearr_18109_18173 = state_18097__$1;
(statearr_18109_18173[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18098 === (3))){
var inst_18095 = (state_18097[(2)]);
var state_18097__$1 = state_18097;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18097__$1,inst_18095);
} else {
if((state_val_18098 === (12))){
var inst_18072 = (state_18097[(10)]);
var state_18097__$1 = state_18097;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18097__$1,(14),inst_18072);
} else {
if((state_val_18098 === (2))){
var state_18097__$1 = state_18097;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18097__$1,(4),results);
} else {
if((state_val_18098 === (19))){
var state_18097__$1 = state_18097;
var statearr_18110_18174 = state_18097__$1;
(statearr_18110_18174[(2)] = null);

(statearr_18110_18174[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18098 === (11))){
var inst_18072 = (state_18097[(2)]);
var state_18097__$1 = (function (){var statearr_18111 = state_18097;
(statearr_18111[(10)] = inst_18072);

return statearr_18111;
})();
var statearr_18112_18175 = state_18097__$1;
(statearr_18112_18175[(2)] = null);

(statearr_18112_18175[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18098 === (9))){
var state_18097__$1 = state_18097;
var statearr_18113_18176 = state_18097__$1;
(statearr_18113_18176[(2)] = null);

(statearr_18113_18176[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18098 === (5))){
var state_18097__$1 = state_18097;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18114_18177 = state_18097__$1;
(statearr_18114_18177[(1)] = (8));

} else {
var statearr_18115_18178 = state_18097__$1;
(statearr_18115_18178[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18098 === (14))){
var inst_18075 = (state_18097[(8)]);
var inst_18077 = (state_18097[(11)]);
var inst_18075__$1 = (state_18097[(2)]);
var inst_18076 = (inst_18075__$1 == null);
var inst_18077__$1 = cljs.core.not.call(null,inst_18076);
var state_18097__$1 = (function (){var statearr_18116 = state_18097;
(statearr_18116[(8)] = inst_18075__$1);

(statearr_18116[(11)] = inst_18077__$1);

return statearr_18116;
})();
if(inst_18077__$1){
var statearr_18117_18179 = state_18097__$1;
(statearr_18117_18179[(1)] = (15));

} else {
var statearr_18118_18180 = state_18097__$1;
(statearr_18118_18180[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18098 === (16))){
var inst_18077 = (state_18097[(11)]);
var state_18097__$1 = state_18097;
var statearr_18119_18181 = state_18097__$1;
(statearr_18119_18181[(2)] = inst_18077);

(statearr_18119_18181[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18098 === (10))){
var inst_18069 = (state_18097[(2)]);
var state_18097__$1 = state_18097;
var statearr_18120_18182 = state_18097__$1;
(statearr_18120_18182[(2)] = inst_18069);

(statearr_18120_18182[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18098 === (18))){
var inst_18080 = (state_18097[(2)]);
var state_18097__$1 = state_18097;
var statearr_18121_18183 = state_18097__$1;
(statearr_18121_18183[(2)] = inst_18080);

(statearr_18121_18183[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18098 === (8))){
var inst_18066 = cljs.core.async.close_BANG_.call(null,to);
var state_18097__$1 = state_18097;
var statearr_18122_18184 = state_18097__$1;
(statearr_18122_18184[(2)] = inst_18066);

(statearr_18122_18184[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto__,jobs,results,process,async))
;
return ((function (switch__9165__auto__,c__9230__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0 = (function (){
var statearr_18126 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18126[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__);

(statearr_18126[(1)] = (1));

return statearr_18126;
});
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1 = (function (state_18097){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_18097);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e18127){if((e18127 instanceof Object)){
var ex__9169__auto__ = e18127;
var statearr_18128_18185 = state_18097;
(statearr_18128_18185[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18097);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18127;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18186 = state_18097;
state_18097 = G__18186;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = function(state_18097){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1.call(this,state_18097);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto__,jobs,results,process,async))
})();
var state__9232__auto__ = (function (){var statearr_18129 = f__9231__auto__.call(null);
(statearr_18129[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto__);

return statearr_18129;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto__,jobs,results,process,async))
);

return c__9230__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args18187 = [];
var len__5627__auto___18190 = arguments.length;
var i__5628__auto___18191 = (0);
while(true){
if((i__5628__auto___18191 < len__5627__auto___18190)){
args18187.push((arguments[i__5628__auto___18191]));

var G__18192 = (i__5628__auto___18191 + (1));
i__5628__auto___18191 = G__18192;
continue;
} else {
}
break;
}

var G__18189 = args18187.length;
switch (G__18189) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18187.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args18194 = [];
var len__5627__auto___18197 = arguments.length;
var i__5628__auto___18198 = (0);
while(true){
if((i__5628__auto___18198 < len__5627__auto___18197)){
args18194.push((arguments[i__5628__auto___18198]));

var G__18199 = (i__5628__auto___18198 + (1));
i__5628__auto___18198 = G__18199;
continue;
} else {
}
break;
}

var G__18196 = args18194.length;
switch (G__18196) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18194.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args18201 = [];
var len__5627__auto___18254 = arguments.length;
var i__5628__auto___18255 = (0);
while(true){
if((i__5628__auto___18255 < len__5627__auto___18254)){
args18201.push((arguments[i__5628__auto___18255]));

var G__18256 = (i__5628__auto___18255 + (1));
i__5628__auto___18255 = G__18256;
continue;
} else {
}
break;
}

var G__18203 = args18201.length;
switch (G__18203) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18201.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__9230__auto___18258 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___18258,tc,fc){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___18258,tc,fc){
return (function (state_18229){
var state_val_18230 = (state_18229[(1)]);
if((state_val_18230 === (7))){
var inst_18225 = (state_18229[(2)]);
var state_18229__$1 = state_18229;
var statearr_18231_18259 = state_18229__$1;
(statearr_18231_18259[(2)] = inst_18225);

(statearr_18231_18259[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18230 === (1))){
var state_18229__$1 = state_18229;
var statearr_18232_18260 = state_18229__$1;
(statearr_18232_18260[(2)] = null);

(statearr_18232_18260[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18230 === (4))){
var inst_18206 = (state_18229[(7)]);
var inst_18206__$1 = (state_18229[(2)]);
var inst_18207 = (inst_18206__$1 == null);
var state_18229__$1 = (function (){var statearr_18233 = state_18229;
(statearr_18233[(7)] = inst_18206__$1);

return statearr_18233;
})();
if(cljs.core.truth_(inst_18207)){
var statearr_18234_18261 = state_18229__$1;
(statearr_18234_18261[(1)] = (5));

} else {
var statearr_18235_18262 = state_18229__$1;
(statearr_18235_18262[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18230 === (13))){
var state_18229__$1 = state_18229;
var statearr_18236_18263 = state_18229__$1;
(statearr_18236_18263[(2)] = null);

(statearr_18236_18263[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18230 === (6))){
var inst_18206 = (state_18229[(7)]);
var inst_18212 = p.call(null,inst_18206);
var state_18229__$1 = state_18229;
if(cljs.core.truth_(inst_18212)){
var statearr_18237_18264 = state_18229__$1;
(statearr_18237_18264[(1)] = (9));

} else {
var statearr_18238_18265 = state_18229__$1;
(statearr_18238_18265[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18230 === (3))){
var inst_18227 = (state_18229[(2)]);
var state_18229__$1 = state_18229;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18229__$1,inst_18227);
} else {
if((state_val_18230 === (12))){
var state_18229__$1 = state_18229;
var statearr_18239_18266 = state_18229__$1;
(statearr_18239_18266[(2)] = null);

(statearr_18239_18266[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18230 === (2))){
var state_18229__$1 = state_18229;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18229__$1,(4),ch);
} else {
if((state_val_18230 === (11))){
var inst_18206 = (state_18229[(7)]);
var inst_18216 = (state_18229[(2)]);
var state_18229__$1 = state_18229;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18229__$1,(8),inst_18216,inst_18206);
} else {
if((state_val_18230 === (9))){
var state_18229__$1 = state_18229;
var statearr_18240_18267 = state_18229__$1;
(statearr_18240_18267[(2)] = tc);

(statearr_18240_18267[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18230 === (5))){
var inst_18209 = cljs.core.async.close_BANG_.call(null,tc);
var inst_18210 = cljs.core.async.close_BANG_.call(null,fc);
var state_18229__$1 = (function (){var statearr_18241 = state_18229;
(statearr_18241[(8)] = inst_18209);

return statearr_18241;
})();
var statearr_18242_18268 = state_18229__$1;
(statearr_18242_18268[(2)] = inst_18210);

(statearr_18242_18268[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18230 === (14))){
var inst_18223 = (state_18229[(2)]);
var state_18229__$1 = state_18229;
var statearr_18243_18269 = state_18229__$1;
(statearr_18243_18269[(2)] = inst_18223);

(statearr_18243_18269[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18230 === (10))){
var state_18229__$1 = state_18229;
var statearr_18244_18270 = state_18229__$1;
(statearr_18244_18270[(2)] = fc);

(statearr_18244_18270[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18230 === (8))){
var inst_18218 = (state_18229[(2)]);
var state_18229__$1 = state_18229;
if(cljs.core.truth_(inst_18218)){
var statearr_18245_18271 = state_18229__$1;
(statearr_18245_18271[(1)] = (12));

} else {
var statearr_18246_18272 = state_18229__$1;
(statearr_18246_18272[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___18258,tc,fc))
;
return ((function (switch__9165__auto__,c__9230__auto___18258,tc,fc){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_18250 = [null,null,null,null,null,null,null,null,null];
(statearr_18250[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_18250[(1)] = (1));

return statearr_18250;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_18229){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_18229);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e18251){if((e18251 instanceof Object)){
var ex__9169__auto__ = e18251;
var statearr_18252_18273 = state_18229;
(statearr_18252_18273[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18229);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18251;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18274 = state_18229;
state_18229 = G__18274;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_18229){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_18229);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___18258,tc,fc))
})();
var state__9232__auto__ = (function (){var statearr_18253 = f__9231__auto__.call(null);
(statearr_18253[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___18258);

return statearr_18253;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___18258,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__9230__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto__){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto__){
return (function (state_18321){
var state_val_18322 = (state_18321[(1)]);
if((state_val_18322 === (1))){
var inst_18307 = init;
var state_18321__$1 = (function (){var statearr_18323 = state_18321;
(statearr_18323[(7)] = inst_18307);

return statearr_18323;
})();
var statearr_18324_18339 = state_18321__$1;
(statearr_18324_18339[(2)] = null);

(statearr_18324_18339[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18322 === (2))){
var state_18321__$1 = state_18321;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18321__$1,(4),ch);
} else {
if((state_val_18322 === (3))){
var inst_18319 = (state_18321[(2)]);
var state_18321__$1 = state_18321;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18321__$1,inst_18319);
} else {
if((state_val_18322 === (4))){
var inst_18310 = (state_18321[(8)]);
var inst_18310__$1 = (state_18321[(2)]);
var inst_18311 = (inst_18310__$1 == null);
var state_18321__$1 = (function (){var statearr_18325 = state_18321;
(statearr_18325[(8)] = inst_18310__$1);

return statearr_18325;
})();
if(cljs.core.truth_(inst_18311)){
var statearr_18326_18340 = state_18321__$1;
(statearr_18326_18340[(1)] = (5));

} else {
var statearr_18327_18341 = state_18321__$1;
(statearr_18327_18341[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18322 === (5))){
var inst_18307 = (state_18321[(7)]);
var state_18321__$1 = state_18321;
var statearr_18328_18342 = state_18321__$1;
(statearr_18328_18342[(2)] = inst_18307);

(statearr_18328_18342[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18322 === (6))){
var inst_18310 = (state_18321[(8)]);
var inst_18307 = (state_18321[(7)]);
var inst_18314 = f.call(null,inst_18307,inst_18310);
var inst_18307__$1 = inst_18314;
var state_18321__$1 = (function (){var statearr_18329 = state_18321;
(statearr_18329[(7)] = inst_18307__$1);

return statearr_18329;
})();
var statearr_18330_18343 = state_18321__$1;
(statearr_18330_18343[(2)] = null);

(statearr_18330_18343[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18322 === (7))){
var inst_18317 = (state_18321[(2)]);
var state_18321__$1 = state_18321;
var statearr_18331_18344 = state_18321__$1;
(statearr_18331_18344[(2)] = inst_18317);

(statearr_18331_18344[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__9230__auto__))
;
return ((function (switch__9165__auto__,c__9230__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__9166__auto__ = null;
var cljs$core$async$reduce_$_state_machine__9166__auto____0 = (function (){
var statearr_18335 = [null,null,null,null,null,null,null,null,null];
(statearr_18335[(0)] = cljs$core$async$reduce_$_state_machine__9166__auto__);

(statearr_18335[(1)] = (1));

return statearr_18335;
});
var cljs$core$async$reduce_$_state_machine__9166__auto____1 = (function (state_18321){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_18321);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e18336){if((e18336 instanceof Object)){
var ex__9169__auto__ = e18336;
var statearr_18337_18345 = state_18321;
(statearr_18337_18345[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18321);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18336;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18346 = state_18321;
state_18321 = G__18346;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__9166__auto__ = function(state_18321){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__9166__auto____1.call(this,state_18321);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__9166__auto____0;
cljs$core$async$reduce_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__9166__auto____1;
return cljs$core$async$reduce_$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto__))
})();
var state__9232__auto__ = (function (){var statearr_18338 = f__9231__auto__.call(null);
(statearr_18338[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto__);

return statearr_18338;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto__))
);

return c__9230__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args18347 = [];
var len__5627__auto___18399 = arguments.length;
var i__5628__auto___18400 = (0);
while(true){
if((i__5628__auto___18400 < len__5627__auto___18399)){
args18347.push((arguments[i__5628__auto___18400]));

var G__18401 = (i__5628__auto___18400 + (1));
i__5628__auto___18400 = G__18401;
continue;
} else {
}
break;
}

var G__18349 = args18347.length;
switch (G__18349) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18347.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__9230__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto__){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto__){
return (function (state_18374){
var state_val_18375 = (state_18374[(1)]);
if((state_val_18375 === (7))){
var inst_18356 = (state_18374[(2)]);
var state_18374__$1 = state_18374;
var statearr_18376_18403 = state_18374__$1;
(statearr_18376_18403[(2)] = inst_18356);

(statearr_18376_18403[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18375 === (1))){
var inst_18350 = cljs.core.seq.call(null,coll);
var inst_18351 = inst_18350;
var state_18374__$1 = (function (){var statearr_18377 = state_18374;
(statearr_18377[(7)] = inst_18351);

return statearr_18377;
})();
var statearr_18378_18404 = state_18374__$1;
(statearr_18378_18404[(2)] = null);

(statearr_18378_18404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18375 === (4))){
var inst_18351 = (state_18374[(7)]);
var inst_18354 = cljs.core.first.call(null,inst_18351);
var state_18374__$1 = state_18374;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18374__$1,(7),ch,inst_18354);
} else {
if((state_val_18375 === (13))){
var inst_18368 = (state_18374[(2)]);
var state_18374__$1 = state_18374;
var statearr_18379_18405 = state_18374__$1;
(statearr_18379_18405[(2)] = inst_18368);

(statearr_18379_18405[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18375 === (6))){
var inst_18359 = (state_18374[(2)]);
var state_18374__$1 = state_18374;
if(cljs.core.truth_(inst_18359)){
var statearr_18380_18406 = state_18374__$1;
(statearr_18380_18406[(1)] = (8));

} else {
var statearr_18381_18407 = state_18374__$1;
(statearr_18381_18407[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18375 === (3))){
var inst_18372 = (state_18374[(2)]);
var state_18374__$1 = state_18374;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18374__$1,inst_18372);
} else {
if((state_val_18375 === (12))){
var state_18374__$1 = state_18374;
var statearr_18382_18408 = state_18374__$1;
(statearr_18382_18408[(2)] = null);

(statearr_18382_18408[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18375 === (2))){
var inst_18351 = (state_18374[(7)]);
var state_18374__$1 = state_18374;
if(cljs.core.truth_(inst_18351)){
var statearr_18383_18409 = state_18374__$1;
(statearr_18383_18409[(1)] = (4));

} else {
var statearr_18384_18410 = state_18374__$1;
(statearr_18384_18410[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18375 === (11))){
var inst_18365 = cljs.core.async.close_BANG_.call(null,ch);
var state_18374__$1 = state_18374;
var statearr_18385_18411 = state_18374__$1;
(statearr_18385_18411[(2)] = inst_18365);

(statearr_18385_18411[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18375 === (9))){
var state_18374__$1 = state_18374;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18386_18412 = state_18374__$1;
(statearr_18386_18412[(1)] = (11));

} else {
var statearr_18387_18413 = state_18374__$1;
(statearr_18387_18413[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18375 === (5))){
var inst_18351 = (state_18374[(7)]);
var state_18374__$1 = state_18374;
var statearr_18388_18414 = state_18374__$1;
(statearr_18388_18414[(2)] = inst_18351);

(statearr_18388_18414[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18375 === (10))){
var inst_18370 = (state_18374[(2)]);
var state_18374__$1 = state_18374;
var statearr_18389_18415 = state_18374__$1;
(statearr_18389_18415[(2)] = inst_18370);

(statearr_18389_18415[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18375 === (8))){
var inst_18351 = (state_18374[(7)]);
var inst_18361 = cljs.core.next.call(null,inst_18351);
var inst_18351__$1 = inst_18361;
var state_18374__$1 = (function (){var statearr_18390 = state_18374;
(statearr_18390[(7)] = inst_18351__$1);

return statearr_18390;
})();
var statearr_18391_18416 = state_18374__$1;
(statearr_18391_18416[(2)] = null);

(statearr_18391_18416[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto__))
;
return ((function (switch__9165__auto__,c__9230__auto__){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_18395 = [null,null,null,null,null,null,null,null];
(statearr_18395[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_18395[(1)] = (1));

return statearr_18395;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_18374){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_18374);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e18396){if((e18396 instanceof Object)){
var ex__9169__auto__ = e18396;
var statearr_18397_18417 = state_18374;
(statearr_18397_18417[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18374);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18396;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18418 = state_18374;
state_18374 = G__18418;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_18374){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_18374);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto__))
})();
var state__9232__auto__ = (function (){var statearr_18398 = f__9231__auto__.call(null);
(statearr_18398[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto__);

return statearr_18398;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto__))
);

return c__9230__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5224__auto__ = (((_ == null))?null:_);
var m__5225__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,_);
} else {
var m__5225__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5225__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m);
} else {
var m__5225__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18640 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18640 = (function (mult,ch,cs,meta18641){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta18641 = meta18641;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18640.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_18642,meta18641__$1){
var self__ = this;
var _18642__$1 = this;
return (new cljs.core.async.t_cljs$core$async18640(self__.mult,self__.ch,self__.cs,meta18641__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async18640.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_18642){
var self__ = this;
var _18642__$1 = this;
return self__.meta18641;
});})(cs))
;

cljs.core.async.t_cljs$core$async18640.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18640.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async18640.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async18640.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18640.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18640.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18640.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta18641","meta18641",1239110015,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async18640.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18640.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18640";

cljs.core.async.t_cljs$core$async18640.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async18640");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async18640 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async18640(mult__$1,ch__$1,cs__$1,meta18641){
return (new cljs.core.async.t_cljs$core$async18640(mult__$1,ch__$1,cs__$1,meta18641));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async18640(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__9230__auto___18861 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___18861,cs,m,dchan,dctr,done){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___18861,cs,m,dchan,dctr,done){
return (function (state_18773){
var state_val_18774 = (state_18773[(1)]);
if((state_val_18774 === (7))){
var inst_18769 = (state_18773[(2)]);
var state_18773__$1 = state_18773;
var statearr_18775_18862 = state_18773__$1;
(statearr_18775_18862[(2)] = inst_18769);

(statearr_18775_18862[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (20))){
var inst_18674 = (state_18773[(7)]);
var inst_18684 = cljs.core.first.call(null,inst_18674);
var inst_18685 = cljs.core.nth.call(null,inst_18684,(0),null);
var inst_18686 = cljs.core.nth.call(null,inst_18684,(1),null);
var state_18773__$1 = (function (){var statearr_18776 = state_18773;
(statearr_18776[(8)] = inst_18685);

return statearr_18776;
})();
if(cljs.core.truth_(inst_18686)){
var statearr_18777_18863 = state_18773__$1;
(statearr_18777_18863[(1)] = (22));

} else {
var statearr_18778_18864 = state_18773__$1;
(statearr_18778_18864[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (27))){
var inst_18716 = (state_18773[(9)]);
var inst_18714 = (state_18773[(10)]);
var inst_18721 = (state_18773[(11)]);
var inst_18645 = (state_18773[(12)]);
var inst_18721__$1 = cljs.core._nth.call(null,inst_18714,inst_18716);
var inst_18722 = cljs.core.async.put_BANG_.call(null,inst_18721__$1,inst_18645,done);
var state_18773__$1 = (function (){var statearr_18779 = state_18773;
(statearr_18779[(11)] = inst_18721__$1);

return statearr_18779;
})();
if(cljs.core.truth_(inst_18722)){
var statearr_18780_18865 = state_18773__$1;
(statearr_18780_18865[(1)] = (30));

} else {
var statearr_18781_18866 = state_18773__$1;
(statearr_18781_18866[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (1))){
var state_18773__$1 = state_18773;
var statearr_18782_18867 = state_18773__$1;
(statearr_18782_18867[(2)] = null);

(statearr_18782_18867[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (24))){
var inst_18674 = (state_18773[(7)]);
var inst_18691 = (state_18773[(2)]);
var inst_18692 = cljs.core.next.call(null,inst_18674);
var inst_18654 = inst_18692;
var inst_18655 = null;
var inst_18656 = (0);
var inst_18657 = (0);
var state_18773__$1 = (function (){var statearr_18783 = state_18773;
(statearr_18783[(13)] = inst_18657);

(statearr_18783[(14)] = inst_18691);

(statearr_18783[(15)] = inst_18655);

(statearr_18783[(16)] = inst_18654);

(statearr_18783[(17)] = inst_18656);

return statearr_18783;
})();
var statearr_18784_18868 = state_18773__$1;
(statearr_18784_18868[(2)] = null);

(statearr_18784_18868[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (39))){
var state_18773__$1 = state_18773;
var statearr_18788_18869 = state_18773__$1;
(statearr_18788_18869[(2)] = null);

(statearr_18788_18869[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (4))){
var inst_18645 = (state_18773[(12)]);
var inst_18645__$1 = (state_18773[(2)]);
var inst_18646 = (inst_18645__$1 == null);
var state_18773__$1 = (function (){var statearr_18789 = state_18773;
(statearr_18789[(12)] = inst_18645__$1);

return statearr_18789;
})();
if(cljs.core.truth_(inst_18646)){
var statearr_18790_18870 = state_18773__$1;
(statearr_18790_18870[(1)] = (5));

} else {
var statearr_18791_18871 = state_18773__$1;
(statearr_18791_18871[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (15))){
var inst_18657 = (state_18773[(13)]);
var inst_18655 = (state_18773[(15)]);
var inst_18654 = (state_18773[(16)]);
var inst_18656 = (state_18773[(17)]);
var inst_18670 = (state_18773[(2)]);
var inst_18671 = (inst_18657 + (1));
var tmp18785 = inst_18655;
var tmp18786 = inst_18654;
var tmp18787 = inst_18656;
var inst_18654__$1 = tmp18786;
var inst_18655__$1 = tmp18785;
var inst_18656__$1 = tmp18787;
var inst_18657__$1 = inst_18671;
var state_18773__$1 = (function (){var statearr_18792 = state_18773;
(statearr_18792[(13)] = inst_18657__$1);

(statearr_18792[(15)] = inst_18655__$1);

(statearr_18792[(16)] = inst_18654__$1);

(statearr_18792[(18)] = inst_18670);

(statearr_18792[(17)] = inst_18656__$1);

return statearr_18792;
})();
var statearr_18793_18872 = state_18773__$1;
(statearr_18793_18872[(2)] = null);

(statearr_18793_18872[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (21))){
var inst_18695 = (state_18773[(2)]);
var state_18773__$1 = state_18773;
var statearr_18797_18873 = state_18773__$1;
(statearr_18797_18873[(2)] = inst_18695);

(statearr_18797_18873[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (31))){
var inst_18721 = (state_18773[(11)]);
var inst_18725 = done.call(null,null);
var inst_18726 = cljs.core.async.untap_STAR_.call(null,m,inst_18721);
var state_18773__$1 = (function (){var statearr_18798 = state_18773;
(statearr_18798[(19)] = inst_18725);

return statearr_18798;
})();
var statearr_18799_18874 = state_18773__$1;
(statearr_18799_18874[(2)] = inst_18726);

(statearr_18799_18874[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (32))){
var inst_18716 = (state_18773[(9)]);
var inst_18714 = (state_18773[(10)]);
var inst_18713 = (state_18773[(20)]);
var inst_18715 = (state_18773[(21)]);
var inst_18728 = (state_18773[(2)]);
var inst_18729 = (inst_18716 + (1));
var tmp18794 = inst_18714;
var tmp18795 = inst_18713;
var tmp18796 = inst_18715;
var inst_18713__$1 = tmp18795;
var inst_18714__$1 = tmp18794;
var inst_18715__$1 = tmp18796;
var inst_18716__$1 = inst_18729;
var state_18773__$1 = (function (){var statearr_18800 = state_18773;
(statearr_18800[(9)] = inst_18716__$1);

(statearr_18800[(10)] = inst_18714__$1);

(statearr_18800[(22)] = inst_18728);

(statearr_18800[(20)] = inst_18713__$1);

(statearr_18800[(21)] = inst_18715__$1);

return statearr_18800;
})();
var statearr_18801_18875 = state_18773__$1;
(statearr_18801_18875[(2)] = null);

(statearr_18801_18875[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (40))){
var inst_18741 = (state_18773[(23)]);
var inst_18745 = done.call(null,null);
var inst_18746 = cljs.core.async.untap_STAR_.call(null,m,inst_18741);
var state_18773__$1 = (function (){var statearr_18802 = state_18773;
(statearr_18802[(24)] = inst_18745);

return statearr_18802;
})();
var statearr_18803_18876 = state_18773__$1;
(statearr_18803_18876[(2)] = inst_18746);

(statearr_18803_18876[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (33))){
var inst_18732 = (state_18773[(25)]);
var inst_18734 = cljs.core.chunked_seq_QMARK_.call(null,inst_18732);
var state_18773__$1 = state_18773;
if(inst_18734){
var statearr_18804_18877 = state_18773__$1;
(statearr_18804_18877[(1)] = (36));

} else {
var statearr_18805_18878 = state_18773__$1;
(statearr_18805_18878[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (13))){
var inst_18664 = (state_18773[(26)]);
var inst_18667 = cljs.core.async.close_BANG_.call(null,inst_18664);
var state_18773__$1 = state_18773;
var statearr_18806_18879 = state_18773__$1;
(statearr_18806_18879[(2)] = inst_18667);

(statearr_18806_18879[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (22))){
var inst_18685 = (state_18773[(8)]);
var inst_18688 = cljs.core.async.close_BANG_.call(null,inst_18685);
var state_18773__$1 = state_18773;
var statearr_18807_18880 = state_18773__$1;
(statearr_18807_18880[(2)] = inst_18688);

(statearr_18807_18880[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (36))){
var inst_18732 = (state_18773[(25)]);
var inst_18736 = cljs.core.chunk_first.call(null,inst_18732);
var inst_18737 = cljs.core.chunk_rest.call(null,inst_18732);
var inst_18738 = cljs.core.count.call(null,inst_18736);
var inst_18713 = inst_18737;
var inst_18714 = inst_18736;
var inst_18715 = inst_18738;
var inst_18716 = (0);
var state_18773__$1 = (function (){var statearr_18808 = state_18773;
(statearr_18808[(9)] = inst_18716);

(statearr_18808[(10)] = inst_18714);

(statearr_18808[(20)] = inst_18713);

(statearr_18808[(21)] = inst_18715);

return statearr_18808;
})();
var statearr_18809_18881 = state_18773__$1;
(statearr_18809_18881[(2)] = null);

(statearr_18809_18881[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (41))){
var inst_18732 = (state_18773[(25)]);
var inst_18748 = (state_18773[(2)]);
var inst_18749 = cljs.core.next.call(null,inst_18732);
var inst_18713 = inst_18749;
var inst_18714 = null;
var inst_18715 = (0);
var inst_18716 = (0);
var state_18773__$1 = (function (){var statearr_18810 = state_18773;
(statearr_18810[(9)] = inst_18716);

(statearr_18810[(10)] = inst_18714);

(statearr_18810[(20)] = inst_18713);

(statearr_18810[(21)] = inst_18715);

(statearr_18810[(27)] = inst_18748);

return statearr_18810;
})();
var statearr_18811_18882 = state_18773__$1;
(statearr_18811_18882[(2)] = null);

(statearr_18811_18882[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (43))){
var state_18773__$1 = state_18773;
var statearr_18812_18883 = state_18773__$1;
(statearr_18812_18883[(2)] = null);

(statearr_18812_18883[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (29))){
var inst_18757 = (state_18773[(2)]);
var state_18773__$1 = state_18773;
var statearr_18813_18884 = state_18773__$1;
(statearr_18813_18884[(2)] = inst_18757);

(statearr_18813_18884[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (44))){
var inst_18766 = (state_18773[(2)]);
var state_18773__$1 = (function (){var statearr_18814 = state_18773;
(statearr_18814[(28)] = inst_18766);

return statearr_18814;
})();
var statearr_18815_18885 = state_18773__$1;
(statearr_18815_18885[(2)] = null);

(statearr_18815_18885[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (6))){
var inst_18705 = (state_18773[(29)]);
var inst_18704 = cljs.core.deref.call(null,cs);
var inst_18705__$1 = cljs.core.keys.call(null,inst_18704);
var inst_18706 = cljs.core.count.call(null,inst_18705__$1);
var inst_18707 = cljs.core.reset_BANG_.call(null,dctr,inst_18706);
var inst_18712 = cljs.core.seq.call(null,inst_18705__$1);
var inst_18713 = inst_18712;
var inst_18714 = null;
var inst_18715 = (0);
var inst_18716 = (0);
var state_18773__$1 = (function (){var statearr_18816 = state_18773;
(statearr_18816[(9)] = inst_18716);

(statearr_18816[(10)] = inst_18714);

(statearr_18816[(20)] = inst_18713);

(statearr_18816[(30)] = inst_18707);

(statearr_18816[(21)] = inst_18715);

(statearr_18816[(29)] = inst_18705__$1);

return statearr_18816;
})();
var statearr_18817_18886 = state_18773__$1;
(statearr_18817_18886[(2)] = null);

(statearr_18817_18886[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (28))){
var inst_18713 = (state_18773[(20)]);
var inst_18732 = (state_18773[(25)]);
var inst_18732__$1 = cljs.core.seq.call(null,inst_18713);
var state_18773__$1 = (function (){var statearr_18818 = state_18773;
(statearr_18818[(25)] = inst_18732__$1);

return statearr_18818;
})();
if(inst_18732__$1){
var statearr_18819_18887 = state_18773__$1;
(statearr_18819_18887[(1)] = (33));

} else {
var statearr_18820_18888 = state_18773__$1;
(statearr_18820_18888[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (25))){
var inst_18716 = (state_18773[(9)]);
var inst_18715 = (state_18773[(21)]);
var inst_18718 = (inst_18716 < inst_18715);
var inst_18719 = inst_18718;
var state_18773__$1 = state_18773;
if(cljs.core.truth_(inst_18719)){
var statearr_18821_18889 = state_18773__$1;
(statearr_18821_18889[(1)] = (27));

} else {
var statearr_18822_18890 = state_18773__$1;
(statearr_18822_18890[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (34))){
var state_18773__$1 = state_18773;
var statearr_18823_18891 = state_18773__$1;
(statearr_18823_18891[(2)] = null);

(statearr_18823_18891[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (17))){
var state_18773__$1 = state_18773;
var statearr_18824_18892 = state_18773__$1;
(statearr_18824_18892[(2)] = null);

(statearr_18824_18892[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (3))){
var inst_18771 = (state_18773[(2)]);
var state_18773__$1 = state_18773;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18773__$1,inst_18771);
} else {
if((state_val_18774 === (12))){
var inst_18700 = (state_18773[(2)]);
var state_18773__$1 = state_18773;
var statearr_18825_18893 = state_18773__$1;
(statearr_18825_18893[(2)] = inst_18700);

(statearr_18825_18893[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (2))){
var state_18773__$1 = state_18773;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18773__$1,(4),ch);
} else {
if((state_val_18774 === (23))){
var state_18773__$1 = state_18773;
var statearr_18826_18894 = state_18773__$1;
(statearr_18826_18894[(2)] = null);

(statearr_18826_18894[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (35))){
var inst_18755 = (state_18773[(2)]);
var state_18773__$1 = state_18773;
var statearr_18827_18895 = state_18773__$1;
(statearr_18827_18895[(2)] = inst_18755);

(statearr_18827_18895[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (19))){
var inst_18674 = (state_18773[(7)]);
var inst_18678 = cljs.core.chunk_first.call(null,inst_18674);
var inst_18679 = cljs.core.chunk_rest.call(null,inst_18674);
var inst_18680 = cljs.core.count.call(null,inst_18678);
var inst_18654 = inst_18679;
var inst_18655 = inst_18678;
var inst_18656 = inst_18680;
var inst_18657 = (0);
var state_18773__$1 = (function (){var statearr_18828 = state_18773;
(statearr_18828[(13)] = inst_18657);

(statearr_18828[(15)] = inst_18655);

(statearr_18828[(16)] = inst_18654);

(statearr_18828[(17)] = inst_18656);

return statearr_18828;
})();
var statearr_18829_18896 = state_18773__$1;
(statearr_18829_18896[(2)] = null);

(statearr_18829_18896[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (11))){
var inst_18674 = (state_18773[(7)]);
var inst_18654 = (state_18773[(16)]);
var inst_18674__$1 = cljs.core.seq.call(null,inst_18654);
var state_18773__$1 = (function (){var statearr_18830 = state_18773;
(statearr_18830[(7)] = inst_18674__$1);

return statearr_18830;
})();
if(inst_18674__$1){
var statearr_18831_18897 = state_18773__$1;
(statearr_18831_18897[(1)] = (16));

} else {
var statearr_18832_18898 = state_18773__$1;
(statearr_18832_18898[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (9))){
var inst_18702 = (state_18773[(2)]);
var state_18773__$1 = state_18773;
var statearr_18833_18899 = state_18773__$1;
(statearr_18833_18899[(2)] = inst_18702);

(statearr_18833_18899[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (5))){
var inst_18652 = cljs.core.deref.call(null,cs);
var inst_18653 = cljs.core.seq.call(null,inst_18652);
var inst_18654 = inst_18653;
var inst_18655 = null;
var inst_18656 = (0);
var inst_18657 = (0);
var state_18773__$1 = (function (){var statearr_18834 = state_18773;
(statearr_18834[(13)] = inst_18657);

(statearr_18834[(15)] = inst_18655);

(statearr_18834[(16)] = inst_18654);

(statearr_18834[(17)] = inst_18656);

return statearr_18834;
})();
var statearr_18835_18900 = state_18773__$1;
(statearr_18835_18900[(2)] = null);

(statearr_18835_18900[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (14))){
var state_18773__$1 = state_18773;
var statearr_18836_18901 = state_18773__$1;
(statearr_18836_18901[(2)] = null);

(statearr_18836_18901[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (45))){
var inst_18763 = (state_18773[(2)]);
var state_18773__$1 = state_18773;
var statearr_18837_18902 = state_18773__$1;
(statearr_18837_18902[(2)] = inst_18763);

(statearr_18837_18902[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (26))){
var inst_18705 = (state_18773[(29)]);
var inst_18759 = (state_18773[(2)]);
var inst_18760 = cljs.core.seq.call(null,inst_18705);
var state_18773__$1 = (function (){var statearr_18838 = state_18773;
(statearr_18838[(31)] = inst_18759);

return statearr_18838;
})();
if(inst_18760){
var statearr_18839_18903 = state_18773__$1;
(statearr_18839_18903[(1)] = (42));

} else {
var statearr_18840_18904 = state_18773__$1;
(statearr_18840_18904[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (16))){
var inst_18674 = (state_18773[(7)]);
var inst_18676 = cljs.core.chunked_seq_QMARK_.call(null,inst_18674);
var state_18773__$1 = state_18773;
if(inst_18676){
var statearr_18841_18905 = state_18773__$1;
(statearr_18841_18905[(1)] = (19));

} else {
var statearr_18842_18906 = state_18773__$1;
(statearr_18842_18906[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (38))){
var inst_18752 = (state_18773[(2)]);
var state_18773__$1 = state_18773;
var statearr_18843_18907 = state_18773__$1;
(statearr_18843_18907[(2)] = inst_18752);

(statearr_18843_18907[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (30))){
var state_18773__$1 = state_18773;
var statearr_18844_18908 = state_18773__$1;
(statearr_18844_18908[(2)] = null);

(statearr_18844_18908[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (10))){
var inst_18657 = (state_18773[(13)]);
var inst_18655 = (state_18773[(15)]);
var inst_18663 = cljs.core._nth.call(null,inst_18655,inst_18657);
var inst_18664 = cljs.core.nth.call(null,inst_18663,(0),null);
var inst_18665 = cljs.core.nth.call(null,inst_18663,(1),null);
var state_18773__$1 = (function (){var statearr_18845 = state_18773;
(statearr_18845[(26)] = inst_18664);

return statearr_18845;
})();
if(cljs.core.truth_(inst_18665)){
var statearr_18846_18909 = state_18773__$1;
(statearr_18846_18909[(1)] = (13));

} else {
var statearr_18847_18910 = state_18773__$1;
(statearr_18847_18910[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (18))){
var inst_18698 = (state_18773[(2)]);
var state_18773__$1 = state_18773;
var statearr_18848_18911 = state_18773__$1;
(statearr_18848_18911[(2)] = inst_18698);

(statearr_18848_18911[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (42))){
var state_18773__$1 = state_18773;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18773__$1,(45),dchan);
} else {
if((state_val_18774 === (37))){
var inst_18741 = (state_18773[(23)]);
var inst_18732 = (state_18773[(25)]);
var inst_18645 = (state_18773[(12)]);
var inst_18741__$1 = cljs.core.first.call(null,inst_18732);
var inst_18742 = cljs.core.async.put_BANG_.call(null,inst_18741__$1,inst_18645,done);
var state_18773__$1 = (function (){var statearr_18849 = state_18773;
(statearr_18849[(23)] = inst_18741__$1);

return statearr_18849;
})();
if(cljs.core.truth_(inst_18742)){
var statearr_18850_18912 = state_18773__$1;
(statearr_18850_18912[(1)] = (39));

} else {
var statearr_18851_18913 = state_18773__$1;
(statearr_18851_18913[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18774 === (8))){
var inst_18657 = (state_18773[(13)]);
var inst_18656 = (state_18773[(17)]);
var inst_18659 = (inst_18657 < inst_18656);
var inst_18660 = inst_18659;
var state_18773__$1 = state_18773;
if(cljs.core.truth_(inst_18660)){
var statearr_18852_18914 = state_18773__$1;
(statearr_18852_18914[(1)] = (10));

} else {
var statearr_18853_18915 = state_18773__$1;
(statearr_18853_18915[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___18861,cs,m,dchan,dctr,done))
;
return ((function (switch__9165__auto__,c__9230__auto___18861,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__9166__auto__ = null;
var cljs$core$async$mult_$_state_machine__9166__auto____0 = (function (){
var statearr_18857 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18857[(0)] = cljs$core$async$mult_$_state_machine__9166__auto__);

(statearr_18857[(1)] = (1));

return statearr_18857;
});
var cljs$core$async$mult_$_state_machine__9166__auto____1 = (function (state_18773){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_18773);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e18858){if((e18858 instanceof Object)){
var ex__9169__auto__ = e18858;
var statearr_18859_18916 = state_18773;
(statearr_18859_18916[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18773);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18858;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18917 = state_18773;
state_18773 = G__18917;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__9166__auto__ = function(state_18773){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__9166__auto____1.call(this,state_18773);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__9166__auto____0;
cljs$core$async$mult_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__9166__auto____1;
return cljs$core$async$mult_$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___18861,cs,m,dchan,dctr,done))
})();
var state__9232__auto__ = (function (){var statearr_18860 = f__9231__auto__.call(null);
(statearr_18860[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___18861);

return statearr_18860;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___18861,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args18918 = [];
var len__5627__auto___18921 = arguments.length;
var i__5628__auto___18922 = (0);
while(true){
if((i__5628__auto___18922 < len__5627__auto___18921)){
args18918.push((arguments[i__5628__auto___18922]));

var G__18923 = (i__5628__auto___18922 + (1));
i__5628__auto___18922 = G__18923;
continue;
} else {
}
break;
}

var G__18920 = args18918.length;
switch (G__18920) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18918.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m);
} else {
var m__5225__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,state_map);
} else {
var m__5225__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,mode);
} else {
var m__5225__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___18935 = arguments.length;
var i__5628__auto___18936 = (0);
while(true){
if((i__5628__auto___18936 < len__5627__auto___18935)){
args__5634__auto__.push((arguments[i__5628__auto___18936]));

var G__18937 = (i__5628__auto___18936 + (1));
i__5628__auto___18936 = G__18937;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((3) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5635__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__18929){
var map__18930 = p__18929;
var map__18930__$1 = ((((!((map__18930 == null)))?((((map__18930.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18930.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18930):map__18930);
var opts = map__18930__$1;
var statearr_18932_18938 = state;
(statearr_18932_18938[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__18930,map__18930__$1,opts){
return (function (val){
var statearr_18933_18939 = state;
(statearr_18933_18939[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__18930,map__18930__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_18934_18940 = state;
(statearr_18934_18940[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq18925){
var G__18926 = cljs.core.first.call(null,seq18925);
var seq18925__$1 = cljs.core.next.call(null,seq18925);
var G__18927 = cljs.core.first.call(null,seq18925__$1);
var seq18925__$2 = cljs.core.next.call(null,seq18925__$1);
var G__18928 = cljs.core.first.call(null,seq18925__$2);
var seq18925__$3 = cljs.core.next.call(null,seq18925__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18926,G__18927,G__18928,seq18925__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async19104 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19104 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta19105){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta19105 = meta19105;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19104.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_19106,meta19105__$1){
var self__ = this;
var _19106__$1 = this;
return (new cljs.core.async.t_cljs$core$async19104(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta19105__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19104.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_19106){
var self__ = this;
var _19106__$1 = this;
return self__.meta19105;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19104.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19104.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19104.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async19104.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19104.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19104.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19104.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19104.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19104.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta19105","meta19105",-1128344699,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19104.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19104.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19104";

cljs.core.async.t_cljs$core$async19104.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async19104");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async19104 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async19104(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta19105){
return (new cljs.core.async.t_cljs$core$async19104(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta19105));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async19104(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__9230__auto___19267 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___19267,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___19267,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_19204){
var state_val_19205 = (state_19204[(1)]);
if((state_val_19205 === (7))){
var inst_19122 = (state_19204[(2)]);
var state_19204__$1 = state_19204;
var statearr_19206_19268 = state_19204__$1;
(statearr_19206_19268[(2)] = inst_19122);

(statearr_19206_19268[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (20))){
var inst_19134 = (state_19204[(7)]);
var state_19204__$1 = state_19204;
var statearr_19207_19269 = state_19204__$1;
(statearr_19207_19269[(2)] = inst_19134);

(statearr_19207_19269[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (27))){
var state_19204__$1 = state_19204;
var statearr_19208_19270 = state_19204__$1;
(statearr_19208_19270[(2)] = null);

(statearr_19208_19270[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (1))){
var inst_19110 = (state_19204[(8)]);
var inst_19110__$1 = calc_state.call(null);
var inst_19112 = (inst_19110__$1 == null);
var inst_19113 = cljs.core.not.call(null,inst_19112);
var state_19204__$1 = (function (){var statearr_19209 = state_19204;
(statearr_19209[(8)] = inst_19110__$1);

return statearr_19209;
})();
if(inst_19113){
var statearr_19210_19271 = state_19204__$1;
(statearr_19210_19271[(1)] = (2));

} else {
var statearr_19211_19272 = state_19204__$1;
(statearr_19211_19272[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (24))){
var inst_19157 = (state_19204[(9)]);
var inst_19178 = (state_19204[(10)]);
var inst_19164 = (state_19204[(11)]);
var inst_19178__$1 = inst_19157.call(null,inst_19164);
var state_19204__$1 = (function (){var statearr_19212 = state_19204;
(statearr_19212[(10)] = inst_19178__$1);

return statearr_19212;
})();
if(cljs.core.truth_(inst_19178__$1)){
var statearr_19213_19273 = state_19204__$1;
(statearr_19213_19273[(1)] = (29));

} else {
var statearr_19214_19274 = state_19204__$1;
(statearr_19214_19274[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (4))){
var inst_19125 = (state_19204[(2)]);
var state_19204__$1 = state_19204;
if(cljs.core.truth_(inst_19125)){
var statearr_19215_19275 = state_19204__$1;
(statearr_19215_19275[(1)] = (8));

} else {
var statearr_19216_19276 = state_19204__$1;
(statearr_19216_19276[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (15))){
var inst_19151 = (state_19204[(2)]);
var state_19204__$1 = state_19204;
if(cljs.core.truth_(inst_19151)){
var statearr_19217_19277 = state_19204__$1;
(statearr_19217_19277[(1)] = (19));

} else {
var statearr_19218_19278 = state_19204__$1;
(statearr_19218_19278[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (21))){
var inst_19156 = (state_19204[(12)]);
var inst_19156__$1 = (state_19204[(2)]);
var inst_19157 = cljs.core.get.call(null,inst_19156__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_19158 = cljs.core.get.call(null,inst_19156__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_19159 = cljs.core.get.call(null,inst_19156__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_19204__$1 = (function (){var statearr_19219 = state_19204;
(statearr_19219[(9)] = inst_19157);

(statearr_19219[(13)] = inst_19158);

(statearr_19219[(12)] = inst_19156__$1);

return statearr_19219;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_19204__$1,(22),inst_19159);
} else {
if((state_val_19205 === (31))){
var inst_19186 = (state_19204[(2)]);
var state_19204__$1 = state_19204;
if(cljs.core.truth_(inst_19186)){
var statearr_19220_19279 = state_19204__$1;
(statearr_19220_19279[(1)] = (32));

} else {
var statearr_19221_19280 = state_19204__$1;
(statearr_19221_19280[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (32))){
var inst_19163 = (state_19204[(14)]);
var state_19204__$1 = state_19204;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19204__$1,(35),out,inst_19163);
} else {
if((state_val_19205 === (33))){
var inst_19156 = (state_19204[(12)]);
var inst_19134 = inst_19156;
var state_19204__$1 = (function (){var statearr_19222 = state_19204;
(statearr_19222[(7)] = inst_19134);

return statearr_19222;
})();
var statearr_19223_19281 = state_19204__$1;
(statearr_19223_19281[(2)] = null);

(statearr_19223_19281[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (13))){
var inst_19134 = (state_19204[(7)]);
var inst_19141 = inst_19134.cljs$lang$protocol_mask$partition0$;
var inst_19142 = (inst_19141 & (64));
var inst_19143 = inst_19134.cljs$core$ISeq$;
var inst_19144 = (inst_19142) || (inst_19143);
var state_19204__$1 = state_19204;
if(cljs.core.truth_(inst_19144)){
var statearr_19224_19282 = state_19204__$1;
(statearr_19224_19282[(1)] = (16));

} else {
var statearr_19225_19283 = state_19204__$1;
(statearr_19225_19283[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (22))){
var inst_19164 = (state_19204[(11)]);
var inst_19163 = (state_19204[(14)]);
var inst_19162 = (state_19204[(2)]);
var inst_19163__$1 = cljs.core.nth.call(null,inst_19162,(0),null);
var inst_19164__$1 = cljs.core.nth.call(null,inst_19162,(1),null);
var inst_19165 = (inst_19163__$1 == null);
var inst_19166 = cljs.core._EQ_.call(null,inst_19164__$1,change);
var inst_19167 = (inst_19165) || (inst_19166);
var state_19204__$1 = (function (){var statearr_19226 = state_19204;
(statearr_19226[(11)] = inst_19164__$1);

(statearr_19226[(14)] = inst_19163__$1);

return statearr_19226;
})();
if(cljs.core.truth_(inst_19167)){
var statearr_19227_19284 = state_19204__$1;
(statearr_19227_19284[(1)] = (23));

} else {
var statearr_19228_19285 = state_19204__$1;
(statearr_19228_19285[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (36))){
var inst_19156 = (state_19204[(12)]);
var inst_19134 = inst_19156;
var state_19204__$1 = (function (){var statearr_19229 = state_19204;
(statearr_19229[(7)] = inst_19134);

return statearr_19229;
})();
var statearr_19230_19286 = state_19204__$1;
(statearr_19230_19286[(2)] = null);

(statearr_19230_19286[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (29))){
var inst_19178 = (state_19204[(10)]);
var state_19204__$1 = state_19204;
var statearr_19231_19287 = state_19204__$1;
(statearr_19231_19287[(2)] = inst_19178);

(statearr_19231_19287[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (6))){
var state_19204__$1 = state_19204;
var statearr_19232_19288 = state_19204__$1;
(statearr_19232_19288[(2)] = false);

(statearr_19232_19288[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (28))){
var inst_19174 = (state_19204[(2)]);
var inst_19175 = calc_state.call(null);
var inst_19134 = inst_19175;
var state_19204__$1 = (function (){var statearr_19233 = state_19204;
(statearr_19233[(7)] = inst_19134);

(statearr_19233[(15)] = inst_19174);

return statearr_19233;
})();
var statearr_19234_19289 = state_19204__$1;
(statearr_19234_19289[(2)] = null);

(statearr_19234_19289[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (25))){
var inst_19200 = (state_19204[(2)]);
var state_19204__$1 = state_19204;
var statearr_19235_19290 = state_19204__$1;
(statearr_19235_19290[(2)] = inst_19200);

(statearr_19235_19290[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (34))){
var inst_19198 = (state_19204[(2)]);
var state_19204__$1 = state_19204;
var statearr_19236_19291 = state_19204__$1;
(statearr_19236_19291[(2)] = inst_19198);

(statearr_19236_19291[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (17))){
var state_19204__$1 = state_19204;
var statearr_19237_19292 = state_19204__$1;
(statearr_19237_19292[(2)] = false);

(statearr_19237_19292[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (3))){
var state_19204__$1 = state_19204;
var statearr_19238_19293 = state_19204__$1;
(statearr_19238_19293[(2)] = false);

(statearr_19238_19293[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (12))){
var inst_19202 = (state_19204[(2)]);
var state_19204__$1 = state_19204;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19204__$1,inst_19202);
} else {
if((state_val_19205 === (2))){
var inst_19110 = (state_19204[(8)]);
var inst_19115 = inst_19110.cljs$lang$protocol_mask$partition0$;
var inst_19116 = (inst_19115 & (64));
var inst_19117 = inst_19110.cljs$core$ISeq$;
var inst_19118 = (inst_19116) || (inst_19117);
var state_19204__$1 = state_19204;
if(cljs.core.truth_(inst_19118)){
var statearr_19239_19294 = state_19204__$1;
(statearr_19239_19294[(1)] = (5));

} else {
var statearr_19240_19295 = state_19204__$1;
(statearr_19240_19295[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (23))){
var inst_19163 = (state_19204[(14)]);
var inst_19169 = (inst_19163 == null);
var state_19204__$1 = state_19204;
if(cljs.core.truth_(inst_19169)){
var statearr_19241_19296 = state_19204__$1;
(statearr_19241_19296[(1)] = (26));

} else {
var statearr_19242_19297 = state_19204__$1;
(statearr_19242_19297[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (35))){
var inst_19189 = (state_19204[(2)]);
var state_19204__$1 = state_19204;
if(cljs.core.truth_(inst_19189)){
var statearr_19243_19298 = state_19204__$1;
(statearr_19243_19298[(1)] = (36));

} else {
var statearr_19244_19299 = state_19204__$1;
(statearr_19244_19299[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (19))){
var inst_19134 = (state_19204[(7)]);
var inst_19153 = cljs.core.apply.call(null,cljs.core.hash_map,inst_19134);
var state_19204__$1 = state_19204;
var statearr_19245_19300 = state_19204__$1;
(statearr_19245_19300[(2)] = inst_19153);

(statearr_19245_19300[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (11))){
var inst_19134 = (state_19204[(7)]);
var inst_19138 = (inst_19134 == null);
var inst_19139 = cljs.core.not.call(null,inst_19138);
var state_19204__$1 = state_19204;
if(inst_19139){
var statearr_19246_19301 = state_19204__$1;
(statearr_19246_19301[(1)] = (13));

} else {
var statearr_19247_19302 = state_19204__$1;
(statearr_19247_19302[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (9))){
var inst_19110 = (state_19204[(8)]);
var state_19204__$1 = state_19204;
var statearr_19248_19303 = state_19204__$1;
(statearr_19248_19303[(2)] = inst_19110);

(statearr_19248_19303[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (5))){
var state_19204__$1 = state_19204;
var statearr_19249_19304 = state_19204__$1;
(statearr_19249_19304[(2)] = true);

(statearr_19249_19304[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (14))){
var state_19204__$1 = state_19204;
var statearr_19250_19305 = state_19204__$1;
(statearr_19250_19305[(2)] = false);

(statearr_19250_19305[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (26))){
var inst_19164 = (state_19204[(11)]);
var inst_19171 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_19164);
var state_19204__$1 = state_19204;
var statearr_19251_19306 = state_19204__$1;
(statearr_19251_19306[(2)] = inst_19171);

(statearr_19251_19306[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (16))){
var state_19204__$1 = state_19204;
var statearr_19252_19307 = state_19204__$1;
(statearr_19252_19307[(2)] = true);

(statearr_19252_19307[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (38))){
var inst_19194 = (state_19204[(2)]);
var state_19204__$1 = state_19204;
var statearr_19253_19308 = state_19204__$1;
(statearr_19253_19308[(2)] = inst_19194);

(statearr_19253_19308[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (30))){
var inst_19157 = (state_19204[(9)]);
var inst_19164 = (state_19204[(11)]);
var inst_19158 = (state_19204[(13)]);
var inst_19181 = cljs.core.empty_QMARK_.call(null,inst_19157);
var inst_19182 = inst_19158.call(null,inst_19164);
var inst_19183 = cljs.core.not.call(null,inst_19182);
var inst_19184 = (inst_19181) && (inst_19183);
var state_19204__$1 = state_19204;
var statearr_19254_19309 = state_19204__$1;
(statearr_19254_19309[(2)] = inst_19184);

(statearr_19254_19309[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (10))){
var inst_19110 = (state_19204[(8)]);
var inst_19130 = (state_19204[(2)]);
var inst_19131 = cljs.core.get.call(null,inst_19130,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_19132 = cljs.core.get.call(null,inst_19130,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_19133 = cljs.core.get.call(null,inst_19130,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_19134 = inst_19110;
var state_19204__$1 = (function (){var statearr_19255 = state_19204;
(statearr_19255[(7)] = inst_19134);

(statearr_19255[(16)] = inst_19133);

(statearr_19255[(17)] = inst_19132);

(statearr_19255[(18)] = inst_19131);

return statearr_19255;
})();
var statearr_19256_19310 = state_19204__$1;
(statearr_19256_19310[(2)] = null);

(statearr_19256_19310[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (18))){
var inst_19148 = (state_19204[(2)]);
var state_19204__$1 = state_19204;
var statearr_19257_19311 = state_19204__$1;
(statearr_19257_19311[(2)] = inst_19148);

(statearr_19257_19311[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (37))){
var state_19204__$1 = state_19204;
var statearr_19258_19312 = state_19204__$1;
(statearr_19258_19312[(2)] = null);

(statearr_19258_19312[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19205 === (8))){
var inst_19110 = (state_19204[(8)]);
var inst_19127 = cljs.core.apply.call(null,cljs.core.hash_map,inst_19110);
var state_19204__$1 = state_19204;
var statearr_19259_19313 = state_19204__$1;
(statearr_19259_19313[(2)] = inst_19127);

(statearr_19259_19313[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___19267,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__9165__auto__,c__9230__auto___19267,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__9166__auto__ = null;
var cljs$core$async$mix_$_state_machine__9166__auto____0 = (function (){
var statearr_19263 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19263[(0)] = cljs$core$async$mix_$_state_machine__9166__auto__);

(statearr_19263[(1)] = (1));

return statearr_19263;
});
var cljs$core$async$mix_$_state_machine__9166__auto____1 = (function (state_19204){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_19204);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e19264){if((e19264 instanceof Object)){
var ex__9169__auto__ = e19264;
var statearr_19265_19314 = state_19204;
(statearr_19265_19314[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19204);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19264;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19315 = state_19204;
state_19204 = G__19315;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__9166__auto__ = function(state_19204){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__9166__auto____1.call(this,state_19204);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__9166__auto____0;
cljs$core$async$mix_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__9166__auto____1;
return cljs$core$async$mix_$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___19267,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__9232__auto__ = (function (){var statearr_19266 = f__9231__auto__.call(null);
(statearr_19266[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___19267);

return statearr_19266;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___19267,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5225__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p,v,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args19316 = [];
var len__5627__auto___19319 = arguments.length;
var i__5628__auto___19320 = (0);
while(true){
if((i__5628__auto___19320 < len__5627__auto___19319)){
args19316.push((arguments[i__5628__auto___19320]));

var G__19321 = (i__5628__auto___19320 + (1));
i__5628__auto___19320 = G__19321;
continue;
} else {
}
break;
}

var G__19318 = args19316.length;
switch (G__19318) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19316.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p);
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p,v);
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args19324 = [];
var len__5627__auto___19449 = arguments.length;
var i__5628__auto___19450 = (0);
while(true){
if((i__5628__auto___19450 < len__5627__auto___19449)){
args19324.push((arguments[i__5628__auto___19450]));

var G__19451 = (i__5628__auto___19450 + (1));
i__5628__auto___19450 = G__19451;
continue;
} else {
}
break;
}

var G__19326 = args19324.length;
switch (G__19326) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19324.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4569__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4569__auto__,mults){
return (function (p1__19323_SHARP_){
if(cljs.core.truth_(p1__19323_SHARP_.call(null,topic))){
return p1__19323_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__19323_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4569__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async19327 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19327 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta19328){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta19328 = meta19328;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19327.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_19329,meta19328__$1){
var self__ = this;
var _19329__$1 = this;
return (new cljs.core.async.t_cljs$core$async19327(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta19328__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19327.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_19329){
var self__ = this;
var _19329__$1 = this;
return self__.meta19328;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19327.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19327.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19327.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async19327.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19327.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19327.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19327.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19327.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta19328","meta19328",2000435217,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19327.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19327.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19327";

cljs.core.async.t_cljs$core$async19327.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async19327");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async19327 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async19327(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19328){
return (new cljs.core.async.t_cljs$core$async19327(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19328));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async19327(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__9230__auto___19453 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___19453,mults,ensure_mult,p){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___19453,mults,ensure_mult,p){
return (function (state_19401){
var state_val_19402 = (state_19401[(1)]);
if((state_val_19402 === (7))){
var inst_19397 = (state_19401[(2)]);
var state_19401__$1 = state_19401;
var statearr_19403_19454 = state_19401__$1;
(statearr_19403_19454[(2)] = inst_19397);

(statearr_19403_19454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19402 === (20))){
var state_19401__$1 = state_19401;
var statearr_19404_19455 = state_19401__$1;
(statearr_19404_19455[(2)] = null);

(statearr_19404_19455[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19402 === (1))){
var state_19401__$1 = state_19401;
var statearr_19405_19456 = state_19401__$1;
(statearr_19405_19456[(2)] = null);

(statearr_19405_19456[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19402 === (24))){
var inst_19380 = (state_19401[(7)]);
var inst_19389 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_19380);
var state_19401__$1 = state_19401;
var statearr_19406_19457 = state_19401__$1;
(statearr_19406_19457[(2)] = inst_19389);

(statearr_19406_19457[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19402 === (4))){
var inst_19332 = (state_19401[(8)]);
var inst_19332__$1 = (state_19401[(2)]);
var inst_19333 = (inst_19332__$1 == null);
var state_19401__$1 = (function (){var statearr_19407 = state_19401;
(statearr_19407[(8)] = inst_19332__$1);

return statearr_19407;
})();
if(cljs.core.truth_(inst_19333)){
var statearr_19408_19458 = state_19401__$1;
(statearr_19408_19458[(1)] = (5));

} else {
var statearr_19409_19459 = state_19401__$1;
(statearr_19409_19459[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19402 === (15))){
var inst_19374 = (state_19401[(2)]);
var state_19401__$1 = state_19401;
var statearr_19410_19460 = state_19401__$1;
(statearr_19410_19460[(2)] = inst_19374);

(statearr_19410_19460[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19402 === (21))){
var inst_19394 = (state_19401[(2)]);
var state_19401__$1 = (function (){var statearr_19411 = state_19401;
(statearr_19411[(9)] = inst_19394);

return statearr_19411;
})();
var statearr_19412_19461 = state_19401__$1;
(statearr_19412_19461[(2)] = null);

(statearr_19412_19461[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19402 === (13))){
var inst_19356 = (state_19401[(10)]);
var inst_19358 = cljs.core.chunked_seq_QMARK_.call(null,inst_19356);
var state_19401__$1 = state_19401;
if(inst_19358){
var statearr_19413_19462 = state_19401__$1;
(statearr_19413_19462[(1)] = (16));

} else {
var statearr_19414_19463 = state_19401__$1;
(statearr_19414_19463[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19402 === (22))){
var inst_19386 = (state_19401[(2)]);
var state_19401__$1 = state_19401;
if(cljs.core.truth_(inst_19386)){
var statearr_19415_19464 = state_19401__$1;
(statearr_19415_19464[(1)] = (23));

} else {
var statearr_19416_19465 = state_19401__$1;
(statearr_19416_19465[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19402 === (6))){
var inst_19380 = (state_19401[(7)]);
var inst_19382 = (state_19401[(11)]);
var inst_19332 = (state_19401[(8)]);
var inst_19380__$1 = topic_fn.call(null,inst_19332);
var inst_19381 = cljs.core.deref.call(null,mults);
var inst_19382__$1 = cljs.core.get.call(null,inst_19381,inst_19380__$1);
var state_19401__$1 = (function (){var statearr_19417 = state_19401;
(statearr_19417[(7)] = inst_19380__$1);

(statearr_19417[(11)] = inst_19382__$1);

return statearr_19417;
})();
if(cljs.core.truth_(inst_19382__$1)){
var statearr_19418_19466 = state_19401__$1;
(statearr_19418_19466[(1)] = (19));

} else {
var statearr_19419_19467 = state_19401__$1;
(statearr_19419_19467[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19402 === (25))){
var inst_19391 = (state_19401[(2)]);
var state_19401__$1 = state_19401;
var statearr_19420_19468 = state_19401__$1;
(statearr_19420_19468[(2)] = inst_19391);

(statearr_19420_19468[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19402 === (17))){
var inst_19356 = (state_19401[(10)]);
var inst_19365 = cljs.core.first.call(null,inst_19356);
var inst_19366 = cljs.core.async.muxch_STAR_.call(null,inst_19365);
var inst_19367 = cljs.core.async.close_BANG_.call(null,inst_19366);
var inst_19368 = cljs.core.next.call(null,inst_19356);
var inst_19342 = inst_19368;
var inst_19343 = null;
var inst_19344 = (0);
var inst_19345 = (0);
var state_19401__$1 = (function (){var statearr_19421 = state_19401;
(statearr_19421[(12)] = inst_19345);

(statearr_19421[(13)] = inst_19342);

(statearr_19421[(14)] = inst_19367);

(statearr_19421[(15)] = inst_19344);

(statearr_19421[(16)] = inst_19343);

return statearr_19421;
})();
var statearr_19422_19469 = state_19401__$1;
(statearr_19422_19469[(2)] = null);

(statearr_19422_19469[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19402 === (3))){
var inst_19399 = (state_19401[(2)]);
var state_19401__$1 = state_19401;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19401__$1,inst_19399);
} else {
if((state_val_19402 === (12))){
var inst_19376 = (state_19401[(2)]);
var state_19401__$1 = state_19401;
var statearr_19423_19470 = state_19401__$1;
(statearr_19423_19470[(2)] = inst_19376);

(statearr_19423_19470[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19402 === (2))){
var state_19401__$1 = state_19401;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19401__$1,(4),ch);
} else {
if((state_val_19402 === (23))){
var state_19401__$1 = state_19401;
var statearr_19424_19471 = state_19401__$1;
(statearr_19424_19471[(2)] = null);

(statearr_19424_19471[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19402 === (19))){
var inst_19382 = (state_19401[(11)]);
var inst_19332 = (state_19401[(8)]);
var inst_19384 = cljs.core.async.muxch_STAR_.call(null,inst_19382);
var state_19401__$1 = state_19401;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19401__$1,(22),inst_19384,inst_19332);
} else {
if((state_val_19402 === (11))){
var inst_19342 = (state_19401[(13)]);
var inst_19356 = (state_19401[(10)]);
var inst_19356__$1 = cljs.core.seq.call(null,inst_19342);
var state_19401__$1 = (function (){var statearr_19425 = state_19401;
(statearr_19425[(10)] = inst_19356__$1);

return statearr_19425;
})();
if(inst_19356__$1){
var statearr_19426_19472 = state_19401__$1;
(statearr_19426_19472[(1)] = (13));

} else {
var statearr_19427_19473 = state_19401__$1;
(statearr_19427_19473[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19402 === (9))){
var inst_19378 = (state_19401[(2)]);
var state_19401__$1 = state_19401;
var statearr_19428_19474 = state_19401__$1;
(statearr_19428_19474[(2)] = inst_19378);

(statearr_19428_19474[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19402 === (5))){
var inst_19339 = cljs.core.deref.call(null,mults);
var inst_19340 = cljs.core.vals.call(null,inst_19339);
var inst_19341 = cljs.core.seq.call(null,inst_19340);
var inst_19342 = inst_19341;
var inst_19343 = null;
var inst_19344 = (0);
var inst_19345 = (0);
var state_19401__$1 = (function (){var statearr_19429 = state_19401;
(statearr_19429[(12)] = inst_19345);

(statearr_19429[(13)] = inst_19342);

(statearr_19429[(15)] = inst_19344);

(statearr_19429[(16)] = inst_19343);

return statearr_19429;
})();
var statearr_19430_19475 = state_19401__$1;
(statearr_19430_19475[(2)] = null);

(statearr_19430_19475[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19402 === (14))){
var state_19401__$1 = state_19401;
var statearr_19434_19476 = state_19401__$1;
(statearr_19434_19476[(2)] = null);

(statearr_19434_19476[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19402 === (16))){
var inst_19356 = (state_19401[(10)]);
var inst_19360 = cljs.core.chunk_first.call(null,inst_19356);
var inst_19361 = cljs.core.chunk_rest.call(null,inst_19356);
var inst_19362 = cljs.core.count.call(null,inst_19360);
var inst_19342 = inst_19361;
var inst_19343 = inst_19360;
var inst_19344 = inst_19362;
var inst_19345 = (0);
var state_19401__$1 = (function (){var statearr_19435 = state_19401;
(statearr_19435[(12)] = inst_19345);

(statearr_19435[(13)] = inst_19342);

(statearr_19435[(15)] = inst_19344);

(statearr_19435[(16)] = inst_19343);

return statearr_19435;
})();
var statearr_19436_19477 = state_19401__$1;
(statearr_19436_19477[(2)] = null);

(statearr_19436_19477[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19402 === (10))){
var inst_19345 = (state_19401[(12)]);
var inst_19342 = (state_19401[(13)]);
var inst_19344 = (state_19401[(15)]);
var inst_19343 = (state_19401[(16)]);
var inst_19350 = cljs.core._nth.call(null,inst_19343,inst_19345);
var inst_19351 = cljs.core.async.muxch_STAR_.call(null,inst_19350);
var inst_19352 = cljs.core.async.close_BANG_.call(null,inst_19351);
var inst_19353 = (inst_19345 + (1));
var tmp19431 = inst_19342;
var tmp19432 = inst_19344;
var tmp19433 = inst_19343;
var inst_19342__$1 = tmp19431;
var inst_19343__$1 = tmp19433;
var inst_19344__$1 = tmp19432;
var inst_19345__$1 = inst_19353;
var state_19401__$1 = (function (){var statearr_19437 = state_19401;
(statearr_19437[(12)] = inst_19345__$1);

(statearr_19437[(13)] = inst_19342__$1);

(statearr_19437[(17)] = inst_19352);

(statearr_19437[(15)] = inst_19344__$1);

(statearr_19437[(16)] = inst_19343__$1);

return statearr_19437;
})();
var statearr_19438_19478 = state_19401__$1;
(statearr_19438_19478[(2)] = null);

(statearr_19438_19478[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19402 === (18))){
var inst_19371 = (state_19401[(2)]);
var state_19401__$1 = state_19401;
var statearr_19439_19479 = state_19401__$1;
(statearr_19439_19479[(2)] = inst_19371);

(statearr_19439_19479[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19402 === (8))){
var inst_19345 = (state_19401[(12)]);
var inst_19344 = (state_19401[(15)]);
var inst_19347 = (inst_19345 < inst_19344);
var inst_19348 = inst_19347;
var state_19401__$1 = state_19401;
if(cljs.core.truth_(inst_19348)){
var statearr_19440_19480 = state_19401__$1;
(statearr_19440_19480[(1)] = (10));

} else {
var statearr_19441_19481 = state_19401__$1;
(statearr_19441_19481[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___19453,mults,ensure_mult,p))
;
return ((function (switch__9165__auto__,c__9230__auto___19453,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_19445 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19445[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_19445[(1)] = (1));

return statearr_19445;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_19401){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_19401);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e19446){if((e19446 instanceof Object)){
var ex__9169__auto__ = e19446;
var statearr_19447_19482 = state_19401;
(statearr_19447_19482[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19401);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19446;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19483 = state_19401;
state_19401 = G__19483;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_19401){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_19401);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___19453,mults,ensure_mult,p))
})();
var state__9232__auto__ = (function (){var statearr_19448 = f__9231__auto__.call(null);
(statearr_19448[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___19453);

return statearr_19448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___19453,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args19484 = [];
var len__5627__auto___19487 = arguments.length;
var i__5628__auto___19488 = (0);
while(true){
if((i__5628__auto___19488 < len__5627__auto___19487)){
args19484.push((arguments[i__5628__auto___19488]));

var G__19489 = (i__5628__auto___19488 + (1));
i__5628__auto___19488 = G__19489;
continue;
} else {
}
break;
}

var G__19486 = args19484.length;
switch (G__19486) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19484.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args19491 = [];
var len__5627__auto___19494 = arguments.length;
var i__5628__auto___19495 = (0);
while(true){
if((i__5628__auto___19495 < len__5627__auto___19494)){
args19491.push((arguments[i__5628__auto___19495]));

var G__19496 = (i__5628__auto___19495 + (1));
i__5628__auto___19495 = G__19496;
continue;
} else {
}
break;
}

var G__19493 = args19491.length;
switch (G__19493) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19491.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args19498 = [];
var len__5627__auto___19569 = arguments.length;
var i__5628__auto___19570 = (0);
while(true){
if((i__5628__auto___19570 < len__5627__auto___19569)){
args19498.push((arguments[i__5628__auto___19570]));

var G__19571 = (i__5628__auto___19570 + (1));
i__5628__auto___19570 = G__19571;
continue;
} else {
}
break;
}

var G__19500 = args19498.length;
switch (G__19500) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19498.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__9230__auto___19573 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___19573,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___19573,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_19539){
var state_val_19540 = (state_19539[(1)]);
if((state_val_19540 === (7))){
var state_19539__$1 = state_19539;
var statearr_19541_19574 = state_19539__$1;
(statearr_19541_19574[(2)] = null);

(statearr_19541_19574[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19540 === (1))){
var state_19539__$1 = state_19539;
var statearr_19542_19575 = state_19539__$1;
(statearr_19542_19575[(2)] = null);

(statearr_19542_19575[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19540 === (4))){
var inst_19503 = (state_19539[(7)]);
var inst_19505 = (inst_19503 < cnt);
var state_19539__$1 = state_19539;
if(cljs.core.truth_(inst_19505)){
var statearr_19543_19576 = state_19539__$1;
(statearr_19543_19576[(1)] = (6));

} else {
var statearr_19544_19577 = state_19539__$1;
(statearr_19544_19577[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19540 === (15))){
var inst_19535 = (state_19539[(2)]);
var state_19539__$1 = state_19539;
var statearr_19545_19578 = state_19539__$1;
(statearr_19545_19578[(2)] = inst_19535);

(statearr_19545_19578[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19540 === (13))){
var inst_19528 = cljs.core.async.close_BANG_.call(null,out);
var state_19539__$1 = state_19539;
var statearr_19546_19579 = state_19539__$1;
(statearr_19546_19579[(2)] = inst_19528);

(statearr_19546_19579[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19540 === (6))){
var state_19539__$1 = state_19539;
var statearr_19547_19580 = state_19539__$1;
(statearr_19547_19580[(2)] = null);

(statearr_19547_19580[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19540 === (3))){
var inst_19537 = (state_19539[(2)]);
var state_19539__$1 = state_19539;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19539__$1,inst_19537);
} else {
if((state_val_19540 === (12))){
var inst_19525 = (state_19539[(8)]);
var inst_19525__$1 = (state_19539[(2)]);
var inst_19526 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_19525__$1);
var state_19539__$1 = (function (){var statearr_19548 = state_19539;
(statearr_19548[(8)] = inst_19525__$1);

return statearr_19548;
})();
if(cljs.core.truth_(inst_19526)){
var statearr_19549_19581 = state_19539__$1;
(statearr_19549_19581[(1)] = (13));

} else {
var statearr_19550_19582 = state_19539__$1;
(statearr_19550_19582[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19540 === (2))){
var inst_19502 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_19503 = (0);
var state_19539__$1 = (function (){var statearr_19551 = state_19539;
(statearr_19551[(9)] = inst_19502);

(statearr_19551[(7)] = inst_19503);

return statearr_19551;
})();
var statearr_19552_19583 = state_19539__$1;
(statearr_19552_19583[(2)] = null);

(statearr_19552_19583[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19540 === (11))){
var inst_19503 = (state_19539[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_19539,(10),Object,null,(9));
var inst_19512 = chs__$1.call(null,inst_19503);
var inst_19513 = done.call(null,inst_19503);
var inst_19514 = cljs.core.async.take_BANG_.call(null,inst_19512,inst_19513);
var state_19539__$1 = state_19539;
var statearr_19553_19584 = state_19539__$1;
(statearr_19553_19584[(2)] = inst_19514);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19539__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19540 === (9))){
var inst_19503 = (state_19539[(7)]);
var inst_19516 = (state_19539[(2)]);
var inst_19517 = (inst_19503 + (1));
var inst_19503__$1 = inst_19517;
var state_19539__$1 = (function (){var statearr_19554 = state_19539;
(statearr_19554[(10)] = inst_19516);

(statearr_19554[(7)] = inst_19503__$1);

return statearr_19554;
})();
var statearr_19555_19585 = state_19539__$1;
(statearr_19555_19585[(2)] = null);

(statearr_19555_19585[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19540 === (5))){
var inst_19523 = (state_19539[(2)]);
var state_19539__$1 = (function (){var statearr_19556 = state_19539;
(statearr_19556[(11)] = inst_19523);

return statearr_19556;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19539__$1,(12),dchan);
} else {
if((state_val_19540 === (14))){
var inst_19525 = (state_19539[(8)]);
var inst_19530 = cljs.core.apply.call(null,f,inst_19525);
var state_19539__$1 = state_19539;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19539__$1,(16),out,inst_19530);
} else {
if((state_val_19540 === (16))){
var inst_19532 = (state_19539[(2)]);
var state_19539__$1 = (function (){var statearr_19557 = state_19539;
(statearr_19557[(12)] = inst_19532);

return statearr_19557;
})();
var statearr_19558_19586 = state_19539__$1;
(statearr_19558_19586[(2)] = null);

(statearr_19558_19586[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19540 === (10))){
var inst_19507 = (state_19539[(2)]);
var inst_19508 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_19539__$1 = (function (){var statearr_19559 = state_19539;
(statearr_19559[(13)] = inst_19507);

return statearr_19559;
})();
var statearr_19560_19587 = state_19539__$1;
(statearr_19560_19587[(2)] = inst_19508);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19539__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19540 === (8))){
var inst_19521 = (state_19539[(2)]);
var state_19539__$1 = state_19539;
var statearr_19561_19588 = state_19539__$1;
(statearr_19561_19588[(2)] = inst_19521);

(statearr_19561_19588[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___19573,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__9165__auto__,c__9230__auto___19573,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_19565 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19565[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_19565[(1)] = (1));

return statearr_19565;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_19539){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_19539);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e19566){if((e19566 instanceof Object)){
var ex__9169__auto__ = e19566;
var statearr_19567_19589 = state_19539;
(statearr_19567_19589[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19539);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19566;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19590 = state_19539;
state_19539 = G__19590;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_19539){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_19539);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___19573,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__9232__auto__ = (function (){var statearr_19568 = f__9231__auto__.call(null);
(statearr_19568[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___19573);

return statearr_19568;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___19573,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args19592 = [];
var len__5627__auto___19648 = arguments.length;
var i__5628__auto___19649 = (0);
while(true){
if((i__5628__auto___19649 < len__5627__auto___19648)){
args19592.push((arguments[i__5628__auto___19649]));

var G__19650 = (i__5628__auto___19649 + (1));
i__5628__auto___19649 = G__19650;
continue;
} else {
}
break;
}

var G__19594 = args19592.length;
switch (G__19594) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19592.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__9230__auto___19652 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___19652,out){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___19652,out){
return (function (state_19624){
var state_val_19625 = (state_19624[(1)]);
if((state_val_19625 === (7))){
var inst_19603 = (state_19624[(7)]);
var inst_19604 = (state_19624[(8)]);
var inst_19603__$1 = (state_19624[(2)]);
var inst_19604__$1 = cljs.core.nth.call(null,inst_19603__$1,(0),null);
var inst_19605 = cljs.core.nth.call(null,inst_19603__$1,(1),null);
var inst_19606 = (inst_19604__$1 == null);
var state_19624__$1 = (function (){var statearr_19626 = state_19624;
(statearr_19626[(7)] = inst_19603__$1);

(statearr_19626[(9)] = inst_19605);

(statearr_19626[(8)] = inst_19604__$1);

return statearr_19626;
})();
if(cljs.core.truth_(inst_19606)){
var statearr_19627_19653 = state_19624__$1;
(statearr_19627_19653[(1)] = (8));

} else {
var statearr_19628_19654 = state_19624__$1;
(statearr_19628_19654[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19625 === (1))){
var inst_19595 = cljs.core.vec.call(null,chs);
var inst_19596 = inst_19595;
var state_19624__$1 = (function (){var statearr_19629 = state_19624;
(statearr_19629[(10)] = inst_19596);

return statearr_19629;
})();
var statearr_19630_19655 = state_19624__$1;
(statearr_19630_19655[(2)] = null);

(statearr_19630_19655[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19625 === (4))){
var inst_19596 = (state_19624[(10)]);
var state_19624__$1 = state_19624;
return cljs.core.async.ioc_alts_BANG_.call(null,state_19624__$1,(7),inst_19596);
} else {
if((state_val_19625 === (6))){
var inst_19620 = (state_19624[(2)]);
var state_19624__$1 = state_19624;
var statearr_19631_19656 = state_19624__$1;
(statearr_19631_19656[(2)] = inst_19620);

(statearr_19631_19656[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19625 === (3))){
var inst_19622 = (state_19624[(2)]);
var state_19624__$1 = state_19624;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19624__$1,inst_19622);
} else {
if((state_val_19625 === (2))){
var inst_19596 = (state_19624[(10)]);
var inst_19598 = cljs.core.count.call(null,inst_19596);
var inst_19599 = (inst_19598 > (0));
var state_19624__$1 = state_19624;
if(cljs.core.truth_(inst_19599)){
var statearr_19633_19657 = state_19624__$1;
(statearr_19633_19657[(1)] = (4));

} else {
var statearr_19634_19658 = state_19624__$1;
(statearr_19634_19658[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19625 === (11))){
var inst_19596 = (state_19624[(10)]);
var inst_19613 = (state_19624[(2)]);
var tmp19632 = inst_19596;
var inst_19596__$1 = tmp19632;
var state_19624__$1 = (function (){var statearr_19635 = state_19624;
(statearr_19635[(11)] = inst_19613);

(statearr_19635[(10)] = inst_19596__$1);

return statearr_19635;
})();
var statearr_19636_19659 = state_19624__$1;
(statearr_19636_19659[(2)] = null);

(statearr_19636_19659[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19625 === (9))){
var inst_19604 = (state_19624[(8)]);
var state_19624__$1 = state_19624;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19624__$1,(11),out,inst_19604);
} else {
if((state_val_19625 === (5))){
var inst_19618 = cljs.core.async.close_BANG_.call(null,out);
var state_19624__$1 = state_19624;
var statearr_19637_19660 = state_19624__$1;
(statearr_19637_19660[(2)] = inst_19618);

(statearr_19637_19660[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19625 === (10))){
var inst_19616 = (state_19624[(2)]);
var state_19624__$1 = state_19624;
var statearr_19638_19661 = state_19624__$1;
(statearr_19638_19661[(2)] = inst_19616);

(statearr_19638_19661[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19625 === (8))){
var inst_19603 = (state_19624[(7)]);
var inst_19605 = (state_19624[(9)]);
var inst_19596 = (state_19624[(10)]);
var inst_19604 = (state_19624[(8)]);
var inst_19608 = (function (){var cs = inst_19596;
var vec__19601 = inst_19603;
var v = inst_19604;
var c = inst_19605;
return ((function (cs,vec__19601,v,c,inst_19603,inst_19605,inst_19596,inst_19604,state_val_19625,c__9230__auto___19652,out){
return (function (p1__19591_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__19591_SHARP_);
});
;})(cs,vec__19601,v,c,inst_19603,inst_19605,inst_19596,inst_19604,state_val_19625,c__9230__auto___19652,out))
})();
var inst_19609 = cljs.core.filterv.call(null,inst_19608,inst_19596);
var inst_19596__$1 = inst_19609;
var state_19624__$1 = (function (){var statearr_19639 = state_19624;
(statearr_19639[(10)] = inst_19596__$1);

return statearr_19639;
})();
var statearr_19640_19662 = state_19624__$1;
(statearr_19640_19662[(2)] = null);

(statearr_19640_19662[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___19652,out))
;
return ((function (switch__9165__auto__,c__9230__auto___19652,out){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_19644 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19644[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_19644[(1)] = (1));

return statearr_19644;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_19624){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_19624);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e19645){if((e19645 instanceof Object)){
var ex__9169__auto__ = e19645;
var statearr_19646_19663 = state_19624;
(statearr_19646_19663[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19624);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19645;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19664 = state_19624;
state_19624 = G__19664;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_19624){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_19624);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___19652,out))
})();
var state__9232__auto__ = (function (){var statearr_19647 = f__9231__auto__.call(null);
(statearr_19647[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___19652);

return statearr_19647;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___19652,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args19665 = [];
var len__5627__auto___19714 = arguments.length;
var i__5628__auto___19715 = (0);
while(true){
if((i__5628__auto___19715 < len__5627__auto___19714)){
args19665.push((arguments[i__5628__auto___19715]));

var G__19716 = (i__5628__auto___19715 + (1));
i__5628__auto___19715 = G__19716;
continue;
} else {
}
break;
}

var G__19667 = args19665.length;
switch (G__19667) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19665.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__9230__auto___19718 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___19718,out){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___19718,out){
return (function (state_19691){
var state_val_19692 = (state_19691[(1)]);
if((state_val_19692 === (7))){
var inst_19673 = (state_19691[(7)]);
var inst_19673__$1 = (state_19691[(2)]);
var inst_19674 = (inst_19673__$1 == null);
var inst_19675 = cljs.core.not.call(null,inst_19674);
var state_19691__$1 = (function (){var statearr_19693 = state_19691;
(statearr_19693[(7)] = inst_19673__$1);

return statearr_19693;
})();
if(inst_19675){
var statearr_19694_19719 = state_19691__$1;
(statearr_19694_19719[(1)] = (8));

} else {
var statearr_19695_19720 = state_19691__$1;
(statearr_19695_19720[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19692 === (1))){
var inst_19668 = (0);
var state_19691__$1 = (function (){var statearr_19696 = state_19691;
(statearr_19696[(8)] = inst_19668);

return statearr_19696;
})();
var statearr_19697_19721 = state_19691__$1;
(statearr_19697_19721[(2)] = null);

(statearr_19697_19721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19692 === (4))){
var state_19691__$1 = state_19691;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19691__$1,(7),ch);
} else {
if((state_val_19692 === (6))){
var inst_19686 = (state_19691[(2)]);
var state_19691__$1 = state_19691;
var statearr_19698_19722 = state_19691__$1;
(statearr_19698_19722[(2)] = inst_19686);

(statearr_19698_19722[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19692 === (3))){
var inst_19688 = (state_19691[(2)]);
var inst_19689 = cljs.core.async.close_BANG_.call(null,out);
var state_19691__$1 = (function (){var statearr_19699 = state_19691;
(statearr_19699[(9)] = inst_19688);

return statearr_19699;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19691__$1,inst_19689);
} else {
if((state_val_19692 === (2))){
var inst_19668 = (state_19691[(8)]);
var inst_19670 = (inst_19668 < n);
var state_19691__$1 = state_19691;
if(cljs.core.truth_(inst_19670)){
var statearr_19700_19723 = state_19691__$1;
(statearr_19700_19723[(1)] = (4));

} else {
var statearr_19701_19724 = state_19691__$1;
(statearr_19701_19724[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19692 === (11))){
var inst_19668 = (state_19691[(8)]);
var inst_19678 = (state_19691[(2)]);
var inst_19679 = (inst_19668 + (1));
var inst_19668__$1 = inst_19679;
var state_19691__$1 = (function (){var statearr_19702 = state_19691;
(statearr_19702[(8)] = inst_19668__$1);

(statearr_19702[(10)] = inst_19678);

return statearr_19702;
})();
var statearr_19703_19725 = state_19691__$1;
(statearr_19703_19725[(2)] = null);

(statearr_19703_19725[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19692 === (9))){
var state_19691__$1 = state_19691;
var statearr_19704_19726 = state_19691__$1;
(statearr_19704_19726[(2)] = null);

(statearr_19704_19726[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19692 === (5))){
var state_19691__$1 = state_19691;
var statearr_19705_19727 = state_19691__$1;
(statearr_19705_19727[(2)] = null);

(statearr_19705_19727[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19692 === (10))){
var inst_19683 = (state_19691[(2)]);
var state_19691__$1 = state_19691;
var statearr_19706_19728 = state_19691__$1;
(statearr_19706_19728[(2)] = inst_19683);

(statearr_19706_19728[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19692 === (8))){
var inst_19673 = (state_19691[(7)]);
var state_19691__$1 = state_19691;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19691__$1,(11),out,inst_19673);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___19718,out))
;
return ((function (switch__9165__auto__,c__9230__auto___19718,out){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_19710 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19710[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_19710[(1)] = (1));

return statearr_19710;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_19691){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_19691);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e19711){if((e19711 instanceof Object)){
var ex__9169__auto__ = e19711;
var statearr_19712_19729 = state_19691;
(statearr_19712_19729[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19691);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19711;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19730 = state_19691;
state_19691 = G__19730;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_19691){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_19691);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___19718,out))
})();
var state__9232__auto__ = (function (){var statearr_19713 = f__9231__auto__.call(null);
(statearr_19713[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___19718);

return statearr_19713;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___19718,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19738 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19738 = (function (map_LT_,f,ch,meta19739){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19739 = meta19739;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19738.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19740,meta19739__$1){
var self__ = this;
var _19740__$1 = this;
return (new cljs.core.async.t_cljs$core$async19738(self__.map_LT_,self__.f,self__.ch,meta19739__$1));
});

cljs.core.async.t_cljs$core$async19738.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19740){
var self__ = this;
var _19740__$1 = this;
return self__.meta19739;
});

cljs.core.async.t_cljs$core$async19738.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19738.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19738.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19738.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19738.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async19741 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19741 = (function (map_LT_,f,ch,meta19739,_,fn1,meta19742){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19739 = meta19739;
this._ = _;
this.fn1 = fn1;
this.meta19742 = meta19742;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19741.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_19743,meta19742__$1){
var self__ = this;
var _19743__$1 = this;
return (new cljs.core.async.t_cljs$core$async19741(self__.map_LT_,self__.f,self__.ch,self__.meta19739,self__._,self__.fn1,meta19742__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async19741.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_19743){
var self__ = this;
var _19743__$1 = this;
return self__.meta19742;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19741.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19741.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19741.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__19731_SHARP_){
return f1.call(null,(((p1__19731_SHARP_ == null))?null:self__.f.call(null,p1__19731_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async19741.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19739","meta19739",1586411003,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async19738","cljs.core.async/t_cljs$core$async19738",53569496,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta19742","meta19742",792301529,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19741.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19741.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19741";

cljs.core.async.t_cljs$core$async19741.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async19741");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async19741 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19741(map_LT___$1,f__$1,ch__$1,meta19739__$1,___$2,fn1__$1,meta19742){
return (new cljs.core.async.t_cljs$core$async19741(map_LT___$1,f__$1,ch__$1,meta19739__$1,___$2,fn1__$1,meta19742));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async19741(self__.map_LT_,self__.f,self__.ch,self__.meta19739,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4557__auto__ = ret;
if(cljs.core.truth_(and__4557__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4557__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async19738.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19738.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async19738.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19739","meta19739",1586411003,null)], null);
});

cljs.core.async.t_cljs$core$async19738.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19738.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19738";

cljs.core.async.t_cljs$core$async19738.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async19738");
});

cljs.core.async.__GT_t_cljs$core$async19738 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19738(map_LT___$1,f__$1,ch__$1,meta19739){
return (new cljs.core.async.t_cljs$core$async19738(map_LT___$1,f__$1,ch__$1,meta19739));
});

}

return (new cljs.core.async.t_cljs$core$async19738(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19747 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19747 = (function (map_GT_,f,ch,meta19748){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta19748 = meta19748;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19747.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19749,meta19748__$1){
var self__ = this;
var _19749__$1 = this;
return (new cljs.core.async.t_cljs$core$async19747(self__.map_GT_,self__.f,self__.ch,meta19748__$1));
});

cljs.core.async.t_cljs$core$async19747.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19749){
var self__ = this;
var _19749__$1 = this;
return self__.meta19748;
});

cljs.core.async.t_cljs$core$async19747.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19747.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19747.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19747.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19747.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19747.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async19747.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19748","meta19748",-1322196040,null)], null);
});

cljs.core.async.t_cljs$core$async19747.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19747.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19747";

cljs.core.async.t_cljs$core$async19747.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async19747");
});

cljs.core.async.__GT_t_cljs$core$async19747 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async19747(map_GT___$1,f__$1,ch__$1,meta19748){
return (new cljs.core.async.t_cljs$core$async19747(map_GT___$1,f__$1,ch__$1,meta19748));
});

}

return (new cljs.core.async.t_cljs$core$async19747(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async19753 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19753 = (function (filter_GT_,p,ch,meta19754){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta19754 = meta19754;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19753.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19755,meta19754__$1){
var self__ = this;
var _19755__$1 = this;
return (new cljs.core.async.t_cljs$core$async19753(self__.filter_GT_,self__.p,self__.ch,meta19754__$1));
});

cljs.core.async.t_cljs$core$async19753.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19755){
var self__ = this;
var _19755__$1 = this;
return self__.meta19754;
});

cljs.core.async.t_cljs$core$async19753.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19753.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19753.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19753.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19753.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19753.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19753.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async19753.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19754","meta19754",-407595073,null)], null);
});

cljs.core.async.t_cljs$core$async19753.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19753.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19753";

cljs.core.async.t_cljs$core$async19753.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async19753");
});

cljs.core.async.__GT_t_cljs$core$async19753 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async19753(filter_GT___$1,p__$1,ch__$1,meta19754){
return (new cljs.core.async.t_cljs$core$async19753(filter_GT___$1,p__$1,ch__$1,meta19754));
});

}

return (new cljs.core.async.t_cljs$core$async19753(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args19756 = [];
var len__5627__auto___19800 = arguments.length;
var i__5628__auto___19801 = (0);
while(true){
if((i__5628__auto___19801 < len__5627__auto___19800)){
args19756.push((arguments[i__5628__auto___19801]));

var G__19802 = (i__5628__auto___19801 + (1));
i__5628__auto___19801 = G__19802;
continue;
} else {
}
break;
}

var G__19758 = args19756.length;
switch (G__19758) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19756.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__9230__auto___19804 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___19804,out){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___19804,out){
return (function (state_19779){
var state_val_19780 = (state_19779[(1)]);
if((state_val_19780 === (7))){
var inst_19775 = (state_19779[(2)]);
var state_19779__$1 = state_19779;
var statearr_19781_19805 = state_19779__$1;
(statearr_19781_19805[(2)] = inst_19775);

(statearr_19781_19805[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19780 === (1))){
var state_19779__$1 = state_19779;
var statearr_19782_19806 = state_19779__$1;
(statearr_19782_19806[(2)] = null);

(statearr_19782_19806[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19780 === (4))){
var inst_19761 = (state_19779[(7)]);
var inst_19761__$1 = (state_19779[(2)]);
var inst_19762 = (inst_19761__$1 == null);
var state_19779__$1 = (function (){var statearr_19783 = state_19779;
(statearr_19783[(7)] = inst_19761__$1);

return statearr_19783;
})();
if(cljs.core.truth_(inst_19762)){
var statearr_19784_19807 = state_19779__$1;
(statearr_19784_19807[(1)] = (5));

} else {
var statearr_19785_19808 = state_19779__$1;
(statearr_19785_19808[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19780 === (6))){
var inst_19761 = (state_19779[(7)]);
var inst_19766 = p.call(null,inst_19761);
var state_19779__$1 = state_19779;
if(cljs.core.truth_(inst_19766)){
var statearr_19786_19809 = state_19779__$1;
(statearr_19786_19809[(1)] = (8));

} else {
var statearr_19787_19810 = state_19779__$1;
(statearr_19787_19810[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19780 === (3))){
var inst_19777 = (state_19779[(2)]);
var state_19779__$1 = state_19779;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19779__$1,inst_19777);
} else {
if((state_val_19780 === (2))){
var state_19779__$1 = state_19779;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19779__$1,(4),ch);
} else {
if((state_val_19780 === (11))){
var inst_19769 = (state_19779[(2)]);
var state_19779__$1 = state_19779;
var statearr_19788_19811 = state_19779__$1;
(statearr_19788_19811[(2)] = inst_19769);

(statearr_19788_19811[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19780 === (9))){
var state_19779__$1 = state_19779;
var statearr_19789_19812 = state_19779__$1;
(statearr_19789_19812[(2)] = null);

(statearr_19789_19812[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19780 === (5))){
var inst_19764 = cljs.core.async.close_BANG_.call(null,out);
var state_19779__$1 = state_19779;
var statearr_19790_19813 = state_19779__$1;
(statearr_19790_19813[(2)] = inst_19764);

(statearr_19790_19813[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19780 === (10))){
var inst_19772 = (state_19779[(2)]);
var state_19779__$1 = (function (){var statearr_19791 = state_19779;
(statearr_19791[(8)] = inst_19772);

return statearr_19791;
})();
var statearr_19792_19814 = state_19779__$1;
(statearr_19792_19814[(2)] = null);

(statearr_19792_19814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19780 === (8))){
var inst_19761 = (state_19779[(7)]);
var state_19779__$1 = state_19779;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19779__$1,(11),out,inst_19761);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___19804,out))
;
return ((function (switch__9165__auto__,c__9230__auto___19804,out){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_19796 = [null,null,null,null,null,null,null,null,null];
(statearr_19796[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_19796[(1)] = (1));

return statearr_19796;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_19779){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_19779);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e19797){if((e19797 instanceof Object)){
var ex__9169__auto__ = e19797;
var statearr_19798_19815 = state_19779;
(statearr_19798_19815[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19779);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19797;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19816 = state_19779;
state_19779 = G__19816;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_19779){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_19779);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___19804,out))
})();
var state__9232__auto__ = (function (){var statearr_19799 = f__9231__auto__.call(null);
(statearr_19799[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___19804);

return statearr_19799;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___19804,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args19817 = [];
var len__5627__auto___19820 = arguments.length;
var i__5628__auto___19821 = (0);
while(true){
if((i__5628__auto___19821 < len__5627__auto___19820)){
args19817.push((arguments[i__5628__auto___19821]));

var G__19822 = (i__5628__auto___19821 + (1));
i__5628__auto___19821 = G__19822;
continue;
} else {
}
break;
}

var G__19819 = args19817.length;
switch (G__19819) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19817.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__9230__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto__){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto__){
return (function (state_19989){
var state_val_19990 = (state_19989[(1)]);
if((state_val_19990 === (7))){
var inst_19985 = (state_19989[(2)]);
var state_19989__$1 = state_19989;
var statearr_19991_20032 = state_19989__$1;
(statearr_19991_20032[(2)] = inst_19985);

(statearr_19991_20032[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19990 === (20))){
var inst_19955 = (state_19989[(7)]);
var inst_19966 = (state_19989[(2)]);
var inst_19967 = cljs.core.next.call(null,inst_19955);
var inst_19941 = inst_19967;
var inst_19942 = null;
var inst_19943 = (0);
var inst_19944 = (0);
var state_19989__$1 = (function (){var statearr_19992 = state_19989;
(statearr_19992[(8)] = inst_19941);

(statearr_19992[(9)] = inst_19966);

(statearr_19992[(10)] = inst_19942);

(statearr_19992[(11)] = inst_19943);

(statearr_19992[(12)] = inst_19944);

return statearr_19992;
})();
var statearr_19993_20033 = state_19989__$1;
(statearr_19993_20033[(2)] = null);

(statearr_19993_20033[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19990 === (1))){
var state_19989__$1 = state_19989;
var statearr_19994_20034 = state_19989__$1;
(statearr_19994_20034[(2)] = null);

(statearr_19994_20034[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19990 === (4))){
var inst_19930 = (state_19989[(13)]);
var inst_19930__$1 = (state_19989[(2)]);
var inst_19931 = (inst_19930__$1 == null);
var state_19989__$1 = (function (){var statearr_19995 = state_19989;
(statearr_19995[(13)] = inst_19930__$1);

return statearr_19995;
})();
if(cljs.core.truth_(inst_19931)){
var statearr_19996_20035 = state_19989__$1;
(statearr_19996_20035[(1)] = (5));

} else {
var statearr_19997_20036 = state_19989__$1;
(statearr_19997_20036[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19990 === (15))){
var state_19989__$1 = state_19989;
var statearr_20001_20037 = state_19989__$1;
(statearr_20001_20037[(2)] = null);

(statearr_20001_20037[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19990 === (21))){
var state_19989__$1 = state_19989;
var statearr_20002_20038 = state_19989__$1;
(statearr_20002_20038[(2)] = null);

(statearr_20002_20038[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19990 === (13))){
var inst_19941 = (state_19989[(8)]);
var inst_19942 = (state_19989[(10)]);
var inst_19943 = (state_19989[(11)]);
var inst_19944 = (state_19989[(12)]);
var inst_19951 = (state_19989[(2)]);
var inst_19952 = (inst_19944 + (1));
var tmp19998 = inst_19941;
var tmp19999 = inst_19942;
var tmp20000 = inst_19943;
var inst_19941__$1 = tmp19998;
var inst_19942__$1 = tmp19999;
var inst_19943__$1 = tmp20000;
var inst_19944__$1 = inst_19952;
var state_19989__$1 = (function (){var statearr_20003 = state_19989;
(statearr_20003[(8)] = inst_19941__$1);

(statearr_20003[(10)] = inst_19942__$1);

(statearr_20003[(11)] = inst_19943__$1);

(statearr_20003[(14)] = inst_19951);

(statearr_20003[(12)] = inst_19944__$1);

return statearr_20003;
})();
var statearr_20004_20039 = state_19989__$1;
(statearr_20004_20039[(2)] = null);

(statearr_20004_20039[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19990 === (22))){
var state_19989__$1 = state_19989;
var statearr_20005_20040 = state_19989__$1;
(statearr_20005_20040[(2)] = null);

(statearr_20005_20040[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19990 === (6))){
var inst_19930 = (state_19989[(13)]);
var inst_19939 = f.call(null,inst_19930);
var inst_19940 = cljs.core.seq.call(null,inst_19939);
var inst_19941 = inst_19940;
var inst_19942 = null;
var inst_19943 = (0);
var inst_19944 = (0);
var state_19989__$1 = (function (){var statearr_20006 = state_19989;
(statearr_20006[(8)] = inst_19941);

(statearr_20006[(10)] = inst_19942);

(statearr_20006[(11)] = inst_19943);

(statearr_20006[(12)] = inst_19944);

return statearr_20006;
})();
var statearr_20007_20041 = state_19989__$1;
(statearr_20007_20041[(2)] = null);

(statearr_20007_20041[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19990 === (17))){
var inst_19955 = (state_19989[(7)]);
var inst_19959 = cljs.core.chunk_first.call(null,inst_19955);
var inst_19960 = cljs.core.chunk_rest.call(null,inst_19955);
var inst_19961 = cljs.core.count.call(null,inst_19959);
var inst_19941 = inst_19960;
var inst_19942 = inst_19959;
var inst_19943 = inst_19961;
var inst_19944 = (0);
var state_19989__$1 = (function (){var statearr_20008 = state_19989;
(statearr_20008[(8)] = inst_19941);

(statearr_20008[(10)] = inst_19942);

(statearr_20008[(11)] = inst_19943);

(statearr_20008[(12)] = inst_19944);

return statearr_20008;
})();
var statearr_20009_20042 = state_19989__$1;
(statearr_20009_20042[(2)] = null);

(statearr_20009_20042[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19990 === (3))){
var inst_19987 = (state_19989[(2)]);
var state_19989__$1 = state_19989;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19989__$1,inst_19987);
} else {
if((state_val_19990 === (12))){
var inst_19975 = (state_19989[(2)]);
var state_19989__$1 = state_19989;
var statearr_20010_20043 = state_19989__$1;
(statearr_20010_20043[(2)] = inst_19975);

(statearr_20010_20043[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19990 === (2))){
var state_19989__$1 = state_19989;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19989__$1,(4),in$);
} else {
if((state_val_19990 === (23))){
var inst_19983 = (state_19989[(2)]);
var state_19989__$1 = state_19989;
var statearr_20011_20044 = state_19989__$1;
(statearr_20011_20044[(2)] = inst_19983);

(statearr_20011_20044[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19990 === (19))){
var inst_19970 = (state_19989[(2)]);
var state_19989__$1 = state_19989;
var statearr_20012_20045 = state_19989__$1;
(statearr_20012_20045[(2)] = inst_19970);

(statearr_20012_20045[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19990 === (11))){
var inst_19941 = (state_19989[(8)]);
var inst_19955 = (state_19989[(7)]);
var inst_19955__$1 = cljs.core.seq.call(null,inst_19941);
var state_19989__$1 = (function (){var statearr_20013 = state_19989;
(statearr_20013[(7)] = inst_19955__$1);

return statearr_20013;
})();
if(inst_19955__$1){
var statearr_20014_20046 = state_19989__$1;
(statearr_20014_20046[(1)] = (14));

} else {
var statearr_20015_20047 = state_19989__$1;
(statearr_20015_20047[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19990 === (9))){
var inst_19977 = (state_19989[(2)]);
var inst_19978 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_19989__$1 = (function (){var statearr_20016 = state_19989;
(statearr_20016[(15)] = inst_19977);

return statearr_20016;
})();
if(cljs.core.truth_(inst_19978)){
var statearr_20017_20048 = state_19989__$1;
(statearr_20017_20048[(1)] = (21));

} else {
var statearr_20018_20049 = state_19989__$1;
(statearr_20018_20049[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19990 === (5))){
var inst_19933 = cljs.core.async.close_BANG_.call(null,out);
var state_19989__$1 = state_19989;
var statearr_20019_20050 = state_19989__$1;
(statearr_20019_20050[(2)] = inst_19933);

(statearr_20019_20050[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19990 === (14))){
var inst_19955 = (state_19989[(7)]);
var inst_19957 = cljs.core.chunked_seq_QMARK_.call(null,inst_19955);
var state_19989__$1 = state_19989;
if(inst_19957){
var statearr_20020_20051 = state_19989__$1;
(statearr_20020_20051[(1)] = (17));

} else {
var statearr_20021_20052 = state_19989__$1;
(statearr_20021_20052[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19990 === (16))){
var inst_19973 = (state_19989[(2)]);
var state_19989__$1 = state_19989;
var statearr_20022_20053 = state_19989__$1;
(statearr_20022_20053[(2)] = inst_19973);

(statearr_20022_20053[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19990 === (10))){
var inst_19942 = (state_19989[(10)]);
var inst_19944 = (state_19989[(12)]);
var inst_19949 = cljs.core._nth.call(null,inst_19942,inst_19944);
var state_19989__$1 = state_19989;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19989__$1,(13),out,inst_19949);
} else {
if((state_val_19990 === (18))){
var inst_19955 = (state_19989[(7)]);
var inst_19964 = cljs.core.first.call(null,inst_19955);
var state_19989__$1 = state_19989;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19989__$1,(20),out,inst_19964);
} else {
if((state_val_19990 === (8))){
var inst_19943 = (state_19989[(11)]);
var inst_19944 = (state_19989[(12)]);
var inst_19946 = (inst_19944 < inst_19943);
var inst_19947 = inst_19946;
var state_19989__$1 = state_19989;
if(cljs.core.truth_(inst_19947)){
var statearr_20023_20054 = state_19989__$1;
(statearr_20023_20054[(1)] = (10));

} else {
var statearr_20024_20055 = state_19989__$1;
(statearr_20024_20055[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto__))
;
return ((function (switch__9165__auto__,c__9230__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__9166__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__9166__auto____0 = (function (){
var statearr_20028 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20028[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__9166__auto__);

(statearr_20028[(1)] = (1));

return statearr_20028;
});
var cljs$core$async$mapcat_STAR__$_state_machine__9166__auto____1 = (function (state_19989){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_19989);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e20029){if((e20029 instanceof Object)){
var ex__9169__auto__ = e20029;
var statearr_20030_20056 = state_19989;
(statearr_20030_20056[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19989);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20029;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20057 = state_19989;
state_19989 = G__20057;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__9166__auto__ = function(state_19989){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__9166__auto____1.call(this,state_19989);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__9166__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__9166__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto__))
})();
var state__9232__auto__ = (function (){var statearr_20031 = f__9231__auto__.call(null);
(statearr_20031[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto__);

return statearr_20031;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto__))
);

return c__9230__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args20058 = [];
var len__5627__auto___20061 = arguments.length;
var i__5628__auto___20062 = (0);
while(true){
if((i__5628__auto___20062 < len__5627__auto___20061)){
args20058.push((arguments[i__5628__auto___20062]));

var G__20063 = (i__5628__auto___20062 + (1));
i__5628__auto___20062 = G__20063;
continue;
} else {
}
break;
}

var G__20060 = args20058.length;
switch (G__20060) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20058.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args20065 = [];
var len__5627__auto___20068 = arguments.length;
var i__5628__auto___20069 = (0);
while(true){
if((i__5628__auto___20069 < len__5627__auto___20068)){
args20065.push((arguments[i__5628__auto___20069]));

var G__20070 = (i__5628__auto___20069 + (1));
i__5628__auto___20069 = G__20070;
continue;
} else {
}
break;
}

var G__20067 = args20065.length;
switch (G__20067) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20065.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args20072 = [];
var len__5627__auto___20123 = arguments.length;
var i__5628__auto___20124 = (0);
while(true){
if((i__5628__auto___20124 < len__5627__auto___20123)){
args20072.push((arguments[i__5628__auto___20124]));

var G__20125 = (i__5628__auto___20124 + (1));
i__5628__auto___20124 = G__20125;
continue;
} else {
}
break;
}

var G__20074 = args20072.length;
switch (G__20074) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20072.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__9230__auto___20127 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___20127,out){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___20127,out){
return (function (state_20098){
var state_val_20099 = (state_20098[(1)]);
if((state_val_20099 === (7))){
var inst_20093 = (state_20098[(2)]);
var state_20098__$1 = state_20098;
var statearr_20100_20128 = state_20098__$1;
(statearr_20100_20128[(2)] = inst_20093);

(statearr_20100_20128[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (1))){
var inst_20075 = null;
var state_20098__$1 = (function (){var statearr_20101 = state_20098;
(statearr_20101[(7)] = inst_20075);

return statearr_20101;
})();
var statearr_20102_20129 = state_20098__$1;
(statearr_20102_20129[(2)] = null);

(statearr_20102_20129[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (4))){
var inst_20078 = (state_20098[(8)]);
var inst_20078__$1 = (state_20098[(2)]);
var inst_20079 = (inst_20078__$1 == null);
var inst_20080 = cljs.core.not.call(null,inst_20079);
var state_20098__$1 = (function (){var statearr_20103 = state_20098;
(statearr_20103[(8)] = inst_20078__$1);

return statearr_20103;
})();
if(inst_20080){
var statearr_20104_20130 = state_20098__$1;
(statearr_20104_20130[(1)] = (5));

} else {
var statearr_20105_20131 = state_20098__$1;
(statearr_20105_20131[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (6))){
var state_20098__$1 = state_20098;
var statearr_20106_20132 = state_20098__$1;
(statearr_20106_20132[(2)] = null);

(statearr_20106_20132[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (3))){
var inst_20095 = (state_20098[(2)]);
var inst_20096 = cljs.core.async.close_BANG_.call(null,out);
var state_20098__$1 = (function (){var statearr_20107 = state_20098;
(statearr_20107[(9)] = inst_20095);

return statearr_20107;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20098__$1,inst_20096);
} else {
if((state_val_20099 === (2))){
var state_20098__$1 = state_20098;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20098__$1,(4),ch);
} else {
if((state_val_20099 === (11))){
var inst_20078 = (state_20098[(8)]);
var inst_20087 = (state_20098[(2)]);
var inst_20075 = inst_20078;
var state_20098__$1 = (function (){var statearr_20108 = state_20098;
(statearr_20108[(10)] = inst_20087);

(statearr_20108[(7)] = inst_20075);

return statearr_20108;
})();
var statearr_20109_20133 = state_20098__$1;
(statearr_20109_20133[(2)] = null);

(statearr_20109_20133[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (9))){
var inst_20078 = (state_20098[(8)]);
var state_20098__$1 = state_20098;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20098__$1,(11),out,inst_20078);
} else {
if((state_val_20099 === (5))){
var inst_20078 = (state_20098[(8)]);
var inst_20075 = (state_20098[(7)]);
var inst_20082 = cljs.core._EQ_.call(null,inst_20078,inst_20075);
var state_20098__$1 = state_20098;
if(inst_20082){
var statearr_20111_20134 = state_20098__$1;
(statearr_20111_20134[(1)] = (8));

} else {
var statearr_20112_20135 = state_20098__$1;
(statearr_20112_20135[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (10))){
var inst_20090 = (state_20098[(2)]);
var state_20098__$1 = state_20098;
var statearr_20113_20136 = state_20098__$1;
(statearr_20113_20136[(2)] = inst_20090);

(statearr_20113_20136[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20099 === (8))){
var inst_20075 = (state_20098[(7)]);
var tmp20110 = inst_20075;
var inst_20075__$1 = tmp20110;
var state_20098__$1 = (function (){var statearr_20114 = state_20098;
(statearr_20114[(7)] = inst_20075__$1);

return statearr_20114;
})();
var statearr_20115_20137 = state_20098__$1;
(statearr_20115_20137[(2)] = null);

(statearr_20115_20137[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___20127,out))
;
return ((function (switch__9165__auto__,c__9230__auto___20127,out){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_20119 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20119[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_20119[(1)] = (1));

return statearr_20119;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_20098){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_20098);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e20120){if((e20120 instanceof Object)){
var ex__9169__auto__ = e20120;
var statearr_20121_20138 = state_20098;
(statearr_20121_20138[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20098);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20120;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20139 = state_20098;
state_20098 = G__20139;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_20098){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_20098);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___20127,out))
})();
var state__9232__auto__ = (function (){var statearr_20122 = f__9231__auto__.call(null);
(statearr_20122[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___20127);

return statearr_20122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___20127,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args20140 = [];
var len__5627__auto___20210 = arguments.length;
var i__5628__auto___20211 = (0);
while(true){
if((i__5628__auto___20211 < len__5627__auto___20210)){
args20140.push((arguments[i__5628__auto___20211]));

var G__20212 = (i__5628__auto___20211 + (1));
i__5628__auto___20211 = G__20212;
continue;
} else {
}
break;
}

var G__20142 = args20140.length;
switch (G__20142) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20140.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__9230__auto___20214 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___20214,out){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___20214,out){
return (function (state_20180){
var state_val_20181 = (state_20180[(1)]);
if((state_val_20181 === (7))){
var inst_20176 = (state_20180[(2)]);
var state_20180__$1 = state_20180;
var statearr_20182_20215 = state_20180__$1;
(statearr_20182_20215[(2)] = inst_20176);

(statearr_20182_20215[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (1))){
var inst_20143 = (new Array(n));
var inst_20144 = inst_20143;
var inst_20145 = (0);
var state_20180__$1 = (function (){var statearr_20183 = state_20180;
(statearr_20183[(7)] = inst_20145);

(statearr_20183[(8)] = inst_20144);

return statearr_20183;
})();
var statearr_20184_20216 = state_20180__$1;
(statearr_20184_20216[(2)] = null);

(statearr_20184_20216[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (4))){
var inst_20148 = (state_20180[(9)]);
var inst_20148__$1 = (state_20180[(2)]);
var inst_20149 = (inst_20148__$1 == null);
var inst_20150 = cljs.core.not.call(null,inst_20149);
var state_20180__$1 = (function (){var statearr_20185 = state_20180;
(statearr_20185[(9)] = inst_20148__$1);

return statearr_20185;
})();
if(inst_20150){
var statearr_20186_20217 = state_20180__$1;
(statearr_20186_20217[(1)] = (5));

} else {
var statearr_20187_20218 = state_20180__$1;
(statearr_20187_20218[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (15))){
var inst_20170 = (state_20180[(2)]);
var state_20180__$1 = state_20180;
var statearr_20188_20219 = state_20180__$1;
(statearr_20188_20219[(2)] = inst_20170);

(statearr_20188_20219[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (13))){
var state_20180__$1 = state_20180;
var statearr_20189_20220 = state_20180__$1;
(statearr_20189_20220[(2)] = null);

(statearr_20189_20220[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (6))){
var inst_20145 = (state_20180[(7)]);
var inst_20166 = (inst_20145 > (0));
var state_20180__$1 = state_20180;
if(cljs.core.truth_(inst_20166)){
var statearr_20190_20221 = state_20180__$1;
(statearr_20190_20221[(1)] = (12));

} else {
var statearr_20191_20222 = state_20180__$1;
(statearr_20191_20222[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (3))){
var inst_20178 = (state_20180[(2)]);
var state_20180__$1 = state_20180;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20180__$1,inst_20178);
} else {
if((state_val_20181 === (12))){
var inst_20144 = (state_20180[(8)]);
var inst_20168 = cljs.core.vec.call(null,inst_20144);
var state_20180__$1 = state_20180;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20180__$1,(15),out,inst_20168);
} else {
if((state_val_20181 === (2))){
var state_20180__$1 = state_20180;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20180__$1,(4),ch);
} else {
if((state_val_20181 === (11))){
var inst_20160 = (state_20180[(2)]);
var inst_20161 = (new Array(n));
var inst_20144 = inst_20161;
var inst_20145 = (0);
var state_20180__$1 = (function (){var statearr_20192 = state_20180;
(statearr_20192[(10)] = inst_20160);

(statearr_20192[(7)] = inst_20145);

(statearr_20192[(8)] = inst_20144);

return statearr_20192;
})();
var statearr_20193_20223 = state_20180__$1;
(statearr_20193_20223[(2)] = null);

(statearr_20193_20223[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (9))){
var inst_20144 = (state_20180[(8)]);
var inst_20158 = cljs.core.vec.call(null,inst_20144);
var state_20180__$1 = state_20180;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20180__$1,(11),out,inst_20158);
} else {
if((state_val_20181 === (5))){
var inst_20148 = (state_20180[(9)]);
var inst_20153 = (state_20180[(11)]);
var inst_20145 = (state_20180[(7)]);
var inst_20144 = (state_20180[(8)]);
var inst_20152 = (inst_20144[inst_20145] = inst_20148);
var inst_20153__$1 = (inst_20145 + (1));
var inst_20154 = (inst_20153__$1 < n);
var state_20180__$1 = (function (){var statearr_20194 = state_20180;
(statearr_20194[(11)] = inst_20153__$1);

(statearr_20194[(12)] = inst_20152);

return statearr_20194;
})();
if(cljs.core.truth_(inst_20154)){
var statearr_20195_20224 = state_20180__$1;
(statearr_20195_20224[(1)] = (8));

} else {
var statearr_20196_20225 = state_20180__$1;
(statearr_20196_20225[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (14))){
var inst_20173 = (state_20180[(2)]);
var inst_20174 = cljs.core.async.close_BANG_.call(null,out);
var state_20180__$1 = (function (){var statearr_20198 = state_20180;
(statearr_20198[(13)] = inst_20173);

return statearr_20198;
})();
var statearr_20199_20226 = state_20180__$1;
(statearr_20199_20226[(2)] = inst_20174);

(statearr_20199_20226[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (10))){
var inst_20164 = (state_20180[(2)]);
var state_20180__$1 = state_20180;
var statearr_20200_20227 = state_20180__$1;
(statearr_20200_20227[(2)] = inst_20164);

(statearr_20200_20227[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (8))){
var inst_20153 = (state_20180[(11)]);
var inst_20144 = (state_20180[(8)]);
var tmp20197 = inst_20144;
var inst_20144__$1 = tmp20197;
var inst_20145 = inst_20153;
var state_20180__$1 = (function (){var statearr_20201 = state_20180;
(statearr_20201[(7)] = inst_20145);

(statearr_20201[(8)] = inst_20144__$1);

return statearr_20201;
})();
var statearr_20202_20228 = state_20180__$1;
(statearr_20202_20228[(2)] = null);

(statearr_20202_20228[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___20214,out))
;
return ((function (switch__9165__auto__,c__9230__auto___20214,out){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_20206 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20206[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_20206[(1)] = (1));

return statearr_20206;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_20180){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_20180);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e20207){if((e20207 instanceof Object)){
var ex__9169__auto__ = e20207;
var statearr_20208_20229 = state_20180;
(statearr_20208_20229[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20180);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20207;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20230 = state_20180;
state_20180 = G__20230;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_20180){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_20180);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___20214,out))
})();
var state__9232__auto__ = (function (){var statearr_20209 = f__9231__auto__.call(null);
(statearr_20209[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___20214);

return statearr_20209;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___20214,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args20231 = [];
var len__5627__auto___20305 = arguments.length;
var i__5628__auto___20306 = (0);
while(true){
if((i__5628__auto___20306 < len__5627__auto___20305)){
args20231.push((arguments[i__5628__auto___20306]));

var G__20307 = (i__5628__auto___20306 + (1));
i__5628__auto___20306 = G__20307;
continue;
} else {
}
break;
}

var G__20233 = args20231.length;
switch (G__20233) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20231.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__9230__auto___20309 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___20309,out){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___20309,out){
return (function (state_20275){
var state_val_20276 = (state_20275[(1)]);
if((state_val_20276 === (7))){
var inst_20271 = (state_20275[(2)]);
var state_20275__$1 = state_20275;
var statearr_20277_20310 = state_20275__$1;
(statearr_20277_20310[(2)] = inst_20271);

(statearr_20277_20310[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20276 === (1))){
var inst_20234 = [];
var inst_20235 = inst_20234;
var inst_20236 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_20275__$1 = (function (){var statearr_20278 = state_20275;
(statearr_20278[(7)] = inst_20235);

(statearr_20278[(8)] = inst_20236);

return statearr_20278;
})();
var statearr_20279_20311 = state_20275__$1;
(statearr_20279_20311[(2)] = null);

(statearr_20279_20311[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20276 === (4))){
var inst_20239 = (state_20275[(9)]);
var inst_20239__$1 = (state_20275[(2)]);
var inst_20240 = (inst_20239__$1 == null);
var inst_20241 = cljs.core.not.call(null,inst_20240);
var state_20275__$1 = (function (){var statearr_20280 = state_20275;
(statearr_20280[(9)] = inst_20239__$1);

return statearr_20280;
})();
if(inst_20241){
var statearr_20281_20312 = state_20275__$1;
(statearr_20281_20312[(1)] = (5));

} else {
var statearr_20282_20313 = state_20275__$1;
(statearr_20282_20313[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20276 === (15))){
var inst_20265 = (state_20275[(2)]);
var state_20275__$1 = state_20275;
var statearr_20283_20314 = state_20275__$1;
(statearr_20283_20314[(2)] = inst_20265);

(statearr_20283_20314[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20276 === (13))){
var state_20275__$1 = state_20275;
var statearr_20284_20315 = state_20275__$1;
(statearr_20284_20315[(2)] = null);

(statearr_20284_20315[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20276 === (6))){
var inst_20235 = (state_20275[(7)]);
var inst_20260 = inst_20235.length;
var inst_20261 = (inst_20260 > (0));
var state_20275__$1 = state_20275;
if(cljs.core.truth_(inst_20261)){
var statearr_20285_20316 = state_20275__$1;
(statearr_20285_20316[(1)] = (12));

} else {
var statearr_20286_20317 = state_20275__$1;
(statearr_20286_20317[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20276 === (3))){
var inst_20273 = (state_20275[(2)]);
var state_20275__$1 = state_20275;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20275__$1,inst_20273);
} else {
if((state_val_20276 === (12))){
var inst_20235 = (state_20275[(7)]);
var inst_20263 = cljs.core.vec.call(null,inst_20235);
var state_20275__$1 = state_20275;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20275__$1,(15),out,inst_20263);
} else {
if((state_val_20276 === (2))){
var state_20275__$1 = state_20275;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20275__$1,(4),ch);
} else {
if((state_val_20276 === (11))){
var inst_20243 = (state_20275[(10)]);
var inst_20239 = (state_20275[(9)]);
var inst_20253 = (state_20275[(2)]);
var inst_20254 = [];
var inst_20255 = inst_20254.push(inst_20239);
var inst_20235 = inst_20254;
var inst_20236 = inst_20243;
var state_20275__$1 = (function (){var statearr_20287 = state_20275;
(statearr_20287[(7)] = inst_20235);

(statearr_20287[(11)] = inst_20255);

(statearr_20287[(8)] = inst_20236);

(statearr_20287[(12)] = inst_20253);

return statearr_20287;
})();
var statearr_20288_20318 = state_20275__$1;
(statearr_20288_20318[(2)] = null);

(statearr_20288_20318[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20276 === (9))){
var inst_20235 = (state_20275[(7)]);
var inst_20251 = cljs.core.vec.call(null,inst_20235);
var state_20275__$1 = state_20275;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20275__$1,(11),out,inst_20251);
} else {
if((state_val_20276 === (5))){
var inst_20243 = (state_20275[(10)]);
var inst_20236 = (state_20275[(8)]);
var inst_20239 = (state_20275[(9)]);
var inst_20243__$1 = f.call(null,inst_20239);
var inst_20244 = cljs.core._EQ_.call(null,inst_20243__$1,inst_20236);
var inst_20245 = cljs.core.keyword_identical_QMARK_.call(null,inst_20236,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_20246 = (inst_20244) || (inst_20245);
var state_20275__$1 = (function (){var statearr_20289 = state_20275;
(statearr_20289[(10)] = inst_20243__$1);

return statearr_20289;
})();
if(cljs.core.truth_(inst_20246)){
var statearr_20290_20319 = state_20275__$1;
(statearr_20290_20319[(1)] = (8));

} else {
var statearr_20291_20320 = state_20275__$1;
(statearr_20291_20320[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20276 === (14))){
var inst_20268 = (state_20275[(2)]);
var inst_20269 = cljs.core.async.close_BANG_.call(null,out);
var state_20275__$1 = (function (){var statearr_20293 = state_20275;
(statearr_20293[(13)] = inst_20268);

return statearr_20293;
})();
var statearr_20294_20321 = state_20275__$1;
(statearr_20294_20321[(2)] = inst_20269);

(statearr_20294_20321[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20276 === (10))){
var inst_20258 = (state_20275[(2)]);
var state_20275__$1 = state_20275;
var statearr_20295_20322 = state_20275__$1;
(statearr_20295_20322[(2)] = inst_20258);

(statearr_20295_20322[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20276 === (8))){
var inst_20235 = (state_20275[(7)]);
var inst_20243 = (state_20275[(10)]);
var inst_20239 = (state_20275[(9)]);
var inst_20248 = inst_20235.push(inst_20239);
var tmp20292 = inst_20235;
var inst_20235__$1 = tmp20292;
var inst_20236 = inst_20243;
var state_20275__$1 = (function (){var statearr_20296 = state_20275;
(statearr_20296[(14)] = inst_20248);

(statearr_20296[(7)] = inst_20235__$1);

(statearr_20296[(8)] = inst_20236);

return statearr_20296;
})();
var statearr_20297_20323 = state_20275__$1;
(statearr_20297_20323[(2)] = null);

(statearr_20297_20323[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___20309,out))
;
return ((function (switch__9165__auto__,c__9230__auto___20309,out){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_20301 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20301[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_20301[(1)] = (1));

return statearr_20301;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_20275){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_20275);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e20302){if((e20302 instanceof Object)){
var ex__9169__auto__ = e20302;
var statearr_20303_20324 = state_20275;
(statearr_20303_20324[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20275);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20302;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20325 = state_20275;
state_20275 = G__20325;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_20275){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_20275);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___20309,out))
})();
var state__9232__auto__ = (function (){var statearr_20304 = f__9231__auto__.call(null);
(statearr_20304[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___20309);

return statearr_20304;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___20309,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
