// Compiled by ClojureScript 1.7.145 {}
goog.provide('c2.dom');
goog.require('cljs.core');
goog.require('goog.dom.forms');
goog.require('goog.dom');
goog.require('goog.dom.classes');
goog.require('singult.core');
goog.require('goog.style');
goog.require('clojure.string');
Element.prototype.matchesSelector = Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || Element.prototype.oMatchesSelector;
if(cljs.core.truth_(typeof NodeList != "undefined")){
NodeList.prototype.cljs$core$ISeqable$ = true;

NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});
} else {
}
HTMLCollection.prototype.cljs$core$ISeqable$ = true;

HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});
c2.dom.select;

/**
 * @interface
 */
c2.dom.IDom = function(){};

/**
 * Converts x to a live DOM node
 */
c2.dom.__GT_dom = (function c2$dom$__GT_dom(x){
if((!((x == null))) && (!((x.c2$dom$IDom$__GT_dom$arity$1 == null)))){
return x.c2$dom$IDom$__GT_dom$arity$1(x);
} else {
var x__5224__auto__ = (((x == null))?null:x);
var m__5225__auto__ = (c2.dom.__GT_dom[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,x);
} else {
var m__5225__auto____$1 = (c2.dom.__GT_dom["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,x);
} else {
throw cljs.core.missing_protocol.call(null,"IDom.->dom",x);
}
}
}
});

(c2.dom.IDom["string"] = true);

(c2.dom.__GT_dom["string"] = (function (selector){
return c2.dom.select.call(null,selector);
}));

cljs.core.PersistentVector.prototype.c2$dom$IDom$ = true;

cljs.core.PersistentVector.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (v){
var v__$1 = this;
return singult.core.render.call(null,v__$1);
});
if(cljs.core.truth_(typeof Node != "undefined")){
Node.prototype.c2$dom$IDom$ = true;

Node.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (node){
var node__$1 = this;
return node__$1;
});
} else {
}
/**
 * Select a single DOM node via CSS selector, optionally scoped by second arg.
 */
c2.dom.select = (function c2$dom$select(var_args){
var args23997 = [];
var len__5627__auto___24000 = arguments.length;
var i__5628__auto___24001 = (0);
while(true){
if((i__5628__auto___24001 < len__5627__auto___24000)){
args23997.push((arguments[i__5628__auto___24001]));

var G__24002 = (i__5628__auto___24001 + (1));
i__5628__auto___24001 = G__24002;
continue;
} else {
}
break;
}

var G__23999 = args23997.length;
switch (G__23999) {
case 1:
return c2.dom.select.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23997.length)].join('')));

}
});

c2.dom.select.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelector(selector);
});

c2.dom.select.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom.call(null,container).querySelector(selector);
});

c2.dom.select.cljs$lang$maxFixedArity = 2;
/**
 * Like select, but returns a collection of nodes.
 */
c2.dom.select_all = (function c2$dom$select_all(var_args){
var args24004 = [];
var len__5627__auto___24007 = arguments.length;
var i__5628__auto___24008 = (0);
while(true){
if((i__5628__auto___24008 < len__5627__auto___24007)){
args24004.push((arguments[i__5628__auto___24008]));

var G__24009 = (i__5628__auto___24008 + (1));
i__5628__auto___24008 = G__24009;
continue;
} else {
}
break;
}

var G__24006 = args24004.length;
switch (G__24006) {
case 1:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24004.length)].join('')));

}
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelectorAll(selector);
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom.call(null,container).querySelectorAll(selector);
});

c2.dom.select_all.cljs$lang$maxFixedArity = 2;
/**
 * Does live `node` match CSS `selector`?
 */
c2.dom.matches_selector_QMARK_ = (function c2$dom$matches_selector_QMARK_(node,selector){
if(cljs.core.truth_(node)){
return node.matchesSelector(selector);
} else {
return null;
}
});
/**
 * Return the children of a live DOM element.
 */
c2.dom.children = (function c2$dom$children(node){
if(cljs.core.truth_(node)){
return c2.dom.__GT_dom.call(null,node).children;
} else {
return null;
}
});
/**
 * Return parent of a live DOM node.
 */
c2.dom.parent = (function c2$dom$parent(node){
if(cljs.core.truth_(c2$dom$parent)){
return c2.dom.__GT_dom.call(null,node).parentNode;
} else {
return null;
}
});
/**
 * Make element last child of container.
 * Returns live child.
 */
c2.dom.append_BANG_ = (function c2$dom$append_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.appendChild(c2.dom.__GT_dom.call(null,container),el__$1);

return el__$1;
});
/**
 * Make element first child of container.
 * Returns live DOM child.
 */
c2.dom.prepend_BANG_ = (function c2$dom$prepend_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.insertChildAt(c2.dom.__GT_dom.call(null,container),el__$1,(0));

return el__$1;
});
/**
 * Remove element from DOM and return it.
 * > *el* CSS selector or live DOM node
 */
c2.dom.remove_BANG_ = (function c2$dom$remove_BANG_(el){
return goog.dom.removeNode(c2.dom.__GT_dom.call(null,el));
});
/**
 * Replace live DOM node with a new one, returning the latter.
 * > *old* CSS selector or live DOM node
 * > *new* CSS selector, live DOM node, or hiccup vector
 */
c2.dom.replace_BANG_ = (function c2$dom$replace_BANG_(old,new$){
var new$__$1 = c2.dom.__GT_dom.call(null,new$);
goog.dom.replaceNode(new$__$1,c2.dom.__GT_dom.call(null,old));

return new$__$1;
});
/**
 * Get or set inline element style.
 * 
 * `(style el)`                map of inline element styles
 * 
 * `(style el :keyword)`       value of style :keyword
 * 
 * `(style el {:keyword val})` sets inline style according to map, returns element
 * 
 * `(style el :keyword val)`   sets single style, returns element
 */
c2.dom.style = (function c2$dom$style(var_args){
var args24011 = [];
var len__5627__auto___24020 = arguments.length;
var i__5628__auto___24021 = (0);
while(true){
if((i__5628__auto___24021 < len__5627__auto___24020)){
args24011.push((arguments[i__5628__auto___24021]));

var G__24022 = (i__5628__auto___24021 + (1));
i__5628__auto___24021 = G__24022;
continue;
} else {
}
break;
}

var G__24013 = args24011.length;
switch (G__24013) {
case 1:
return c2.dom.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.style.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24011.length)].join('')));

}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$1 = (function (el){
throw (new Error("TODO: return map of element styles"));
});

c2.dom.style.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((x instanceof cljs.core.Keyword)){
return goog.style.getComputedStyle(el__$1,cljs.core.name.call(null,x));
} else {
if(cljs.core.map_QMARK_.call(null,x)){
var seq__24014_24024 = cljs.core.seq.call(null,x);
var chunk__24015_24025 = null;
var count__24016_24026 = (0);
var i__24017_24027 = (0);
while(true){
if((i__24017_24027 < count__24016_24026)){
var vec__24018_24028 = cljs.core._nth.call(null,chunk__24015_24025,i__24017_24027);
var k_24029 = cljs.core.nth.call(null,vec__24018_24028,(0),null);
var v_24030 = cljs.core.nth.call(null,vec__24018_24028,(1),null);
c2.dom.style.call(null,el__$1,k_24029,v_24030);

var G__24031 = seq__24014_24024;
var G__24032 = chunk__24015_24025;
var G__24033 = count__24016_24026;
var G__24034 = (i__24017_24027 + (1));
seq__24014_24024 = G__24031;
chunk__24015_24025 = G__24032;
count__24016_24026 = G__24033;
i__24017_24027 = G__24034;
continue;
} else {
var temp__4425__auto___24035 = cljs.core.seq.call(null,seq__24014_24024);
if(temp__4425__auto___24035){
var seq__24014_24036__$1 = temp__4425__auto___24035;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__24014_24036__$1)){
var c__5372__auto___24037 = cljs.core.chunk_first.call(null,seq__24014_24036__$1);
var G__24038 = cljs.core.chunk_rest.call(null,seq__24014_24036__$1);
var G__24039 = c__5372__auto___24037;
var G__24040 = cljs.core.count.call(null,c__5372__auto___24037);
var G__24041 = (0);
seq__24014_24024 = G__24038;
chunk__24015_24025 = G__24039;
count__24016_24026 = G__24040;
i__24017_24027 = G__24041;
continue;
} else {
var vec__24019_24042 = cljs.core.first.call(null,seq__24014_24036__$1);
var k_24043 = cljs.core.nth.call(null,vec__24019_24042,(0),null);
var v_24044 = cljs.core.nth.call(null,vec__24019_24042,(1),null);
c2.dom.style.call(null,el__$1,k_24043,v_24044);

var G__24045 = cljs.core.next.call(null,seq__24014_24036__$1);
var G__24046 = null;
var G__24047 = (0);
var G__24048 = (0);
seq__24014_24024 = G__24045;
chunk__24015_24025 = G__24046;
count__24016_24026 = G__24047;
i__24017_24027 = G__24048;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
goog.style.setStyle(c2.dom.__GT_dom.call(null,el),cljs.core.name.call(null,k),((typeof v === 'string')?v:((typeof v === 'number')?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"bottom","bottom",-1550509018),null,new cljs.core.Keyword(null,"top","top",-1856271961),null,new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"right","right",-452581833),null,new cljs.core.Keyword(null,"height","height",1025178622),null,new cljs.core.Keyword(null,"left","left",-399115937),null], null), null).call(null,cljs.core.keyword.call(null,k)))?[cljs.core.str(v),cljs.core.str("px")].join(''):v):null)));

return el;
});

c2.dom.style.cljs$lang$maxFixedArity = 3;
/**
 * Get or set element attributes.
 * 
 * `(attr el)`                map of element attributes
 * 
 * `(attr el :keyword)`       value of attr :keyword
 * 
 * `(attr el {:keyword val})` sets element attributes according to map, returns element
 * 
 * `(attr el :keyword val)`   sets single attr, returns element
 */
c2.dom.attr = (function c2$dom$attr(var_args){
var args24049 = [];
var len__5627__auto___24062 = arguments.length;
var i__5628__auto___24063 = (0);
while(true){
if((i__5628__auto___24063 < len__5627__auto___24062)){
args24049.push((arguments[i__5628__auto___24063]));

var G__24064 = (i__5628__auto___24063 + (1));
i__5628__auto___24063 = G__24064;
continue;
} else {
}
break;
}

var G__24051 = args24049.length;
switch (G__24051) {
case 1:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24049.length)].join('')));

}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$1 = (function (el){
var attrs = c2.dom.__GT_dom.call(null,el).attributes;
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5341__auto__ = ((function (attrs){
return (function c2$dom$iter__24052(s__24053){
return (new cljs.core.LazySeq(null,((function (attrs){
return (function (){
var s__24053__$1 = s__24053;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__24053__$1);
if(temp__4425__auto__){
var s__24053__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__24053__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__24053__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__24055 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__24054 = (0);
while(true){
if((i__24054 < size__5340__auto__)){
var i = cljs.core._nth.call(null,c__5339__auto__,i__24054);
cljs.core.chunk_append.call(null,b__24055,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,(attrs[i]).name),(attrs[i]).value], null));

var G__24066 = (i__24054 + (1));
i__24054 = G__24066;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__24055),c2$dom$iter__24052.call(null,cljs.core.chunk_rest.call(null,s__24053__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__24055),null);
}
} else {
var i = cljs.core.first.call(null,s__24053__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,(attrs[i]).name),(attrs[i]).value], null),c2$dom$iter__24052.call(null,cljs.core.rest.call(null,s__24053__$2)));
}
} else {
return null;
}
break;
}
});})(attrs))
,null,null));
});})(attrs))
;
return iter__5341__auto__.call(null,cljs.core.range.call(null,attrs.length));
})());
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((x instanceof cljs.core.Keyword)){
return el__$1.getAttribute(cljs.core.name.call(null,x));
} else {
if(cljs.core.map_QMARK_.call(null,x)){
var seq__24056_24067 = cljs.core.seq.call(null,x);
var chunk__24057_24068 = null;
var count__24058_24069 = (0);
var i__24059_24070 = (0);
while(true){
if((i__24059_24070 < count__24058_24069)){
var vec__24060_24071 = cljs.core._nth.call(null,chunk__24057_24068,i__24059_24070);
var k_24072 = cljs.core.nth.call(null,vec__24060_24071,(0),null);
var v_24073 = cljs.core.nth.call(null,vec__24060_24071,(1),null);
c2.dom.attr.call(null,el__$1,k_24072,v_24073);

var G__24074 = seq__24056_24067;
var G__24075 = chunk__24057_24068;
var G__24076 = count__24058_24069;
var G__24077 = (i__24059_24070 + (1));
seq__24056_24067 = G__24074;
chunk__24057_24068 = G__24075;
count__24058_24069 = G__24076;
i__24059_24070 = G__24077;
continue;
} else {
var temp__4425__auto___24078 = cljs.core.seq.call(null,seq__24056_24067);
if(temp__4425__auto___24078){
var seq__24056_24079__$1 = temp__4425__auto___24078;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__24056_24079__$1)){
var c__5372__auto___24080 = cljs.core.chunk_first.call(null,seq__24056_24079__$1);
var G__24081 = cljs.core.chunk_rest.call(null,seq__24056_24079__$1);
var G__24082 = c__5372__auto___24080;
var G__24083 = cljs.core.count.call(null,c__5372__auto___24080);
var G__24084 = (0);
seq__24056_24067 = G__24081;
chunk__24057_24068 = G__24082;
count__24058_24069 = G__24083;
i__24059_24070 = G__24084;
continue;
} else {
var vec__24061_24085 = cljs.core.first.call(null,seq__24056_24079__$1);
var k_24086 = cljs.core.nth.call(null,vec__24061_24085,(0),null);
var v_24087 = cljs.core.nth.call(null,vec__24061_24085,(1),null);
c2.dom.attr.call(null,el__$1,k_24086,v_24087);

var G__24088 = cljs.core.next.call(null,seq__24056_24079__$1);
var G__24089 = null;
var G__24090 = (0);
var G__24091 = (0);
seq__24056_24067 = G__24088;
chunk__24057_24068 = G__24089;
count__24058_24069 = G__24090;
i__24059_24070 = G__24091;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((v == null)){
el__$1.removeAttribute(cljs.core.name.call(null,k));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"style","style",-496642736),k)){
c2.dom.style.call(null,el__$1,v);
} else {
el__$1.setAttribute(cljs.core.name.call(null,k),v);
}
}

return el__$1;
});

c2.dom.attr.cljs$lang$maxFixedArity = 3;
/**
 * Get or set element text, returning element
 */
c2.dom.text = (function c2$dom$text(var_args){
var args24092 = [];
var len__5627__auto___24095 = arguments.length;
var i__5628__auto___24096 = (0);
while(true){
if((i__5628__auto___24096 < len__5627__auto___24095)){
args24092.push((arguments[i__5628__auto___24096]));

var G__24097 = (i__5628__auto___24096 + (1));
i__5628__auto___24096 = G__24097;
continue;
} else {
}
break;
}

var G__24094 = args24092.length;
switch (G__24094) {
case 1:
return c2.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24092.length)].join('')));

}
});

c2.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.getTextContent(c2.dom.__GT_dom.call(null,el));
});

c2.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.setTextContent(el__$1,v);

return el__$1;
});

c2.dom.text.cljs$lang$maxFixedArity = 2;
/**
 * Get or set element value.
 */
c2.dom.val = (function c2$dom$val(var_args){
var args24099 = [];
var len__5627__auto___24102 = arguments.length;
var i__5628__auto___24103 = (0);
while(true){
if((i__5628__auto___24103 < len__5627__auto___24102)){
args24099.push((arguments[i__5628__auto___24103]));

var G__24104 = (i__5628__auto___24103 + (1));
i__5628__auto___24103 = G__24104;
continue;
} else {
}
break;
}

var G__24101 = args24099.length;
switch (G__24101) {
case 1:
return c2.dom.val.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.val.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24099.length)].join('')));

}
});

c2.dom.val.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.forms.getValue(c2.dom.__GT_dom.call(null,el));
});

c2.dom.val.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.forms.setValue(el__$1,v);

return el__$1;
});

c2.dom.val.cljs$lang$maxFixedArity = 2;
/**
 * Add or remove `class` to element based on boolean `classed?`, returning element.
 */
c2.dom.classed_BANG_ = (function c2$dom$classed_BANG_(el,class$,classed_QMARK_){
goog.dom.classes.enable(c2.dom.__GT_dom.call(null,el),cljs.core.name.call(null,class$),classed_QMARK_);

return el;
});
c2.dom.add_class_BANG_ = (function c2$dom$add_class_BANG_(el,class$){
return c2.dom.classed_BANG_.call(null,el,class$,true);
});
c2.dom.remove_class_BANG_ = (function c2$dom$remove_class_BANG_(el,class$){
return c2.dom.classed_BANG_.call(null,el,class$,false);
});
c2.dom.request_animation_frame = (function (){var or__4569__auto__ = window.requestAnimationFrame;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
var or__4569__auto____$1 = window.webkitRequestAnimationFrame;
if(cljs.core.truth_(or__4569__auto____$1)){
return or__4569__auto____$1;
} else {
return ((function (or__4569__auto____$1,or__4569__auto__){
return (function (p1__24106_SHARP_){
return setTimeout(((function (or__4569__auto____$1,or__4569__auto__){
return (function (){
return p1__24106_SHARP_.call(null);
});})(or__4569__auto____$1,or__4569__auto__))
,(10));
});
;})(or__4569__auto____$1,or__4569__auto__))
}
}
})();
