// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__42035__delegate = function (args){
if(cljs.core.map_QMARK_(cljs.core.first(args))){
var vec__42034 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,cljs.core.rest(args));
var tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42034,(0),null);
var body = cljs.core.nthnext(vec__42034,(1));
if(cljs.core.map_QMARK_(cljs.core.first(body))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.vector,tag,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.first(body),cljs.core.first(args)], 0)),cljs.core.rest(body));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.vector,tag,cljs.core.first(args),body);
}
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,args);
}
};
var G__42035 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__42036__i = 0, G__42036__a = new Array(arguments.length -  0);
while (G__42036__i < G__42036__a.length) {G__42036__a[G__42036__i] = arguments[G__42036__i + 0]; ++G__42036__i;}
  args = new cljs.core.IndexedSeq(G__42036__a,0);
} 
return G__42035__delegate.call(this,args);};
G__42035.cljs$lang$maxFixedArity = 0;
G__42035.cljs$lang$applyTo = (function (arglist__42037){
var args = cljs.core.seq(arglist__42037);
return G__42035__delegate(args);
});
G__42035.cljs$core$IFn$_invoke$arity$variadic = G__42035__delegate;
return G__42035;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__5341__auto__ = (function sablono$core$update_arglists_$_iter__42044(s__42045){
return (new cljs.core.LazySeq(null,(function (){
var s__42045__$1 = s__42045;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__42045__$1);
if(temp__4425__auto__){
var s__42045__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__42045__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__42045__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__42047 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__42046 = (0);
while(true){
if((i__42046 < size__5340__auto__)){
var args = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__42046);
cljs.core.chunk_append(b__42047,cljs.core.vec(cljs.core.cons(cljs.core.cst$sym$attr_DASH_map_QMARK_,args)));

var G__42050 = (i__42046 + (1));
i__42046 = G__42050;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__42047),sablono$core$update_arglists_$_iter__42044(cljs.core.chunk_rest(s__42045__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__42047),null);
}
} else {
var args = cljs.core.first(s__42045__$2);
return cljs.core.cons(cljs.core.vec(cljs.core.cons(cljs.core.cst$sym$attr_DASH_map_QMARK_,args)),sablono$core$update_arglists_$_iter__42044(cljs.core.rest(s__42045__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__5634__auto__ = [];
var len__5627__auto___42058 = arguments.length;
var i__5628__auto___42059 = (0);
while(true){
if((i__5628__auto___42059 < len__5627__auto___42058)){
args__5634__auto__.push((arguments[i__5628__auto___42059]));

var G__42060 = (i__5628__auto___42059 + (1));
i__5628__auto___42059 = G__42060;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__5341__auto__ = (function sablono$core$iter__42052(s__42053){
return (new cljs.core.LazySeq(null,(function (){
var s__42053__$1 = s__42053;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__42053__$1);
if(temp__4425__auto__){
var s__42053__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__42053__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__42053__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__42055 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__42054 = (0);
while(true){
if((i__42054 < size__5340__auto__)){
var style = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__42054);
cljs.core.chunk_append(b__42055,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$link,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"text/css",cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([style], 0)),cljs.core.cst$kw$rel,"stylesheet"], null)], null));

var G__42061 = (i__42054 + (1));
i__42054 = G__42061;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__42055),sablono$core$iter__42052(cljs.core.chunk_rest(s__42053__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__42055),null);
}
} else {
var style = cljs.core.first(s__42053__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$link,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"text/css",cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([style], 0)),cljs.core.cst$kw$rel,"stylesheet"], null)], null),sablono$core$iter__42052(cljs.core.rest(s__42053__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq42051){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42051));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
var G__42066 = goog.dom.getDocument().body;
var G__42067 = (function (){var G__42068 = "script";
var G__42069 = {"src": src};
return goog.dom.createDom(G__42068,G__42069);
})();
return goog.dom.appendChild(G__42066,G__42067);
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js("http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to42070 = (function sablono$core$link_to42070(var_args){
var args__5634__auto__ = [];
var len__5627__auto___42073 = arguments.length;
var i__5628__auto___42074 = (0);
while(true){
if((i__5628__auto___42074 < len__5627__auto___42073)){
args__5634__auto__.push((arguments[i__5628__auto___42074]));

var G__42075 = (i__5628__auto___42074 + (1));
i__5628__auto___42074 = G__42075;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return sablono.core.link_to42070.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

sablono.core.link_to42070.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([url], 0))], null),content], null);
});

sablono.core.link_to42070.cljs$lang$maxFixedArity = (1);

sablono.core.link_to42070.cljs$lang$applyTo = (function (seq42071){
var G__42072 = cljs.core.first(seq42071);
var seq42071__$1 = cljs.core.next(seq42071);
return sablono.core.link_to42070.cljs$core$IFn$_invoke$arity$variadic(G__42072,seq42071__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs(sablono.core.link_to42070);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to42076 = (function sablono$core$mail_to42076(var_args){
var args__5634__auto__ = [];
var len__5627__auto___42081 = arguments.length;
var i__5628__auto___42082 = (0);
while(true){
if((i__5628__auto___42082 < len__5627__auto___42081)){
args__5634__auto__.push((arguments[i__5628__auto___42082]));

var G__42083 = (i__5628__auto___42082 + (1));
i__5628__auto___42082 = G__42083;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return sablono.core.mail_to42076.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

sablono.core.mail_to42076.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__42079){
var vec__42080 = p__42079;
var content = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42080,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__4569__auto__ = content;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to42076.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to42076.cljs$lang$applyTo = (function (seq42077){
var G__42078 = cljs.core.first(seq42077);
var seq42077__$1 = cljs.core.next(seq42077);
return sablono.core.mail_to42076.cljs$core$IFn$_invoke$arity$variadic(G__42078,seq42077__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs(sablono.core.mail_to42076);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list42084 = (function sablono$core$unordered_list42084(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,(function (){var iter__5341__auto__ = (function sablono$core$unordered_list42084_$_iter__42091(s__42092){
return (new cljs.core.LazySeq(null,(function (){
var s__42092__$1 = s__42092;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__42092__$1);
if(temp__4425__auto__){
var s__42092__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__42092__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__42092__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__42094 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__42093 = (0);
while(true){
if((i__42093 < size__5340__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__42093);
cljs.core.chunk_append(b__42094,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null));

var G__42097 = (i__42093 + (1));
i__42093 = G__42097;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__42094),sablono$core$unordered_list42084_$_iter__42091(cljs.core.chunk_rest(s__42092__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__42094),null);
}
} else {
var x = cljs.core.first(s__42092__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null),sablono$core$unordered_list42084_$_iter__42091(cljs.core.rest(s__42092__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs(sablono.core.unordered_list42084);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list42098 = (function sablono$core$ordered_list42098(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ol,(function (){var iter__5341__auto__ = (function sablono$core$ordered_list42098_$_iter__42105(s__42106){
return (new cljs.core.LazySeq(null,(function (){
var s__42106__$1 = s__42106;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__42106__$1);
if(temp__4425__auto__){
var s__42106__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__42106__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__42106__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__42108 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__42107 = (0);
while(true){
if((i__42107 < size__5340__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__42107);
cljs.core.chunk_append(b__42108,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null));

var G__42111 = (i__42107 + (1));
i__42107 = G__42111;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__42108),sablono$core$ordered_list42098_$_iter__42105(cljs.core.chunk_rest(s__42106__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__42108),null);
}
} else {
var x = cljs.core.first(s__42106__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null),sablono$core$ordered_list42098_$_iter__42105(cljs.core.rest(s__42106__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs(sablono.core.ordered_list42098);
/**
 * Create an image element.
 */
sablono.core.image42112 = (function sablono$core$image42112(var_args){
var args42113 = [];
var len__5627__auto___42116 = arguments.length;
var i__5628__auto___42117 = (0);
while(true){
if((i__5628__auto___42117 < len__5627__auto___42116)){
args42113.push((arguments[i__5628__auto___42117]));

var G__42118 = (i__5628__auto___42117 + (1));
i__5628__auto___42117 = G__42118;
continue;
} else {
}
break;
}

var G__42115 = args42113.length;
switch (G__42115) {
case 1:
return sablono.core.image42112.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image42112.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42113.length)].join('')));

}
});

sablono.core.image42112.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$src,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([src], 0))], null)], null);
});

sablono.core.image42112.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$src,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([src], 0)),cljs.core.cst$kw$alt,alt], null)], null);
});

sablono.core.image42112.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs(sablono.core.image42112);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__42120_SHARP_,p2__42121_SHARP_){
return [cljs.core.str(p1__42120_SHARP_),cljs.core.str("["),cljs.core.str(p2__42121_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([name], 0))));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__42122_SHARP_,p2__42123_SHARP_){
return [cljs.core.str(p1__42122_SHARP_),cljs.core.str("-"),cljs.core.str(p2__42123_SHARP_)].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([name], 0))));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,type,cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field42124 = (function sablono$core$color_field42124(var_args){
var args42125 = [];
var len__5627__auto___42192 = arguments.length;
var i__5628__auto___42193 = (0);
while(true){
if((i__5628__auto___42193 < len__5627__auto___42192)){
args42125.push((arguments[i__5628__auto___42193]));

var G__42194 = (i__5628__auto___42193 + (1));
i__5628__auto___42193 = G__42194;
continue;
} else {
}
break;
}

var G__42127 = args42125.length;
switch (G__42127) {
case 1:
return sablono.core.color_field42124.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field42124.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42125.length)].join('')));

}
});

sablono.core.color_field42124.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.color_field42124.cljs$core$IFn$_invoke$arity$2(name__7494__auto__,null);
});

sablono.core.color_field42124.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$color)].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.color_field42124.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs(sablono.core.color_field42124);

/**
 * Creates a date input field.
 */
sablono.core.date_field42128 = (function sablono$core$date_field42128(var_args){
var args42129 = [];
var len__5627__auto___42196 = arguments.length;
var i__5628__auto___42197 = (0);
while(true){
if((i__5628__auto___42197 < len__5627__auto___42196)){
args42129.push((arguments[i__5628__auto___42197]));

var G__42198 = (i__5628__auto___42197 + (1));
i__5628__auto___42197 = G__42198;
continue;
} else {
}
break;
}

var G__42131 = args42129.length;
switch (G__42131) {
case 1:
return sablono.core.date_field42128.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field42128.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42129.length)].join('')));

}
});

sablono.core.date_field42128.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.date_field42128.cljs$core$IFn$_invoke$arity$2(name__7494__auto__,null);
});

sablono.core.date_field42128.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$date)].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.date_field42128.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs(sablono.core.date_field42128);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field42132 = (function sablono$core$datetime_field42132(var_args){
var args42133 = [];
var len__5627__auto___42200 = arguments.length;
var i__5628__auto___42201 = (0);
while(true){
if((i__5628__auto___42201 < len__5627__auto___42200)){
args42133.push((arguments[i__5628__auto___42201]));

var G__42202 = (i__5628__auto___42201 + (1));
i__5628__auto___42201 = G__42202;
continue;
} else {
}
break;
}

var G__42135 = args42133.length;
switch (G__42135) {
case 1:
return sablono.core.datetime_field42132.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field42132.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42133.length)].join('')));

}
});

sablono.core.datetime_field42132.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.datetime_field42132.cljs$core$IFn$_invoke$arity$2(name__7494__auto__,null);
});

sablono.core.datetime_field42132.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$datetime)].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.datetime_field42132.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs(sablono.core.datetime_field42132);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field42136 = (function sablono$core$datetime_local_field42136(var_args){
var args42137 = [];
var len__5627__auto___42204 = arguments.length;
var i__5628__auto___42205 = (0);
while(true){
if((i__5628__auto___42205 < len__5627__auto___42204)){
args42137.push((arguments[i__5628__auto___42205]));

var G__42206 = (i__5628__auto___42205 + (1));
i__5628__auto___42205 = G__42206;
continue;
} else {
}
break;
}

var G__42139 = args42137.length;
switch (G__42139) {
case 1:
return sablono.core.datetime_local_field42136.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field42136.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42137.length)].join('')));

}
});

sablono.core.datetime_local_field42136.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.datetime_local_field42136.cljs$core$IFn$_invoke$arity$2(name__7494__auto__,null);
});

sablono.core.datetime_local_field42136.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$datetime_DASH_local)].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.datetime_local_field42136.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs(sablono.core.datetime_local_field42136);

/**
 * Creates a email input field.
 */
sablono.core.email_field42140 = (function sablono$core$email_field42140(var_args){
var args42141 = [];
var len__5627__auto___42208 = arguments.length;
var i__5628__auto___42209 = (0);
while(true){
if((i__5628__auto___42209 < len__5627__auto___42208)){
args42141.push((arguments[i__5628__auto___42209]));

var G__42210 = (i__5628__auto___42209 + (1));
i__5628__auto___42209 = G__42210;
continue;
} else {
}
break;
}

var G__42143 = args42141.length;
switch (G__42143) {
case 1:
return sablono.core.email_field42140.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field42140.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42141.length)].join('')));

}
});

sablono.core.email_field42140.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.email_field42140.cljs$core$IFn$_invoke$arity$2(name__7494__auto__,null);
});

sablono.core.email_field42140.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$email)].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.email_field42140.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs(sablono.core.email_field42140);

/**
 * Creates a file input field.
 */
sablono.core.file_field42144 = (function sablono$core$file_field42144(var_args){
var args42145 = [];
var len__5627__auto___42212 = arguments.length;
var i__5628__auto___42213 = (0);
while(true){
if((i__5628__auto___42213 < len__5627__auto___42212)){
args42145.push((arguments[i__5628__auto___42213]));

var G__42214 = (i__5628__auto___42213 + (1));
i__5628__auto___42213 = G__42214;
continue;
} else {
}
break;
}

var G__42147 = args42145.length;
switch (G__42147) {
case 1:
return sablono.core.file_field42144.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field42144.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42145.length)].join('')));

}
});

sablono.core.file_field42144.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.file_field42144.cljs$core$IFn$_invoke$arity$2(name__7494__auto__,null);
});

sablono.core.file_field42144.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$file)].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.file_field42144.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs(sablono.core.file_field42144);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field42148 = (function sablono$core$hidden_field42148(var_args){
var args42149 = [];
var len__5627__auto___42216 = arguments.length;
var i__5628__auto___42217 = (0);
while(true){
if((i__5628__auto___42217 < len__5627__auto___42216)){
args42149.push((arguments[i__5628__auto___42217]));

var G__42218 = (i__5628__auto___42217 + (1));
i__5628__auto___42217 = G__42218;
continue;
} else {
}
break;
}

var G__42151 = args42149.length;
switch (G__42151) {
case 1:
return sablono.core.hidden_field42148.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field42148.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42149.length)].join('')));

}
});

sablono.core.hidden_field42148.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.hidden_field42148.cljs$core$IFn$_invoke$arity$2(name__7494__auto__,null);
});

sablono.core.hidden_field42148.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$hidden)].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.hidden_field42148.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs(sablono.core.hidden_field42148);

/**
 * Creates a month input field.
 */
sablono.core.month_field42152 = (function sablono$core$month_field42152(var_args){
var args42153 = [];
var len__5627__auto___42220 = arguments.length;
var i__5628__auto___42221 = (0);
while(true){
if((i__5628__auto___42221 < len__5627__auto___42220)){
args42153.push((arguments[i__5628__auto___42221]));

var G__42222 = (i__5628__auto___42221 + (1));
i__5628__auto___42221 = G__42222;
continue;
} else {
}
break;
}

var G__42155 = args42153.length;
switch (G__42155) {
case 1:
return sablono.core.month_field42152.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field42152.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42153.length)].join('')));

}
});

sablono.core.month_field42152.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.month_field42152.cljs$core$IFn$_invoke$arity$2(name__7494__auto__,null);
});

sablono.core.month_field42152.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$month)].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.month_field42152.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs(sablono.core.month_field42152);

/**
 * Creates a number input field.
 */
sablono.core.number_field42156 = (function sablono$core$number_field42156(var_args){
var args42157 = [];
var len__5627__auto___42224 = arguments.length;
var i__5628__auto___42225 = (0);
while(true){
if((i__5628__auto___42225 < len__5627__auto___42224)){
args42157.push((arguments[i__5628__auto___42225]));

var G__42226 = (i__5628__auto___42225 + (1));
i__5628__auto___42225 = G__42226;
continue;
} else {
}
break;
}

var G__42159 = args42157.length;
switch (G__42159) {
case 1:
return sablono.core.number_field42156.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field42156.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42157.length)].join('')));

}
});

sablono.core.number_field42156.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.number_field42156.cljs$core$IFn$_invoke$arity$2(name__7494__auto__,null);
});

sablono.core.number_field42156.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$number)].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.number_field42156.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs(sablono.core.number_field42156);

/**
 * Creates a password input field.
 */
sablono.core.password_field42160 = (function sablono$core$password_field42160(var_args){
var args42161 = [];
var len__5627__auto___42228 = arguments.length;
var i__5628__auto___42229 = (0);
while(true){
if((i__5628__auto___42229 < len__5627__auto___42228)){
args42161.push((arguments[i__5628__auto___42229]));

var G__42230 = (i__5628__auto___42229 + (1));
i__5628__auto___42229 = G__42230;
continue;
} else {
}
break;
}

var G__42163 = args42161.length;
switch (G__42163) {
case 1:
return sablono.core.password_field42160.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field42160.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42161.length)].join('')));

}
});

sablono.core.password_field42160.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.password_field42160.cljs$core$IFn$_invoke$arity$2(name__7494__auto__,null);
});

sablono.core.password_field42160.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$password)].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.password_field42160.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs(sablono.core.password_field42160);

/**
 * Creates a range input field.
 */
sablono.core.range_field42164 = (function sablono$core$range_field42164(var_args){
var args42165 = [];
var len__5627__auto___42232 = arguments.length;
var i__5628__auto___42233 = (0);
while(true){
if((i__5628__auto___42233 < len__5627__auto___42232)){
args42165.push((arguments[i__5628__auto___42233]));

var G__42234 = (i__5628__auto___42233 + (1));
i__5628__auto___42233 = G__42234;
continue;
} else {
}
break;
}

var G__42167 = args42165.length;
switch (G__42167) {
case 1:
return sablono.core.range_field42164.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field42164.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42165.length)].join('')));

}
});

sablono.core.range_field42164.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.range_field42164.cljs$core$IFn$_invoke$arity$2(name__7494__auto__,null);
});

sablono.core.range_field42164.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$range)].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.range_field42164.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs(sablono.core.range_field42164);

/**
 * Creates a search input field.
 */
sablono.core.search_field42168 = (function sablono$core$search_field42168(var_args){
var args42169 = [];
var len__5627__auto___42236 = arguments.length;
var i__5628__auto___42237 = (0);
while(true){
if((i__5628__auto___42237 < len__5627__auto___42236)){
args42169.push((arguments[i__5628__auto___42237]));

var G__42238 = (i__5628__auto___42237 + (1));
i__5628__auto___42237 = G__42238;
continue;
} else {
}
break;
}

var G__42171 = args42169.length;
switch (G__42171) {
case 1:
return sablono.core.search_field42168.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field42168.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42169.length)].join('')));

}
});

sablono.core.search_field42168.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.search_field42168.cljs$core$IFn$_invoke$arity$2(name__7494__auto__,null);
});

sablono.core.search_field42168.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$search)].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.search_field42168.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs(sablono.core.search_field42168);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field42172 = (function sablono$core$tel_field42172(var_args){
var args42173 = [];
var len__5627__auto___42240 = arguments.length;
var i__5628__auto___42241 = (0);
while(true){
if((i__5628__auto___42241 < len__5627__auto___42240)){
args42173.push((arguments[i__5628__auto___42241]));

var G__42242 = (i__5628__auto___42241 + (1));
i__5628__auto___42241 = G__42242;
continue;
} else {
}
break;
}

var G__42175 = args42173.length;
switch (G__42175) {
case 1:
return sablono.core.tel_field42172.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field42172.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42173.length)].join('')));

}
});

sablono.core.tel_field42172.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.tel_field42172.cljs$core$IFn$_invoke$arity$2(name__7494__auto__,null);
});

sablono.core.tel_field42172.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$tel)].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.tel_field42172.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs(sablono.core.tel_field42172);

/**
 * Creates a text input field.
 */
sablono.core.text_field42176 = (function sablono$core$text_field42176(var_args){
var args42177 = [];
var len__5627__auto___42244 = arguments.length;
var i__5628__auto___42245 = (0);
while(true){
if((i__5628__auto___42245 < len__5627__auto___42244)){
args42177.push((arguments[i__5628__auto___42245]));

var G__42246 = (i__5628__auto___42245 + (1));
i__5628__auto___42245 = G__42246;
continue;
} else {
}
break;
}

var G__42179 = args42177.length;
switch (G__42179) {
case 1:
return sablono.core.text_field42176.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field42176.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42177.length)].join('')));

}
});

sablono.core.text_field42176.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.text_field42176.cljs$core$IFn$_invoke$arity$2(name__7494__auto__,null);
});

sablono.core.text_field42176.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$text)].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.text_field42176.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs(sablono.core.text_field42176);

/**
 * Creates a time input field.
 */
sablono.core.time_field42180 = (function sablono$core$time_field42180(var_args){
var args42181 = [];
var len__5627__auto___42248 = arguments.length;
var i__5628__auto___42249 = (0);
while(true){
if((i__5628__auto___42249 < len__5627__auto___42248)){
args42181.push((arguments[i__5628__auto___42249]));

var G__42250 = (i__5628__auto___42249 + (1));
i__5628__auto___42249 = G__42250;
continue;
} else {
}
break;
}

var G__42183 = args42181.length;
switch (G__42183) {
case 1:
return sablono.core.time_field42180.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field42180.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42181.length)].join('')));

}
});

sablono.core.time_field42180.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.time_field42180.cljs$core$IFn$_invoke$arity$2(name__7494__auto__,null);
});

sablono.core.time_field42180.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$time)].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.time_field42180.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs(sablono.core.time_field42180);

/**
 * Creates a url input field.
 */
sablono.core.url_field42184 = (function sablono$core$url_field42184(var_args){
var args42185 = [];
var len__5627__auto___42252 = arguments.length;
var i__5628__auto___42253 = (0);
while(true){
if((i__5628__auto___42253 < len__5627__auto___42252)){
args42185.push((arguments[i__5628__auto___42253]));

var G__42254 = (i__5628__auto___42253 + (1));
i__5628__auto___42253 = G__42254;
continue;
} else {
}
break;
}

var G__42187 = args42185.length;
switch (G__42187) {
case 1:
return sablono.core.url_field42184.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field42184.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42185.length)].join('')));

}
});

sablono.core.url_field42184.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.url_field42184.cljs$core$IFn$_invoke$arity$2(name__7494__auto__,null);
});

sablono.core.url_field42184.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$url)].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.url_field42184.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs(sablono.core.url_field42184);

/**
 * Creates a week input field.
 */
sablono.core.week_field42188 = (function sablono$core$week_field42188(var_args){
var args42189 = [];
var len__5627__auto___42256 = arguments.length;
var i__5628__auto___42257 = (0);
while(true){
if((i__5628__auto___42257 < len__5627__auto___42256)){
args42189.push((arguments[i__5628__auto___42257]));

var G__42258 = (i__5628__auto___42257 + (1));
i__5628__auto___42257 = G__42258;
continue;
} else {
}
break;
}

var G__42191 = args42189.length;
switch (G__42191) {
case 1:
return sablono.core.week_field42188.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field42188.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42189.length)].join('')));

}
});

sablono.core.week_field42188.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.week_field42188.cljs$core$IFn$_invoke$arity$2(name__7494__auto__,null);
});

sablono.core.week_field42188.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$week)].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.week_field42188.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs(sablono.core.week_field42188);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box42260 = (function sablono$core$check_box42260(var_args){
var args42261 = [];
var len__5627__auto___42264 = arguments.length;
var i__5628__auto___42265 = (0);
while(true){
if((i__5628__auto___42265 < len__5627__auto___42264)){
args42261.push((arguments[i__5628__auto___42265]));

var G__42266 = (i__5628__auto___42265 + (1));
i__5628__auto___42265 = G__42266;
continue;
} else {
}
break;
}

var G__42263 = args42261.length;
switch (G__42263) {
case 1:
return sablono.core.check_box42260.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box42260.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box42260.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42261.length)].join('')));

}
});

sablono.core.check_box42260.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box42260.cljs$core$IFn$_invoke$arity$2(name,null);
});

sablono.core.check_box42260.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box42260.cljs$core$IFn$_invoke$arity$3(name,checked_QMARK_,"true");
});

sablono.core.check_box42260.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"checkbox",cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value,cljs.core.cst$kw$checked,checked_QMARK_], null)], null);
});

sablono.core.check_box42260.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs(sablono.core.check_box42260);
/**
 * Creates a radio button.
 */
sablono.core.radio_button42268 = (function sablono$core$radio_button42268(var_args){
var args42269 = [];
var len__5627__auto___42272 = arguments.length;
var i__5628__auto___42273 = (0);
while(true){
if((i__5628__auto___42273 < len__5627__auto___42272)){
args42269.push((arguments[i__5628__auto___42273]));

var G__42274 = (i__5628__auto___42273 + (1));
i__5628__auto___42273 = G__42274;
continue;
} else {
}
break;
}

var G__42271 = args42269.length;
switch (G__42271) {
case 1:
return sablono.core.radio_button42268.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button42268.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button42268.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42269.length)].join('')));

}
});

sablono.core.radio_button42268.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button42268.cljs$core$IFn$_invoke$arity$2(group,null);
});

sablono.core.radio_button42268.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button42268.cljs$core$IFn$_invoke$arity$3(group,checked_QMARK_,"true");
});

sablono.core.radio_button42268.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"radio",cljs.core.cst$kw$name,sablono.core.make_name(group),cljs.core.cst$kw$id,sablono.core.make_id([cljs.core.str(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([group], 0))),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([value], 0)))].join('')),cljs.core.cst$kw$value,value,cljs.core.cst$kw$checked,checked_QMARK_], null)], null);
});

sablono.core.radio_button42268.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs(sablono.core.radio_button42268);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options42276 = (function sablono$core$select_options42276(var_args){
var args42277 = [];
var len__5627__auto___42290 = arguments.length;
var i__5628__auto___42291 = (0);
while(true){
if((i__5628__auto___42291 < len__5627__auto___42290)){
args42277.push((arguments[i__5628__auto___42291]));

var G__42292 = (i__5628__auto___42291 + (1));
i__5628__auto___42291 = G__42292;
continue;
} else {
}
break;
}

var G__42279 = args42277.length;
switch (G__42279) {
case 1:
return sablono.core.select_options42276.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options42276.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42277.length)].join('')));

}
});

sablono.core.select_options42276.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options42276.cljs$core$IFn$_invoke$arity$2(coll,null);
});

sablono.core.select_options42276.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__5341__auto__ = (function sablono$core$iter__42280(s__42281){
return (new cljs.core.LazySeq(null,(function (){
var s__42281__$1 = s__42281;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__42281__$1);
if(temp__4425__auto__){
var s__42281__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__42281__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__42281__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__42283 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__42282 = (0);
while(true){
if((i__42282 < size__5340__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__42282);
cljs.core.chunk_append(b__42283,((cljs.core.sequential_QMARK_(x))?(function (){var vec__42288 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42288,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42288,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42288,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$optgroup,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,text], null),sablono.core.select_options42276.cljs$core$IFn$_invoke$arity$2(val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$value,val,cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,selected),cljs.core.cst$kw$disabled,disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,selected)], null),x], null)));

var G__42294 = (i__42282 + (1));
i__42282 = G__42294;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__42283),sablono$core$iter__42280(cljs.core.chunk_rest(s__42281__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__42283),null);
}
} else {
var x = cljs.core.first(s__42281__$2);
return cljs.core.cons(((cljs.core.sequential_QMARK_(x))?(function (){var vec__42289 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42289,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42289,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42289,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$optgroup,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,text], null),sablono.core.select_options42276.cljs$core$IFn$_invoke$arity$2(val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$value,val,cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,selected),cljs.core.cst$kw$disabled,disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,selected)], null),x], null)),sablono$core$iter__42280(cljs.core.rest(s__42281__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(coll);
});

sablono.core.select_options42276.cljs$lang$maxFixedArity = 2;

sablono.core.select_options = sablono.core.wrap_attrs(sablono.core.select_options42276);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down42295 = (function sablono$core$drop_down42295(var_args){
var args42296 = [];
var len__5627__auto___42299 = arguments.length;
var i__5628__auto___42300 = (0);
while(true){
if((i__5628__auto___42300 < len__5627__auto___42299)){
args42296.push((arguments[i__5628__auto___42300]));

var G__42301 = (i__5628__auto___42300 + (1));
i__5628__auto___42300 = G__42301;
continue;
} else {
}
break;
}

var G__42298 = args42296.length;
switch (G__42298) {
case 2:
return sablono.core.drop_down42295.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down42295.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42296.length)].join('')));

}
});

sablono.core.drop_down42295.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down42295.cljs$core$IFn$_invoke$arity$3(name,options,null);
});

sablono.core.drop_down42295.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name)], null),(sablono.core.select_options.cljs$core$IFn$_invoke$arity$2 ? sablono.core.select_options.cljs$core$IFn$_invoke$arity$2(options,selected) : sablono.core.select_options.call(null,options,selected))], null);
});

sablono.core.drop_down42295.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs(sablono.core.drop_down42295);
/**
 * Creates a text area element.
 */
sablono.core.text_area42303 = (function sablono$core$text_area42303(var_args){
var args42304 = [];
var len__5627__auto___42307 = arguments.length;
var i__5628__auto___42308 = (0);
while(true){
if((i__5628__auto___42308 < len__5627__auto___42307)){
args42304.push((arguments[i__5628__auto___42308]));

var G__42309 = (i__5628__auto___42308 + (1));
i__5628__auto___42308 = G__42309;
continue;
} else {
}
break;
}

var G__42306 = args42304.length;
switch (G__42306) {
case 1:
return sablono.core.text_area42303.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area42303.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42304.length)].join('')));

}
});

sablono.core.text_area42303.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area42303.cljs$core$IFn$_invoke$arity$2(name,null);
});

sablono.core.text_area42303.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$textarea,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value], null)], null);
});

sablono.core.text_area42303.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs(sablono.core.text_area42303);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label42311 = (function sablono$core$label42311(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$htmlFor,sablono.core.make_id(name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs(sablono.core.label42311);
/**
 * Creates a submit button.
 */
sablono.core.submit_button42312 = (function sablono$core$submit_button42312(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"submit",cljs.core.cst$kw$value,text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs(sablono.core.submit_button42312);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button42313 = (function sablono$core$reset_button42313(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"reset",cljs.core.cst$kw$value,text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs(sablono.core.reset_button42313);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to42314 = (function sablono$core$form_to42314(var_args){
var args__5634__auto__ = [];
var len__5627__auto___42319 = arguments.length;
var i__5628__auto___42320 = (0);
while(true){
if((i__5628__auto___42320 < len__5627__auto___42319)){
args__5634__auto__.push((arguments[i__5628__auto___42320]));

var G__42321 = (i__5628__auto___42320 + (1));
i__5628__auto___42320 = G__42321;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return sablono.core.form_to42314.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

sablono.core.form_to42314.cljs$core$IFn$_invoke$arity$variadic = (function (p__42317,body){
var vec__42318 = p__42317;
var method = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42318,(0),null);
var action = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42318,(1),null);
var method_str = clojure.string.upper_case(cljs.core.name(method));
var action_uri = sablono.util.to_uri(action);
return cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$get,null,cljs.core.cst$kw$post,null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,method_str,cljs.core.cst$kw$action,action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,"POST",cljs.core.cst$kw$action,action_uri], null),(sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$2 ? sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$2("_method",method_str) : sablono.core.hidden_field.call(null,"_method",method_str))], null)),body));
});

sablono.core.form_to42314.cljs$lang$maxFixedArity = (1);

sablono.core.form_to42314.cljs$lang$applyTo = (function (seq42315){
var G__42316 = cljs.core.first(seq42315);
var seq42315__$1 = cljs.core.next(seq42315);
return sablono.core.form_to42314.cljs$core$IFn$_invoke$arity$variadic(G__42316,seq42315__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs(sablono.core.form_to42314);
