// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Extra fields that will be displayed on the table.
 */
hatti.views.table.get_extra_fields = (function hatti$views$table$get_extra_fields(is_filtered_dataview_QMARK_){
var extra_field = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$full_DASH_name,hatti.constants._id,cljs.core.cst$kw$label,"id",cljs.core.cst$kw$name,hatti.constants._id,cljs.core.cst$kw$type,"integer"], null)], null);
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
return extra_field;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(extra_field,hatti.ona.forms.submission_time_field);
}
});
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(var_args){
var args__5634__auto__ = [];
var len__5627__auto___32901 = arguments.length;
var i__5628__auto___32902 = (0);
while(true){
if((i__5628__auto___32902 < len__5627__auto___32901)){
args__5634__auto__.push((arguments[i__5628__auto___32902]));

var G__32903 = (i__5628__auto___32902 + (1));
i__5628__auto___32902 = G__32903;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__32898){
var map__32899 = p__32898;
var map__32899__$1 = ((((!((map__32899 == null)))?((((map__32899.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32899.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32899):map__32899);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32899__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.has_data_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(hatti.views.table.get_extra_fields(is_filtered_dataview_QMARK_),hatti.ona.forms.non_meta_fields(form),cljs.core.array_seq([hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,cljs.core.not(is_filtered_dataview_QMARK_)], 0))], 0))));
});

hatti.views.table.all_fields.cljs$lang$maxFixedArity = (1);

hatti.views.table.all_fields.cljs$lang$applyTo = (function (seq32896){
var G__32897 = cljs.core.first(seq32896);
var seq32896__$1 = cljs.core.next(seq32896);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(G__32897,seq32896__$1);
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__32904_SHARP_){
if(typeof p1__32904_SHARP_ === 'string'){
return clojure.string.lower_case(p1__32904_SHARP_);
} else {
return p1__32904_SHARP_;
}
});})(col))
;
var aval = lower((a[(col["field"])]));
var bval = lower((b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not(args)){
return true;
} else {
var indexed_form = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full_DASH_name,form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__32908){
var vec__32909 = p__32908;
var fname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32909,(0),null);
var answer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32909,(1),null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(indexed_form,fname),answer,null,true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (indexed_form,query,fmt_subitem){
return (function (p1__32905_SHARP_){
return cljs.core.re_find(hatti.utils.safe_regex(query),[cljs.core.str(p1__32905_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fmt_subitem,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(item))));
return cljs.core.seq(filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(value,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4(field,clj_value,language,true);
});
hatti.views.action_buttons.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__32910 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)));
var map__32910__$1 = ((((!((map__32910 == null)))?((((map__32910.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32910.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32910):map__32910);
var owner__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32910__$1,cljs.core.cst$kw$owner);
var project = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32910__$1,cljs.core.cst$kw$project);
var formid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32910__$1,cljs.core.cst$kw$formid);
var form_owner = hatti.utils.last_url_param(owner__$1);
var project_id = hatti.utils.last_url_param(project);
var edit_link = hatti.utils.url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join('')], 0));
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip$middle_DASH_right,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$view_DASH_record,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_clone,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data_DASH_id,value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$edit_DASH_record,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_DASH_id,value,cljs.core.cst$kw$target,"_blank",cljs.core.cst$kw$href,edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_pencil_DASH_square_DASH_o], null)], null)], null)], null):null)], 0));
});
}));
hatti.views.table.actions_column = (function hatti$views$table$actions_column(owner){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$maxWidth,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],["record-actions header",(70),"",(hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1 ? hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1(owner) : hatti.views.action_buttons.call(null,owner)),hatti.constants._id,"text","actions",false,"record-actions",""]);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args32912 = [];
var len__5627__auto___32936 = arguments.length;
var i__5628__auto___32937 = (0);
while(true){
if((i__5628__auto___32937 < len__5627__auto___32936)){
args32912.push((arguments[i__5628__auto___32937]));

var G__32938 = (i__5628__auto___32937 + (1));
i__5628__auto___32937 = G__32938;
continue;
} else {
}
break;
}

var G__32918 = args32912.length;
switch (G__32918) {
case 1:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args32912.slice((3)),(0)));
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5646__auto__);

}
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1 = (function (form){
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2(form,true);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2 = (function (form,get_label_QMARK_){
return hatti.views.table.flat_form__GT_sg_columns(form,get_label_QMARK_,null);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,get_label_QMARK_,language,p__32919){
var map__32920 = p__32919;
var map__32920__$1 = ((((!((map__32920 == null)))?((((map__32920.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32920.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32920):map__32920);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32920__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var owner = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32920__$1,cljs.core.cst$kw$owner);
var columns = (function (){var iter__5341__auto__ = ((function (map__32920,map__32920__$1,is_filtered_dataview_QMARK_,owner){
return (function hatti$views$table$iter__32922(s__32923){
return (new cljs.core.LazySeq(null,((function (map__32920,map__32920__$1,is_filtered_dataview_QMARK_,owner){
return (function (){
var s__32923__$1 = s__32923;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__32923__$1);
if(temp__4425__auto__){
var s__32923__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__32923__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__32923__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__32925 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__32924 = (0);
while(true){
if((i__32924 < size__5340__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__32924);
cljs.core.chunk_append(b__32925,(function (){var map__32932 = field;
var map__32932__$1 = ((((!((map__32932 == null)))?((((map__32932.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32932.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32932):map__32932);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32932__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32932__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32932__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hatti.ona.forms.get_column_class(field),label,cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class(field),label]);
})());

var G__32940 = (i__32924 + (1));
i__32924 = G__32940;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__32925),hatti$views$table$iter__32922(cljs.core.chunk_rest(s__32923__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__32925),null);
}
} else {
var field = cljs.core.first(s__32923__$2);
return cljs.core.cons((function (){var map__32934 = field;
var map__32934__$1 = ((((!((map__32934 == null)))?((((map__32934.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32934.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32934):map__32934);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32934__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32934__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32934__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hatti.ona.forms.get_column_class(field),label,cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class(field),label]);
})(),hatti$views$table$iter__32922(cljs.core.rest(s__32923__$2)));
}
} else {
return null;
}
break;
}
});})(map__32920,map__32920__$1,is_filtered_dataview_QMARK_,owner))
,null,null));
});})(map__32920,map__32920__$1,is_filtered_dataview_QMARK_,owner))
;
return iter__5341__auto__(hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], 0)));
})();
return cljs.core.clj__GT_js(columns);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq32913){
var G__32914 = cljs.core.first(seq32913);
var seq32913__$1 = cljs.core.next(seq32913);
var G__32915 = cljs.core.first(seq32913__$1);
var seq32913__$2 = cljs.core.next(seq32913__$1);
var G__32916 = cljs.core.first(seq32913__$2);
var seq32913__$3 = cljs.core.next(seq32913__$2);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__32914,G__32915,G__32916,seq32913__$3);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (3);
hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,(function (){var G__32942 = [cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join('');
return jQuery(G__32942);
})()));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = {"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false};
/**
 * Fixes the first column on slick table on horizontal scroll
 */
hatti.views.table.freeze_action_column_BANG_ = (function hatti$views$table$freeze_action_column_BANG_(){
var actions = document.getElementsByClassName("record-actions");
var sg_viewport = cljs.core.first(document.getElementsByClassName("slick-viewport"));
var seq__32950 = cljs.core.seq(actions);
var chunk__32951 = null;
var count__32952 = (0);
var i__32953 = (0);
while(true){
if((i__32953 < count__32952)){
var action = chunk__32951.cljs$core$IIndexed$_nth$arity$2(null,i__32953);
var leftOffset_32956 = (function (){var G__32954 = action.offsetLeft;
return parseInt(G__32954);
})();
sg_viewport.addEventListener("scroll",((function (seq__32950,chunk__32951,count__32952,i__32953,leftOffset_32956,action,actions,sg_viewport){
return (function (){
var sl = sg_viewport.scrollLeft;
var set_border_BANG_ = ((function (seq__32950,chunk__32951,count__32952,i__32953,sl,leftOffset_32956,action,actions,sg_viewport){
return (function (p1__32943_SHARP_){
return action.style.borderRight = p1__32943_SHARP_;
});})(seq__32950,chunk__32951,count__32952,i__32953,sl,leftOffset_32956,action,actions,sg_viewport))
;
if((sl === (0))){
set_border_BANG_("1px dotted #ededed");
} else {
set_border_BANG_("1px solid silver");
}

return action.style.left = [cljs.core.str((sl + leftOffset_32956)),cljs.core.str("px")].join('');
});})(seq__32950,chunk__32951,count__32952,i__32953,leftOffset_32956,action,actions,sg_viewport))
);

var G__32957 = seq__32950;
var G__32958 = chunk__32951;
var G__32959 = count__32952;
var G__32960 = (i__32953 + (1));
seq__32950 = G__32957;
chunk__32951 = G__32958;
count__32952 = G__32959;
i__32953 = G__32960;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__32950);
if(temp__4425__auto__){
var seq__32950__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__32950__$1)){
var c__5372__auto__ = cljs.core.chunk_first(seq__32950__$1);
var G__32961 = cljs.core.chunk_rest(seq__32950__$1);
var G__32962 = c__5372__auto__;
var G__32963 = cljs.core.count(c__5372__auto__);
var G__32964 = (0);
seq__32950 = G__32961;
chunk__32951 = G__32962;
count__32952 = G__32963;
i__32953 = G__32964;
continue;
} else {
var action = cljs.core.first(seq__32950__$1);
var leftOffset_32965 = (function (){var G__32955 = action.offsetLeft;
return parseInt(G__32955);
})();
sg_viewport.addEventListener("scroll",((function (seq__32950,chunk__32951,count__32952,i__32953,leftOffset_32965,action,seq__32950__$1,temp__4425__auto__,actions,sg_viewport){
return (function (){
var sl = sg_viewport.scrollLeft;
var set_border_BANG_ = ((function (seq__32950,chunk__32951,count__32952,i__32953,sl,leftOffset_32965,action,seq__32950__$1,temp__4425__auto__,actions,sg_viewport){
return (function (p1__32943_SHARP_){
return action.style.borderRight = p1__32943_SHARP_;
});})(seq__32950,chunk__32951,count__32952,i__32953,sl,leftOffset_32965,action,seq__32950__$1,temp__4425__auto__,actions,sg_viewport))
;
if((sl === (0))){
set_border_BANG_("1px dotted #ededed");
} else {
set_border_BANG_("1px solid silver");
}

return action.style.left = [cljs.core.str((sl + leftOffset_32965)),cljs.core.str("px")].join('');
});})(seq__32950,chunk__32951,count__32952,i__32953,leftOffset_32965,action,seq__32950__$1,temp__4425__auto__,actions,sg_viewport))
);

var G__32966 = cljs.core.next(seq__32950__$1);
var G__32967 = null;
var G__32968 = (0);
var G__32969 = (0);
seq__32950 = G__32966;
chunk__32951 = G__32967;
count__32952 = G__32968;
i__32953 = G__32969;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__32980(s__32981){
return (new cljs.core.LazySeq(null,(function (){
var s__32981__$1 = s__32981;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__32981__$1);
if(temp__4425__auto__){
var s__32981__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__32981__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__32981__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__32983 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__32982 = (0);
while(true){
if((i__32982 < size__5340__auto__)){
var vec__32988 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__32982);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32988,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32988,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append(b__32983,event.subscribe(handler_function));

var G__32990 = (i__32982 + (1));
i__32982 = G__32990;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__32983),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__32980(cljs.core.chunk_rest(s__32981__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__32983),null);
}
} else {
var vec__32989 = cljs.core.first(s__32981__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32989,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32989,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__32980(cljs.core.rest(s__32981__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__33001(s__33002){
return (new cljs.core.LazySeq(null,(function (){
var s__33002__$1 = s__33002;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__33002__$1);
if(temp__4425__auto__){
var s__33002__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__33002__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__33002__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__33004 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__33003 = (0);
while(true){
if((i__33003 < size__5340__auto__)){
var vec__33009 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__33003);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33009,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33009,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append(b__33004,event.subscribe(handler_function));

var G__33011 = (i__33003 + (1));
i__33003 = G__33011;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33004),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__33001(cljs.core.chunk_rest(s__33002__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33004),null);
}
} else {
var vec__33010 = cljs.core.first(s__33002__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33010,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33010,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__33001(cljs.core.rest(s__33002__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__(event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,is_filtered_dataview_QMARK_,owner,p__33012){
var map__33022 = p__33012;
var map__33022__$1 = ((((!((map__33022 == null)))?((((map__33022.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33022.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33022):map__33022);
var grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33022__$1,cljs.core.cst$kw$grid_DASH_event_DASH_handlers);
var dataview_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33022__$1,cljs.core.cst$kw$dataview_DASH_event_DASH_handlers);
var columns = hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(form,true,current_language,cljs.core.array_seq([cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_,cljs.core.cst$kw$owner,owner], 0));
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
var map__33024 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__33024__$1 = ((((!((map__33024 == null)))?((((map__33024.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33024.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33024):map__33024);
var map__33025 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33024__$1,cljs.core.cst$kw$table_DASH_page);
var map__33025__$1 = ((((!((map__33025 == null)))?((((map__33025.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33025.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33025):map__33025);
var map__33026 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33025__$1,cljs.core.cst$kw$paging);
var map__33026__$1 = ((((!((map__33026 == null)))?((((map__33026.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33026.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33026):map__33026);
var num_displayed_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33026__$1,cljs.core.cst$kw$num_DASH_displayed_DASH_records);
var total_page_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33026__$1,cljs.core.cst$kw$total_DASH_page_DASH_count);
hatti.views.table.bind_external_sg_grid_event_handlers(grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers(dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__33024,map__33024__$1,map__33025,map__33025__$1,map__33026,map__33026__$1,num_displayed_records,total_page_count,map__33022,map__33022__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__33024,map__33024__$1,map__33025,map__33025__$1,map__33026,map__33026__$1,num_displayed_records,total_page_count,map__33022,map__33022__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__33024,map__33024__$1,map__33025,map__33025__$1,map__33026,map__33026__$1,num_displayed_records,total_page_count,map__33022,map__33022__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__33024,map__33024__$1,map__33025,map__33025__$1,map__33026,map__33026__$1,num_displayed_records,total_page_count,map__33022,map__33022__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__33024,map__33024__$1,map__33025,map__33025__$1,map__33026,map__33026__$1,num_displayed_records,total_page_count,map__33022,map__33022__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
});})(columns,SlickGrid,DataView,dataview,grid,map__33024,map__33024__$1,map__33025,map__33025__$1,map__33026,map__33026__$1,num_displayed_records,total_page_count,map__33022,map__33022__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__33024,map__33024__$1,map__33025,map__33025__$1,map__33026,map__33026__$1,num_displayed_records,total_page_count,map__33022,map__33022__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?(function (){var G__33030 = elem.getAttribute("data-id");
return parseInt(G__33030);
})():null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,data_id)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
} else {
return null;
}
});})(columns,SlickGrid,DataView,dataview,grid,map__33024,map__33024__$1,map__33025,map__33025__$1,map__33026,map__33026__$1,num_displayed_records,total_page_count,map__33022,map__33022__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager(grid,dataview);

dataview.setPagingOptions({"pageSize": (function (){var or__4569__auto__ = num_displayed_records;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count});

dataview.setFilter(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js(data),hatti.constants._id);

hatti.views.table.resizeColumns(grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap();
var c__9230__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__9230__auto__,event_chan){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto__,event_chan){
return (function (state_33292){
var state_val_33293 = (state_33292[(1)]);
if((state_val_33293 === (7))){
var inst_33201 = (state_33292[(7)]);
var inst_33201__$1 = (state_33292[(2)]);
var inst_33203 = (inst_33201__$1 == null);
var inst_33204 = cljs.core.not(inst_33203);
var state_33292__$1 = (function (){var statearr_33294 = state_33292;
(statearr_33294[(7)] = inst_33201__$1);

return statearr_33294;
})();
if(inst_33204){
var statearr_33295_33362 = state_33292__$1;
(statearr_33295_33362[(1)] = (8));

} else {
var statearr_33296_33363 = state_33292__$1;
(statearr_33296_33363[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (20))){
var inst_33223 = (state_33292[(8)]);
var inst_33231 = (state_33292[(9)]);
var inst_33240 = (inst_33231.cljs$core$IFn$_invoke$arity$1 ? inst_33231.cljs$core$IFn$_invoke$arity$1(inst_33223) : inst_33231.call(null,inst_33223));
var state_33292__$1 = state_33292;
var statearr_33297_33364 = state_33292__$1;
(statearr_33297_33364[(2)] = inst_33240);

(statearr_33297_33364[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (27))){
var state_33292__$1 = state_33292;
var statearr_33298_33365 = state_33292__$1;
(statearr_33298_33365[(2)] = null);

(statearr_33298_33365[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (1))){
var state_33292__$1 = state_33292;
var statearr_33299_33366 = state_33292__$1;
(statearr_33299_33366[(2)] = null);

(statearr_33299_33366[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (24))){
var state_33292__$1 = state_33292;
var statearr_33300_33367 = state_33292__$1;
(statearr_33300_33367[(2)] = null);

(statearr_33300_33367[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (4))){
var state_33292__$1 = state_33292;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33292__$1,(7),event_chan);
} else {
if((state_val_33293 === (15))){
var inst_33201 = (state_33292[(7)]);
var state_33292__$1 = state_33292;
var statearr_33301_33368 = state_33292__$1;
(statearr_33301_33368[(2)] = inst_33201);

(statearr_33301_33368[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (21))){
var state_33292__$1 = state_33292;
var statearr_33302_33369 = state_33292__$1;
(statearr_33302_33369[(2)] = null);

(statearr_33302_33369[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (31))){
var inst_33227 = (state_33292[(10)]);
var inst_33265 = (state_33292[(2)]);
var inst_33266 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33227,cljs.core.cst$kw$table);
var state_33292__$1 = (function (){var statearr_33303 = state_33292;
(statearr_33303[(11)] = inst_33265);

return statearr_33303;
})();
if(inst_33266){
var statearr_33304_33370 = state_33292__$1;
(statearr_33304_33370[(1)] = (32));

} else {
var statearr_33305_33371 = state_33292__$1;
(statearr_33305_33371[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (32))){
var inst_33225 = (state_33292[(12)]);
var inst_33201 = (state_33292[(7)]);
var inst_33224 = (state_33292[(13)]);
var inst_33227 = (state_33292[(10)]);
var inst_33226 = (state_33292[(14)]);
var inst_33223 = (state_33292[(8)]);
var inst_33221 = (state_33292[(15)]);
var inst_33231 = (state_33292[(9)]);
var inst_33222 = (state_33292[(16)]);
var inst_33232 = (state_33292[(17)]);
var inst_33279 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_33280 = (function (){var new_columns = inst_33226;
var c__9230__auto____$1 = inst_33279;
var map__33199 = inst_33221;
var submission_clicked = inst_33223;
var submission_unclicked = inst_33224;
var get_submission_data = inst_33232;
var re_render = inst_33227;
var update_data_BANG_ = inst_33231;
var submission_to_rank = inst_33222;
var e = inst_33201;
var filter_by = inst_33225;
return ((function (new_columns,c__9230__auto____$1,map__33199,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_33225,inst_33201,inst_33224,inst_33227,inst_33226,inst_33223,inst_33221,inst_33231,inst_33222,inst_33232,inst_33279,state_val_33293,c__9230__auto__,event_chan){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (new_columns,c__9230__auto____$1,map__33199,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_33225,inst_33201,inst_33224,inst_33227,inst_33226,inst_33223,inst_33221,inst_33231,inst_33222,inst_33232,inst_33279,state_val_33293,c__9230__auto__,event_chan){
return (function (state_33277){
var state_val_33278 = (state_33277[(1)]);
if((state_val_33278 === (1))){
var inst_33268 = cljs.core.async.timeout((20));
var state_33277__$1 = state_33277;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33277__$1,(2),inst_33268);
} else {
if((state_val_33278 === (2))){
var inst_33270 = (state_33277[(2)]);
var inst_33271 = grid.resizeCanvas();
var inst_33272 = grid.invalidateAllRows();
var inst_33273 = hatti.views.table.resizeColumns(grid);
var inst_33274 = grid.render();
var inst_33275 = hatti.views.table.init_sg_pager(grid,dataview);
var state_33277__$1 = (function (){var statearr_33306 = state_33277;
(statearr_33306[(7)] = inst_33274);

(statearr_33306[(8)] = inst_33273);

(statearr_33306[(9)] = inst_33270);

(statearr_33306[(10)] = inst_33271);

(statearr_33306[(11)] = inst_33272);

return statearr_33306;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33277__$1,inst_33275);
} else {
return null;
}
}
});})(new_columns,c__9230__auto____$1,map__33199,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_33225,inst_33201,inst_33224,inst_33227,inst_33226,inst_33223,inst_33221,inst_33231,inst_33222,inst_33232,inst_33279,state_val_33293,c__9230__auto__,event_chan))
;
return ((function (switch__9165__auto__,new_columns,c__9230__auto____$1,map__33199,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_33225,inst_33201,inst_33224,inst_33227,inst_33226,inst_33223,inst_33221,inst_33231,inst_33222,inst_33232,inst_33279,state_val_33293,c__9230__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__9166__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__9166__auto____0 = (function (){
var statearr_33310 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33310[(0)] = hatti$views$table$handle_table_events_$_state_machine__9166__auto__);

(statearr_33310[(1)] = (1));

return statearr_33310;
});
var hatti$views$table$handle_table_events_$_state_machine__9166__auto____1 = (function (state_33277){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__(state_33277);
if(cljs.core.keyword_identical_QMARK_(result__9168__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e33311){if((e33311 instanceof Object)){
var ex__9169__auto__ = e33311;
var statearr_33312_33372 = state_33277;
(statearr_33312_33372[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33277);

return cljs.core.cst$kw$recur;
} else {
throw e33311;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__9167__auto__,cljs.core.cst$kw$recur)){
var G__33373 = state_33277;
state_33277 = G__33373;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__9166__auto__ = function(state_33277){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__9166__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__9166__auto____1.call(this,state_33277);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__9166__auto____0;
hatti$views$table$handle_table_events_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__9166__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,new_columns,c__9230__auto____$1,map__33199,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_33225,inst_33201,inst_33224,inst_33227,inst_33226,inst_33223,inst_33221,inst_33231,inst_33222,inst_33232,inst_33279,state_val_33293,c__9230__auto__,event_chan))
})();
var state__9232__auto__ = (function (){var statearr_33313 = (f__9231__auto__.cljs$core$IFn$_invoke$arity$0 ? f__9231__auto__.cljs$core$IFn$_invoke$arity$0() : f__9231__auto__.call(null));
(statearr_33313[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto____$1);

return statearr_33313;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__9232__auto__);
});
;})(new_columns,c__9230__auto____$1,map__33199,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_33225,inst_33201,inst_33224,inst_33227,inst_33226,inst_33223,inst_33221,inst_33231,inst_33222,inst_33232,inst_33279,state_val_33293,c__9230__auto__,event_chan))
})();
var inst_33281 = cljs.core.async.impl.dispatch.run(inst_33280);
var state_33292__$1 = (function (){var statearr_33314 = state_33292;
(statearr_33314[(18)] = inst_33281);

return statearr_33314;
})();
var statearr_33315_33374 = state_33292__$1;
(statearr_33315_33374[(2)] = inst_33279);

(statearr_33315_33374[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (33))){
var state_33292__$1 = state_33292;
var statearr_33316_33375 = state_33292__$1;
(statearr_33316_33375[(2)] = null);

(statearr_33316_33375[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (13))){
var inst_33213 = (state_33292[(2)]);
var state_33292__$1 = state_33292;
var statearr_33317_33376 = state_33292__$1;
(statearr_33317_33376[(2)] = inst_33213);

(statearr_33317_33376[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (22))){
var inst_33224 = (state_33292[(13)]);
var inst_33243 = (state_33292[(2)]);
var state_33292__$1 = (function (){var statearr_33318 = state_33292;
(statearr_33318[(19)] = inst_33243);

return statearr_33318;
})();
if(cljs.core.truth_(inst_33224)){
var statearr_33319_33377 = state_33292__$1;
(statearr_33319_33377[(1)] = (23));

} else {
var statearr_33320_33378 = state_33292__$1;
(statearr_33320_33378[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (29))){
var inst_33225 = (state_33292[(12)]);
var inst_33257 = [cljs.core.cst$kw$query];
var inst_33258 = [inst_33225];
var inst_33259 = cljs.core.PersistentHashMap.fromArrays(inst_33257,inst_33258);
var inst_33260 = cljs.core.clj__GT_js(inst_33259);
var inst_33261 = dataview.setFilterArgs(inst_33260);
var inst_33262 = dataview.refresh();
var state_33292__$1 = (function (){var statearr_33321 = state_33292;
(statearr_33321[(20)] = inst_33261);

return statearr_33321;
})();
var statearr_33322_33379 = state_33292__$1;
(statearr_33322_33379[(2)] = inst_33262);

(statearr_33322_33379[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (6))){
var inst_33288 = (state_33292[(2)]);
var state_33292__$1 = state_33292;
var statearr_33323_33380 = state_33292__$1;
(statearr_33323_33380[(2)] = inst_33288);

(statearr_33323_33380[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (28))){
var inst_33225 = (state_33292[(12)]);
var inst_33255 = (state_33292[(2)]);
var state_33292__$1 = (function (){var statearr_33324 = state_33292;
(statearr_33324[(21)] = inst_33255);

return statearr_33324;
})();
if(cljs.core.truth_(inst_33225)){
var statearr_33325_33381 = state_33292__$1;
(statearr_33325_33381[(1)] = (29));

} else {
var statearr_33326_33382 = state_33292__$1;
(statearr_33326_33382[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (25))){
var inst_33226 = (state_33292[(14)]);
var inst_33248 = (state_33292[(2)]);
var state_33292__$1 = (function (){var statearr_33327 = state_33292;
(statearr_33327[(22)] = inst_33248);

return statearr_33327;
})();
if(cljs.core.truth_(inst_33226)){
var statearr_33328_33383 = state_33292__$1;
(statearr_33328_33383[(1)] = (26));

} else {
var statearr_33329_33384 = state_33292__$1;
(statearr_33329_33384[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (34))){
var inst_33284 = (state_33292[(2)]);
var state_33292__$1 = (function (){var statearr_33330 = state_33292;
(statearr_33330[(23)] = inst_33284);

return statearr_33330;
})();
var statearr_33331_33385 = state_33292__$1;
(statearr_33331_33385[(2)] = null);

(statearr_33331_33385[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (17))){
var inst_33231 = (state_33292[(9)]);
var inst_33222 = (state_33292[(16)]);
var inst_33232 = (state_33292[(17)]);
var inst_33234 = (inst_33232.cljs$core$IFn$_invoke$arity$2 ? inst_33232.cljs$core$IFn$_invoke$arity$2(hatti.constants._rank,inst_33222) : inst_33232.call(null,hatti.constants._rank,inst_33222));
var inst_33235 = (inst_33231.cljs$core$IFn$_invoke$arity$1 ? inst_33231.cljs$core$IFn$_invoke$arity$1(inst_33234) : inst_33231.call(null,inst_33234));
var state_33292__$1 = state_33292;
var statearr_33332_33386 = state_33292__$1;
(statearr_33332_33386[(2)] = inst_33235);

(statearr_33332_33386[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (3))){
var inst_33290 = (state_33292[(2)]);
var state_33292__$1 = state_33292;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33292__$1,inst_33290);
} else {
if((state_val_33293 === (12))){
var state_33292__$1 = state_33292;
var statearr_33333_33387 = state_33292__$1;
(statearr_33333_33387[(2)] = false);

(statearr_33333_33387[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (2))){
var state_33292__$1 = state_33292;
var statearr_33334_33388 = state_33292__$1;
(statearr_33334_33388[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (23))){
var inst_33231 = (state_33292[(9)]);
var inst_33245 = (inst_33231.cljs$core$IFn$_invoke$arity$1 ? inst_33231.cljs$core$IFn$_invoke$arity$1(null) : inst_33231.call(null,null));
var state_33292__$1 = state_33292;
var statearr_33336_33389 = state_33292__$1;
(statearr_33336_33389[(2)] = inst_33245);

(statearr_33336_33389[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (19))){
var inst_33223 = (state_33292[(8)]);
var inst_33238 = (state_33292[(2)]);
var state_33292__$1 = (function (){var statearr_33337 = state_33292;
(statearr_33337[(24)] = inst_33238);

return statearr_33337;
})();
if(cljs.core.truth_(inst_33223)){
var statearr_33338_33390 = state_33292__$1;
(statearr_33338_33390[(1)] = (20));

} else {
var statearr_33339_33391 = state_33292__$1;
(statearr_33339_33391[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (11))){
var state_33292__$1 = state_33292;
var statearr_33340_33392 = state_33292__$1;
(statearr_33340_33392[(2)] = true);

(statearr_33340_33392[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (9))){
var state_33292__$1 = state_33292;
var statearr_33341_33393 = state_33292__$1;
(statearr_33341_33393[(2)] = false);

(statearr_33341_33393[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (5))){
var state_33292__$1 = state_33292;
var statearr_33342_33394 = state_33292__$1;
(statearr_33342_33394[(2)] = null);

(statearr_33342_33394[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (14))){
var inst_33201 = (state_33292[(7)]);
var inst_33218 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_33201);
var state_33292__$1 = state_33292;
var statearr_33343_33395 = state_33292__$1;
(statearr_33343_33395[(2)] = inst_33218);

(statearr_33343_33395[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (26))){
var inst_33226 = (state_33292[(14)]);
var inst_33250 = grid.setColumns(inst_33226);
var inst_33251 = hatti.views.table.resizeColumns(grid);
var inst_33252 = grid.render();
var state_33292__$1 = (function (){var statearr_33344 = state_33292;
(statearr_33344[(25)] = inst_33251);

(statearr_33344[(26)] = inst_33250);

return statearr_33344;
})();
var statearr_33345_33396 = state_33292__$1;
(statearr_33345_33396[(2)] = inst_33252);

(statearr_33345_33396[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (16))){
var inst_33225 = (state_33292[(12)]);
var inst_33201 = (state_33292[(7)]);
var inst_33224 = (state_33292[(13)]);
var inst_33227 = (state_33292[(10)]);
var inst_33226 = (state_33292[(14)]);
var inst_33223 = (state_33292[(8)]);
var inst_33221 = (state_33292[(15)]);
var inst_33231 = (state_33292[(9)]);
var inst_33222 = (state_33292[(16)]);
var inst_33221__$1 = (state_33292[(2)]);
var inst_33222__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33221__$1,cljs.core.cst$kw$submission_DASH_to_DASH_rank);
var inst_33223__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33221__$1,cljs.core.cst$kw$submission_DASH_clicked);
var inst_33224__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33221__$1,cljs.core.cst$kw$submission_DASH_unclicked);
var inst_33225__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33221__$1,cljs.core.cst$kw$filter_DASH_by);
var inst_33226__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33221__$1,cljs.core.cst$kw$new_DASH_columns);
var inst_33227__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33221__$1,cljs.core.cst$kw$re_DASH_render);
var inst_33228 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33229 = [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$data];
var inst_33230 = (new cljs.core.PersistentVector(null,3,(5),inst_33228,inst_33229,null));
var inst_33231__$1 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(om.core.update_BANG_,app_state,inst_33230);
var inst_33232 = (function (){var e = inst_33201;
var map__33199 = inst_33221__$1;
var submission_to_rank = inst_33222__$1;
var submission_clicked = inst_33223__$1;
var submission_unclicked = inst_33224__$1;
var filter_by = inst_33225__$1;
var new_columns = inst_33226__$1;
var re_render = inst_33227__$1;
var update_data_BANG_ = inst_33231__$1;
return ((function (e,map__33199,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_33225,inst_33201,inst_33224,inst_33227,inst_33226,inst_33223,inst_33221,inst_33231,inst_33222,inst_33221__$1,inst_33222__$1,inst_33223__$1,inst_33224__$1,inst_33225__$1,inst_33226__$1,inst_33227__$1,inst_33228,inst_33229,inst_33230,inst_33231__$1,state_val_33293,c__9230__auto__,event_chan){
return (function (field,value){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (e,map__33199,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_33225,inst_33201,inst_33224,inst_33227,inst_33226,inst_33223,inst_33221,inst_33231,inst_33222,inst_33221__$1,inst_33222__$1,inst_33223__$1,inst_33224__$1,inst_33225__$1,inst_33226__$1,inst_33227__$1,inst_33228,inst_33229,inst_33230,inst_33231__$1,state_val_33293,c__9230__auto__,event_chan){
return (function (p1__33031_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__33031_SHARP_,field));
});})(e,map__33199,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_33225,inst_33201,inst_33224,inst_33227,inst_33226,inst_33223,inst_33221,inst_33231,inst_33222,inst_33221__$1,inst_33222__$1,inst_33223__$1,inst_33224__$1,inst_33225__$1,inst_33226__$1,inst_33227__$1,inst_33228,inst_33229,inst_33230,inst_33231__$1,state_val_33293,c__9230__auto__,event_chan))
,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null))));
});
;})(e,map__33199,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_33225,inst_33201,inst_33224,inst_33227,inst_33226,inst_33223,inst_33221,inst_33231,inst_33222,inst_33221__$1,inst_33222__$1,inst_33223__$1,inst_33224__$1,inst_33225__$1,inst_33226__$1,inst_33227__$1,inst_33228,inst_33229,inst_33230,inst_33231__$1,state_val_33293,c__9230__auto__,event_chan))
})();
var state_33292__$1 = (function (){var statearr_33346 = state_33292;
(statearr_33346[(12)] = inst_33225__$1);

(statearr_33346[(13)] = inst_33224__$1);

(statearr_33346[(10)] = inst_33227__$1);

(statearr_33346[(14)] = inst_33226__$1);

(statearr_33346[(8)] = inst_33223__$1);

(statearr_33346[(15)] = inst_33221__$1);

(statearr_33346[(9)] = inst_33231__$1);

(statearr_33346[(16)] = inst_33222__$1);

(statearr_33346[(17)] = inst_33232);

return statearr_33346;
})();
if(cljs.core.truth_(inst_33222__$1)){
var statearr_33347_33397 = state_33292__$1;
(statearr_33347_33397[(1)] = (17));

} else {
var statearr_33348_33398 = state_33292__$1;
(statearr_33348_33398[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (30))){
var state_33292__$1 = state_33292;
var statearr_33349_33399 = state_33292__$1;
(statearr_33349_33399[(2)] = null);

(statearr_33349_33399[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (10))){
var inst_33216 = (state_33292[(2)]);
var state_33292__$1 = state_33292;
if(cljs.core.truth_(inst_33216)){
var statearr_33350_33400 = state_33292__$1;
(statearr_33350_33400[(1)] = (14));

} else {
var statearr_33351_33401 = state_33292__$1;
(statearr_33351_33401[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (18))){
var state_33292__$1 = state_33292;
var statearr_33352_33402 = state_33292__$1;
(statearr_33352_33402[(2)] = null);

(statearr_33352_33402[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33293 === (8))){
var inst_33201 = (state_33292[(7)]);
var inst_33206 = inst_33201.cljs$lang$protocol_mask$partition0$;
var inst_33207 = (inst_33206 & (64));
var inst_33208 = inst_33201.cljs$core$ISeq$;
var inst_33209 = (inst_33207) || (inst_33208);
var state_33292__$1 = state_33292;
if(cljs.core.truth_(inst_33209)){
var statearr_33353_33403 = state_33292__$1;
(statearr_33353_33403[(1)] = (11));

} else {
var statearr_33354_33404 = state_33292__$1;
(statearr_33354_33404[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto__,event_chan))
;
return ((function (switch__9165__auto__,c__9230__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__9166__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__9166__auto____0 = (function (){
var statearr_33358 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33358[(0)] = hatti$views$table$handle_table_events_$_state_machine__9166__auto__);

(statearr_33358[(1)] = (1));

return statearr_33358;
});
var hatti$views$table$handle_table_events_$_state_machine__9166__auto____1 = (function (state_33292){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__(state_33292);
if(cljs.core.keyword_identical_QMARK_(result__9168__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e33359){if((e33359 instanceof Object)){
var ex__9169__auto__ = e33359;
var statearr_33360_33405 = state_33292;
(statearr_33360_33405[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33292);

return cljs.core.cst$kw$recur;
} else {
throw e33359;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__9167__auto__,cljs.core.cst$kw$recur)){
var G__33406 = state_33292;
state_33292 = G__33406;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__9166__auto__ = function(state_33292){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__9166__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__9166__auto____1.call(this,state_33292);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__9166__auto____0;
hatti$views$table$handle_table_events_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__9166__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto__,event_chan))
})();
var state__9232__auto__ = (function (){var statearr_33361 = (f__9231__auto__.cljs$core$IFn$_invoke$arity$0 ? f__9231__auto__.cljs$core$IFn$_invoke$arity$0() : f__9231__auto__.call(null));
(statearr_33361[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto__);

return statearr_33361;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__9232__auto__);
});})(c__9230__auto__,event_chan))
);

return c__9230__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$name_DASH_or_DASH_label,k);

return (colset_BANG_.cljs$core$IFn$_invoke$arity$1 ? colset_BANG_.cljs$core$IFn$_invoke$arity$1(k) : colset_BANG_.call(null,k));
});
var iter__5341__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__33417(s__33418){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__33418__$1 = s__33418;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__33418__$1);
if(temp__4425__auto__){
var s__33418__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__33418__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__33418__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__33420 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__33419 = (0);
while(true){
if((i__33419 < size__5340__auto__)){
var vec__33425 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__33419);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33425,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33425,(1),null);
cljs.core.chunk_append(b__33420,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (i__33419,vec__33425,k,v,c__5339__auto__,size__5340__auto__,b__33420,s__33418__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(i__33419,vec__33425,k,v,c__5339__auto__,size__5340__auto__,b__33420,s__33418__$2,temp__4425__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null));

var G__33427 = (i__33419 + (1));
i__33419 = G__33427;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33420),hatti$views$table$render_options_$_iter__33417(cljs.core.chunk_rest(s__33418__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33420),null);
}
} else {
var vec__33426 = cljs.core.first(s__33418__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33426,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33426,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (vec__33426,k,v,s__33418__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(vec__33426,k,v,s__33418__$2,temp__4425__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__33417(cljs.core.rest(s__33418__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__5341__auto__(options);
});
hatti.views.label_changer.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table33429 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table33429 = (function (_,owner,meta33430){
this._ = _;
this.owner = owner;
this.meta33430 = meta33430;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table33429.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33431,meta33430__$1){
var self__ = this;
var _33431__$1 = this;
return (new hatti.views.table.t_hatti$views$table33429(self__._,self__.owner,meta33430__$1));
});

hatti.views.table.t_hatti$views$table33429.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33431){
var self__ = this;
var _33431__$1 = this;
return self__.meta33430;
});

hatti.views.table.t_hatti$views$table33429.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table33429.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name_DASH_or_DASH_label,cljs.core.cst$kw$label], null);
});

hatti.views.table.t_hatti$views$table33429.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table33429.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__33432){
var self__ = this;
var map__33433 = p__33432;
var map__33433__$1 = ((((!((map__33433 == null)))?((((map__33433.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33433.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33433):map__33433);
var name_or_label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33433__$1,cljs.core.cst$kw$name_DASH_or_DASH_label);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33433__$1,cljs.core.cst$kw$language);
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Label"], null),cljs.core.cst$kw$name,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Name"], null)], null);
var map__33435 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__33435__$1 = ((((!((map__33435 == null)))?((((map__33435.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33435.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33435):map__33435);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33435__$1,cljs.core.cst$kw$flat_DASH_form);
var new_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var colset_BANG_ = ((function (options,map__33435,map__33435__$1,flat_form,new_language,___$2,map__33433,map__33433__$1,name_or_label,language){
return (function (p1__33428_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$new_DASH_columns,hatti.views.table.flat_form__GT_sg_columns(flat_form,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$label,p1__33428_SHARP_),new_language)], null));
});})(options,map__33435,map__33435__$1,flat_form,new_language,___$2,map__33433,map__33433__$1,name_or_label,language))
;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new_language,language)){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$language,new_language);

colset_BANG_(name_or_label);
} else {
}

var G__33444 = {"className": "label-changer"};
var G__33445 = (function (){var G__33447 = {"className": "label-changer-label"};
var G__33448 = "Show:";
return React.DOM.span(G__33447,G__33448);
})();
var G__33446 = (function (){var G__33449 = {"id": "header-display-dropdown", "className": "drop-hover"};
var G__33450 = (function (){var attrs33439 = (options.cljs$core$IFn$_invoke$arity$1 ? options.cljs$core$IFn$_invoke$arity$1(name_or_label) : options.call(null,name_or_label));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs33439))?sablono.interpreter.attributes(attrs33439):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs33439))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__33452 = {"className": "fa fa-angle-down"};
return React.DOM.i(G__33452);
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs33439),(function (){var G__33453 = {"className": "fa fa-angle-down"};
return React.DOM.i(G__33453);
})()], null))));
})();
var G__33451 = (function (){var G__33454 = {"className": "submenu no-dot"};
var G__33455 = sablono.interpreter.interpret(hatti.views.table.render_options(options,self__.owner,colset_BANG_));
return React.DOM.ul(G__33454,G__33455);
})();
return React.DOM.div(G__33449,G__33450,G__33451);
})();
return React.DOM.div(G__33444,G__33445,G__33446);
});

hatti.views.table.t_hatti$views$table33429.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta33430], null);
});

hatti.views.table.t_hatti$views$table33429.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table33429.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table33429";

hatti.views.table.t_hatti$views$table33429.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table33429");
});

hatti.views.table.__GT_t_hatti$views$table33429 = (function hatti$views$table$__GT_t_hatti$views$table33429(___$1,owner__$1,meta33430){
return (new hatti.views.table.t_hatti$views$table33429(___$1,owner__$1,meta33430));
});

}

return (new hatti.views.table.t_hatti$views$table33429(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__9230__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__9230__auto__,query){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto__,query){
return (function (state_33498){
var state_val_33499 = (state_33498[(1)]);
if((state_val_33499 === (1))){
var inst_33484 = cljs.core.async.timeout((150));
var state_33498__$1 = state_33498;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33498__$1,(2),inst_33484);
} else {
if((state_val_33499 === (2))){
var inst_33486 = (state_33498[(2)]);
var inst_33487 = input.value;
var inst_33488 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query,inst_33487);
var state_33498__$1 = (function (){var statearr_33500 = state_33498;
(statearr_33500[(7)] = inst_33486);

return statearr_33500;
})();
if(inst_33488){
var statearr_33501_33512 = state_33498__$1;
(statearr_33501_33512[(1)] = (3));

} else {
var statearr_33502_33513 = state_33498__$1;
(statearr_33502_33513[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33499 === (3))){
var inst_33490 = [query_event_key];
var inst_33491 = [query];
var inst_33492 = cljs.core.PersistentHashMap.fromArrays(inst_33490,inst_33491);
var inst_33493 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,inst_33492);
var state_33498__$1 = state_33498;
var statearr_33503_33514 = state_33498__$1;
(statearr_33503_33514[(2)] = inst_33493);

(statearr_33503_33514[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33499 === (4))){
var state_33498__$1 = state_33498;
var statearr_33504_33515 = state_33498__$1;
(statearr_33504_33515[(2)] = null);

(statearr_33504_33515[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33499 === (5))){
var inst_33496 = (state_33498[(2)]);
var state_33498__$1 = state_33498;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33498__$1,inst_33496);
} else {
return null;
}
}
}
}
}
});})(c__9230__auto__,query))
;
return ((function (switch__9165__auto__,c__9230__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__9166__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__9166__auto____0 = (function (){
var statearr_33508 = [null,null,null,null,null,null,null,null];
(statearr_33508[(0)] = hatti$views$table$delayed_search_$_state_machine__9166__auto__);

(statearr_33508[(1)] = (1));

return statearr_33508;
});
var hatti$views$table$delayed_search_$_state_machine__9166__auto____1 = (function (state_33498){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__(state_33498);
if(cljs.core.keyword_identical_QMARK_(result__9168__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e33509){if((e33509 instanceof Object)){
var ex__9169__auto__ = e33509;
var statearr_33510_33516 = state_33498;
(statearr_33510_33516[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33498);

return cljs.core.cst$kw$recur;
} else {
throw e33509;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__9167__auto__,cljs.core.cst$kw$recur)){
var G__33517 = state_33498;
state_33498 = G__33517;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__9166__auto__ = function(state_33498){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__9166__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__9166__auto____1.call(this,state_33498);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__9166__auto____0;
hatti$views$table$delayed_search_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__9166__auto____1;
return hatti$views$table$delayed_search_$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto__,query))
})();
var state__9232__auto__ = (function (){var statearr_33511 = (f__9231__auto__.cljs$core$IFn$_invoke$arity$0 ? f__9231__auto__.cljs$core$IFn$_invoke$arity$0() : f__9231__auto__.call(null));
(statearr_33511[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto__);

return statearr_33511;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__9232__auto__);
});})(c__9230__auto__,query))
);

return c__9230__auto__;
});
hatti.views.table_search.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table33519 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table33519 = (function (_,owner,meta33520){
this._ = _;
this.owner = owner;
this.meta33520 = meta33520;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table33519.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33521,meta33520__$1){
var self__ = this;
var _33521__$1 = this;
return (new hatti.views.table.t_hatti$views$table33519(self__._,self__.owner,meta33520__$1));
});

hatti.views.table.t_hatti$views$table33519.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33521){
var self__ = this;
var _33521__$1 = this;
return self__.meta33520;
});

hatti.views.table.t_hatti$views$table33519.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table33519.prototype.om$core$IRender$render$arity$1 = (function (this__6567__auto__){
var self__ = this;
var this__6567__auto____$1 = this;
var G__33524 = {"className": "table-search"};
var G__33525 = (function (){var G__33527 = {"className": "fa fa-search"};
return React.DOM.i(G__33527);
})();
var G__33526 = (function (){var G__33528 = {"type": "text", "placeholder": "Search", "onChange": ((function (G__33524,G__33525,this__6567__auto____$1){
return (function (p1__33518_SHARP_){
return hatti.views.table.delayed_search(p1__33518_SHARP_.target,cljs.core.cst$kw$filter_DASH_by);
});})(G__33524,G__33525,this__6567__auto____$1))
};
return (sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1 ? sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1(G__33528) : sablono.interpreter.input.call(null,G__33528));
})();
return React.DOM.div(G__33524,G__33525,G__33526);
});

hatti.views.table.t_hatti$views$table33519.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta33520], null);
});

hatti.views.table.t_hatti$views$table33519.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table33519.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table33519";

hatti.views.table.t_hatti$views$table33519.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table33519");
});

hatti.views.table.__GT_t_hatti$views$table33519 = (function hatti$views$table$__GT_t_hatti$views$table33519(___$1,owner__$1,meta33520){
return (new hatti.views.table.t_hatti$views$table33519(___$1,owner__$1,meta33520));
});

}

return (new hatti.views.table.t_hatti$views$table33519(_,owner,null));
}));
hatti.views.table_header.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner){
if(typeof hatti.views.table.t_hatti$views$table33529 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table33529 = (function (app_state,owner,meta33530){
this.app_state = app_state;
this.owner = owner;
this.meta33530 = meta33530;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table33529.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33531,meta33530__$1){
var self__ = this;
var _33531__$1 = this;
return (new hatti.views.table.t_hatti$views$table33529(self__.app_state,self__.owner,meta33530__$1));
});

hatti.views.table.t_hatti$views$table33529.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33531){
var self__ = this;
var _33531__$1 = this;
return self__.meta33530;
});

hatti.views.table.t_hatti$views$table33529.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table33529.prototype.om$core$IRender$render$arity$1 = (function (this__6567__auto__){
var self__ = this;
var this__6567__auto____$1 = this;
var G__33534 = {"className": "topbar"};
var G__33535 = (function (){var G__33539 = {"id": hatti.views.table.pager_id};
return React.DOM.div(G__33539);
})();
var G__33536 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.label_changer,null));
var G__33537 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_search,self__.app_state));
var G__33538 = (function (){var G__33540 = {"style": {"clear": "both"}};
return React.DOM.div(G__33540);
})();
return React.DOM.div(G__33534,G__33535,G__33536,G__33537,G__33538);
});

hatti.views.table.t_hatti$views$table33529.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta33530], null);
});

hatti.views.table.t_hatti$views$table33529.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table33529.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table33529";

hatti.views.table.t_hatti$views$table33529.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table33529");
});

hatti.views.table.__GT_t_hatti$views$table33529 = (function hatti$views$table$__GT_t_hatti$views$table33529(app_state__$1,owner__$1,meta33530){
return (new hatti.views.table.t_hatti$views$table33529(app_state__$1,owner__$1,meta33530));
});

}

return (new hatti.views.table.t_hatti$views$table33529(app_state,owner,null));
}));
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){

if(cljs.core.seq(data)){
var map__33544 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(owner);
var map__33544__$1 = ((((!((map__33544 == null)))?((((map__33544.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33544.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33544):map__33544);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33544__$1,cljs.core.cst$kw$flat_DASH_form);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33544__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var current_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(owner,hatti.shared.language_cursor()));
var vec__33545 = hatti.views.table.sg_init(data,flat_form,current_language,is_filtered_dataview_QMARK_,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33545,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33545,(1),null);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$grid,grid);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$dataview,dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table.get_table_view_height = (function hatti$views$table$get_table_view_height(){
return (document.querySelector("body").clientHeight - document.querySelector(".tab-page").getBoundingClientRect().top);
});
hatti.views.table.set_window_resize_handler = (function hatti$views$table$set_window_resize_handler(owner){
var resize_handler = (function (event){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$table_DASH_view_DASH_height,hatti.views.table.get_table_view_height());
});
window.addEventListener("resize",resize_handler);

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$resize_DASH_handler,resize_handler);
});
hatti.views.table_page.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner,p__33548){
var map__33549 = p__33548;
var map__33549__$1 = ((((!((map__33549 == null)))?((((map__33549.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33549.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33549):map__33549);
var opts = map__33549__$1;
var slick_grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33549__$1,cljs.core.cst$kw$slick_DASH_grid_DASH_event_DASH_handlers);

if(typeof hatti.views.table.t_hatti$views$table33551 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table33551 = (function (app_state,owner,p__33548,map__33549,opts,slick_grid_event_handlers,meta33552){
this.app_state = app_state;
this.owner = owner;
this.p__33548 = p__33548;
this.map__33549 = map__33549;
this.opts = opts;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.meta33552 = meta33552;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table33551.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__33549,map__33549__$1,opts,slick_grid_event_handlers){
return (function (_33553,meta33552__$1){
var self__ = this;
var _33553__$1 = this;
return (new hatti.views.table.t_hatti$views$table33551(self__.app_state,self__.owner,self__.p__33548,self__.map__33549,self__.opts,self__.slick_grid_event_handlers,meta33552__$1));
});})(map__33549,map__33549__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table33551.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__33549,map__33549__$1,opts,slick_grid_event_handlers){
return (function (_33553){
var self__ = this;
var _33553__$1 = this;
return self__.meta33552;
});})(map__33549,map__33549__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table33551.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table33551.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (map__33549,map__33549__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
hatti.views.table.set_window_resize_handler(self__.owner);

var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_(data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__33554 = temp__4425__auto__;
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33554,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33554,(1),null);
return hatti.views.table.handle_table_events(self__.app_state,grid,dataview);
} else {
return null;
}
});})(map__33549,map__33549__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table33551.prototype.om$core$IWillUnmount$ = true;

hatti.views.table.t_hatti$views$table33551.prototype.om$core$IWillUnmount$will_unmount$arity$1 = ((function (map__33549,map__33549__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
return window.removeEventListener("resize",om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$resize_DASH_handler));
});})(map__33549,map__33549__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table33551.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table33551.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (map__33549,map__33549__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

var old_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(om.core.get_props.cljs$core$IFn$_invoke$arity$1(self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var new_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var map__33555 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__33555__$1 = ((((!((map__33555 == null)))?((((map__33555.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33555.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33555):map__33555);
var grid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33555__$1,cljs.core.cst$kw$grid);
var dataview = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33555__$1,cljs.core.cst$kw$dataview);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_data,new_data)){
if(cljs.core.empty_QMARK_(old_data)){
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_(new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__33557 = temp__4425__auto__;
var grid__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33557,(0),null);
var dataview__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33557,(1),null);
return hatti.views.table.handle_table_events(self__.app_state,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js(new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
});})(map__33549,map__33549__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table33551.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table33551.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__33549,map__33549__$1,opts,slick_grid_event_handlers){
return (function (_,p__33558){
var self__ = this;
var map__33559 = p__33558;
var map__33559__$1 = ((((!((map__33559 == null)))?((((map__33559.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33559.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33559):map__33559);
var table_view_height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33559__$1,cljs.core.cst$kw$table_DASH_view_DASH_height);
var ___$1 = this;
var map__33561 = self__.app_state;
var map__33561__$1 = ((((!((map__33561 == null)))?((((map__33561.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33561.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33561):map__33561);
var map__33562 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33561__$1,cljs.core.cst$kw$table_DASH_page);
var map__33562__$1 = ((((!((map__33562 == null)))?((((map__33562.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33562.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33562):map__33562);
var prevent_scrolling_in_table_view_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33562__$1,cljs.core.cst$kw$prevent_DASH_scrolling_DASH_in_DASH_table_DASH_view_QMARK_);
var submission_clicked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33562__$1,cljs.core.cst$kw$submission_DASH_clicked);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33561__$1,cljs.core.cst$kw$data);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33561__$1,cljs.core.cst$kw$dataset_DASH_info);
var map__33563 = dataset_info;
var map__33563__$1 = ((((!((map__33563 == null)))?((((map__33563.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33563.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33563):map__33563);
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33563__$1,cljs.core.cst$kw$num_of_submissions);
var no_data_QMARK_ = cljs.core.empty_QMARK_(data);
var with_info = ((function (map__33561,map__33561__$1,map__33562,map__33562__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__33563,map__33563__$1,num_of_submissions,no_data_QMARK_,___$1,map__33559,map__33559__$1,table_view_height,map__33549,map__33549__$1,opts,slick_grid_event_handlers){
return (function (p1__33547_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__33547_SHARP_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$dataset_DASH_info,dataset_info], null)], 0));
});})(map__33561,map__33561__$1,map__33562,map__33562__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__33563,map__33563__$1,num_of_submissions,no_data_QMARK_,___$1,map__33559,map__33559__$1,table_view_height,map__33549,map__33549__$1,opts,slick_grid_event_handlers))
;
var G__33567 = {"style": cljs.core.clj__GT_js((cljs.core.truth_(prevent_scrolling_in_table_view_QMARK_)?new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$height,(function (){var or__4569__auto__ = table_view_height;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return hatti.views.table.get_table_view_height();
}
})(),cljs.core.cst$kw$overflow,"hidden"], null):null)), "className": "table-view"};
var G__33568 = sablono.interpreter.interpret((cljs.core.truth_(cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(submission_clicked))?om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.submission_view,with_info(submission_clicked),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.select_keys(self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$role,null,cljs.core.cst$kw$delete_DASH_record_BANG_,null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,cljs.core.cst$kw$table], null)], 0))], null)):null));
var G__33569 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.app_state));
var G__33570 = (function (){var G__33571 = {"id": hatti.views.table.table_id, "className": "slickgrid"};
var G__33572 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__33577 = {"className": "empty-state"};
var G__33578 = "No data";
return React.DOM.span(G__33577,G__33578);
})():(function (){var G__33580 = null;
var G__33581 = (function (){var G__33583 = {"className": "fa fa-spinner fa-pulse"};
return React.DOM.i(G__33583);
})();
var G__33582 = "Loading...";
return React.DOM.span(G__33580,G__33581,G__33582);
})());
return React.DOM.div(G__33571,G__33572);
})();
return React.DOM.div(G__33567,G__33568,G__33569,G__33570);
});})(map__33549,map__33549__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table33551.getBasis = ((function (map__33549,map__33549__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__33548,cljs.core.cst$sym$map__33549,cljs.core.cst$sym$opts,cljs.core.cst$sym$slick_DASH_grid_DASH_event_DASH_handlers,cljs.core.cst$sym$meta33552], null);
});})(map__33549,map__33549__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table33551.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table33551.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table33551";

hatti.views.table.t_hatti$views$table33551.cljs$lang$ctorPrWriter = ((function (map__33549,map__33549__$1,opts,slick_grid_event_handlers){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"hatti.views.table/t_hatti$views$table33551");
});})(map__33549,map__33549__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table33551 = ((function (map__33549,map__33549__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table33551(app_state__$1,owner__$1,p__33548__$1,map__33549__$2,opts__$1,slick_grid_event_handlers__$1,meta33552){
return (new hatti.views.table.t_hatti$views$table33551(app_state__$1,owner__$1,p__33548__$1,map__33549__$2,opts__$1,slick_grid_event_handlers__$1,meta33552));
});})(map__33549,map__33549__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table33551(app_state,owner,p__33548,map__33549__$1,opts,slick_grid_event_handlers,cljs.core.PersistentArrayMap.EMPTY));
}));
