// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.utils.om.state');
goog.require('cljs.core');
goog.require('om.core');
/**
 * A transact! function that optionally uses swap! if this atom is not yet
 * transactable?
 */
hatti.utils.om.state.transact_BANG_ = (function hatti$utils$om$state$transact_BANG_(app_state){
if(((!((app_state == null)))?(((false) || (app_state.om$core$ITransact$))?true:(((!app_state.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(om.core.ITransact,app_state):false)):cljs.core.native_satisfies_QMARK_(om.core.ITransact,app_state))){
return om.core.transact_BANG_;
} else {
return cljs.core.swap_BANG_;
}
});
/**
 * Like om/transact! but also works on atoms that are not transactable?
 */
hatti.utils.om.state.transact_app_state_BANG_ = (function hatti$utils$om$state$transact_app_state_BANG_(var_args){
var args30623 = [];
var len__5627__auto___30626 = arguments.length;
var i__5628__auto___30627 = (0);
while(true){
if((i__5628__auto___30627 < len__5627__auto___30626)){
args30623.push((arguments[i__5628__auto___30627]));

var G__30628 = (i__5628__auto___30627 + (1));
i__5628__auto___30627 = G__30628;
continue;
} else {
}
break;
}

var G__30625 = args30623.length;
switch (G__30625) {
case 2:
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30623.length)].join('')));

}
});

hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (app_state,transact_fn){
return hatti.utils.om.state.transact_BANG_(app_state).call(null,app_state,transact_fn);
});

hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (app_state,ks,transact_fn){
return hatti.utils.om.state.transact_BANG_(app_state).call(null,app_state,(function (p1__30622_SHARP_){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(p1__30622_SHARP_,ks,transact_fn);
}));
});

hatti.utils.om.state.transact_app_state_BANG_.cljs$lang$maxFixedArity = 3;
/**
 * Like om/update! but also works on atoms that are not transactable?
 */
hatti.utils.om.state.update_app_state_BANG_ = (function hatti$utils$om$state$update_app_state_BANG_(var_args){
var args30630 = [];
var len__5627__auto___30633 = arguments.length;
var i__5628__auto___30634 = (0);
while(true){
if((i__5628__auto___30634 < len__5627__auto___30633)){
args30630.push((arguments[i__5628__auto___30634]));

var G__30635 = (i__5628__auto___30634 + (1));
i__5628__auto___30634 = G__30635;
continue;
} else {
}
break;
}

var G__30632 = args30630.length;
switch (G__30632) {
case 2:
return hatti.utils.om.state.update_app_state_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.utils.om.state.update_app_state_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30630.length)].join('')));

}
});

hatti.utils.om.state.update_app_state_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (app_state,update_val){
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$2(app_state,(function (){
return update_val;
}));
});

hatti.utils.om.state.update_app_state_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (app_state,ks,update_val){
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,ks,(function (){
return update_val;
}));
});

hatti.utils.om.state.update_app_state_BANG_.cljs$lang$maxFixedArity = 3;
/**
 * Merges provided state into existing app-state, possibly after zoomint into
 * ks.
 */
hatti.utils.om.state.merge_into_app_state_BANG_ = (function hatti$utils$om$state$merge_into_app_state_BANG_(var_args){
var args30639 = [];
var len__5627__auto___30642 = arguments.length;
var i__5628__auto___30643 = (0);
while(true){
if((i__5628__auto___30643 < len__5627__auto___30642)){
args30639.push((arguments[i__5628__auto___30643]));

var G__30644 = (i__5628__auto___30643 + (1));
i__5628__auto___30643 = G__30644;
continue;
} else {
}
break;
}

var G__30641 = args30639.length;
switch (G__30641) {
case 2:
return hatti.utils.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.utils.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30639.length)].join('')));

}
});

hatti.utils.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (app_state,state_to_merge){
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$2(app_state,(function (p1__30637_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__30637_SHARP_,state_to_merge], 0));
}));
});

hatti.utils.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (app_state,ks,state_to_merge){
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,ks,(function (p1__30638_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__30638_SHARP_,state_to_merge], 0));
}));
});

hatti.utils.om.state.merge_into_app_state_BANG_.cljs$lang$maxFixedArity = 3;
