// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.utils');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string.format');
goog.require('goog.string');
goog.require('inflections.core');
goog.require('sablono.core');
hatti.utils.url = (function hatti$utils$url(var_args){
var args__5634__auto__ = [];
var len__5627__auto___26912 = arguments.length;
var i__5628__auto___26913 = (0);
while(true){
if((i__5628__auto___26913 < len__5627__auto___26912)){
args__5634__auto__.push((arguments[i__5628__auto___26913]));

var G__26914 = (i__5628__auto___26913 + (1));
i__5628__auto___26913 = G__26914;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return hatti.utils.url.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

hatti.utils.url.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str("/"),cljs.core.str(clojure.string.join.cljs$core$IFn$_invoke$arity$2("/",cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args)))].join('');
});

hatti.utils.url.cljs$lang$maxFixedArity = (0);

hatti.utils.url.cljs$lang$applyTo = (function (seq26911){
return hatti.utils.url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26911));
});
/**
 * Get last parameter form url
 */
hatti.utils.last_url_param = (function hatti$utils$last_url_param(url){
var last_param = cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2([cljs.core.str(url)].join(''),/\//));
return cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2([cljs.core.str(last_param)].join(''),/.json/));
});
/**
 * Convert json to js using JSON.parse
 */
hatti.utils.json__GT_js = (function hatti$utils$json__GT_js(s){
return JSON.parse(s);
});
/**
 * Convert json string to cljs object.
 * Fast, but doesn't preserve keywords.
 */
hatti.utils.json__GT_cljs = (function hatti$utils$json__GT_cljs(s){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(hatti.utils.json__GT_js(s));
});
/**
 * Convert json string to cljs via js.
 * Slow method, but preserves keywords, and appropriate for small json.
 */
hatti.utils.json__GT_js__GT_cljs = (function hatti$utils$json__GT_js__GT_cljs(s){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(hatti.utils.json__GT_js(s),cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Formats a string using goog.string.format, so we can use format in cljx.
 */
hatti.utils.format = (function hatti$utils$format(var_args){
var args__5634__auto__ = [];
var len__5627__auto___26917 = arguments.length;
var i__5628__auto___26918 = (0);
while(true){
if((i__5628__auto___26918 < len__5627__auto___26917)){
args__5634__auto__.push((arguments[i__5628__auto___26918]));

var G__26919 = (i__5628__auto___26918 + (1));
i__5628__auto___26918 = G__26919;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.utils.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.utils.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(goog.string.format,fmt,args);
});

hatti.utils.format.cljs$lang$maxFixedArity = (1);

hatti.utils.format.cljs$lang$applyTo = (function (seq26915){
var G__26916 = cljs.core.first(seq26915);
var seq26915__$1 = cljs.core.next(seq26915);
return hatti.utils.format.cljs$core$IFn$_invoke$arity$variadic(G__26916,seq26915__$1);
});
/**
 * Create a safe (escaped) js regex out of a string.
 * By default, creates regex with ignore case option.
 */
hatti.utils.safe_regex = (function hatti$utils$safe_regex(var_args){
var args__5634__auto__ = [];
var len__5627__auto___26925 = arguments.length;
var i__5628__auto___26926 = (0);
while(true){
if((i__5628__auto___26926 < len__5627__auto___26925)){
args__5634__auto__.push((arguments[i__5628__auto___26926]));

var G__26927 = (i__5628__auto___26926 + (1));
i__5628__auto___26926 = G__26927;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.utils.safe_regex.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.utils.safe_regex.cljs$core$IFn$_invoke$arity$variadic = (function (s,p__26922){
var map__26923 = p__26922;
var map__26923__$1 = ((((!((map__26923 == null)))?((((map__26923.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26923.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26923):map__26923);
var ignore_case_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__26923__$1,cljs.core.cst$kw$ignore_DASH_case_QMARK_,true);
var s__$1 = s.replace(/\/[\-\[\]\\/\{\}\(\)\*\+\?\.\\\^\$\|]\//,"\\$&");
return (new RegExp(s__$1,"i"));

});

hatti.utils.safe_regex.cljs$lang$maxFixedArity = (1);

hatti.utils.safe_regex.cljs$lang$applyTo = (function (seq26920){
var G__26921 = cljs.core.first(seq26920);
var seq26920__$1 = cljs.core.next(seq26920);
return hatti.utils.safe_regex.cljs$core$IFn$_invoke$arity$variadic(G__26921,seq26920__$1);
});
/**
 * Given a seq, produces a two-el seq. [a b c] => [[0 a] [1 b] [2 c]].
 */
hatti.utils.indexed = (function hatti$utils$indexed(coll){
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,coll);
});
/**
 * Helper function to create a click function that prevents default
 */
hatti.utils.click_fn = (function hatti$utils$click_fn(f){
return (function (event){
event.preventDefault();

return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
});
});
/**
 * Create an appropriately pluralized string prefix by number.
 */
hatti.utils.pluralize_number = (function hatti$utils$pluralize_number(number,kind){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [number,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),number))?kind:inflections.core.plural(kind))], null));
});
/**
 * True if substring is a substring of string
 */
hatti.utils.substring_QMARK_ = (function hatti$utils$substring_QMARK_(var_args){
var args26928 = [];
var len__5627__auto___26937 = arguments.length;
var i__5628__auto___26938 = (0);
while(true){
if((i__5628__auto___26938 < len__5627__auto___26937)){
args26928.push((arguments[i__5628__auto___26938]));

var G__26939 = (i__5628__auto___26938 + (1));
i__5628__auto___26938 = G__26939;
continue;
} else {
}
break;
}

var G__26933 = args26928.length;
switch (G__26933) {
case 2:
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args26928.slice((2)),(0)));
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (substring,string){
return cljs.core.complement(cljs.core.nil_QMARK_).call(null,cljs.core.re_find(cljs.core.re_pattern(substring),string));
});

hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (substring,string,p__26934){
var map__26935 = p__26934;
var map__26935__$1 = ((((!((map__26935 == null)))?((((map__26935.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26935.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26935):map__26935);
var case_sensitive_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26935__$1,cljs.core.cst$kw$case_DASH_sensitive_QMARK_);
if(cljs.core.truth_(case_sensitive_QMARK_)){
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2(substring,string);
} else {
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2(clojure.string.lower_case(substring),clojure.string.lower_case(string));
}
});

hatti.utils.substring_QMARK_.cljs$lang$applyTo = (function (seq26929){
var G__26930 = cljs.core.first(seq26929);
var seq26929__$1 = cljs.core.next(seq26929);
var G__26931 = cljs.core.first(seq26929__$1);
var seq26929__$2 = cljs.core.next(seq26929__$1);
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__26930,G__26931,seq26929__$2);
});

hatti.utils.substring_QMARK_.cljs$lang$maxFixedArity = (2);
hatti.utils.hyphen__GT_camel_case = (function hatti$utils$hyphen__GT_camel_case(source_string){
return clojure.string.replace(source_string,/(-)(.)/,(function (p1__26941_SHARP_){
var vec__26943 = p1__26941_SHARP_;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26943,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26943,(1),null);
var letter_to_uppercase = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26943,(2),null);
return clojure.string.upper_case(letter_to_uppercase);
}));
});
hatti.utils.generate_component = (function hatti$utils$generate_component(element_definition_vector){
return sablono.interpreter.interpret(element_definition_vector);
});
/**
 * This function generates HTML from hiccup-style vectors, and concatenates
 *   the resulting markup. Strings are returned unaffected.
 */
hatti.utils.generate_html = (function hatti$utils$generate_html(var_args){
var args__5634__auto__ = [];
var len__5627__auto___26945 = arguments.length;
var i__5628__auto___26946 = (0);
while(true){
if((i__5628__auto___26946 < len__5627__auto___26945)){
args__5634__auto__.push((arguments[i__5628__auto___26946]));

var G__26947 = (i__5628__auto___26946 + (1));
i__5628__auto___26946 = G__26947;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic = (function (element_definition_vectors){
var components = cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.utils.generate_component,element_definition_vectors);
var components_as_static_markup = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (components){
return (function (component){
if(typeof component === 'string'){
return component;
} else {
return sablono.core.render_static(component);
}
});})(components))
,components);
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(components_as_static_markup);
});

hatti.utils.generate_html.cljs$lang$maxFixedArity = (0);

hatti.utils.generate_html.cljs$lang$applyTo = (function (seq26944){
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26944));
});
