// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.stream');
goog.require('cljs.core');
goog.require('cljs.core.async');
hatti.ona.stream.small_delay = (10);
/**
 * Calls callback on aggregated data that come via messages in channel.
 * Callback accepts two arguments: data (cljs list), and completed? (bool)
 *   If there is a parser in message, resume it after a timeout.
 */
hatti.ona.stream.process_aggregated_data_BANG_ = (function hatti$ona$stream$process_aggregated_data_BANG_(agg_data_channel,callback){
var c__9230__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__9230__auto__){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto__){
return (function (state_30535){
var state_val_30536 = (state_30535[(1)]);
if((state_val_30536 === (7))){
var inst_30492 = (state_30535[(7)]);
var inst_30492__$1 = (state_30535[(2)]);
var inst_30494 = (inst_30492__$1 == null);
var inst_30495 = cljs.core.not(inst_30494);
var state_30535__$1 = (function (){var statearr_30537 = state_30535;
(statearr_30537[(7)] = inst_30492__$1);

return statearr_30537;
})();
if(inst_30495){
var statearr_30538_30575 = state_30535__$1;
(statearr_30538_30575[(1)] = (8));

} else {
var statearr_30539_30576 = state_30535__$1;
(statearr_30539_30576[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30536 === (20))){
var inst_30514 = (state_30535[(8)]);
var inst_30522 = (state_30535[(2)]);
var state_30535__$1 = (function (){var statearr_30540 = state_30535;
(statearr_30540[(9)] = inst_30522);

return statearr_30540;
})();
if(cljs.core.truth_(inst_30514)){
var statearr_30541_30577 = state_30535__$1;
(statearr_30541_30577[(1)] = (21));

} else {
var statearr_30542_30578 = state_30535__$1;
(statearr_30542_30578[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30536 === (1))){
var state_30535__$1 = state_30535;
var statearr_30543_30579 = state_30535__$1;
(statearr_30543_30579[(2)] = null);

(statearr_30543_30579[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30536 === (4))){
var state_30535__$1 = state_30535;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30535__$1,(7),agg_data_channel);
} else {
if((state_val_30536 === (15))){
var inst_30492 = (state_30535[(7)]);
var state_30535__$1 = state_30535;
var statearr_30544_30580 = state_30535__$1;
(statearr_30544_30580[(2)] = inst_30492);

(statearr_30544_30580[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30536 === (21))){
var inst_30524 = cljs.core.async.close_BANG_(agg_data_channel);
var state_30535__$1 = state_30535;
var statearr_30545_30581 = state_30535__$1;
(statearr_30545_30581[(2)] = inst_30524);

(statearr_30545_30581[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30536 === (13))){
var inst_30504 = (state_30535[(2)]);
var state_30535__$1 = state_30535;
var statearr_30546_30582 = state_30535__$1;
(statearr_30546_30582[(2)] = inst_30504);

(statearr_30546_30582[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30536 === (22))){
var state_30535__$1 = state_30535;
var statearr_30547_30583 = state_30535__$1;
(statearr_30547_30583[(2)] = null);

(statearr_30547_30583[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30536 === (6))){
var inst_30531 = (state_30535[(2)]);
var state_30535__$1 = state_30535;
var statearr_30548_30584 = state_30535__$1;
(statearr_30548_30584[(2)] = inst_30531);

(statearr_30548_30584[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30536 === (17))){
var inst_30514 = (state_30535[(8)]);
var inst_30513 = (state_30535[(10)]);
var inst_30516 = (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(inst_30513,inst_30514) : callback.call(null,inst_30513,inst_30514));
var state_30535__$1 = state_30535;
var statearr_30549_30585 = state_30535__$1;
(statearr_30549_30585[(2)] = inst_30516);

(statearr_30549_30585[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30536 === (3))){
var inst_30533 = (state_30535[(2)]);
var state_30535__$1 = state_30535;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30535__$1,inst_30533);
} else {
if((state_val_30536 === (12))){
var state_30535__$1 = state_30535;
var statearr_30550_30586 = state_30535__$1;
(statearr_30550_30586[(2)] = false);

(statearr_30550_30586[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30536 === (2))){
var state_30535__$1 = state_30535;
var statearr_30551_30587 = state_30535__$1;
(statearr_30551_30587[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_30536 === (23))){
var inst_30527 = (state_30535[(2)]);
var state_30535__$1 = (function (){var statearr_30553 = state_30535;
(statearr_30553[(11)] = inst_30527);

return statearr_30553;
})();
var statearr_30554_30588 = state_30535__$1;
(statearr_30554_30588[(2)] = null);

(statearr_30554_30588[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30536 === (19))){
var inst_30519 = (state_30535[(2)]);
var inst_30520 = cljs.core.async.timeout(hatti.ona.stream.small_delay);
var state_30535__$1 = (function (){var statearr_30555 = state_30535;
(statearr_30555[(12)] = inst_30519);

return statearr_30555;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30535__$1,(20),inst_30520);
} else {
if((state_val_30536 === (11))){
var state_30535__$1 = state_30535;
var statearr_30556_30589 = state_30535__$1;
(statearr_30556_30589[(2)] = true);

(statearr_30556_30589[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30536 === (9))){
var state_30535__$1 = state_30535;
var statearr_30557_30590 = state_30535__$1;
(statearr_30557_30590[(2)] = false);

(statearr_30557_30590[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30536 === (5))){
var state_30535__$1 = state_30535;
var statearr_30558_30591 = state_30535__$1;
(statearr_30558_30591[(2)] = null);

(statearr_30558_30591[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30536 === (14))){
var inst_30492 = (state_30535[(7)]);
var inst_30509 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_30492);
var state_30535__$1 = state_30535;
var statearr_30559_30592 = state_30535__$1;
(statearr_30559_30592[(2)] = inst_30509);

(statearr_30559_30592[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30536 === (16))){
var inst_30513 = (state_30535[(10)]);
var inst_30512 = (state_30535[(2)]);
var inst_30513__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30512,cljs.core.cst$kw$data);
var inst_30514 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30512,cljs.core.cst$kw$completed_QMARK_);
var state_30535__$1 = (function (){var statearr_30560 = state_30535;
(statearr_30560[(8)] = inst_30514);

(statearr_30560[(10)] = inst_30513__$1);

return statearr_30560;
})();
if(cljs.core.truth_(inst_30513__$1)){
var statearr_30561_30593 = state_30535__$1;
(statearr_30561_30593[(1)] = (17));

} else {
var statearr_30562_30594 = state_30535__$1;
(statearr_30562_30594[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30536 === (10))){
var inst_30507 = (state_30535[(2)]);
var state_30535__$1 = state_30535;
if(cljs.core.truth_(inst_30507)){
var statearr_30563_30595 = state_30535__$1;
(statearr_30563_30595[(1)] = (14));

} else {
var statearr_30564_30596 = state_30535__$1;
(statearr_30564_30596[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30536 === (18))){
var state_30535__$1 = state_30535;
var statearr_30565_30597 = state_30535__$1;
(statearr_30565_30597[(2)] = null);

(statearr_30565_30597[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30536 === (8))){
var inst_30492 = (state_30535[(7)]);
var inst_30497 = inst_30492.cljs$lang$protocol_mask$partition0$;
var inst_30498 = (inst_30497 & (64));
var inst_30499 = inst_30492.cljs$core$ISeq$;
var inst_30500 = (inst_30498) || (inst_30499);
var state_30535__$1 = state_30535;
if(cljs.core.truth_(inst_30500)){
var statearr_30566_30598 = state_30535__$1;
(statearr_30566_30598[(1)] = (11));

} else {
var statearr_30567_30599 = state_30535__$1;
(statearr_30567_30599[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto__))
;
return ((function (switch__9165__auto__,c__9230__auto__){
return (function() {
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__9166__auto__ = null;
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__9166__auto____0 = (function (){
var statearr_30571 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30571[(0)] = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__9166__auto__);

(statearr_30571[(1)] = (1));

return statearr_30571;
});
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__9166__auto____1 = (function (state_30535){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__(state_30535);
if(cljs.core.keyword_identical_QMARK_(result__9168__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e30572){if((e30572 instanceof Object)){
var ex__9169__auto__ = e30572;
var statearr_30573_30600 = state_30535;
(statearr_30573_30600[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30535);

return cljs.core.cst$kw$recur;
} else {
throw e30572;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__9167__auto__,cljs.core.cst$kw$recur)){
var G__30601 = state_30535;
state_30535 = G__30601;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__9166__auto__ = function(state_30535){
switch(arguments.length){
case 0:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__9166__auto____0.call(this);
case 1:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__9166__auto____1.call(this,state_30535);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__9166__auto____0;
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__9166__auto____1;
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto__))
})();
var state__9232__auto__ = (function (){var statearr_30574 = (f__9231__auto__.cljs$core$IFn$_invoke$arity$0 ? f__9231__auto__.cljs$core$IFn$_invoke$arity$0() : f__9231__auto__.call(null));
(statearr_30574[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto__);

return statearr_30574;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__9232__auto__);
});})(c__9230__auto__))
);

return c__9230__auto__;
});
/**
 * On each step of data, increment read-count atom, and put data in a list agg.
 * After a exponentially increasing # of steps have been processed,
 * the aggregated data gets flushed into a channel, and parser is paused.
 * The channel reader should resume the parser after processing the data.
 */
hatti.ona.stream.read_next_chunk_BANG_ = (function hatti$ona$stream$read_next_chunk_BANG_(data_chunk,read_count,agg,channel){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(read_count,cljs.core.inc);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(agg,cljs.core.conj,data_chunk);

if((((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)) >= (100))) && (cljs.core.integer_QMARK_(Math.log10((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)))))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg))], null));

var G__30604_30606 = agg;
var G__30605_30607 = cljs.core.PersistentVector.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__30604_30606,G__30605_30607) : cljs.core.reset_BANG_.call(null,G__30604_30606,G__30605_30607));

return oboe.drop();
} else {
return null;
}
});
/**
 * Given url, a node pattern matcher, and a callback, streaming-read json.
 */
hatti.ona.stream.streamingly_read_json_BANG_ = (function hatti$ona$stream$streamingly_read_json_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___30615 = arguments.length;
var i__5628__auto___30616 = (0);
while(true){
if((i__5628__auto___30616 < len__5627__auto___30615)){
args__5634__auto__.push((arguments[i__5628__auto___30616]));

var G__30617 = (i__5628__auto___30616 + (1));
i__5628__auto___30616 = G__30617;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (url,stepfn,p__30611){
var map__30612 = p__30611;
var map__30612__$1 = ((((!((map__30612 == null)))?((((map__30612.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30612.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30612):map__30612);
var oboe_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30612__$1,cljs.core.cst$kw$oboe_DASH_headers);
var read_count = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0)) : cljs.core.atom.call(null,(0)));
var agg = (function (){var G__30614 = cljs.core.PersistentVector.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__30614) : cljs.core.atom.call(null,G__30614));
})();
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var return_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var oboe_params = cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$headers,oboe_headers,cljs.core.cst$kw$withCredentials,true], null));
var step = ((function (read_count,agg,channel,return_channel,oboe_params,map__30612,map__30612__$1,oboe_headers){
return (function (line){
return hatti.ona.stream.read_next_chunk_BANG_(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(line),read_count,agg,channel);
});})(read_count,agg,channel,return_channel,oboe_params,map__30612,map__30612__$1,oboe_headers))
;
var done = ((function (read_count,agg,channel,return_channel,oboe_params,step,map__30612,map__30612__$1,oboe_headers){
return (function (){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg)),cljs.core.cst$kw$completed_QMARK_,true], null));

return cljs.core.async.close_BANG_(return_channel);
});})(read_count,agg,channel,return_channel,oboe_params,step,map__30612,map__30612__$1,oboe_headers))
;
hatti.ona.stream.process_aggregated_data_BANG_(channel,stepfn);

window.oboe(oboe_params).node("!.*",step).done(done);

return return_channel;
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$applyTo = (function (seq30608){
var G__30609 = cljs.core.first(seq30608);
var seq30608__$1 = cljs.core.next(seq30608);
var G__30610 = cljs.core.first(seq30608__$1);
var seq30608__$2 = cljs.core.next(seq30608__$1);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__30609,G__30610,seq30608__$2);
});
