// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.post_process');
goog.require('cljs.core');
goog.require('hatti.ona.forms');
goog.require('hatti.ona.urls');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.utils');
goog.require('hatti.utils.om.state');
/**
 * Given some data in Ona format, builds a data structure that we will use
 * to link osm data to Ona data.
 */
hatti.ona.post_process.ona_osm_link = (function hatti$ona$post_process$ona_osm_link(data,form){
var osmfields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.flatten((function (){var iter__5341__auto__ = ((function (osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__30964(s__30965){
return (new cljs.core.LazySeq(null,((function (osmfields){
return (function (){
var s__30965__$1 = s__30965;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__30965__$1);
if(temp__4425__auto__){
var s__30965__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__30965__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__30965__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__30967 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__30966 = (0);
while(true){
if((i__30966 < size__5340__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__30966);
cljs.core.chunk_append(b__30967,(function (){var iter__5341__auto__ = ((function (i__30966,datum,c__5339__auto__,size__5340__auto__,b__30967,s__30965__$2,temp__4425__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__30964_$_iter__30982(s__30983){
return (new cljs.core.LazySeq(null,((function (i__30966,datum,c__5339__auto__,size__5340__auto__,b__30967,s__30965__$2,temp__4425__auto__,osmfields){
return (function (){
var s__30983__$1 = s__30983;
while(true){
var temp__4425__auto____$1 = cljs.core.seq(s__30983__$1);
if(temp__4425__auto____$1){
var s__30983__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__30983__$2)){
var c__5339__auto____$1 = cljs.core.chunk_first(s__30983__$2);
var size__5340__auto____$1 = cljs.core.count(c__5339__auto____$1);
var b__30985 = cljs.core.chunk_buffer(size__5340__auto____$1);
if((function (){var i__30984 = (0);
while(true){
if((i__30984 < size__5340__auto____$1)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto____$1,i__30984);
cljs.core.chunk_append(b__30985,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__30994 = (i__30984 + (1));
i__30984 = G__30994;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30985),hatti$ona$post_process$ona_osm_link_$_iter__30964_$_iter__30982(cljs.core.chunk_rest(s__30983__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30985),null);
}
} else {
var field = cljs.core.first(s__30983__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__30964_$_iter__30982(cljs.core.rest(s__30983__$2)));
}
} else {
return null;
}
break;
}
});})(i__30966,datum,c__5339__auto__,size__5340__auto__,b__30967,s__30965__$2,temp__4425__auto__,osmfields))
,null,null));
});})(i__30966,datum,c__5339__auto__,size__5340__auto__,b__30967,s__30965__$2,temp__4425__auto__,osmfields))
;
return iter__5341__auto__(osmfields);
})());

var G__30995 = (i__30966 + (1));
i__30966 = G__30995;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30967),hatti$ona$post_process$ona_osm_link_$_iter__30964(cljs.core.chunk_rest(s__30965__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30967),null);
}
} else {
var datum = cljs.core.first(s__30965__$2);
return cljs.core.cons((function (){var iter__5341__auto__ = ((function (datum,s__30965__$2,temp__4425__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__30964_$_iter__30988(s__30989){
return (new cljs.core.LazySeq(null,((function (datum,s__30965__$2,temp__4425__auto__,osmfields){
return (function (){
var s__30989__$1 = s__30989;
while(true){
var temp__4425__auto____$1 = cljs.core.seq(s__30989__$1);
if(temp__4425__auto____$1){
var s__30989__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__30989__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__30989__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__30991 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__30990 = (0);
while(true){
if((i__30990 < size__5340__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__30990);
cljs.core.chunk_append(b__30991,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__30996 = (i__30990 + (1));
i__30990 = G__30996;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30991),hatti$ona$post_process$ona_osm_link_$_iter__30964_$_iter__30988(cljs.core.chunk_rest(s__30989__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30991),null);
}
} else {
var field = cljs.core.first(s__30989__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__30964_$_iter__30988(cljs.core.rest(s__30989__$2)));
}
} else {
return null;
}
break;
}
});})(datum,s__30965__$2,temp__4425__auto__,osmfields))
,null,null));
});})(datum,s__30965__$2,temp__4425__auto__,osmfields))
;
return iter__5341__auto__(osmfields);
})(),hatti$ona$post_process$ona_osm_link_$_iter__30964(cljs.core.rest(s__30965__$2)));
}
} else {
return null;
}
break;
}
});})(osmfields))
,null,null));
});})(osmfields))
;
return iter__5341__auto__(data);
})()));
});
/**
 * Takes OSM XML in string form, and returns cljs geojson.
 */
hatti.ona.post_process.osm_xml__GT_geojson = (function hatti$ona$post_process$osm_xml__GT_geojson(osm_xml_string){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic((function (){var G__30998 = jQuery.parseXML(osm_xml_string);
return osmtogeojson(G__30998);
})(),cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Given some data in OSM format, an Ona Form, and osm xml string,
 * return a map from OSM ID to each osm feature. The map contains:
 * :osm-id, :name, :tags from osm xml,
 * :type, :geom from osm feature's geojson equivalent.
 */
hatti.ona.post_process.osm_id__GT_osm_data = (function hatti$ona$post_process$osm_id__GT_osm_data(data,form,osm_xml){
var ona_osm_link = hatti.ona.post_process.ona_osm_link(data,form);
var osmgeo = hatti.ona.post_process.osm_xml__GT_geojson(osm_xml);
var featureset = (osmgeo.cljs$core$IFn$_invoke$arity$1 ? osmgeo.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$features) : osmgeo.call(null,cljs.core.cst$kw$features));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5341__auto__ = ((function (ona_osm_link,osmgeo,featureset){
return (function hatti$ona$post_process$osm_id__GT_osm_data_$_iter__31021(s__31022){
return (new cljs.core.LazySeq(null,((function (ona_osm_link,osmgeo,featureset){
return (function (){
var s__31022__$1 = s__31022;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__31022__$1);
if(temp__4425__auto__){
var s__31022__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__31022__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__31022__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__31024 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__31023 = (0);
while(true){
if((i__31023 < size__5340__auto__)){
var map__31035 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__31023);
var map__31035__$1 = ((((!((map__31035 == null)))?((((map__31035.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31035.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31035):map__31035);
var feature = map__31035__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31035__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31035__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31035__$1,cljs.core.cst$kw$geometry);
cljs.core.chunk_append(b__31024,(function (){var map__31037 = properties;
var map__31037__$1 = ((((!((map__31037 == null)))?((((map__31037.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31037.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31037):map__31037);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31037__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31037__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31037__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})());

var G__31043 = (i__31023 + (1));
i__31023 = G__31043;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__31024),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__31021(cljs.core.chunk_rest(s__31022__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__31024),null);
}
} else {
var map__31039 = cljs.core.first(s__31022__$2);
var map__31039__$1 = ((((!((map__31039 == null)))?((((map__31039.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31039.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31039):map__31039);
var feature = map__31039__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31039__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31039__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31039__$1,cljs.core.cst$kw$geometry);
return cljs.core.cons((function (){var map__31041 = properties;
var map__31041__$1 = ((((!((map__31041 == null)))?((((map__31041.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31041.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31041):map__31041);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31041__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31041__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31041__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})(),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__31021(cljs.core.rest(s__31022__$2)));
}
} else {
return null;
}
break;
}
});})(ona_osm_link,osmgeo,featureset))
,null,null));
});})(ona_osm_link,osmgeo,featureset))
;
return iter__5341__auto__(featureset);
})());
});
/**
 * Given some data post-processed from the ona server
 * (ie, containing _id, _rank), and a string of osm-xml, produce a version with
 * relevant osm data injected in.
 */
hatti.ona.post_process.integrate_osm_data_BANG_ = (function hatti$ona$post_process$integrate_osm_data_BANG_(app_state,form,osm_xml,app_state_keys){
var osm_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
if(cljs.core.seq(osm_fields)){
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(app_state,app_state_keys);
var osm_data = hatti.ona.post_process.osm_id__GT_osm_data(data,form,osm_xml);
var osm_val__GT_osm_id = ((function (data,osm_data,osm_fields){
return (function (p1__31044_SHARP_){
return cljs.core.re_find(/[-]?[0-9]+/,p1__31044_SHARP_);
});})(data,osm_data,osm_fields))
;
var osm_val__GT_osm_data = ((function (data,osm_data,osm_val__GT_osm_id,osm_fields){
return (function (osm_val){
if(typeof osm_val === 'string'){
var temp__4423__auto__ = (function (){var G__31056 = osm_val__GT_osm_id(osm_val);
return (osm_data.cljs$core$IFn$_invoke$arity$1 ? osm_data.cljs$core$IFn$_invoke$arity$1(G__31056) : osm_data.call(null,G__31056));
})();
if(cljs.core.truth_(temp__4423__auto__)){
var osm_submission_data = temp__4423__auto__;
return osm_submission_data;
} else {
return osm_val;
}
} else {
return osm_val;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_fields))
;
var updater = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (osm_key){
return ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (data__$1){
var iter__5341__auto__ = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function hatti$ona$post_process$integrate_osm_data_BANG__$_iter__31057(s__31058){
return (new cljs.core.LazySeq(null,((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (){
var s__31058__$1 = s__31058;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__31058__$1);
if(temp__4425__auto__){
var s__31058__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__31058__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__31058__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__31060 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__31059 = (0);
while(true){
if((i__31059 < size__5340__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__31059);
cljs.core.chunk_append(b__31060,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data));

var G__31067 = (i__31059 + (1));
i__31059 = G__31067;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__31060),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__31057(cljs.core.chunk_rest(s__31058__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__31060),null);
}
} else {
var datum = cljs.core.first(s__31058__$2);
return cljs.core.cons(cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__31057(cljs.core.rest(s__31058__$2)));
}
} else {
return null;
}
break;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
,null,null));
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
return iter__5341__auto__(data__$1);
});
;})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
var seq__31063 = cljs.core.seq(osm_fields);
var chunk__31064 = null;
var count__31065 = (0);
var i__31066 = (0);
while(true){
if((i__31066 < count__31065)){
var osm_field = chunk__31064.cljs$core$IIndexed$_nth$arity$2(null,i__31066);
hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__31068 = seq__31063;
var G__31069 = chunk__31064;
var G__31070 = count__31065;
var G__31071 = (i__31066 + (1));
seq__31063 = G__31068;
chunk__31064 = G__31069;
count__31065 = G__31070;
i__31066 = G__31071;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__31063);
if(temp__4425__auto__){
var seq__31063__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__31063__$1)){
var c__5372__auto__ = cljs.core.chunk_first(seq__31063__$1);
var G__31072 = cljs.core.chunk_rest(seq__31063__$1);
var G__31073 = c__5372__auto__;
var G__31074 = cljs.core.count(c__5372__auto__);
var G__31075 = (0);
seq__31063 = G__31072;
chunk__31064 = G__31073;
count__31065 = G__31074;
i__31066 = G__31075;
continue;
} else {
var osm_field = cljs.core.first(seq__31063__$1);
hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__31076 = cljs.core.next(seq__31063__$1);
var G__31077 = null;
var G__31078 = (0);
var G__31079 = (0);
seq__31063 = G__31076;
chunk__31064 = G__31077;
count__31065 = G__31078;
i__31066 = G__31079;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
/**
 * Calculate full image and thumbnail urls given attachment information.
 */
hatti.ona.post_process.url_obj = (function hatti$ona$post_process$url_obj(media_obj){
var media_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"id");
var fname = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"filename");
var file_url = hatti.ona.urls.media_url(media_id,fname);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$filename,fname,cljs.core.cst$kw$download_url,file_url,cljs.core.cst$kw$small_download_url,[cljs.core.str(file_url),cljs.core.str("&suffix=small")].join('')], null);
});
/**
 * Helper function for integrate attachments; returns a function from
 * a filename to a `url-obj` (see specs in `url-obj` function).
 */
hatti.ona.post_process.get_attach_map = (function hatti$ona$post_process$get_attach_map(record,attachments){
var attachments__$1 = (function (){var or__4569__auto__ = attachments;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,"_attachments");
}
})();
var fnames = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (attachments__$1){
return (function (p1__31080_SHARP_){
return hatti.utils.last_url_param(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__31080_SHARP_,"filename"));
});})(attachments__$1))
,attachments__$1);
var fname__GT_urlobj = cljs.core.zipmap(fnames,cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.ona.post_process.url_obj,attachments__$1));
return ((function (attachments__$1,fnames,fname__GT_urlobj){
return (function (fname){
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(fname__GT_urlobj,fname,fname);
});
;})(attachments__$1,fnames,fname__GT_urlobj))
});
/**
 * Inlines media data from within _attachments into each record.
 */
hatti.ona.post_process.integrate_attachments = (function hatti$ona$post_process$integrate_attachments(var_args){
var args__5634__auto__ = [];
var len__5627__auto___31093 = arguments.length;
var i__5628__auto___31094 = (0);
while(true){
if((i__5628__auto___31094 < len__5627__auto___31093)){
args__5634__auto__.push((arguments[i__5628__auto___31094]));

var G__31095 = (i__5628__auto___31094 + (1));
i__5628__auto___31094 = G__31095;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,data,p__31084){
var map__31085 = p__31084;
var map__31085__$1 = ((((!((map__31085 == null)))?((((map__31085.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31085.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31085):map__31085);
var attachments = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31085__$1,cljs.core.cst$kw$attachments);
var image_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.image_QMARK_,flat_form);
var iter__5341__auto__ = ((function (image_fields,map__31085,map__31085__$1,attachments){
return (function hatti$ona$post_process$iter__31087(s__31088){
return (new cljs.core.LazySeq(null,((function (image_fields,map__31085,map__31085__$1,attachments){
return (function (){
var s__31088__$1 = s__31088;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__31088__$1);
if(temp__4425__auto__){
var s__31088__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__31088__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__31088__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__31090 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__31089 = (0);
while(true){
if((i__31089 < size__5340__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__31089);
cljs.core.chunk_append(b__31090,(function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (i__31089,attach_map,record,c__5339__auto__,size__5340__auto__,b__31090,s__31088__$2,temp__4425__auto__,image_fields,map__31085,map__31085__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(i__31089,attach_map,record,c__5339__auto__,size__5340__auto__,b__31090,s__31088__$2,temp__4425__auto__,image_fields,map__31085,map__31085__$1,attachments))
,record,image_fields);
})());

var G__31096 = (i__31089 + (1));
i__31089 = G__31096;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__31090),hatti$ona$post_process$iter__31087(cljs.core.chunk_rest(s__31088__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__31090),null);
}
} else {
var record = cljs.core.first(s__31088__$2);
return cljs.core.cons((function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (attach_map,record,s__31088__$2,temp__4425__auto__,image_fields,map__31085,map__31085__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(attach_map,record,s__31088__$2,temp__4425__auto__,image_fields,map__31085,map__31085__$1,attachments))
,record,image_fields);
})(),hatti$ona$post_process$iter__31087(cljs.core.rest(s__31088__$2)));
}
} else {
return null;
}
break;
}
});})(image_fields,map__31085,map__31085__$1,attachments))
,null,null));
});})(image_fields,map__31085,map__31085__$1,attachments))
;
return iter__5341__auto__(data);
});

hatti.ona.post_process.integrate_attachments.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments.cljs$lang$applyTo = (function (seq31081){
var G__31082 = cljs.core.first(seq31081);
var seq31081__$1 = cljs.core.next(seq31081);
var G__31083 = cljs.core.first(seq31081__$1);
var seq31081__$2 = cljs.core.next(seq31081__$1);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(G__31082,G__31083,seq31081__$2);
});
/**
 * Inlines data from within _attachments into each datapoint within repeats.
 */
hatti.ona.post_process.integrate_attachments_in_repeats = (function hatti$ona$post_process$integrate_attachments_in_repeats(flat_form,data){
var repeat_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.repeat_QMARK_,flat_form);
var integrate = ((function (repeat_fields){
return (function (record,rpt_field){
var key = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(rpt_field);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(record,key,hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(rpt_field),cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,key),cljs.core.array_seq([cljs.core.cst$kw$attachments,cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,"_attachments")], 0)));
});})(repeat_fields))
;
var iter__5341__auto__ = ((function (repeat_fields,integrate){
return (function hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__31103(s__31104){
return (new cljs.core.LazySeq(null,((function (repeat_fields,integrate){
return (function (){
var s__31104__$1 = s__31104;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__31104__$1);
if(temp__4425__auto__){
var s__31104__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__31104__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__31104__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__31106 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__31105 = (0);
while(true){
if((i__31105 < size__5340__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__31105);
cljs.core.chunk_append(b__31106,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields));

var G__31109 = (i__31105 + (1));
i__31105 = G__31109;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__31106),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__31103(cljs.core.chunk_rest(s__31104__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__31106),null);
}
} else {
var record = cljs.core.first(s__31104__$2);
return cljs.core.cons(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__31103(cljs.core.rest(s__31104__$2)));
}
} else {
return null;
}
break;
}
});})(repeat_fields,integrate))
,null,null));
});})(repeat_fields,integrate))
;
return iter__5341__auto__(data);
});
/**
 * Inlines data from within _atatchments into each record within app-state.
 */
hatti.ona.post_process.integrate_attachments_BANG_ = (function hatti$ona$post_process$integrate_attachments_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___31117 = arguments.length;
var i__5628__auto___31118 = (0);
while(true){
if((i__5628__auto___31118 < len__5627__auto___31117)){
args__5634__auto__.push((arguments[i__5628__auto___31118]));

var G__31119 = (i__5628__auto___31118 + (1));
i__5628__auto___31118 = G__31119;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,flat_form,p__31114){
var map__31115 = p__31114;
var map__31115__$1 = ((((!((map__31115 == null)))?((((map__31115.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31115.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31115):map__31115);
var app_data_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31115__$1,cljs.core.cst$kw$app_DASH_data_DASH_keys,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_data_keys,((function (map__31115,map__31115__$1,app_data_keys){
return (function (p1__31110_SHARP_){
return hatti.ona.post_process.integrate_attachments_in_repeats(flat_form,hatti.ona.post_process.integrate_attachments(flat_form,p1__31110_SHARP_));
});})(map__31115,map__31115__$1,app_data_keys))
);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$applyTo = (function (seq31111){
var G__31112 = cljs.core.first(seq31111);
var seq31111__$1 = cljs.core.next(seq31111);
var G__31113 = cljs.core.first(seq31111__$1);
var seq31111__$2 = cljs.core.next(seq31111__$1);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31112,G__31113,seq31111__$2);
});
