// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.forms');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('hatti.constants');
goog.require('hatti.utils');
hatti.ona.forms.no_answer = "No Answer";
hatti.ona.forms.submission_time_field = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$name,hatti.constants._submission_time,cljs.core.cst$kw$full_DASH_name,hatti.constants._submission_time,cljs.core.cst$kw$label,"Submission Time",cljs.core.cst$kw$type,"dateTime"], null);
hatti.ona.forms.submitted_by_field = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$name,hatti.constants._submitted_by,cljs.core.cst$kw$full_DASH_name,hatti.constants._submitted_by,cljs.core.cst$kw$label,"Submitted by",cljs.core.cst$kw$type,"text"], null);
hatti.ona.forms.last_edited = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$name,hatti.constants._last_edited,cljs.core.cst$kw$full_DASH_name,hatti.constants._last_edited,cljs.core.cst$kw$label,"Last Edited",cljs.core.cst$kw$type,"date"], null);
hatti.ona.forms.extra_submission_details = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [hatti.ona.forms.last_edited,hatti.ona.forms.submission_time_field,hatti.ona.forms.submitted_by_field], null);
/**
 * Helper function: is the :type of a field among a set of types
 */
hatti.ona.forms.field_type_in_set_QMARK_ = (function hatti$ona$forms$field_type_in_set_QMARK_(types,field){
return cljs.core.contains_QMARK_(types,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(field));
});
/**
 * Checks whether a field in a form (ie, a field) is a group field
 */
hatti.ona.forms.group_QMARK_ = (function hatti$ona$forms$group_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["group",null], null), null),field);
});
/**
 * Checks whether a field in a form (ie, a field) is a repeat field
 */
hatti.ona.forms.repeat_QMARK_ = (function hatti$ona$forms$repeat_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["repeat",null], null), null),field);
});
/**
 * Checks whether a field is a numeric field
 */
hatti.ona.forms.numeric_QMARK_ = (function hatti$ona$forms$numeric_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["integer",null,"decimal",null], null), null),field);
});
/**
 * Checks whether a field is a date or a time field
 */
hatti.ona.forms.time_based_QMARK_ = (function hatti$ona$forms$time_based_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, ["today",null,"dateTime",null,"start",null,"time",null,"date",null,"end",null], null), null),field);
});
/**
 * Checks whether a field is a category field (select one or multiple)
 */
hatti.ona.forms.categorical_QMARK_ = (function hatti$ona$forms$categorical_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["select all that apply",null,"select one",null], null), null),field);
});
/**
 * Checks whether a field is a select one field
 */
hatti.ona.forms.select_one_QMARK_ = (function hatti$ona$forms$select_one_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["select one",null], null), null),field);
});
/**
 * Checks whether a field is a select multiple (select all that apply) field
 */
hatti.ona.forms.select_all_QMARK_ = (function hatti$ona$forms$select_all_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["select all that apply",null], null), null),field);
});
/**
 * Checks whether a field is a text / string field.
 */
hatti.ona.forms.text_QMARK_ = (function hatti$ona$forms$text_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["string",null,"text",null], null), null),field);
});
/**
 * Checks whether a field in a form (a field) is a group field
 */
hatti.ona.forms.note_QMARK_ = (function hatti$ona$forms$note_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["note",null], null), null),field);
});
hatti.ona.forms.meta_QMARK_ = (function hatti$ona$forms$meta_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, ["subscriberid",null,"phonenumber",null,"instanceID",null,"today",null,"deviceid",null,"uuid",null,"start",null,"imei",null,"simserial",null,"end",null], null), null),field);
});
hatti.ona.forms.geofield_QMARK_ = (function hatti$ona$forms$geofield_QMARK_(field){
var or__4569__auto__ = hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, ["geoshape",null,"geotrace",null,"geopoint",null,"osm",null,"gps",null], null), null),field);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
var map__26952 = field;
var map__26952__$1 = ((((!((map__26952 == null)))?((((map__26952.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26952.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26952):map__26952);
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26952__$1,cljs.core.cst$kw$children);
return cljs.core.some(hatti$ona$forms$geofield_QMARK_,children);
} else {
return null;
}
}
});
hatti.ona.forms.geopoint_QMARK_ = (function hatti$ona$forms$geopoint_QMARK_(field){
var or__4569__auto__ = hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["geopoint",null,"gps",null], null), null),field);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
var map__26956 = field;
var map__26956__$1 = ((((!((map__26956 == null)))?((((map__26956.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26956.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26956):map__26956);
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26956__$1,cljs.core.cst$kw$children);
return cljs.core.some(hatti$ona$forms$geopoint_QMARK_,children);
} else {
return null;
}
}
});
hatti.ona.forms.geoshape_QMARK_ = (function hatti$ona$forms$geoshape_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["geoshape",null], null), null),field);
});
hatti.ona.forms.image_QMARK_ = (function hatti$ona$forms$image_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["image",null,"photo",null], null), null),field);
});
hatti.ona.forms.osm_QMARK_ = (function hatti$ona$forms$osm_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["osm",null], null), null),field);
});
/**
 * Checks whether a field is a calculate field
 */
hatti.ona.forms.calculate_QMARK_ = (function hatti$ona$forms$calculate_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["calculate",null], null), null),field);
});
/**
 * Returns false for fields such as note, group, etc. which don't have data
 */
hatti.ona.forms.has_data_QMARK_ = (function hatti$ona$forms$has_data_QMARK_(field){
return cljs.core.not((function (){var or__4569__auto__ = hatti.ona.forms.note_QMARK_(field);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return hatti.ona.forms.group_QMARK_(field);
}
})());
});
hatti.ona.forms.get_icon = (function hatti$ona$forms$get_icon(field){

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,(cljs.core.truth_(hatti.ona.forms.text_QMARK_(field))?"fa fa-font":(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))?"fa fa-clock-o":(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))?"fa fa-bar-chart":(cljs.core.truth_(hatti.ona.forms.calculate_QMARK_(field))?"fa fa-bar-chart":(cljs.core.truth_(hatti.ona.forms.categorical_QMARK_(field))?"fa fa-bar-chart fa-flip-h-rotate-90":""
)))))], null)], null);
});
/**
 * Assign class according to field type category, e.g. integer & decimals are
 * both in the numeric category
 */
hatti.ona.forms.get_column_class = (function hatti$ona$forms$get_column_class(field){
if(cljs.core.truth_(hatti.ona.forms.text_QMARK_(field))){
return "column-string";
} else {
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))){
return "column-numeric";
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))){
return "column-datetime";
} else {
if(cljs.core.truth_(hatti.ona.forms.categorical_QMARK_(field))){
return "column-categorical";
} else {
if(cljs.core.truth_(hatti.ona.forms.geofield_QMARK_(field))){
return "column-geofield";
} else {
if(cljs.core.truth_(hatti.ona.forms.image_QMARK_(field))){
return "column-image";
} else {
if(cljs.core.truth_(hatti.ona.forms.meta_QMARK_(field))){
return "column-metadata";
} else {
return "";

}
}
}
}
}
}
}
});
/**
 * Gets the label object out of a map with key :label (eg. a field).
 * If multiple languages, and none specified, picks out alphabetically first.
 */
hatti.ona.forms.get_label = (function hatti$ona$forms$get_label(var_args){
var args26958 = [];
var len__5627__auto___26969 = arguments.length;
var i__5628__auto___26970 = (0);
while(true){
if((i__5628__auto___26970 < len__5627__auto___26969)){
args26958.push((arguments[i__5628__auto___26970]));

var G__26971 = (i__5628__auto___26970 + (1));
i__5628__auto___26970 = G__26971;
continue;
} else {
}
break;
}

var G__26962 = args26958.length;
switch (G__26962) {
case 1:
return hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args26958.slice((1)),(0)));
return hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5646__auto__);

}
});

hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$1 = (function (labelled_obj){
return hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(labelled_obj,cljs.core.array_seq([null], 0));
});

hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic = (function (p__26963,p__26964){
var map__26965 = p__26963;
var map__26965__$1 = ((((!((map__26965 == null)))?((((map__26965.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26965.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26965):map__26965);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26965__$1,cljs.core.cst$kw$label);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26965__$1,cljs.core.cst$kw$name);
var vec__26966 = p__26964;
var language = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26966,(0),null);
if(!(cljs.core.map_QMARK_(label))){
var or__4569__auto__ = label;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return name;
}
} else {
if(cljs.core.contains_QMARK_(cljs.core.set(cljs.core.keys(label)),language)){
return (label.cljs$core$IFn$_invoke$arity$1 ? label.cljs$core$IFn$_invoke$arity$1(language) : label.call(null,language));
} else {
var G__26968 = cljs.core.first(cljs.core.sort.cljs$core$IFn$_invoke$arity$1(cljs.core.keys(label)));
return (label.cljs$core$IFn$_invoke$arity$1 ? label.cljs$core$IFn$_invoke$arity$1(G__26968) : label.call(null,G__26968));
}
}
});

hatti.ona.forms.get_label.cljs$lang$applyTo = (function (seq26959){
var G__26960 = cljs.core.first(seq26959);
var seq26959__$1 = cljs.core.next(seq26959);
return hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(G__26960,seq26959__$1);
});

hatti.ona.forms.get_label.cljs$lang$maxFixedArity = (1);
/**
 * String representation for a particular field datapoint (answer).
 * re-formatting depends on field type, eg. name->label substitution.
 * Optional: compact? should be true if a short string needs to be returned.
 */
hatti.ona.forms.format_answer = (function hatti$ona$forms$format_answer(var_args){
var args26976 = [];
var len__5627__auto___26984 = arguments.length;
var i__5628__auto___26985 = (0);
while(true){
if((i__5628__auto___26985 < len__5627__auto___26984)){
args26976.push((arguments[i__5628__auto___26985]));

var G__26986 = (i__5628__auto___26985 + (1));
i__5628__auto___26985 = G__26986;
continue;
} else {
}
break;
}

var G__26978 = args26976.length;
switch (G__26978) {
case 2:
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26976.length)].join('')));

}
});

hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$2 = (function (field,answer){
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$3(field,answer,null);
});

hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$3 = (function (field,answer,language){
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4(field,answer,language,false);
});

hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4 = (function (field,answer,language,compact_QMARK_){
var which = (cljs.core.truth_(hatti.ona.forms.image_QMARK_(field))?cljs.core.cst$kw$img:(cljs.core.truth_(hatti.ona.forms.osm_QMARK_(field))?cljs.core.cst$kw$osm:(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))?cljs.core.cst$kw$rpt:(cljs.core.truth_(hatti.ona.forms.select_one_QMARK_(field))?cljs.core.cst$kw$sel1:(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_(field))?cljs.core.cst$kw$selm:cljs.core.cst$kw$else
)))));
var G__26979 = (((which instanceof cljs.core.Keyword))?which.fqn:null);
switch (G__26979) {
case "sel1":
if(cljs.core.not(answer)){
return hatti.ona.forms.no_answer;
} else {
var option = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__26979,which){
return (function (p1__26973_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(answer,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(p1__26973_SHARP_));
});})(G__26979,which))
,cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(field)));
var formatted = hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(option,cljs.core.array_seq([language], 0));
var or__4569__auto__ = formatted;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return answer;
}
}

break;
case "selm":
if(cljs.core.truth_(clojure.string.blank_QMARK_(answer))){
return hatti.ona.forms.no_answer;
} else {
var names = cljs.core.set(clojure.string.split.cljs$core$IFn$_invoke$arity$2(answer,/ /));
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (names,G__26979,which){
return (function (p1__26975_SHARP_){
return [cljs.core.str("\u2611 "),cljs.core.str(hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(p1__26975_SHARP_,cljs.core.array_seq([language], 0))),cljs.core.str(" ")].join('');
});})(names,G__26979,which))
,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (names,G__26979,which){
return (function (p1__26974_SHARP_){
return cljs.core.contains_QMARK_(names,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(p1__26974_SHARP_));
});})(names,G__26979,which))
,cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(field))));
}

break;
case "img":
var image = cljs.core.cst$kw$download_url.cljs$core$IFn$_invoke$arity$1(answer);
var thumb = (function (){var or__4569__auto__ = cljs.core.cst$kw$small_download_url.cljs$core$IFn$_invoke$arity$1(answer);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return image;
}
})();
var fname = hatti.utils.last_url_param(cljs.core.cst$kw$filename.cljs$core$IFn$_invoke$arity$1(answer));
if(((answer == null)) || (typeof answer === 'string')){
return answer;
} else {
if(cljs.core.truth_(compact_QMARK_)){
return hatti.utils.format.cljs$core$IFn$_invoke$arity$variadic("<a href='%s' target='_blank'>\n                                      <i class='fa fa-external-link'></i>\n                                      %s </a>",cljs.core.array_seq([image,fname], 0));
} else {
if((thumb == null)){
return answer;
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$href,image,cljs.core.cst$kw$target,"_blank"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$width,"80px",cljs.core.cst$kw$src,thumb], null)], null)], null);

}
}
}

break;
case "osm":
if(cljs.core.truth_(answer)){
var kw__GT_name = cljs.core.name;
var map__26980 = answer;
var map__26980__$1 = ((((!((map__26980 == null)))?((((map__26980.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26980.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26980):map__26980);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26980__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26980__$1,cljs.core.cst$kw$type);
var osm_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26980__$1,cljs.core.cst$kw$osm_DASH_id);
var type_cap = (cljs.core.truth_(type)?clojure.string.capitalize(type):null);
var title = [cljs.core.str("OSM "),cljs.core.str(type_cap),cljs.core.str(": "),cljs.core.str(name),cljs.core.str(" ("),cljs.core.str(osm_id),cljs.core.str(")")].join('');
if(cljs.core.truth_(compact_QMARK_)){
return title;
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table$osm_DASH_data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$thead,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$col_DASH_span,(2)], null),title], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (kw__GT_name,map__26980,map__26980__$1,name,type,osm_id,type_cap,title,G__26979,which){
return (function (p__26982){
var vec__26983 = p__26982;
var tk = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26983,(0),null);
var tv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26983,(1),null);
if(cljs.core.truth_(clojure.string.blank_QMARK_(tv))){
return null;
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$question,(kw__GT_name.cljs$core$IFn$_invoke$arity$1 ? kw__GT_name.cljs$core$IFn$_invoke$arity$1(tk) : kw__GT_name.call(null,tk))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$answer,tv], null)], null);
}
});})(kw__GT_name,map__26980,map__26980__$1,name,type,osm_id,type_cap,title,G__26979,which))
,cljs.core.cst$kw$tags.cljs$core$IFn$_invoke$arity$1(answer))], null)], null);
}
} else {
return null;
}

break;
case "rpt":
if(cljs.core.empty_QMARK_(answer)){
return "";
} else {
return [cljs.core.str("Repeated data with "),cljs.core.str(cljs.core.count(answer)),cljs.core.str(" answers.")].join('');
}

break;
case "else":
return answer;

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(which)].join('')));

}
});

hatti.ona.forms.format_answer.cljs$lang$maxFixedArity = 4;
/**
 * Try and produce a label for meta field if non-existent.
 */
hatti.ona.forms.relabel_meta_field = (function hatti$ona$forms$relabel_meta_field(field){
var label = (function (){var temp__4423__auto__ = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(field);
if(cljs.core.truth_(temp__4423__auto__)){
var type = temp__4423__auto__;
var G__26991 = type;
switch (G__26991) {
case "start":
return "Start time";

break;
case "end":
return "End time";

break;
case "today":
return "Day of survey";

break;
case "deviceid":
return "Device ID (IMEI)";

break;
case "imei":
return "IMEI";

break;
case "subscriberid":
return "IMSI";

break;
case "simserial":
return "SIM serial number";

break;
case "uuid":
return "UUID";

break;
case "instanceID":
return "Instance ID";

break;
case "phonenumber":
return "Phone number";

break;
default:
return cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(field);

}
} else {
var G__26992 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(field);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$_submission_time,G__26992)){
return "Submission time";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$_submitted_by,G__26992)){
return "Submitted by";
} else {
return "";

}
}
}
})();
if(cljs.core.truth_(cljs.core.cst$kw$label.cljs$core$IFn$_invoke$arity$1(field))){
return field;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(field,cljs.core.cst$kw$label,label);
}
});
/**
 * Input: map derived from form.json. Output: a flattened vector;
 * each element is a field; a field is a {:name .. :label .. :type ..} map.
 * By default, REPEAT BLOCKS ARE NOT FLATTENED, repeat blocks represent
 * subforms, which need special handling in most cases.
 * :flatten-repeats? overrides default behavior, also flattens repeats.
 */
hatti.ona.forms.flatten_form = (function hatti$ona$forms$flatten_form(var_args){
var args__5634__auto__ = [];
var len__5627__auto___27016 = arguments.length;
var i__5628__auto___27017 = (0);
while(true){
if((i__5628__auto___27017 < len__5627__auto___27016)){
args__5634__auto__.push((arguments[i__5628__auto___27017]));

var G__27018 = (i__5628__auto___27017 + (1));
i__5628__auto___27017 = G__27018;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.ona.forms.flatten_form.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.ona.forms.flatten_form.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__26999){
var map__27000 = p__26999;
var map__27000__$1 = ((((!((map__27000 == null)))?((((map__27000.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27000.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27000):map__27000);
var flatten_repeats_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27000__$1,cljs.core.cst$kw$flatten_DASH_repeats_QMARK_);
var name_label_map = ((function (map__27000,map__27000__$1,flatten_repeats_QMARK_){
return (function hatti$ona$forms$name_label_map(nd,prefix,acc){
var map__27014 = nd;
var map__27014__$1 = ((((!((map__27014 == null)))?((((map__27014.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27014.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27014):map__27014);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27014__$1,cljs.core.cst$kw$type);
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27014__$1,cljs.core.cst$kw$children);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27014__$1,cljs.core.cst$kw$name);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27014__$1,cljs.core.cst$kw$label);
var full_name = (cljs.core.truth_(prefix)?[cljs.core.str(prefix),cljs.core.str("/"),cljs.core.str(name)].join(''):name);
var langs = ((cljs.core.map_QMARK_(label))?cljs.core.keys(label):null);
var nd__$1 = cljs.core.with_meta(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(nd,cljs.core.cst$kw$full_DASH_name,full_name),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$langs,langs], null));
var mini_nd = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(nd__$1,cljs.core.cst$kw$children);
var new_children = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__27014,map__27014__$1,type,children,name,label,full_name,langs,nd__$1,mini_nd,map__27000,map__27000__$1,flatten_repeats_QMARK_){
return (function (p1__26994_SHARP_){
return hatti$ona$forms$name_label_map(p1__26994_SHARP_,full_name,cljs.core.PersistentVector.EMPTY);
});})(map__27014,map__27014__$1,type,children,name,label,full_name,langs,nd__$1,mini_nd,map__27000,map__27000__$1,flatten_repeats_QMARK_))
,children);
if(cljs.core.truth_(hatti.ona.forms.group_QMARK_(nd__$1))){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,mini_nd),new_children);
} else {
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(nd__$1))){
if(cljs.core.truth_(flatten_repeats_QMARK_)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,mini_nd),new_children);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(nd__$1,cljs.core.cst$kw$children,cljs.core.flatten(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,new_children))));
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,nd__$1);

}
}
});})(map__27000,map__27000__$1,flatten_repeats_QMARK_))
;
var nodes = cljs.core.flatten(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__27000,map__27000__$1,flatten_repeats_QMARK_){
return (function (p1__26995_SHARP_){
return name_label_map(p1__26995_SHARP_,null,cljs.core.PersistentVector.EMPTY);
});})(map__27000,map__27000__$1,flatten_repeats_QMARK_))
,cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(form)));
var langs = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.flatten(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (nodes,map__27000,map__27000__$1,flatten_repeats_QMARK_){
return (function (p1__26996_SHARP_){
return cljs.core.cst$kw$langs.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__26996_SHARP_));
});})(nodes,map__27000,map__27000__$1,flatten_repeats_QMARK_))
,nodes)));
return cljs.core.with_meta(nodes,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$languages,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,langs)], null));
});

hatti.ona.forms.flatten_form.cljs$lang$maxFixedArity = (1);

hatti.ona.forms.flatten_form.cljs$lang$applyTo = (function (seq26997){
var G__26998 = cljs.core.first(seq26997);
var seq26997__$1 = cljs.core.next(seq26997);
return hatti.ona.forms.flatten_form.cljs$core$IFn$_invoke$arity$variadic(G__26998,seq26997__$1);
});
/**
 * Get just the meta fields out of the form.
 * Options to re-label meta fields, or include submission time in meta list.
 */
hatti.ona.forms.meta_fields = (function hatti$ona$forms$meta_fields(var_args){
var args__5634__auto__ = [];
var len__5627__auto___27026 = arguments.length;
var i__5628__auto___27027 = (0);
while(true){
if((i__5628__auto___27027 < len__5627__auto___27026)){
args__5634__auto__.push((arguments[i__5628__auto___27027]));

var G__27028 = (i__5628__auto___27027 + (1));
i__5628__auto___27027 = G__27028;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,p__27022){
var map__27023 = p__27022;
var map__27023__$1 = ((((!((map__27023 == null)))?((((map__27023.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27023.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27023):map__27023);
var relabel_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__27023__$1,cljs.core.cst$kw$relabel_QMARK_,true);
var with_submission_details_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27023__$1,cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_);
var meta_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.meta_QMARK_,flat_form);
var include_extra_sub_details = (cljs.core.truth_(with_submission_details_QMARK_)?((function (meta_fields,map__27023,map__27023__$1,relabel_QMARK_,with_submission_details_QMARK_){
return (function (p1__27019_SHARP_){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__27019_SHARP_),hatti.ona.forms.extra_submission_details);
});})(meta_fields,map__27023,map__27023__$1,relabel_QMARK_,with_submission_details_QMARK_))
:cljs.core.identity);
var relabel = (cljs.core.truth_(relabel_QMARK_)?hatti.ona.forms.relabel_meta_field:cljs.core.identity);
var G__27025 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(relabel,meta_fields);
return (include_extra_sub_details.cljs$core$IFn$_invoke$arity$1 ? include_extra_sub_details.cljs$core$IFn$_invoke$arity$1(G__27025) : include_extra_sub_details.call(null,G__27025));
});

hatti.ona.forms.meta_fields.cljs$lang$maxFixedArity = (1);

hatti.ona.forms.meta_fields.cljs$lang$applyTo = (function (seq27020){
var G__27021 = cljs.core.first(seq27020);
var seq27020__$1 = cljs.core.next(seq27020);
return hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(G__27021,seq27020__$1);
});
/**
 * Get just the fields in this form that are not meta fields.
 */
hatti.ona.forms.non_meta_fields = (function hatti$ona$forms$non_meta_fields(flat_form){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.meta_QMARK_,flat_form);
});
hatti.ona.forms.geofields = (function hatti$ona$forms$geofields(flat_form){

return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geofield_QMARK_,flat_form);
});
hatti.ona.forms.default_geofield = (function hatti$ona$forms$default_geofield(flat_form){

var repeats = cljs.core.flatten(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.repeat_QMARK_,flat_form));
var geofields = hatti.ona.forms.geofields(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(flat_form,repeats));
var geoshapes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geoshape_QMARK_,geofields);
var geopoints = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geopoint_QMARK_,geofields);
if(cljs.core.seq(geoshapes)){
return cljs.core.first(geoshapes);
} else {
if(cljs.core.seq(geopoints)){
return cljs.core.first(geopoints);
} else {
return cljs.core.first(geofields);

}
}
});
hatti.ona.forms.english_QMARK_ = (function hatti$ona$forms$english_QMARK_(language){
return cljs.core.re_find(/english/i,[cljs.core.str(language)].join(''));
});
hatti.ona.forms.get_languages = (function hatti$ona$forms$get_languages(form){

return cljs.core.cst$kw$languages.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(form));
});
hatti.ona.forms.multilingual_QMARK_ = (function hatti$ona$forms$multilingual_QMARK_(form){

return cljs.core.seq(hatti.ona.forms.get_languages(form));
});
hatti.ona.forms.default_lang = (function hatti$ona$forms$default_lang(languages){

var temp__4423__auto__ = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.english_QMARK_,languages));
if(cljs.core.truth_(temp__4423__auto__)){
var eng = temp__4423__auto__;
return eng;
} else {
return cljs.core.first(cljs.core.sort.cljs$core$IFn$_invoke$arity$1(languages));
}
});
