// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t_cljs$core$async36267 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async36267 = (function (fn_handler,f,meta36268){
this.fn_handler = fn_handler;
this.f = f;
this.meta36268 = meta36268;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async36267.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_36269,meta36268__$1){
var self__ = this;
var _36269__$1 = this;
return (new cljs.core.async.t_cljs$core$async36267(self__.fn_handler,self__.f,meta36268__$1));
});

cljs.core.async.t_cljs$core$async36267.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_36269){
var self__ = this;
var _36269__$1 = this;
return self__.meta36268;
});

cljs.core.async.t_cljs$core$async36267.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async36267.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async36267.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async36267.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$fn_DASH_handler,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null)))], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$meta36268], null);
});

cljs.core.async.t_cljs$core$async36267.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async36267.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async36267";

cljs.core.async.t_cljs$core$async36267.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async36267");
});

cljs.core.async.__GT_t_cljs$core$async36267 = (function cljs$core$async$fn_handler_$___GT_t_cljs$core$async36267(fn_handler__$1,f__$1,meta36268){
return (new cljs.core.async.t_cljs$core$async36267(fn_handler__$1,f__$1,meta36268));
});

}

return (new cljs.core.async.t_cljs$core$async36267(cljs$core$async$fn_handler,f,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args36272 = [];
var len__5627__auto___36275 = arguments.length;
var i__5628__auto___36276 = (0);
while(true){
if((i__5628__auto___36276 < len__5627__auto___36275)){
args36272.push((arguments[i__5628__auto___36276]));

var G__36277 = (i__5628__auto___36276 + (1));
i__5628__auto___36276 = G__36277;
continue;
} else {
}
break;
}

var G__36274 = args36272.length;
switch (G__36274) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36272.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$sym$buf_DASH_or_DASH_n], 0)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args36279 = [];
var len__5627__auto___36282 = arguments.length;
var i__5628__auto___36283 = (0);
while(true){
if((i__5628__auto___36283 < len__5627__auto___36282)){
args36279.push((arguments[i__5628__auto___36283]));

var G__36284 = (i__5628__auto___36283 + (1));
i__5628__auto___36283 = G__36284;
continue;
} else {
}
break;
}

var G__36281 = args36279.length;
switch (G__36281) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36279.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(ret)){
var val_36286 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_36286) : fn1.call(null,val_36286));
} else {
cljs.core.async.impl.dispatch.run(((function (val_36286,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_36286) : fn1.call(null,val_36286));
});})(val_36286,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args36287 = [];
var len__5627__auto___36290 = arguments.length;
var i__5628__auto___36291 = (0);
while(true){
if((i__5628__auto___36291 < len__5627__auto___36290)){
args36287.push((arguments[i__5628__auto___36291]));

var G__36292 = (i__5628__auto___36291 + (1));
i__5628__auto___36291 = G__36292;
continue;
} else {
}
break;
}

var G__36289 = args36287.length;
switch (G__36289) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36287.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4423__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5472__auto___36294 = n;
var x_36295 = (0);
while(true){
if((x_36295 < n__5472__auto___36294)){
(a[x_36295] = (0));

var G__36296 = (x_36295 + (1));
x_36295 = G__36296;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__36297 = (i + (1));
i = G__36297;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async36301 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async36301 = (function (alt_flag,flag,meta36302){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta36302 = meta36302;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async36301.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_36303,meta36302__$1){
var self__ = this;
var _36303__$1 = this;
return (new cljs.core.async.t_cljs$core$async36301(self__.alt_flag,self__.flag,meta36302__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async36301.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_36303){
var self__ = this;
var _36303__$1 = this;
return self__.meta36302;
});})(flag))
;

cljs.core.async.t_cljs$core$async36301.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async36301.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async36301.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async36301.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_flag,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$meta36302], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async36301.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async36301.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async36301";

cljs.core.async.t_cljs$core$async36301.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async36301");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async36301 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async36301(alt_flag__$1,flag__$1,meta36302){
return (new cljs.core.async.t_cljs$core$async36301(alt_flag__$1,flag__$1,meta36302));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async36301(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async36307 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async36307 = (function (alt_handler,flag,cb,meta36308){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta36308 = meta36308;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async36307.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_36309,meta36308__$1){
var self__ = this;
var _36309__$1 = this;
return (new cljs.core.async.t_cljs$core$async36307(self__.alt_handler,self__.flag,self__.cb,meta36308__$1));
});

cljs.core.async.t_cljs$core$async36307.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_36309){
var self__ = this;
var _36309__$1 = this;
return self__.meta36308;
});

cljs.core.async.t_cljs$core$async36307.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async36307.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async36307.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async36307.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_handler,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb], null)))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta36308], null);
});

cljs.core.async.t_cljs$core$async36307.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async36307.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async36307";

cljs.core.async.t_cljs$core$async36307.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async36307");
});

cljs.core.async.__GT_t_cljs$core$async36307 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async36307(alt_handler__$1,flag__$1,cb__$1,meta36308){
return (new cljs.core.async.t_cljs$core$async36307(alt_handler__$1,flag__$1,cb__$1,meta36308));
});

}

return (new cljs.core.async.t_cljs$core$async36307(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__36310_SHARP_){
var G__36314 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__36310_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__36314) : fret.call(null,G__36314));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__36311_SHARP_){
var G__36315 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__36311_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__36315) : fret.call(null,G__36315));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__4569__auto__ = wport;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return port;
}
})()], null));
} else {
var G__36316 = (i + (1));
i = G__36316;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4569__auto__ = ret;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__4425__auto__ = (function (){var and__4557__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___36322 = arguments.length;
var i__5628__auto___36323 = (0);
while(true){
if((i__5628__auto___36323 < len__5627__auto___36322)){
args__5634__auto__.push((arguments[i__5628__auto___36323]));

var G__36324 = (i__5628__auto___36323 + (1));
i__5628__auto___36323 = G__36324;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__36319){
var map__36320 = p__36319;
var map__36320__$1 = ((((!((map__36320 == null)))?((((map__36320.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36320.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36320):map__36320);
var opts = map__36320__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq36317){
var G__36318 = cljs.core.first(seq36317);
var seq36317__$1 = cljs.core.next(seq36317);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__36318,seq36317__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args36325 = [];
var len__5627__auto___36375 = arguments.length;
var i__5628__auto___36376 = (0);
while(true){
if((i__5628__auto___36376 < len__5627__auto___36375)){
args36325.push((arguments[i__5628__auto___36376]));

var G__36377 = (i__5628__auto___36376 + (1));
i__5628__auto___36376 = G__36377;
continue;
} else {
}
break;
}

var G__36327 = args36325.length;
switch (G__36327) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36325.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__9230__auto___36379 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__9230__auto___36379){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___36379){
return (function (state_36351){
var state_val_36352 = (state_36351[(1)]);
if((state_val_36352 === (7))){
var inst_36347 = (state_36351[(2)]);
var state_36351__$1 = state_36351;
var statearr_36353_36380 = state_36351__$1;
(statearr_36353_36380[(2)] = inst_36347);

(statearr_36353_36380[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36352 === (1))){
var state_36351__$1 = state_36351;
var statearr_36354_36381 = state_36351__$1;
(statearr_36354_36381[(2)] = null);

(statearr_36354_36381[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36352 === (4))){
var inst_36330 = (state_36351[(7)]);
var inst_36330__$1 = (state_36351[(2)]);
var inst_36331 = (inst_36330__$1 == null);
var state_36351__$1 = (function (){var statearr_36355 = state_36351;
(statearr_36355[(7)] = inst_36330__$1);

return statearr_36355;
})();
if(cljs.core.truth_(inst_36331)){
var statearr_36356_36382 = state_36351__$1;
(statearr_36356_36382[(1)] = (5));

} else {
var statearr_36357_36383 = state_36351__$1;
(statearr_36357_36383[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36352 === (13))){
var state_36351__$1 = state_36351;
var statearr_36358_36384 = state_36351__$1;
(statearr_36358_36384[(2)] = null);

(statearr_36358_36384[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36352 === (6))){
var inst_36330 = (state_36351[(7)]);
var state_36351__$1 = state_36351;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36351__$1,(11),to,inst_36330);
} else {
if((state_val_36352 === (3))){
var inst_36349 = (state_36351[(2)]);
var state_36351__$1 = state_36351;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36351__$1,inst_36349);
} else {
if((state_val_36352 === (12))){
var state_36351__$1 = state_36351;
var statearr_36359_36385 = state_36351__$1;
(statearr_36359_36385[(2)] = null);

(statearr_36359_36385[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36352 === (2))){
var state_36351__$1 = state_36351;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36351__$1,(4),from);
} else {
if((state_val_36352 === (11))){
var inst_36340 = (state_36351[(2)]);
var state_36351__$1 = state_36351;
if(cljs.core.truth_(inst_36340)){
var statearr_36360_36386 = state_36351__$1;
(statearr_36360_36386[(1)] = (12));

} else {
var statearr_36361_36387 = state_36351__$1;
(statearr_36361_36387[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36352 === (9))){
var state_36351__$1 = state_36351;
var statearr_36362_36388 = state_36351__$1;
(statearr_36362_36388[(2)] = null);

(statearr_36362_36388[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36352 === (5))){
var state_36351__$1 = state_36351;
if(cljs.core.truth_(close_QMARK_)){
var statearr_36363_36389 = state_36351__$1;
(statearr_36363_36389[(1)] = (8));

} else {
var statearr_36364_36390 = state_36351__$1;
(statearr_36364_36390[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36352 === (14))){
var inst_36345 = (state_36351[(2)]);
var state_36351__$1 = state_36351;
var statearr_36365_36391 = state_36351__$1;
(statearr_36365_36391[(2)] = inst_36345);

(statearr_36365_36391[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36352 === (10))){
var inst_36337 = (state_36351[(2)]);
var state_36351__$1 = state_36351;
var statearr_36366_36392 = state_36351__$1;
(statearr_36366_36392[(2)] = inst_36337);

(statearr_36366_36392[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36352 === (8))){
var inst_36334 = cljs.core.async.close_BANG_(to);
var state_36351__$1 = state_36351;
var statearr_36367_36393 = state_36351__$1;
(statearr_36367_36393[(2)] = inst_36334);

(statearr_36367_36393[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___36379))
;
return ((function (switch__9165__auto__,c__9230__auto___36379){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_36371 = [null,null,null,null,null,null,null,null];
(statearr_36371[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_36371[(1)] = (1));

return statearr_36371;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_36351){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__(state_36351);
if(cljs.core.keyword_identical_QMARK_(result__9168__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e36372){if((e36372 instanceof Object)){
var ex__9169__auto__ = e36372;
var statearr_36373_36394 = state_36351;
(statearr_36373_36394[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36351);

return cljs.core.cst$kw$recur;
} else {
throw e36372;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__9167__auto__,cljs.core.cst$kw$recur)){
var G__36395 = state_36351;
state_36351 = G__36395;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_36351){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_36351);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___36379))
})();
var state__9232__auto__ = (function (){var statearr_36374 = (f__9231__auto__.cljs$core$IFn$_invoke$arity$0 ? f__9231__auto__.cljs$core$IFn$_invoke$arity$0() : f__9231__auto__.call(null));
(statearr_36374[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___36379);

return statearr_36374;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__9232__auto__);
});})(c__9230__auto___36379))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(cljs.core.cst$sym$pos_QMARK_,cljs.core.cst$sym$n)], 0)))].join('')));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__36579){
var vec__36580 = p__36579;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36580,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36580,(1),null);
var job = vec__36580;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__9230__auto___36762 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__9230__auto___36762,res,vec__36580,v,p,job,jobs,results){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___36762,res,vec__36580,v,p,job,jobs,results){
return (function (state_36585){
var state_val_36586 = (state_36585[(1)]);
if((state_val_36586 === (1))){
var state_36585__$1 = state_36585;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36585__$1,(2),res,v);
} else {
if((state_val_36586 === (2))){
var inst_36582 = (state_36585[(2)]);
var inst_36583 = cljs.core.async.close_BANG_(res);
var state_36585__$1 = (function (){var statearr_36587 = state_36585;
(statearr_36587[(7)] = inst_36582);

return statearr_36587;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_36585__$1,inst_36583);
} else {
return null;
}
}
});})(c__9230__auto___36762,res,vec__36580,v,p,job,jobs,results))
;
return ((function (switch__9165__auto__,c__9230__auto___36762,res,vec__36580,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0 = (function (){
var statearr_36591 = [null,null,null,null,null,null,null,null];
(statearr_36591[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__);

(statearr_36591[(1)] = (1));

return statearr_36591;
});
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1 = (function (state_36585){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__(state_36585);
if(cljs.core.keyword_identical_QMARK_(result__9168__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e36592){if((e36592 instanceof Object)){
var ex__9169__auto__ = e36592;
var statearr_36593_36763 = state_36585;
(statearr_36593_36763[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36585);

return cljs.core.cst$kw$recur;
} else {
throw e36592;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__9167__auto__,cljs.core.cst$kw$recur)){
var G__36764 = state_36585;
state_36585 = G__36764;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = function(state_36585){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1.call(this,state_36585);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___36762,res,vec__36580,v,p,job,jobs,results))
})();
var state__9232__auto__ = (function (){var statearr_36594 = (f__9231__auto__.cljs$core$IFn$_invoke$arity$0 ? f__9231__auto__.cljs$core$IFn$_invoke$arity$0() : f__9231__auto__.call(null));
(statearr_36594[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___36762);

return statearr_36594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__9232__auto__);
});})(c__9230__auto___36762,res,vec__36580,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__36595){
var vec__36596 = p__36595;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36596,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36596,(1),null);
var job = vec__36596;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__5472__auto___36765 = n;
var __36766 = (0);
while(true){
if((__36766 < n__5472__auto___36765)){
var G__36597_36767 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__36597_36767) {
case "compute":
var c__9230__auto___36769 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__36766,c__9230__auto___36769,G__36597_36767,n__5472__auto___36765,jobs,results,process,async){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (__36766,c__9230__auto___36769,G__36597_36767,n__5472__auto___36765,jobs,results,process,async){
return (function (state_36610){
var state_val_36611 = (state_36610[(1)]);
if((state_val_36611 === (1))){
var state_36610__$1 = state_36610;
var statearr_36612_36770 = state_36610__$1;
(statearr_36612_36770[(2)] = null);

(statearr_36612_36770[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36611 === (2))){
var state_36610__$1 = state_36610;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36610__$1,(4),jobs);
} else {
if((state_val_36611 === (3))){
var inst_36608 = (state_36610[(2)]);
var state_36610__$1 = state_36610;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36610__$1,inst_36608);
} else {
if((state_val_36611 === (4))){
var inst_36600 = (state_36610[(2)]);
var inst_36601 = process(inst_36600);
var state_36610__$1 = state_36610;
if(cljs.core.truth_(inst_36601)){
var statearr_36613_36771 = state_36610__$1;
(statearr_36613_36771[(1)] = (5));

} else {
var statearr_36614_36772 = state_36610__$1;
(statearr_36614_36772[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36611 === (5))){
var state_36610__$1 = state_36610;
var statearr_36615_36773 = state_36610__$1;
(statearr_36615_36773[(2)] = null);

(statearr_36615_36773[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36611 === (6))){
var state_36610__$1 = state_36610;
var statearr_36616_36774 = state_36610__$1;
(statearr_36616_36774[(2)] = null);

(statearr_36616_36774[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36611 === (7))){
var inst_36606 = (state_36610[(2)]);
var state_36610__$1 = state_36610;
var statearr_36617_36775 = state_36610__$1;
(statearr_36617_36775[(2)] = inst_36606);

(statearr_36617_36775[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__36766,c__9230__auto___36769,G__36597_36767,n__5472__auto___36765,jobs,results,process,async))
;
return ((function (__36766,switch__9165__auto__,c__9230__auto___36769,G__36597_36767,n__5472__auto___36765,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0 = (function (){
var statearr_36621 = [null,null,null,null,null,null,null];
(statearr_36621[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__);

(statearr_36621[(1)] = (1));

return statearr_36621;
});
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1 = (function (state_36610){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__(state_36610);
if(cljs.core.keyword_identical_QMARK_(result__9168__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e36622){if((e36622 instanceof Object)){
var ex__9169__auto__ = e36622;
var statearr_36623_36776 = state_36610;
(statearr_36623_36776[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36610);

return cljs.core.cst$kw$recur;
} else {
throw e36622;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__9167__auto__,cljs.core.cst$kw$recur)){
var G__36777 = state_36610;
state_36610 = G__36777;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = function(state_36610){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1.call(this,state_36610);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__;
})()
;})(__36766,switch__9165__auto__,c__9230__auto___36769,G__36597_36767,n__5472__auto___36765,jobs,results,process,async))
})();
var state__9232__auto__ = (function (){var statearr_36624 = (f__9231__auto__.cljs$core$IFn$_invoke$arity$0 ? f__9231__auto__.cljs$core$IFn$_invoke$arity$0() : f__9231__auto__.call(null));
(statearr_36624[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___36769);

return statearr_36624;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__9232__auto__);
});})(__36766,c__9230__auto___36769,G__36597_36767,n__5472__auto___36765,jobs,results,process,async))
);


break;
case "async":
var c__9230__auto___36778 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__36766,c__9230__auto___36778,G__36597_36767,n__5472__auto___36765,jobs,results,process,async){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (__36766,c__9230__auto___36778,G__36597_36767,n__5472__auto___36765,jobs,results,process,async){
return (function (state_36637){
var state_val_36638 = (state_36637[(1)]);
if((state_val_36638 === (1))){
var state_36637__$1 = state_36637;
var statearr_36639_36779 = state_36637__$1;
(statearr_36639_36779[(2)] = null);

(statearr_36639_36779[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36638 === (2))){
var state_36637__$1 = state_36637;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36637__$1,(4),jobs);
} else {
if((state_val_36638 === (3))){
var inst_36635 = (state_36637[(2)]);
var state_36637__$1 = state_36637;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36637__$1,inst_36635);
} else {
if((state_val_36638 === (4))){
var inst_36627 = (state_36637[(2)]);
var inst_36628 = async(inst_36627);
var state_36637__$1 = state_36637;
if(cljs.core.truth_(inst_36628)){
var statearr_36640_36780 = state_36637__$1;
(statearr_36640_36780[(1)] = (5));

} else {
var statearr_36641_36781 = state_36637__$1;
(statearr_36641_36781[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36638 === (5))){
var state_36637__$1 = state_36637;
var statearr_36642_36782 = state_36637__$1;
(statearr_36642_36782[(2)] = null);

(statearr_36642_36782[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36638 === (6))){
var state_36637__$1 = state_36637;
var statearr_36643_36783 = state_36637__$1;
(statearr_36643_36783[(2)] = null);

(statearr_36643_36783[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36638 === (7))){
var inst_36633 = (state_36637[(2)]);
var state_36637__$1 = state_36637;
var statearr_36644_36784 = state_36637__$1;
(statearr_36644_36784[(2)] = inst_36633);

(statearr_36644_36784[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__36766,c__9230__auto___36778,G__36597_36767,n__5472__auto___36765,jobs,results,process,async))
;
return ((function (__36766,switch__9165__auto__,c__9230__auto___36778,G__36597_36767,n__5472__auto___36765,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0 = (function (){
var statearr_36648 = [null,null,null,null,null,null,null];
(statearr_36648[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__);

(statearr_36648[(1)] = (1));

return statearr_36648;
});
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1 = (function (state_36637){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__(state_36637);
if(cljs.core.keyword_identical_QMARK_(result__9168__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e36649){if((e36649 instanceof Object)){
var ex__9169__auto__ = e36649;
var statearr_36650_36785 = state_36637;
(statearr_36650_36785[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36637);

return cljs.core.cst$kw$recur;
} else {
throw e36649;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__9167__auto__,cljs.core.cst$kw$recur)){
var G__36786 = state_36637;
state_36637 = G__36786;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = function(state_36637){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1.call(this,state_36637);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__;
})()
;})(__36766,switch__9165__auto__,c__9230__auto___36778,G__36597_36767,n__5472__auto___36765,jobs,results,process,async))
})();
var state__9232__auto__ = (function (){var statearr_36651 = (f__9231__auto__.cljs$core$IFn$_invoke$arity$0 ? f__9231__auto__.cljs$core$IFn$_invoke$arity$0() : f__9231__auto__.call(null));
(statearr_36651[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___36778);

return statearr_36651;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__9232__auto__);
});})(__36766,c__9230__auto___36778,G__36597_36767,n__5472__auto___36765,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__36787 = (__36766 + (1));
__36766 = G__36787;
continue;
} else {
}
break;
}

var c__9230__auto___36788 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__9230__auto___36788,jobs,results,process,async){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___36788,jobs,results,process,async){
return (function (state_36673){
var state_val_36674 = (state_36673[(1)]);
if((state_val_36674 === (1))){
var state_36673__$1 = state_36673;
var statearr_36675_36789 = state_36673__$1;
(statearr_36675_36789[(2)] = null);

(statearr_36675_36789[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36674 === (2))){
var state_36673__$1 = state_36673;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36673__$1,(4),from);
} else {
if((state_val_36674 === (3))){
var inst_36671 = (state_36673[(2)]);
var state_36673__$1 = state_36673;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36673__$1,inst_36671);
} else {
if((state_val_36674 === (4))){
var inst_36654 = (state_36673[(7)]);
var inst_36654__$1 = (state_36673[(2)]);
var inst_36655 = (inst_36654__$1 == null);
var state_36673__$1 = (function (){var statearr_36676 = state_36673;
(statearr_36676[(7)] = inst_36654__$1);

return statearr_36676;
})();
if(cljs.core.truth_(inst_36655)){
var statearr_36677_36790 = state_36673__$1;
(statearr_36677_36790[(1)] = (5));

} else {
var statearr_36678_36791 = state_36673__$1;
(statearr_36678_36791[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36674 === (5))){
var inst_36657 = cljs.core.async.close_BANG_(jobs);
var state_36673__$1 = state_36673;
var statearr_36679_36792 = state_36673__$1;
(statearr_36679_36792[(2)] = inst_36657);

(statearr_36679_36792[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36674 === (6))){
var inst_36659 = (state_36673[(8)]);
var inst_36654 = (state_36673[(7)]);
var inst_36659__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_36660 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36661 = [inst_36654,inst_36659__$1];
var inst_36662 = (new cljs.core.PersistentVector(null,2,(5),inst_36660,inst_36661,null));
var state_36673__$1 = (function (){var statearr_36680 = state_36673;
(statearr_36680[(8)] = inst_36659__$1);

return statearr_36680;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36673__$1,(8),jobs,inst_36662);
} else {
if((state_val_36674 === (7))){
var inst_36669 = (state_36673[(2)]);
var state_36673__$1 = state_36673;
var statearr_36681_36793 = state_36673__$1;
(statearr_36681_36793[(2)] = inst_36669);

(statearr_36681_36793[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36674 === (8))){
var inst_36659 = (state_36673[(8)]);
var inst_36664 = (state_36673[(2)]);
var state_36673__$1 = (function (){var statearr_36682 = state_36673;
(statearr_36682[(9)] = inst_36664);

return statearr_36682;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36673__$1,(9),results,inst_36659);
} else {
if((state_val_36674 === (9))){
var inst_36666 = (state_36673[(2)]);
var state_36673__$1 = (function (){var statearr_36683 = state_36673;
(statearr_36683[(10)] = inst_36666);

return statearr_36683;
})();
var statearr_36684_36794 = state_36673__$1;
(statearr_36684_36794[(2)] = null);

(statearr_36684_36794[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___36788,jobs,results,process,async))
;
return ((function (switch__9165__auto__,c__9230__auto___36788,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0 = (function (){
var statearr_36688 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_36688[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__);

(statearr_36688[(1)] = (1));

return statearr_36688;
});
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1 = (function (state_36673){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__(state_36673);
if(cljs.core.keyword_identical_QMARK_(result__9168__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e36689){if((e36689 instanceof Object)){
var ex__9169__auto__ = e36689;
var statearr_36690_36795 = state_36673;
(statearr_36690_36795[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36673);

return cljs.core.cst$kw$recur;
} else {
throw e36689;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__9167__auto__,cljs.core.cst$kw$recur)){
var G__36796 = state_36673;
state_36673 = G__36796;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = function(state_36673){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1.call(this,state_36673);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___36788,jobs,results,process,async))
})();
var state__9232__auto__ = (function (){var statearr_36691 = (f__9231__auto__.cljs$core$IFn$_invoke$arity$0 ? f__9231__auto__.cljs$core$IFn$_invoke$arity$0() : f__9231__auto__.call(null));
(statearr_36691[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___36788);

return statearr_36691;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__9232__auto__);
});})(c__9230__auto___36788,jobs,results,process,async))
);


var c__9230__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__9230__auto__,jobs,results,process,async){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto__,jobs,results,process,async){
return (function (state_36729){
var state_val_36730 = (state_36729[(1)]);
if((state_val_36730 === (7))){
var inst_36725 = (state_36729[(2)]);
var state_36729__$1 = state_36729;
var statearr_36731_36797 = state_36729__$1;
(statearr_36731_36797[(2)] = inst_36725);

(statearr_36731_36797[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36730 === (20))){
var state_36729__$1 = state_36729;
var statearr_36732_36798 = state_36729__$1;
(statearr_36732_36798[(2)] = null);

(statearr_36732_36798[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36730 === (1))){
var state_36729__$1 = state_36729;
var statearr_36733_36799 = state_36729__$1;
(statearr_36733_36799[(2)] = null);

(statearr_36733_36799[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36730 === (4))){
var inst_36694 = (state_36729[(7)]);
var inst_36694__$1 = (state_36729[(2)]);
var inst_36695 = (inst_36694__$1 == null);
var state_36729__$1 = (function (){var statearr_36734 = state_36729;
(statearr_36734[(7)] = inst_36694__$1);

return statearr_36734;
})();
if(cljs.core.truth_(inst_36695)){
var statearr_36735_36800 = state_36729__$1;
(statearr_36735_36800[(1)] = (5));

} else {
var statearr_36736_36801 = state_36729__$1;
(statearr_36736_36801[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36730 === (15))){
var inst_36707 = (state_36729[(8)]);
var state_36729__$1 = state_36729;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36729__$1,(18),to,inst_36707);
} else {
if((state_val_36730 === (21))){
var inst_36720 = (state_36729[(2)]);
var state_36729__$1 = state_36729;
var statearr_36737_36802 = state_36729__$1;
(statearr_36737_36802[(2)] = inst_36720);

(statearr_36737_36802[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36730 === (13))){
var inst_36722 = (state_36729[(2)]);
var state_36729__$1 = (function (){var statearr_36738 = state_36729;
(statearr_36738[(9)] = inst_36722);

return statearr_36738;
})();
var statearr_36739_36803 = state_36729__$1;
(statearr_36739_36803[(2)] = null);

(statearr_36739_36803[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36730 === (6))){
var inst_36694 = (state_36729[(7)]);
var state_36729__$1 = state_36729;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36729__$1,(11),inst_36694);
} else {
if((state_val_36730 === (17))){
var inst_36715 = (state_36729[(2)]);
var state_36729__$1 = state_36729;
if(cljs.core.truth_(inst_36715)){
var statearr_36740_36804 = state_36729__$1;
(statearr_36740_36804[(1)] = (19));

} else {
var statearr_36741_36805 = state_36729__$1;
(statearr_36741_36805[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36730 === (3))){
var inst_36727 = (state_36729[(2)]);
var state_36729__$1 = state_36729;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36729__$1,inst_36727);
} else {
if((state_val_36730 === (12))){
var inst_36704 = (state_36729[(10)]);
var state_36729__$1 = state_36729;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36729__$1,(14),inst_36704);
} else {
if((state_val_36730 === (2))){
var state_36729__$1 = state_36729;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36729__$1,(4),results);
} else {
if((state_val_36730 === (19))){
var state_36729__$1 = state_36729;
var statearr_36742_36806 = state_36729__$1;
(statearr_36742_36806[(2)] = null);

(statearr_36742_36806[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36730 === (11))){
var inst_36704 = (state_36729[(2)]);
var state_36729__$1 = (function (){var statearr_36743 = state_36729;
(statearr_36743[(10)] = inst_36704);

return statearr_36743;
})();
var statearr_36744_36807 = state_36729__$1;
(statearr_36744_36807[(2)] = null);

(statearr_36744_36807[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36730 === (9))){
var state_36729__$1 = state_36729;
var statearr_36745_36808 = state_36729__$1;
(statearr_36745_36808[(2)] = null);

(statearr_36745_36808[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36730 === (5))){
var state_36729__$1 = state_36729;
if(cljs.core.truth_(close_QMARK_)){
var statearr_36746_36809 = state_36729__$1;
(statearr_36746_36809[(1)] = (8));

} else {
var statearr_36747_36810 = state_36729__$1;
(statearr_36747_36810[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36730 === (14))){
var inst_36709 = (state_36729[(11)]);
var inst_36707 = (state_36729[(8)]);
var inst_36707__$1 = (state_36729[(2)]);
var inst_36708 = (inst_36707__$1 == null);
var inst_36709__$1 = cljs.core.not(inst_36708);
var state_36729__$1 = (function (){var statearr_36748 = state_36729;
(statearr_36748[(11)] = inst_36709__$1);

(statearr_36748[(8)] = inst_36707__$1);

return statearr_36748;
})();
if(inst_36709__$1){
var statearr_36749_36811 = state_36729__$1;
(statearr_36749_36811[(1)] = (15));

} else {
var statearr_36750_36812 = state_36729__$1;
(statearr_36750_36812[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36730 === (16))){
var inst_36709 = (state_36729[(11)]);
var state_36729__$1 = state_36729;
var statearr_36751_36813 = state_36729__$1;
(statearr_36751_36813[(2)] = inst_36709);

(statearr_36751_36813[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36730 === (10))){
var inst_36701 = (state_36729[(2)]);
var state_36729__$1 = state_36729;
var statearr_36752_36814 = state_36729__$1;
(statearr_36752_36814[(2)] = inst_36701);

(statearr_36752_36814[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36730 === (18))){
var inst_36712 = (state_36729[(2)]);
var state_36729__$1 = state_36729;
var statearr_36753_36815 = state_36729__$1;
(statearr_36753_36815[(2)] = inst_36712);

(statearr_36753_36815[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36730 === (8))){
var inst_36698 = cljs.core.async.close_BANG_(to);
var state_36729__$1 = state_36729;
var statearr_36754_36816 = state_36729__$1;
(statearr_36754_36816[(2)] = inst_36698);

(statearr_36754_36816[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto__,jobs,results,process,async))
;
return ((function (switch__9165__auto__,c__9230__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0 = (function (){
var statearr_36758 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36758[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__);

(statearr_36758[(1)] = (1));

return statearr_36758;
});
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1 = (function (state_36729){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__(state_36729);
if(cljs.core.keyword_identical_QMARK_(result__9168__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e36759){if((e36759 instanceof Object)){
var ex__9169__auto__ = e36759;
var statearr_36760_36817 = state_36729;
(statearr_36760_36817[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36729);

return cljs.core.cst$kw$recur;
} else {
throw e36759;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__9167__auto__,cljs.core.cst$kw$recur)){
var G__36818 = state_36729;
state_36729 = G__36818;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = function(state_36729){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1.call(this,state_36729);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto__,jobs,results,process,async))
})();
var state__9232__auto__ = (function (){var statearr_36761 = (f__9231__auto__.cljs$core$IFn$_invoke$arity$0 ? f__9231__auto__.cljs$core$IFn$_invoke$arity$0() : f__9231__auto__.call(null));
(statearr_36761[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto__);

return statearr_36761;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__9232__auto__);
});})(c__9230__auto__,jobs,results,process,async))
);

return c__9230__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args36819 = [];
var len__5627__auto___36822 = arguments.length;
var i__5628__auto___36823 = (0);
while(true){
if((i__5628__auto___36823 < len__5627__auto___36822)){
args36819.push((arguments[i__5628__auto___36823]));

var G__36824 = (i__5628__auto___36823 + (1));
i__5628__auto___36823 = G__36824;
continue;
} else {
}
break;
}

var G__36821 = args36819.length;
switch (G__36821) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36819.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args36826 = [];
var len__5627__auto___36829 = arguments.length;
var i__5628__auto___36830 = (0);
while(true){
if((i__5628__auto___36830 < len__5627__auto___36829)){
args36826.push((arguments[i__5628__auto___36830]));

var G__36831 = (i__5628__auto___36830 + (1));
i__5628__auto___36830 = G__36831;
continue;
} else {
}
break;
}

var G__36828 = args36826.length;
switch (G__36828) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36826.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args36833 = [];
var len__5627__auto___36886 = arguments.length;
var i__5628__auto___36887 = (0);
while(true){
if((i__5628__auto___36887 < len__5627__auto___36886)){
args36833.push((arguments[i__5628__auto___36887]));

var G__36888 = (i__5628__auto___36887 + (1));
i__5628__auto___36887 = G__36888;
continue;
} else {
}
break;
}

var G__36835 = args36833.length;
switch (G__36835) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36833.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__9230__auto___36890 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__9230__auto___36890,tc,fc){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___36890,tc,fc){
return (function (state_36861){
var state_val_36862 = (state_36861[(1)]);
if((state_val_36862 === (7))){
var inst_36857 = (state_36861[(2)]);
var state_36861__$1 = state_36861;
var statearr_36863_36891 = state_36861__$1;
(statearr_36863_36891[(2)] = inst_36857);

(statearr_36863_36891[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36862 === (1))){
var state_36861__$1 = state_36861;
var statearr_36864_36892 = state_36861__$1;
(statearr_36864_36892[(2)] = null);

(statearr_36864_36892[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36862 === (4))){
var inst_36838 = (state_36861[(7)]);
var inst_36838__$1 = (state_36861[(2)]);
var inst_36839 = (inst_36838__$1 == null);
var state_36861__$1 = (function (){var statearr_36865 = state_36861;
(statearr_36865[(7)] = inst_36838__$1);

return statearr_36865;
})();
if(cljs.core.truth_(inst_36839)){
var statearr_36866_36893 = state_36861__$1;
(statearr_36866_36893[(1)] = (5));

} else {
var statearr_36867_36894 = state_36861__$1;
(statearr_36867_36894[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36862 === (13))){
var state_36861__$1 = state_36861;
var statearr_36868_36895 = state_36861__$1;
(statearr_36868_36895[(2)] = null);

(statearr_36868_36895[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36862 === (6))){
var inst_36838 = (state_36861[(7)]);
var inst_36844 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_36838) : p.call(null,inst_36838));
var state_36861__$1 = state_36861;
if(cljs.core.truth_(inst_36844)){
var statearr_36869_36896 = state_36861__$1;
(statearr_36869_36896[(1)] = (9));

} else {
var statearr_36870_36897 = state_36861__$1;
(statearr_36870_36897[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36862 === (3))){
var inst_36859 = (state_36861[(2)]);
var state_36861__$1 = state_36861;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36861__$1,inst_36859);
} else {
if((state_val_36862 === (12))){
var state_36861__$1 = state_36861;
var statearr_36871_36898 = state_36861__$1;
(statearr_36871_36898[(2)] = null);

(statearr_36871_36898[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36862 === (2))){
var state_36861__$1 = state_36861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36861__$1,(4),ch);
} else {
if((state_val_36862 === (11))){
var inst_36838 = (state_36861[(7)]);
var inst_36848 = (state_36861[(2)]);
var state_36861__$1 = state_36861;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36861__$1,(8),inst_36848,inst_36838);
} else {
if((state_val_36862 === (9))){
var state_36861__$1 = state_36861;
var statearr_36872_36899 = state_36861__$1;
(statearr_36872_36899[(2)] = tc);

(statearr_36872_36899[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36862 === (5))){
var inst_36841 = cljs.core.async.close_BANG_(tc);
var inst_36842 = cljs.core.async.close_BANG_(fc);
var state_36861__$1 = (function (){var statearr_36873 = state_36861;
(statearr_36873[(8)] = inst_36841);

return statearr_36873;
})();
var statearr_36874_36900 = state_36861__$1;
(statearr_36874_36900[(2)] = inst_36842);

(statearr_36874_36900[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36862 === (14))){
var inst_36855 = (state_36861[(2)]);
var state_36861__$1 = state_36861;
var statearr_36875_36901 = state_36861__$1;
(statearr_36875_36901[(2)] = inst_36855);

(statearr_36875_36901[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36862 === (10))){
var state_36861__$1 = state_36861;
var statearr_36876_36902 = state_36861__$1;
(statearr_36876_36902[(2)] = fc);

(statearr_36876_36902[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36862 === (8))){
var inst_36850 = (state_36861[(2)]);
var state_36861__$1 = state_36861;
if(cljs.core.truth_(inst_36850)){
var statearr_36877_36903 = state_36861__$1;
(statearr_36877_36903[(1)] = (12));

} else {
var statearr_36878_36904 = state_36861__$1;
(statearr_36878_36904[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___36890,tc,fc))
;
return ((function (switch__9165__auto__,c__9230__auto___36890,tc,fc){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_36882 = [null,null,null,null,null,null,null,null,null];
(statearr_36882[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_36882[(1)] = (1));

return statearr_36882;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_36861){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__(state_36861);
if(cljs.core.keyword_identical_QMARK_(result__9168__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e36883){if((e36883 instanceof Object)){
var ex__9169__auto__ = e36883;
var statearr_36884_36905 = state_36861;
(statearr_36884_36905[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36861);

return cljs.core.cst$kw$recur;
} else {
throw e36883;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__9167__auto__,cljs.core.cst$kw$recur)){
var G__36906 = state_36861;
state_36861 = G__36906;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_36861){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_36861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___36890,tc,fc))
})();
var state__9232__auto__ = (function (){var statearr_36885 = (f__9231__auto__.cljs$core$IFn$_invoke$arity$0 ? f__9231__auto__.cljs$core$IFn$_invoke$arity$0() : f__9231__auto__.call(null));
(statearr_36885[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___36890);

return statearr_36885;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__9232__auto__);
});})(c__9230__auto___36890,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__9230__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__9230__auto__){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto__){
return (function (state_36953){
var state_val_36954 = (state_36953[(1)]);
if((state_val_36954 === (1))){
var inst_36939 = init;
var state_36953__$1 = (function (){var statearr_36955 = state_36953;
(statearr_36955[(7)] = inst_36939);

return statearr_36955;
})();
var statearr_36956_36971 = state_36953__$1;
(statearr_36956_36971[(2)] = null);

(statearr_36956_36971[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36954 === (2))){
var state_36953__$1 = state_36953;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36953__$1,(4),ch);
} else {
if((state_val_36954 === (3))){
var inst_36951 = (state_36953[(2)]);
var state_36953__$1 = state_36953;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36953__$1,inst_36951);
} else {
if((state_val_36954 === (4))){
var inst_36942 = (state_36953[(8)]);
var inst_36942__$1 = (state_36953[(2)]);
var inst_36943 = (inst_36942__$1 == null);
var state_36953__$1 = (function (){var statearr_36957 = state_36953;
(statearr_36957[(8)] = inst_36942__$1);

return statearr_36957;
})();
if(cljs.core.truth_(inst_36943)){
var statearr_36958_36972 = state_36953__$1;
(statearr_36958_36972[(1)] = (5));

} else {
var statearr_36959_36973 = state_36953__$1;
(statearr_36959_36973[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36954 === (5))){
var inst_36939 = (state_36953[(7)]);
var state_36953__$1 = state_36953;
var statearr_36960_36974 = state_36953__$1;
(statearr_36960_36974[(2)] = inst_36939);

(statearr_36960_36974[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36954 === (6))){
var inst_36942 = (state_36953[(8)]);
var inst_36939 = (state_36953[(7)]);
var inst_36946 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_36939,inst_36942) : f.call(null,inst_36939,inst_36942));
var inst_36939__$1 = inst_36946;
var state_36953__$1 = (function (){var statearr_36961 = state_36953;
(statearr_36961[(7)] = inst_36939__$1);

return statearr_36961;
})();
var statearr_36962_36975 = state_36953__$1;
(statearr_36962_36975[(2)] = null);

(statearr_36962_36975[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36954 === (7))){
var inst_36949 = (state_36953[(2)]);
var state_36953__$1 = state_36953;
var statearr_36963_36976 = state_36953__$1;
(statearr_36963_36976[(2)] = inst_36949);

(statearr_36963_36976[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__9230__auto__))
;
return ((function (switch__9165__auto__,c__9230__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__9166__auto__ = null;
var cljs$core$async$reduce_$_state_machine__9166__auto____0 = (function (){
var statearr_36967 = [null,null,null,null,null,null,null,null,null];
(statearr_36967[(0)] = cljs$core$async$reduce_$_state_machine__9166__auto__);

(statearr_36967[(1)] = (1));

return statearr_36967;
});
var cljs$core$async$reduce_$_state_machine__9166__auto____1 = (function (state_36953){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__(state_36953);
if(cljs.core.keyword_identical_QMARK_(result__9168__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e36968){if((e36968 instanceof Object)){
var ex__9169__auto__ = e36968;
var statearr_36969_36977 = state_36953;
(statearr_36969_36977[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36953);

return cljs.core.cst$kw$recur;
} else {
throw e36968;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__9167__auto__,cljs.core.cst$kw$recur)){
var G__36978 = state_36953;
state_36953 = G__36978;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__9166__auto__ = function(state_36953){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__9166__auto____1.call(this,state_36953);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__9166__auto____0;
cljs$core$async$reduce_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__9166__auto____1;
return cljs$core$async$reduce_$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto__))
})();
var state__9232__auto__ = (function (){var statearr_36970 = (f__9231__auto__.cljs$core$IFn$_invoke$arity$0 ? f__9231__auto__.cljs$core$IFn$_invoke$arity$0() : f__9231__auto__.call(null));
(statearr_36970[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto__);

return statearr_36970;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__9232__auto__);
});})(c__9230__auto__))
);

return c__9230__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args36979 = [];
var len__5627__auto___37031 = arguments.length;
var i__5628__auto___37032 = (0);
while(true){
if((i__5628__auto___37032 < len__5627__auto___37031)){
args36979.push((arguments[i__5628__auto___37032]));

var G__37033 = (i__5628__auto___37032 + (1));
i__5628__auto___37032 = G__37033;
continue;
} else {
}
break;
}

var G__36981 = args36979.length;
switch (G__36981) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36979.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__9230__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__9230__auto__){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto__){
return (function (state_37006){
var state_val_37007 = (state_37006[(1)]);
if((state_val_37007 === (7))){
var inst_36988 = (state_37006[(2)]);
var state_37006__$1 = state_37006;
var statearr_37008_37035 = state_37006__$1;
(statearr_37008_37035[(2)] = inst_36988);

(statearr_37008_37035[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37007 === (1))){
var inst_36982 = cljs.core.seq(coll);
var inst_36983 = inst_36982;
var state_37006__$1 = (function (){var statearr_37009 = state_37006;
(statearr_37009[(7)] = inst_36983);

return statearr_37009;
})();
var statearr_37010_37036 = state_37006__$1;
(statearr_37010_37036[(2)] = null);

(statearr_37010_37036[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37007 === (4))){
var inst_36983 = (state_37006[(7)]);
var inst_36986 = cljs.core.first(inst_36983);
var state_37006__$1 = state_37006;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37006__$1,(7),ch,inst_36986);
} else {
if((state_val_37007 === (13))){
var inst_37000 = (state_37006[(2)]);
var state_37006__$1 = state_37006;
var statearr_37011_37037 = state_37006__$1;
(statearr_37011_37037[(2)] = inst_37000);

(statearr_37011_37037[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37007 === (6))){
var inst_36991 = (state_37006[(2)]);
var state_37006__$1 = state_37006;
if(cljs.core.truth_(inst_36991)){
var statearr_37012_37038 = state_37006__$1;
(statearr_37012_37038[(1)] = (8));

} else {
var statearr_37013_37039 = state_37006__$1;
(statearr_37013_37039[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37007 === (3))){
var inst_37004 = (state_37006[(2)]);
var state_37006__$1 = state_37006;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37006__$1,inst_37004);
} else {
if((state_val_37007 === (12))){
var state_37006__$1 = state_37006;
var statearr_37014_37040 = state_37006__$1;
(statearr_37014_37040[(2)] = null);

(statearr_37014_37040[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37007 === (2))){
var inst_36983 = (state_37006[(7)]);
var state_37006__$1 = state_37006;
if(cljs.core.truth_(inst_36983)){
var statearr_37015_37041 = state_37006__$1;
(statearr_37015_37041[(1)] = (4));

} else {
var statearr_37016_37042 = state_37006__$1;
(statearr_37016_37042[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37007 === (11))){
var inst_36997 = cljs.core.async.close_BANG_(ch);
var state_37006__$1 = state_37006;
var statearr_37017_37043 = state_37006__$1;
(statearr_37017_37043[(2)] = inst_36997);

(statearr_37017_37043[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37007 === (9))){
var state_37006__$1 = state_37006;
if(cljs.core.truth_(close_QMARK_)){
var statearr_37018_37044 = state_37006__$1;
(statearr_37018_37044[(1)] = (11));

} else {
var statearr_37019_37045 = state_37006__$1;
(statearr_37019_37045[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37007 === (5))){
var inst_36983 = (state_37006[(7)]);
var state_37006__$1 = state_37006;
var statearr_37020_37046 = state_37006__$1;
(statearr_37020_37046[(2)] = inst_36983);

(statearr_37020_37046[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37007 === (10))){
var inst_37002 = (state_37006[(2)]);
var state_37006__$1 = state_37006;
var statearr_37021_37047 = state_37006__$1;
(statearr_37021_37047[(2)] = inst_37002);

(statearr_37021_37047[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37007 === (8))){
var inst_36983 = (state_37006[(7)]);
var inst_36993 = cljs.core.next(inst_36983);
var inst_36983__$1 = inst_36993;
var state_37006__$1 = (function (){var statearr_37022 = state_37006;
(statearr_37022[(7)] = inst_36983__$1);

return statearr_37022;
})();
var statearr_37023_37048 = state_37006__$1;
(statearr_37023_37048[(2)] = null);

(statearr_37023_37048[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto__))
;
return ((function (switch__9165__auto__,c__9230__auto__){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_37027 = [null,null,null,null,null,null,null,null];
(statearr_37027[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_37027[(1)] = (1));

return statearr_37027;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_37006){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__(state_37006);
if(cljs.core.keyword_identical_QMARK_(result__9168__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e37028){if((e37028 instanceof Object)){
var ex__9169__auto__ = e37028;
var statearr_37029_37049 = state_37006;
(statearr_37029_37049[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37006);

return cljs.core.cst$kw$recur;
} else {
throw e37028;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__9167__auto__,cljs.core.cst$kw$recur)){
var G__37050 = state_37006;
state_37006 = G__37050;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_37006){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_37006);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto__))
})();
var state__9232__auto__ = (function (){var statearr_37030 = (f__9231__auto__.cljs$core$IFn$_invoke$arity$0 ? f__9231__auto__.cljs$core$IFn$_invoke$arity$0() : f__9231__auto__.call(null));
(statearr_37030[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto__);

return statearr_37030;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__9232__auto__);
});})(c__9230__auto__))
);

return c__9230__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5224__auto__ = (((_ == null))?null:_);
var m__5225__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5225__auto__.call(null,_));
} else {
var m__5225__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__5225__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5225__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__5225__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5225__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto__.call(null,m,ch));
} else {
var m__5225__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5225__auto__.call(null,m));
} else {
var m__5225__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__5225__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__37275 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__37275) : cljs.core.atom.call(null,G__37275));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async37276 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37276 = (function (mult,ch,cs,meta37277){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta37277 = meta37277;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async37276.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_37278,meta37277__$1){
var self__ = this;
var _37278__$1 = this;
return (new cljs.core.async.t_cljs$core$async37276(self__.mult,self__.ch,self__.cs,meta37277__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async37276.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_37278){
var self__ = this;
var _37278__$1 = this;
return self__.meta37277;
});})(cs))
;

cljs.core.async.t_cljs$core$async37276.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async37276.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async37276.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async37276.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async37276.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async37276.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__37279_37499 = self__.cs;
var G__37280_37500 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__37279_37499,G__37280_37500) : cljs.core.reset_BANG_.call(null,G__37279_37499,G__37280_37500));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async37276.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mult,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta37277], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async37276.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async37276.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37276";

cljs.core.async.t_cljs$core$async37276.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async37276");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async37276 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async37276(mult__$1,ch__$1,cs__$1,meta37277){
return (new cljs.core.async.t_cljs$core$async37276(mult__$1,ch__$1,cs__$1,meta37277));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async37276(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__9230__auto___37501 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__9230__auto___37501,cs,m,dchan,dctr,done){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___37501,cs,m,dchan,dctr,done){
return (function (state_37411){
var state_val_37412 = (state_37411[(1)]);
if((state_val_37412 === (7))){
var inst_37407 = (state_37411[(2)]);
var state_37411__$1 = state_37411;
var statearr_37413_37502 = state_37411__$1;
(statearr_37413_37502[(2)] = inst_37407);

(statearr_37413_37502[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (20))){
var inst_37312 = (state_37411[(7)]);
var inst_37322 = cljs.core.first(inst_37312);
var inst_37323 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37322,(0),null);
var inst_37324 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37322,(1),null);
var state_37411__$1 = (function (){var statearr_37414 = state_37411;
(statearr_37414[(8)] = inst_37323);

return statearr_37414;
})();
if(cljs.core.truth_(inst_37324)){
var statearr_37415_37503 = state_37411__$1;
(statearr_37415_37503[(1)] = (22));

} else {
var statearr_37416_37504 = state_37411__$1;
(statearr_37416_37504[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (27))){
var inst_37283 = (state_37411[(9)]);
var inst_37359 = (state_37411[(10)]);
var inst_37354 = (state_37411[(11)]);
var inst_37352 = (state_37411[(12)]);
var inst_37359__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_37352,inst_37354);
var inst_37360 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_37359__$1,inst_37283,done);
var state_37411__$1 = (function (){var statearr_37417 = state_37411;
(statearr_37417[(10)] = inst_37359__$1);

return statearr_37417;
})();
if(cljs.core.truth_(inst_37360)){
var statearr_37418_37505 = state_37411__$1;
(statearr_37418_37505[(1)] = (30));

} else {
var statearr_37419_37506 = state_37411__$1;
(statearr_37419_37506[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (1))){
var state_37411__$1 = state_37411;
var statearr_37420_37507 = state_37411__$1;
(statearr_37420_37507[(2)] = null);

(statearr_37420_37507[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (24))){
var inst_37312 = (state_37411[(7)]);
var inst_37329 = (state_37411[(2)]);
var inst_37330 = cljs.core.next(inst_37312);
var inst_37292 = inst_37330;
var inst_37293 = null;
var inst_37294 = (0);
var inst_37295 = (0);
var state_37411__$1 = (function (){var statearr_37421 = state_37411;
(statearr_37421[(13)] = inst_37292);

(statearr_37421[(14)] = inst_37294);

(statearr_37421[(15)] = inst_37293);

(statearr_37421[(16)] = inst_37295);

(statearr_37421[(17)] = inst_37329);

return statearr_37421;
})();
var statearr_37422_37508 = state_37411__$1;
(statearr_37422_37508[(2)] = null);

(statearr_37422_37508[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (39))){
var state_37411__$1 = state_37411;
var statearr_37426_37509 = state_37411__$1;
(statearr_37426_37509[(2)] = null);

(statearr_37426_37509[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (4))){
var inst_37283 = (state_37411[(9)]);
var inst_37283__$1 = (state_37411[(2)]);
var inst_37284 = (inst_37283__$1 == null);
var state_37411__$1 = (function (){var statearr_37427 = state_37411;
(statearr_37427[(9)] = inst_37283__$1);

return statearr_37427;
})();
if(cljs.core.truth_(inst_37284)){
var statearr_37428_37510 = state_37411__$1;
(statearr_37428_37510[(1)] = (5));

} else {
var statearr_37429_37511 = state_37411__$1;
(statearr_37429_37511[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (15))){
var inst_37292 = (state_37411[(13)]);
var inst_37294 = (state_37411[(14)]);
var inst_37293 = (state_37411[(15)]);
var inst_37295 = (state_37411[(16)]);
var inst_37308 = (state_37411[(2)]);
var inst_37309 = (inst_37295 + (1));
var tmp37423 = inst_37292;
var tmp37424 = inst_37294;
var tmp37425 = inst_37293;
var inst_37292__$1 = tmp37423;
var inst_37293__$1 = tmp37425;
var inst_37294__$1 = tmp37424;
var inst_37295__$1 = inst_37309;
var state_37411__$1 = (function (){var statearr_37430 = state_37411;
(statearr_37430[(13)] = inst_37292__$1);

(statearr_37430[(14)] = inst_37294__$1);

(statearr_37430[(15)] = inst_37293__$1);

(statearr_37430[(16)] = inst_37295__$1);

(statearr_37430[(18)] = inst_37308);

return statearr_37430;
})();
var statearr_37431_37512 = state_37411__$1;
(statearr_37431_37512[(2)] = null);

(statearr_37431_37512[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (21))){
var inst_37333 = (state_37411[(2)]);
var state_37411__$1 = state_37411;
var statearr_37435_37513 = state_37411__$1;
(statearr_37435_37513[(2)] = inst_37333);

(statearr_37435_37513[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (31))){
var inst_37359 = (state_37411[(10)]);
var inst_37363 = done(null);
var inst_37364 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_37359);
var state_37411__$1 = (function (){var statearr_37436 = state_37411;
(statearr_37436[(19)] = inst_37363);

return statearr_37436;
})();
var statearr_37437_37514 = state_37411__$1;
(statearr_37437_37514[(2)] = inst_37364);

(statearr_37437_37514[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (32))){
var inst_37354 = (state_37411[(11)]);
var inst_37353 = (state_37411[(20)]);
var inst_37351 = (state_37411[(21)]);
var inst_37352 = (state_37411[(12)]);
var inst_37366 = (state_37411[(2)]);
var inst_37367 = (inst_37354 + (1));
var tmp37432 = inst_37353;
var tmp37433 = inst_37351;
var tmp37434 = inst_37352;
var inst_37351__$1 = tmp37433;
var inst_37352__$1 = tmp37434;
var inst_37353__$1 = tmp37432;
var inst_37354__$1 = inst_37367;
var state_37411__$1 = (function (){var statearr_37438 = state_37411;
(statearr_37438[(22)] = inst_37366);

(statearr_37438[(11)] = inst_37354__$1);

(statearr_37438[(20)] = inst_37353__$1);

(statearr_37438[(21)] = inst_37351__$1);

(statearr_37438[(12)] = inst_37352__$1);

return statearr_37438;
})();
var statearr_37439_37515 = state_37411__$1;
(statearr_37439_37515[(2)] = null);

(statearr_37439_37515[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (40))){
var inst_37379 = (state_37411[(23)]);
var inst_37383 = done(null);
var inst_37384 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_37379);
var state_37411__$1 = (function (){var statearr_37440 = state_37411;
(statearr_37440[(24)] = inst_37383);

return statearr_37440;
})();
var statearr_37441_37516 = state_37411__$1;
(statearr_37441_37516[(2)] = inst_37384);

(statearr_37441_37516[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (33))){
var inst_37370 = (state_37411[(25)]);
var inst_37372 = cljs.core.chunked_seq_QMARK_(inst_37370);
var state_37411__$1 = state_37411;
if(inst_37372){
var statearr_37442_37517 = state_37411__$1;
(statearr_37442_37517[(1)] = (36));

} else {
var statearr_37443_37518 = state_37411__$1;
(statearr_37443_37518[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (13))){
var inst_37302 = (state_37411[(26)]);
var inst_37305 = cljs.core.async.close_BANG_(inst_37302);
var state_37411__$1 = state_37411;
var statearr_37444_37519 = state_37411__$1;
(statearr_37444_37519[(2)] = inst_37305);

(statearr_37444_37519[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (22))){
var inst_37323 = (state_37411[(8)]);
var inst_37326 = cljs.core.async.close_BANG_(inst_37323);
var state_37411__$1 = state_37411;
var statearr_37445_37520 = state_37411__$1;
(statearr_37445_37520[(2)] = inst_37326);

(statearr_37445_37520[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (36))){
var inst_37370 = (state_37411[(25)]);
var inst_37374 = cljs.core.chunk_first(inst_37370);
var inst_37375 = cljs.core.chunk_rest(inst_37370);
var inst_37376 = cljs.core.count(inst_37374);
var inst_37351 = inst_37375;
var inst_37352 = inst_37374;
var inst_37353 = inst_37376;
var inst_37354 = (0);
var state_37411__$1 = (function (){var statearr_37446 = state_37411;
(statearr_37446[(11)] = inst_37354);

(statearr_37446[(20)] = inst_37353);

(statearr_37446[(21)] = inst_37351);

(statearr_37446[(12)] = inst_37352);

return statearr_37446;
})();
var statearr_37447_37521 = state_37411__$1;
(statearr_37447_37521[(2)] = null);

(statearr_37447_37521[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (41))){
var inst_37370 = (state_37411[(25)]);
var inst_37386 = (state_37411[(2)]);
var inst_37387 = cljs.core.next(inst_37370);
var inst_37351 = inst_37387;
var inst_37352 = null;
var inst_37353 = (0);
var inst_37354 = (0);
var state_37411__$1 = (function (){var statearr_37448 = state_37411;
(statearr_37448[(11)] = inst_37354);

(statearr_37448[(27)] = inst_37386);

(statearr_37448[(20)] = inst_37353);

(statearr_37448[(21)] = inst_37351);

(statearr_37448[(12)] = inst_37352);

return statearr_37448;
})();
var statearr_37449_37522 = state_37411__$1;
(statearr_37449_37522[(2)] = null);

(statearr_37449_37522[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (43))){
var state_37411__$1 = state_37411;
var statearr_37450_37523 = state_37411__$1;
(statearr_37450_37523[(2)] = null);

(statearr_37450_37523[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (29))){
var inst_37395 = (state_37411[(2)]);
var state_37411__$1 = state_37411;
var statearr_37451_37524 = state_37411__$1;
(statearr_37451_37524[(2)] = inst_37395);

(statearr_37451_37524[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (44))){
var inst_37404 = (state_37411[(2)]);
var state_37411__$1 = (function (){var statearr_37452 = state_37411;
(statearr_37452[(28)] = inst_37404);

return statearr_37452;
})();
var statearr_37453_37525 = state_37411__$1;
(statearr_37453_37525[(2)] = null);

(statearr_37453_37525[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (6))){
var inst_37343 = (state_37411[(29)]);
var inst_37342 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_37343__$1 = cljs.core.keys(inst_37342);
var inst_37344 = cljs.core.count(inst_37343__$1);
var inst_37345 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_37344) : cljs.core.reset_BANG_.call(null,dctr,inst_37344));
var inst_37350 = cljs.core.seq(inst_37343__$1);
var inst_37351 = inst_37350;
var inst_37352 = null;
var inst_37353 = (0);
var inst_37354 = (0);
var state_37411__$1 = (function (){var statearr_37454 = state_37411;
(statearr_37454[(11)] = inst_37354);

(statearr_37454[(30)] = inst_37345);

(statearr_37454[(20)] = inst_37353);

(statearr_37454[(21)] = inst_37351);

(statearr_37454[(12)] = inst_37352);

(statearr_37454[(29)] = inst_37343__$1);

return statearr_37454;
})();
var statearr_37455_37526 = state_37411__$1;
(statearr_37455_37526[(2)] = null);

(statearr_37455_37526[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (28))){
var inst_37370 = (state_37411[(25)]);
var inst_37351 = (state_37411[(21)]);
var inst_37370__$1 = cljs.core.seq(inst_37351);
var state_37411__$1 = (function (){var statearr_37456 = state_37411;
(statearr_37456[(25)] = inst_37370__$1);

return statearr_37456;
})();
if(inst_37370__$1){
var statearr_37457_37527 = state_37411__$1;
(statearr_37457_37527[(1)] = (33));

} else {
var statearr_37458_37528 = state_37411__$1;
(statearr_37458_37528[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (25))){
var inst_37354 = (state_37411[(11)]);
var inst_37353 = (state_37411[(20)]);
var inst_37356 = (inst_37354 < inst_37353);
var inst_37357 = inst_37356;
var state_37411__$1 = state_37411;
if(cljs.core.truth_(inst_37357)){
var statearr_37459_37529 = state_37411__$1;
(statearr_37459_37529[(1)] = (27));

} else {
var statearr_37460_37530 = state_37411__$1;
(statearr_37460_37530[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (34))){
var state_37411__$1 = state_37411;
var statearr_37461_37531 = state_37411__$1;
(statearr_37461_37531[(2)] = null);

(statearr_37461_37531[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (17))){
var state_37411__$1 = state_37411;
var statearr_37462_37532 = state_37411__$1;
(statearr_37462_37532[(2)] = null);

(statearr_37462_37532[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (3))){
var inst_37409 = (state_37411[(2)]);
var state_37411__$1 = state_37411;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37411__$1,inst_37409);
} else {
if((state_val_37412 === (12))){
var inst_37338 = (state_37411[(2)]);
var state_37411__$1 = state_37411;
var statearr_37463_37533 = state_37411__$1;
(statearr_37463_37533[(2)] = inst_37338);

(statearr_37463_37533[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (2))){
var state_37411__$1 = state_37411;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37411__$1,(4),ch);
} else {
if((state_val_37412 === (23))){
var state_37411__$1 = state_37411;
var statearr_37464_37534 = state_37411__$1;
(statearr_37464_37534[(2)] = null);

(statearr_37464_37534[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (35))){
var inst_37393 = (state_37411[(2)]);
var state_37411__$1 = state_37411;
var statearr_37465_37535 = state_37411__$1;
(statearr_37465_37535[(2)] = inst_37393);

(statearr_37465_37535[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (19))){
var inst_37312 = (state_37411[(7)]);
var inst_37316 = cljs.core.chunk_first(inst_37312);
var inst_37317 = cljs.core.chunk_rest(inst_37312);
var inst_37318 = cljs.core.count(inst_37316);
var inst_37292 = inst_37317;
var inst_37293 = inst_37316;
var inst_37294 = inst_37318;
var inst_37295 = (0);
var state_37411__$1 = (function (){var statearr_37466 = state_37411;
(statearr_37466[(13)] = inst_37292);

(statearr_37466[(14)] = inst_37294);

(statearr_37466[(15)] = inst_37293);

(statearr_37466[(16)] = inst_37295);

return statearr_37466;
})();
var statearr_37467_37536 = state_37411__$1;
(statearr_37467_37536[(2)] = null);

(statearr_37467_37536[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (11))){
var inst_37292 = (state_37411[(13)]);
var inst_37312 = (state_37411[(7)]);
var inst_37312__$1 = cljs.core.seq(inst_37292);
var state_37411__$1 = (function (){var statearr_37468 = state_37411;
(statearr_37468[(7)] = inst_37312__$1);

return statearr_37468;
})();
if(inst_37312__$1){
var statearr_37469_37537 = state_37411__$1;
(statearr_37469_37537[(1)] = (16));

} else {
var statearr_37470_37538 = state_37411__$1;
(statearr_37470_37538[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (9))){
var inst_37340 = (state_37411[(2)]);
var state_37411__$1 = state_37411;
var statearr_37471_37539 = state_37411__$1;
(statearr_37471_37539[(2)] = inst_37340);

(statearr_37471_37539[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (5))){
var inst_37290 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_37291 = cljs.core.seq(inst_37290);
var inst_37292 = inst_37291;
var inst_37293 = null;
var inst_37294 = (0);
var inst_37295 = (0);
var state_37411__$1 = (function (){var statearr_37472 = state_37411;
(statearr_37472[(13)] = inst_37292);

(statearr_37472[(14)] = inst_37294);

(statearr_37472[(15)] = inst_37293);

(statearr_37472[(16)] = inst_37295);

return statearr_37472;
})();
var statearr_37473_37540 = state_37411__$1;
(statearr_37473_37540[(2)] = null);

(statearr_37473_37540[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (14))){
var state_37411__$1 = state_37411;
var statearr_37474_37541 = state_37411__$1;
(statearr_37474_37541[(2)] = null);

(statearr_37474_37541[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (45))){
var inst_37401 = (state_37411[(2)]);
var state_37411__$1 = state_37411;
var statearr_37475_37542 = state_37411__$1;
(statearr_37475_37542[(2)] = inst_37401);

(statearr_37475_37542[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (26))){
var inst_37343 = (state_37411[(29)]);
var inst_37397 = (state_37411[(2)]);
var inst_37398 = cljs.core.seq(inst_37343);
var state_37411__$1 = (function (){var statearr_37476 = state_37411;
(statearr_37476[(31)] = inst_37397);

return statearr_37476;
})();
if(inst_37398){
var statearr_37477_37543 = state_37411__$1;
(statearr_37477_37543[(1)] = (42));

} else {
var statearr_37478_37544 = state_37411__$1;
(statearr_37478_37544[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (16))){
var inst_37312 = (state_37411[(7)]);
var inst_37314 = cljs.core.chunked_seq_QMARK_(inst_37312);
var state_37411__$1 = state_37411;
if(inst_37314){
var statearr_37479_37545 = state_37411__$1;
(statearr_37479_37545[(1)] = (19));

} else {
var statearr_37480_37546 = state_37411__$1;
(statearr_37480_37546[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (38))){
var inst_37390 = (state_37411[(2)]);
var state_37411__$1 = state_37411;
var statearr_37481_37547 = state_37411__$1;
(statearr_37481_37547[(2)] = inst_37390);

(statearr_37481_37547[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (30))){
var state_37411__$1 = state_37411;
var statearr_37482_37548 = state_37411__$1;
(statearr_37482_37548[(2)] = null);

(statearr_37482_37548[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (10))){
var inst_37293 = (state_37411[(15)]);
var inst_37295 = (state_37411[(16)]);
var inst_37301 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_37293,inst_37295);
var inst_37302 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37301,(0),null);
var inst_37303 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37301,(1),null);
var state_37411__$1 = (function (){var statearr_37483 = state_37411;
(statearr_37483[(26)] = inst_37302);

return statearr_37483;
})();
if(cljs.core.truth_(inst_37303)){
var statearr_37484_37549 = state_37411__$1;
(statearr_37484_37549[(1)] = (13));

} else {
var statearr_37485_37550 = state_37411__$1;
(statearr_37485_37550[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (18))){
var inst_37336 = (state_37411[(2)]);
var state_37411__$1 = state_37411;
var statearr_37486_37551 = state_37411__$1;
(statearr_37486_37551[(2)] = inst_37336);

(statearr_37486_37551[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (42))){
var state_37411__$1 = state_37411;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37411__$1,(45),dchan);
} else {
if((state_val_37412 === (37))){
var inst_37283 = (state_37411[(9)]);
var inst_37370 = (state_37411[(25)]);
var inst_37379 = (state_37411[(23)]);
var inst_37379__$1 = cljs.core.first(inst_37370);
var inst_37380 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_37379__$1,inst_37283,done);
var state_37411__$1 = (function (){var statearr_37487 = state_37411;
(statearr_37487[(23)] = inst_37379__$1);

return statearr_37487;
})();
if(cljs.core.truth_(inst_37380)){
var statearr_37488_37552 = state_37411__$1;
(statearr_37488_37552[(1)] = (39));

} else {
var statearr_37489_37553 = state_37411__$1;
(statearr_37489_37553[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37412 === (8))){
var inst_37294 = (state_37411[(14)]);
var inst_37295 = (state_37411[(16)]);
var inst_37297 = (inst_37295 < inst_37294);
var inst_37298 = inst_37297;
var state_37411__$1 = state_37411;
if(cljs.core.truth_(inst_37298)){
var statearr_37490_37554 = state_37411__$1;
(statearr_37490_37554[(1)] = (10));

} else {
var statearr_37491_37555 = state_37411__$1;
(statearr_37491_37555[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___37501,cs,m,dchan,dctr,done))
;
return ((function (switch__9165__auto__,c__9230__auto___37501,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__9166__auto__ = null;
var cljs$core$async$mult_$_state_machine__9166__auto____0 = (function (){
var statearr_37495 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37495[(0)] = cljs$core$async$mult_$_state_machine__9166__auto__);

(statearr_37495[(1)] = (1));

return statearr_37495;
});
var cljs$core$async$mult_$_state_machine__9166__auto____1 = (function (state_37411){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__(state_37411);
if(cljs.core.keyword_identical_QMARK_(result__9168__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e37496){if((e37496 instanceof Object)){
var ex__9169__auto__ = e37496;
var statearr_37497_37556 = state_37411;
(statearr_37497_37556[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37411);

return cljs.core.cst$kw$recur;
} else {
throw e37496;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__9167__auto__,cljs.core.cst$kw$recur)){
var G__37557 = state_37411;
state_37411 = G__37557;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__9166__auto__ = function(state_37411){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__9166__auto____1.call(this,state_37411);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__9166__auto____0;
cljs$core$async$mult_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__9166__auto____1;
return cljs$core$async$mult_$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___37501,cs,m,dchan,dctr,done))
})();
var state__9232__auto__ = (function (){var statearr_37498 = (f__9231__auto__.cljs$core$IFn$_invoke$arity$0 ? f__9231__auto__.cljs$core$IFn$_invoke$arity$0() : f__9231__auto__.call(null));
(statearr_37498[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___37501);

return statearr_37498;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__9232__auto__);
});})(c__9230__auto___37501,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args37558 = [];
var len__5627__auto___37561 = arguments.length;
var i__5628__auto___37562 = (0);
while(true){
if((i__5628__auto___37562 < len__5627__auto___37561)){
args37558.push((arguments[i__5628__auto___37562]));

var G__37563 = (i__5628__auto___37562 + (1));
i__5628__auto___37562 = G__37563;
continue;
} else {
}
break;
}

var G__37560 = args37558.length;
switch (G__37560) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37558.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto__.call(null,m,ch));
} else {
var m__5225__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto__.call(null,m,ch));
} else {
var m__5225__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5225__auto__.call(null,m));
} else {
var m__5225__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__5225__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5225__auto__.call(null,m,state_map));
} else {
var m__5225__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5225__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5225__auto__.call(null,m,mode));
} else {
var m__5225__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5225__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___37575 = arguments.length;
var i__5628__auto___37576 = (0);
while(true){
if((i__5628__auto___37576 < len__5627__auto___37575)){
args__5634__auto__.push((arguments[i__5628__auto___37576]));

var G__37577 = (i__5628__auto___37576 + (1));
i__5628__auto___37576 = G__37577;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((3) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5635__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__37569){
var map__37570 = p__37569;
var map__37570__$1 = ((((!((map__37570 == null)))?((((map__37570.cljs$lang$protocol_mask$partition0$ & (64))) || (map__37570.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37570):map__37570);
var opts = map__37570__$1;
var statearr_37572_37578 = state;
(statearr_37572_37578[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts(((function (map__37570,map__37570__$1,opts){
return (function (val){
var statearr_37573_37579 = state;
(statearr_37573_37579[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__37570,map__37570__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_37574_37580 = state;
(statearr_37574_37580[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq37565){
var G__37566 = cljs.core.first(seq37565);
var seq37565__$1 = cljs.core.next(seq37565);
var G__37567 = cljs.core.first(seq37565__$1);
var seq37565__$2 = cljs.core.next(seq37565__$1);
var G__37568 = cljs.core.first(seq37565__$2);
var seq37565__$3 = cljs.core.next(seq37565__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__37566,G__37567,G__37568,seq37565__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__37747 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__37747) : cljs.core.atom.call(null,G__37747));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute) : cljs.core.atom.call(null,cljs.core.cst$kw$mute));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async37748 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37748 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta37749){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta37749 = meta37749;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async37748.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_37750,meta37749__$1){
var self__ = this;
var _37750__$1 = this;
return (new cljs.core.async.t_cljs$core$async37748(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta37749__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37748.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_37750){
var self__ = this;
var _37750__$1 = this;
return self__.meta37749;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37748.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async37748.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37748.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async37748.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37748.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37748.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__37751_37913 = self__.cs;
var G__37752_37914 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__37751_37913,G__37752_37914) : cljs.core.reset_BANG_.call(null,G__37751_37913,G__37752_37914));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37748.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37748.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$mode)], 0)))].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37748.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.with_meta(cljs.core.cst$sym$mix,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out], null))),cljs.core.cst$kw$doc,"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta37749], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37748.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async37748.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37748";

cljs.core.async.t_cljs$core$async37748.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async37748");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async37748 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async37748(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta37749){
return (new cljs.core.async.t_cljs$core$async37748(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta37749));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async37748(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__9230__auto___37915 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__9230__auto___37915,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___37915,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_37850){
var state_val_37851 = (state_37850[(1)]);
if((state_val_37851 === (7))){
var inst_37768 = (state_37850[(2)]);
var state_37850__$1 = state_37850;
var statearr_37852_37916 = state_37850__$1;
(statearr_37852_37916[(2)] = inst_37768);

(statearr_37852_37916[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (20))){
var inst_37780 = (state_37850[(7)]);
var state_37850__$1 = state_37850;
var statearr_37853_37917 = state_37850__$1;
(statearr_37853_37917[(2)] = inst_37780);

(statearr_37853_37917[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (27))){
var state_37850__$1 = state_37850;
var statearr_37854_37918 = state_37850__$1;
(statearr_37854_37918[(2)] = null);

(statearr_37854_37918[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (1))){
var inst_37756 = (state_37850[(8)]);
var inst_37756__$1 = calc_state();
var inst_37758 = (inst_37756__$1 == null);
var inst_37759 = cljs.core.not(inst_37758);
var state_37850__$1 = (function (){var statearr_37855 = state_37850;
(statearr_37855[(8)] = inst_37756__$1);

return statearr_37855;
})();
if(inst_37759){
var statearr_37856_37919 = state_37850__$1;
(statearr_37856_37919[(1)] = (2));

} else {
var statearr_37857_37920 = state_37850__$1;
(statearr_37857_37920[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (24))){
var inst_37810 = (state_37850[(9)]);
var inst_37824 = (state_37850[(10)]);
var inst_37803 = (state_37850[(11)]);
var inst_37824__$1 = (inst_37803.cljs$core$IFn$_invoke$arity$1 ? inst_37803.cljs$core$IFn$_invoke$arity$1(inst_37810) : inst_37803.call(null,inst_37810));
var state_37850__$1 = (function (){var statearr_37858 = state_37850;
(statearr_37858[(10)] = inst_37824__$1);

return statearr_37858;
})();
if(cljs.core.truth_(inst_37824__$1)){
var statearr_37859_37921 = state_37850__$1;
(statearr_37859_37921[(1)] = (29));

} else {
var statearr_37860_37922 = state_37850__$1;
(statearr_37860_37922[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (4))){
var inst_37771 = (state_37850[(2)]);
var state_37850__$1 = state_37850;
if(cljs.core.truth_(inst_37771)){
var statearr_37861_37923 = state_37850__$1;
(statearr_37861_37923[(1)] = (8));

} else {
var statearr_37862_37924 = state_37850__$1;
(statearr_37862_37924[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (15))){
var inst_37797 = (state_37850[(2)]);
var state_37850__$1 = state_37850;
if(cljs.core.truth_(inst_37797)){
var statearr_37863_37925 = state_37850__$1;
(statearr_37863_37925[(1)] = (19));

} else {
var statearr_37864_37926 = state_37850__$1;
(statearr_37864_37926[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (21))){
var inst_37802 = (state_37850[(12)]);
var inst_37802__$1 = (state_37850[(2)]);
var inst_37803 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37802__$1,cljs.core.cst$kw$solos);
var inst_37804 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37802__$1,cljs.core.cst$kw$mutes);
var inst_37805 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37802__$1,cljs.core.cst$kw$reads);
var state_37850__$1 = (function (){var statearr_37865 = state_37850;
(statearr_37865[(12)] = inst_37802__$1);

(statearr_37865[(13)] = inst_37804);

(statearr_37865[(11)] = inst_37803);

return statearr_37865;
})();
return cljs.core.async.ioc_alts_BANG_(state_37850__$1,(22),inst_37805);
} else {
if((state_val_37851 === (31))){
var inst_37832 = (state_37850[(2)]);
var state_37850__$1 = state_37850;
if(cljs.core.truth_(inst_37832)){
var statearr_37866_37927 = state_37850__$1;
(statearr_37866_37927[(1)] = (32));

} else {
var statearr_37867_37928 = state_37850__$1;
(statearr_37867_37928[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (32))){
var inst_37809 = (state_37850[(14)]);
var state_37850__$1 = state_37850;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37850__$1,(35),out,inst_37809);
} else {
if((state_val_37851 === (33))){
var inst_37802 = (state_37850[(12)]);
var inst_37780 = inst_37802;
var state_37850__$1 = (function (){var statearr_37868 = state_37850;
(statearr_37868[(7)] = inst_37780);

return statearr_37868;
})();
var statearr_37869_37929 = state_37850__$1;
(statearr_37869_37929[(2)] = null);

(statearr_37869_37929[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (13))){
var inst_37780 = (state_37850[(7)]);
var inst_37787 = inst_37780.cljs$lang$protocol_mask$partition0$;
var inst_37788 = (inst_37787 & (64));
var inst_37789 = inst_37780.cljs$core$ISeq$;
var inst_37790 = (inst_37788) || (inst_37789);
var state_37850__$1 = state_37850;
if(cljs.core.truth_(inst_37790)){
var statearr_37870_37930 = state_37850__$1;
(statearr_37870_37930[(1)] = (16));

} else {
var statearr_37871_37931 = state_37850__$1;
(statearr_37871_37931[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (22))){
var inst_37809 = (state_37850[(14)]);
var inst_37810 = (state_37850[(9)]);
var inst_37808 = (state_37850[(2)]);
var inst_37809__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37808,(0),null);
var inst_37810__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37808,(1),null);
var inst_37811 = (inst_37809__$1 == null);
var inst_37812 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_37810__$1,change);
var inst_37813 = (inst_37811) || (inst_37812);
var state_37850__$1 = (function (){var statearr_37872 = state_37850;
(statearr_37872[(14)] = inst_37809__$1);

(statearr_37872[(9)] = inst_37810__$1);

return statearr_37872;
})();
if(cljs.core.truth_(inst_37813)){
var statearr_37873_37932 = state_37850__$1;
(statearr_37873_37932[(1)] = (23));

} else {
var statearr_37874_37933 = state_37850__$1;
(statearr_37874_37933[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (36))){
var inst_37802 = (state_37850[(12)]);
var inst_37780 = inst_37802;
var state_37850__$1 = (function (){var statearr_37875 = state_37850;
(statearr_37875[(7)] = inst_37780);

return statearr_37875;
})();
var statearr_37876_37934 = state_37850__$1;
(statearr_37876_37934[(2)] = null);

(statearr_37876_37934[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (29))){
var inst_37824 = (state_37850[(10)]);
var state_37850__$1 = state_37850;
var statearr_37877_37935 = state_37850__$1;
(statearr_37877_37935[(2)] = inst_37824);

(statearr_37877_37935[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (6))){
var state_37850__$1 = state_37850;
var statearr_37878_37936 = state_37850__$1;
(statearr_37878_37936[(2)] = false);

(statearr_37878_37936[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (28))){
var inst_37820 = (state_37850[(2)]);
var inst_37821 = calc_state();
var inst_37780 = inst_37821;
var state_37850__$1 = (function (){var statearr_37879 = state_37850;
(statearr_37879[(15)] = inst_37820);

(statearr_37879[(7)] = inst_37780);

return statearr_37879;
})();
var statearr_37880_37937 = state_37850__$1;
(statearr_37880_37937[(2)] = null);

(statearr_37880_37937[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (25))){
var inst_37846 = (state_37850[(2)]);
var state_37850__$1 = state_37850;
var statearr_37881_37938 = state_37850__$1;
(statearr_37881_37938[(2)] = inst_37846);

(statearr_37881_37938[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (34))){
var inst_37844 = (state_37850[(2)]);
var state_37850__$1 = state_37850;
var statearr_37882_37939 = state_37850__$1;
(statearr_37882_37939[(2)] = inst_37844);

(statearr_37882_37939[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (17))){
var state_37850__$1 = state_37850;
var statearr_37883_37940 = state_37850__$1;
(statearr_37883_37940[(2)] = false);

(statearr_37883_37940[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (3))){
var state_37850__$1 = state_37850;
var statearr_37884_37941 = state_37850__$1;
(statearr_37884_37941[(2)] = false);

(statearr_37884_37941[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (12))){
var inst_37848 = (state_37850[(2)]);
var state_37850__$1 = state_37850;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37850__$1,inst_37848);
} else {
if((state_val_37851 === (2))){
var inst_37756 = (state_37850[(8)]);
var inst_37761 = inst_37756.cljs$lang$protocol_mask$partition0$;
var inst_37762 = (inst_37761 & (64));
var inst_37763 = inst_37756.cljs$core$ISeq$;
var inst_37764 = (inst_37762) || (inst_37763);
var state_37850__$1 = state_37850;
if(cljs.core.truth_(inst_37764)){
var statearr_37885_37942 = state_37850__$1;
(statearr_37885_37942[(1)] = (5));

} else {
var statearr_37886_37943 = state_37850__$1;
(statearr_37886_37943[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (23))){
var inst_37809 = (state_37850[(14)]);
var inst_37815 = (inst_37809 == null);
var state_37850__$1 = state_37850;
if(cljs.core.truth_(inst_37815)){
var statearr_37887_37944 = state_37850__$1;
(statearr_37887_37944[(1)] = (26));

} else {
var statearr_37888_37945 = state_37850__$1;
(statearr_37888_37945[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (35))){
var inst_37835 = (state_37850[(2)]);
var state_37850__$1 = state_37850;
if(cljs.core.truth_(inst_37835)){
var statearr_37889_37946 = state_37850__$1;
(statearr_37889_37946[(1)] = (36));

} else {
var statearr_37890_37947 = state_37850__$1;
(statearr_37890_37947[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (19))){
var inst_37780 = (state_37850[(7)]);
var inst_37799 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37780);
var state_37850__$1 = state_37850;
var statearr_37891_37948 = state_37850__$1;
(statearr_37891_37948[(2)] = inst_37799);

(statearr_37891_37948[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (11))){
var inst_37780 = (state_37850[(7)]);
var inst_37784 = (inst_37780 == null);
var inst_37785 = cljs.core.not(inst_37784);
var state_37850__$1 = state_37850;
if(inst_37785){
var statearr_37892_37949 = state_37850__$1;
(statearr_37892_37949[(1)] = (13));

} else {
var statearr_37893_37950 = state_37850__$1;
(statearr_37893_37950[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (9))){
var inst_37756 = (state_37850[(8)]);
var state_37850__$1 = state_37850;
var statearr_37894_37951 = state_37850__$1;
(statearr_37894_37951[(2)] = inst_37756);

(statearr_37894_37951[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (5))){
var state_37850__$1 = state_37850;
var statearr_37895_37952 = state_37850__$1;
(statearr_37895_37952[(2)] = true);

(statearr_37895_37952[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (14))){
var state_37850__$1 = state_37850;
var statearr_37896_37953 = state_37850__$1;
(statearr_37896_37953[(2)] = false);

(statearr_37896_37953[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (26))){
var inst_37810 = (state_37850[(9)]);
var inst_37817 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_37810);
var state_37850__$1 = state_37850;
var statearr_37897_37954 = state_37850__$1;
(statearr_37897_37954[(2)] = inst_37817);

(statearr_37897_37954[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (16))){
var state_37850__$1 = state_37850;
var statearr_37898_37955 = state_37850__$1;
(statearr_37898_37955[(2)] = true);

(statearr_37898_37955[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (38))){
var inst_37840 = (state_37850[(2)]);
var state_37850__$1 = state_37850;
var statearr_37899_37956 = state_37850__$1;
(statearr_37899_37956[(2)] = inst_37840);

(statearr_37899_37956[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (30))){
var inst_37810 = (state_37850[(9)]);
var inst_37804 = (state_37850[(13)]);
var inst_37803 = (state_37850[(11)]);
var inst_37827 = cljs.core.empty_QMARK_(inst_37803);
var inst_37828 = (inst_37804.cljs$core$IFn$_invoke$arity$1 ? inst_37804.cljs$core$IFn$_invoke$arity$1(inst_37810) : inst_37804.call(null,inst_37810));
var inst_37829 = cljs.core.not(inst_37828);
var inst_37830 = (inst_37827) && (inst_37829);
var state_37850__$1 = state_37850;
var statearr_37900_37957 = state_37850__$1;
(statearr_37900_37957[(2)] = inst_37830);

(statearr_37900_37957[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (10))){
var inst_37756 = (state_37850[(8)]);
var inst_37776 = (state_37850[(2)]);
var inst_37777 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37776,cljs.core.cst$kw$solos);
var inst_37778 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37776,cljs.core.cst$kw$mutes);
var inst_37779 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37776,cljs.core.cst$kw$reads);
var inst_37780 = inst_37756;
var state_37850__$1 = (function (){var statearr_37901 = state_37850;
(statearr_37901[(16)] = inst_37779);

(statearr_37901[(17)] = inst_37778);

(statearr_37901[(18)] = inst_37777);

(statearr_37901[(7)] = inst_37780);

return statearr_37901;
})();
var statearr_37902_37958 = state_37850__$1;
(statearr_37902_37958[(2)] = null);

(statearr_37902_37958[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (18))){
var inst_37794 = (state_37850[(2)]);
var state_37850__$1 = state_37850;
var statearr_37903_37959 = state_37850__$1;
(statearr_37903_37959[(2)] = inst_37794);

(statearr_37903_37959[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (37))){
var state_37850__$1 = state_37850;
var statearr_37904_37960 = state_37850__$1;
(statearr_37904_37960[(2)] = null);

(statearr_37904_37960[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37851 === (8))){
var inst_37756 = (state_37850[(8)]);
var inst_37773 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37756);
var state_37850__$1 = state_37850;
var statearr_37905_37961 = state_37850__$1;
(statearr_37905_37961[(2)] = inst_37773);

(statearr_37905_37961[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___37915,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__9165__auto__,c__9230__auto___37915,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__9166__auto__ = null;
var cljs$core$async$mix_$_state_machine__9166__auto____0 = (function (){
var statearr_37909 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37909[(0)] = cljs$core$async$mix_$_state_machine__9166__auto__);

(statearr_37909[(1)] = (1));

return statearr_37909;
});
var cljs$core$async$mix_$_state_machine__9166__auto____1 = (function (state_37850){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__(state_37850);
if(cljs.core.keyword_identical_QMARK_(result__9168__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e37910){if((e37910 instanceof Object)){
var ex__9169__auto__ = e37910;
var statearr_37911_37962 = state_37850;
(statearr_37911_37962[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37850);

return cljs.core.cst$kw$recur;
} else {
throw e37910;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__9167__auto__,cljs.core.cst$kw$recur)){
var G__37963 = state_37850;
state_37850 = G__37963;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__9166__auto__ = function(state_37850){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__9166__auto____1.call(this,state_37850);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__9166__auto____0;
cljs$core$async$mix_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__9166__auto____1;
return cljs$core$async$mix_$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___37915,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__9232__auto__ = (function (){var statearr_37912 = (f__9231__auto__.cljs$core$IFn$_invoke$arity$0 ? f__9231__auto__.cljs$core$IFn$_invoke$arity$0() : f__9231__auto__.call(null));
(statearr_37912[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___37915);

return statearr_37912;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__9232__auto__);
});})(c__9230__auto___37915,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5225__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__5225__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5225__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5225__auto__.call(null,p,v,ch));
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5225__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args37964 = [];
var len__5627__auto___37967 = arguments.length;
var i__5628__auto___37968 = (0);
while(true){
if((i__5628__auto___37968 < len__5627__auto___37967)){
args37964.push((arguments[i__5628__auto___37968]));

var G__37969 = (i__5628__auto___37968 + (1));
i__5628__auto___37968 = G__37969;
continue;
} else {
}
break;
}

var G__37966 = args37964.length;
switch (G__37966) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37964.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5225__auto__.call(null,p));
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__5225__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5225__auto__.call(null,p,v));
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__5225__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args37972 = [];
var len__5627__auto___38100 = arguments.length;
var i__5628__auto___38101 = (0);
while(true){
if((i__5628__auto___38101 < len__5627__auto___38100)){
args37972.push((arguments[i__5628__auto___38101]));

var G__38102 = (i__5628__auto___38101 + (1));
i__5628__auto___38101 = G__38102;
continue;
} else {
}
break;
}

var G__37974 = args37972.length;
switch (G__37974) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37972.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__37975 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__37975) : cljs.core.atom.call(null,G__37975));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__4569__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__4569__auto__,mults){
return (function (p1__37971_SHARP_){
if(cljs.core.truth_((p1__37971_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__37971_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__37971_SHARP_.call(null,topic)))){
return p1__37971_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__37971_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__4569__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async37976 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37976 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta37977){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta37977 = meta37977;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async37976.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_37978,meta37977__$1){
var self__ = this;
var _37978__$1 = this;
return (new cljs.core.async.t_cljs$core$async37976(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta37977__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37976.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_37978){
var self__ = this;
var _37978__$1 = this;
return self__.meta37977;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37976.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async37976.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37976.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async37976.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37976.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37976.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__37979 = self__.mults;
var G__37980 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__37979,G__37980) : cljs.core.reset_BANG_.call(null,G__37979,G__37980));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37976.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37976.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta37977], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37976.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async37976.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37976";

cljs.core.async.t_cljs$core$async37976.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async37976");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async37976 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async37976(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta37977){
return (new cljs.core.async.t_cljs$core$async37976(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta37977));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async37976(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__9230__auto___38104 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__9230__auto___38104,mults,ensure_mult,p){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___38104,mults,ensure_mult,p){
return (function (state_38052){
var state_val_38053 = (state_38052[(1)]);
if((state_val_38053 === (7))){
var inst_38048 = (state_38052[(2)]);
var state_38052__$1 = state_38052;
var statearr_38054_38105 = state_38052__$1;
(statearr_38054_38105[(2)] = inst_38048);

(statearr_38054_38105[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38053 === (20))){
var state_38052__$1 = state_38052;
var statearr_38055_38106 = state_38052__$1;
(statearr_38055_38106[(2)] = null);

(statearr_38055_38106[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38053 === (1))){
var state_38052__$1 = state_38052;
var statearr_38056_38107 = state_38052__$1;
(statearr_38056_38107[(2)] = null);

(statearr_38056_38107[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38053 === (24))){
var inst_38031 = (state_38052[(7)]);
var inst_38040 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_38031);
var state_38052__$1 = state_38052;
var statearr_38057_38108 = state_38052__$1;
(statearr_38057_38108[(2)] = inst_38040);

(statearr_38057_38108[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38053 === (4))){
var inst_37983 = (state_38052[(8)]);
var inst_37983__$1 = (state_38052[(2)]);
var inst_37984 = (inst_37983__$1 == null);
var state_38052__$1 = (function (){var statearr_38058 = state_38052;
(statearr_38058[(8)] = inst_37983__$1);

return statearr_38058;
})();
if(cljs.core.truth_(inst_37984)){
var statearr_38059_38109 = state_38052__$1;
(statearr_38059_38109[(1)] = (5));

} else {
var statearr_38060_38110 = state_38052__$1;
(statearr_38060_38110[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38053 === (15))){
var inst_38025 = (state_38052[(2)]);
var state_38052__$1 = state_38052;
var statearr_38061_38111 = state_38052__$1;
(statearr_38061_38111[(2)] = inst_38025);

(statearr_38061_38111[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38053 === (21))){
var inst_38045 = (state_38052[(2)]);
var state_38052__$1 = (function (){var statearr_38062 = state_38052;
(statearr_38062[(9)] = inst_38045);

return statearr_38062;
})();
var statearr_38063_38112 = state_38052__$1;
(statearr_38063_38112[(2)] = null);

(statearr_38063_38112[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38053 === (13))){
var inst_38007 = (state_38052[(10)]);
var inst_38009 = cljs.core.chunked_seq_QMARK_(inst_38007);
var state_38052__$1 = state_38052;
if(inst_38009){
var statearr_38064_38113 = state_38052__$1;
(statearr_38064_38113[(1)] = (16));

} else {
var statearr_38065_38114 = state_38052__$1;
(statearr_38065_38114[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38053 === (22))){
var inst_38037 = (state_38052[(2)]);
var state_38052__$1 = state_38052;
if(cljs.core.truth_(inst_38037)){
var statearr_38066_38115 = state_38052__$1;
(statearr_38066_38115[(1)] = (23));

} else {
var statearr_38067_38116 = state_38052__$1;
(statearr_38067_38116[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38053 === (6))){
var inst_37983 = (state_38052[(8)]);
var inst_38033 = (state_38052[(11)]);
var inst_38031 = (state_38052[(7)]);
var inst_38031__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_37983) : topic_fn.call(null,inst_37983));
var inst_38032 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_38033__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38032,inst_38031__$1);
var state_38052__$1 = (function (){var statearr_38068 = state_38052;
(statearr_38068[(11)] = inst_38033__$1);

(statearr_38068[(7)] = inst_38031__$1);

return statearr_38068;
})();
if(cljs.core.truth_(inst_38033__$1)){
var statearr_38069_38117 = state_38052__$1;
(statearr_38069_38117[(1)] = (19));

} else {
var statearr_38070_38118 = state_38052__$1;
(statearr_38070_38118[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38053 === (25))){
var inst_38042 = (state_38052[(2)]);
var state_38052__$1 = state_38052;
var statearr_38071_38119 = state_38052__$1;
(statearr_38071_38119[(2)] = inst_38042);

(statearr_38071_38119[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38053 === (17))){
var inst_38007 = (state_38052[(10)]);
var inst_38016 = cljs.core.first(inst_38007);
var inst_38017 = cljs.core.async.muxch_STAR_(inst_38016);
var inst_38018 = cljs.core.async.close_BANG_(inst_38017);
var inst_38019 = cljs.core.next(inst_38007);
var inst_37993 = inst_38019;
var inst_37994 = null;
var inst_37995 = (0);
var inst_37996 = (0);
var state_38052__$1 = (function (){var statearr_38072 = state_38052;
(statearr_38072[(12)] = inst_37995);

(statearr_38072[(13)] = inst_38018);

(statearr_38072[(14)] = inst_37996);

(statearr_38072[(15)] = inst_37993);

(statearr_38072[(16)] = inst_37994);

return statearr_38072;
})();
var statearr_38073_38120 = state_38052__$1;
(statearr_38073_38120[(2)] = null);

(statearr_38073_38120[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38053 === (3))){
var inst_38050 = (state_38052[(2)]);
var state_38052__$1 = state_38052;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38052__$1,inst_38050);
} else {
if((state_val_38053 === (12))){
var inst_38027 = (state_38052[(2)]);
var state_38052__$1 = state_38052;
var statearr_38074_38121 = state_38052__$1;
(statearr_38074_38121[(2)] = inst_38027);

(statearr_38074_38121[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38053 === (2))){
var state_38052__$1 = state_38052;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38052__$1,(4),ch);
} else {
if((state_val_38053 === (23))){
var state_38052__$1 = state_38052;
var statearr_38075_38122 = state_38052__$1;
(statearr_38075_38122[(2)] = null);

(statearr_38075_38122[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38053 === (19))){
var inst_37983 = (state_38052[(8)]);
var inst_38033 = (state_38052[(11)]);
var inst_38035 = cljs.core.async.muxch_STAR_(inst_38033);
var state_38052__$1 = state_38052;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38052__$1,(22),inst_38035,inst_37983);
} else {
if((state_val_38053 === (11))){
var inst_37993 = (state_38052[(15)]);
var inst_38007 = (state_38052[(10)]);
var inst_38007__$1 = cljs.core.seq(inst_37993);
var state_38052__$1 = (function (){var statearr_38076 = state_38052;
(statearr_38076[(10)] = inst_38007__$1);

return statearr_38076;
})();
if(inst_38007__$1){
var statearr_38077_38123 = state_38052__$1;
(statearr_38077_38123[(1)] = (13));

} else {
var statearr_38078_38124 = state_38052__$1;
(statearr_38078_38124[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38053 === (9))){
var inst_38029 = (state_38052[(2)]);
var state_38052__$1 = state_38052;
var statearr_38079_38125 = state_38052__$1;
(statearr_38079_38125[(2)] = inst_38029);

(statearr_38079_38125[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38053 === (5))){
var inst_37990 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_37991 = cljs.core.vals(inst_37990);
var inst_37992 = cljs.core.seq(inst_37991);
var inst_37993 = inst_37992;
var inst_37994 = null;
var inst_37995 = (0);
var inst_37996 = (0);
var state_38052__$1 = (function (){var statearr_38080 = state_38052;
(statearr_38080[(12)] = inst_37995);

(statearr_38080[(14)] = inst_37996);

(statearr_38080[(15)] = inst_37993);

(statearr_38080[(16)] = inst_37994);

return statearr_38080;
})();
var statearr_38081_38126 = state_38052__$1;
(statearr_38081_38126[(2)] = null);

(statearr_38081_38126[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38053 === (14))){
var state_38052__$1 = state_38052;
var statearr_38085_38127 = state_38052__$1;
(statearr_38085_38127[(2)] = null);

(statearr_38085_38127[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38053 === (16))){
var inst_38007 = (state_38052[(10)]);
var inst_38011 = cljs.core.chunk_first(inst_38007);
var inst_38012 = cljs.core.chunk_rest(inst_38007);
var inst_38013 = cljs.core.count(inst_38011);
var inst_37993 = inst_38012;
var inst_37994 = inst_38011;
var inst_37995 = inst_38013;
var inst_37996 = (0);
var state_38052__$1 = (function (){var statearr_38086 = state_38052;
(statearr_38086[(12)] = inst_37995);

(statearr_38086[(14)] = inst_37996);

(statearr_38086[(15)] = inst_37993);

(statearr_38086[(16)] = inst_37994);

return statearr_38086;
})();
var statearr_38087_38128 = state_38052__$1;
(statearr_38087_38128[(2)] = null);

(statearr_38087_38128[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38053 === (10))){
var inst_37995 = (state_38052[(12)]);
var inst_37996 = (state_38052[(14)]);
var inst_37993 = (state_38052[(15)]);
var inst_37994 = (state_38052[(16)]);
var inst_38001 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_37994,inst_37996);
var inst_38002 = cljs.core.async.muxch_STAR_(inst_38001);
var inst_38003 = cljs.core.async.close_BANG_(inst_38002);
var inst_38004 = (inst_37996 + (1));
var tmp38082 = inst_37995;
var tmp38083 = inst_37993;
var tmp38084 = inst_37994;
var inst_37993__$1 = tmp38083;
var inst_37994__$1 = tmp38084;
var inst_37995__$1 = tmp38082;
var inst_37996__$1 = inst_38004;
var state_38052__$1 = (function (){var statearr_38088 = state_38052;
(statearr_38088[(12)] = inst_37995__$1);

(statearr_38088[(14)] = inst_37996__$1);

(statearr_38088[(17)] = inst_38003);

(statearr_38088[(15)] = inst_37993__$1);

(statearr_38088[(16)] = inst_37994__$1);

return statearr_38088;
})();
var statearr_38089_38129 = state_38052__$1;
(statearr_38089_38129[(2)] = null);

(statearr_38089_38129[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38053 === (18))){
var inst_38022 = (state_38052[(2)]);
var state_38052__$1 = state_38052;
var statearr_38090_38130 = state_38052__$1;
(statearr_38090_38130[(2)] = inst_38022);

(statearr_38090_38130[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38053 === (8))){
var inst_37995 = (state_38052[(12)]);
var inst_37996 = (state_38052[(14)]);
var inst_37998 = (inst_37996 < inst_37995);
var inst_37999 = inst_37998;
var state_38052__$1 = state_38052;
if(cljs.core.truth_(inst_37999)){
var statearr_38091_38131 = state_38052__$1;
(statearr_38091_38131[(1)] = (10));

} else {
var statearr_38092_38132 = state_38052__$1;
(statearr_38092_38132[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___38104,mults,ensure_mult,p))
;
return ((function (switch__9165__auto__,c__9230__auto___38104,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_38096 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38096[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_38096[(1)] = (1));

return statearr_38096;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_38052){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__(state_38052);
if(cljs.core.keyword_identical_QMARK_(result__9168__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e38097){if((e38097 instanceof Object)){
var ex__9169__auto__ = e38097;
var statearr_38098_38133 = state_38052;
(statearr_38098_38133[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38052);

return cljs.core.cst$kw$recur;
} else {
throw e38097;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__9167__auto__,cljs.core.cst$kw$recur)){
var G__38134 = state_38052;
state_38052 = G__38134;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_38052){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_38052);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___38104,mults,ensure_mult,p))
})();
var state__9232__auto__ = (function (){var statearr_38099 = (f__9231__auto__.cljs$core$IFn$_invoke$arity$0 ? f__9231__auto__.cljs$core$IFn$_invoke$arity$0() : f__9231__auto__.call(null));
(statearr_38099[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___38104);

return statearr_38099;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__9232__auto__);
});})(c__9230__auto___38104,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args38135 = [];
var len__5627__auto___38138 = arguments.length;
var i__5628__auto___38139 = (0);
while(true){
if((i__5628__auto___38139 < len__5627__auto___38138)){
args38135.push((arguments[i__5628__auto___38139]));

var G__38140 = (i__5628__auto___38139 + (1));
i__5628__auto___38139 = G__38140;
continue;
} else {
}
break;
}

var G__38137 = args38135.length;
switch (G__38137) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38135.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args38142 = [];
var len__5627__auto___38145 = arguments.length;
var i__5628__auto___38146 = (0);
while(true){
if((i__5628__auto___38146 < len__5627__auto___38145)){
args38142.push((arguments[i__5628__auto___38146]));

var G__38147 = (i__5628__auto___38146 + (1));
i__5628__auto___38146 = G__38147;
continue;
} else {
}
break;
}

var G__38144 = args38142.length;
switch (G__38144) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38142.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args38149 = [];
var len__5627__auto___38220 = arguments.length;
var i__5628__auto___38221 = (0);
while(true){
if((i__5628__auto___38221 < len__5627__auto___38220)){
args38149.push((arguments[i__5628__auto___38221]));

var G__38222 = (i__5628__auto___38221 + (1));
i__5628__auto___38221 = G__38222;
continue;
} else {
}
break;
}

var G__38151 = args38149.length;
switch (G__38151) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38149.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__9230__auto___38224 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__9230__auto___38224,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___38224,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_38190){
var state_val_38191 = (state_38190[(1)]);
if((state_val_38191 === (7))){
var state_38190__$1 = state_38190;
var statearr_38192_38225 = state_38190__$1;
(statearr_38192_38225[(2)] = null);

(statearr_38192_38225[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38191 === (1))){
var state_38190__$1 = state_38190;
var statearr_38193_38226 = state_38190__$1;
(statearr_38193_38226[(2)] = null);

(statearr_38193_38226[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38191 === (4))){
var inst_38154 = (state_38190[(7)]);
var inst_38156 = (inst_38154 < cnt);
var state_38190__$1 = state_38190;
if(cljs.core.truth_(inst_38156)){
var statearr_38194_38227 = state_38190__$1;
(statearr_38194_38227[(1)] = (6));

} else {
var statearr_38195_38228 = state_38190__$1;
(statearr_38195_38228[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38191 === (15))){
var inst_38186 = (state_38190[(2)]);
var state_38190__$1 = state_38190;
var statearr_38196_38229 = state_38190__$1;
(statearr_38196_38229[(2)] = inst_38186);

(statearr_38196_38229[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38191 === (13))){
var inst_38179 = cljs.core.async.close_BANG_(out);
var state_38190__$1 = state_38190;
var statearr_38197_38230 = state_38190__$1;
(statearr_38197_38230[(2)] = inst_38179);

(statearr_38197_38230[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38191 === (6))){
var state_38190__$1 = state_38190;
var statearr_38198_38231 = state_38190__$1;
(statearr_38198_38231[(2)] = null);

(statearr_38198_38231[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38191 === (3))){
var inst_38188 = (state_38190[(2)]);
var state_38190__$1 = state_38190;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38190__$1,inst_38188);
} else {
if((state_val_38191 === (12))){
var inst_38176 = (state_38190[(8)]);
var inst_38176__$1 = (state_38190[(2)]);
var inst_38177 = cljs.core.some(cljs.core.nil_QMARK_,inst_38176__$1);
var state_38190__$1 = (function (){var statearr_38199 = state_38190;
(statearr_38199[(8)] = inst_38176__$1);

return statearr_38199;
})();
if(cljs.core.truth_(inst_38177)){
var statearr_38200_38232 = state_38190__$1;
(statearr_38200_38232[(1)] = (13));

} else {
var statearr_38201_38233 = state_38190__$1;
(statearr_38201_38233[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38191 === (2))){
var inst_38153 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_38154 = (0);
var state_38190__$1 = (function (){var statearr_38202 = state_38190;
(statearr_38202[(9)] = inst_38153);

(statearr_38202[(7)] = inst_38154);

return statearr_38202;
})();
var statearr_38203_38234 = state_38190__$1;
(statearr_38203_38234[(2)] = null);

(statearr_38203_38234[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38191 === (11))){
var inst_38154 = (state_38190[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_38190,(10),Object,null,(9));
var inst_38163 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_38154) : chs__$1.call(null,inst_38154));
var inst_38164 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_38154) : done.call(null,inst_38154));
var inst_38165 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_38163,inst_38164);
var state_38190__$1 = state_38190;
var statearr_38204_38235 = state_38190__$1;
(statearr_38204_38235[(2)] = inst_38165);


cljs.core.async.impl.ioc_helpers.process_exception(state_38190__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_38191 === (9))){
var inst_38154 = (state_38190[(7)]);
var inst_38167 = (state_38190[(2)]);
var inst_38168 = (inst_38154 + (1));
var inst_38154__$1 = inst_38168;
var state_38190__$1 = (function (){var statearr_38205 = state_38190;
(statearr_38205[(10)] = inst_38167);

(statearr_38205[(7)] = inst_38154__$1);

return statearr_38205;
})();
var statearr_38206_38236 = state_38190__$1;
(statearr_38206_38236[(2)] = null);

(statearr_38206_38236[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38191 === (5))){
var inst_38174 = (state_38190[(2)]);
var state_38190__$1 = (function (){var statearr_38207 = state_38190;
(statearr_38207[(11)] = inst_38174);

return statearr_38207;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38190__$1,(12),dchan);
} else {
if((state_val_38191 === (14))){
var inst_38176 = (state_38190[(8)]);
var inst_38181 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_38176);
var state_38190__$1 = state_38190;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38190__$1,(16),out,inst_38181);
} else {
if((state_val_38191 === (16))){
var inst_38183 = (state_38190[(2)]);
var state_38190__$1 = (function (){var statearr_38208 = state_38190;
(statearr_38208[(12)] = inst_38183);

return statearr_38208;
})();
var statearr_38209_38237 = state_38190__$1;
(statearr_38209_38237[(2)] = null);

(statearr_38209_38237[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38191 === (10))){
var inst_38158 = (state_38190[(2)]);
var inst_38159 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_38190__$1 = (function (){var statearr_38210 = state_38190;
(statearr_38210[(13)] = inst_38158);

return statearr_38210;
})();
var statearr_38211_38238 = state_38190__$1;
(statearr_38211_38238[(2)] = inst_38159);


cljs.core.async.impl.ioc_helpers.process_exception(state_38190__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_38191 === (8))){
var inst_38172 = (state_38190[(2)]);
var state_38190__$1 = state_38190;
var statearr_38212_38239 = state_38190__$1;
(statearr_38212_38239[(2)] = inst_38172);

(statearr_38212_38239[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___38224,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__9165__auto__,c__9230__auto___38224,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_38216 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38216[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_38216[(1)] = (1));

return statearr_38216;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_38190){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__(state_38190);
if(cljs.core.keyword_identical_QMARK_(result__9168__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e38217){if((e38217 instanceof Object)){
var ex__9169__auto__ = e38217;
var statearr_38218_38240 = state_38190;
(statearr_38218_38240[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38190);

return cljs.core.cst$kw$recur;
} else {
throw e38217;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__9167__auto__,cljs.core.cst$kw$recur)){
var G__38241 = state_38190;
state_38190 = G__38241;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_38190){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_38190);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___38224,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__9232__auto__ = (function (){var statearr_38219 = (f__9231__auto__.cljs$core$IFn$_invoke$arity$0 ? f__9231__auto__.cljs$core$IFn$_invoke$arity$0() : f__9231__auto__.call(null));
(statearr_38219[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___38224);

return statearr_38219;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__9232__auto__);
});})(c__9230__auto___38224,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args38243 = [];
var len__5627__auto___38299 = arguments.length;
var i__5628__auto___38300 = (0);
while(true){
if((i__5628__auto___38300 < len__5627__auto___38299)){
args38243.push((arguments[i__5628__auto___38300]));

var G__38301 = (i__5628__auto___38300 + (1));
i__5628__auto___38300 = G__38301;
continue;
} else {
}
break;
}

var G__38245 = args38243.length;
switch (G__38245) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38243.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__9230__auto___38303 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__9230__auto___38303,out){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___38303,out){
return (function (state_38275){
var state_val_38276 = (state_38275[(1)]);
if((state_val_38276 === (7))){
var inst_38254 = (state_38275[(7)]);
var inst_38255 = (state_38275[(8)]);
var inst_38254__$1 = (state_38275[(2)]);
var inst_38255__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38254__$1,(0),null);
var inst_38256 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38254__$1,(1),null);
var inst_38257 = (inst_38255__$1 == null);
var state_38275__$1 = (function (){var statearr_38277 = state_38275;
(statearr_38277[(9)] = inst_38256);

(statearr_38277[(7)] = inst_38254__$1);

(statearr_38277[(8)] = inst_38255__$1);

return statearr_38277;
})();
if(cljs.core.truth_(inst_38257)){
var statearr_38278_38304 = state_38275__$1;
(statearr_38278_38304[(1)] = (8));

} else {
var statearr_38279_38305 = state_38275__$1;
(statearr_38279_38305[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38276 === (1))){
var inst_38246 = cljs.core.vec(chs);
var inst_38247 = inst_38246;
var state_38275__$1 = (function (){var statearr_38280 = state_38275;
(statearr_38280[(10)] = inst_38247);

return statearr_38280;
})();
var statearr_38281_38306 = state_38275__$1;
(statearr_38281_38306[(2)] = null);

(statearr_38281_38306[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38276 === (4))){
var inst_38247 = (state_38275[(10)]);
var state_38275__$1 = state_38275;
return cljs.core.async.ioc_alts_BANG_(state_38275__$1,(7),inst_38247);
} else {
if((state_val_38276 === (6))){
var inst_38271 = (state_38275[(2)]);
var state_38275__$1 = state_38275;
var statearr_38282_38307 = state_38275__$1;
(statearr_38282_38307[(2)] = inst_38271);

(statearr_38282_38307[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38276 === (3))){
var inst_38273 = (state_38275[(2)]);
var state_38275__$1 = state_38275;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38275__$1,inst_38273);
} else {
if((state_val_38276 === (2))){
var inst_38247 = (state_38275[(10)]);
var inst_38249 = cljs.core.count(inst_38247);
var inst_38250 = (inst_38249 > (0));
var state_38275__$1 = state_38275;
if(cljs.core.truth_(inst_38250)){
var statearr_38284_38308 = state_38275__$1;
(statearr_38284_38308[(1)] = (4));

} else {
var statearr_38285_38309 = state_38275__$1;
(statearr_38285_38309[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38276 === (11))){
var inst_38247 = (state_38275[(10)]);
var inst_38264 = (state_38275[(2)]);
var tmp38283 = inst_38247;
var inst_38247__$1 = tmp38283;
var state_38275__$1 = (function (){var statearr_38286 = state_38275;
(statearr_38286[(11)] = inst_38264);

(statearr_38286[(10)] = inst_38247__$1);

return statearr_38286;
})();
var statearr_38287_38310 = state_38275__$1;
(statearr_38287_38310[(2)] = null);

(statearr_38287_38310[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38276 === (9))){
var inst_38255 = (state_38275[(8)]);
var state_38275__$1 = state_38275;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38275__$1,(11),out,inst_38255);
} else {
if((state_val_38276 === (5))){
var inst_38269 = cljs.core.async.close_BANG_(out);
var state_38275__$1 = state_38275;
var statearr_38288_38311 = state_38275__$1;
(statearr_38288_38311[(2)] = inst_38269);

(statearr_38288_38311[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38276 === (10))){
var inst_38267 = (state_38275[(2)]);
var state_38275__$1 = state_38275;
var statearr_38289_38312 = state_38275__$1;
(statearr_38289_38312[(2)] = inst_38267);

(statearr_38289_38312[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38276 === (8))){
var inst_38247 = (state_38275[(10)]);
var inst_38256 = (state_38275[(9)]);
var inst_38254 = (state_38275[(7)]);
var inst_38255 = (state_38275[(8)]);
var inst_38259 = (function (){var cs = inst_38247;
var vec__38252 = inst_38254;
var v = inst_38255;
var c = inst_38256;
return ((function (cs,vec__38252,v,c,inst_38247,inst_38256,inst_38254,inst_38255,state_val_38276,c__9230__auto___38303,out){
return (function (p1__38242_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__38242_SHARP_);
});
;})(cs,vec__38252,v,c,inst_38247,inst_38256,inst_38254,inst_38255,state_val_38276,c__9230__auto___38303,out))
})();
var inst_38260 = cljs.core.filterv(inst_38259,inst_38247);
var inst_38247__$1 = inst_38260;
var state_38275__$1 = (function (){var statearr_38290 = state_38275;
(statearr_38290[(10)] = inst_38247__$1);

return statearr_38290;
})();
var statearr_38291_38313 = state_38275__$1;
(statearr_38291_38313[(2)] = null);

(statearr_38291_38313[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___38303,out))
;
return ((function (switch__9165__auto__,c__9230__auto___38303,out){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_38295 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38295[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_38295[(1)] = (1));

return statearr_38295;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_38275){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__(state_38275);
if(cljs.core.keyword_identical_QMARK_(result__9168__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e38296){if((e38296 instanceof Object)){
var ex__9169__auto__ = e38296;
var statearr_38297_38314 = state_38275;
(statearr_38297_38314[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38275);

return cljs.core.cst$kw$recur;
} else {
throw e38296;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__9167__auto__,cljs.core.cst$kw$recur)){
var G__38315 = state_38275;
state_38275 = G__38315;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_38275){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_38275);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___38303,out))
})();
var state__9232__auto__ = (function (){var statearr_38298 = (f__9231__auto__.cljs$core$IFn$_invoke$arity$0 ? f__9231__auto__.cljs$core$IFn$_invoke$arity$0() : f__9231__auto__.call(null));
(statearr_38298[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___38303);

return statearr_38298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__9232__auto__);
});})(c__9230__auto___38303,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args38316 = [];
var len__5627__auto___38365 = arguments.length;
var i__5628__auto___38366 = (0);
while(true){
if((i__5628__auto___38366 < len__5627__auto___38365)){
args38316.push((arguments[i__5628__auto___38366]));

var G__38367 = (i__5628__auto___38366 + (1));
i__5628__auto___38366 = G__38367;
continue;
} else {
}
break;
}

var G__38318 = args38316.length;
switch (G__38318) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38316.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__9230__auto___38369 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__9230__auto___38369,out){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___38369,out){
return (function (state_38342){
var state_val_38343 = (state_38342[(1)]);
if((state_val_38343 === (7))){
var inst_38324 = (state_38342[(7)]);
var inst_38324__$1 = (state_38342[(2)]);
var inst_38325 = (inst_38324__$1 == null);
var inst_38326 = cljs.core.not(inst_38325);
var state_38342__$1 = (function (){var statearr_38344 = state_38342;
(statearr_38344[(7)] = inst_38324__$1);

return statearr_38344;
})();
if(inst_38326){
var statearr_38345_38370 = state_38342__$1;
(statearr_38345_38370[(1)] = (8));

} else {
var statearr_38346_38371 = state_38342__$1;
(statearr_38346_38371[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38343 === (1))){
var inst_38319 = (0);
var state_38342__$1 = (function (){var statearr_38347 = state_38342;
(statearr_38347[(8)] = inst_38319);

return statearr_38347;
})();
var statearr_38348_38372 = state_38342__$1;
(statearr_38348_38372[(2)] = null);

(statearr_38348_38372[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38343 === (4))){
var state_38342__$1 = state_38342;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38342__$1,(7),ch);
} else {
if((state_val_38343 === (6))){
var inst_38337 = (state_38342[(2)]);
var state_38342__$1 = state_38342;
var statearr_38349_38373 = state_38342__$1;
(statearr_38349_38373[(2)] = inst_38337);

(statearr_38349_38373[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38343 === (3))){
var inst_38339 = (state_38342[(2)]);
var inst_38340 = cljs.core.async.close_BANG_(out);
var state_38342__$1 = (function (){var statearr_38350 = state_38342;
(statearr_38350[(9)] = inst_38339);

return statearr_38350;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38342__$1,inst_38340);
} else {
if((state_val_38343 === (2))){
var inst_38319 = (state_38342[(8)]);
var inst_38321 = (inst_38319 < n);
var state_38342__$1 = state_38342;
if(cljs.core.truth_(inst_38321)){
var statearr_38351_38374 = state_38342__$1;
(statearr_38351_38374[(1)] = (4));

} else {
var statearr_38352_38375 = state_38342__$1;
(statearr_38352_38375[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38343 === (11))){
var inst_38319 = (state_38342[(8)]);
var inst_38329 = (state_38342[(2)]);
var inst_38330 = (inst_38319 + (1));
var inst_38319__$1 = inst_38330;
var state_38342__$1 = (function (){var statearr_38353 = state_38342;
(statearr_38353[(10)] = inst_38329);

(statearr_38353[(8)] = inst_38319__$1);

return statearr_38353;
})();
var statearr_38354_38376 = state_38342__$1;
(statearr_38354_38376[(2)] = null);

(statearr_38354_38376[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38343 === (9))){
var state_38342__$1 = state_38342;
var statearr_38355_38377 = state_38342__$1;
(statearr_38355_38377[(2)] = null);

(statearr_38355_38377[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38343 === (5))){
var state_38342__$1 = state_38342;
var statearr_38356_38378 = state_38342__$1;
(statearr_38356_38378[(2)] = null);

(statearr_38356_38378[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38343 === (10))){
var inst_38334 = (state_38342[(2)]);
var state_38342__$1 = state_38342;
var statearr_38357_38379 = state_38342__$1;
(statearr_38357_38379[(2)] = inst_38334);

(statearr_38357_38379[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38343 === (8))){
var inst_38324 = (state_38342[(7)]);
var state_38342__$1 = state_38342;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38342__$1,(11),out,inst_38324);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___38369,out))
;
return ((function (switch__9165__auto__,c__9230__auto___38369,out){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_38361 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38361[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_38361[(1)] = (1));

return statearr_38361;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_38342){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__(state_38342);
if(cljs.core.keyword_identical_QMARK_(result__9168__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e38362){if((e38362 instanceof Object)){
var ex__9169__auto__ = e38362;
var statearr_38363_38380 = state_38342;
(statearr_38363_38380[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38342);

return cljs.core.cst$kw$recur;
} else {
throw e38362;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__9167__auto__,cljs.core.cst$kw$recur)){
var G__38381 = state_38342;
state_38342 = G__38381;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_38342){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_38342);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___38369,out))
})();
var state__9232__auto__ = (function (){var statearr_38364 = (f__9231__auto__.cljs$core$IFn$_invoke$arity$0 ? f__9231__auto__.cljs$core$IFn$_invoke$arity$0() : f__9231__auto__.call(null));
(statearr_38364[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___38369);

return statearr_38364;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__9232__auto__);
});})(c__9230__auto___38369,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async38391 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38391 = (function (map_LT_,f,ch,meta38392){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta38392 = meta38392;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async38391.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38393,meta38392__$1){
var self__ = this;
var _38393__$1 = this;
return (new cljs.core.async.t_cljs$core$async38391(self__.map_LT_,self__.f,self__.ch,meta38392__$1));
});

cljs.core.async.t_cljs$core$async38391.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38393){
var self__ = this;
var _38393__$1 = this;
return self__.meta38392;
});

cljs.core.async.t_cljs$core$async38391.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async38391.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async38391.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async38391.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async38391.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async38394 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38394 = (function (map_LT_,f,ch,meta38392,_,fn1,meta38395){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta38392 = meta38392;
this._ = _;
this.fn1 = fn1;
this.meta38395 = meta38395;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async38394.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_38396,meta38395__$1){
var self__ = this;
var _38396__$1 = this;
return (new cljs.core.async.t_cljs$core$async38394(self__.map_LT_,self__.f,self__.ch,self__.meta38392,self__._,self__.fn1,meta38395__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async38394.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_38396){
var self__ = this;
var _38396__$1 = this;
return self__.meta38395;
});})(___$1))
;

cljs.core.async.t_cljs$core$async38394.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async38394.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async38394.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__38382_SHARP_){
var G__38397 = (((p1__38382_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__38382_SHARP_) : self__.f.call(null,p1__38382_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__38397) : f1.call(null,G__38397));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async38394.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta38392,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async38391], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta38395], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async38394.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38394.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38394";

cljs.core.async.t_cljs$core$async38394.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async38394");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async38394 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async38394(map_LT___$1,f__$1,ch__$1,meta38392__$1,___$2,fn1__$1,meta38395){
return (new cljs.core.async.t_cljs$core$async38394(map_LT___$1,f__$1,ch__$1,meta38392__$1,___$2,fn1__$1,meta38395));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async38394(self__.map_LT_,self__.f,self__.ch,self__.meta38392,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4557__auto__ = ret;
if(cljs.core.truth_(and__4557__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__4557__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__38398 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__38398) : self__.f.call(null,G__38398));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async38391.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async38391.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async38391.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta38392], null);
});

cljs.core.async.t_cljs$core$async38391.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38391.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38391";

cljs.core.async.t_cljs$core$async38391.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async38391");
});

cljs.core.async.__GT_t_cljs$core$async38391 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async38391(map_LT___$1,f__$1,ch__$1,meta38392){
return (new cljs.core.async.t_cljs$core$async38391(map_LT___$1,f__$1,ch__$1,meta38392));
});

}

return (new cljs.core.async.t_cljs$core$async38391(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async38402 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38402 = (function (map_GT_,f,ch,meta38403){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta38403 = meta38403;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async38402.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38404,meta38403__$1){
var self__ = this;
var _38404__$1 = this;
return (new cljs.core.async.t_cljs$core$async38402(self__.map_GT_,self__.f,self__.ch,meta38403__$1));
});

cljs.core.async.t_cljs$core$async38402.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38404){
var self__ = this;
var _38404__$1 = this;
return self__.meta38403;
});

cljs.core.async.t_cljs$core$async38402.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async38402.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async38402.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async38402.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async38402.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async38402.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async38402.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta38403], null);
});

cljs.core.async.t_cljs$core$async38402.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38402.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38402";

cljs.core.async.t_cljs$core$async38402.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async38402");
});

cljs.core.async.__GT_t_cljs$core$async38402 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async38402(map_GT___$1,f__$1,ch__$1,meta38403){
return (new cljs.core.async.t_cljs$core$async38402(map_GT___$1,f__$1,ch__$1,meta38403));
});

}

return (new cljs.core.async.t_cljs$core$async38402(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async38408 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38408 = (function (filter_GT_,p,ch,meta38409){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta38409 = meta38409;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async38408.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38410,meta38409__$1){
var self__ = this;
var _38410__$1 = this;
return (new cljs.core.async.t_cljs$core$async38408(self__.filter_GT_,self__.p,self__.ch,meta38409__$1));
});

cljs.core.async.t_cljs$core$async38408.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38410){
var self__ = this;
var _38410__$1 = this;
return self__.meta38409;
});

cljs.core.async.t_cljs$core$async38408.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async38408.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async38408.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async38408.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async38408.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async38408.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async38408.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async38408.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$filter_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta38409], null);
});

cljs.core.async.t_cljs$core$async38408.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38408.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38408";

cljs.core.async.t_cljs$core$async38408.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async38408");
});

cljs.core.async.__GT_t_cljs$core$async38408 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async38408(filter_GT___$1,p__$1,ch__$1,meta38409){
return (new cljs.core.async.t_cljs$core$async38408(filter_GT___$1,p__$1,ch__$1,meta38409));
});

}

return (new cljs.core.async.t_cljs$core$async38408(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args38411 = [];
var len__5627__auto___38455 = arguments.length;
var i__5628__auto___38456 = (0);
while(true){
if((i__5628__auto___38456 < len__5627__auto___38455)){
args38411.push((arguments[i__5628__auto___38456]));

var G__38457 = (i__5628__auto___38456 + (1));
i__5628__auto___38456 = G__38457;
continue;
} else {
}
break;
}

var G__38413 = args38411.length;
switch (G__38413) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38411.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__9230__auto___38459 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__9230__auto___38459,out){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___38459,out){
return (function (state_38434){
var state_val_38435 = (state_38434[(1)]);
if((state_val_38435 === (7))){
var inst_38430 = (state_38434[(2)]);
var state_38434__$1 = state_38434;
var statearr_38436_38460 = state_38434__$1;
(statearr_38436_38460[(2)] = inst_38430);

(statearr_38436_38460[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38435 === (1))){
var state_38434__$1 = state_38434;
var statearr_38437_38461 = state_38434__$1;
(statearr_38437_38461[(2)] = null);

(statearr_38437_38461[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38435 === (4))){
var inst_38416 = (state_38434[(7)]);
var inst_38416__$1 = (state_38434[(2)]);
var inst_38417 = (inst_38416__$1 == null);
var state_38434__$1 = (function (){var statearr_38438 = state_38434;
(statearr_38438[(7)] = inst_38416__$1);

return statearr_38438;
})();
if(cljs.core.truth_(inst_38417)){
var statearr_38439_38462 = state_38434__$1;
(statearr_38439_38462[(1)] = (5));

} else {
var statearr_38440_38463 = state_38434__$1;
(statearr_38440_38463[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38435 === (6))){
var inst_38416 = (state_38434[(7)]);
var inst_38421 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_38416) : p.call(null,inst_38416));
var state_38434__$1 = state_38434;
if(cljs.core.truth_(inst_38421)){
var statearr_38441_38464 = state_38434__$1;
(statearr_38441_38464[(1)] = (8));

} else {
var statearr_38442_38465 = state_38434__$1;
(statearr_38442_38465[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38435 === (3))){
var inst_38432 = (state_38434[(2)]);
var state_38434__$1 = state_38434;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38434__$1,inst_38432);
} else {
if((state_val_38435 === (2))){
var state_38434__$1 = state_38434;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38434__$1,(4),ch);
} else {
if((state_val_38435 === (11))){
var inst_38424 = (state_38434[(2)]);
var state_38434__$1 = state_38434;
var statearr_38443_38466 = state_38434__$1;
(statearr_38443_38466[(2)] = inst_38424);

(statearr_38443_38466[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38435 === (9))){
var state_38434__$1 = state_38434;
var statearr_38444_38467 = state_38434__$1;
(statearr_38444_38467[(2)] = null);

(statearr_38444_38467[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38435 === (5))){
var inst_38419 = cljs.core.async.close_BANG_(out);
var state_38434__$1 = state_38434;
var statearr_38445_38468 = state_38434__$1;
(statearr_38445_38468[(2)] = inst_38419);

(statearr_38445_38468[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38435 === (10))){
var inst_38427 = (state_38434[(2)]);
var state_38434__$1 = (function (){var statearr_38446 = state_38434;
(statearr_38446[(8)] = inst_38427);

return statearr_38446;
})();
var statearr_38447_38469 = state_38434__$1;
(statearr_38447_38469[(2)] = null);

(statearr_38447_38469[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38435 === (8))){
var inst_38416 = (state_38434[(7)]);
var state_38434__$1 = state_38434;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38434__$1,(11),out,inst_38416);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___38459,out))
;
return ((function (switch__9165__auto__,c__9230__auto___38459,out){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_38451 = [null,null,null,null,null,null,null,null,null];
(statearr_38451[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_38451[(1)] = (1));

return statearr_38451;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_38434){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__(state_38434);
if(cljs.core.keyword_identical_QMARK_(result__9168__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e38452){if((e38452 instanceof Object)){
var ex__9169__auto__ = e38452;
var statearr_38453_38470 = state_38434;
(statearr_38453_38470[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38434);

return cljs.core.cst$kw$recur;
} else {
throw e38452;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__9167__auto__,cljs.core.cst$kw$recur)){
var G__38471 = state_38434;
state_38434 = G__38471;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_38434){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_38434);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___38459,out))
})();
var state__9232__auto__ = (function (){var statearr_38454 = (f__9231__auto__.cljs$core$IFn$_invoke$arity$0 ? f__9231__auto__.cljs$core$IFn$_invoke$arity$0() : f__9231__auto__.call(null));
(statearr_38454[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___38459);

return statearr_38454;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__9232__auto__);
});})(c__9230__auto___38459,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args38472 = [];
var len__5627__auto___38475 = arguments.length;
var i__5628__auto___38476 = (0);
while(true){
if((i__5628__auto___38476 < len__5627__auto___38475)){
args38472.push((arguments[i__5628__auto___38476]));

var G__38477 = (i__5628__auto___38476 + (1));
i__5628__auto___38476 = G__38477;
continue;
} else {
}
break;
}

var G__38474 = args38472.length;
switch (G__38474) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38472.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__9230__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__9230__auto__){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto__){
return (function (state_38644){
var state_val_38645 = (state_38644[(1)]);
if((state_val_38645 === (7))){
var inst_38640 = (state_38644[(2)]);
var state_38644__$1 = state_38644;
var statearr_38646_38687 = state_38644__$1;
(statearr_38646_38687[(2)] = inst_38640);

(statearr_38646_38687[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38645 === (20))){
var inst_38610 = (state_38644[(7)]);
var inst_38621 = (state_38644[(2)]);
var inst_38622 = cljs.core.next(inst_38610);
var inst_38596 = inst_38622;
var inst_38597 = null;
var inst_38598 = (0);
var inst_38599 = (0);
var state_38644__$1 = (function (){var statearr_38647 = state_38644;
(statearr_38647[(8)] = inst_38597);

(statearr_38647[(9)] = inst_38598);

(statearr_38647[(10)] = inst_38599);

(statearr_38647[(11)] = inst_38596);

(statearr_38647[(12)] = inst_38621);

return statearr_38647;
})();
var statearr_38648_38688 = state_38644__$1;
(statearr_38648_38688[(2)] = null);

(statearr_38648_38688[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38645 === (1))){
var state_38644__$1 = state_38644;
var statearr_38649_38689 = state_38644__$1;
(statearr_38649_38689[(2)] = null);

(statearr_38649_38689[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38645 === (4))){
var inst_38585 = (state_38644[(13)]);
var inst_38585__$1 = (state_38644[(2)]);
var inst_38586 = (inst_38585__$1 == null);
var state_38644__$1 = (function (){var statearr_38650 = state_38644;
(statearr_38650[(13)] = inst_38585__$1);

return statearr_38650;
})();
if(cljs.core.truth_(inst_38586)){
var statearr_38651_38690 = state_38644__$1;
(statearr_38651_38690[(1)] = (5));

} else {
var statearr_38652_38691 = state_38644__$1;
(statearr_38652_38691[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38645 === (15))){
var state_38644__$1 = state_38644;
var statearr_38656_38692 = state_38644__$1;
(statearr_38656_38692[(2)] = null);

(statearr_38656_38692[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38645 === (21))){
var state_38644__$1 = state_38644;
var statearr_38657_38693 = state_38644__$1;
(statearr_38657_38693[(2)] = null);

(statearr_38657_38693[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38645 === (13))){
var inst_38597 = (state_38644[(8)]);
var inst_38598 = (state_38644[(9)]);
var inst_38599 = (state_38644[(10)]);
var inst_38596 = (state_38644[(11)]);
var inst_38606 = (state_38644[(2)]);
var inst_38607 = (inst_38599 + (1));
var tmp38653 = inst_38597;
var tmp38654 = inst_38598;
var tmp38655 = inst_38596;
var inst_38596__$1 = tmp38655;
var inst_38597__$1 = tmp38653;
var inst_38598__$1 = tmp38654;
var inst_38599__$1 = inst_38607;
var state_38644__$1 = (function (){var statearr_38658 = state_38644;
(statearr_38658[(8)] = inst_38597__$1);

(statearr_38658[(9)] = inst_38598__$1);

(statearr_38658[(10)] = inst_38599__$1);

(statearr_38658[(11)] = inst_38596__$1);

(statearr_38658[(14)] = inst_38606);

return statearr_38658;
})();
var statearr_38659_38694 = state_38644__$1;
(statearr_38659_38694[(2)] = null);

(statearr_38659_38694[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38645 === (22))){
var state_38644__$1 = state_38644;
var statearr_38660_38695 = state_38644__$1;
(statearr_38660_38695[(2)] = null);

(statearr_38660_38695[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38645 === (6))){
var inst_38585 = (state_38644[(13)]);
var inst_38594 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_38585) : f.call(null,inst_38585));
var inst_38595 = cljs.core.seq(inst_38594);
var inst_38596 = inst_38595;
var inst_38597 = null;
var inst_38598 = (0);
var inst_38599 = (0);
var state_38644__$1 = (function (){var statearr_38661 = state_38644;
(statearr_38661[(8)] = inst_38597);

(statearr_38661[(9)] = inst_38598);

(statearr_38661[(10)] = inst_38599);

(statearr_38661[(11)] = inst_38596);

return statearr_38661;
})();
var statearr_38662_38696 = state_38644__$1;
(statearr_38662_38696[(2)] = null);

(statearr_38662_38696[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38645 === (17))){
var inst_38610 = (state_38644[(7)]);
var inst_38614 = cljs.core.chunk_first(inst_38610);
var inst_38615 = cljs.core.chunk_rest(inst_38610);
var inst_38616 = cljs.core.count(inst_38614);
var inst_38596 = inst_38615;
var inst_38597 = inst_38614;
var inst_38598 = inst_38616;
var inst_38599 = (0);
var state_38644__$1 = (function (){var statearr_38663 = state_38644;
(statearr_38663[(8)] = inst_38597);

(statearr_38663[(9)] = inst_38598);

(statearr_38663[(10)] = inst_38599);

(statearr_38663[(11)] = inst_38596);

return statearr_38663;
})();
var statearr_38664_38697 = state_38644__$1;
(statearr_38664_38697[(2)] = null);

(statearr_38664_38697[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38645 === (3))){
var inst_38642 = (state_38644[(2)]);
var state_38644__$1 = state_38644;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38644__$1,inst_38642);
} else {
if((state_val_38645 === (12))){
var inst_38630 = (state_38644[(2)]);
var state_38644__$1 = state_38644;
var statearr_38665_38698 = state_38644__$1;
(statearr_38665_38698[(2)] = inst_38630);

(statearr_38665_38698[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38645 === (2))){
var state_38644__$1 = state_38644;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38644__$1,(4),in$);
} else {
if((state_val_38645 === (23))){
var inst_38638 = (state_38644[(2)]);
var state_38644__$1 = state_38644;
var statearr_38666_38699 = state_38644__$1;
(statearr_38666_38699[(2)] = inst_38638);

(statearr_38666_38699[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38645 === (19))){
var inst_38625 = (state_38644[(2)]);
var state_38644__$1 = state_38644;
var statearr_38667_38700 = state_38644__$1;
(statearr_38667_38700[(2)] = inst_38625);

(statearr_38667_38700[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38645 === (11))){
var inst_38596 = (state_38644[(11)]);
var inst_38610 = (state_38644[(7)]);
var inst_38610__$1 = cljs.core.seq(inst_38596);
var state_38644__$1 = (function (){var statearr_38668 = state_38644;
(statearr_38668[(7)] = inst_38610__$1);

return statearr_38668;
})();
if(inst_38610__$1){
var statearr_38669_38701 = state_38644__$1;
(statearr_38669_38701[(1)] = (14));

} else {
var statearr_38670_38702 = state_38644__$1;
(statearr_38670_38702[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38645 === (9))){
var inst_38632 = (state_38644[(2)]);
var inst_38633 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_38644__$1 = (function (){var statearr_38671 = state_38644;
(statearr_38671[(15)] = inst_38632);

return statearr_38671;
})();
if(cljs.core.truth_(inst_38633)){
var statearr_38672_38703 = state_38644__$1;
(statearr_38672_38703[(1)] = (21));

} else {
var statearr_38673_38704 = state_38644__$1;
(statearr_38673_38704[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38645 === (5))){
var inst_38588 = cljs.core.async.close_BANG_(out);
var state_38644__$1 = state_38644;
var statearr_38674_38705 = state_38644__$1;
(statearr_38674_38705[(2)] = inst_38588);

(statearr_38674_38705[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38645 === (14))){
var inst_38610 = (state_38644[(7)]);
var inst_38612 = cljs.core.chunked_seq_QMARK_(inst_38610);
var state_38644__$1 = state_38644;
if(inst_38612){
var statearr_38675_38706 = state_38644__$1;
(statearr_38675_38706[(1)] = (17));

} else {
var statearr_38676_38707 = state_38644__$1;
(statearr_38676_38707[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38645 === (16))){
var inst_38628 = (state_38644[(2)]);
var state_38644__$1 = state_38644;
var statearr_38677_38708 = state_38644__$1;
(statearr_38677_38708[(2)] = inst_38628);

(statearr_38677_38708[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38645 === (10))){
var inst_38597 = (state_38644[(8)]);
var inst_38599 = (state_38644[(10)]);
var inst_38604 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_38597,inst_38599);
var state_38644__$1 = state_38644;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38644__$1,(13),out,inst_38604);
} else {
if((state_val_38645 === (18))){
var inst_38610 = (state_38644[(7)]);
var inst_38619 = cljs.core.first(inst_38610);
var state_38644__$1 = state_38644;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38644__$1,(20),out,inst_38619);
} else {
if((state_val_38645 === (8))){
var inst_38598 = (state_38644[(9)]);
var inst_38599 = (state_38644[(10)]);
var inst_38601 = (inst_38599 < inst_38598);
var inst_38602 = inst_38601;
var state_38644__$1 = state_38644;
if(cljs.core.truth_(inst_38602)){
var statearr_38678_38709 = state_38644__$1;
(statearr_38678_38709[(1)] = (10));

} else {
var statearr_38679_38710 = state_38644__$1;
(statearr_38679_38710[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto__))
;
return ((function (switch__9165__auto__,c__9230__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__9166__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__9166__auto____0 = (function (){
var statearr_38683 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38683[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__9166__auto__);

(statearr_38683[(1)] = (1));

return statearr_38683;
});
var cljs$core$async$mapcat_STAR__$_state_machine__9166__auto____1 = (function (state_38644){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__(state_38644);
if(cljs.core.keyword_identical_QMARK_(result__9168__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e38684){if((e38684 instanceof Object)){
var ex__9169__auto__ = e38684;
var statearr_38685_38711 = state_38644;
(statearr_38685_38711[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38644);

return cljs.core.cst$kw$recur;
} else {
throw e38684;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__9167__auto__,cljs.core.cst$kw$recur)){
var G__38712 = state_38644;
state_38644 = G__38712;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__9166__auto__ = function(state_38644){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__9166__auto____1.call(this,state_38644);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__9166__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__9166__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto__))
})();
var state__9232__auto__ = (function (){var statearr_38686 = (f__9231__auto__.cljs$core$IFn$_invoke$arity$0 ? f__9231__auto__.cljs$core$IFn$_invoke$arity$0() : f__9231__auto__.call(null));
(statearr_38686[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto__);

return statearr_38686;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__9232__auto__);
});})(c__9230__auto__))
);

return c__9230__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args38713 = [];
var len__5627__auto___38716 = arguments.length;
var i__5628__auto___38717 = (0);
while(true){
if((i__5628__auto___38717 < len__5627__auto___38716)){
args38713.push((arguments[i__5628__auto___38717]));

var G__38718 = (i__5628__auto___38717 + (1));
i__5628__auto___38717 = G__38718;
continue;
} else {
}
break;
}

var G__38715 = args38713.length;
switch (G__38715) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38713.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args38720 = [];
var len__5627__auto___38723 = arguments.length;
var i__5628__auto___38724 = (0);
while(true){
if((i__5628__auto___38724 < len__5627__auto___38723)){
args38720.push((arguments[i__5628__auto___38724]));

var G__38725 = (i__5628__auto___38724 + (1));
i__5628__auto___38724 = G__38725;
continue;
} else {
}
break;
}

var G__38722 = args38720.length;
switch (G__38722) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38720.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args38727 = [];
var len__5627__auto___38778 = arguments.length;
var i__5628__auto___38779 = (0);
while(true){
if((i__5628__auto___38779 < len__5627__auto___38778)){
args38727.push((arguments[i__5628__auto___38779]));

var G__38780 = (i__5628__auto___38779 + (1));
i__5628__auto___38779 = G__38780;
continue;
} else {
}
break;
}

var G__38729 = args38727.length;
switch (G__38729) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38727.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__9230__auto___38782 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__9230__auto___38782,out){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___38782,out){
return (function (state_38753){
var state_val_38754 = (state_38753[(1)]);
if((state_val_38754 === (7))){
var inst_38748 = (state_38753[(2)]);
var state_38753__$1 = state_38753;
var statearr_38755_38783 = state_38753__$1;
(statearr_38755_38783[(2)] = inst_38748);

(statearr_38755_38783[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38754 === (1))){
var inst_38730 = null;
var state_38753__$1 = (function (){var statearr_38756 = state_38753;
(statearr_38756[(7)] = inst_38730);

return statearr_38756;
})();
var statearr_38757_38784 = state_38753__$1;
(statearr_38757_38784[(2)] = null);

(statearr_38757_38784[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38754 === (4))){
var inst_38733 = (state_38753[(8)]);
var inst_38733__$1 = (state_38753[(2)]);
var inst_38734 = (inst_38733__$1 == null);
var inst_38735 = cljs.core.not(inst_38734);
var state_38753__$1 = (function (){var statearr_38758 = state_38753;
(statearr_38758[(8)] = inst_38733__$1);

return statearr_38758;
})();
if(inst_38735){
var statearr_38759_38785 = state_38753__$1;
(statearr_38759_38785[(1)] = (5));

} else {
var statearr_38760_38786 = state_38753__$1;
(statearr_38760_38786[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38754 === (6))){
var state_38753__$1 = state_38753;
var statearr_38761_38787 = state_38753__$1;
(statearr_38761_38787[(2)] = null);

(statearr_38761_38787[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38754 === (3))){
var inst_38750 = (state_38753[(2)]);
var inst_38751 = cljs.core.async.close_BANG_(out);
var state_38753__$1 = (function (){var statearr_38762 = state_38753;
(statearr_38762[(9)] = inst_38750);

return statearr_38762;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38753__$1,inst_38751);
} else {
if((state_val_38754 === (2))){
var state_38753__$1 = state_38753;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38753__$1,(4),ch);
} else {
if((state_val_38754 === (11))){
var inst_38733 = (state_38753[(8)]);
var inst_38742 = (state_38753[(2)]);
var inst_38730 = inst_38733;
var state_38753__$1 = (function (){var statearr_38763 = state_38753;
(statearr_38763[(10)] = inst_38742);

(statearr_38763[(7)] = inst_38730);

return statearr_38763;
})();
var statearr_38764_38788 = state_38753__$1;
(statearr_38764_38788[(2)] = null);

(statearr_38764_38788[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38754 === (9))){
var inst_38733 = (state_38753[(8)]);
var state_38753__$1 = state_38753;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38753__$1,(11),out,inst_38733);
} else {
if((state_val_38754 === (5))){
var inst_38733 = (state_38753[(8)]);
var inst_38730 = (state_38753[(7)]);
var inst_38737 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38733,inst_38730);
var state_38753__$1 = state_38753;
if(inst_38737){
var statearr_38766_38789 = state_38753__$1;
(statearr_38766_38789[(1)] = (8));

} else {
var statearr_38767_38790 = state_38753__$1;
(statearr_38767_38790[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38754 === (10))){
var inst_38745 = (state_38753[(2)]);
var state_38753__$1 = state_38753;
var statearr_38768_38791 = state_38753__$1;
(statearr_38768_38791[(2)] = inst_38745);

(statearr_38768_38791[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38754 === (8))){
var inst_38730 = (state_38753[(7)]);
var tmp38765 = inst_38730;
var inst_38730__$1 = tmp38765;
var state_38753__$1 = (function (){var statearr_38769 = state_38753;
(statearr_38769[(7)] = inst_38730__$1);

return statearr_38769;
})();
var statearr_38770_38792 = state_38753__$1;
(statearr_38770_38792[(2)] = null);

(statearr_38770_38792[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___38782,out))
;
return ((function (switch__9165__auto__,c__9230__auto___38782,out){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_38774 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38774[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_38774[(1)] = (1));

return statearr_38774;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_38753){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__(state_38753);
if(cljs.core.keyword_identical_QMARK_(result__9168__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e38775){if((e38775 instanceof Object)){
var ex__9169__auto__ = e38775;
var statearr_38776_38793 = state_38753;
(statearr_38776_38793[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38753);

return cljs.core.cst$kw$recur;
} else {
throw e38775;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__9167__auto__,cljs.core.cst$kw$recur)){
var G__38794 = state_38753;
state_38753 = G__38794;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_38753){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_38753);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___38782,out))
})();
var state__9232__auto__ = (function (){var statearr_38777 = (f__9231__auto__.cljs$core$IFn$_invoke$arity$0 ? f__9231__auto__.cljs$core$IFn$_invoke$arity$0() : f__9231__auto__.call(null));
(statearr_38777[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___38782);

return statearr_38777;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__9232__auto__);
});})(c__9230__auto___38782,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args38795 = [];
var len__5627__auto___38865 = arguments.length;
var i__5628__auto___38866 = (0);
while(true){
if((i__5628__auto___38866 < len__5627__auto___38865)){
args38795.push((arguments[i__5628__auto___38866]));

var G__38867 = (i__5628__auto___38866 + (1));
i__5628__auto___38866 = G__38867;
continue;
} else {
}
break;
}

var G__38797 = args38795.length;
switch (G__38797) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38795.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__9230__auto___38869 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__9230__auto___38869,out){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___38869,out){
return (function (state_38835){
var state_val_38836 = (state_38835[(1)]);
if((state_val_38836 === (7))){
var inst_38831 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
var statearr_38837_38870 = state_38835__$1;
(statearr_38837_38870[(2)] = inst_38831);

(statearr_38837_38870[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38836 === (1))){
var inst_38798 = (new Array(n));
var inst_38799 = inst_38798;
var inst_38800 = (0);
var state_38835__$1 = (function (){var statearr_38838 = state_38835;
(statearr_38838[(7)] = inst_38799);

(statearr_38838[(8)] = inst_38800);

return statearr_38838;
})();
var statearr_38839_38871 = state_38835__$1;
(statearr_38839_38871[(2)] = null);

(statearr_38839_38871[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38836 === (4))){
var inst_38803 = (state_38835[(9)]);
var inst_38803__$1 = (state_38835[(2)]);
var inst_38804 = (inst_38803__$1 == null);
var inst_38805 = cljs.core.not(inst_38804);
var state_38835__$1 = (function (){var statearr_38840 = state_38835;
(statearr_38840[(9)] = inst_38803__$1);

return statearr_38840;
})();
if(inst_38805){
var statearr_38841_38872 = state_38835__$1;
(statearr_38841_38872[(1)] = (5));

} else {
var statearr_38842_38873 = state_38835__$1;
(statearr_38842_38873[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38836 === (15))){
var inst_38825 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
var statearr_38843_38874 = state_38835__$1;
(statearr_38843_38874[(2)] = inst_38825);

(statearr_38843_38874[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38836 === (13))){
var state_38835__$1 = state_38835;
var statearr_38844_38875 = state_38835__$1;
(statearr_38844_38875[(2)] = null);

(statearr_38844_38875[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38836 === (6))){
var inst_38800 = (state_38835[(8)]);
var inst_38821 = (inst_38800 > (0));
var state_38835__$1 = state_38835;
if(cljs.core.truth_(inst_38821)){
var statearr_38845_38876 = state_38835__$1;
(statearr_38845_38876[(1)] = (12));

} else {
var statearr_38846_38877 = state_38835__$1;
(statearr_38846_38877[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38836 === (3))){
var inst_38833 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38835__$1,inst_38833);
} else {
if((state_val_38836 === (12))){
var inst_38799 = (state_38835[(7)]);
var inst_38823 = cljs.core.vec(inst_38799);
var state_38835__$1 = state_38835;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38835__$1,(15),out,inst_38823);
} else {
if((state_val_38836 === (2))){
var state_38835__$1 = state_38835;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38835__$1,(4),ch);
} else {
if((state_val_38836 === (11))){
var inst_38815 = (state_38835[(2)]);
var inst_38816 = (new Array(n));
var inst_38799 = inst_38816;
var inst_38800 = (0);
var state_38835__$1 = (function (){var statearr_38847 = state_38835;
(statearr_38847[(10)] = inst_38815);

(statearr_38847[(7)] = inst_38799);

(statearr_38847[(8)] = inst_38800);

return statearr_38847;
})();
var statearr_38848_38878 = state_38835__$1;
(statearr_38848_38878[(2)] = null);

(statearr_38848_38878[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38836 === (9))){
var inst_38799 = (state_38835[(7)]);
var inst_38813 = cljs.core.vec(inst_38799);
var state_38835__$1 = state_38835;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38835__$1,(11),out,inst_38813);
} else {
if((state_val_38836 === (5))){
var inst_38799 = (state_38835[(7)]);
var inst_38808 = (state_38835[(11)]);
var inst_38803 = (state_38835[(9)]);
var inst_38800 = (state_38835[(8)]);
var inst_38807 = (inst_38799[inst_38800] = inst_38803);
var inst_38808__$1 = (inst_38800 + (1));
var inst_38809 = (inst_38808__$1 < n);
var state_38835__$1 = (function (){var statearr_38849 = state_38835;
(statearr_38849[(12)] = inst_38807);

(statearr_38849[(11)] = inst_38808__$1);

return statearr_38849;
})();
if(cljs.core.truth_(inst_38809)){
var statearr_38850_38879 = state_38835__$1;
(statearr_38850_38879[(1)] = (8));

} else {
var statearr_38851_38880 = state_38835__$1;
(statearr_38851_38880[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38836 === (14))){
var inst_38828 = (state_38835[(2)]);
var inst_38829 = cljs.core.async.close_BANG_(out);
var state_38835__$1 = (function (){var statearr_38853 = state_38835;
(statearr_38853[(13)] = inst_38828);

return statearr_38853;
})();
var statearr_38854_38881 = state_38835__$1;
(statearr_38854_38881[(2)] = inst_38829);

(statearr_38854_38881[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38836 === (10))){
var inst_38819 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
var statearr_38855_38882 = state_38835__$1;
(statearr_38855_38882[(2)] = inst_38819);

(statearr_38855_38882[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38836 === (8))){
var inst_38799 = (state_38835[(7)]);
var inst_38808 = (state_38835[(11)]);
var tmp38852 = inst_38799;
var inst_38799__$1 = tmp38852;
var inst_38800 = inst_38808;
var state_38835__$1 = (function (){var statearr_38856 = state_38835;
(statearr_38856[(7)] = inst_38799__$1);

(statearr_38856[(8)] = inst_38800);

return statearr_38856;
})();
var statearr_38857_38883 = state_38835__$1;
(statearr_38857_38883[(2)] = null);

(statearr_38857_38883[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___38869,out))
;
return ((function (switch__9165__auto__,c__9230__auto___38869,out){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_38861 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38861[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_38861[(1)] = (1));

return statearr_38861;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_38835){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__(state_38835);
if(cljs.core.keyword_identical_QMARK_(result__9168__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e38862){if((e38862 instanceof Object)){
var ex__9169__auto__ = e38862;
var statearr_38863_38884 = state_38835;
(statearr_38863_38884[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38835);

return cljs.core.cst$kw$recur;
} else {
throw e38862;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__9167__auto__,cljs.core.cst$kw$recur)){
var G__38885 = state_38835;
state_38835 = G__38885;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_38835){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_38835);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___38869,out))
})();
var state__9232__auto__ = (function (){var statearr_38864 = (f__9231__auto__.cljs$core$IFn$_invoke$arity$0 ? f__9231__auto__.cljs$core$IFn$_invoke$arity$0() : f__9231__auto__.call(null));
(statearr_38864[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___38869);

return statearr_38864;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__9232__auto__);
});})(c__9230__auto___38869,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args38886 = [];
var len__5627__auto___38960 = arguments.length;
var i__5628__auto___38961 = (0);
while(true){
if((i__5628__auto___38961 < len__5627__auto___38960)){
args38886.push((arguments[i__5628__auto___38961]));

var G__38962 = (i__5628__auto___38961 + (1));
i__5628__auto___38961 = G__38962;
continue;
} else {
}
break;
}

var G__38888 = args38886.length;
switch (G__38888) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38886.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__9230__auto___38964 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__9230__auto___38964,out){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___38964,out){
return (function (state_38930){
var state_val_38931 = (state_38930[(1)]);
if((state_val_38931 === (7))){
var inst_38926 = (state_38930[(2)]);
var state_38930__$1 = state_38930;
var statearr_38932_38965 = state_38930__$1;
(statearr_38932_38965[(2)] = inst_38926);

(statearr_38932_38965[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38931 === (1))){
var inst_38889 = [];
var inst_38890 = inst_38889;
var inst_38891 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_38930__$1 = (function (){var statearr_38933 = state_38930;
(statearr_38933[(7)] = inst_38891);

(statearr_38933[(8)] = inst_38890);

return statearr_38933;
})();
var statearr_38934_38966 = state_38930__$1;
(statearr_38934_38966[(2)] = null);

(statearr_38934_38966[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38931 === (4))){
var inst_38894 = (state_38930[(9)]);
var inst_38894__$1 = (state_38930[(2)]);
var inst_38895 = (inst_38894__$1 == null);
var inst_38896 = cljs.core.not(inst_38895);
var state_38930__$1 = (function (){var statearr_38935 = state_38930;
(statearr_38935[(9)] = inst_38894__$1);

return statearr_38935;
})();
if(inst_38896){
var statearr_38936_38967 = state_38930__$1;
(statearr_38936_38967[(1)] = (5));

} else {
var statearr_38937_38968 = state_38930__$1;
(statearr_38937_38968[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38931 === (15))){
var inst_38920 = (state_38930[(2)]);
var state_38930__$1 = state_38930;
var statearr_38938_38969 = state_38930__$1;
(statearr_38938_38969[(2)] = inst_38920);

(statearr_38938_38969[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38931 === (13))){
var state_38930__$1 = state_38930;
var statearr_38939_38970 = state_38930__$1;
(statearr_38939_38970[(2)] = null);

(statearr_38939_38970[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38931 === (6))){
var inst_38890 = (state_38930[(8)]);
var inst_38915 = inst_38890.length;
var inst_38916 = (inst_38915 > (0));
var state_38930__$1 = state_38930;
if(cljs.core.truth_(inst_38916)){
var statearr_38940_38971 = state_38930__$1;
(statearr_38940_38971[(1)] = (12));

} else {
var statearr_38941_38972 = state_38930__$1;
(statearr_38941_38972[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38931 === (3))){
var inst_38928 = (state_38930[(2)]);
var state_38930__$1 = state_38930;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38930__$1,inst_38928);
} else {
if((state_val_38931 === (12))){
var inst_38890 = (state_38930[(8)]);
var inst_38918 = cljs.core.vec(inst_38890);
var state_38930__$1 = state_38930;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38930__$1,(15),out,inst_38918);
} else {
if((state_val_38931 === (2))){
var state_38930__$1 = state_38930;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38930__$1,(4),ch);
} else {
if((state_val_38931 === (11))){
var inst_38898 = (state_38930[(10)]);
var inst_38894 = (state_38930[(9)]);
var inst_38908 = (state_38930[(2)]);
var inst_38909 = [];
var inst_38910 = inst_38909.push(inst_38894);
var inst_38890 = inst_38909;
var inst_38891 = inst_38898;
var state_38930__$1 = (function (){var statearr_38942 = state_38930;
(statearr_38942[(11)] = inst_38910);

(statearr_38942[(12)] = inst_38908);

(statearr_38942[(7)] = inst_38891);

(statearr_38942[(8)] = inst_38890);

return statearr_38942;
})();
var statearr_38943_38973 = state_38930__$1;
(statearr_38943_38973[(2)] = null);

(statearr_38943_38973[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38931 === (9))){
var inst_38890 = (state_38930[(8)]);
var inst_38906 = cljs.core.vec(inst_38890);
var state_38930__$1 = state_38930;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38930__$1,(11),out,inst_38906);
} else {
if((state_val_38931 === (5))){
var inst_38898 = (state_38930[(10)]);
var inst_38891 = (state_38930[(7)]);
var inst_38894 = (state_38930[(9)]);
var inst_38898__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_38894) : f.call(null,inst_38894));
var inst_38899 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38898__$1,inst_38891);
var inst_38900 = cljs.core.keyword_identical_QMARK_(inst_38891,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_38901 = (inst_38899) || (inst_38900);
var state_38930__$1 = (function (){var statearr_38944 = state_38930;
(statearr_38944[(10)] = inst_38898__$1);

return statearr_38944;
})();
if(cljs.core.truth_(inst_38901)){
var statearr_38945_38974 = state_38930__$1;
(statearr_38945_38974[(1)] = (8));

} else {
var statearr_38946_38975 = state_38930__$1;
(statearr_38946_38975[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38931 === (14))){
var inst_38923 = (state_38930[(2)]);
var inst_38924 = cljs.core.async.close_BANG_(out);
var state_38930__$1 = (function (){var statearr_38948 = state_38930;
(statearr_38948[(13)] = inst_38923);

return statearr_38948;
})();
var statearr_38949_38976 = state_38930__$1;
(statearr_38949_38976[(2)] = inst_38924);

(statearr_38949_38976[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38931 === (10))){
var inst_38913 = (state_38930[(2)]);
var state_38930__$1 = state_38930;
var statearr_38950_38977 = state_38930__$1;
(statearr_38950_38977[(2)] = inst_38913);

(statearr_38950_38977[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38931 === (8))){
var inst_38898 = (state_38930[(10)]);
var inst_38894 = (state_38930[(9)]);
var inst_38890 = (state_38930[(8)]);
var inst_38903 = inst_38890.push(inst_38894);
var tmp38947 = inst_38890;
var inst_38890__$1 = tmp38947;
var inst_38891 = inst_38898;
var state_38930__$1 = (function (){var statearr_38951 = state_38930;
(statearr_38951[(7)] = inst_38891);

(statearr_38951[(14)] = inst_38903);

(statearr_38951[(8)] = inst_38890__$1);

return statearr_38951;
})();
var statearr_38952_38978 = state_38930__$1;
(statearr_38952_38978[(2)] = null);

(statearr_38952_38978[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___38964,out))
;
return ((function (switch__9165__auto__,c__9230__auto___38964,out){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_38956 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38956[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_38956[(1)] = (1));

return statearr_38956;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_38930){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__(state_38930);
if(cljs.core.keyword_identical_QMARK_(result__9168__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e38957){if((e38957 instanceof Object)){
var ex__9169__auto__ = e38957;
var statearr_38958_38979 = state_38930;
(statearr_38958_38979[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38930);

return cljs.core.cst$kw$recur;
} else {
throw e38957;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__9167__auto__,cljs.core.cst$kw$recur)){
var G__38980 = state_38930;
state_38930 = G__38980;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_38930){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_38930);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___38964,out))
})();
var state__9232__auto__ = (function (){var statearr_38959 = (f__9231__auto__.cljs$core$IFn$_invoke$arity$0 ? f__9231__auto__.cljs$core$IFn$_invoke$arity$0() : f__9231__auto__.call(null));
(statearr_38959[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___38964);

return statearr_38959;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__9232__auto__);
});})(c__9230__auto___38964,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
