// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('c2.scale');
goog.require('cljs.core');
goog.require('c2.maths');

/**
 * @interface
 */
c2.scale.IInvertable = function(){};

/**
 * Inverted scale
 */
c2.scale.invert = (function c2$scale$invert(scale){
if((!((scale == null))) && (!((scale.c2$scale$IInvertable$invert$arity$1 == null)))){
return scale.c2$scale$IInvertable$invert$arity$1(scale);
} else {
var x__5224__auto__ = (((scale == null))?null:scale);
var m__5225__auto__ = (c2.scale.invert[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(scale) : m__5225__auto__.call(null,scale));
} else {
var m__5225__auto____$1 = (c2.scale.invert["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(scale) : m__5225__auto____$1.call(null,scale));
} else {
throw cljs.core.missing_protocol("IInvertable.invert",scale);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {c2.scale.IInvertable}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
c2.scale._linear = (function (domain,range,__meta,__extmap,__hash){
this.domain = domain;
this.range = range;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667595;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
c2.scale._linear.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5183__auto__,k__5184__auto__){
var self__ = this;
var this__5183__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__5183__auto____$1,k__5184__auto__,null);
});

c2.scale._linear.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5185__auto__,k34876,else__5186__auto__){
var self__ = this;
var this__5185__auto____$1 = this;
var G__34879 = (((k34876 instanceof cljs.core.Keyword))?k34876.fqn:null);
switch (G__34879) {
case "domain":
return self__.domain;

break;
case "range":
return self__.range;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k34876,else__5186__auto__);

}
});

c2.scale._linear.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5197__auto__,writer__5198__auto__,opts__5199__auto__){
var self__ = this;
var this__5197__auto____$1 = this;
var pr_pair__5200__auto__ = ((function (this__5197__auto____$1){
return (function (keyval__5201__auto__){
return cljs.core.pr_sequential_writer(writer__5198__auto__,cljs.core.pr_writer,""," ","",opts__5199__auto__,keyval__5201__auto__);
});})(this__5197__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__5198__auto__,pr_pair__5200__auto__,"#c2.scale._linear{",", ","}",opts__5199__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$domain,self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$range,self__.range],null))], null),self__.__extmap));
});

c2.scale._linear.prototype.cljs$core$IIterable$ = true;

c2.scale._linear.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__34875){
var self__ = this;
var G__34875__$1 = this;
return (new cljs.core.RecordIter((0),G__34875__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$domain,cljs.core.cst$kw$range], null),cljs.core._iterator(self__.__extmap)));
});

c2.scale._linear.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5181__auto__){
var self__ = this;
var this__5181__auto____$1 = this;
return self__.__meta;
});

c2.scale._linear.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5177__auto__){
var self__ = this;
var this__5177__auto____$1 = this;
return (new c2.scale._linear(self__.domain,self__.range,self__.__meta,self__.__extmap,self__.__hash));
});

c2.scale._linear.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5187__auto__){
var self__ = this;
var this__5187__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

c2.scale._linear.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5178__auto__){
var self__ = this;
var this__5178__auto____$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_imap(this__5178__auto____$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

c2.scale._linear.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__5179__auto__,other__5180__auto__){
var self__ = this;
var this__5179__auto____$1 = this;
if(cljs.core.truth_((function (){var and__4557__auto__ = other__5180__auto__;
if(cljs.core.truth_(and__4557__auto__)){
var and__4557__auto____$1 = (this__5179__auto____$1.constructor === other__5180__auto__.constructor);
if(and__4557__auto____$1){
return cljs.core.equiv_map(this__5179__auto____$1,other__5180__auto__);
} else {
return and__4557__auto____$1;
}
} else {
return and__4557__auto__;
}
})())){
return true;
} else {
return false;
}
});

c2.scale._linear.prototype.c2$scale$IInvertable$ = true;

c2.scale._linear.prototype.c2$scale$IInvertable$invert$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(this$__$1,cljs.core.cst$kw$domain,self__.range,cljs.core.array_seq([cljs.core.cst$kw$range,self__.domain], 0));
});

c2.scale._linear.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5192__auto__,k__5193__auto__){
var self__ = this;
var this__5192__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$domain,null,cljs.core.cst$kw$range,null], null), null),k__5193__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5192__auto____$1),self__.__meta),k__5193__auto__);
} else {
return (new c2.scale._linear(self__.domain,self__.range,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5193__auto__)),null));
}
});

c2.scale._linear.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5190__auto__,k__5191__auto__,G__34875){
var self__ = this;
var this__5190__auto____$1 = this;
var pred__34880 = cljs.core.keyword_identical_QMARK_;
var expr__34881 = k__5191__auto__;
if(cljs.core.truth_((pred__34880.cljs$core$IFn$_invoke$arity$2 ? pred__34880.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$domain,expr__34881) : pred__34880.call(null,cljs.core.cst$kw$domain,expr__34881)))){
return (new c2.scale._linear(G__34875,self__.range,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__34880.cljs$core$IFn$_invoke$arity$2 ? pred__34880.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$range,expr__34881) : pred__34880.call(null,cljs.core.cst$kw$range,expr__34881)))){
return (new c2.scale._linear(self__.domain,G__34875,self__.__meta,self__.__extmap,null));
} else {
return (new c2.scale._linear(self__.domain,self__.range,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5191__auto__,G__34875),null));
}
}
});

c2.scale._linear.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5195__auto__){
var self__ = this;
var this__5195__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$domain,self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$range,self__.range],null))], null),self__.__extmap));
});

c2.scale._linear.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5182__auto__,G__34875){
var self__ = this;
var this__5182__auto____$1 = this;
return (new c2.scale._linear(self__.domain,self__.range,G__34875,self__.__extmap,self__.__hash));
});

c2.scale._linear.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5188__auto__,entry__5189__auto__){
var self__ = this;
var this__5188__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5189__auto__)){
return cljs.core._assoc(this__5188__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5189__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5189__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5188__auto____$1,entry__5189__auto__);
}
});

c2.scale._linear.prototype.call = (function (self__,x){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var domain_length = (cljs.core.last(self__.domain) - cljs.core.first(self__.domain));
var range_length = (cljs.core.last(self__.range) - cljs.core.first(self__.range));
return (cljs.core.first(self__.range) + (range_length * ((x - cljs.core.first(self__.domain)) / domain_length)));
});

c2.scale._linear.prototype.apply = (function (self__,args34878){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args34878)));
});

c2.scale._linear.prototype.cljs$core$IFn$_invoke$arity$1 = (function (x){
var self__ = this;
var _ = this;
var domain_length = (cljs.core.last(self__.domain) - cljs.core.first(self__.domain));
var range_length = (cljs.core.last(self__.range) - cljs.core.first(self__.range));
return (cljs.core.first(self__.range) + (range_length * ((x - cljs.core.first(self__.domain)) / domain_length)));
});

c2.scale._linear.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$domain,cljs.core.cst$sym$range], null);
});

c2.scale._linear.cljs$lang$type = true;

c2.scale._linear.cljs$lang$ctorPrSeq = (function (this__5217__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"c2.scale/_linear");
});

c2.scale._linear.cljs$lang$ctorPrWriter = (function (this__5217__auto__,writer__5218__auto__){
return cljs.core._write(writer__5218__auto__,"c2.scale/_linear");
});

c2.scale.__GT__linear = (function c2$scale$__GT__linear(domain,range){
return (new c2.scale._linear(domain,range,null,null,null));
});

c2.scale.map__GT__linear = (function c2$scale$map__GT__linear(G__34877){
return (new c2.scale._linear(cljs.core.cst$kw$domain.cljs$core$IFn$_invoke$arity$1(G__34877),cljs.core.cst$kw$range.cljs$core$IFn$_invoke$arity$1(G__34877),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__34877,cljs.core.cst$kw$domain,cljs.core.array_seq([cljs.core.cst$kw$range], 0)),null));
});


c2.scale.linear = (function c2$scale$linear(var_args){
var args__5634__auto__ = [];
var len__5627__auto___34885 = arguments.length;
var i__5628__auto___34886 = (0);
while(true){
if((i__5628__auto___34886 < len__5627__auto___34885)){
args__5634__auto__.push((arguments[i__5628__auto___34886]));

var G__34887 = (i__5628__auto___34886 + (1));
i__5628__auto___34886 = G__34887;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic = (function (kwargs){
return c2.scale.map__GT__linear(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null)], null),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,kwargs)], 0)));
});

c2.scale.linear.cljs$lang$maxFixedArity = (0);

c2.scale.linear.cljs$lang$applyTo = (function (seq34883){
return c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34883));
});
c2.scale.log;

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
c2.scale._power = (function (domain,range,__meta,__extmap,__hash){
this.domain = domain;
this.range = range;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667595;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
c2.scale._power.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5183__auto__,k__5184__auto__){
var self__ = this;
var this__5183__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__5183__auto____$1,k__5184__auto__,null);
});

c2.scale._power.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5185__auto__,k34889,else__5186__auto__){
var self__ = this;
var this__5185__auto____$1 = this;
var G__34892 = (((k34889 instanceof cljs.core.Keyword))?k34889.fqn:null);
switch (G__34892) {
case "domain":
return self__.domain;

break;
case "range":
return self__.range;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k34889,else__5186__auto__);

}
});

c2.scale._power.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5197__auto__,writer__5198__auto__,opts__5199__auto__){
var self__ = this;
var this__5197__auto____$1 = this;
var pr_pair__5200__auto__ = ((function (this__5197__auto____$1){
return (function (keyval__5201__auto__){
return cljs.core.pr_sequential_writer(writer__5198__auto__,cljs.core.pr_writer,""," ","",opts__5199__auto__,keyval__5201__auto__);
});})(this__5197__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__5198__auto__,pr_pair__5200__auto__,"#c2.scale._power{",", ","}",opts__5199__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$domain,self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$range,self__.range],null))], null),self__.__extmap));
});

c2.scale._power.prototype.cljs$core$IIterable$ = true;

c2.scale._power.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__34888){
var self__ = this;
var G__34888__$1 = this;
return (new cljs.core.RecordIter((0),G__34888__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$domain,cljs.core.cst$kw$range], null),cljs.core._iterator(self__.__extmap)));
});

c2.scale._power.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5181__auto__){
var self__ = this;
var this__5181__auto____$1 = this;
return self__.__meta;
});

c2.scale._power.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5177__auto__){
var self__ = this;
var this__5177__auto____$1 = this;
return (new c2.scale._power(self__.domain,self__.range,self__.__meta,self__.__extmap,self__.__hash));
});

c2.scale._power.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5187__auto__){
var self__ = this;
var this__5187__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

c2.scale._power.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5178__auto__){
var self__ = this;
var this__5178__auto____$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_imap(this__5178__auto____$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

c2.scale._power.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__5179__auto__,other__5180__auto__){
var self__ = this;
var this__5179__auto____$1 = this;
if(cljs.core.truth_((function (){var and__4557__auto__ = other__5180__auto__;
if(cljs.core.truth_(and__4557__auto__)){
var and__4557__auto____$1 = (this__5179__auto____$1.constructor === other__5180__auto__.constructor);
if(and__4557__auto____$1){
return cljs.core.equiv_map(this__5179__auto____$1,other__5180__auto__);
} else {
return and__4557__auto____$1;
}
} else {
return and__4557__auto__;
}
})())){
return true;
} else {
return false;
}
});

c2.scale._power.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5192__auto__,k__5193__auto__){
var self__ = this;
var this__5192__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$domain,null,cljs.core.cst$kw$range,null], null), null),k__5193__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5192__auto____$1),self__.__meta),k__5193__auto__);
} else {
return (new c2.scale._power(self__.domain,self__.range,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5193__auto__)),null));
}
});

c2.scale._power.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5190__auto__,k__5191__auto__,G__34888){
var self__ = this;
var this__5190__auto____$1 = this;
var pred__34893 = cljs.core.keyword_identical_QMARK_;
var expr__34894 = k__5191__auto__;
if(cljs.core.truth_((pred__34893.cljs$core$IFn$_invoke$arity$2 ? pred__34893.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$domain,expr__34894) : pred__34893.call(null,cljs.core.cst$kw$domain,expr__34894)))){
return (new c2.scale._power(G__34888,self__.range,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__34893.cljs$core$IFn$_invoke$arity$2 ? pred__34893.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$range,expr__34894) : pred__34893.call(null,cljs.core.cst$kw$range,expr__34894)))){
return (new c2.scale._power(self__.domain,G__34888,self__.__meta,self__.__extmap,null));
} else {
return (new c2.scale._power(self__.domain,self__.range,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5191__auto__,G__34888),null));
}
}
});

c2.scale._power.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5195__auto__){
var self__ = this;
var this__5195__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$domain,self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$range,self__.range],null))], null),self__.__extmap));
});

c2.scale._power.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5182__auto__,G__34888){
var self__ = this;
var this__5182__auto____$1 = this;
return (new c2.scale._power(self__.domain,self__.range,G__34888,self__.__extmap,self__.__hash));
});

c2.scale._power.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5188__auto__,entry__5189__auto__){
var self__ = this;
var this__5188__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5189__auto__)){
return cljs.core._assoc(this__5188__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5189__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5189__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5188__auto____$1,entry__5189__auto__);
}
});

c2.scale._power.prototype.call = (function (self__,x){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,cljs.core.map.cljs$core$IFn$_invoke$arity$2(c2.maths.expt,self__.domain),cljs.core.cst$kw$range,self__.range], 0)),c2.maths.expt).call(null,x);
});

c2.scale._power.prototype.apply = (function (self__,args34891){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args34891)));
});

c2.scale._power.prototype.cljs$core$IFn$_invoke$arity$1 = (function (x){
var self__ = this;
var _ = this;
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,cljs.core.map.cljs$core$IFn$_invoke$arity$2(c2.maths.expt,self__.domain),cljs.core.cst$kw$range,self__.range], 0)),c2.maths.expt).call(null,x);
});

c2.scale._power.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$domain,cljs.core.cst$sym$range], null);
});

c2.scale._power.cljs$lang$type = true;

c2.scale._power.cljs$lang$ctorPrSeq = (function (this__5217__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"c2.scale/_power");
});

c2.scale._power.cljs$lang$ctorPrWriter = (function (this__5217__auto__,writer__5218__auto__){
return cljs.core._write(writer__5218__auto__,"c2.scale/_power");
});

c2.scale.__GT__power = (function c2$scale$__GT__power(domain,range){
return (new c2.scale._power(domain,range,null,null,null));
});

c2.scale.map__GT__power = (function c2$scale$map__GT__power(G__34890){
return (new c2.scale._power(cljs.core.cst$kw$domain.cljs$core$IFn$_invoke$arity$1(G__34890),cljs.core.cst$kw$range.cljs$core$IFn$_invoke$arity$1(G__34890),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__34890,cljs.core.cst$kw$domain,cljs.core.array_seq([cljs.core.cst$kw$range], 0)),null));
});


c2.scale.power = (function c2$scale$power(var_args){
var args__5634__auto__ = [];
var len__5627__auto___34898 = arguments.length;
var i__5628__auto___34899 = (0);
while(true){
if((i__5628__auto___34899 < len__5627__auto___34898)){
args__5634__auto__.push((arguments[i__5628__auto___34899]));

var G__34900 = (i__5628__auto___34899 + (1));
i__5628__auto___34899 = G__34900;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return c2.scale.power.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

c2.scale.power.cljs$core$IFn$_invoke$arity$variadic = (function (kwargs){
return c2.scale.map__GT__power(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null)], null),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,kwargs)], 0)));
});

c2.scale.power.cljs$lang$maxFixedArity = (0);

c2.scale.power.cljs$lang$applyTo = (function (seq34896){
return c2.scale.power.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34896));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
c2.scale._log = (function (domain,range,__meta,__extmap,__hash){
this.domain = domain;
this.range = range;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667595;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
c2.scale._log.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5183__auto__,k__5184__auto__){
var self__ = this;
var this__5183__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__5183__auto____$1,k__5184__auto__,null);
});

c2.scale._log.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5185__auto__,k34902,else__5186__auto__){
var self__ = this;
var this__5185__auto____$1 = this;
var G__34905 = (((k34902 instanceof cljs.core.Keyword))?k34902.fqn:null);
switch (G__34905) {
case "domain":
return self__.domain;

break;
case "range":
return self__.range;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k34902,else__5186__auto__);

}
});

c2.scale._log.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5197__auto__,writer__5198__auto__,opts__5199__auto__){
var self__ = this;
var this__5197__auto____$1 = this;
var pr_pair__5200__auto__ = ((function (this__5197__auto____$1){
return (function (keyval__5201__auto__){
return cljs.core.pr_sequential_writer(writer__5198__auto__,cljs.core.pr_writer,""," ","",opts__5199__auto__,keyval__5201__auto__);
});})(this__5197__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__5198__auto__,pr_pair__5200__auto__,"#c2.scale._log{",", ","}",opts__5199__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$domain,self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$range,self__.range],null))], null),self__.__extmap));
});

c2.scale._log.prototype.cljs$core$IIterable$ = true;

c2.scale._log.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__34901){
var self__ = this;
var G__34901__$1 = this;
return (new cljs.core.RecordIter((0),G__34901__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$domain,cljs.core.cst$kw$range], null),cljs.core._iterator(self__.__extmap)));
});

c2.scale._log.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5181__auto__){
var self__ = this;
var this__5181__auto____$1 = this;
return self__.__meta;
});

c2.scale._log.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5177__auto__){
var self__ = this;
var this__5177__auto____$1 = this;
return (new c2.scale._log(self__.domain,self__.range,self__.__meta,self__.__extmap,self__.__hash));
});

c2.scale._log.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5187__auto__){
var self__ = this;
var this__5187__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

c2.scale._log.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5178__auto__){
var self__ = this;
var this__5178__auto____$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_imap(this__5178__auto____$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

c2.scale._log.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__5179__auto__,other__5180__auto__){
var self__ = this;
var this__5179__auto____$1 = this;
if(cljs.core.truth_((function (){var and__4557__auto__ = other__5180__auto__;
if(cljs.core.truth_(and__4557__auto__)){
var and__4557__auto____$1 = (this__5179__auto____$1.constructor === other__5180__auto__.constructor);
if(and__4557__auto____$1){
return cljs.core.equiv_map(this__5179__auto____$1,other__5180__auto__);
} else {
return and__4557__auto____$1;
}
} else {
return and__4557__auto__;
}
})())){
return true;
} else {
return false;
}
});

c2.scale._log.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5192__auto__,k__5193__auto__){
var self__ = this;
var this__5192__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$domain,null,cljs.core.cst$kw$range,null], null), null),k__5193__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5192__auto____$1),self__.__meta),k__5193__auto__);
} else {
return (new c2.scale._log(self__.domain,self__.range,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5193__auto__)),null));
}
});

c2.scale._log.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5190__auto__,k__5191__auto__,G__34901){
var self__ = this;
var this__5190__auto____$1 = this;
var pred__34906 = cljs.core.keyword_identical_QMARK_;
var expr__34907 = k__5191__auto__;
if(cljs.core.truth_((pred__34906.cljs$core$IFn$_invoke$arity$2 ? pred__34906.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$domain,expr__34907) : pred__34906.call(null,cljs.core.cst$kw$domain,expr__34907)))){
return (new c2.scale._log(G__34901,self__.range,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__34906.cljs$core$IFn$_invoke$arity$2 ? pred__34906.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$range,expr__34907) : pred__34906.call(null,cljs.core.cst$kw$range,expr__34907)))){
return (new c2.scale._log(self__.domain,G__34901,self__.__meta,self__.__extmap,null));
} else {
return (new c2.scale._log(self__.domain,self__.range,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5191__auto__,G__34901),null));
}
}
});

c2.scale._log.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5195__auto__){
var self__ = this;
var this__5195__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$domain,self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$range,self__.range],null))], null),self__.__extmap));
});

c2.scale._log.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5182__auto__,G__34901){
var self__ = this;
var this__5182__auto____$1 = this;
return (new c2.scale._log(self__.domain,self__.range,G__34901,self__.__extmap,self__.__hash));
});

c2.scale._log.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5188__auto__,entry__5189__auto__){
var self__ = this;
var this__5188__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5189__auto__)){
return cljs.core._assoc(this__5188__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5189__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5189__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5188__auto____$1,entry__5189__auto__);
}
});

c2.scale._log.prototype.call = (function (self__,x){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,cljs.core.map.cljs$core$IFn$_invoke$arity$2(c2.maths.log,self__.domain),cljs.core.cst$kw$range,self__.range], 0)),c2.maths.log).call(null,x);
});

c2.scale._log.prototype.apply = (function (self__,args34904){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args34904)));
});

c2.scale._log.prototype.cljs$core$IFn$_invoke$arity$1 = (function (x){
var self__ = this;
var _ = this;
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,cljs.core.map.cljs$core$IFn$_invoke$arity$2(c2.maths.log,self__.domain),cljs.core.cst$kw$range,self__.range], 0)),c2.maths.log).call(null,x);
});

c2.scale._log.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$domain,cljs.core.cst$sym$range], null);
});

c2.scale._log.cljs$lang$type = true;

c2.scale._log.cljs$lang$ctorPrSeq = (function (this__5217__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"c2.scale/_log");
});

c2.scale._log.cljs$lang$ctorPrWriter = (function (this__5217__auto__,writer__5218__auto__){
return cljs.core._write(writer__5218__auto__,"c2.scale/_log");
});

c2.scale.__GT__log = (function c2$scale$__GT__log(domain,range){
return (new c2.scale._log(domain,range,null,null,null));
});

c2.scale.map__GT__log = (function c2$scale$map__GT__log(G__34903){
return (new c2.scale._log(cljs.core.cst$kw$domain.cljs$core$IFn$_invoke$arity$1(G__34903),cljs.core.cst$kw$range.cljs$core$IFn$_invoke$arity$1(G__34903),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__34903,cljs.core.cst$kw$domain,cljs.core.array_seq([cljs.core.cst$kw$range], 0)),null));
});


c2.scale.log = (function c2$scale$log(var_args){
var args__5634__auto__ = [];
var len__5627__auto___34911 = arguments.length;
var i__5628__auto___34912 = (0);
while(true){
if((i__5628__auto___34912 < len__5627__auto___34911)){
args__5634__auto__.push((arguments[i__5628__auto___34912]));

var G__34913 = (i__5628__auto___34912 + (1));
i__5628__auto___34912 = G__34913;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return c2.scale.log.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

c2.scale.log.cljs$core$IFn$_invoke$arity$variadic = (function (kwargs){
return c2.scale.map__GT__log(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(10)], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null)], null),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,kwargs)], 0)));
});

c2.scale.log.cljs$lang$maxFixedArity = (0);

c2.scale.log.cljs$lang$applyTo = (function (seq34909){
return c2.scale.log.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34909));
});
