// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('c2.maths');
goog.require('cljs.core');
c2.maths.Pi = Math.PI;
c2.maths.Tau = ((2) * c2.maths.Pi);
c2.maths.e = Math.E;
c2.maths.radians_per_degree = (c2.maths.Pi / (180));
c2.maths.rad = (function c2$maths$rad(x){
return (c2.maths.radians_per_degree * x);
});
c2.maths.deg = (function c2$maths$deg(x){
return (x / c2.maths.radians_per_degree);
});
c2.maths.sin = (function c2$maths$sin(x){
return Math.sin(x);
});
c2.maths.asin = (function c2$maths$asin(x){
return Math.asin(x);
});
c2.maths.cos = (function c2$maths$cos(x){
return Math.cos(x);
});
c2.maths.acos = (function c2$maths$acos(x){
return Math.acos(x);
});
c2.maths.tan = (function c2$maths$tan(x){
return Math.tan(x);
});
c2.maths.atan = (function c2$maths$atan(x){
return Math.atan(x);
});
c2.maths.expt = (function c2$maths$expt(var_args){
var args34916 = [];
var len__5627__auto___34919 = arguments.length;
var i__5628__auto___34920 = (0);
while(true){
if((i__5628__auto___34920 < len__5627__auto___34919)){
args34916.push((arguments[i__5628__auto___34920]));

var G__34921 = (i__5628__auto___34920 + (1));
i__5628__auto___34920 = G__34921;
continue;
} else {
}
break;
}

var G__34918 = args34916.length;
switch (G__34918) {
case 1:
return c2.maths.expt.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.maths.expt.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34916.length)].join('')));

}
});

c2.maths.expt.cljs$core$IFn$_invoke$arity$1 = (function (x){
return Math.exp(x);
});

c2.maths.expt.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return Math.pow(x,y);
});

c2.maths.expt.cljs$lang$maxFixedArity = 2;
c2.maths.sq = (function c2$maths$sq(x){
return c2.maths.expt.cljs$core$IFn$_invoke$arity$2(x,(2));
});
c2.maths.sqrt = (function c2$maths$sqrt(x){
return Math.sqrt(x);
});
c2.maths.floor = (function c2$maths$floor(x){
return Math.floor(x);
});
c2.maths.ceil = (function c2$maths$ceil(x){
return Math.ceil(x);
});
c2.maths.abs = (function c2$maths$abs(x){
return Math.abs(x);
});
c2.maths.log = (function c2$maths$log(var_args){
var args34923 = [];
var len__5627__auto___34926 = arguments.length;
var i__5628__auto___34927 = (0);
while(true){
if((i__5628__auto___34927 < len__5627__auto___34926)){
args34923.push((arguments[i__5628__auto___34927]));

var G__34928 = (i__5628__auto___34927 + (1));
i__5628__auto___34927 = G__34928;
continue;
} else {
}
break;
}

var G__34925 = args34923.length;
switch (G__34925) {
case 1:
return c2.maths.log.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.maths.log.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34923.length)].join('')));

}
});

c2.maths.log.cljs$core$IFn$_invoke$arity$1 = (function (x){
return Math.log(x);
});

c2.maths.log.cljs$core$IFn$_invoke$arity$2 = (function (base,x){
return (Math.log(x) / Math.log(base));
});

c2.maths.log.cljs$lang$maxFixedArity = 2;
c2.maths.log10 = (function c2$maths$log10(x){
return (Math.log(x) / Math.LN10);
});
/**
 * Returns 2-vector of min and max elements in xs.
 */
c2.maths.extent = (function c2$maths$extent(xs){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,xs),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,xs)], null);
});
/**
 * Arithemetic mean of collection
 */
c2.maths.mean = (function c2$maths$mean(xs){
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,xs) / cljs.core.count(xs));
});
/**
 * Median of a collection.
 */
c2.maths.median = (function c2$maths$median(xs){
var sorted = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(xs);
var n = cljs.core.count(xs);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(1))){
return cljs.core.first(sorted);
} else {
if(cljs.core.odd_QMARK_(n)){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(sorted,((n + (1)) / (2)));
} else {
var mid = (n / (2));
return c2.maths.mean(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.nth.cljs$core$IFn$_invoke$arity$2(sorted,c2.maths.floor(mid)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(sorted,c2.maths.ceil(mid))], null));

}
}
});
/**
 * Inclusive range; same as core/range, but includes the end.
 */
c2.maths.irange = (function c2$maths$irange(var_args){
var args34930 = [];
var len__5627__auto___34933 = arguments.length;
var i__5628__auto___34934 = (0);
while(true){
if((i__5628__auto___34934 < len__5627__auto___34933)){
args34930.push((arguments[i__5628__auto___34934]));

var G__34935 = (i__5628__auto___34934 + (1));
i__5628__auto___34934 = G__34935;
continue;
} else {
}
break;
}

var G__34932 = args34930.length;
switch (G__34932) {
case 1:
return c2.maths.irange.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.maths.irange.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.maths.irange.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34930.length)].join('')));

}
});

c2.maths.irange.cljs$core$IFn$_invoke$arity$1 = (function (start){
return cljs.core.range.cljs$core$IFn$_invoke$arity$1(start);
});

c2.maths.irange.cljs$core$IFn$_invoke$arity$2 = (function (start,end){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.range.cljs$core$IFn$_invoke$arity$2(start,end),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [end], null));
});

c2.maths.irange.cljs$core$IFn$_invoke$arity$3 = (function (start,end,step){
var r = cljs.core.range.cljs$core$IFn$_invoke$arity$3(start,end,step);
if((cljs.core.mod(cljs.core.first(r),step) === cljs.core.mod(end,step))){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(r,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [end], null));
} else {
return r;
}
});

c2.maths.irange.cljs$lang$maxFixedArity = 3;
/**
 * Checks if bottom <= x <= top.
 */
c2.maths.within_QMARK_ = (function c2$maths$within_QMARK_(x,p__34937){
var vec__34939 = p__34937;
var bottom = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34939,(0),null);
var top = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34939,(1),null);
return ((bottom <= x)) && ((x <= top));
});
c2.maths.add = (function c2$maths$add(var_args){
var args__5634__auto__ = [];
var len__5627__auto___34941 = arguments.length;
var i__5628__auto___34942 = (0);
while(true){
if((i__5628__auto___34942 < len__5627__auto___34941)){
args__5634__auto__.push((arguments[i__5628__auto___34942]));

var G__34943 = (i__5628__auto___34942 + (1));
i__5628__auto___34942 = G__34943;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return c2.maths.add.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

c2.maths.add.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A + B);
} else {
if((cljs.core.coll_QMARK_(A)) && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,cljs.core.replicate(cljs.core.count(B),A),B);
} else {
if((cljs.core.coll_QMARK_(A)) && (typeof B === 'number')){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,A,cljs.core.replicate(cljs.core.count(A),B));
} else {
return null;
}
}
}
}
}),args);
});

c2.maths.add.cljs$lang$maxFixedArity = (0);

c2.maths.add.cljs$lang$applyTo = (function (seq34940){
return c2.maths.add.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34940));
});
c2.maths.sub = (function c2$maths$sub(var_args){
var args__5634__auto__ = [];
var len__5627__auto___34945 = arguments.length;
var i__5628__auto___34946 = (0);
while(true){
if((i__5628__auto___34946 < len__5627__auto___34945)){
args__5634__auto__.push((arguments[i__5628__auto___34946]));

var G__34947 = (i__5628__auto___34946 + (1));
i__5628__auto___34946 = G__34947;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return c2.maths.sub.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

c2.maths.sub.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(args),(1))){
if((typeof (0) === 'number') && (typeof cljs.core.first(args) === 'number')){
return ((0) - cljs.core.first(args));
} else {
if((cljs.core.coll_QMARK_((0))) && (cljs.core.coll_QMARK_(cljs.core.first(args)))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,(0),cljs.core.first(args));
} else {
if((typeof (0) === 'number') && (cljs.core.coll_QMARK_(cljs.core.first(args)))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,cljs.core.replicate(cljs.core.count(cljs.core.first(args)),(0)),cljs.core.first(args));
} else {
if((cljs.core.coll_QMARK_((0))) && (typeof cljs.core.first(args) === 'number')){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,(0),cljs.core.replicate(cljs.core.count((0)),cljs.core.first(args)));
} else {
return null;
}
}
}
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A - B);
} else {
if((cljs.core.coll_QMARK_(A)) && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,cljs.core.replicate(cljs.core.count(B),A),B);
} else {
if((cljs.core.coll_QMARK_(A)) && (typeof B === 'number')){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,A,cljs.core.replicate(cljs.core.count(A),B));
} else {
return null;
}
}
}
}
}),args);
}
});

c2.maths.sub.cljs$lang$maxFixedArity = (0);

c2.maths.sub.cljs$lang$applyTo = (function (seq34944){
return c2.maths.sub.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34944));
});
c2.maths.mul = (function c2$maths$mul(var_args){
var args__5634__auto__ = [];
var len__5627__auto___34949 = arguments.length;
var i__5628__auto___34950 = (0);
while(true){
if((i__5628__auto___34950 < len__5627__auto___34949)){
args__5634__auto__.push((arguments[i__5628__auto___34950]));

var G__34951 = (i__5628__auto___34950 + (1));
i__5628__auto___34950 = G__34951;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return c2.maths.mul.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

c2.maths.mul.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A * B);
} else {
if((cljs.core.coll_QMARK_(A)) && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,cljs.core.replicate(cljs.core.count(B),A),B);
} else {
if((cljs.core.coll_QMARK_(A)) && (typeof B === 'number')){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,A,cljs.core.replicate(cljs.core.count(A),B));
} else {
return null;
}
}
}
}
}),args);
});

c2.maths.mul.cljs$lang$maxFixedArity = (0);

c2.maths.mul.cljs$lang$applyTo = (function (seq34948){
return c2.maths.mul.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34948));
});
c2.maths.div = (function c2$maths$div(var_args){
var args__5634__auto__ = [];
var len__5627__auto___34953 = arguments.length;
var i__5628__auto___34954 = (0);
while(true){
if((i__5628__auto___34954 < len__5627__auto___34953)){
args__5634__auto__.push((arguments[i__5628__auto___34954]));

var G__34955 = (i__5628__auto___34954 + (1));
i__5628__auto___34954 = G__34955;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return c2.maths.div.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

c2.maths.div.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(args),(1))){
if((typeof (1) === 'number') && (typeof cljs.core.first(args) === 'number')){
return ((1) / cljs.core.first(args));
} else {
if((cljs.core.coll_QMARK_((1))) && (cljs.core.coll_QMARK_(cljs.core.first(args)))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,(1),cljs.core.first(args));
} else {
if((typeof (1) === 'number') && (cljs.core.coll_QMARK_(cljs.core.first(args)))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,cljs.core.replicate(cljs.core.count(cljs.core.first(args)),(1)),cljs.core.first(args));
} else {
if((cljs.core.coll_QMARK_((1))) && (typeof cljs.core.first(args) === 'number')){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,(1),cljs.core.replicate(cljs.core.count((1)),cljs.core.first(args)));
} else {
return null;
}
}
}
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A / B);
} else {
if((cljs.core.coll_QMARK_(A)) && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,cljs.core.replicate(cljs.core.count(B),A),B);
} else {
if((cljs.core.coll_QMARK_(A)) && (typeof B === 'number')){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,A,cljs.core.replicate(cljs.core.count(A),B));
} else {
return null;
}
}
}
}
}),args);
}
});

c2.maths.div.cljs$lang$maxFixedArity = (0);

c2.maths.div.cljs$lang$applyTo = (function (seq34952){
return c2.maths.div.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34952));
});
/**
 * Returns the quantiles of a dataset.
 * 
 * Kwargs:
 * 
 *   > *:probs*: ntiles of the data to return, defaults to `[0 0.25 0.5 0.75 1]`
 * 
 *   Algorithm is the same as R's quantile type=7.
 *   Transcribed from Jason Davies; https://github.com/jasondavies/science.js/blob/master/src/stats/quantiles.js
 */
c2.maths.quantile = (function c2$maths$quantile(var_args){
var args__5634__auto__ = [];
var len__5627__auto___34971 = arguments.length;
var i__5628__auto___34972 = (0);
while(true){
if((i__5628__auto___34972 < len__5627__auto___34971)){
args__5634__auto__.push((arguments[i__5628__auto___34972]));

var G__34973 = (i__5628__auto___34972 + (1));
i__5628__auto___34972 = G__34973;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return c2.maths.quantile.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

c2.maths.quantile.cljs$core$IFn$_invoke$arity$variadic = (function (data,p__34958){
var map__34959 = p__34958;
var map__34959__$1 = ((((!((map__34959 == null)))?((((map__34959.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34959.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34959):map__34959);
var probs = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34959__$1,cljs.core.cst$kw$probs,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),0.25,0.5,0.75,(1)], null));
var xs = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.sort.cljs$core$IFn$_invoke$arity$1(data));
var n_1 = (cljs.core.count(xs) - (1));
var iter__5341__auto__ = ((function (xs,n_1,map__34959,map__34959__$1,probs){
return (function c2$maths$iter__34961(s__34962){
return (new cljs.core.LazySeq(null,((function (xs,n_1,map__34959,map__34959__$1,probs){
return (function (){
var s__34962__$1 = s__34962;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__34962__$1);
if(temp__4425__auto__){
var s__34962__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34962__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__34962__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__34964 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__34963 = (0);
while(true){
if((i__34963 < size__5340__auto__)){
var q = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__34963);
cljs.core.chunk_append(b__34964,(function (){var index = ((q * n_1) + (1));
var lo = (c2.maths.floor(index) | (0));
var h = (index - lo);
var a = (function (){var G__34969 = (lo - (1));
return (xs.cljs$core$IFn$_invoke$arity$1 ? xs.cljs$core$IFn$_invoke$arity$1(G__34969) : xs.call(null,G__34969));
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(h,(0))){
return a;
} else {
return (a + (h * ((xs.cljs$core$IFn$_invoke$arity$1 ? xs.cljs$core$IFn$_invoke$arity$1(lo) : xs.call(null,lo)) - a)));
}
})());

var G__34974 = (i__34963 + (1));
i__34963 = G__34974;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34964),c2$maths$iter__34961(cljs.core.chunk_rest(s__34962__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34964),null);
}
} else {
var q = cljs.core.first(s__34962__$2);
return cljs.core.cons((function (){var index = ((q * n_1) + (1));
var lo = (c2.maths.floor(index) | (0));
var h = (index - lo);
var a = (function (){var G__34970 = (lo - (1));
return (xs.cljs$core$IFn$_invoke$arity$1 ? xs.cljs$core$IFn$_invoke$arity$1(G__34970) : xs.call(null,G__34970));
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(h,(0))){
return a;
} else {
return (a + (h * ((xs.cljs$core$IFn$_invoke$arity$1 ? xs.cljs$core$IFn$_invoke$arity$1(lo) : xs.call(null,lo)) - a)));
}
})(),c2$maths$iter__34961(cljs.core.rest(s__34962__$2)));
}
} else {
return null;
}
break;
}
});})(xs,n_1,map__34959,map__34959__$1,probs))
,null,null));
});})(xs,n_1,map__34959,map__34959__$1,probs))
;
return iter__5341__auto__(probs);
});

c2.maths.quantile.cljs$lang$maxFixedArity = (1);

c2.maths.quantile.cljs$lang$applyTo = (function (seq34956){
var G__34957 = cljs.core.first(seq34956);
var seq34956__$1 = cljs.core.next(seq34956);
return c2.maths.quantile.cljs$core$IFn$_invoke$arity$variadic(G__34957,seq34956__$1);
});
