// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('c2.layout.histogram');
goog.require('cljs.core');
goog.require('c2.maths');
c2.layout.histogram.binary_search = (function c2$layout$histogram$binary_search(v,target){

var low = (0);
var high = (cljs.core.count(v) - (1));
while(true){
if((low > high)){
return (- (low + (1)));
} else {
var mid = cljs.core.quot((low + high),(2));
var mid_val = (v.cljs$core$IFn$_invoke$arity$1 ? v.cljs$core$IFn$_invoke$arity$1(mid) : v.call(null,mid));
if((mid_val < target)){
var G__42904 = (mid + (1));
var G__42905 = high;
low = G__42904;
high = G__42905;
continue;
} else {
if((target < mid_val)){
var G__42906 = low;
var G__42907 = (mid - (1));
low = G__42906;
high = G__42907;
continue;
} else {
return mid;

}
}
}
break;
}
});
/**
 * Calulate reasonable number of bins assuming an approximately normal
 *   distribution
 */
c2.layout.histogram.sturges = (function c2$layout$histogram$sturges(values){
return ((c2.maths.log.cljs$core$IFn$_invoke$arity$2(cljs.core.count(values),(2)) | (0)) + (1));
});
/**
 * Return the inclusive upper threshold of all bins
 */
c2.layout.histogram.fixed_size_bins = (function c2$layout$histogram$fixed_size_bins(p__42908,n){
var vec__42916 = p__42908;
var mn = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42916,(0),null);
var mx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42916,(1),null);
var size = ((mx - mn) / n);
return cljs.core.vec((function (){var iter__5341__auto__ = ((function (size,vec__42916,mn,mx){
return (function c2$layout$histogram$fixed_size_bins_$_iter__42917(s__42918){
return (new cljs.core.LazySeq(null,((function (size,vec__42916,mn,mx){
return (function (){
var s__42918__$1 = s__42918;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__42918__$1);
if(temp__4425__auto__){
var s__42918__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__42918__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__42918__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__42920 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__42919 = (0);
while(true){
if((i__42919 < size__5340__auto__)){
var step = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__42919);
cljs.core.chunk_append(b__42920,(mn + (size * step)));

var G__42923 = (i__42919 + (1));
i__42919 = G__42923;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__42920),c2$layout$histogram$fixed_size_bins_$_iter__42917(cljs.core.chunk_rest(s__42918__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__42920),null);
}
} else {
var step = cljs.core.first(s__42918__$2);
return cljs.core.cons((mn + (size * step)),c2$layout$histogram$fixed_size_bins_$_iter__42917(cljs.core.rest(s__42918__$2)));
}
} else {
return null;
}
break;
}
});})(size,vec__42916,mn,mx))
,null,null));
});})(size,vec__42916,mn,mx))
;
return iter__5341__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1((n + (1))));
})());
});
/**
 * The histogram layout transforms data by grouping descrete data points into
 *   bins. Returns a collection of values with the following metadata set:
 * 
 *   > *:x* the lower bound of the bin (inclusive).
 * 
 *   > *:dx* the width of the bin; x + dx is the upper bound (exclusive).
 * 
 *   > *:y* the count
 * 
 * Kwargs:
 * 
 * > *:value* fn that calculates value of node, defaults to `:value`
 * 
 * > *:index* opaque value passed to `:bins` and `:range`
 * 
 * > *:range* fn which calculates the minimum and maximum values given the array of values
 * 
 * > *:bins* Number of bins /or/ fn that takes the range, array of values, and current index
 */
c2.layout.histogram.histogram = (function c2$layout$histogram$histogram(var_args){
var args__5634__auto__ = [];
var len__5627__auto___42932 = arguments.length;
var i__5628__auto___42933 = (0);
while(true){
if((i__5628__auto___42933 < len__5627__auto___42932)){
args__5634__auto__.push((arguments[i__5628__auto___42933]));

var G__42934 = (i__5628__auto___42933 + (1));
i__5628__auto___42933 = G__42934;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return c2.layout.histogram.histogram.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

c2.layout.histogram.histogram.cljs$core$IFn$_invoke$arity$variadic = (function (data,p__42926){
var map__42927 = p__42926;
var map__42927__$1 = ((((!((map__42927 == null)))?((((map__42927.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42927.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42927):map__42927);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__42927__$1,cljs.core.cst$kw$value,cljs.core.cst$kw$value);
var index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42927__$1,cljs.core.cst$kw$index);
var range = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__42927__$1,cljs.core.cst$kw$range,((function (map__42927,map__42927__$1,value,index){
return (function (xs,_){
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.reduce,cljs.core.min),cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.reduce,cljs.core.max)).call(null,xs);
});})(map__42927,map__42927__$1,value,index))
);
var bins = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__42927__$1,cljs.core.cst$kw$bins,((function (map__42927,map__42927__$1,value,index,range){
return (function (r,xs,_){
return c2.layout.histogram.fixed_size_bins(r,c2.layout.histogram.sturges(xs));
});})(map__42927,map__42927__$1,value,index,range))
);
var values = cljs.core.map.cljs$core$IFn$_invoke$arity$2(value,data);
var r = ((cljs.core.fn_QMARK_(range))?(range.cljs$core$IFn$_invoke$arity$2 ? range.cljs$core$IFn$_invoke$arity$2(values,index) : range.call(null,values,index)):range
);
var thresholds = ((cljs.core.fn_QMARK_(bins))?(bins.cljs$core$IFn$_invoke$arity$3 ? bins.cljs$core$IFn$_invoke$arity$3(r,values,index) : bins.call(null,r,values,index)):((typeof bins === 'number')?c2.layout.histogram.fixed_size_bins(r,bins):bins
));
var binner = ((function (values,r,thresholds,map__42927,map__42927__$1,value,index,range,bins){
return (function (e){
return ((function (){var G__42929 = (c2.layout.histogram.binary_search(cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(thresholds,(0),(cljs.core.count(thresholds) - (1))),(value.cljs$core$IFn$_invoke$arity$1 ? value.cljs$core$IFn$_invoke$arity$1(e) : value.call(null,e))) + (1));
return Math.abs(G__42929);
})() - (1));
});})(values,r,thresholds,map__42927,map__42927__$1,value,index,range,bins))
;
var groups = cljs.core.group_by(binner,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (values,r,thresholds,binner,map__42927,map__42927__$1,value,index,range,bins){
return (function (p1__109951_SHARP_){
return (((value.cljs$core$IFn$_invoke$arity$1 ? value.cljs$core$IFn$_invoke$arity$1(p1__109951_SHARP_) : value.call(null,p1__109951_SHARP_)) >= (r.cljs$core$IFn$_invoke$arity$1 ? r.cljs$core$IFn$_invoke$arity$1((0)) : r.call(null,(0))))) && (((value.cljs$core$IFn$_invoke$arity$1 ? value.cljs$core$IFn$_invoke$arity$1(p1__109951_SHARP_) : value.call(null,p1__109951_SHARP_)) <= (r.cljs$core$IFn$_invoke$arity$1 ? r.cljs$core$IFn$_invoke$arity$1((1)) : r.call(null,(1)))));
});})(values,r,thresholds,binner,map__42927,map__42927__$1,value,index,range,bins))
,data));
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (values,r,thresholds,binner,groups,map__42927,map__42927__$1,value,index,range,bins){
return (function (index__$1,p__42930){
var vec__42931 = p__42930;
var mn = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42931,(0),null);
var mx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42931,(1),null);
var group = (function (){var or__4569__auto__ = (groups.cljs$core$IFn$_invoke$arity$1 ? groups.cljs$core$IFn$_invoke$arity$1(index__$1) : groups.call(null,index__$1));
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})();
return cljs.core.with_meta(group,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$x,mn,cljs.core.cst$kw$dx,(mx - mn),cljs.core.cst$kw$y,cljs.core.count(group)], null));
});})(values,r,thresholds,binner,groups,map__42927,map__42927__$1,value,index,range,bins))
,cljs.core.partition.cljs$core$IFn$_invoke$arity$3((2),(1),thresholds));
});

c2.layout.histogram.histogram.cljs$lang$maxFixedArity = (1);

c2.layout.histogram.histogram.cljs$lang$applyTo = (function (seq42924){
var G__42925 = cljs.core.first(seq42924);
var seq42924__$1 = cljs.core.next(seq42924);
return c2.layout.histogram.histogram.cljs$core$IFn$_invoke$arity$variadic(G__42925,seq42924__$1);
});
