// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('c2.dom');
goog.require('cljs.core');
goog.require('goog.dom.forms');
goog.require('goog.dom');
goog.require('goog.dom.classes');
goog.require('singult.core');
goog.require('goog.style');
goog.require('clojure.string');
Element.prototype.matchesSelector = Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || Element.prototype.oMatchesSelector;
if(cljs.core.truth_(typeof NodeList != "undefined")){
NodeList.prototype.cljs$core$ISeqable$ = true;

NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(array__$1,(0));
});
} else {
}
HTMLCollection.prototype.cljs$core$ISeqable$ = true;

HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(array__$1,(0));
});
c2.dom.select;

/**
 * @interface
 */
c2.dom.IDom = function(){};

/**
 * Converts x to a live DOM node
 */
c2.dom.__GT_dom = (function c2$dom$__GT_dom(x){
if((!((x == null))) && (!((x.c2$dom$IDom$__GT_dom$arity$1 == null)))){
return x.c2$dom$IDom$__GT_dom$arity$1(x);
} else {
var x__5224__auto__ = (((x == null))?null:x);
var m__5225__auto__ = (c2.dom.__GT_dom[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__5225__auto__.call(null,x));
} else {
var m__5225__auto____$1 = (c2.dom.__GT_dom["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__5225__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("IDom.->dom",x);
}
}
}
});

(c2.dom.IDom["string"] = true);

(c2.dom.__GT_dom["string"] = (function (selector){
return (c2.dom.select.cljs$core$IFn$_invoke$arity$1 ? c2.dom.select.cljs$core$IFn$_invoke$arity$1(selector) : c2.dom.select.call(null,selector));
}));

cljs.core.PersistentVector.prototype.c2$dom$IDom$ = true;

cljs.core.PersistentVector.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (v){
var v__$1 = this;
return singult.core.render(v__$1);
});
if(cljs.core.truth_(typeof Node != "undefined")){
Node.prototype.c2$dom$IDom$ = true;

Node.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (node){
var node__$1 = this;
return node__$1;
});
} else {
}
/**
 * Select a single DOM node via CSS selector, optionally scoped by second arg.
 */
c2.dom.select = (function c2$dom$select(var_args){
var args42746 = [];
var len__5627__auto___42749 = arguments.length;
var i__5628__auto___42750 = (0);
while(true){
if((i__5628__auto___42750 < len__5627__auto___42749)){
args42746.push((arguments[i__5628__auto___42750]));

var G__42751 = (i__5628__auto___42750 + (1));
i__5628__auto___42750 = G__42751;
continue;
} else {
}
break;
}

var G__42748 = args42746.length;
switch (G__42748) {
case 1:
return c2.dom.select.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42746.length)].join('')));

}
});

c2.dom.select.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelector(selector);
});

c2.dom.select.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom(container).querySelector(selector);
});

c2.dom.select.cljs$lang$maxFixedArity = 2;
/**
 * Like select, but returns a collection of nodes.
 */
c2.dom.select_all = (function c2$dom$select_all(var_args){
var args42753 = [];
var len__5627__auto___42756 = arguments.length;
var i__5628__auto___42757 = (0);
while(true){
if((i__5628__auto___42757 < len__5627__auto___42756)){
args42753.push((arguments[i__5628__auto___42757]));

var G__42758 = (i__5628__auto___42757 + (1));
i__5628__auto___42757 = G__42758;
continue;
} else {
}
break;
}

var G__42755 = args42753.length;
switch (G__42755) {
case 1:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42753.length)].join('')));

}
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelectorAll(selector);
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom(container).querySelectorAll(selector);
});

c2.dom.select_all.cljs$lang$maxFixedArity = 2;
/**
 * Does live `node` match CSS `selector`?
 */
c2.dom.matches_selector_QMARK_ = (function c2$dom$matches_selector_QMARK_(node,selector){
if(cljs.core.truth_(node)){
return node.matchesSelector(selector);
} else {
return null;
}
});
/**
 * Return the children of a live DOM element.
 */
c2.dom.children = (function c2$dom$children(node){
if(cljs.core.truth_(node)){
return c2.dom.__GT_dom(node).children;
} else {
return null;
}
});
/**
 * Return parent of a live DOM node.
 */
c2.dom.parent = (function c2$dom$parent(node){
if(cljs.core.truth_(c2$dom$parent)){
return c2.dom.__GT_dom(node).parentNode;
} else {
return null;
}
});
/**
 * Make element last child of container.
 * Returns live child.
 */
c2.dom.append_BANG_ = (function c2$dom$append_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom(el);
var G__42762_42764 = c2.dom.__GT_dom(container);
var G__42763_42765 = el__$1;
goog.dom.appendChild(G__42762_42764,G__42763_42765);

return el__$1;
});
/**
 * Make element first child of container.
 * Returns live DOM child.
 */
c2.dom.prepend_BANG_ = (function c2$dom$prepend_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom(el);
var G__42769_42772 = c2.dom.__GT_dom(container);
var G__42770_42773 = el__$1;
var G__42771_42774 = (0);
goog.dom.insertChildAt(G__42769_42772,G__42770_42773,G__42771_42774);

return el__$1;
});
/**
 * Remove element from DOM and return it.
 * > *el* CSS selector or live DOM node
 */
c2.dom.remove_BANG_ = (function c2$dom$remove_BANG_(el){
var G__42776 = c2.dom.__GT_dom(el);
return goog.dom.removeNode(G__42776);
});
/**
 * Replace live DOM node with a new one, returning the latter.
 * > *old* CSS selector or live DOM node
 * > *new* CSS selector, live DOM node, or hiccup vector
 */
c2.dom.replace_BANG_ = (function c2$dom$replace_BANG_(old,new$){
var new$__$1 = c2.dom.__GT_dom(new$);
var G__42779_42781 = new$__$1;
var G__42780_42782 = c2.dom.__GT_dom(old);
goog.dom.replaceNode(G__42779_42781,G__42780_42782);

return new$__$1;
});
/**
 * Get or set inline element style.
 * 
 * `(style el)`                map of inline element styles
 * 
 * `(style el :keyword)`       value of style :keyword
 * 
 * `(style el {:keyword val})` sets inline style according to map, returns element
 * 
 * `(style el :keyword val)`   sets single style, returns element
 */
c2.dom.style = (function c2$dom$style(var_args){
var args42783 = [];
var len__5627__auto___42797 = arguments.length;
var i__5628__auto___42798 = (0);
while(true){
if((i__5628__auto___42798 < len__5627__auto___42797)){
args42783.push((arguments[i__5628__auto___42798]));

var G__42799 = (i__5628__auto___42798 + (1));
i__5628__auto___42798 = G__42799;
continue;
} else {
}
break;
}

var G__42785 = args42783.length;
switch (G__42785) {
case 1:
return c2.dom.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.style.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42783.length)].join('')));

}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$1 = (function (el){
throw (new Error("TODO: return map of element styles"));
});

c2.dom.style.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom(el);
if((x instanceof cljs.core.Keyword)){
var G__42786 = el__$1;
var G__42787 = cljs.core.name(x);
return goog.style.getComputedStyle(G__42786,G__42787);
} else {
if(cljs.core.map_QMARK_(x)){
var seq__42788_42801 = cljs.core.seq(x);
var chunk__42789_42802 = null;
var count__42790_42803 = (0);
var i__42791_42804 = (0);
while(true){
if((i__42791_42804 < count__42790_42803)){
var vec__42792_42805 = chunk__42789_42802.cljs$core$IIndexed$_nth$arity$2(null,i__42791_42804);
var k_42806 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42792_42805,(0),null);
var v_42807 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42792_42805,(1),null);
c2.dom.style.cljs$core$IFn$_invoke$arity$3(el__$1,k_42806,v_42807);

var G__42808 = seq__42788_42801;
var G__42809 = chunk__42789_42802;
var G__42810 = count__42790_42803;
var G__42811 = (i__42791_42804 + (1));
seq__42788_42801 = G__42808;
chunk__42789_42802 = G__42809;
count__42790_42803 = G__42810;
i__42791_42804 = G__42811;
continue;
} else {
var temp__4425__auto___42812 = cljs.core.seq(seq__42788_42801);
if(temp__4425__auto___42812){
var seq__42788_42813__$1 = temp__4425__auto___42812;
if(cljs.core.chunked_seq_QMARK_(seq__42788_42813__$1)){
var c__5372__auto___42814 = cljs.core.chunk_first(seq__42788_42813__$1);
var G__42815 = cljs.core.chunk_rest(seq__42788_42813__$1);
var G__42816 = c__5372__auto___42814;
var G__42817 = cljs.core.count(c__5372__auto___42814);
var G__42818 = (0);
seq__42788_42801 = G__42815;
chunk__42789_42802 = G__42816;
count__42790_42803 = G__42817;
i__42791_42804 = G__42818;
continue;
} else {
var vec__42793_42819 = cljs.core.first(seq__42788_42813__$1);
var k_42820 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42793_42819,(0),null);
var v_42821 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42793_42819,(1),null);
c2.dom.style.cljs$core$IFn$_invoke$arity$3(el__$1,k_42820,v_42821);

var G__42822 = cljs.core.next(seq__42788_42813__$1);
var G__42823 = null;
var G__42824 = (0);
var G__42825 = (0);
seq__42788_42801 = G__42822;
chunk__42789_42802 = G__42823;
count__42790_42803 = G__42824;
i__42791_42804 = G__42825;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var G__42794_42826 = c2.dom.__GT_dom(el);
var G__42795_42827 = cljs.core.name(k);
var G__42796_42828 = ((typeof v === 'string')?v:((typeof v === 'number')?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$bottom,null,cljs.core.cst$kw$top,null,cljs.core.cst$kw$width,null,cljs.core.cst$kw$right,null,cljs.core.cst$kw$height,null,cljs.core.cst$kw$left,null], null), null).call(null,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k)))?[cljs.core.str(v),cljs.core.str("px")].join(''):v):null));
goog.style.setStyle(G__42794_42826,G__42795_42827,G__42796_42828);

return el;
});

c2.dom.style.cljs$lang$maxFixedArity = 3;
/**
 * Get or set element attributes.
 * 
 * `(attr el)`                map of element attributes
 * 
 * `(attr el :keyword)`       value of attr :keyword
 * 
 * `(attr el {:keyword val})` sets element attributes according to map, returns element
 * 
 * `(attr el :keyword val)`   sets single attr, returns element
 */
c2.dom.attr = (function c2$dom$attr(var_args){
var args42829 = [];
var len__5627__auto___42844 = arguments.length;
var i__5628__auto___42845 = (0);
while(true){
if((i__5628__auto___42845 < len__5627__auto___42844)){
args42829.push((arguments[i__5628__auto___42845]));

var G__42846 = (i__5628__auto___42845 + (1));
i__5628__auto___42845 = G__42846;
continue;
} else {
}
break;
}

var G__42831 = args42829.length;
switch (G__42831) {
case 1:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42829.length)].join('')));

}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$1 = (function (el){
var attrs = c2.dom.__GT_dom(el).attributes;
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5341__auto__ = ((function (attrs){
return (function c2$dom$iter__42832(s__42833){
return (new cljs.core.LazySeq(null,((function (attrs){
return (function (){
var s__42833__$1 = s__42833;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__42833__$1);
if(temp__4425__auto__){
var s__42833__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__42833__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__42833__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__42835 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__42834 = (0);
while(true){
if((i__42834 < size__5340__auto__)){
var i = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__42834);
cljs.core.chunk_append(b__42835,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((attrs[i]).name),(attrs[i]).value], null));

var G__42848 = (i__42834 + (1));
i__42834 = G__42848;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__42835),c2$dom$iter__42832(cljs.core.chunk_rest(s__42833__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__42835),null);
}
} else {
var i = cljs.core.first(s__42833__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((attrs[i]).name),(attrs[i]).value], null),c2$dom$iter__42832(cljs.core.rest(s__42833__$2)));
}
} else {
return null;
}
break;
}
});})(attrs))
,null,null));
});})(attrs))
;
return iter__5341__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(attrs.length));
})());
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom(el);
if((x instanceof cljs.core.Keyword)){
return el__$1.getAttribute(cljs.core.name(x));
} else {
if(cljs.core.map_QMARK_(x)){
var seq__42838_42849 = cljs.core.seq(x);
var chunk__42839_42850 = null;
var count__42840_42851 = (0);
var i__42841_42852 = (0);
while(true){
if((i__42841_42852 < count__42840_42851)){
var vec__42842_42853 = chunk__42839_42850.cljs$core$IIndexed$_nth$arity$2(null,i__42841_42852);
var k_42854 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42842_42853,(0),null);
var v_42855 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42842_42853,(1),null);
c2.dom.attr.cljs$core$IFn$_invoke$arity$3(el__$1,k_42854,v_42855);

var G__42856 = seq__42838_42849;
var G__42857 = chunk__42839_42850;
var G__42858 = count__42840_42851;
var G__42859 = (i__42841_42852 + (1));
seq__42838_42849 = G__42856;
chunk__42839_42850 = G__42857;
count__42840_42851 = G__42858;
i__42841_42852 = G__42859;
continue;
} else {
var temp__4425__auto___42860 = cljs.core.seq(seq__42838_42849);
if(temp__4425__auto___42860){
var seq__42838_42861__$1 = temp__4425__auto___42860;
if(cljs.core.chunked_seq_QMARK_(seq__42838_42861__$1)){
var c__5372__auto___42862 = cljs.core.chunk_first(seq__42838_42861__$1);
var G__42863 = cljs.core.chunk_rest(seq__42838_42861__$1);
var G__42864 = c__5372__auto___42862;
var G__42865 = cljs.core.count(c__5372__auto___42862);
var G__42866 = (0);
seq__42838_42849 = G__42863;
chunk__42839_42850 = G__42864;
count__42840_42851 = G__42865;
i__42841_42852 = G__42866;
continue;
} else {
var vec__42843_42867 = cljs.core.first(seq__42838_42861__$1);
var k_42868 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42843_42867,(0),null);
var v_42869 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42843_42867,(1),null);
c2.dom.attr.cljs$core$IFn$_invoke$arity$3(el__$1,k_42868,v_42869);

var G__42870 = cljs.core.next(seq__42838_42861__$1);
var G__42871 = null;
var G__42872 = (0);
var G__42873 = (0);
seq__42838_42849 = G__42870;
chunk__42839_42850 = G__42871;
count__42840_42851 = G__42872;
i__42841_42852 = G__42873;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var el__$1 = c2.dom.__GT_dom(el);
if((v == null)){
el__$1.removeAttribute(cljs.core.name(k));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$style,k)){
c2.dom.style.cljs$core$IFn$_invoke$arity$2(el__$1,v);
} else {
el__$1.setAttribute(cljs.core.name(k),v);
}
}

return el__$1;
});

c2.dom.attr.cljs$lang$maxFixedArity = 3;
/**
 * Get or set element text, returning element
 */
c2.dom.text = (function c2$dom$text(var_args){
var args42874 = [];
var len__5627__auto___42878 = arguments.length;
var i__5628__auto___42879 = (0);
while(true){
if((i__5628__auto___42879 < len__5627__auto___42878)){
args42874.push((arguments[i__5628__auto___42879]));

var G__42880 = (i__5628__auto___42879 + (1));
i__5628__auto___42879 = G__42880;
continue;
} else {
}
break;
}

var G__42876 = args42874.length;
switch (G__42876) {
case 1:
return c2.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42874.length)].join('')));

}
});

c2.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__42877 = c2.dom.__GT_dom(el);
return goog.dom.getTextContent(G__42877);
});

c2.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom(el);
goog.dom.setTextContent(el__$1,v);

return el__$1;
});

c2.dom.text.cljs$lang$maxFixedArity = 2;
/**
 * Get or set element value.
 */
c2.dom.val = (function c2$dom$val(var_args){
var args42882 = [];
var len__5627__auto___42886 = arguments.length;
var i__5628__auto___42887 = (0);
while(true){
if((i__5628__auto___42887 < len__5627__auto___42886)){
args42882.push((arguments[i__5628__auto___42887]));

var G__42888 = (i__5628__auto___42887 + (1));
i__5628__auto___42887 = G__42888;
continue;
} else {
}
break;
}

var G__42884 = args42882.length;
switch (G__42884) {
case 1:
return c2.dom.val.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.val.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42882.length)].join('')));

}
});

c2.dom.val.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__42885 = c2.dom.__GT_dom(el);
return goog.dom.forms.getValue(G__42885);
});

c2.dom.val.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom(el);
goog.dom.forms.setValue(el__$1,v);

return el__$1;
});

c2.dom.val.cljs$lang$maxFixedArity = 2;
/**
 * Add or remove `class` to element based on boolean `classed?`, returning element.
 */
c2.dom.classed_BANG_ = (function c2$dom$classed_BANG_(el,class$,classed_QMARK_){
var G__42893_42896 = c2.dom.__GT_dom(el);
var G__42894_42897 = cljs.core.name(class$);
var G__42895_42898 = classed_QMARK_;
goog.dom.classes.enable(G__42893_42896,G__42894_42897,G__42895_42898);

return el;
});
c2.dom.add_class_BANG_ = (function c2$dom$add_class_BANG_(el,class$){
return c2.dom.classed_BANG_(el,class$,true);
});
c2.dom.remove_class_BANG_ = (function c2$dom$remove_class_BANG_(el,class$){
return c2.dom.classed_BANG_(el,class$,false);
});
c2.dom.request_animation_frame = (function (){var or__4569__auto__ = window.requestAnimationFrame;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
var or__4569__auto____$1 = window.webkitRequestAnimationFrame;
if(cljs.core.truth_(or__4569__auto____$1)){
return or__4569__auto____$1;
} else {
return ((function (or__4569__auto____$1,or__4569__auto__){
return (function (p1__42899_SHARP_){
var G__42900 = ((function (or__4569__auto____$1,or__4569__auto__){
return (function (){
return (p1__42899_SHARP_.cljs$core$IFn$_invoke$arity$0 ? p1__42899_SHARP_.cljs$core$IFn$_invoke$arity$0() : p1__42899_SHARP_.call(null));
});})(or__4569__auto____$1,or__4569__auto__))
;
var G__42901 = (10);
return setTimeout(G__42900,G__42901);
});
;})(or__4569__auto____$1,or__4569__auto__))
}
}
})();
