// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.utils.style');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('hatti.ona.forms');
/**
 * Set of CSS properties that can be modified by a user
 */
hatti.utils.style.user_customizable_styles = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["color",null], null), null);
/**
 * Saturated qualitative palette from colorbrewer.
 * Saturated red+brown disabled due to clash with the :clicked color.
 */
hatti.utils.style.qualitative_palette = new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, ["#1f78b4","#33a02c","#6a3d9a","#ffff99","#b15928","#a6cee3","#b2df8a","#fb9a99","#fdbf6f","#cab2d6"], null);
/**
 * Color palette of YlGnBl from colorbrewer.
 */
hatti.utils.style.sequential_palette = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["#ffffcc","#bdd7e7","#6baed6","#3182bd","#08519c"], null);
/**
 * A Grey Color for deselected points.
 */
hatti.utils.style.grey = "#d9d9d9";
/**
 * Check if a user can customize a style
 */
hatti.utils.style.customizable_style_QMARK_ = (function hatti$utils$style$customizable_style_QMARK_(p__25887){
var vec__25889 = p__25887;
var style_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25889,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25889,(1),null);
return cljs.core.contains_QMARK_(hatti.utils.style.user_customizable_styles,style_name);
});
/**
 * Return a map of a form field answer name to CSS rules
 */
hatti.utils.style.get_css_rule_map = (function hatti$utils$style$get_css_rule_map(appearance_attribute){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__25893){
var vec__25894 = p__25893;
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25894,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25894,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(key),value], null);
}),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.utils.style.customizable_style_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__25890_SHARP_){
return clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__25890_SHARP_,/:/);
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(appearance_attribute,/;/)))));
});
/**
 * Return a map of answer to associated CSS rules
 */
hatti.utils.style.group_user_defined_styles_by_answer = (function hatti$utils$style$group_user_defined_styles_by_answer(p__25895){
var map__25901 = p__25895;
var map__25901__$1 = ((((!((map__25901 == null)))?((((map__25901.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25901.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25901):map__25901);
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25901__$1,cljs.core.cst$kw$children);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.merge,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__25901,map__25901__$1,children){
return (function (p__25903){
var map__25904 = p__25903;
var map__25904__$1 = ((((!((map__25904 == null)))?((((map__25904.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25904.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25904):map__25904);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25904__$1,cljs.core.cst$kw$name);
var appearance = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25904__$1,cljs.core.cst$kw$appearance);
return cljs.core.PersistentArrayMap.fromArray([name,hatti.utils.style.get_css_rule_map(appearance)], true, false);
});})(map__25901,map__25901__$1,children))
,children));
});
/**
 * Returns only the color property of the style map, with the answer as the key
 */
hatti.utils.style.style_map__GT_color_map = (function hatti$utils$style$style_map__GT_color_map(p__25906){
var vec__25910 = p__25906;
var answer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25910,(0),null);
var map__25911 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25910,(1),null);
var map__25911__$1 = ((((!((map__25911 == null)))?((((map__25911.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25911.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25911):map__25911);
var color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25911__$1,cljs.core.cst$kw$color);
if(cljs.core.truth_(color)){
return cljs.core.PersistentArrayMap.fromArray([answer,color], true, false);
} else {
return null;
}
});
/**
 * Return a map of answers to their associated colors
 */
hatti.utils.style.group_user_defined_colors_by_answer = (function hatti$utils$style$group_user_defined_colors_by_answer(field){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.vec(cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.utils.style.style_map__GT_color_map,hatti.utils.style.group_user_defined_styles_by_answer(field))))));
});
/**
 * Return the appropriate set of colors given the field. For a select_one,
 * returns a mapping of answer to color. Returns a string for all other field
 * types
 */
hatti.utils.style.field__GT_colors = (function hatti$utils$style$field__GT_colors(field){
if(cljs.core.truth_(hatti.ona.forms.select_one_QMARK_(field))){
if((cljs.core.count(cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(field)) <= cljs.core.count(hatti.utils.style.qualitative_palette))){
return hatti.utils.style.qualitative_palette;
} else {
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("#f30");
}
} else {
if(cljs.core.truth_(hatti.ona.forms.calculate_QMARK_(field))){
return hatti.utils.style.qualitative_palette;
} else {
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))){
return hatti.utils.style.sequential_palette;
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))){
return hatti.utils.style.sequential_palette;
} else {
if(cljs.core.truth_(hatti.ona.forms.text_QMARK_(field))){
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("#f30");
} else {
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_(field))){
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("#f30");
} else {
return null;
}
}
}
}
}
}
});
/**
 * Given a field and set of answers, return a mapping of answer to color
 * defaulting to an inbuilt palette if the field is not a select-one or
 * any of the choices lack an appearance attribute
 */
hatti.utils.style.answer__GT_color = (function hatti$utils$style$answer__GT_color(p__25913,answers){
var map__25916 = p__25913;
var map__25916__$1 = ((((!((map__25916 == null)))?((((map__25916.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25916.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25916):map__25916);
var field = map__25916__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25916__$1,cljs.core.cst$kw$children);
if(cljs.core.truth_((function (){var and__4557__auto__ = hatti.ona.forms.select_one_QMARK_(field);
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.every_QMARK_(cljs.core.cst$kw$appearance,children);
} else {
return and__4557__auto__;
}
})())){
return hatti.utils.style.group_user_defined_colors_by_answer(field);
} else {
return cljs.core.zipmap(answers,hatti.utils.style.field__GT_colors(field));
}
});
