// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.ona.stream');
goog.require('cljs.core');
goog.require('cljs.core.async');
hatti.ona.stream.small_delay = (10);
/**
 * Calls callback on aggregated data that come via messages in channel.
 * Callback accepts two arguments: data (cljs list), and completed? (bool)
 *   If there is a parser in message, resume it after a timeout.
 */
hatti.ona.stream.process_aggregated_data_BANG_ = (function hatti$ona$stream$process_aggregated_data_BANG_(agg_data_channel,callback){
var c__8287__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8287__auto__){
return (function (){
var f__8288__auto__ = (function (){var switch__8266__auto__ = ((function (c__8287__auto__){
return (function (state_8885){
var state_val_8886 = (state_8885[(1)]);
if((state_val_8886 === (7))){
var inst_8842 = (state_8885[(7)]);
var inst_8842__$1 = (state_8885[(2)]);
var inst_8844 = (inst_8842__$1 == null);
var inst_8845 = cljs.core.not.call(null,inst_8844);
var state_8885__$1 = (function (){var statearr_8887 = state_8885;
(statearr_8887[(7)] = inst_8842__$1);

return statearr_8887;
})();
if(inst_8845){
var statearr_8888_8925 = state_8885__$1;
(statearr_8888_8925[(1)] = (8));

} else {
var statearr_8889_8926 = state_8885__$1;
(statearr_8889_8926[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8886 === (20))){
var inst_8864 = (state_8885[(8)]);
var inst_8872 = (state_8885[(2)]);
var state_8885__$1 = (function (){var statearr_8890 = state_8885;
(statearr_8890[(9)] = inst_8872);

return statearr_8890;
})();
if(cljs.core.truth_(inst_8864)){
var statearr_8891_8927 = state_8885__$1;
(statearr_8891_8927[(1)] = (21));

} else {
var statearr_8892_8928 = state_8885__$1;
(statearr_8892_8928[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8886 === (1))){
var state_8885__$1 = state_8885;
var statearr_8893_8929 = state_8885__$1;
(statearr_8893_8929[(2)] = null);

(statearr_8893_8929[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8886 === (4))){
var state_8885__$1 = state_8885;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8885__$1,(7),agg_data_channel);
} else {
if((state_val_8886 === (15))){
var inst_8842 = (state_8885[(7)]);
var state_8885__$1 = state_8885;
var statearr_8894_8930 = state_8885__$1;
(statearr_8894_8930[(2)] = inst_8842);

(statearr_8894_8930[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8886 === (21))){
var inst_8874 = cljs.core.async.close_BANG_.call(null,agg_data_channel);
var state_8885__$1 = state_8885;
var statearr_8895_8931 = state_8885__$1;
(statearr_8895_8931[(2)] = inst_8874);

(statearr_8895_8931[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8886 === (13))){
var inst_8854 = (state_8885[(2)]);
var state_8885__$1 = state_8885;
var statearr_8896_8932 = state_8885__$1;
(statearr_8896_8932[(2)] = inst_8854);

(statearr_8896_8932[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8886 === (22))){
var state_8885__$1 = state_8885;
var statearr_8897_8933 = state_8885__$1;
(statearr_8897_8933[(2)] = null);

(statearr_8897_8933[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8886 === (6))){
var inst_8881 = (state_8885[(2)]);
var state_8885__$1 = state_8885;
var statearr_8898_8934 = state_8885__$1;
(statearr_8898_8934[(2)] = inst_8881);

(statearr_8898_8934[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8886 === (17))){
var inst_8864 = (state_8885[(8)]);
var inst_8863 = (state_8885[(10)]);
var inst_8866 = callback.call(null,inst_8863,inst_8864);
var state_8885__$1 = state_8885;
var statearr_8899_8935 = state_8885__$1;
(statearr_8899_8935[(2)] = inst_8866);

(statearr_8899_8935[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8886 === (3))){
var inst_8883 = (state_8885[(2)]);
var state_8885__$1 = state_8885;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8885__$1,inst_8883);
} else {
if((state_val_8886 === (12))){
var state_8885__$1 = state_8885;
var statearr_8900_8936 = state_8885__$1;
(statearr_8900_8936[(2)] = false);

(statearr_8900_8936[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8886 === (2))){
var state_8885__$1 = state_8885;
var statearr_8901_8937 = state_8885__$1;
(statearr_8901_8937[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8886 === (23))){
var inst_8877 = (state_8885[(2)]);
var state_8885__$1 = (function (){var statearr_8903 = state_8885;
(statearr_8903[(11)] = inst_8877);

return statearr_8903;
})();
var statearr_8904_8938 = state_8885__$1;
(statearr_8904_8938[(2)] = null);

(statearr_8904_8938[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8886 === (19))){
var inst_8869 = (state_8885[(2)]);
var inst_8870 = cljs.core.async.timeout.call(null,hatti.ona.stream.small_delay);
var state_8885__$1 = (function (){var statearr_8905 = state_8885;
(statearr_8905[(12)] = inst_8869);

return statearr_8905;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8885__$1,(20),inst_8870);
} else {
if((state_val_8886 === (11))){
var state_8885__$1 = state_8885;
var statearr_8906_8939 = state_8885__$1;
(statearr_8906_8939[(2)] = true);

(statearr_8906_8939[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8886 === (9))){
var state_8885__$1 = state_8885;
var statearr_8907_8940 = state_8885__$1;
(statearr_8907_8940[(2)] = false);

(statearr_8907_8940[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8886 === (5))){
var state_8885__$1 = state_8885;
var statearr_8908_8941 = state_8885__$1;
(statearr_8908_8941[(2)] = null);

(statearr_8908_8941[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8886 === (14))){
var inst_8842 = (state_8885[(7)]);
var inst_8859 = cljs.core.apply.call(null,cljs.core.hash_map,inst_8842);
var state_8885__$1 = state_8885;
var statearr_8909_8942 = state_8885__$1;
(statearr_8909_8942[(2)] = inst_8859);

(statearr_8909_8942[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8886 === (16))){
var inst_8863 = (state_8885[(10)]);
var inst_8862 = (state_8885[(2)]);
var inst_8863__$1 = cljs.core.get.call(null,inst_8862,new cljs.core.Keyword(null,"data","data",-232669377));
var inst_8864 = cljs.core.get.call(null,inst_8862,new cljs.core.Keyword(null,"completed?","completed?",946828354));
var state_8885__$1 = (function (){var statearr_8910 = state_8885;
(statearr_8910[(8)] = inst_8864);

(statearr_8910[(10)] = inst_8863__$1);

return statearr_8910;
})();
if(cljs.core.truth_(inst_8863__$1)){
var statearr_8911_8943 = state_8885__$1;
(statearr_8911_8943[(1)] = (17));

} else {
var statearr_8912_8944 = state_8885__$1;
(statearr_8912_8944[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8886 === (10))){
var inst_8857 = (state_8885[(2)]);
var state_8885__$1 = state_8885;
if(cljs.core.truth_(inst_8857)){
var statearr_8913_8945 = state_8885__$1;
(statearr_8913_8945[(1)] = (14));

} else {
var statearr_8914_8946 = state_8885__$1;
(statearr_8914_8946[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8886 === (18))){
var state_8885__$1 = state_8885;
var statearr_8915_8947 = state_8885__$1;
(statearr_8915_8947[(2)] = null);

(statearr_8915_8947[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8886 === (8))){
var inst_8842 = (state_8885[(7)]);
var inst_8847 = inst_8842.cljs$lang$protocol_mask$partition0$;
var inst_8848 = (inst_8847 & (64));
var inst_8849 = inst_8842.cljs$core$ISeq$;
var inst_8850 = (inst_8848) || (inst_8849);
var state_8885__$1 = state_8885;
if(cljs.core.truth_(inst_8850)){
var statearr_8916_8948 = state_8885__$1;
(statearr_8916_8948[(1)] = (11));

} else {
var statearr_8917_8949 = state_8885__$1;
(statearr_8917_8949[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8287__auto__))
;
return ((function (switch__8266__auto__,c__8287__auto__){
return (function() {
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8267__auto__ = null;
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8267__auto____0 = (function (){
var statearr_8921 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_8921[(0)] = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8267__auto__);

(statearr_8921[(1)] = (1));

return statearr_8921;
});
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8267__auto____1 = (function (state_8885){
while(true){
var ret_value__8268__auto__ = (function (){try{while(true){
var result__8269__auto__ = switch__8266__auto__.call(null,state_8885);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8269__auto__;
}
break;
}
}catch (e8922){if((e8922 instanceof Object)){
var ex__8270__auto__ = e8922;
var statearr_8923_8950 = state_8885;
(statearr_8923_8950[(5)] = ex__8270__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8885);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8922;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8951 = state_8885;
state_8885 = G__8951;
continue;
} else {
return ret_value__8268__auto__;
}
break;
}
});
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8267__auto__ = function(state_8885){
switch(arguments.length){
case 0:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8267__auto____0.call(this);
case 1:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8267__auto____1.call(this,state_8885);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8267__auto____0;
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8267__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8267__auto____1;
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8267__auto__;
})()
;})(switch__8266__auto__,c__8287__auto__))
})();
var state__8289__auto__ = (function (){var statearr_8924 = f__8288__auto__.call(null);
(statearr_8924[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8287__auto__);

return statearr_8924;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8289__auto__);
});})(c__8287__auto__))
);

return c__8287__auto__;
});
/**
 * On each step of data, increment read-count atom, and put data in a list agg.
 * After a exponentially increasing # of steps have been processed,
 * the aggregated data gets flushed into a channel, and parser is paused.
 * The channel reader should resume the parser after processing the data.
 */
hatti.ona.stream.read_next_chunk_BANG_ = (function hatti$ona$stream$read_next_chunk_BANG_(data_chunk,read_count,agg,channel){
cljs.core.swap_BANG_.call(null,read_count,cljs.core.inc);

cljs.core.swap_BANG_.call(null,agg,cljs.core.conj,data_chunk);

if(((cljs.core.deref.call(null,read_count) >= (100))) && (cljs.core.integer_QMARK_.call(null,Math.log10(cljs.core.deref.call(null,read_count))))){
cljs.core.async.put_BANG_.call(null,channel,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.deref.call(null,agg)], null));

cljs.core.reset_BANG_.call(null,agg,cljs.core.PersistentVector.EMPTY);

return oboe.drop();
} else {
return null;
}
});
/**
 * Given url, a node pattern matcher, and a callback, streaming-read json.
 */
hatti.ona.stream.streamingly_read_json_BANG_ = (function hatti$ona$stream$streamingly_read_json_BANG_(var_args){
var args__5645__auto__ = [];
var len__5638__auto___8958 = arguments.length;
var i__5639__auto___8959 = (0);
while(true){
if((i__5639__auto___8959 < len__5638__auto___8958)){
args__5645__auto__.push((arguments[i__5639__auto___8959]));

var G__8960 = (i__5639__auto___8959 + (1));
i__5639__auto___8959 = G__8960;
continue;
} else {
}
break;
}

var argseq__5646__auto__ = ((((2) < args__5645__auto__.length))?(new cljs.core.IndexedSeq(args__5645__auto__.slice((2)),(0))):null);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (url,stepfn,p__8955){
var map__8956 = p__8955;
var map__8956__$1 = ((((!((map__8956 == null)))?((((map__8956.cljs$lang$protocol_mask$partition0$ & (64))) || (map__8956.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8956):map__8956);
var oboe_headers = cljs.core.get.call(null,map__8956__$1,new cljs.core.Keyword(null,"oboe-headers","oboe-headers",-764778163));
var read_count = cljs.core.atom.call(null,(0));
var agg = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
var channel = cljs.core.async.chan.call(null);
var return_channel = cljs.core.async.chan.call(null);
var oboe_params = cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"headers","headers",-835030129),oboe_headers,new cljs.core.Keyword(null,"withCredentials","withCredentials",1719959454),true], null));
var step = ((function (read_count,agg,channel,return_channel,oboe_params,map__8956,map__8956__$1,oboe_headers){
return (function (line){
return hatti.ona.stream.read_next_chunk_BANG_.call(null,cljs.core.js__GT_clj.call(null,line),read_count,agg,channel);
});})(read_count,agg,channel,return_channel,oboe_params,map__8956,map__8956__$1,oboe_headers))
;
var done = ((function (read_count,agg,channel,return_channel,oboe_params,step,map__8956,map__8956__$1,oboe_headers){
return (function (){
cljs.core.async.put_BANG_.call(null,channel,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.deref.call(null,agg),new cljs.core.Keyword(null,"completed?","completed?",946828354),true], null));

return cljs.core.async.close_BANG_.call(null,return_channel);
});})(read_count,agg,channel,return_channel,oboe_params,step,map__8956,map__8956__$1,oboe_headers))
;
hatti.ona.stream.process_aggregated_data_BANG_.call(null,channel,stepfn);

window.oboe(oboe_params).node("!.*",step).done(done);

return return_channel;
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$applyTo = (function (seq8952){
var G__8953 = cljs.core.first.call(null,seq8952);
var seq8952__$1 = cljs.core.next.call(null,seq8952);
var G__8954 = cljs.core.first.call(null,seq8952__$1);
var seq8952__$2 = cljs.core.next.call(null,seq8952__$1);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__8953,G__8954,seq8952__$2);
});
