// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.ona.post_process');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.ona.forms');
goog.require('hatti.ona.urls');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('chimera.urls');
/**
 * Given some data in Ona format, builds a data structure that we will use
 * to link osm data to Ona data.
 */
hatti.ona.post_process.ona_osm_link = (function hatti$ona$post_process$ona_osm_link(data,form){
var osmfields = cljs.core.filter.call(null,hatti.ona.forms.osm_QMARK_,form);
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.flatten.call(null,(function (){var iter__5352__auto__ = ((function (osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__9144(s__9145){
return (new cljs.core.LazySeq(null,((function (osmfields){
return (function (){
var s__9145__$1 = s__9145;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__9145__$1);
if(temp__4657__auto__){
var s__9145__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__9145__$2)){
var c__5350__auto__ = cljs.core.chunk_first.call(null,s__9145__$2);
var size__5351__auto__ = cljs.core.count.call(null,c__5350__auto__);
var b__9147 = cljs.core.chunk_buffer.call(null,size__5351__auto__);
if((function (){var i__9146 = (0);
while(true){
if((i__9146 < size__5351__auto__)){
var datum = cljs.core._nth.call(null,c__5350__auto__,i__9146);
cljs.core.chunk_append.call(null,b__9147,(function (){var iter__5352__auto__ = ((function (i__9146,datum,c__5350__auto__,size__5351__auto__,b__9147,s__9145__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__9144_$_iter__9156(s__9157){
return (new cljs.core.LazySeq(null,((function (i__9146,datum,c__5350__auto__,size__5351__auto__,b__9147,s__9145__$2,temp__4657__auto__,osmfields){
return (function (){
var s__9157__$1 = s__9157;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__9157__$1);
if(temp__4657__auto____$1){
var s__9157__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__9157__$2)){
var c__5350__auto____$1 = cljs.core.chunk_first.call(null,s__9157__$2);
var size__5351__auto____$1 = cljs.core.count.call(null,c__5350__auto____$1);
var b__9159 = cljs.core.chunk_buffer.call(null,size__5351__auto____$1);
if((function (){var i__9158 = (0);
while(true){
if((i__9158 < size__5351__auto____$1)){
var field = cljs.core._nth.call(null,c__5350__auto____$1,i__9158);
cljs.core.chunk_append.call(null,b__9159,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__4568__auto__ = osmdatum;
if(cljs.core.truth_(and__4568__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__4568__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})());

var G__9164 = (i__9158 + (1));
i__9158 = G__9164;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9159),hatti$ona$post_process$ona_osm_link_$_iter__9144_$_iter__9156.call(null,cljs.core.chunk_rest.call(null,s__9157__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9159),null);
}
} else {
var field = cljs.core.first.call(null,s__9157__$2);
return cljs.core.cons.call(null,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__4568__auto__ = osmdatum;
if(cljs.core.truth_(and__4568__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__4568__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__9144_$_iter__9156.call(null,cljs.core.rest.call(null,s__9157__$2)));
}
} else {
return null;
}
break;
}
});})(i__9146,datum,c__5350__auto__,size__5351__auto__,b__9147,s__9145__$2,temp__4657__auto__,osmfields))
,null,null));
});})(i__9146,datum,c__5350__auto__,size__5351__auto__,b__9147,s__9145__$2,temp__4657__auto__,osmfields))
;
return iter__5352__auto__.call(null,osmfields);
})());

var G__9165 = (i__9146 + (1));
i__9146 = G__9165;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9147),hatti$ona$post_process$ona_osm_link_$_iter__9144.call(null,cljs.core.chunk_rest.call(null,s__9145__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9147),null);
}
} else {
var datum = cljs.core.first.call(null,s__9145__$2);
return cljs.core.cons.call(null,(function (){var iter__5352__auto__ = ((function (datum,s__9145__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__9144_$_iter__9160(s__9161){
return (new cljs.core.LazySeq(null,((function (datum,s__9145__$2,temp__4657__auto__,osmfields){
return (function (){
var s__9161__$1 = s__9161;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__9161__$1);
if(temp__4657__auto____$1){
var s__9161__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__9161__$2)){
var c__5350__auto__ = cljs.core.chunk_first.call(null,s__9161__$2);
var size__5351__auto__ = cljs.core.count.call(null,c__5350__auto__);
var b__9163 = cljs.core.chunk_buffer.call(null,size__5351__auto__);
if((function (){var i__9162 = (0);
while(true){
if((i__9162 < size__5351__auto__)){
var field = cljs.core._nth.call(null,c__5350__auto__,i__9162);
cljs.core.chunk_append.call(null,b__9163,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__4568__auto__ = osmdatum;
if(cljs.core.truth_(and__4568__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__4568__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})());

var G__9166 = (i__9162 + (1));
i__9162 = G__9166;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9163),hatti$ona$post_process$ona_osm_link_$_iter__9144_$_iter__9160.call(null,cljs.core.chunk_rest.call(null,s__9161__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9163),null);
}
} else {
var field = cljs.core.first.call(null,s__9161__$2);
return cljs.core.cons.call(null,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__4568__auto__ = osmdatum;
if(cljs.core.truth_(and__4568__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__4568__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__9144_$_iter__9160.call(null,cljs.core.rest.call(null,s__9161__$2)));
}
} else {
return null;
}
break;
}
});})(datum,s__9145__$2,temp__4657__auto__,osmfields))
,null,null));
});})(datum,s__9145__$2,temp__4657__auto__,osmfields))
;
return iter__5352__auto__.call(null,osmfields);
})(),hatti$ona$post_process$ona_osm_link_$_iter__9144.call(null,cljs.core.rest.call(null,s__9145__$2)));
}
} else {
return null;
}
break;
}
});})(osmfields))
,null,null));
});})(osmfields))
;
return iter__5352__auto__.call(null,data);
})()));
});
/**
 * Takes OSM XML in string form, and returns cljs geojson.
 */
hatti.ona.post_process.osm_xml__GT_geojson = (function hatti$ona$post_process$osm_xml__GT_geojson(osm_xml_string){
return cljs.core.js__GT_clj.call(null,osmtogeojson(jQuery.parseXML(osm_xml_string)),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});
/**
 * Given some data in OSM format, an Ona Form, and osm xml string,
 * return a map from OSM ID to each osm feature. The map contains:
 * :osm-id, :name, :tags from osm xml,
 * :type, :geom from osm feature's geojson equivalent.
 */
hatti.ona.post_process.osm_id__GT_osm_data = (function hatti$ona$post_process$osm_id__GT_osm_data(data,form,osm_xml){
var ona_osm_link = hatti.ona.post_process.ona_osm_link.call(null,data,form);
var osmgeo = hatti.ona.post_process.osm_xml__GT_geojson.call(null,osm_xml);
var featureset = osmgeo.call(null,new cljs.core.Keyword(null,"features","features",-1146962336));
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5352__auto__ = ((function (ona_osm_link,osmgeo,featureset){
return (function hatti$ona$post_process$osm_id__GT_osm_data_$_iter__9187(s__9188){
return (new cljs.core.LazySeq(null,((function (ona_osm_link,osmgeo,featureset){
return (function (){
var s__9188__$1 = s__9188;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__9188__$1);
if(temp__4657__auto__){
var s__9188__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__9188__$2)){
var c__5350__auto__ = cljs.core.chunk_first.call(null,s__9188__$2);
var size__5351__auto__ = cljs.core.count.call(null,c__5350__auto__);
var b__9190 = cljs.core.chunk_buffer.call(null,size__5351__auto__);
if((function (){var i__9189 = (0);
while(true){
if((i__9189 < size__5351__auto__)){
var map__9199 = cljs.core._nth.call(null,c__5350__auto__,i__9189);
var map__9199__$1 = ((((!((map__9199 == null)))?((((map__9199.cljs$lang$protocol_mask$partition0$ & (64))) || (map__9199.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__9199):map__9199);
var feature = map__9199__$1;
var type = cljs.core.get.call(null,map__9199__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var properties = cljs.core.get.call(null,map__9199__$1,new cljs.core.Keyword(null,"properties","properties",685819552));
var geometry = cljs.core.get.call(null,map__9199__$1,new cljs.core.Keyword(null,"geometry","geometry",-405034994));
cljs.core.chunk_append.call(null,b__9190,(function (){var map__9201 = properties;
var map__9201__$1 = ((((!((map__9201 == null)))?((((map__9201.cljs$lang$protocol_mask$partition0$ & (64))) || (map__9201.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__9201):map__9201);
var type__$1 = cljs.core.get.call(null,map__9201__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var id = cljs.core.get.call(null,map__9201__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tags = cljs.core.get.call(null,map__9201__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"osm-id","osm-id",-1125866420),id,new cljs.core.Keyword(null,"type","type",1174270348),type__$1,new cljs.core.Keyword(null,"geom","geom",1207084371),geometry,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(tags),new cljs.core.Keyword(null,"tags","tags",1771418977),tags], null)], true, false);
})());

var G__9207 = (i__9189 + (1));
i__9189 = G__9207;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9190),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__9187.call(null,cljs.core.chunk_rest.call(null,s__9188__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9190),null);
}
} else {
var map__9203 = cljs.core.first.call(null,s__9188__$2);
var map__9203__$1 = ((((!((map__9203 == null)))?((((map__9203.cljs$lang$protocol_mask$partition0$ & (64))) || (map__9203.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__9203):map__9203);
var feature = map__9203__$1;
var type = cljs.core.get.call(null,map__9203__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var properties = cljs.core.get.call(null,map__9203__$1,new cljs.core.Keyword(null,"properties","properties",685819552));
var geometry = cljs.core.get.call(null,map__9203__$1,new cljs.core.Keyword(null,"geometry","geometry",-405034994));
return cljs.core.cons.call(null,(function (){var map__9205 = properties;
var map__9205__$1 = ((((!((map__9205 == null)))?((((map__9205.cljs$lang$protocol_mask$partition0$ & (64))) || (map__9205.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__9205):map__9205);
var type__$1 = cljs.core.get.call(null,map__9205__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var id = cljs.core.get.call(null,map__9205__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tags = cljs.core.get.call(null,map__9205__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"osm-id","osm-id",-1125866420),id,new cljs.core.Keyword(null,"type","type",1174270348),type__$1,new cljs.core.Keyword(null,"geom","geom",1207084371),geometry,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(tags),new cljs.core.Keyword(null,"tags","tags",1771418977),tags], null)], true, false);
})(),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__9187.call(null,cljs.core.rest.call(null,s__9188__$2)));
}
} else {
return null;
}
break;
}
});})(ona_osm_link,osmgeo,featureset))
,null,null));
});})(ona_osm_link,osmgeo,featureset))
;
return iter__5352__auto__.call(null,featureset);
})());
});
/**
 * Given some data post-processed from the ona server
 * (ie, containing _id, _rank), and a string of osm-xml, produce a version with
 * relevant osm data injected in.
 */
hatti.ona.post_process.integrate_osm_data_BANG_ = (function hatti$ona$post_process$integrate_osm_data_BANG_(app_state,form,osm_xml,app_state_keys){
var osm_fields = cljs.core.filter.call(null,hatti.ona.forms.osm_QMARK_,form);
if(cljs.core.seq.call(null,osm_fields)){
var data = cljs.core.get_in.call(null,app_state,app_state_keys);
var osm_data = hatti.ona.post_process.osm_id__GT_osm_data.call(null,data,form,osm_xml);
var osm_val__GT_osm_id = ((function (data,osm_data,osm_fields){
return (function (p1__9208_SHARP_){
return cljs.core.re_find.call(null,/[-]?[0-9]+/,p1__9208_SHARP_);
});})(data,osm_data,osm_fields))
;
var osm_val__GT_osm_data = ((function (data,osm_data,osm_val__GT_osm_id,osm_fields){
return (function (osm_val){
if(typeof osm_val === 'string'){
var temp__4655__auto__ = osm_data.call(null,osm_val__GT_osm_id.call(null,osm_val));
if(cljs.core.truth_(temp__4655__auto__)){
var osm_submission_data = temp__4655__auto__;
return osm_submission_data;
} else {
return osm_val;
}
} else {
return osm_val;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_fields))
;
var updater = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (osm_key){
return ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (data__$1){
var iter__5352__auto__ = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function hatti$ona$post_process$integrate_osm_data_BANG__$_iter__9217(s__9218){
return (new cljs.core.LazySeq(null,((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (){
var s__9218__$1 = s__9218;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__9218__$1);
if(temp__4657__auto__){
var s__9218__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__9218__$2)){
var c__5350__auto__ = cljs.core.chunk_first.call(null,s__9218__$2);
var size__5351__auto__ = cljs.core.count.call(null,c__5350__auto__);
var b__9220 = cljs.core.chunk_buffer.call(null,size__5351__auto__);
if((function (){var i__9219 = (0);
while(true){
if((i__9219 < size__5351__auto__)){
var datum = cljs.core._nth.call(null,c__5350__auto__,i__9219);
cljs.core.chunk_append.call(null,b__9220,cljs.core.update_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data));

var G__9225 = (i__9219 + (1));
i__9219 = G__9225;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9220),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__9217.call(null,cljs.core.chunk_rest.call(null,s__9218__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9220),null);
}
} else {
var datum = cljs.core.first.call(null,s__9218__$2);
return cljs.core.cons.call(null,cljs.core.update_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__9217.call(null,cljs.core.rest.call(null,s__9218__$2)));
}
} else {
return null;
}
break;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
,null,null));
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
return iter__5352__auto__.call(null,data__$1);
});
;})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
var seq__9221 = cljs.core.seq.call(null,osm_fields);
var chunk__9222 = null;
var count__9223 = (0);
var i__9224 = (0);
while(true){
if((i__9224 < count__9223)){
var osm_field = cljs.core._nth.call(null,chunk__9222,i__9224);
chimera.om.state.transact_BANG_.call(null,app_state,app_state_keys,updater.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__9226 = seq__9221;
var G__9227 = chunk__9222;
var G__9228 = count__9223;
var G__9229 = (i__9224 + (1));
seq__9221 = G__9226;
chunk__9222 = G__9227;
count__9223 = G__9228;
i__9224 = G__9229;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__9221);
if(temp__4657__auto__){
var seq__9221__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9221__$1)){
var c__5383__auto__ = cljs.core.chunk_first.call(null,seq__9221__$1);
var G__9230 = cljs.core.chunk_rest.call(null,seq__9221__$1);
var G__9231 = c__5383__auto__;
var G__9232 = cljs.core.count.call(null,c__5383__auto__);
var G__9233 = (0);
seq__9221 = G__9230;
chunk__9222 = G__9231;
count__9223 = G__9232;
i__9224 = G__9233;
continue;
} else {
var osm_field = cljs.core.first.call(null,seq__9221__$1);
chimera.om.state.transact_BANG_.call(null,app_state,app_state_keys,updater.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__9234 = cljs.core.next.call(null,seq__9221__$1);
var G__9235 = null;
var G__9236 = (0);
var G__9237 = (0);
seq__9221 = G__9234;
chunk__9222 = G__9235;
count__9223 = G__9236;
i__9224 = G__9237;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
/**
 * Calculate full image and thumbnail urls given attachment information.
 */
hatti.ona.post_process.url_obj = (function hatti$ona$post_process$url_obj(media_obj){
var media_id = cljs.core.get.call(null,media_obj,"id");
var fname = cljs.core.get.call(null,media_obj,"filename");
var file_url = hatti.ona.urls.media_url.call(null,media_id,fname);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"filename","filename",-1428840783),fname,new cljs.core.Keyword(null,"download_url","download_url",-2115471203),file_url,new cljs.core.Keyword(null,"small_download_url","small_download_url",1654303565),[cljs.core.str(file_url),cljs.core.str("&suffix=small")].join('')], null);
});
/**
 * Helper function for integrate attachments; returns a function from
 * a filename to a `url-obj` (see specs in `url-obj` function).
 */
hatti.ona.post_process.get_attach_map = (function hatti$ona$post_process$get_attach_map(record,attachments){
var attachments__$1 = (function (){var or__4580__auto__ = attachments;
if(cljs.core.truth_(or__4580__auto__)){
return or__4580__auto__;
} else {
return cljs.core.get.call(null,record,"_attachments");
}
})();
var fnames = cljs.core.map.call(null,((function (attachments__$1){
return (function (p1__9238_SHARP_){
return chimera.urls.last_url_param.call(null,cljs.core.get.call(null,p1__9238_SHARP_,"filename"));
});})(attachments__$1))
,attachments__$1);
var fname__GT_urlobj = cljs.core.zipmap.call(null,fnames,cljs.core.map.call(null,hatti.ona.post_process.url_obj,attachments__$1));
return ((function (attachments__$1,fnames,fname__GT_urlobj){
return (function (fname){
return cljs.core.get.call(null,fname__GT_urlobj,fname,fname);
});
;})(attachments__$1,fnames,fname__GT_urlobj))
});
/**
 * Inlines media data from within _attachments into each record.
 */
hatti.ona.post_process.integrate_attachments = (function hatti$ona$post_process$integrate_attachments(var_args){
var args__5645__auto__ = [];
var len__5638__auto___9249 = arguments.length;
var i__5639__auto___9250 = (0);
while(true){
if((i__5639__auto___9250 < len__5638__auto___9249)){
args__5645__auto__.push((arguments[i__5639__auto___9250]));

var G__9251 = (i__5639__auto___9250 + (1));
i__5639__auto___9250 = G__9251;
continue;
} else {
}
break;
}

var argseq__5646__auto__ = ((((2) < args__5645__auto__.length))?(new cljs.core.IndexedSeq(args__5645__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);
});

hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,data,p__9242){
var map__9243 = p__9242;
var map__9243__$1 = ((((!((map__9243 == null)))?((((map__9243.cljs$lang$protocol_mask$partition0$ & (64))) || (map__9243.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__9243):map__9243);
var attachments = cljs.core.get.call(null,map__9243__$1,new cljs.core.Keyword(null,"attachments","attachments",-1535547830));
var image_fields = cljs.core.filter.call(null,hatti.ona.forms.image_QMARK_,flat_form);
var iter__5352__auto__ = ((function (image_fields,map__9243,map__9243__$1,attachments){
return (function hatti$ona$post_process$iter__9245(s__9246){
return (new cljs.core.LazySeq(null,((function (image_fields,map__9243,map__9243__$1,attachments){
return (function (){
var s__9246__$1 = s__9246;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__9246__$1);
if(temp__4657__auto__){
var s__9246__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__9246__$2)){
var c__5350__auto__ = cljs.core.chunk_first.call(null,s__9246__$2);
var size__5351__auto__ = cljs.core.count.call(null,c__5350__auto__);
var b__9248 = cljs.core.chunk_buffer.call(null,size__5351__auto__);
if((function (){var i__9247 = (0);
while(true){
if((i__9247 < size__5351__auto__)){
var record = cljs.core._nth.call(null,c__5350__auto__,i__9247);
cljs.core.chunk_append.call(null,b__9248,(function (){var attach_map = hatti.ona.post_process.get_attach_map.call(null,record,attachments);
return cljs.core.reduce.call(null,((function (i__9247,attach_map,record,c__5350__auto__,size__5351__auto__,b__9248,s__9246__$2,temp__4657__auto__,image_fields,map__9243,map__9243__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.call(null,record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(i__9247,attach_map,record,c__5350__auto__,size__5351__auto__,b__9248,s__9246__$2,temp__4657__auto__,image_fields,map__9243,map__9243__$1,attachments))
,record,image_fields);
})());

var G__9252 = (i__9247 + (1));
i__9247 = G__9252;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9248),hatti$ona$post_process$iter__9245.call(null,cljs.core.chunk_rest.call(null,s__9246__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9248),null);
}
} else {
var record = cljs.core.first.call(null,s__9246__$2);
return cljs.core.cons.call(null,(function (){var attach_map = hatti.ona.post_process.get_attach_map.call(null,record,attachments);
return cljs.core.reduce.call(null,((function (attach_map,record,s__9246__$2,temp__4657__auto__,image_fields,map__9243,map__9243__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.call(null,record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(attach_map,record,s__9246__$2,temp__4657__auto__,image_fields,map__9243,map__9243__$1,attachments))
,record,image_fields);
})(),hatti$ona$post_process$iter__9245.call(null,cljs.core.rest.call(null,s__9246__$2)));
}
} else {
return null;
}
break;
}
});})(image_fields,map__9243,map__9243__$1,attachments))
,null,null));
});})(image_fields,map__9243,map__9243__$1,attachments))
;
return iter__5352__auto__.call(null,data);
});

hatti.ona.post_process.integrate_attachments.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments.cljs$lang$applyTo = (function (seq9239){
var G__9240 = cljs.core.first.call(null,seq9239);
var seq9239__$1 = cljs.core.next.call(null,seq9239);
var G__9241 = cljs.core.first.call(null,seq9239__$1);
var seq9239__$2 = cljs.core.next.call(null,seq9239__$1);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(G__9240,G__9241,seq9239__$2);
});
/**
 * Inlines data from within _attachments into each datapoint within repeats.
 */
hatti.ona.post_process.integrate_attachments_in_repeats = (function hatti$ona$post_process$integrate_attachments_in_repeats(flat_form,data){
var repeat_fields = cljs.core.filter.call(null,hatti.ona.forms.repeat_QMARK_,flat_form);
var integrate = ((function (repeat_fields){
return (function (record,rpt_field){
var key = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(rpt_field);
return cljs.core.assoc.call(null,record,key,hatti.ona.post_process.integrate_attachments.call(null,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(rpt_field),cljs.core.get.call(null,record,key),new cljs.core.Keyword(null,"attachments","attachments",-1535547830),cljs.core.get.call(null,record,"_attachments")));
});})(repeat_fields))
;
var iter__5352__auto__ = ((function (repeat_fields,integrate){
return (function hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__9257(s__9258){
return (new cljs.core.LazySeq(null,((function (repeat_fields,integrate){
return (function (){
var s__9258__$1 = s__9258;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__9258__$1);
if(temp__4657__auto__){
var s__9258__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__9258__$2)){
var c__5350__auto__ = cljs.core.chunk_first.call(null,s__9258__$2);
var size__5351__auto__ = cljs.core.count.call(null,c__5350__auto__);
var b__9260 = cljs.core.chunk_buffer.call(null,size__5351__auto__);
if((function (){var i__9259 = (0);
while(true){
if((i__9259 < size__5351__auto__)){
var record = cljs.core._nth.call(null,c__5350__auto__,i__9259);
cljs.core.chunk_append.call(null,b__9260,cljs.core.reduce.call(null,integrate,record,repeat_fields));

var G__9261 = (i__9259 + (1));
i__9259 = G__9261;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9260),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__9257.call(null,cljs.core.chunk_rest.call(null,s__9258__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9260),null);
}
} else {
var record = cljs.core.first.call(null,s__9258__$2);
return cljs.core.cons.call(null,cljs.core.reduce.call(null,integrate,record,repeat_fields),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__9257.call(null,cljs.core.rest.call(null,s__9258__$2)));
}
} else {
return null;
}
break;
}
});})(repeat_fields,integrate))
,null,null));
});})(repeat_fields,integrate))
;
return iter__5352__auto__.call(null,data);
});
/**
 * Inlines data from within _atatchments into each record within app-state.
 */
hatti.ona.post_process.integrate_attachments_BANG_ = (function hatti$ona$post_process$integrate_attachments_BANG_(var_args){
var args__5645__auto__ = [];
var len__5638__auto___9269 = arguments.length;
var i__5639__auto___9270 = (0);
while(true){
if((i__5639__auto___9270 < len__5638__auto___9269)){
args__5645__auto__.push((arguments[i__5639__auto___9270]));

var G__9271 = (i__5639__auto___9270 + (1));
i__5639__auto___9270 = G__9271;
continue;
} else {
}
break;
}

var argseq__5646__auto__ = ((((2) < args__5645__auto__.length))?(new cljs.core.IndexedSeq(args__5645__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,flat_form,p__9266){
var map__9267 = p__9266;
var map__9267__$1 = ((((!((map__9267 == null)))?((((map__9267.cljs$lang$protocol_mask$partition0$ & (64))) || (map__9267.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__9267):map__9267);
var app_data_keys = cljs.core.get.call(null,map__9267__$1,new cljs.core.Keyword(null,"app-data-keys","app-data-keys",-662378404),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
return chimera.om.state.transact_BANG_.call(null,app_state,app_data_keys,((function (map__9267,map__9267__$1,app_data_keys){
return (function (p1__9262_SHARP_){
return hatti.ona.post_process.integrate_attachments_in_repeats.call(null,flat_form,hatti.ona.post_process.integrate_attachments.call(null,flat_form,p1__9262_SHARP_));
});})(map__9267,map__9267__$1,app_data_keys))
);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$applyTo = (function (seq9263){
var G__9264 = cljs.core.first.call(null,seq9263);
var seq9263__$1 = cljs.core.next.call(null,seq9263);
var G__9265 = cljs.core.first.call(null,seq9263__$1);
var seq9263__$2 = cljs.core.next.call(null,seq9263__$1);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__9264,G__9265,seq9263__$2);
});
