// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.map.viewby');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('chimera.js_interop');
goog.require('hatti.charting');
goog.require('hatti.ona.forms');
goog.require('hatti.utils.style');
goog.require('hatti.map.utils');
hatti.map.viewby.marker_styler = (function hatti$map$viewby$marker_styler(id_color,id_selected_QMARK_){
return (function (marker){
var id = hatti.map.utils.get_id.call(null,marker);
var geotype = hatti.map.utils.marker__GT_geotype.call(null,marker);
var color_key = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"line","line",212345235),geotype))?new cljs.core.Keyword(null,"color","color",1011675173):new cljs.core.Keyword(null,"fillColor","fillColor",-176906116));
return cljs.core.PersistentArrayMap.fromArray([color_key,(cljs.core.truth_(id_selected_QMARK_.call(null,id))?id_color.call(null,id):hatti.utils.style.grey)], true, false);
});
});
hatti.map.viewby.move_nil_to_end = (function hatti$map$viewby$move_nil_to_end(s){
var no_nil = cljs.core.vec.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,s));
if(cljs.core._EQ_.call(null,s,no_nil)){
return s;
} else {
return cljs.core.conj.call(null,no_nil,null);
}
});
hatti.map.viewby.all_but_nil_selected = (function hatti$map$viewby$all_but_nil_selected(answers){
return cljs.core.merge.call(null,cljs.core.zipmap.call(null,answers,cljs.core.repeat.call(null,true)),new cljs.core.PersistentArrayMap(null, 1, [null,false], null));
});
/**
 * Preproccesses answers depending on the field. For multi-selects, return type
 * is a list of list of strings. For other types, a list of strings.
 */
hatti.map.viewby.preprocess_answers = (function hatti$map$viewby$preprocess_answers(field,raw_answers){
if(cljs.core.truth_(hatti.ona.forms.select_one_QMARK_.call(null,field))){
return raw_answers;
} else {
if(cljs.core.truth_(hatti.ona.forms.text_QMARK_.call(null,field))){
return raw_answers;
} else {
if(cljs.core.truth_(hatti.ona.forms.calculate_QMARK_.call(null,field))){
return raw_answers;
} else {
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_.call(null,field))){
return hatti.charting.evenly_spaced_bins.call(null,raw_answers,(5),"int");
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_.call(null,field))){
return hatti.charting.evenly_spaced_bins.call(null,raw_answers,(5),"date");
} else {
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_.call(null,field))){
return cljs.core.map.call(null,(function (p1__8714_SHARP_){
if(cljs.core.truth_(p1__8714_SHARP_)){
return clojure.string.split.call(null,p1__8714_SHARP_,/ /);
} else {
return null;
}
}),raw_answers);
} else {
return null;
}
}
}
}
}
}
});
/**
 * Produces a set of data structures / functions for view-by.
 * answers are a list of answers, sorted by count;
 * id->answers is a mapping from id to either one or many answers
 * answer->count, answer->selected?, answer->color are maps from answer;
 * used for the legend rendering. An 'answer' is mapped from a data element,
 * eg. a bin for numbers/dates, an option for multiple/single selects.
 */
hatti.map.viewby.viewby_info = (function hatti$map$viewby$viewby_info(field,raw_answers,ids){
var fname = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var preprocessed_answers = hatti.map.viewby.preprocess_answers.call(null,field,raw_answers);
var answer__GT_count = cljs.core.frequencies.call(null,cljs.core.flatten.call(null,preprocessed_answers));
var sorted_answers = (cljs.core.truth_((function (){var or__4580__auto__ = hatti.ona.forms.categorical_QMARK_.call(null,field);
if(cljs.core.truth_(or__4580__auto__)){
return or__4580__auto__;
} else {
var or__4580__auto____$1 = hatti.ona.forms.text_QMARK_.call(null,field);
if(cljs.core.truth_(or__4580__auto____$1)){
return or__4580__auto____$1;
} else {
return hatti.ona.forms.calculate_QMARK_.call(null,field);
}
}
})())?cljs.core.map.call(null,cljs.core.first,cljs.core.sort_by.call(null,cljs.core.second,cljs.core._GT_,answer__GT_count)):(cljs.core.truth_((function (){var or__4580__auto__ = hatti.ona.forms.time_based_QMARK_.call(null,field);
if(cljs.core.truth_(or__4580__auto__)){
return or__4580__auto__;
} else {
return hatti.ona.forms.numeric_QMARK_.call(null,field);
}
})())?new cljs.core.Keyword(null,"bins","bins",1670395210).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,preprocessed_answers)):null));
var sorted_answers_with_nil_at_end = hatti.map.viewby.move_nil_to_end.call(null,sorted_answers);
var answer__GT_color_map = hatti.utils.style.answer__GT_color.call(null,field,sorted_answers);
var defaults = new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"answers","answers",-2066449770),sorted_answers_with_nil_at_end,new cljs.core.Keyword(null,"id->answers","id->answers",-655129337),cljs.core.zipmap.call(null,ids,preprocessed_answers),new cljs.core.Keyword(null,"answer->count","answer->count",-99425122),answer__GT_count,new cljs.core.Keyword(null,"answer->selected?","answer->selected?",2082517958),hatti.map.viewby.all_but_nil_selected.call(null,sorted_answers),new cljs.core.Keyword(null,"answer->color","answer->color",-142632854),answer__GT_color_map,new cljs.core.Keyword(null,"visible-answers","visible-answers",-771956023),sorted_answers_with_nil_at_end,new cljs.core.Keyword(null,"field","field",-1302436500),field], null);
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_.call(null,field))){
return cljs.core.merge.call(null,defaults,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id-color","id-color",-484052665),((function (fname,preprocessed_answers,answer__GT_count,sorted_answers,sorted_answers_with_nil_at_end,answer__GT_color_map,defaults){
return (function (){
return cljs.core.first.call(null,cljs.core.vals.call(null,answer__GT_color_map));
});})(fname,preprocessed_answers,answer__GT_count,sorted_answers,sorted_answers_with_nil_at_end,answer__GT_color_map,defaults))
], null));
} else {
return defaults;

}
});
/**
 * Generates id-color and id-selected? functions based on viewby-info.
 */
hatti.map.viewby.id_color_selected = (function hatti$map$viewby$id_color_selected(p__8717){
var map__8721 = p__8717;
var map__8721__$1 = ((((!((map__8721 == null)))?((((map__8721.cljs$lang$protocol_mask$partition0$ & (64))) || (map__8721.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8721):map__8721);
var field = cljs.core.get.call(null,map__8721__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var id__GT_answers = cljs.core.get.call(null,map__8721__$1,new cljs.core.Keyword(null,"id->answers","id->answers",-655129337));
var answer__GT_color = cljs.core.get.call(null,map__8721__$1,new cljs.core.Keyword(null,"answer->color","answer->color",-142632854));
var answer__GT_selected_QMARK_ = cljs.core.get.call(null,map__8721__$1,new cljs.core.Keyword(null,"answer->selected?","answer->selected?",2082517958));
var G__8723 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(field);
switch (G__8723) {
case "select all that apply":
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id-color","id-color",-484052665),((function (G__8723,map__8721,map__8721__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (){
return cljs.core.first.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["#f30"], null));
});})(G__8723,map__8721,map__8721__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
,new cljs.core.Keyword(null,"id-selected?","id-selected?",1326938375),((function (G__8723,map__8721,map__8721__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (id){
var answers = id__GT_answers.call(null,id);
if((answers == null)){
return cljs.core.get.call(null,answer__GT_selected_QMARK_,answers);
} else {
return cljs.core.some.call(null,cljs.core.identity,cljs.core.map.call(null,answer__GT_selected_QMARK_,answers));
}
});})(G__8723,map__8721,map__8721__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
], null);

break;
default:
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id-color","id-color",-484052665),((function (G__8723,map__8721,map__8721__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (p1__8715_SHARP_){
return answer__GT_color.call(null,id__GT_answers.call(null,p1__8715_SHARP_));
});})(G__8723,map__8721,map__8721__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
,new cljs.core.Keyword(null,"id-selected?","id-selected?",1326938375),((function (G__8723,map__8721,map__8721__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (p1__8716_SHARP_){
return answer__GT_selected_QMARK_.call(null,id__GT_answers.call(null,p1__8716_SHARP_));
});})(G__8723,map__8721,map__8721__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
], null);

}
});
hatti.map.viewby.view_by_BANG_ = (function hatti$map$viewby$view_by_BANG_(view_by_info,markers){
var map__8731 = hatti.map.viewby.id_color_selected.call(null,view_by_info);
var map__8731__$1 = ((((!((map__8731 == null)))?((((map__8731.cljs$lang$protocol_mask$partition0$ & (64))) || (map__8731.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8731):map__8731);
var id_selected_QMARK_ = cljs.core.get.call(null,map__8731__$1,new cljs.core.Keyword(null,"id-selected?","id-selected?",1326938375));
var id_color = cljs.core.get.call(null,map__8731__$1,new cljs.core.Keyword(null,"id-color","id-color",-484052665));
var m__GT_s = hatti.map.viewby.marker_styler.call(null,id_color,id_selected_QMARK_);
var seq__8733 = cljs.core.seq.call(null,markers);
var chunk__8734 = null;
var count__8735 = (0);
var i__8736 = (0);
while(true){
if((i__8736 < count__8735)){
var marker = cljs.core._nth.call(null,chunk__8734,i__8736);
hatti.map.utils.re_style_marker.call(null,m__GT_s,marker);

hatti.map.utils.bring_to_top_if_selected.call(null,id_selected_QMARK_,marker);

var G__8737 = seq__8733;
var G__8738 = chunk__8734;
var G__8739 = count__8735;
var G__8740 = (i__8736 + (1));
seq__8733 = G__8737;
chunk__8734 = G__8738;
count__8735 = G__8739;
i__8736 = G__8740;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__8733);
if(temp__4657__auto__){
var seq__8733__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8733__$1)){
var c__5383__auto__ = cljs.core.chunk_first.call(null,seq__8733__$1);
var G__8741 = cljs.core.chunk_rest.call(null,seq__8733__$1);
var G__8742 = c__5383__auto__;
var G__8743 = cljs.core.count.call(null,c__5383__auto__);
var G__8744 = (0);
seq__8733 = G__8741;
chunk__8734 = G__8742;
count__8735 = G__8743;
i__8736 = G__8744;
continue;
} else {
var marker = cljs.core.first.call(null,seq__8733__$1);
hatti.map.utils.re_style_marker.call(null,m__GT_s,marker);

hatti.map.utils.bring_to_top_if_selected.call(null,id_selected_QMARK_,marker);

var G__8745 = cljs.core.next.call(null,seq__8733__$1);
var G__8746 = null;
var G__8747 = (0);
var G__8748 = (0);
seq__8733 = G__8745;
chunk__8734 = G__8746;
count__8735 = G__8747;
i__8736 = G__8748;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Given a list of answers + query, returns map from answers to true/false.
 * True if query is in the answer, false if not.
 */
hatti.map.viewby.filter_answer_data_structures = (function hatti$map$viewby$filter_answer_data_structures(answers,query,field,language){
var query_present_QMARK_ = (function (ans){
if(cljs.core.truth_(ans)){
return cljs.core.re_find.call(null,chimera.js_interop.safe_regex.call(null,query),hatti.ona.forms.format_answer.call(null,field,ans,language));
} else {
return null;
}
});
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"visible-answers","visible-answers",-771956023),cljs.core.filter.call(null,query_present_QMARK_,answers),new cljs.core.Keyword(null,"answer->selected?","answer->selected?",2082517958),cljs.core.zipmap.call(null,answers,cljs.core.map.call(null,query_present_QMARK_,answers))], null);
});
/**
 * This function appropriately toggles answer->selected? when answer is clicked
 * answer->selected? is a map from answers to true/false. Special rules:
 * First click = select the answer. If nothing clicked, make everything
 * clicked.
 */
hatti.map.viewby.toggle_answer_selected = (function hatti$map$viewby$toggle_answer_selected(answer__GT_selected_QMARK_,visible_answers,answer){
var all_answers = cljs.core.vals.call(null,answer__GT_selected_QMARK_);
var all_visible_selected_QMARK_ = ((function (all_answers){
return (function (a__GT_s,visible){
return cljs.core._EQ_.call(null,cljs.core.set.call(null,visible),cljs.core.set.call(null,cljs.core.keys.call(null,cljs.core.filter.call(null,cljs.core.second,a__GT_s))));
});})(all_answers))
;
if((answer == null)){
return answer__GT_selected_QMARK_;
} else {
if(cljs.core.truth_(all_visible_selected_QMARK_.call(null,answer__GT_selected_QMARK_,visible_answers))){
return cljs.core.merge.call(null,cljs.core.zipmap.call(null,all_answers,cljs.core.repeat.call(null,false)),cljs.core.PersistentArrayMap.fromArray([answer,true], true, false));
} else {
var toggled = cljs.core.update_in.call(null,answer__GT_selected_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer], null),cljs.core.not);
if(cljs.core.every_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.vals.call(null,toggled))){
return cljs.core.merge.call(null,cljs.core.zipmap.call(null,all_answers,cljs.core.repeat.call(null,false)),hatti.map.viewby.all_but_nil_selected.call(null,visible_answers));
} else {
return toggled;
}
}
}
});
