// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.stream');
goog.require('cljs.core');
goog.require('cljs.core.async');
hatti.ona.stream.small_delay = (10);
/**
 * Calls callback on aggregated data that come via messages in channel.
 * Callback accepts two arguments: data (cljs list), and completed? (bool)
 *   If there is a parser in message, resume it after a timeout.
 */
hatti.ona.stream.process_aggregated_data_BANG_ = (function hatti$ona$stream$process_aggregated_data_BANG_(agg_data_channel,callback){
var c__8308__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8308__auto__){
return (function (){
var f__8309__auto__ = (function (){var switch__8287__auto__ = ((function (c__8308__auto__){
return (function (state_26967){
var state_val_26968 = (state_26967[(1)]);
if((state_val_26968 === (7))){
var inst_26924 = (state_26967[(7)]);
var inst_26924__$1 = (state_26967[(2)]);
var inst_26926 = (inst_26924__$1 == null);
var inst_26927 = cljs.core.not(inst_26926);
var state_26967__$1 = (function (){var statearr_26969 = state_26967;
(statearr_26969[(7)] = inst_26924__$1);

return statearr_26969;
})();
if(inst_26927){
var statearr_26970_27007 = state_26967__$1;
(statearr_26970_27007[(1)] = (8));

} else {
var statearr_26971_27008 = state_26967__$1;
(statearr_26971_27008[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26968 === (20))){
var inst_26946 = (state_26967[(8)]);
var inst_26954 = (state_26967[(2)]);
var state_26967__$1 = (function (){var statearr_26972 = state_26967;
(statearr_26972[(9)] = inst_26954);

return statearr_26972;
})();
if(cljs.core.truth_(inst_26946)){
var statearr_26973_27009 = state_26967__$1;
(statearr_26973_27009[(1)] = (21));

} else {
var statearr_26974_27010 = state_26967__$1;
(statearr_26974_27010[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26968 === (1))){
var state_26967__$1 = state_26967;
var statearr_26975_27011 = state_26967__$1;
(statearr_26975_27011[(2)] = null);

(statearr_26975_27011[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26968 === (4))){
var state_26967__$1 = state_26967;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26967__$1,(7),agg_data_channel);
} else {
if((state_val_26968 === (15))){
var inst_26924 = (state_26967[(7)]);
var state_26967__$1 = state_26967;
var statearr_26976_27012 = state_26967__$1;
(statearr_26976_27012[(2)] = inst_26924);

(statearr_26976_27012[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26968 === (21))){
var inst_26956 = cljs.core.async.close_BANG_(agg_data_channel);
var state_26967__$1 = state_26967;
var statearr_26977_27013 = state_26967__$1;
(statearr_26977_27013[(2)] = inst_26956);

(statearr_26977_27013[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26968 === (13))){
var inst_26936 = (state_26967[(2)]);
var state_26967__$1 = state_26967;
var statearr_26978_27014 = state_26967__$1;
(statearr_26978_27014[(2)] = inst_26936);

(statearr_26978_27014[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26968 === (22))){
var state_26967__$1 = state_26967;
var statearr_26979_27015 = state_26967__$1;
(statearr_26979_27015[(2)] = null);

(statearr_26979_27015[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26968 === (6))){
var inst_26963 = (state_26967[(2)]);
var state_26967__$1 = state_26967;
var statearr_26980_27016 = state_26967__$1;
(statearr_26980_27016[(2)] = inst_26963);

(statearr_26980_27016[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26968 === (17))){
var inst_26945 = (state_26967[(10)]);
var inst_26946 = (state_26967[(8)]);
var inst_26948 = (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(inst_26945,inst_26946) : callback.call(null,inst_26945,inst_26946));
var state_26967__$1 = state_26967;
var statearr_26981_27017 = state_26967__$1;
(statearr_26981_27017[(2)] = inst_26948);

(statearr_26981_27017[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26968 === (3))){
var inst_26965 = (state_26967[(2)]);
var state_26967__$1 = state_26967;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26967__$1,inst_26965);
} else {
if((state_val_26968 === (12))){
var state_26967__$1 = state_26967;
var statearr_26982_27018 = state_26967__$1;
(statearr_26982_27018[(2)] = false);

(statearr_26982_27018[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26968 === (2))){
var state_26967__$1 = state_26967;
var statearr_26983_27019 = state_26967__$1;
(statearr_26983_27019[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_26968 === (23))){
var inst_26959 = (state_26967[(2)]);
var state_26967__$1 = (function (){var statearr_26985 = state_26967;
(statearr_26985[(11)] = inst_26959);

return statearr_26985;
})();
var statearr_26986_27020 = state_26967__$1;
(statearr_26986_27020[(2)] = null);

(statearr_26986_27020[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26968 === (19))){
var inst_26951 = (state_26967[(2)]);
var inst_26952 = cljs.core.async.timeout(hatti.ona.stream.small_delay);
var state_26967__$1 = (function (){var statearr_26987 = state_26967;
(statearr_26987[(12)] = inst_26951);

return statearr_26987;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26967__$1,(20),inst_26952);
} else {
if((state_val_26968 === (11))){
var state_26967__$1 = state_26967;
var statearr_26988_27021 = state_26967__$1;
(statearr_26988_27021[(2)] = true);

(statearr_26988_27021[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26968 === (9))){
var state_26967__$1 = state_26967;
var statearr_26989_27022 = state_26967__$1;
(statearr_26989_27022[(2)] = false);

(statearr_26989_27022[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26968 === (5))){
var state_26967__$1 = state_26967;
var statearr_26990_27023 = state_26967__$1;
(statearr_26990_27023[(2)] = null);

(statearr_26990_27023[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26968 === (14))){
var inst_26924 = (state_26967[(7)]);
var inst_26941 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_26924);
var state_26967__$1 = state_26967;
var statearr_26991_27024 = state_26967__$1;
(statearr_26991_27024[(2)] = inst_26941);

(statearr_26991_27024[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26968 === (16))){
var inst_26945 = (state_26967[(10)]);
var inst_26944 = (state_26967[(2)]);
var inst_26945__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26944,cljs.core.cst$kw$data);
var inst_26946 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26944,cljs.core.cst$kw$completed_QMARK_);
var state_26967__$1 = (function (){var statearr_26992 = state_26967;
(statearr_26992[(10)] = inst_26945__$1);

(statearr_26992[(8)] = inst_26946);

return statearr_26992;
})();
if(cljs.core.truth_(inst_26945__$1)){
var statearr_26993_27025 = state_26967__$1;
(statearr_26993_27025[(1)] = (17));

} else {
var statearr_26994_27026 = state_26967__$1;
(statearr_26994_27026[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26968 === (10))){
var inst_26939 = (state_26967[(2)]);
var state_26967__$1 = state_26967;
if(cljs.core.truth_(inst_26939)){
var statearr_26995_27027 = state_26967__$1;
(statearr_26995_27027[(1)] = (14));

} else {
var statearr_26996_27028 = state_26967__$1;
(statearr_26996_27028[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26968 === (18))){
var state_26967__$1 = state_26967;
var statearr_26997_27029 = state_26967__$1;
(statearr_26997_27029[(2)] = null);

(statearr_26997_27029[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26968 === (8))){
var inst_26924 = (state_26967[(7)]);
var inst_26929 = inst_26924.cljs$lang$protocol_mask$partition0$;
var inst_26930 = (inst_26929 & (64));
var inst_26931 = inst_26924.cljs$core$ISeq$;
var inst_26932 = (inst_26930) || (inst_26931);
var state_26967__$1 = state_26967;
if(cljs.core.truth_(inst_26932)){
var statearr_26998_27030 = state_26967__$1;
(statearr_26998_27030[(1)] = (11));

} else {
var statearr_26999_27031 = state_26967__$1;
(statearr_26999_27031[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8308__auto__))
;
return ((function (switch__8287__auto__,c__8308__auto__){
return (function() {
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8288__auto__ = null;
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8288__auto____0 = (function (){
var statearr_27003 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27003[(0)] = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8288__auto__);

(statearr_27003[(1)] = (1));

return statearr_27003;
});
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8288__auto____1 = (function (state_26967){
while(true){
var ret_value__8289__auto__ = (function (){try{while(true){
var result__8290__auto__ = switch__8287__auto__(state_26967);
if(cljs.core.keyword_identical_QMARK_(result__8290__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8290__auto__;
}
break;
}
}catch (e27004){if((e27004 instanceof Object)){
var ex__8291__auto__ = e27004;
var statearr_27005_27032 = state_26967;
(statearr_27005_27032[(5)] = ex__8291__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_26967);

return cljs.core.cst$kw$recur;
} else {
throw e27004;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8289__auto__,cljs.core.cst$kw$recur)){
var G__27033 = state_26967;
state_26967 = G__27033;
continue;
} else {
return ret_value__8289__auto__;
}
break;
}
});
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8288__auto__ = function(state_26967){
switch(arguments.length){
case 0:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8288__auto____0.call(this);
case 1:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8288__auto____1.call(this,state_26967);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8288__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8288__auto____0;
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8288__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8288__auto____1;
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8288__auto__;
})()
;})(switch__8287__auto__,c__8308__auto__))
})();
var state__8310__auto__ = (function (){var statearr_27006 = (f__8309__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8309__auto__.cljs$core$IFn$_invoke$arity$0() : f__8309__auto__.call(null));
(statearr_27006[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8308__auto__);

return statearr_27006;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8310__auto__);
});})(c__8308__auto__))
);

return c__8308__auto__;
});
/**
 * On each step of data, increment read-count atom, and put data in a list agg.
 * After a exponentially increasing # of steps have been processed,
 * the aggregated data gets flushed into a channel, and parser is paused.
 * The channel reader should resume the parser after processing the data.
 */
hatti.ona.stream.read_next_chunk_BANG_ = (function hatti$ona$stream$read_next_chunk_BANG_(data_chunk,read_count,agg,channel){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(read_count,cljs.core.inc);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(agg,cljs.core.conj,data_chunk);

if((((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)) >= (100))) && (cljs.core.integer_QMARK_(Math.log10((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)))))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg))], null));

var G__27036_27038 = agg;
var G__27037_27039 = cljs.core.PersistentVector.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__27036_27038,G__27037_27039) : cljs.core.reset_BANG_.call(null,G__27036_27038,G__27037_27039));

return oboe.drop();
} else {
return null;
}
});
/**
 * Given url, a node pattern matcher, and a callback, streaming-read json.
 */
hatti.ona.stream.streamingly_read_json_BANG_ = (function hatti$ona$stream$streamingly_read_json_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___27047 = arguments.length;
var i__5628__auto___27048 = (0);
while(true){
if((i__5628__auto___27048 < len__5627__auto___27047)){
args__5634__auto__.push((arguments[i__5628__auto___27048]));

var G__27049 = (i__5628__auto___27048 + (1));
i__5628__auto___27048 = G__27049;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (url,stepfn,p__27043){
var map__27044 = p__27043;
var map__27044__$1 = ((((!((map__27044 == null)))?((((map__27044.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27044.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27044):map__27044);
var oboe_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27044__$1,cljs.core.cst$kw$oboe_DASH_headers);
var read_count = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0)) : cljs.core.atom.call(null,(0)));
var agg = (function (){var G__27046 = cljs.core.PersistentVector.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__27046) : cljs.core.atom.call(null,G__27046));
})();
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var return_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var oboe_params = cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$headers,oboe_headers,cljs.core.cst$kw$withCredentials,true], null));
var step = ((function (read_count,agg,channel,return_channel,oboe_params,map__27044,map__27044__$1,oboe_headers){
return (function (line){
return hatti.ona.stream.read_next_chunk_BANG_(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(line),read_count,agg,channel);
});})(read_count,agg,channel,return_channel,oboe_params,map__27044,map__27044__$1,oboe_headers))
;
var done = ((function (read_count,agg,channel,return_channel,oboe_params,step,map__27044,map__27044__$1,oboe_headers){
return (function (){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg)),cljs.core.cst$kw$completed_QMARK_,true], null));

return cljs.core.async.close_BANG_(return_channel);
});})(read_count,agg,channel,return_channel,oboe_params,step,map__27044,map__27044__$1,oboe_headers))
;
hatti.ona.stream.process_aggregated_data_BANG_(channel,stepfn);

window.oboe(oboe_params).node("!.*",step).done(done);

return return_channel;
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$applyTo = (function (seq27040){
var G__27041 = cljs.core.first(seq27040);
var seq27040__$1 = cljs.core.next(seq27040);
var G__27042 = cljs.core.first(seq27040__$1);
var seq27040__$2 = cljs.core.next(seq27040__$1);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__27041,G__27042,seq27040__$2);
});
