// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('chimera.js_interop');
goog.require('cljs.core');
goog.require('cognitect.transit');
goog.require('goog.string');
/**
 * Convert json string to cljs object using transit.
 * Fast, but doesn't preserve keywords.
 */
chimera.js_interop.json__GT_cljs = (function chimera$js_interop$json__GT_cljs(s){
return cognitect.transit.read(cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$json),s);
});
/**
 * Convert json to js using JSON.parse.
 * If error occurs, return the string unmodified.
 */
chimera.js_interop.str__GT_json = (function chimera$js_interop$str__GT_json(string){
try{return JSON.parse(string);
}catch (e30172){if((e30172 instanceof Error)){
var _ = e30172;
return string;
} else {
throw e30172;

}
}});
/**
 * Convert json string to cljs via js.
 * Slow method, but preserves keywords, and appropriate for small json.
 */
chimera.js_interop.json__GT_js__GT_cljs = (function chimera$js_interop$json__GT_js__GT_cljs(s){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(chimera.js_interop.str__GT_json(s),cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Formats a string using goog.string.format, so we can use format in cljx.
 */
chimera.js_interop.format = (function chimera$js_interop$format(var_args){
var args__5634__auto__ = [];
var len__5627__auto___30175 = arguments.length;
var i__5628__auto___30176 = (0);
while(true){
if((i__5628__auto___30176 < len__5627__auto___30175)){
args__5634__auto__.push((arguments[i__5628__auto___30176]));

var G__30177 = (i__5628__auto___30176 + (1));
i__5628__auto___30176 = G__30177;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(goog.string.format,fmt,args);
});

chimera.js_interop.format.cljs$lang$maxFixedArity = (1);

chimera.js_interop.format.cljs$lang$applyTo = (function (seq30173){
var G__30174 = cljs.core.first(seq30173);
var seq30173__$1 = cljs.core.next(seq30173);
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic(G__30174,seq30173__$1);
});
/**
 * Create a safe (escaped) js regex out of a string.
 * By default, creates regex with ignore case option.
 */
chimera.js_interop.safe_regex = (function chimera$js_interop$safe_regex(var_args){
var args__5634__auto__ = [];
var len__5627__auto___30183 = arguments.length;
var i__5628__auto___30184 = (0);
while(true){
if((i__5628__auto___30184 < len__5627__auto___30183)){
args__5634__auto__.push((arguments[i__5628__auto___30184]));

var G__30185 = (i__5628__auto___30184 + (1));
i__5628__auto___30184 = G__30185;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic = (function (query_string,p__30180){
var map__30181 = p__30180;
var map__30181__$1 = ((((!((map__30181 == null)))?((((map__30181.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30181.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30181):map__30181);
var ignore_case_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__30181__$1,cljs.core.cst$kw$ignore_DASH_case_QMARK_,true);
return cljs.core.re_pattern([cljs.core.str((cljs.core.truth_(ignore_case_QMARK_)?"(?i)":null)),cljs.core.str(goog.string.regExpEscape(query_string))].join(''));
});

chimera.js_interop.safe_regex.cljs$lang$maxFixedArity = (1);

chimera.js_interop.safe_regex.cljs$lang$applyTo = (function (seq30178){
var G__30179 = cljs.core.first(seq30178);
var seq30178__$1 = cljs.core.next(seq30178);
return chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic(G__30179,seq30178__$1);
});
