// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.map.utils');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('hatti.constants');
goog.require('hatti.ona.forms');
goog.require('hatti.utils');
hatti.map.utils.ona_styles = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"point","point",1813198264),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"normal","normal",-1519123858),{"radius": (6), "fillColor": "#f30", "reset": {"fillColor": "#f30"}, "color": "#fff", "border": (8), "opacity": 0.5, "fillOpacity": 0.9},new cljs.core.Keyword(null,"hover","hover",-341141711),{"fillColor": "#631400"},new cljs.core.Keyword(null,"clicked","clicked",114423720),{"fillColor": "#ad2300"}], null),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"normal","normal",-1519123858),{"fillColor": "#f30", "color": "#666", "weight": (3), "dashArray": "3", "fillOpacity": 0.7, "opacity": 0.8},new cljs.core.Keyword(null,"hover","hover",-341141711),{"fillColor": "#631400", "color": "#222"},new cljs.core.Keyword(null,"clicked","clicked",114423720),{"fillColor": "#ad2300", "color": "#222"}], null),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"normal","normal",-1519123858),{"color": "#f30", "opacity": (1), "weight": (6), "reset": {"color": "#f30"}},new cljs.core.Keyword(null,"hover","hover",-341141711),{"color": "#631400"},new cljs.core.Keyword(null,"clicked","clicked",114423720),{"color": "#ad2300"}], null)], null);
/**
 * Returns geotype (:point :line or :shape) based on marker.
 */
hatti.map.utils.marker__GT_geotype = (function hatti$map$utils$marker__GT_geotype(marker){
return new cljs.core.PersistentArrayMap(null, 3, ["Point",new cljs.core.Keyword(null,"point","point",1813198264),"Polygon",new cljs.core.Keyword(null,"shape","shape",1190694006),"LineString",new cljs.core.Keyword(null,"line","line",212345235)], null).call(null,(((marker["feature"])["geometry"])["type"]));
});
/**
 * Appropriate style given style-type (:normal, :clicked, :hover), and
 * either a leaflet marker or clojurescript keyword (one of :point or :shape).
 */
hatti.map.utils.get_ona_style = (function hatti$map$utils$get_ona_style(marker_or_keyword,style_type){
var kw = (((marker_or_keyword instanceof cljs.core.Keyword))?marker_or_keyword:hatti.map.utils.marker__GT_geotype.call(null,marker_or_keyword));
return style_type.call(null,kw.call(null,hatti.map.utils.ona_styles));
});
hatti.map.utils.equivalent_style = (function hatti$map$utils$equivalent_style(s,t){

var sc = cljs.core.js__GT_clj.call(null,s);
var tc = cljs.core.js__GT_clj.call(null,t);
return cljs.core._EQ_.call(null,cljs.core.select_keys.call(null,sc,cljs.core.keys.call(null,tc)),cljs.core.select_keys.call(null,tc,cljs.core.keys.call(null,sc)));
});
hatti.map.utils.get_id = (function hatti$map$utils$get_id(marker){
return (((marker["feature"])["properties"])[hatti.constants._id]);
});
hatti.map.utils.get_rank = (function hatti$map$utils$get_rank(marker){
return (((marker["feature"])["properties"])[hatti.constants._rank]);
});
/**
 * Get the style of a marker. Second arg specifies style attribute to get.
 * eg. For marker m1, call like: (get-style m1) or (get-style m1 :fillColor)
 */
hatti.map.utils.get_style = (function hatti$map$utils$get_style(var_args){
var args8332 = [];
var len__5638__auto___8335 = arguments.length;
var i__5639__auto___8336 = (0);
while(true){
if((i__5639__auto___8336 < len__5638__auto___8335)){
args8332.push((arguments[i__5639__auto___8336]));

var G__8337 = (i__5639__auto___8336 + (1));
i__5639__auto___8336 = G__8337;
continue;
} else {
}
break;
}

var G__8334 = args8332.length;
switch (G__8334) {
case 1:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args8332.length)].join('')));

}
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1 = (function (marker){
return (marker["options"]);
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2 = (function (marker,kw){
return kw.call(null,cljs.core.js__GT_clj.call(null,hatti.map.utils.get_style.call(null,marker)));
});

hatti.map.utils.get_style.cljs$lang$maxFixedArity = 2;
/**
 * Check whether a marker is clicked, so it's style can be preserved.
 */
hatti.map.utils.is_clicked_QMARK_ = (function hatti$map$utils$is_clicked_QMARK_(marker){
return hatti.map.utils.equivalent_style.call(null,hatti.map.utils.get_style.call(null,marker),hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"clicked","clicked",114423720)));
});
/**
 * Apply a style to a marker. Style comes from a function that takes marker.
 */
hatti.map.utils.re_style_marker = (function hatti$map$utils$re_style_marker(marker__GT_style,marker){
var style = marker__GT_style.call(null,marker);
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_.call(null,marker))){
return marker.setStyle(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"reset","reset",-800929946),style], null)));
} else {
return marker.setStyle(cljs.core.clj__GT_js.call(null,cljs.core.assoc.call(null,style,new cljs.core.Keyword(null,"reset","reset",-800929946),style)));
}
});
/**
 * Reset styles pulls the 'reset' property from within a markers options,
 * clearing styles to default if nothing found.
 */
hatti.map.utils.reset_style = (function hatti$map$utils$reset_style(marker){
var temp__4655__auto__ = ((marker["options"])["reset"]);
if(cljs.core.truth_(temp__4655__auto__)){
var rstyle = temp__4655__auto__;
return marker.setStyle(rstyle);
} else {
return marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"normal","normal",-1519123858)));
}
});
/**
 * Looks at the _id in marker, and brings to top if (1) marker clicked or
 * (2) marker's id is selected (via id-selected?)
 */
hatti.map.utils.bring_to_top_if_selected = (function hatti$map$utils$bring_to_top_if_selected(id_selected_QMARK_,marker){
if(cljs.core.truth_((function (){var or__4580__auto__ = hatti.map.utils.is_clicked_QMARK_.call(null,marker);
if(cljs.core.truth_(or__4580__auto__)){
return or__4580__auto__;
} else {
return id_selected_QMARK_.call(null,hatti.map.utils.get_id.call(null,marker));
}
})())){
return marker.bringToFront();
} else {
return null;
}
});
hatti.map.utils.apply_click_style = (function hatti$map$utils$apply_click_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"clicked","clicked",114423720)));
} else {
return null;
}
});
hatti.map.utils.apply_unclick_style = (function hatti$map$utils$apply_unclick_style(marker){
if(cljs.core.truth_(marker)){
return hatti.map.utils.reset_style.call(null,marker);
} else {
return null;
}
});
hatti.map.utils.apply_hover_style = (function hatti$map$utils$apply_hover_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"hover","hover",-341141711)));
} else {
return null;
}
});
/**
 * Sets the default style on a marker.
 */
hatti.map.utils.clear_all_styles = (function hatti$map$utils$clear_all_styles(var_args){
var args__5645__auto__ = [];
var len__5638__auto___8348 = arguments.length;
var i__5639__auto___8349 = (0);
while(true){
if((i__5639__auto___8349 < len__5638__auto___8348)){
args__5645__auto__.push((arguments[i__5639__auto___8349]));

var G__8350 = (i__5639__auto___8349 + (1));
i__5639__auto___8349 = G__8350;
continue;
} else {
}
break;
}

var argseq__5646__auto__ = ((((1) < args__5645__auto__.length))?(new cljs.core.IndexedSeq(args__5645__auto__.slice((1)),(0))):null);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5646__auto__);
});

hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic = (function (markers,p__8341){
var map__8342 = p__8341;
var map__8342__$1 = ((((!((map__8342 == null)))?((((map__8342.cljs$lang$protocol_mask$partition0$ & (64))) || (map__8342.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8342):map__8342);
var preserve_clicked_QMARK_ = cljs.core.get.call(null,map__8342__$1,new cljs.core.Keyword(null,"preserve-clicked?","preserve-clicked?",-727263842),true);
var seq__8344 = cljs.core.seq.call(null,markers);
var chunk__8345 = null;
var count__8346 = (0);
var i__8347 = (0);
while(true){
if((i__8347 < count__8346)){
var marker = cljs.core._nth.call(null,chunk__8345,i__8347);
if(cljs.core.not.call(null,(function (){var and__4568__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__4568__auto__)){
return hatti.map.utils.is_clicked_QMARK_.call(null,marker);
} else {
return and__4568__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"normal","normal",-1519123858)));
} else {
}

var G__8351 = seq__8344;
var G__8352 = chunk__8345;
var G__8353 = count__8346;
var G__8354 = (i__8347 + (1));
seq__8344 = G__8351;
chunk__8345 = G__8352;
count__8346 = G__8353;
i__8347 = G__8354;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__8344);
if(temp__4657__auto__){
var seq__8344__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8344__$1)){
var c__5383__auto__ = cljs.core.chunk_first.call(null,seq__8344__$1);
var G__8355 = cljs.core.chunk_rest.call(null,seq__8344__$1);
var G__8356 = c__5383__auto__;
var G__8357 = cljs.core.count.call(null,c__5383__auto__);
var G__8358 = (0);
seq__8344 = G__8355;
chunk__8345 = G__8356;
count__8346 = G__8357;
i__8347 = G__8358;
continue;
} else {
var marker = cljs.core.first.call(null,seq__8344__$1);
if(cljs.core.not.call(null,(function (){var and__4568__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__4568__auto__)){
return hatti.map.utils.is_clicked_QMARK_.call(null,marker);
} else {
return and__4568__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"normal","normal",-1519123858)));
} else {
}

var G__8359 = cljs.core.next.call(null,seq__8344__$1);
var G__8360 = null;
var G__8361 = (0);
var G__8362 = (0);
seq__8344 = G__8359;
chunk__8345 = G__8360;
count__8346 = G__8361;
i__8347 = G__8362;
continue;
}
} else {
return null;
}
}
break;
}
});

hatti.map.utils.clear_all_styles.cljs$lang$maxFixedArity = (1);

hatti.map.utils.clear_all_styles.cljs$lang$applyTo = (function (seq8339){
var G__8340 = cljs.core.first.call(null,seq8339);
var seq8339__$1 = cljs.core.next.call(null,seq8339);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic(G__8340,seq8339__$1);
});
hatti.map.utils.read_string_or_number = (function hatti$map$utils$read_string_or_number(maybe_s){
if(typeof maybe_s === 'string'){
return cljs.reader.read_string.call(null,maybe_s);
} else {
return maybe_s;
}
});
hatti.map.utils.make_feature = (function hatti$map$utils$make_feature(geometry,record_id,index){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"Feature",new cljs.core.Keyword(null,"properties","properties",685819552),cljs.core.PersistentArrayMap.fromArray([cljs.core.keyword.call(null,hatti.constants._rank),(index + (1)),cljs.core.keyword.call(null,hatti.constants._id),record_id], true, false),new cljs.core.Keyword(null,"geometry","geometry",-405034994),geometry], null);
});
if(typeof hatti.map.utils.get_as_geom !== 'undefined'){
} else {
hatti.map.utils.get_as_geom = (function (){var method_table__5493__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5494__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5495__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5496__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5497__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"hatti.map.utils","get-as-geom"),((function (method_table__5493__auto__,prefer_table__5494__auto__,method_cache__5495__auto__,cached_hierarchy__5496__auto__,hierarchy__5497__auto__){
return (function() { 
var G__8365__delegate = function (record,field,p__8363){
var vec__8364 = p__8363;
var repeat_child_index = cljs.core.nth.call(null,vec__8364,(0),null);
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_.call(null,field))){
return new cljs.core.Keyword(null,"repeat","repeat",832692087);
} else {
return new cljs.core.Keyword(null,"default","default",-1987822328);

}
};
var G__8365 = function (record,field,var_args){
var p__8363 = null;
if (arguments.length > 2) {
var G__8366__i = 0, G__8366__a = new Array(arguments.length -  2);
while (G__8366__i < G__8366__a.length) {G__8366__a[G__8366__i] = arguments[G__8366__i + 2]; ++G__8366__i;}
  p__8363 = new cljs.core.IndexedSeq(G__8366__a,0);
} 
return G__8365__delegate.call(this,record,field,p__8363);};
G__8365.cljs$lang$maxFixedArity = 2;
G__8365.cljs$lang$applyTo = (function (arglist__8367){
var record = cljs.core.first(arglist__8367);
arglist__8367 = cljs.core.next(arglist__8367);
var field = cljs.core.first(arglist__8367);
var p__8363 = cljs.core.rest(arglist__8367);
return G__8365__delegate(record,field,p__8363);
});
G__8365.cljs$core$IFn$_invoke$arity$variadic = G__8365__delegate;
return G__8365;
})()
;})(method_table__5493__auto__,prefer_table__5494__auto__,method_cache__5495__auto__,cached_hierarchy__5496__auto__,hierarchy__5497__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5497__auto__,method_table__5493__auto__,prefer_table__5494__auto__,method_cache__5495__auto__,cached_hierarchy__5496__auto__));
})();
}
cljs.core._add_method.call(null,hatti.map.utils.get_as_geom,new cljs.core.Keyword(null,"repeat","repeat",832692087),(function (record,p__8368){
var map__8369 = p__8368;
var map__8369__$1 = ((((!((map__8369 == null)))?((((map__8369.cljs$lang$protocol_mask$partition0$ & (64))) || (map__8369.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8369):map__8369);
var field = map__8369__$1;
var children = cljs.core.get.call(null,map__8369__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var full_name = cljs.core.get.call(null,map__8369__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var iter__5352__auto__ = ((function (map__8369,map__8369__$1,field,children,full_name){
return (function hatti$map$utils$iter__8371(s__8372){
return (new cljs.core.LazySeq(null,((function (map__8369,map__8369__$1,field,children,full_name){
return (function (){
var s__8372__$1 = s__8372;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__8372__$1);
if(temp__4657__auto__){
var s__8372__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__8372__$2)){
var c__5350__auto__ = cljs.core.chunk_first.call(null,s__8372__$2);
var size__5351__auto__ = cljs.core.count.call(null,c__5350__auto__);
var b__8374 = cljs.core.chunk_buffer.call(null,size__5351__auto__);
if((function (){var i__8373 = (0);
while(true){
if((i__8373 < size__5351__auto__)){
var child_record = cljs.core._nth.call(null,c__5350__auto__,i__8373);
cljs.core.chunk_append.call(null,b__8374,(function (){var iter__5352__auto__ = ((function (i__8373,child_record,c__5350__auto__,size__5351__auto__,b__8374,s__8372__$2,temp__4657__auto__,map__8369,map__8369__$1,field,children,full_name){
return (function hatti$map$utils$iter__8371_$_iter__8383(s__8384){
return (new cljs.core.LazySeq(null,((function (i__8373,child_record,c__5350__auto__,size__5351__auto__,b__8374,s__8372__$2,temp__4657__auto__,map__8369,map__8369__$1,field,children,full_name){
return (function (){
var s__8384__$1 = s__8384;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__8384__$1);
if(temp__4657__auto____$1){
var s__8384__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__8384__$2)){
var c__5350__auto____$1 = cljs.core.chunk_first.call(null,s__8384__$2);
var size__5351__auto____$1 = cljs.core.count.call(null,c__5350__auto____$1);
var b__8386 = cljs.core.chunk_buffer.call(null,size__5351__auto____$1);
if((function (){var i__8385 = (0);
while(true){
if((i__8385 < size__5351__auto____$1)){
var child = cljs.core._nth.call(null,c__5350__auto____$1,i__8385);
cljs.core.chunk_append.call(null,b__8386,hatti.map.utils.get_as_geom.call(null,child_record,child));

var G__8391 = (i__8385 + (1));
i__8385 = G__8391;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__8386),hatti$map$utils$iter__8371_$_iter__8383.call(null,cljs.core.chunk_rest.call(null,s__8384__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__8386),null);
}
} else {
var child = cljs.core.first.call(null,s__8384__$2);
return cljs.core.cons.call(null,hatti.map.utils.get_as_geom.call(null,child_record,child),hatti$map$utils$iter__8371_$_iter__8383.call(null,cljs.core.rest.call(null,s__8384__$2)));
}
} else {
return null;
}
break;
}
});})(i__8373,child_record,c__5350__auto__,size__5351__auto__,b__8374,s__8372__$2,temp__4657__auto__,map__8369,map__8369__$1,field,children,full_name))
,null,null));
});})(i__8373,child_record,c__5350__auto__,size__5351__auto__,b__8374,s__8372__$2,temp__4657__auto__,map__8369,map__8369__$1,field,children,full_name))
;
return iter__5352__auto__.call(null,cljs.core.filter.call(null,hatti.ona.forms.geofield_QMARK_,children));
})());

var G__8392 = (i__8373 + (1));
i__8373 = G__8392;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__8374),hatti$map$utils$iter__8371.call(null,cljs.core.chunk_rest.call(null,s__8372__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__8374),null);
}
} else {
var child_record = cljs.core.first.call(null,s__8372__$2);
return cljs.core.cons.call(null,(function (){var iter__5352__auto__ = ((function (child_record,s__8372__$2,temp__4657__auto__,map__8369,map__8369__$1,field,children,full_name){
return (function hatti$map$utils$iter__8371_$_iter__8387(s__8388){
return (new cljs.core.LazySeq(null,((function (child_record,s__8372__$2,temp__4657__auto__,map__8369,map__8369__$1,field,children,full_name){
return (function (){
var s__8388__$1 = s__8388;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__8388__$1);
if(temp__4657__auto____$1){
var s__8388__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__8388__$2)){
var c__5350__auto__ = cljs.core.chunk_first.call(null,s__8388__$2);
var size__5351__auto__ = cljs.core.count.call(null,c__5350__auto__);
var b__8390 = cljs.core.chunk_buffer.call(null,size__5351__auto__);
if((function (){var i__8389 = (0);
while(true){
if((i__8389 < size__5351__auto__)){
var child = cljs.core._nth.call(null,c__5350__auto__,i__8389);
cljs.core.chunk_append.call(null,b__8390,hatti.map.utils.get_as_geom.call(null,child_record,child));

var G__8393 = (i__8389 + (1));
i__8389 = G__8393;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__8390),hatti$map$utils$iter__8371_$_iter__8387.call(null,cljs.core.chunk_rest.call(null,s__8388__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__8390),null);
}
} else {
var child = cljs.core.first.call(null,s__8388__$2);
return cljs.core.cons.call(null,hatti.map.utils.get_as_geom.call(null,child_record,child),hatti$map$utils$iter__8371_$_iter__8387.call(null,cljs.core.rest.call(null,s__8388__$2)));
}
} else {
return null;
}
break;
}
});})(child_record,s__8372__$2,temp__4657__auto__,map__8369,map__8369__$1,field,children,full_name))
,null,null));
});})(child_record,s__8372__$2,temp__4657__auto__,map__8369,map__8369__$1,field,children,full_name))
;
return iter__5352__auto__.call(null,cljs.core.filter.call(null,hatti.ona.forms.geofield_QMARK_,children));
})(),hatti$map$utils$iter__8371.call(null,cljs.core.rest.call(null,s__8372__$2)));
}
} else {
return null;
}
break;
}
});})(map__8369,map__8369__$1,field,children,full_name))
,null,null));
});})(map__8369,map__8369__$1,field,children,full_name))
;
return iter__5352__auto__.call(null,cljs.core.get.call(null,record,full_name));
}));
cljs.core._add_method.call(null,hatti.map.utils.get_as_geom,new cljs.core.Keyword(null,"default","default",-1987822328),(function (record,geofield){
var geotype = new cljs.core.PersistentArrayMap(null, 4, ["geopoint","Point","gps","Point","geoshape","Polygon","geotrace","LineString"], null).call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(geofield));
var parse = ((function (geotype){
return (function (s){
if((cljs.core.seq.call(null,s)) && (cljs.core.not_EQ_.call(null,s,"n/a"))){
var iter__5352__auto__ = ((function (geotype){
return (function hatti$map$utils$iter__8396(s__8397){
return (new cljs.core.LazySeq(null,((function (geotype){
return (function (){
var s__8397__$1 = s__8397;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__8397__$1);
if(temp__4657__auto__){
var s__8397__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__8397__$2)){
var c__5350__auto__ = cljs.core.chunk_first.call(null,s__8397__$2);
var size__5351__auto__ = cljs.core.count.call(null,c__5350__auto__);
var b__8399 = cljs.core.chunk_buffer.call(null,size__5351__auto__);
if((function (){var i__8398 = (0);
while(true){
if((i__8398 < size__5351__auto__)){
var coord_string = cljs.core._nth.call(null,c__5350__auto__,i__8398);
cljs.core.chunk_append.call(null,b__8399,(function (){var vec__8402 = clojure.string.split.call(null,coord_string,/ /);
var lat = cljs.core.nth.call(null,vec__8402,(0),null);
var lng = cljs.core.nth.call(null,vec__8402,(1),null);
var _ = cljs.core.nth.call(null,vec__8402,(2),null);
var ___$1 = cljs.core.nth.call(null,vec__8402,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string.call(null,lng),cljs.reader.read_string.call(null,lat)], null);
})());

var G__8405 = (i__8398 + (1));
i__8398 = G__8405;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__8399),hatti$map$utils$iter__8396.call(null,cljs.core.chunk_rest.call(null,s__8397__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__8399),null);
}
} else {
var coord_string = cljs.core.first.call(null,s__8397__$2);
return cljs.core.cons.call(null,(function (){var vec__8403 = clojure.string.split.call(null,coord_string,/ /);
var lat = cljs.core.nth.call(null,vec__8403,(0),null);
var lng = cljs.core.nth.call(null,vec__8403,(1),null);
var _ = cljs.core.nth.call(null,vec__8403,(2),null);
var ___$1 = cljs.core.nth.call(null,vec__8403,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string.call(null,lng),cljs.reader.read_string.call(null,lat)], null);
})(),hatti$map$utils$iter__8396.call(null,cljs.core.rest.call(null,s__8397__$2)));
}
} else {
return null;
}
break;
}
});})(geotype))
,null,null));
});})(geotype))
;
return iter__5352__auto__.call(null,clojure.string.split.call(null,s,/;/));
} else {
return null;
}
});})(geotype))
;
var coordfn = (function (){var G__8404 = geotype;
switch (G__8404) {
case "Point":
return ((function (G__8404,geotype,parse){
return (function (p1__8394_SHARP_){
return cljs.core.first.call(null,parse.call(null,p1__8394_SHARP_));
});
;})(G__8404,geotype,parse))

break;
case "LineString":
return parse;

break;
case "Polygon":
return ((function (G__8404,geotype,parse){
return (function (p1__8395_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[parse.call(null,p1__8395_SHARP_)],null));
});
;})(G__8404,geotype,parse))

break;
default:
return cljs.core.identity;

}
})();
var value = cljs.core.get.call(null,record,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(geofield));
var coords = coordfn.call(null,value);
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_.call(null,geofield))){
return new cljs.core.Keyword(null,"geom","geom",1207084371).cljs$core$IFn$_invoke$arity$1(value);
} else {
if(cljs.core.truth_((function (){var or__4580__auto__ = (coords == null);
if(or__4580__auto__){
return or__4580__auto__;
} else {
return cljs.core.some.call(null,cljs.core.nil_QMARK_,coords);
}
})())){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),geotype,new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668),coords], null);
}
}
}));
/**
 * Given the dataset, and the form schema, get out geojson.
 * Optional specification of field will map that field data to the geom.
 */
hatti.map.utils.as_geojson = (function hatti$map$utils$as_geojson(var_args){
var args8408 = [];
var len__5638__auto___8419 = arguments.length;
var i__5639__auto___8420 = (0);
while(true){
if((i__5639__auto___8420 < len__5638__auto___8419)){
args8408.push((arguments[i__5639__auto___8420]));

var G__8421 = (i__5639__auto___8420 + (1));
i__5639__auto___8420 = G__8421;
continue;
} else {
}
break;
}

var G__8410 = args8408.length;
switch (G__8410) {
case 2:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args8408.length)].join('')));

}
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2 = (function (dataset,form){
return hatti.map.utils.as_geojson.call(null,dataset,form,hatti.ona.forms.default_geofield.call(null,form));
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3 = (function (dataset,form,geofield){
if(cljs.core.truth_(geofield)){
var features = (function (){var iter__5352__auto__ = (function hatti$map$utils$iter__8411(s__8412){
return (new cljs.core.LazySeq(null,(function (){
var s__8412__$1 = s__8412;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__8412__$1);
if(temp__4657__auto__){
var s__8412__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__8412__$2)){
var c__5350__auto__ = cljs.core.chunk_first.call(null,s__8412__$2);
var size__5351__auto__ = cljs.core.count.call(null,c__5350__auto__);
var b__8414 = cljs.core.chunk_buffer.call(null,size__5351__auto__);
if((function (){var i__8413 = (0);
while(true){
if((i__8413 < size__5351__auto__)){
var vec__8417 = cljs.core._nth.call(null,c__5350__auto__,i__8413);
var idx = cljs.core.nth.call(null,vec__8417,(0),null);
var record = cljs.core.nth.call(null,vec__8417,(1),null);
var geom_or_geoms = hatti.map.utils.get_as_geom.call(null,record,geofield);
if(cljs.core.truth_(geom_or_geoms)){
cljs.core.chunk_append.call(null,b__8414,((cljs.core.map_QMARK_.call(null,geom_or_geoms))?hatti.map.utils.make_feature.call(null,geom_or_geoms,record.call(null,hatti.constants._id),idx):cljs.core.map.call(null,((function (i__8413,s__8412__$1,geom_or_geoms,vec__8417,idx,record,c__5350__auto__,size__5351__auto__,b__8414,s__8412__$2,temp__4657__auto__){
return (function (p1__8407_SHARP_){
return hatti.map.utils.make_feature.call(null,p1__8407_SHARP_,record.call(null,hatti.constants._id),idx);
});})(i__8413,s__8412__$1,geom_or_geoms,vec__8417,idx,record,c__5350__auto__,size__5351__auto__,b__8414,s__8412__$2,temp__4657__auto__))
,cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.flatten.call(null,geom_or_geoms)))));

var G__8423 = (i__8413 + (1));
i__8413 = G__8423;
continue;
} else {
var G__8424 = (i__8413 + (1));
i__8413 = G__8424;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__8414),hatti$map$utils$iter__8411.call(null,cljs.core.chunk_rest.call(null,s__8412__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__8414),null);
}
} else {
var vec__8418 = cljs.core.first.call(null,s__8412__$2);
var idx = cljs.core.nth.call(null,vec__8418,(0),null);
var record = cljs.core.nth.call(null,vec__8418,(1),null);
var geom_or_geoms = hatti.map.utils.get_as_geom.call(null,record,geofield);
if(cljs.core.truth_(geom_or_geoms)){
return cljs.core.cons.call(null,((cljs.core.map_QMARK_.call(null,geom_or_geoms))?hatti.map.utils.make_feature.call(null,geom_or_geoms,record.call(null,hatti.constants._id),idx):cljs.core.map.call(null,((function (s__8412__$1,geom_or_geoms,vec__8418,idx,record,s__8412__$2,temp__4657__auto__){
return (function (p1__8407_SHARP_){
return hatti.map.utils.make_feature.call(null,p1__8407_SHARP_,record.call(null,hatti.constants._id),idx);
});})(s__8412__$1,geom_or_geoms,vec__8418,idx,record,s__8412__$2,temp__4657__auto__))
,cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.flatten.call(null,geom_or_geoms)))),hatti$map$utils$iter__8411.call(null,cljs.core.rest.call(null,s__8412__$2)));
} else {
var G__8425 = cljs.core.rest.call(null,s__8412__$2);
s__8412__$1 = G__8425;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5352__auto__.call(null,hatti.utils.indexed.call(null,dataset));
})();
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"FeatureCollection",new cljs.core.Keyword(null,"features","features",-1146962336),cljs.core.flatten.call(null,features)], null);
} else {
return null;
}
});

hatti.map.utils.as_geojson.cljs$lang$maxFixedArity = 3;
/**
 * Creates a leaflet map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_map = (function hatti$map$utils$create_map(id,p__8427){
var map__8430 = p__8427;
var map__8430__$1 = ((((!((map__8430 == null)))?((((map__8430.cljs$lang$protocol_mask$partition0$ & (64))) || (map__8430.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8430):map__8430);
var mapbox_tiles = cljs.core.get.call(null,map__8430__$1,new cljs.core.Keyword(null,"mapbox-tiles","mapbox-tiles",69952469));
var include_google_maps_QMARK_ = cljs.core.get.call(null,map__8430__$1,new cljs.core.Keyword(null,"include-google-maps?","include-google-maps?",1820261665));
var layers = cljs.core.map.call(null,((function (map__8430,map__8430__$1,mapbox_tiles,include_google_maps_QMARK_){
return (function (p1__8426_SHARP_){
return L.tileLayer(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(p1__8426_SHARP_));
});})(map__8430,map__8430__$1,mapbox_tiles,include_google_maps_QMARK_))
,mapbox_tiles);
var nlayers = cljs.core.zipmap.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"name","name",1843675177),mapbox_tiles),layers);
var named_layers = (cljs.core.truth_(include_google_maps_QMARK_)?cljs.core.clj__GT_js.call(null,cljs.core.assoc.call(null,nlayers,"Google Satellite",new L.Google)):cljs.core.clj__GT_js.call(null,nlayers));
var m = L.map(id,{"layers": cljs.core.first.call(null,layers), "zoomControl": false});
var z = L.control.zoom.call(null,{"position": "bottomleft"});
z.addTo(m);

L.control.layers.call(null,named_layers,null,{"position": "bottomleft"}).addTo(m);

m.setView([(0),(0)],(1));

return m;
});
/**
 * Mouse events for markers.
 *   On click or arrow, mapped-submission-to-rank events are generated.
 *   On hover, marker is brought to the front and color changed.
 */
hatti.map.utils.register_mouse_events = (function hatti$map$utils$register_mouse_events(feature,marker,event_chan){
marker.on("click",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_.call(null,marker))){
return null;
} else {
return cljs.core.async.put_BANG_.call(null,event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mapped-submission-to-rank","mapped-submission-to-rank",-1281314361),((feature["properties"])[hatti.constants._rank])], null));
}
}));

marker.on("mouseover",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_.call(null,marker))){
return null;
} else {
return hatti.map.utils.apply_hover_style.call(null,marker);
}
}));

return marker.on("mouseout",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_.call(null,marker))){
return null;
} else {
return hatti.map.utils.apply_unclick_style.call(null,marker);
}
}));
});
/**
 * Re-renders map by invalidating leaflet size.
 * If map is zoomed out beyond layer-bounds, re-zooms to layer.
 */
hatti.map.utils.re_render_map_BANG_ = (function hatti$map$utils$re_render_map_BANG_(leaflet_map,feature_layer){
var map_bounds = leaflet_map.getBounds();
var layer_bounds = feature_layer.getBounds();
leaflet_map.invalidateSize(false);

if(((leaflet_map.getZoom() === (0))) || (cljs.core.not.call(null,layer_bounds.contains(map_bounds)))){
return leaflet_map.fitBounds(layer_bounds);
} else {
return null;
}
});
/**
 * Create a map with the given GeoJSON data.
 * Adds mouse events and centers on the geojson features.
 */
hatti.map.utils.load_geo_json = (function hatti$map$utils$load_geo_json(var_args){
var args__5645__auto__ = [];
var len__5638__auto___8444 = arguments.length;
var i__5639__auto___8445 = (0);
while(true){
if((i__5639__auto___8445 < len__5638__auto___8444)){
args__5645__auto__.push((arguments[i__5639__auto___8445]));

var G__8446 = (i__5639__auto___8445 + (1));
i__5639__auto___8445 = G__8446;
continue;
} else {
}
break;
}

var argseq__5646__auto__ = ((((3) < args__5645__auto__.length))?(new cljs.core.IndexedSeq(args__5645__auto__.slice((3)),(0))):null);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5646__auto__);
});

hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic = (function (m,geojson,event_chan,p__8441){
var map__8442 = p__8441;
var map__8442__$1 = ((((!((map__8442 == null)))?((((map__8442.cljs$lang$protocol_mask$partition0$ & (64))) || (map__8442.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8442):map__8442);
var rezoom_QMARK_ = cljs.core.get.call(null,map__8442__$1,new cljs.core.Keyword(null,"rezoom?","rezoom?",746240707));
var on_events = ((function (map__8442,map__8442__$1,rezoom_QMARK_){
return (function (p1__8432_SHARP_,p2__8433_SHARP_){
return hatti.map.utils.register_mouse_events.call(null,p1__8432_SHARP_,p2__8433_SHARP_,event_chan);
});})(map__8442,map__8442__$1,rezoom_QMARK_))
;
var geometry_type = new cljs.core.PersistentArrayMap(null, 3, ["Point",new cljs.core.Keyword(null,"point","point",1813198264),"Polygon",new cljs.core.Keyword(null,"shape","shape",1190694006),"LineString",new cljs.core.Keyword(null,"line","line",212345235)], null).call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"geometry","geometry",-405034994).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geojson)))));
var stylefn = ((function (on_events,geometry_type,map__8442,map__8442__$1,rezoom_QMARK_){
return (function (){
return hatti.map.utils.get_ona_style.call(null,geometry_type,new cljs.core.Keyword(null,"normal","normal",-1519123858));
});})(on_events,geometry_type,map__8442,map__8442__$1,rezoom_QMARK_))
;
var point__GT_marker = ((function (on_events,geometry_type,stylefn,map__8442,map__8442__$1,rezoom_QMARK_){
return (function (p1__8435_SHARP_,p2__8434_SHARP_){
return L.circleMarker(p2__8434_SHARP_);
});})(on_events,geometry_type,stylefn,map__8442,map__8442__$1,rezoom_QMARK_))
;
var feature_layer = L.geoJson(cljs.core.clj__GT_js.call(null,geojson),{"onEachFeature": on_events, "pointToLayer": point__GT_marker, "style": stylefn});
var ids = cljs.core.map.call(null,((function (on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__8442,map__8442__$1,rezoom_QMARK_){
return (function (p1__8436_SHARP_){
return cljs.core.get_in.call(null,p1__8436_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"properties","properties",685819552),cljs.core.keyword.call(null,hatti.constants._id)], null));
});})(on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__8442,map__8442__$1,rezoom_QMARK_))
,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geojson));
var markers = feature_layer.getLayers();
if(cljs.core.seq.call(null,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geojson))){
if(cljs.core.truth_(rezoom_QMARK_)){
m.fitBounds(feature_layer.getBounds());
} else {
}

feature_layer.addTo(m);
} else {
}

return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"feature-layer","feature-layer",2086639246),feature_layer,new cljs.core.Keyword(null,"markers","markers",-246919693),markers,new cljs.core.Keyword(null,"id->marker","id->marker",-1702427771),cljs.core.zipmap.call(null,ids,markers)], null);
});

hatti.map.utils.load_geo_json.cljs$lang$maxFixedArity = (3);

hatti.map.utils.load_geo_json.cljs$lang$applyTo = (function (seq8437){
var G__8438 = cljs.core.first.call(null,seq8437);
var seq8437__$1 = cljs.core.next.call(null,seq8437);
var G__8439 = cljs.core.first.call(null,seq8437__$1);
var seq8437__$2 = cljs.core.next.call(null,seq8437__$1);
var G__8440 = cljs.core.first.call(null,seq8437__$2);
var seq8437__$3 = cljs.core.next.call(null,seq8437__$2);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic(G__8438,G__8439,G__8440,seq8437__$3);
});
