// Compiled by ClojureScript 1.7.145 {}
goog.provide('chimera.js_interop');
goog.require('cljs.core');
goog.require('cognitect.transit');
goog.require('goog.string');
/**
 * Convert json string to cljs object using transit.
 * Fast, but doesn't preserve keywords.
 */
chimera.js_interop.json__GT_cljs = (function chimera$js_interop$json__GT_cljs(s){
return cognitect.transit.read.call(null,cognitect.transit.reader.call(null,new cljs.core.Keyword(null,"json","json",1279968570)),s);
});
/**
 * Convert json to js using JSON.parse.
 * If error occurs, return the string unmodified.
 */
chimera.js_interop.str__GT_json = (function chimera$js_interop$str__GT_json(string){
try{return JSON.parse(string);
}catch (e12143){if((e12143 instanceof Error)){
var _ = e12143;
return string;
} else {
throw e12143;

}
}});
/**
 * Convert json string to cljs via js.
 * Slow method, but preserves keywords, and appropriate for small json.
 */
chimera.js_interop.json__GT_js__GT_cljs = (function chimera$js_interop$json__GT_js__GT_cljs(s){
return cljs.core.js__GT_clj.call(null,chimera.js_interop.str__GT_json.call(null,s),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});
/**
 * Formats a string using goog.string.format, so we can use format in cljx.
 */
chimera.js_interop.format = (function chimera$js_interop$format(var_args){
var args__5645__auto__ = [];
var len__5638__auto___12146 = arguments.length;
var i__5639__auto___12147 = (0);
while(true){
if((i__5639__auto___12147 < len__5638__auto___12146)){
args__5645__auto__.push((arguments[i__5639__auto___12147]));

var G__12148 = (i__5639__auto___12147 + (1));
i__5639__auto___12147 = G__12148;
continue;
} else {
}
break;
}

var argseq__5646__auto__ = ((((1) < args__5645__auto__.length))?(new cljs.core.IndexedSeq(args__5645__auto__.slice((1)),(0))):null);
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5646__auto__);
});

chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return cljs.core.apply.call(null,goog.string.format,fmt,args);
});

chimera.js_interop.format.cljs$lang$maxFixedArity = (1);

chimera.js_interop.format.cljs$lang$applyTo = (function (seq12144){
var G__12145 = cljs.core.first.call(null,seq12144);
var seq12144__$1 = cljs.core.next.call(null,seq12144);
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic(G__12145,seq12144__$1);
});
/**
 * Create a safe (escaped) js regex out of a string.
 * By default, creates regex with ignore case option.
 */
chimera.js_interop.safe_regex = (function chimera$js_interop$safe_regex(var_args){
var args__5645__auto__ = [];
var len__5638__auto___12154 = arguments.length;
var i__5639__auto___12155 = (0);
while(true){
if((i__5639__auto___12155 < len__5638__auto___12154)){
args__5645__auto__.push((arguments[i__5639__auto___12155]));

var G__12156 = (i__5639__auto___12155 + (1));
i__5639__auto___12155 = G__12156;
continue;
} else {
}
break;
}

var argseq__5646__auto__ = ((((1) < args__5645__auto__.length))?(new cljs.core.IndexedSeq(args__5645__auto__.slice((1)),(0))):null);
return chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5646__auto__);
});

chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic = (function (query_string,p__12151){
var map__12152 = p__12151;
var map__12152__$1 = ((((!((map__12152 == null)))?((((map__12152.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12152.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12152):map__12152);
var ignore_case_QMARK_ = cljs.core.get.call(null,map__12152__$1,new cljs.core.Keyword(null,"ignore-case?","ignore-case?",-956106212),true);
return cljs.core.re_pattern.call(null,[cljs.core.str((cljs.core.truth_(ignore_case_QMARK_)?"(?i)":null)),cljs.core.str(goog.string.regExpEscape(query_string))].join(''));
});

chimera.js_interop.safe_regex.cljs$lang$maxFixedArity = (1);

chimera.js_interop.safe_regex.cljs$lang$applyTo = (function (seq12149){
var G__12150 = cljs.core.first.call(null,seq12149);
var seq12149__$1 = cljs.core.next.call(null,seq12149);
return chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic(G__12150,seq12149__$1);
});
