// Compiled by ClojureScript 1.7.145 {}
goog.provide('c2.svg');
goog.require('cljs.core');
goog.require('c2.core');
goog.require('c2.maths');
goog.require('c2.dom');
/**
 * Ensure that coordinates (potentially map of `{:x :y}`) are a seq or vector pair.
 */
c2.svg.__GT_xy = (function c2$svg$__GT_xy(coordinates){
if((cljs.core.sequential_QMARK_.call(null,coordinates)) && (cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,coordinates)))){
return coordinates;
} else {
if(cljs.core.map_QMARK_.call(null,coordinates)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(coordinates),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(coordinates)], null);
} else {
return null;
}
}
});
c2.svg.translate = (function c2$svg$translate(coordinates){
var vec__20044 = c2.svg.__GT_xy.call(null,coordinates);
var x = cljs.core.nth.call(null,vec__20044,(0),null);
var y = cljs.core.nth.call(null,vec__20044,(1),null);
return [cljs.core.str("translate("),cljs.core.str(x),cljs.core.str(","),cljs.core.str(y),cljs.core.str(")")].join('');
});
c2.svg.scale = (function c2$svg$scale(coordinates){
if(typeof coordinates === 'number'){
return [cljs.core.str("scale("),cljs.core.str(coordinates),cljs.core.str(")")].join('');
} else {
var vec__20046 = c2.svg.__GT_xy.call(null,coordinates);
var x = cljs.core.nth.call(null,vec__20046,(0),null);
var y = cljs.core.nth.call(null,vec__20046,(1),null);
return [cljs.core.str("scale("),cljs.core.str(x),cljs.core.str(","),cljs.core.str(y),cljs.core.str(")")].join('');
}
});
c2.svg.rotate = (function c2$svg$rotate(var_args){
var args20047 = [];
var len__5638__auto___20051 = arguments.length;
var i__5639__auto___20052 = (0);
while(true){
if((i__5639__auto___20052 < len__5638__auto___20051)){
args20047.push((arguments[i__5639__auto___20052]));

var G__20053 = (i__5639__auto___20052 + (1));
i__5639__auto___20052 = G__20053;
continue;
} else {
}
break;
}

var G__20049 = args20047.length;
switch (G__20049) {
case 1:
return c2.svg.rotate.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.svg.rotate.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20047.length)].join('')));

}
});

c2.svg.rotate.cljs$core$IFn$_invoke$arity$1 = (function (angle){
return c2.svg.rotate.call(null,angle,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null));
});

c2.svg.rotate.cljs$core$IFn$_invoke$arity$2 = (function (angle,coordinates){
var vec__20050 = c2.svg.__GT_xy.call(null,coordinates);
var x = cljs.core.nth.call(null,vec__20050,(0),null);
var y = cljs.core.nth.call(null,vec__20050,(1),null);
return [cljs.core.str("rotate("),cljs.core.str(angle),cljs.core.str(","),cljs.core.str(x),cljs.core.str(","),cljs.core.str(y),cljs.core.str(")")].join('');
});

c2.svg.rotate.cljs$lang$maxFixedArity = 2;
/**
 * Returns map of `{:x :y :width :height}` containing SVG element bounding box.
 * All coordinates are in userspace. Ref [SVG spec](http://www.w3.org/TR/SVG/types.html#InterfaceSVGLocatable)
 */
c2.svg.get_bounds = (function c2$svg$get_bounds($svg_el){
var b = $svg_el.getBBox();
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"x","x",2099068185),b.x,new cljs.core.Keyword(null,"y","y",-1757859776),b.y,new cljs.core.Keyword(null,"width","width",-384071477),b.width,new cljs.core.Keyword(null,"height","height",1025178622),b.height], null);
});
/**
 * Returns a transform string that will scale and center provided element `{:width :height :x :y}` within container `{:width :height}`.
 */
c2.svg.transform_to_center = (function c2$svg$transform_to_center(element,container){
var map__20059 = element;
var map__20059__$1 = ((((!((map__20059 == null)))?((((map__20059.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20059.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20059):map__20059);
var ew = cljs.core.get.call(null,map__20059__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var eh = cljs.core.get.call(null,map__20059__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var x = cljs.core.get.call(null,map__20059__$1,new cljs.core.Keyword(null,"x","x",2099068185));
var y = cljs.core.get.call(null,map__20059__$1,new cljs.core.Keyword(null,"y","y",-1757859776));
var map__20060 = container;
var map__20060__$1 = ((((!((map__20060 == null)))?((((map__20060.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20060.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20060):map__20060);
var w = cljs.core.get.call(null,map__20060__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var h = cljs.core.get.call(null,map__20060__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var s = (function (){var x__4918__auto__ = (h / eh);
var y__4919__auto__ = (w / ew);
return ((x__4918__auto__ < y__4919__auto__) ? x__4918__auto__ : y__4919__auto__);
})();
return [cljs.core.str(c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((w / (2)) - (s * (ew / (2)))),((h / (2)) - (s * (eh / (2))))], null))),cljs.core.str(" "),cljs.core.str(c2.svg.scale.call(null,s)),cljs.core.str(" "),cljs.core.str(c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(- x),(- y)], null)))].join('');
});
/**
 * Scales and centers `$svg-el` within its parent SVG container.
 * Uses parent's width and height attributes only.
 */
c2.svg.transform_to_center_BANG_ = (function c2$svg$transform_to_center_BANG_($svg_el){
var $svg = $svg_el.ownerSVGElement;
var t = c2.svg.transform_to_center.call(null,c2.svg.get_bounds.call(null,$svg_el),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"width","width",-384071477),parseFloat(c2.dom.attr.call(null,$svg,new cljs.core.Keyword(null,"width","width",-384071477))),new cljs.core.Keyword(null,"height","height",1025178622),parseFloat(c2.dom.attr.call(null,$svg,new cljs.core.Keyword(null,"height","height",1025178622)))], null));
return c2.dom.attr.call(null,$svg_el,new cljs.core.Keyword(null,"transform","transform",1381301764),t);
});
/**
 * Returns axis <g> hiccup vector for provided input `scale` and collection of `ticks` (numbers).
 * Direction away from the data frame is defined to be positive; use negative margins and widths to render axis inside of data frame.
 * 
 * Kwargs:
 * 
 * > *:orientation* &in; (`:top`, `:bottom`, `:left`, `:right`), where the axis should be relative to the data frame, defaults to `:left`
 * 
 * > *:formatter* fn run on tick values, defaults to `str`
 * 
 * > *:major-tick-width* width of ticks (minor ticks not yet implemented), defaults to 6
 * 
 * > *:text-margin* distance between axis and start of text, defaults to 9
 * 
 * > *:label* axis label, centered on axis; :left and :right orientation labels are rotated by +/- pi/2, respectively
 * 
 * > *:label-margin* distance between axis and label, defaults to 28
 */
c2.svg.axis = (function c2$svg$axis(var_args){
var args__5645__auto__ = [];
var len__5638__auto___20075 = arguments.length;
var i__5639__auto___20076 = (0);
while(true){
if((i__5639__auto___20076 < len__5638__auto___20075)){
args__5645__auto__.push((arguments[i__5639__auto___20076]));

var G__20077 = (i__5639__auto___20076 + (1));
i__5639__auto___20076 = G__20077;
continue;
} else {
}
break;
}

var argseq__5646__auto__ = ((((2) < args__5645__auto__.length))?(new cljs.core.IndexedSeq(args__5645__auto__.slice((2)),(0))):null);
return c2.svg.axis.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);
});

c2.svg.axis.cljs$core$IFn$_invoke$arity$variadic = (function (scale,ticks,p__20066){
var map__20067 = p__20066;
var map__20067__$1 = ((((!((map__20067 == null)))?((((map__20067.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20067.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20067):map__20067);
var orientation = cljs.core.get.call(null,map__20067__$1,new cljs.core.Keyword(null,"orientation","orientation",623557579),new cljs.core.Keyword(null,"left","left",-399115937));
var formatter = cljs.core.get.call(null,map__20067__$1,new cljs.core.Keyword(null,"formatter","formatter",-483008823),cljs.core.str);
var major_tick_width = cljs.core.get.call(null,map__20067__$1,new cljs.core.Keyword(null,"major-tick-width","major-tick-width",-401901043),(6));
var text_margin = cljs.core.get.call(null,map__20067__$1,new cljs.core.Keyword(null,"text-margin","text-margin",1161346978),(9));
var label = cljs.core.get.call(null,map__20067__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var label_margin = cljs.core.get.call(null,map__20067__$1,new cljs.core.Keyword(null,"label-margin","label-margin",-17690670),(28));
var vec__20069 = (function (){var G__20070 = (((orientation instanceof cljs.core.Keyword))?orientation.fqn:null);
switch (G__20070) {
case "left":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"x1","x1",-1863922247),new cljs.core.Keyword(null,"x2","x2",-1362513475),new cljs.core.Keyword(null,"y1","y1",589123466),new cljs.core.Keyword(null,"y2","y2",-718691301)], null);

break;
case "right":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"x1","x1",-1863922247),new cljs.core.Keyword(null,"x2","x2",-1362513475),new cljs.core.Keyword(null,"y1","y1",589123466),new cljs.core.Keyword(null,"y2","y2",-718691301)], null);

break;
case "top":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y1","y1",589123466),new cljs.core.Keyword(null,"y2","y2",-718691301),new cljs.core.Keyword(null,"x1","x1",-1863922247),new cljs.core.Keyword(null,"x2","x2",-1362513475)], null);

break;
case "bottom":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y1","y1",589123466),new cljs.core.Keyword(null,"y2","y2",-718691301),new cljs.core.Keyword(null,"x1","x1",-1863922247),new cljs.core.Keyword(null,"x2","x2",-1362513475)], null);

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(orientation)].join('')));

}
})();
var x = cljs.core.nth.call(null,vec__20069,(0),null);
var y = cljs.core.nth.call(null,vec__20069,(1),null);
var x1 = cljs.core.nth.call(null,vec__20069,(2),null);
var x2 = cljs.core.nth.call(null,vec__20069,(3),null);
var y1 = cljs.core.nth.call(null,vec__20069,(4),null);
var y2 = cljs.core.nth.call(null,vec__20069,(5),null);
var parity = (function (){var G__20071 = (((orientation instanceof cljs.core.Keyword))?orientation.fqn:null);
switch (G__20071) {
case "left":
return (-1);

break;
case "top":
return (-1);

break;
case "right":
return (1);

break;
case "bottom":
return (1);

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(orientation)].join('')));

}
})();
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g","g",1738089905),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),[cljs.core.str("axis "),cljs.core.str(cljs.core.name.call(null,orientation))].join('')], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"line.rule","line.rule",-722114232),cljs.core.apply.call(null,cljs.core.hash_map,cljs.core.interleave.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [y1,y2], null),new cljs.core.Keyword(null,"range","range",1639692286).cljs$core$IFn$_invoke$arity$1(scale)))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.ticks","g.ticks",28507493),c2.core.unify.call(null,cljs.core.map.call(null,cljs.core.vector,ticks,cljs.core.repeat.call(null,scale)),((function (vec__20069,x,y,x1,x2,y1,y2,parity,map__20067,map__20067__$1,orientation,formatter,major_tick_width,text_margin,label,label_margin){
return (function (p__20072){
var vec__20073 = p__20072;
var d = cljs.core.nth.call(null,vec__20073,(0),null);
var scale__$1 = cljs.core.nth.call(null,vec__20073,(1),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.tick.major-tick","g.tick.major-tick",1467819139),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),c2.svg.translate.call(null,cljs.core.PersistentArrayMap.fromArray([x,(0),y,scale__$1.call(null,d)], true, false))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),cljs.core.PersistentArrayMap.fromArray([x,(parity * text_margin)], true, false),formatter.call(null,d)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"line","line",212345235),cljs.core.PersistentArrayMap.fromArray([x1,(0),x2,(parity * major_tick_width)], true, false)], null)], null);
});})(vec__20069,x,y,x1,x2,y1,y2,parity,map__20067,map__20067__$1,orientation,formatter,major_tick_width,text_margin,label,label_margin))
)], null),(cljs.core.truth_(label)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text.label","text.label",210580295),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),[cljs.core.str(c2.svg.translate.call(null,cljs.core.PersistentArrayMap.fromArray([x,(parity * label_margin),y,c2.maths.mean.call(null,new cljs.core.Keyword(null,"range","range",1639692286).cljs$core$IFn$_invoke$arity$1(scale))], true, false))),cljs.core.str(" "),cljs.core.str((function (){var G__20074 = (((orientation instanceof cljs.core.Keyword))?orientation.fqn:null);
switch (G__20074) {
case "left":
return c2.svg.rotate.call(null,(-90));

break;
case "right":
return c2.svg.rotate.call(null,(90));

break;
default:
return "";

}
})())].join('')], null),label], null):null)], null);
});

c2.svg.axis.cljs$lang$maxFixedArity = (2);

c2.svg.axis.cljs$lang$applyTo = (function (seq20063){
var G__20064 = cljs.core.first.call(null,seq20063);
var seq20063__$1 = cljs.core.next.call(null,seq20063);
var G__20065 = cljs.core.first.call(null,seq20063__$1);
var seq20063__$2 = cljs.core.next.call(null,seq20063__$1);
return c2.svg.axis.cljs$core$IFn$_invoke$arity$variadic(G__20064,G__20065,seq20063__$2);
});
c2.svg.ArcMax = (c2.maths.Tau - 1.0E-7);
/**
 * Calculate SVG path data for a circle of `radius` starting at 3 o'clock and sweeping in positive y.
 */
c2.svg.circle = (function c2$svg$circle(var_args){
var args20081 = [];
var len__5638__auto___20085 = arguments.length;
var i__5639__auto___20086 = (0);
while(true){
if((i__5639__auto___20086 < len__5638__auto___20085)){
args20081.push((arguments[i__5639__auto___20086]));

var G__20087 = (i__5639__auto___20086 + (1));
i__5639__auto___20086 = G__20087;
continue;
} else {
}
break;
}

var G__20083 = args20081.length;
switch (G__20083) {
case 1:
return c2.svg.circle.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.svg.circle.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20081.length)].join('')));

}
});

c2.svg.circle.cljs$core$IFn$_invoke$arity$1 = (function (radius){
return c2.svg.circle.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),radius);
});

c2.svg.circle.cljs$core$IFn$_invoke$arity$2 = (function (coordinates,radius){
var vec__20084 = c2.svg.__GT_xy.call(null,coordinates);
var x = cljs.core.nth.call(null,vec__20084,(0),null);
var y = cljs.core.nth.call(null,vec__20084,(1),null);
return [cljs.core.str("M"),cljs.core.str((x + radius)),cljs.core.str(","),cljs.core.str(y),cljs.core.str("A"),cljs.core.str((x + radius)),cljs.core.str(","),cljs.core.str((y + radius)),cljs.core.str(" 0 1,1"),cljs.core.str((- (x + radius))),cljs.core.str(","),cljs.core.str(y),cljs.core.str("A"),cljs.core.str((x + radius)),cljs.core.str(","),cljs.core.str((y + radius)),cljs.core.str(" 0 1,1"),cljs.core.str((x + radius)),cljs.core.str(","),cljs.core.str(y)].join('');
});

c2.svg.circle.cljs$lang$maxFixedArity = 2;
/**
 * Calculate SVG path data for an arc.
 */
c2.svg.arc = (function c2$svg$arc(var_args){
var args__5645__auto__ = [];
var len__5638__auto___20094 = arguments.length;
var i__5639__auto___20095 = (0);
while(true){
if((i__5639__auto___20095 < len__5638__auto___20094)){
args__5645__auto__.push((arguments[i__5639__auto___20095]));

var G__20096 = (i__5639__auto___20095 + (1));
i__5639__auto___20095 = G__20096;
continue;
} else {
}
break;
}

var argseq__5646__auto__ = ((((0) < args__5645__auto__.length))?(new cljs.core.IndexedSeq(args__5645__auto__.slice((0)),(0))):null);
return c2.svg.arc.cljs$core$IFn$_invoke$arity$variadic(argseq__5646__auto__);
});

c2.svg.arc.cljs$core$IFn$_invoke$arity$variadic = (function (p__20090){
var map__20091 = p__20090;
var map__20091__$1 = ((((!((map__20091 == null)))?((((map__20091.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20091.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20091):map__20091);
var inner_radius = cljs.core.get.call(null,map__20091__$1,new cljs.core.Keyword(null,"inner-radius","inner-radius",-681823510),(0));
var outer_radius = cljs.core.get.call(null,map__20091__$1,new cljs.core.Keyword(null,"outer-radius","outer-radius",1715267468),(1));
var start_angle = cljs.core.get.call(null,map__20091__$1,new cljs.core.Keyword(null,"start-angle","start-angle",-1763140493),(0));
var end_angle = cljs.core.get.call(null,map__20091__$1,new cljs.core.Keyword(null,"end-angle","end-angle",1398887581),c2.maths.Pi);
var angle_offset = cljs.core.get.call(null,map__20091__$1,new cljs.core.Keyword(null,"angle-offset","angle-offset",-824819163),(0));
var r0 = inner_radius;
var r1 = outer_radius;
var vec__20093 = cljs.core.sort.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(angle_offset + start_angle),(angle_offset + end_angle)], null));
var a0 = cljs.core.nth.call(null,vec__20093,(0),null);
var a1 = cljs.core.nth.call(null,vec__20093,(1),null);
var da = (a1 - a0);
var large_arc_flag = (((da < c2.maths.Pi))?"0":"1");
var s0 = c2.maths.sin.call(null,a0);
var c0 = c2.maths.cos.call(null,a0);
var s1 = c2.maths.sin.call(null,a1);
var c1 = c2.maths.cos.call(null,a1);
if((da >= c2.svg.ArcMax)){
return [cljs.core.str("M0,"),cljs.core.str(r1),cljs.core.str("A"),cljs.core.str(r1),cljs.core.str(","),cljs.core.str(r1),cljs.core.str(" 0 1,1 0,"),cljs.core.str((- r1)),cljs.core.str("A"),cljs.core.str(r1),cljs.core.str(","),cljs.core.str(r1),cljs.core.str(" 0 1,1 0,"),cljs.core.str(r1),cljs.core.str(((cljs.core.not_EQ_.call(null,(0),r0))?[cljs.core.str("M0,"),cljs.core.str(r0),cljs.core.str("A"),cljs.core.str(r0),cljs.core.str(","),cljs.core.str(r0),cljs.core.str(" 0 1,0 0,"),cljs.core.str((- r0)),cljs.core.str("A"),cljs.core.str(r0),cljs.core.str(","),cljs.core.str(r0),cljs.core.str(" 0 1,0 0,"),cljs.core.str(r0)].join(''):null)),cljs.core.str("Z")].join('');
} else {
return [cljs.core.str("M"),cljs.core.str((r1 * c0)),cljs.core.str(","),cljs.core.str((r1 * s0)),cljs.core.str("A"),cljs.core.str(r1),cljs.core.str(","),cljs.core.str(r1),cljs.core.str(" 0 "),cljs.core.str(large_arc_flag),cljs.core.str(",1 "),cljs.core.str((r1 * c1)),cljs.core.str(","),cljs.core.str((r1 * s1)),cljs.core.str(((cljs.core.not_EQ_.call(null,(0),r0))?[cljs.core.str("L"),cljs.core.str((r0 * c1)),cljs.core.str(","),cljs.core.str((r0 * s1)),cljs.core.str("A"),cljs.core.str(r0),cljs.core.str(","),cljs.core.str(r0),cljs.core.str(" 0 "),cljs.core.str(large_arc_flag),cljs.core.str(",0 "),cljs.core.str((r0 * c0)),cljs.core.str(","),cljs.core.str((r0 * s0))].join(''):"L0,0")),cljs.core.str("Z")].join('');
}
});

c2.svg.arc.cljs$lang$maxFixedArity = (0);

c2.svg.arc.cljs$lang$applyTo = (function (seq20089){
return c2.svg.arc.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq20089));
});
