// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('c2.dom');
goog.require('cljs.core');
goog.require('goog.dom.forms');
goog.require('goog.dom');
goog.require('goog.dom.classes');
goog.require('singult.core');
goog.require('goog.style');
goog.require('clojure.string');
Element.prototype.matchesSelector = Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || Element.prototype.oMatchesSelector;
if(cljs.core.truth_(typeof NodeList != "undefined")){
NodeList.prototype.cljs$core$ISeqable$ = true;

NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(array__$1,(0));
});
} else {
}
HTMLCollection.prototype.cljs$core$ISeqable$ = true;

HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(array__$1,(0));
});
c2.dom.select;

/**
 * @interface
 */
c2.dom.IDom = function(){};

/**
 * Converts x to a live DOM node
 */
c2.dom.__GT_dom = (function c2$dom$__GT_dom(x){
if((!((x == null))) && (!((x.c2$dom$IDom$__GT_dom$arity$1 == null)))){
return x.c2$dom$IDom$__GT_dom$arity$1(x);
} else {
var x__5224__auto__ = (((x == null))?null:x);
var m__5225__auto__ = (c2.dom.__GT_dom[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__5225__auto__.call(null,x));
} else {
var m__5225__auto____$1 = (c2.dom.__GT_dom["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__5225__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("IDom.->dom",x);
}
}
}
});

(c2.dom.IDom["string"] = true);

(c2.dom.__GT_dom["string"] = (function (selector){
return (c2.dom.select.cljs$core$IFn$_invoke$arity$1 ? c2.dom.select.cljs$core$IFn$_invoke$arity$1(selector) : c2.dom.select.call(null,selector));
}));

cljs.core.PersistentVector.prototype.c2$dom$IDom$ = true;

cljs.core.PersistentVector.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (v){
var v__$1 = this;
return singult.core.render(v__$1);
});
if(cljs.core.truth_(typeof Node != "undefined")){
Node.prototype.c2$dom$IDom$ = true;

Node.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (node){
var node__$1 = this;
return node__$1;
});
} else {
}
/**
 * Select a single DOM node via CSS selector, optionally scoped by second arg.
 */
c2.dom.select = (function c2$dom$select(var_args){
var args42485 = [];
var len__5627__auto___42488 = arguments.length;
var i__5628__auto___42489 = (0);
while(true){
if((i__5628__auto___42489 < len__5627__auto___42488)){
args42485.push((arguments[i__5628__auto___42489]));

var G__42490 = (i__5628__auto___42489 + (1));
i__5628__auto___42489 = G__42490;
continue;
} else {
}
break;
}

var G__42487 = args42485.length;
switch (G__42487) {
case 1:
return c2.dom.select.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42485.length)].join('')));

}
});

c2.dom.select.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelector(selector);
});

c2.dom.select.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom(container).querySelector(selector);
});

c2.dom.select.cljs$lang$maxFixedArity = 2;
/**
 * Like select, but returns a collection of nodes.
 */
c2.dom.select_all = (function c2$dom$select_all(var_args){
var args42492 = [];
var len__5627__auto___42495 = arguments.length;
var i__5628__auto___42496 = (0);
while(true){
if((i__5628__auto___42496 < len__5627__auto___42495)){
args42492.push((arguments[i__5628__auto___42496]));

var G__42497 = (i__5628__auto___42496 + (1));
i__5628__auto___42496 = G__42497;
continue;
} else {
}
break;
}

var G__42494 = args42492.length;
switch (G__42494) {
case 1:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42492.length)].join('')));

}
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelectorAll(selector);
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom(container).querySelectorAll(selector);
});

c2.dom.select_all.cljs$lang$maxFixedArity = 2;
/**
 * Does live `node` match CSS `selector`?
 */
c2.dom.matches_selector_QMARK_ = (function c2$dom$matches_selector_QMARK_(node,selector){
if(cljs.core.truth_(node)){
return node.matchesSelector(selector);
} else {
return null;
}
});
/**
 * Return the children of a live DOM element.
 */
c2.dom.children = (function c2$dom$children(node){
if(cljs.core.truth_(node)){
return c2.dom.__GT_dom(node).children;
} else {
return null;
}
});
/**
 * Return parent of a live DOM node.
 */
c2.dom.parent = (function c2$dom$parent(node){
if(cljs.core.truth_(c2$dom$parent)){
return c2.dom.__GT_dom(node).parentNode;
} else {
return null;
}
});
/**
 * Make element last child of container.
 * Returns live child.
 */
c2.dom.append_BANG_ = (function c2$dom$append_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom(el);
var G__42501_42503 = c2.dom.__GT_dom(container);
var G__42502_42504 = el__$1;
goog.dom.appendChild(G__42501_42503,G__42502_42504);

return el__$1;
});
/**
 * Make element first child of container.
 * Returns live DOM child.
 */
c2.dom.prepend_BANG_ = (function c2$dom$prepend_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom(el);
var G__42508_42511 = c2.dom.__GT_dom(container);
var G__42509_42512 = el__$1;
var G__42510_42513 = (0);
goog.dom.insertChildAt(G__42508_42511,G__42509_42512,G__42510_42513);

return el__$1;
});
/**
 * Remove element from DOM and return it.
 * > *el* CSS selector or live DOM node
 */
c2.dom.remove_BANG_ = (function c2$dom$remove_BANG_(el){
var G__42515 = c2.dom.__GT_dom(el);
return goog.dom.removeNode(G__42515);
});
/**
 * Replace live DOM node with a new one, returning the latter.
 * > *old* CSS selector or live DOM node
 * > *new* CSS selector, live DOM node, or hiccup vector
 */
c2.dom.replace_BANG_ = (function c2$dom$replace_BANG_(old,new$){
var new$__$1 = c2.dom.__GT_dom(new$);
var G__42518_42520 = new$__$1;
var G__42519_42521 = c2.dom.__GT_dom(old);
goog.dom.replaceNode(G__42518_42520,G__42519_42521);

return new$__$1;
});
/**
 * Get or set inline element style.
 * 
 * `(style el)`                map of inline element styles
 * 
 * `(style el :keyword)`       value of style :keyword
 * 
 * `(style el {:keyword val})` sets inline style according to map, returns element
 * 
 * `(style el :keyword val)`   sets single style, returns element
 */
c2.dom.style = (function c2$dom$style(var_args){
var args42522 = [];
var len__5627__auto___42536 = arguments.length;
var i__5628__auto___42537 = (0);
while(true){
if((i__5628__auto___42537 < len__5627__auto___42536)){
args42522.push((arguments[i__5628__auto___42537]));

var G__42538 = (i__5628__auto___42537 + (1));
i__5628__auto___42537 = G__42538;
continue;
} else {
}
break;
}

var G__42524 = args42522.length;
switch (G__42524) {
case 1:
return c2.dom.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.style.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42522.length)].join('')));

}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$1 = (function (el){
throw (new Error("TODO: return map of element styles"));
});

c2.dom.style.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom(el);
if((x instanceof cljs.core.Keyword)){
var G__42525 = el__$1;
var G__42526 = cljs.core.name(x);
return goog.style.getComputedStyle(G__42525,G__42526);
} else {
if(cljs.core.map_QMARK_(x)){
var seq__42527_42540 = cljs.core.seq(x);
var chunk__42528_42541 = null;
var count__42529_42542 = (0);
var i__42530_42543 = (0);
while(true){
if((i__42530_42543 < count__42529_42542)){
var vec__42531_42544 = chunk__42528_42541.cljs$core$IIndexed$_nth$arity$2(null,i__42530_42543);
var k_42545 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42531_42544,(0),null);
var v_42546 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42531_42544,(1),null);
c2.dom.style.cljs$core$IFn$_invoke$arity$3(el__$1,k_42545,v_42546);

var G__42547 = seq__42527_42540;
var G__42548 = chunk__42528_42541;
var G__42549 = count__42529_42542;
var G__42550 = (i__42530_42543 + (1));
seq__42527_42540 = G__42547;
chunk__42528_42541 = G__42548;
count__42529_42542 = G__42549;
i__42530_42543 = G__42550;
continue;
} else {
var temp__4425__auto___42551 = cljs.core.seq(seq__42527_42540);
if(temp__4425__auto___42551){
var seq__42527_42552__$1 = temp__4425__auto___42551;
if(cljs.core.chunked_seq_QMARK_(seq__42527_42552__$1)){
var c__5372__auto___42553 = cljs.core.chunk_first(seq__42527_42552__$1);
var G__42554 = cljs.core.chunk_rest(seq__42527_42552__$1);
var G__42555 = c__5372__auto___42553;
var G__42556 = cljs.core.count(c__5372__auto___42553);
var G__42557 = (0);
seq__42527_42540 = G__42554;
chunk__42528_42541 = G__42555;
count__42529_42542 = G__42556;
i__42530_42543 = G__42557;
continue;
} else {
var vec__42532_42558 = cljs.core.first(seq__42527_42552__$1);
var k_42559 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42532_42558,(0),null);
var v_42560 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42532_42558,(1),null);
c2.dom.style.cljs$core$IFn$_invoke$arity$3(el__$1,k_42559,v_42560);

var G__42561 = cljs.core.next(seq__42527_42552__$1);
var G__42562 = null;
var G__42563 = (0);
var G__42564 = (0);
seq__42527_42540 = G__42561;
chunk__42528_42541 = G__42562;
count__42529_42542 = G__42563;
i__42530_42543 = G__42564;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var G__42533_42565 = c2.dom.__GT_dom(el);
var G__42534_42566 = cljs.core.name(k);
var G__42535_42567 = ((typeof v === 'string')?v:((typeof v === 'number')?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$bottom,null,cljs.core.cst$kw$top,null,cljs.core.cst$kw$width,null,cljs.core.cst$kw$right,null,cljs.core.cst$kw$height,null,cljs.core.cst$kw$left,null], null), null).call(null,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k)))?[cljs.core.str(v),cljs.core.str("px")].join(''):v):null));
goog.style.setStyle(G__42533_42565,G__42534_42566,G__42535_42567);

return el;
});

c2.dom.style.cljs$lang$maxFixedArity = 3;
/**
 * Get or set element attributes.
 * 
 * `(attr el)`                map of element attributes
 * 
 * `(attr el :keyword)`       value of attr :keyword
 * 
 * `(attr el {:keyword val})` sets element attributes according to map, returns element
 * 
 * `(attr el :keyword val)`   sets single attr, returns element
 */
c2.dom.attr = (function c2$dom$attr(var_args){
var args42568 = [];
var len__5627__auto___42583 = arguments.length;
var i__5628__auto___42584 = (0);
while(true){
if((i__5628__auto___42584 < len__5627__auto___42583)){
args42568.push((arguments[i__5628__auto___42584]));

var G__42585 = (i__5628__auto___42584 + (1));
i__5628__auto___42584 = G__42585;
continue;
} else {
}
break;
}

var G__42570 = args42568.length;
switch (G__42570) {
case 1:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42568.length)].join('')));

}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$1 = (function (el){
var attrs = c2.dom.__GT_dom(el).attributes;
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5341__auto__ = ((function (attrs){
return (function c2$dom$iter__42571(s__42572){
return (new cljs.core.LazySeq(null,((function (attrs){
return (function (){
var s__42572__$1 = s__42572;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__42572__$1);
if(temp__4425__auto__){
var s__42572__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__42572__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__42572__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__42574 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__42573 = (0);
while(true){
if((i__42573 < size__5340__auto__)){
var i = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__42573);
cljs.core.chunk_append(b__42574,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((attrs[i]).name),(attrs[i]).value], null));

var G__42587 = (i__42573 + (1));
i__42573 = G__42587;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__42574),c2$dom$iter__42571(cljs.core.chunk_rest(s__42572__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__42574),null);
}
} else {
var i = cljs.core.first(s__42572__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((attrs[i]).name),(attrs[i]).value], null),c2$dom$iter__42571(cljs.core.rest(s__42572__$2)));
}
} else {
return null;
}
break;
}
});})(attrs))
,null,null));
});})(attrs))
;
return iter__5341__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(attrs.length));
})());
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom(el);
if((x instanceof cljs.core.Keyword)){
return el__$1.getAttribute(cljs.core.name(x));
} else {
if(cljs.core.map_QMARK_(x)){
var seq__42577_42588 = cljs.core.seq(x);
var chunk__42578_42589 = null;
var count__42579_42590 = (0);
var i__42580_42591 = (0);
while(true){
if((i__42580_42591 < count__42579_42590)){
var vec__42581_42592 = chunk__42578_42589.cljs$core$IIndexed$_nth$arity$2(null,i__42580_42591);
var k_42593 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42581_42592,(0),null);
var v_42594 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42581_42592,(1),null);
c2.dom.attr.cljs$core$IFn$_invoke$arity$3(el__$1,k_42593,v_42594);

var G__42595 = seq__42577_42588;
var G__42596 = chunk__42578_42589;
var G__42597 = count__42579_42590;
var G__42598 = (i__42580_42591 + (1));
seq__42577_42588 = G__42595;
chunk__42578_42589 = G__42596;
count__42579_42590 = G__42597;
i__42580_42591 = G__42598;
continue;
} else {
var temp__4425__auto___42599 = cljs.core.seq(seq__42577_42588);
if(temp__4425__auto___42599){
var seq__42577_42600__$1 = temp__4425__auto___42599;
if(cljs.core.chunked_seq_QMARK_(seq__42577_42600__$1)){
var c__5372__auto___42601 = cljs.core.chunk_first(seq__42577_42600__$1);
var G__42602 = cljs.core.chunk_rest(seq__42577_42600__$1);
var G__42603 = c__5372__auto___42601;
var G__42604 = cljs.core.count(c__5372__auto___42601);
var G__42605 = (0);
seq__42577_42588 = G__42602;
chunk__42578_42589 = G__42603;
count__42579_42590 = G__42604;
i__42580_42591 = G__42605;
continue;
} else {
var vec__42582_42606 = cljs.core.first(seq__42577_42600__$1);
var k_42607 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42582_42606,(0),null);
var v_42608 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42582_42606,(1),null);
c2.dom.attr.cljs$core$IFn$_invoke$arity$3(el__$1,k_42607,v_42608);

var G__42609 = cljs.core.next(seq__42577_42600__$1);
var G__42610 = null;
var G__42611 = (0);
var G__42612 = (0);
seq__42577_42588 = G__42609;
chunk__42578_42589 = G__42610;
count__42579_42590 = G__42611;
i__42580_42591 = G__42612;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var el__$1 = c2.dom.__GT_dom(el);
if((v == null)){
el__$1.removeAttribute(cljs.core.name(k));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$style,k)){
c2.dom.style.cljs$core$IFn$_invoke$arity$2(el__$1,v);
} else {
el__$1.setAttribute(cljs.core.name(k),v);
}
}

return el__$1;
});

c2.dom.attr.cljs$lang$maxFixedArity = 3;
/**
 * Get or set element text, returning element
 */
c2.dom.text = (function c2$dom$text(var_args){
var args42613 = [];
var len__5627__auto___42617 = arguments.length;
var i__5628__auto___42618 = (0);
while(true){
if((i__5628__auto___42618 < len__5627__auto___42617)){
args42613.push((arguments[i__5628__auto___42618]));

var G__42619 = (i__5628__auto___42618 + (1));
i__5628__auto___42618 = G__42619;
continue;
} else {
}
break;
}

var G__42615 = args42613.length;
switch (G__42615) {
case 1:
return c2.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42613.length)].join('')));

}
});

c2.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__42616 = c2.dom.__GT_dom(el);
return goog.dom.getTextContent(G__42616);
});

c2.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom(el);
goog.dom.setTextContent(el__$1,v);

return el__$1;
});

c2.dom.text.cljs$lang$maxFixedArity = 2;
/**
 * Get or set element value.
 */
c2.dom.val = (function c2$dom$val(var_args){
var args42621 = [];
var len__5627__auto___42625 = arguments.length;
var i__5628__auto___42626 = (0);
while(true){
if((i__5628__auto___42626 < len__5627__auto___42625)){
args42621.push((arguments[i__5628__auto___42626]));

var G__42627 = (i__5628__auto___42626 + (1));
i__5628__auto___42626 = G__42627;
continue;
} else {
}
break;
}

var G__42623 = args42621.length;
switch (G__42623) {
case 1:
return c2.dom.val.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.val.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42621.length)].join('')));

}
});

c2.dom.val.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__42624 = c2.dom.__GT_dom(el);
return goog.dom.forms.getValue(G__42624);
});

c2.dom.val.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom(el);
goog.dom.forms.setValue(el__$1,v);

return el__$1;
});

c2.dom.val.cljs$lang$maxFixedArity = 2;
/**
 * Add or remove `class` to element based on boolean `classed?`, returning element.
 */
c2.dom.classed_BANG_ = (function c2$dom$classed_BANG_(el,class$,classed_QMARK_){
var G__42632_42635 = c2.dom.__GT_dom(el);
var G__42633_42636 = cljs.core.name(class$);
var G__42634_42637 = classed_QMARK_;
goog.dom.classes.enable(G__42632_42635,G__42633_42636,G__42634_42637);

return el;
});
c2.dom.add_class_BANG_ = (function c2$dom$add_class_BANG_(el,class$){
return c2.dom.classed_BANG_(el,class$,true);
});
c2.dom.remove_class_BANG_ = (function c2$dom$remove_class_BANG_(el,class$){
return c2.dom.classed_BANG_(el,class$,false);
});
c2.dom.request_animation_frame = (function (){var or__4569__auto__ = window.requestAnimationFrame;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
var or__4569__auto____$1 = window.webkitRequestAnimationFrame;
if(cljs.core.truth_(or__4569__auto____$1)){
return or__4569__auto____$1;
} else {
return ((function (or__4569__auto____$1,or__4569__auto__){
return (function (p1__42638_SHARP_){
var G__42639 = ((function (or__4569__auto____$1,or__4569__auto__){
return (function (){
return (p1__42638_SHARP_.cljs$core$IFn$_invoke$arity$0 ? p1__42638_SHARP_.cljs$core$IFn$_invoke$arity$0() : p1__42638_SHARP_.call(null));
});})(or__4569__auto____$1,or__4569__auto__))
;
var G__42640 = (10);
return setTimeout(G__42639,G__42640);
});
;})(or__4569__auto____$1,or__4569__auto__))
}
}
})();
