// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.stream');
goog.require('cljs.core');
goog.require('cljs.core.async');
hatti.ona.stream.small_delay = (10);
/**
 * Calls callback on aggregated data that come via messages in channel.
 * Callback accepts two arguments: data (cljs list), and completed? (bool)
 *   If there is a parser in message, resume it after a timeout.
 */
hatti.ona.stream.process_aggregated_data_BANG_ = (function hatti$ona$stream$process_aggregated_data_BANG_(agg_data_channel,callback){
var c__8437__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8437__auto__){
return (function (){
var f__8438__auto__ = (function (){var switch__8372__auto__ = ((function (c__8437__auto__){
return (function (state_30224){
var state_val_30225 = (state_30224[(1)]);
if((state_val_30225 === (7))){
var inst_30181 = (state_30224[(7)]);
var inst_30181__$1 = (state_30224[(2)]);
var inst_30183 = (inst_30181__$1 == null);
var inst_30184 = cljs.core.not(inst_30183);
var state_30224__$1 = (function (){var statearr_30226 = state_30224;
(statearr_30226[(7)] = inst_30181__$1);

return statearr_30226;
})();
if(inst_30184){
var statearr_30227_30264 = state_30224__$1;
(statearr_30227_30264[(1)] = (8));

} else {
var statearr_30228_30265 = state_30224__$1;
(statearr_30228_30265[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30225 === (20))){
var inst_30203 = (state_30224[(8)]);
var inst_30211 = (state_30224[(2)]);
var state_30224__$1 = (function (){var statearr_30229 = state_30224;
(statearr_30229[(9)] = inst_30211);

return statearr_30229;
})();
if(cljs.core.truth_(inst_30203)){
var statearr_30230_30266 = state_30224__$1;
(statearr_30230_30266[(1)] = (21));

} else {
var statearr_30231_30267 = state_30224__$1;
(statearr_30231_30267[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30225 === (1))){
var state_30224__$1 = state_30224;
var statearr_30232_30268 = state_30224__$1;
(statearr_30232_30268[(2)] = null);

(statearr_30232_30268[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30225 === (4))){
var state_30224__$1 = state_30224;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30224__$1,(7),agg_data_channel);
} else {
if((state_val_30225 === (15))){
var inst_30181 = (state_30224[(7)]);
var state_30224__$1 = state_30224;
var statearr_30233_30269 = state_30224__$1;
(statearr_30233_30269[(2)] = inst_30181);

(statearr_30233_30269[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30225 === (21))){
var inst_30213 = cljs.core.async.close_BANG_(agg_data_channel);
var state_30224__$1 = state_30224;
var statearr_30234_30270 = state_30224__$1;
(statearr_30234_30270[(2)] = inst_30213);

(statearr_30234_30270[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30225 === (13))){
var inst_30193 = (state_30224[(2)]);
var state_30224__$1 = state_30224;
var statearr_30235_30271 = state_30224__$1;
(statearr_30235_30271[(2)] = inst_30193);

(statearr_30235_30271[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30225 === (22))){
var state_30224__$1 = state_30224;
var statearr_30236_30272 = state_30224__$1;
(statearr_30236_30272[(2)] = null);

(statearr_30236_30272[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30225 === (6))){
var inst_30220 = (state_30224[(2)]);
var state_30224__$1 = state_30224;
var statearr_30237_30273 = state_30224__$1;
(statearr_30237_30273[(2)] = inst_30220);

(statearr_30237_30273[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30225 === (17))){
var inst_30202 = (state_30224[(10)]);
var inst_30203 = (state_30224[(8)]);
var inst_30205 = (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(inst_30202,inst_30203) : callback.call(null,inst_30202,inst_30203));
var state_30224__$1 = state_30224;
var statearr_30238_30274 = state_30224__$1;
(statearr_30238_30274[(2)] = inst_30205);

(statearr_30238_30274[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30225 === (3))){
var inst_30222 = (state_30224[(2)]);
var state_30224__$1 = state_30224;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30224__$1,inst_30222);
} else {
if((state_val_30225 === (12))){
var state_30224__$1 = state_30224;
var statearr_30239_30275 = state_30224__$1;
(statearr_30239_30275[(2)] = false);

(statearr_30239_30275[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30225 === (2))){
var state_30224__$1 = state_30224;
var statearr_30240_30276 = state_30224__$1;
(statearr_30240_30276[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_30225 === (23))){
var inst_30216 = (state_30224[(2)]);
var state_30224__$1 = (function (){var statearr_30242 = state_30224;
(statearr_30242[(11)] = inst_30216);

return statearr_30242;
})();
var statearr_30243_30277 = state_30224__$1;
(statearr_30243_30277[(2)] = null);

(statearr_30243_30277[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30225 === (19))){
var inst_30208 = (state_30224[(2)]);
var inst_30209 = cljs.core.async.timeout(hatti.ona.stream.small_delay);
var state_30224__$1 = (function (){var statearr_30244 = state_30224;
(statearr_30244[(12)] = inst_30208);

return statearr_30244;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30224__$1,(20),inst_30209);
} else {
if((state_val_30225 === (11))){
var state_30224__$1 = state_30224;
var statearr_30245_30278 = state_30224__$1;
(statearr_30245_30278[(2)] = true);

(statearr_30245_30278[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30225 === (9))){
var state_30224__$1 = state_30224;
var statearr_30246_30279 = state_30224__$1;
(statearr_30246_30279[(2)] = false);

(statearr_30246_30279[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30225 === (5))){
var state_30224__$1 = state_30224;
var statearr_30247_30280 = state_30224__$1;
(statearr_30247_30280[(2)] = null);

(statearr_30247_30280[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30225 === (14))){
var inst_30181 = (state_30224[(7)]);
var inst_30198 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_30181);
var state_30224__$1 = state_30224;
var statearr_30248_30281 = state_30224__$1;
(statearr_30248_30281[(2)] = inst_30198);

(statearr_30248_30281[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30225 === (16))){
var inst_30202 = (state_30224[(10)]);
var inst_30201 = (state_30224[(2)]);
var inst_30202__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30201,cljs.core.cst$kw$data);
var inst_30203 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30201,cljs.core.cst$kw$completed_QMARK_);
var state_30224__$1 = (function (){var statearr_30249 = state_30224;
(statearr_30249[(10)] = inst_30202__$1);

(statearr_30249[(8)] = inst_30203);

return statearr_30249;
})();
if(cljs.core.truth_(inst_30202__$1)){
var statearr_30250_30282 = state_30224__$1;
(statearr_30250_30282[(1)] = (17));

} else {
var statearr_30251_30283 = state_30224__$1;
(statearr_30251_30283[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30225 === (10))){
var inst_30196 = (state_30224[(2)]);
var state_30224__$1 = state_30224;
if(cljs.core.truth_(inst_30196)){
var statearr_30252_30284 = state_30224__$1;
(statearr_30252_30284[(1)] = (14));

} else {
var statearr_30253_30285 = state_30224__$1;
(statearr_30253_30285[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30225 === (18))){
var state_30224__$1 = state_30224;
var statearr_30254_30286 = state_30224__$1;
(statearr_30254_30286[(2)] = null);

(statearr_30254_30286[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30225 === (8))){
var inst_30181 = (state_30224[(7)]);
var inst_30186 = inst_30181.cljs$lang$protocol_mask$partition0$;
var inst_30187 = (inst_30186 & (64));
var inst_30188 = inst_30181.cljs$core$ISeq$;
var inst_30189 = (inst_30187) || (inst_30188);
var state_30224__$1 = state_30224;
if(cljs.core.truth_(inst_30189)){
var statearr_30255_30287 = state_30224__$1;
(statearr_30255_30287[(1)] = (11));

} else {
var statearr_30256_30288 = state_30224__$1;
(statearr_30256_30288[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8437__auto__))
;
return ((function (switch__8372__auto__,c__8437__auto__){
return (function() {
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8373__auto__ = null;
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8373__auto____0 = (function (){
var statearr_30260 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30260[(0)] = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8373__auto__);

(statearr_30260[(1)] = (1));

return statearr_30260;
});
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8373__auto____1 = (function (state_30224){
while(true){
var ret_value__8374__auto__ = (function (){try{while(true){
var result__8375__auto__ = switch__8372__auto__(state_30224);
if(cljs.core.keyword_identical_QMARK_(result__8375__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8375__auto__;
}
break;
}
}catch (e30261){if((e30261 instanceof Object)){
var ex__8376__auto__ = e30261;
var statearr_30262_30289 = state_30224;
(statearr_30262_30289[(5)] = ex__8376__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30224);

return cljs.core.cst$kw$recur;
} else {
throw e30261;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8374__auto__,cljs.core.cst$kw$recur)){
var G__30290 = state_30224;
state_30224 = G__30290;
continue;
} else {
return ret_value__8374__auto__;
}
break;
}
});
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8373__auto__ = function(state_30224){
switch(arguments.length){
case 0:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8373__auto____0.call(this);
case 1:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8373__auto____1.call(this,state_30224);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8373__auto____0;
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8373__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8373__auto____1;
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__8373__auto__;
})()
;})(switch__8372__auto__,c__8437__auto__))
})();
var state__8439__auto__ = (function (){var statearr_30263 = (f__8438__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8438__auto__.cljs$core$IFn$_invoke$arity$0() : f__8438__auto__.call(null));
(statearr_30263[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8437__auto__);

return statearr_30263;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8439__auto__);
});})(c__8437__auto__))
);

return c__8437__auto__;
});
/**
 * On each step of data, increment read-count atom, and put data in a list agg.
 * After a exponentially increasing # of steps have been processed,
 * the aggregated data gets flushed into a channel, and parser is paused.
 * The channel reader should resume the parser after processing the data.
 */
hatti.ona.stream.read_next_chunk_BANG_ = (function hatti$ona$stream$read_next_chunk_BANG_(data_chunk,read_count,agg,channel){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(read_count,cljs.core.inc);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(agg,cljs.core.conj,data_chunk);

if((((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)) >= (100))) && (cljs.core.integer_QMARK_(Math.log10((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)))))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg))], null));

var G__30293_30295 = agg;
var G__30294_30296 = cljs.core.PersistentVector.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__30293_30295,G__30294_30296) : cljs.core.reset_BANG_.call(null,G__30293_30295,G__30294_30296));

return oboe.drop();
} else {
return null;
}
});
/**
 * Given url, a node pattern matcher, and a callback, streaming-read json.
 */
hatti.ona.stream.streamingly_read_json_BANG_ = (function hatti$ona$stream$streamingly_read_json_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___30304 = arguments.length;
var i__5628__auto___30305 = (0);
while(true){
if((i__5628__auto___30305 < len__5627__auto___30304)){
args__5634__auto__.push((arguments[i__5628__auto___30305]));

var G__30306 = (i__5628__auto___30305 + (1));
i__5628__auto___30305 = G__30306;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (url,stepfn,p__30300){
var map__30301 = p__30300;
var map__30301__$1 = ((((!((map__30301 == null)))?((((map__30301.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30301.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30301):map__30301);
var oboe_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30301__$1,cljs.core.cst$kw$oboe_DASH_headers);
var read_count = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0)) : cljs.core.atom.call(null,(0)));
var agg = (function (){var G__30303 = cljs.core.PersistentVector.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__30303) : cljs.core.atom.call(null,G__30303));
})();
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var return_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var oboe_params = cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$headers,oboe_headers,cljs.core.cst$kw$withCredentials,true], null));
var step = ((function (read_count,agg,channel,return_channel,oboe_params,map__30301,map__30301__$1,oboe_headers){
return (function (line){
return hatti.ona.stream.read_next_chunk_BANG_(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(line),read_count,agg,channel);
});})(read_count,agg,channel,return_channel,oboe_params,map__30301,map__30301__$1,oboe_headers))
;
var done = ((function (read_count,agg,channel,return_channel,oboe_params,step,map__30301,map__30301__$1,oboe_headers){
return (function (){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg)),cljs.core.cst$kw$completed_QMARK_,true], null));

return cljs.core.async.close_BANG_(return_channel);
});})(read_count,agg,channel,return_channel,oboe_params,step,map__30301,map__30301__$1,oboe_headers))
;
hatti.ona.stream.process_aggregated_data_BANG_(channel,stepfn);

window.oboe(oboe_params).node("!.*",step).done(done);

return return_channel;
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$applyTo = (function (seq30297){
var G__30298 = cljs.core.first(seq30297);
var seq30297__$1 = cljs.core.next(seq30297);
var G__30299 = cljs.core.first(seq30297__$1);
var seq30297__$2 = cljs.core.next(seq30297__$1);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__30298,G__30299,seq30297__$2);
});
