// Compiled by ClojureScript 1.8.51 {}
goog.provide('hatti.ona.stream');
goog.require('cljs.core');
goog.require('cljs.core.async');
hatti.ona.stream.small_delay = (10);
/**
 * Calls callback on aggregated data that come via messages in channel.
 * Callback accepts two arguments: data (cljs list), and completed? (bool)
 *   If there is a parser in message, resume it after a timeout.
 */
hatti.ona.stream.process_aggregated_data_BANG_ = (function hatti$ona$stream$process_aggregated_data_BANG_(agg_data_channel,callback){
var c__11856__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11856__auto__){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto__){
return (function (state_17627){
var state_val_17628 = (state_17627[(1)]);
if((state_val_17628 === (7))){
var inst_17584 = (state_17627[(7)]);
var inst_17584__$1 = (state_17627[(2)]);
var inst_17586 = (inst_17584__$1 == null);
var inst_17587 = cljs.core.not.call(null,inst_17586);
var state_17627__$1 = (function (){var statearr_17629 = state_17627;
(statearr_17629[(7)] = inst_17584__$1);

return statearr_17629;
})();
if(inst_17587){
var statearr_17630_17667 = state_17627__$1;
(statearr_17630_17667[(1)] = (8));

} else {
var statearr_17631_17668 = state_17627__$1;
(statearr_17631_17668[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17628 === (20))){
var inst_17606 = (state_17627[(8)]);
var inst_17614 = (state_17627[(2)]);
var state_17627__$1 = (function (){var statearr_17632 = state_17627;
(statearr_17632[(9)] = inst_17614);

return statearr_17632;
})();
if(cljs.core.truth_(inst_17606)){
var statearr_17633_17669 = state_17627__$1;
(statearr_17633_17669[(1)] = (21));

} else {
var statearr_17634_17670 = state_17627__$1;
(statearr_17634_17670[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17628 === (1))){
var state_17627__$1 = state_17627;
var statearr_17635_17671 = state_17627__$1;
(statearr_17635_17671[(2)] = null);

(statearr_17635_17671[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17628 === (4))){
var state_17627__$1 = state_17627;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17627__$1,(7),agg_data_channel);
} else {
if((state_val_17628 === (15))){
var inst_17584 = (state_17627[(7)]);
var state_17627__$1 = state_17627;
var statearr_17636_17672 = state_17627__$1;
(statearr_17636_17672[(2)] = inst_17584);

(statearr_17636_17672[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17628 === (21))){
var inst_17616 = cljs.core.async.close_BANG_.call(null,agg_data_channel);
var state_17627__$1 = state_17627;
var statearr_17637_17673 = state_17627__$1;
(statearr_17637_17673[(2)] = inst_17616);

(statearr_17637_17673[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17628 === (13))){
var inst_17596 = (state_17627[(2)]);
var state_17627__$1 = state_17627;
var statearr_17638_17674 = state_17627__$1;
(statearr_17638_17674[(2)] = inst_17596);

(statearr_17638_17674[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17628 === (22))){
var state_17627__$1 = state_17627;
var statearr_17639_17675 = state_17627__$1;
(statearr_17639_17675[(2)] = null);

(statearr_17639_17675[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17628 === (6))){
var inst_17623 = (state_17627[(2)]);
var state_17627__$1 = state_17627;
var statearr_17640_17676 = state_17627__$1;
(statearr_17640_17676[(2)] = inst_17623);

(statearr_17640_17676[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17628 === (17))){
var inst_17605 = (state_17627[(10)]);
var inst_17606 = (state_17627[(8)]);
var inst_17608 = callback.call(null,inst_17605,inst_17606);
var state_17627__$1 = state_17627;
var statearr_17641_17677 = state_17627__$1;
(statearr_17641_17677[(2)] = inst_17608);

(statearr_17641_17677[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17628 === (3))){
var inst_17625 = (state_17627[(2)]);
var state_17627__$1 = state_17627;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17627__$1,inst_17625);
} else {
if((state_val_17628 === (12))){
var state_17627__$1 = state_17627;
var statearr_17642_17678 = state_17627__$1;
(statearr_17642_17678[(2)] = false);

(statearr_17642_17678[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17628 === (2))){
var state_17627__$1 = state_17627;
var statearr_17643_17679 = state_17627__$1;
(statearr_17643_17679[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17628 === (23))){
var inst_17619 = (state_17627[(2)]);
var state_17627__$1 = (function (){var statearr_17645 = state_17627;
(statearr_17645[(11)] = inst_17619);

return statearr_17645;
})();
var statearr_17646_17680 = state_17627__$1;
(statearr_17646_17680[(2)] = null);

(statearr_17646_17680[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17628 === (19))){
var inst_17611 = (state_17627[(2)]);
var inst_17612 = cljs.core.async.timeout.call(null,hatti.ona.stream.small_delay);
var state_17627__$1 = (function (){var statearr_17647 = state_17627;
(statearr_17647[(12)] = inst_17611);

return statearr_17647;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17627__$1,(20),inst_17612);
} else {
if((state_val_17628 === (11))){
var state_17627__$1 = state_17627;
var statearr_17648_17681 = state_17627__$1;
(statearr_17648_17681[(2)] = true);

(statearr_17648_17681[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17628 === (9))){
var state_17627__$1 = state_17627;
var statearr_17649_17682 = state_17627__$1;
(statearr_17649_17682[(2)] = false);

(statearr_17649_17682[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17628 === (5))){
var state_17627__$1 = state_17627;
var statearr_17650_17683 = state_17627__$1;
(statearr_17650_17683[(2)] = null);

(statearr_17650_17683[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17628 === (14))){
var inst_17584 = (state_17627[(7)]);
var inst_17601 = cljs.core.apply.call(null,cljs.core.hash_map,inst_17584);
var state_17627__$1 = state_17627;
var statearr_17651_17684 = state_17627__$1;
(statearr_17651_17684[(2)] = inst_17601);

(statearr_17651_17684[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17628 === (16))){
var inst_17605 = (state_17627[(10)]);
var inst_17604 = (state_17627[(2)]);
var inst_17605__$1 = cljs.core.get.call(null,inst_17604,new cljs.core.Keyword(null,"data","data",-232669377));
var inst_17606 = cljs.core.get.call(null,inst_17604,new cljs.core.Keyword(null,"completed?","completed?",946828354));
var state_17627__$1 = (function (){var statearr_17652 = state_17627;
(statearr_17652[(10)] = inst_17605__$1);

(statearr_17652[(8)] = inst_17606);

return statearr_17652;
})();
if(cljs.core.truth_(inst_17605__$1)){
var statearr_17653_17685 = state_17627__$1;
(statearr_17653_17685[(1)] = (17));

} else {
var statearr_17654_17686 = state_17627__$1;
(statearr_17654_17686[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17628 === (10))){
var inst_17599 = (state_17627[(2)]);
var state_17627__$1 = state_17627;
if(cljs.core.truth_(inst_17599)){
var statearr_17655_17687 = state_17627__$1;
(statearr_17655_17687[(1)] = (14));

} else {
var statearr_17656_17688 = state_17627__$1;
(statearr_17656_17688[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17628 === (18))){
var state_17627__$1 = state_17627;
var statearr_17657_17689 = state_17627__$1;
(statearr_17657_17689[(2)] = null);

(statearr_17657_17689[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17628 === (8))){
var inst_17584 = (state_17627[(7)]);
var inst_17589 = inst_17584.cljs$lang$protocol_mask$partition0$;
var inst_17590 = (inst_17589 & (64));
var inst_17591 = inst_17584.cljs$core$ISeq$;
var inst_17592 = (inst_17590) || (inst_17591);
var state_17627__$1 = state_17627;
if(cljs.core.truth_(inst_17592)){
var statearr_17658_17690 = state_17627__$1;
(statearr_17658_17690[(1)] = (11));

} else {
var statearr_17659_17691 = state_17627__$1;
(statearr_17659_17691[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto__))
;
return ((function (switch__11791__auto__,c__11856__auto__){
return (function() {
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__11792__auto__ = null;
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__11792__auto____0 = (function (){
var statearr_17663 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17663[(0)] = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__11792__auto__);

(statearr_17663[(1)] = (1));

return statearr_17663;
});
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__11792__auto____1 = (function (state_17627){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__.call(null,state_17627);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11794__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e17664){if((e17664 instanceof Object)){
var ex__11795__auto__ = e17664;
var statearr_17665_17692 = state_17627;
(statearr_17665_17692[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17627);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17664;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11793__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17693 = state_17627;
state_17627 = G__17693;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__11792__auto__ = function(state_17627){
switch(arguments.length){
case 0:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__11792__auto____0.call(this);
case 1:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__11792__auto____1.call(this,state_17627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__11792__auto____0;
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__11792__auto____1;
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto__))
})();
var state__11858__auto__ = (function (){var statearr_17666 = f__11857__auto__.call(null);
(statearr_17666[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto__);

return statearr_17666;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11858__auto__);
});})(c__11856__auto__))
);

return c__11856__auto__;
});
/**
 * On each step of data, increment read-count atom, and put data in a list agg.
 * After a exponentially increasing # of steps have been processed,
 * the aggregated data gets flushed into a channel, and parser is paused.
 * The channel reader should resume the parser after processing the data.
 */
hatti.ona.stream.read_next_chunk_BANG_ = (function hatti$ona$stream$read_next_chunk_BANG_(data_chunk,read_count,agg,channel){
cljs.core.swap_BANG_.call(null,read_count,cljs.core.inc);

cljs.core.swap_BANG_.call(null,agg,cljs.core.conj,data_chunk);

if(((cljs.core.deref.call(null,read_count) >= (100))) && (cljs.core.integer_QMARK_.call(null,Math.log10(cljs.core.deref.call(null,read_count))))){
cljs.core.async.put_BANG_.call(null,channel,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.deref.call(null,agg)], null));

cljs.core.reset_BANG_.call(null,agg,cljs.core.PersistentVector.EMPTY);

return oboe.drop();
} else {
return null;
}
});
/**
 * Given url, a node pattern matcher, and a callback, streaming-read json.
 */
hatti.ona.stream.streamingly_read_json_BANG_ = (function hatti$ona$stream$streamingly_read_json_BANG_(var_args){
var args__7287__auto__ = [];
var len__7280__auto___17700 = arguments.length;
var i__7281__auto___17701 = (0);
while(true){
if((i__7281__auto___17701 < len__7280__auto___17700)){
args__7287__auto__.push((arguments[i__7281__auto___17701]));

var G__17702 = (i__7281__auto___17701 + (1));
i__7281__auto___17701 = G__17702;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((2) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((2)),(0),null)):null);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7288__auto__);
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (url,stepfn,p__17697){
var map__17698 = p__17697;
var map__17698__$1 = ((((!((map__17698 == null)))?((((map__17698.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17698.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17698):map__17698);
var oboe_headers = cljs.core.get.call(null,map__17698__$1,new cljs.core.Keyword(null,"oboe-headers","oboe-headers",-764778163));
var read_count = cljs.core.atom.call(null,(0));
var agg = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
var channel = cljs.core.async.chan.call(null);
var return_channel = cljs.core.async.chan.call(null);
var oboe_params = cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"headers","headers",-835030129),oboe_headers,new cljs.core.Keyword(null,"withCredentials","withCredentials",1719959454),true], null));
var step = ((function (read_count,agg,channel,return_channel,oboe_params,map__17698,map__17698__$1,oboe_headers){
return (function (line){
return hatti.ona.stream.read_next_chunk_BANG_.call(null,cljs.core.js__GT_clj.call(null,line),read_count,agg,channel);
});})(read_count,agg,channel,return_channel,oboe_params,map__17698,map__17698__$1,oboe_headers))
;
var done = ((function (read_count,agg,channel,return_channel,oboe_params,step,map__17698,map__17698__$1,oboe_headers){
return (function (){
cljs.core.async.put_BANG_.call(null,channel,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.deref.call(null,agg),new cljs.core.Keyword(null,"completed?","completed?",946828354),true], null));

return cljs.core.async.close_BANG_.call(null,return_channel);
});})(read_count,agg,channel,return_channel,oboe_params,step,map__17698,map__17698__$1,oboe_headers))
;
hatti.ona.stream.process_aggregated_data_BANG_.call(null,channel,stepfn);

window.oboe(oboe_params).node("!.*",step).done(done);

return return_channel;
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$applyTo = (function (seq17694){
var G__17695 = cljs.core.first.call(null,seq17694);
var seq17694__$1 = cljs.core.next.call(null,seq17694);
var G__17696 = cljs.core.first.call(null,seq17694__$1);
var seq17694__$2 = cljs.core.next.call(null,seq17694__$1);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17695,G__17696,seq17694__$2);
});
