// Compiled by ClojureScript 1.8.51 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.post_process');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.ona.forms');
goog.require('hatti.ona.urls');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('chimera.urls');
/**
 * Given some data in Ona format, builds a data structure that we will use
 * to link osm data to Ona data.
 */
hatti.ona.post_process.ona_osm_link = (function hatti$ona$post_process$ona_osm_link(data,form){
var osmfields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.flatten((function (){var iter__6990__auto__ = ((function (osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__34363(s__34364){
return (new cljs.core.LazySeq(null,((function (osmfields){
return (function (){
var s__34364__$1 = s__34364;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__34364__$1);
if(temp__4657__auto__){
var s__34364__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34364__$2)){
var c__6988__auto__ = cljs.core.chunk_first(s__34364__$2);
var size__6989__auto__ = cljs.core.count(c__6988__auto__);
var b__34366 = cljs.core.chunk_buffer(size__6989__auto__);
if((function (){var i__34365 = (0);
while(true){
if((i__34365 < size__6989__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6988__auto__,i__34365);
cljs.core.chunk_append(b__34366,(function (){var iter__6990__auto__ = ((function (i__34365,datum,c__6988__auto__,size__6989__auto__,b__34366,s__34364__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__34363_$_iter__34381(s__34382){
return (new cljs.core.LazySeq(null,((function (i__34365,datum,c__6988__auto__,size__6989__auto__,b__34366,s__34364__$2,temp__4657__auto__,osmfields){
return (function (){
var s__34382__$1 = s__34382;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__34382__$1);
if(temp__4657__auto____$1){
var s__34382__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__34382__$2)){
var c__6988__auto____$1 = cljs.core.chunk_first(s__34382__$2);
var size__6989__auto____$1 = cljs.core.count(c__6988__auto____$1);
var b__34384 = cljs.core.chunk_buffer(size__6989__auto____$1);
if((function (){var i__34383 = (0);
while(true){
if((i__34383 < size__6989__auto____$1)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6988__auto____$1,i__34383);
cljs.core.chunk_append(b__34384,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6198__auto__ = osmdatum;
if(cljs.core.truth_(and__6198__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6198__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__34393 = (i__34383 + (1));
i__34383 = G__34393;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34384),hatti$ona$post_process$ona_osm_link_$_iter__34363_$_iter__34381(cljs.core.chunk_rest(s__34382__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34384),null);
}
} else {
var field = cljs.core.first(s__34382__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6198__auto__ = osmdatum;
if(cljs.core.truth_(and__6198__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6198__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__34363_$_iter__34381(cljs.core.rest(s__34382__$2)));
}
} else {
return null;
}
break;
}
});})(i__34365,datum,c__6988__auto__,size__6989__auto__,b__34366,s__34364__$2,temp__4657__auto__,osmfields))
,null,null));
});})(i__34365,datum,c__6988__auto__,size__6989__auto__,b__34366,s__34364__$2,temp__4657__auto__,osmfields))
;
return iter__6990__auto__(osmfields);
})());

var G__34394 = (i__34365 + (1));
i__34365 = G__34394;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34366),hatti$ona$post_process$ona_osm_link_$_iter__34363(cljs.core.chunk_rest(s__34364__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34366),null);
}
} else {
var datum = cljs.core.first(s__34364__$2);
return cljs.core.cons((function (){var iter__6990__auto__ = ((function (datum,s__34364__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__34363_$_iter__34387(s__34388){
return (new cljs.core.LazySeq(null,((function (datum,s__34364__$2,temp__4657__auto__,osmfields){
return (function (){
var s__34388__$1 = s__34388;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__34388__$1);
if(temp__4657__auto____$1){
var s__34388__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__34388__$2)){
var c__6988__auto__ = cljs.core.chunk_first(s__34388__$2);
var size__6989__auto__ = cljs.core.count(c__6988__auto__);
var b__34390 = cljs.core.chunk_buffer(size__6989__auto__);
if((function (){var i__34389 = (0);
while(true){
if((i__34389 < size__6989__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6988__auto__,i__34389);
cljs.core.chunk_append(b__34390,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6198__auto__ = osmdatum;
if(cljs.core.truth_(and__6198__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6198__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__34395 = (i__34389 + (1));
i__34389 = G__34395;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34390),hatti$ona$post_process$ona_osm_link_$_iter__34363_$_iter__34387(cljs.core.chunk_rest(s__34388__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34390),null);
}
} else {
var field = cljs.core.first(s__34388__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6198__auto__ = osmdatum;
if(cljs.core.truth_(and__6198__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6198__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__34363_$_iter__34387(cljs.core.rest(s__34388__$2)));
}
} else {
return null;
}
break;
}
});})(datum,s__34364__$2,temp__4657__auto__,osmfields))
,null,null));
});})(datum,s__34364__$2,temp__4657__auto__,osmfields))
;
return iter__6990__auto__(osmfields);
})(),hatti$ona$post_process$ona_osm_link_$_iter__34363(cljs.core.rest(s__34364__$2)));
}
} else {
return null;
}
break;
}
});})(osmfields))
,null,null));
});})(osmfields))
;
return iter__6990__auto__(data);
})()));
});
/**
 * Takes OSM XML in string form, and returns cljs geojson.
 */
hatti.ona.post_process.osm_xml__GT_geojson = (function hatti$ona$post_process$osm_xml__GT_geojson(osm_xml_string){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic((function (){var G__34397 = jQuery.parseXML(osm_xml_string);
return osmtogeojson(G__34397);
})(),cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Given some data in OSM format, an Ona Form, and osm xml string,
 * return a map from OSM ID to each osm feature. The map contains:
 * :osm-id, :name, :tags from osm xml,
 * :type, :geom from osm feature's geojson equivalent.
 */
hatti.ona.post_process.osm_id__GT_osm_data = (function hatti$ona$post_process$osm_id__GT_osm_data(data,form,osm_xml){
var ona_osm_link = hatti.ona.post_process.ona_osm_link(data,form);
var osmgeo = hatti.ona.post_process.osm_xml__GT_geojson(osm_xml);
var featureset = (osmgeo.cljs$core$IFn$_invoke$arity$1 ? osmgeo.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$features) : osmgeo.call(null,cljs.core.cst$kw$features));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__6990__auto__ = ((function (ona_osm_link,osmgeo,featureset){
return (function hatti$ona$post_process$osm_id__GT_osm_data_$_iter__34420(s__34421){
return (new cljs.core.LazySeq(null,((function (ona_osm_link,osmgeo,featureset){
return (function (){
var s__34421__$1 = s__34421;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__34421__$1);
if(temp__4657__auto__){
var s__34421__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34421__$2)){
var c__6988__auto__ = cljs.core.chunk_first(s__34421__$2);
var size__6989__auto__ = cljs.core.count(c__6988__auto__);
var b__34423 = cljs.core.chunk_buffer(size__6989__auto__);
if((function (){var i__34422 = (0);
while(true){
if((i__34422 < size__6989__auto__)){
var map__34434 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6988__auto__,i__34422);
var map__34434__$1 = ((((!((map__34434 == null)))?((((map__34434.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34434.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34434):map__34434);
var feature = map__34434__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34434__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34434__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34434__$1,cljs.core.cst$kw$geometry);
cljs.core.chunk_append(b__34423,(function (){var map__34436 = properties;
var map__34436__$1 = ((((!((map__34436 == null)))?((((map__34436.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34436.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34436):map__34436);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34436__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34436__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34436__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})());

var G__34442 = (i__34422 + (1));
i__34422 = G__34442;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34423),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__34420(cljs.core.chunk_rest(s__34421__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34423),null);
}
} else {
var map__34438 = cljs.core.first(s__34421__$2);
var map__34438__$1 = ((((!((map__34438 == null)))?((((map__34438.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34438.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34438):map__34438);
var feature = map__34438__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34438__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34438__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34438__$1,cljs.core.cst$kw$geometry);
return cljs.core.cons((function (){var map__34440 = properties;
var map__34440__$1 = ((((!((map__34440 == null)))?((((map__34440.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34440.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34440):map__34440);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34440__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34440__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34440__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})(),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__34420(cljs.core.rest(s__34421__$2)));
}
} else {
return null;
}
break;
}
});})(ona_osm_link,osmgeo,featureset))
,null,null));
});})(ona_osm_link,osmgeo,featureset))
;
return iter__6990__auto__(featureset);
})());
});
/**
 * Given some data post-processed from the ona server
 * (ie, containing _id, _rank), and a string of osm-xml, produce a version with
 * relevant osm data injected in.
 */
hatti.ona.post_process.integrate_osm_data_BANG_ = (function hatti$ona$post_process$integrate_osm_data_BANG_(app_state,form,osm_xml,app_state_keys){
var osm_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
if(cljs.core.seq(osm_fields)){
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(app_state,app_state_keys);
var osm_data = hatti.ona.post_process.osm_id__GT_osm_data(data,form,osm_xml);
var osm_val__GT_osm_id = ((function (data,osm_data,osm_fields){
return (function (p1__34443_SHARP_){
return cljs.core.re_find(/[-]?[0-9]+/,p1__34443_SHARP_);
});})(data,osm_data,osm_fields))
;
var osm_val__GT_osm_data = ((function (data,osm_data,osm_val__GT_osm_id,osm_fields){
return (function (osm_val){
if(typeof osm_val === 'string'){
var temp__4655__auto__ = (function (){var G__34455 = osm_val__GT_osm_id(osm_val);
return (osm_data.cljs$core$IFn$_invoke$arity$1 ? osm_data.cljs$core$IFn$_invoke$arity$1(G__34455) : osm_data.call(null,G__34455));
})();
if(cljs.core.truth_(temp__4655__auto__)){
var osm_submission_data = temp__4655__auto__;
return osm_submission_data;
} else {
return osm_val;
}
} else {
return osm_val;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_fields))
;
var updater = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (osm_key){
return ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (data__$1){
var iter__6990__auto__ = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function hatti$ona$post_process$integrate_osm_data_BANG__$_iter__34456(s__34457){
return (new cljs.core.LazySeq(null,((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (){
var s__34457__$1 = s__34457;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__34457__$1);
if(temp__4657__auto__){
var s__34457__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34457__$2)){
var c__6988__auto__ = cljs.core.chunk_first(s__34457__$2);
var size__6989__auto__ = cljs.core.count(c__6988__auto__);
var b__34459 = cljs.core.chunk_buffer(size__6989__auto__);
if((function (){var i__34458 = (0);
while(true){
if((i__34458 < size__6989__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6988__auto__,i__34458);
cljs.core.chunk_append(b__34459,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data));

var G__34466 = (i__34458 + (1));
i__34458 = G__34466;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34459),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__34456(cljs.core.chunk_rest(s__34457__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34459),null);
}
} else {
var datum = cljs.core.first(s__34457__$2);
return cljs.core.cons(cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__34456(cljs.core.rest(s__34457__$2)));
}
} else {
return null;
}
break;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
,null,null));
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
return iter__6990__auto__(data__$1);
});
;})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
var seq__34462 = cljs.core.seq(osm_fields);
var chunk__34463 = null;
var count__34464 = (0);
var i__34465 = (0);
while(true){
if((i__34465 < count__34464)){
var osm_field = chunk__34463.cljs$core$IIndexed$_nth$arity$2(null,i__34465);
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__34467 = seq__34462;
var G__34468 = chunk__34463;
var G__34469 = count__34464;
var G__34470 = (i__34465 + (1));
seq__34462 = G__34467;
chunk__34463 = G__34468;
count__34464 = G__34469;
i__34465 = G__34470;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__34462);
if(temp__4657__auto__){
var seq__34462__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34462__$1)){
var c__7021__auto__ = cljs.core.chunk_first(seq__34462__$1);
var G__34471 = cljs.core.chunk_rest(seq__34462__$1);
var G__34472 = c__7021__auto__;
var G__34473 = cljs.core.count(c__7021__auto__);
var G__34474 = (0);
seq__34462 = G__34471;
chunk__34463 = G__34472;
count__34464 = G__34473;
i__34465 = G__34474;
continue;
} else {
var osm_field = cljs.core.first(seq__34462__$1);
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__34475 = cljs.core.next(seq__34462__$1);
var G__34476 = null;
var G__34477 = (0);
var G__34478 = (0);
seq__34462 = G__34475;
chunk__34463 = G__34476;
count__34464 = G__34477;
i__34465 = G__34478;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
/**
 * Calculate full image and thumbnail urls given attachment information.
 */
hatti.ona.post_process.url_obj = (function hatti$ona$post_process$url_obj(media_obj){
var media_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"id");
var fname = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"filename");
var file_url = hatti.ona.urls.media_url(media_id,fname);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$filename,fname,cljs.core.cst$kw$download_url,file_url,cljs.core.cst$kw$small_download_url,[cljs.core.str(file_url),cljs.core.str("&suffix=small")].join('')], null);
});
/**
 * Helper function for integrate attachments; returns a function from
 * a filename to a `url-obj` (see specs in `url-obj` function).
 */
hatti.ona.post_process.get_attach_map = (function hatti$ona$post_process$get_attach_map(record,attachments){
var attachments__$1 = (function (){var or__6210__auto__ = attachments;
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,"_attachments");
}
})();
var fnames = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (attachments__$1){
return (function (p1__34479_SHARP_){
return chimera.urls.last_url_param(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__34479_SHARP_,"filename"));
});})(attachments__$1))
,attachments__$1);
var fname__GT_urlobj = cljs.core.zipmap(fnames,cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.ona.post_process.url_obj,attachments__$1));
return ((function (attachments__$1,fnames,fname__GT_urlobj){
return (function (fname){
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(fname__GT_urlobj,fname,fname);
});
;})(attachments__$1,fnames,fname__GT_urlobj))
});
/**
 * Inlines media data from within _attachments into each record.
 */
hatti.ona.post_process.integrate_attachments = (function hatti$ona$post_process$integrate_attachments(var_args){
var args__7287__auto__ = [];
var len__7280__auto___34492 = arguments.length;
var i__7281__auto___34493 = (0);
while(true){
if((i__7281__auto___34493 < len__7280__auto___34492)){
args__7287__auto__.push((arguments[i__7281__auto___34493]));

var G__34494 = (i__7281__auto___34493 + (1));
i__7281__auto___34493 = G__34494;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((2) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((2)),(0),null)):null);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7288__auto__);
});

hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,data,p__34483){
var map__34484 = p__34483;
var map__34484__$1 = ((((!((map__34484 == null)))?((((map__34484.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34484.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34484):map__34484);
var attachments = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34484__$1,cljs.core.cst$kw$attachments);
var image_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.image_QMARK_,flat_form);
var iter__6990__auto__ = ((function (image_fields,map__34484,map__34484__$1,attachments){
return (function hatti$ona$post_process$iter__34486(s__34487){
return (new cljs.core.LazySeq(null,((function (image_fields,map__34484,map__34484__$1,attachments){
return (function (){
var s__34487__$1 = s__34487;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__34487__$1);
if(temp__4657__auto__){
var s__34487__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34487__$2)){
var c__6988__auto__ = cljs.core.chunk_first(s__34487__$2);
var size__6989__auto__ = cljs.core.count(c__6988__auto__);
var b__34489 = cljs.core.chunk_buffer(size__6989__auto__);
if((function (){var i__34488 = (0);
while(true){
if((i__34488 < size__6989__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6988__auto__,i__34488);
cljs.core.chunk_append(b__34489,(function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (i__34488,attach_map,record,c__6988__auto__,size__6989__auto__,b__34489,s__34487__$2,temp__4657__auto__,image_fields,map__34484,map__34484__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(i__34488,attach_map,record,c__6988__auto__,size__6989__auto__,b__34489,s__34487__$2,temp__4657__auto__,image_fields,map__34484,map__34484__$1,attachments))
,record,image_fields);
})());

var G__34495 = (i__34488 + (1));
i__34488 = G__34495;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34489),hatti$ona$post_process$iter__34486(cljs.core.chunk_rest(s__34487__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34489),null);
}
} else {
var record = cljs.core.first(s__34487__$2);
return cljs.core.cons((function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (attach_map,record,s__34487__$2,temp__4657__auto__,image_fields,map__34484,map__34484__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(attach_map,record,s__34487__$2,temp__4657__auto__,image_fields,map__34484,map__34484__$1,attachments))
,record,image_fields);
})(),hatti$ona$post_process$iter__34486(cljs.core.rest(s__34487__$2)));
}
} else {
return null;
}
break;
}
});})(image_fields,map__34484,map__34484__$1,attachments))
,null,null));
});})(image_fields,map__34484,map__34484__$1,attachments))
;
return iter__6990__auto__(data);
});

hatti.ona.post_process.integrate_attachments.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments.cljs$lang$applyTo = (function (seq34480){
var G__34481 = cljs.core.first(seq34480);
var seq34480__$1 = cljs.core.next(seq34480);
var G__34482 = cljs.core.first(seq34480__$1);
var seq34480__$2 = cljs.core.next(seq34480__$1);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(G__34481,G__34482,seq34480__$2);
});
/**
 * Inlines data from within _attachments into each datapoint within repeats.
 */
hatti.ona.post_process.integrate_attachments_in_repeats = (function hatti$ona$post_process$integrate_attachments_in_repeats(flat_form,data){
var repeat_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.repeat_QMARK_,flat_form);
var integrate = ((function (repeat_fields){
return (function (record,rpt_field){
var key = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(rpt_field);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(record,key,hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(rpt_field),cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,key),cljs.core.array_seq([cljs.core.cst$kw$attachments,cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,"_attachments")], 0)));
});})(repeat_fields))
;
var iter__6990__auto__ = ((function (repeat_fields,integrate){
return (function hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__34502(s__34503){
return (new cljs.core.LazySeq(null,((function (repeat_fields,integrate){
return (function (){
var s__34503__$1 = s__34503;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__34503__$1);
if(temp__4657__auto__){
var s__34503__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34503__$2)){
var c__6988__auto__ = cljs.core.chunk_first(s__34503__$2);
var size__6989__auto__ = cljs.core.count(c__6988__auto__);
var b__34505 = cljs.core.chunk_buffer(size__6989__auto__);
if((function (){var i__34504 = (0);
while(true){
if((i__34504 < size__6989__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6988__auto__,i__34504);
cljs.core.chunk_append(b__34505,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields));

var G__34508 = (i__34504 + (1));
i__34504 = G__34508;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34505),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__34502(cljs.core.chunk_rest(s__34503__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34505),null);
}
} else {
var record = cljs.core.first(s__34503__$2);
return cljs.core.cons(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__34502(cljs.core.rest(s__34503__$2)));
}
} else {
return null;
}
break;
}
});})(repeat_fields,integrate))
,null,null));
});})(repeat_fields,integrate))
;
return iter__6990__auto__(data);
});
/**
 * Inlines data from within _atatchments into each record within app-state.
 */
hatti.ona.post_process.integrate_attachments_BANG_ = (function hatti$ona$post_process$integrate_attachments_BANG_(var_args){
var args__7287__auto__ = [];
var len__7280__auto___34516 = arguments.length;
var i__7281__auto___34517 = (0);
while(true){
if((i__7281__auto___34517 < len__7280__auto___34516)){
args__7287__auto__.push((arguments[i__7281__auto___34517]));

var G__34518 = (i__7281__auto___34517 + (1));
i__7281__auto___34517 = G__34518;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((2) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((2)),(0),null)):null);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7288__auto__);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,flat_form,p__34513){
var map__34514 = p__34513;
var map__34514__$1 = ((((!((map__34514 == null)))?((((map__34514.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34514.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34514):map__34514);
var app_data_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34514__$1,cljs.core.cst$kw$app_DASH_data_DASH_keys,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
return chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_data_keys,((function (map__34514,map__34514__$1,app_data_keys){
return (function (p1__34509_SHARP_){
return hatti.ona.post_process.integrate_attachments_in_repeats(flat_form,hatti.ona.post_process.integrate_attachments(flat_form,p1__34509_SHARP_));
});})(map__34514,map__34514__$1,app_data_keys))
);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$applyTo = (function (seq34510){
var G__34511 = cljs.core.first(seq34510);
var seq34510__$1 = cljs.core.next(seq34510);
var G__34512 = cljs.core.first(seq34510__$1);
var seq34510__$2 = cljs.core.next(seq34510__$1);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__34511,G__34512,seq34510__$2);
});
