// Compiled by ClojureScript 1.8.51 {}
goog.provide('chimera.js_interop');
goog.require('cljs.core');
goog.require('cognitect.transit');
goog.require('goog.string');
/**
 * Convert json string to cljs object using transit.
 * Fast, but doesn't preserve keywords.
 */
chimera.js_interop.json__GT_cljs = (function chimera$js_interop$json__GT_cljs(s){
return cognitect.transit.read.call(null,cognitect.transit.reader.call(null,new cljs.core.Keyword(null,"json","json",1279968570)),s);
});
/**
 * Convert json to js using JSON.parse.
 * If error occurs, return the string unmodified.
 */
chimera.js_interop.str__GT_json = (function chimera$js_interop$str__GT_json(string){
try{return JSON.parse(string);
}catch (e10558){if((e10558 instanceof Error)){
var _ = e10558;
return string;
} else {
throw e10558;

}
}});
/**
 * Convert json string to cljs via js.
 * Slow method, but preserves keywords, and appropriate for small json.
 */
chimera.js_interop.json__GT_js__GT_cljs = (function chimera$js_interop$json__GT_js__GT_cljs(s){
return cljs.core.js__GT_clj.call(null,chimera.js_interop.str__GT_json.call(null,s),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});
/**
 * Formats a string using goog.string.format, so we can use format in cljx.
 */
chimera.js_interop.format = (function chimera$js_interop$format(var_args){
var args__7287__auto__ = [];
var len__7280__auto___10561 = arguments.length;
var i__7281__auto___10562 = (0);
while(true){
if((i__7281__auto___10562 < len__7280__auto___10561)){
args__7287__auto__.push((arguments[i__7281__auto___10562]));

var G__10563 = (i__7281__auto___10562 + (1));
i__7281__auto___10562 = G__10563;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return cljs.core.apply.call(null,goog.string.format,fmt,args);
});

chimera.js_interop.format.cljs$lang$maxFixedArity = (1);

chimera.js_interop.format.cljs$lang$applyTo = (function (seq10559){
var G__10560 = cljs.core.first.call(null,seq10559);
var seq10559__$1 = cljs.core.next.call(null,seq10559);
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic(G__10560,seq10559__$1);
});
/**
 * Create a safe (escaped) js regex out of a string.
 * By default, creates regex with ignore case option.
 */
chimera.js_interop.safe_regex = (function chimera$js_interop$safe_regex(var_args){
var args__7287__auto__ = [];
var len__7280__auto___10569 = arguments.length;
var i__7281__auto___10570 = (0);
while(true){
if((i__7281__auto___10570 < len__7280__auto___10569)){
args__7287__auto__.push((arguments[i__7281__auto___10570]));

var G__10571 = (i__7281__auto___10570 + (1));
i__7281__auto___10570 = G__10571;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic = (function (query_string,p__10566){
var map__10567 = p__10566;
var map__10567__$1 = ((((!((map__10567 == null)))?((((map__10567.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10567.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10567):map__10567);
var ignore_case_QMARK_ = cljs.core.get.call(null,map__10567__$1,new cljs.core.Keyword(null,"ignore-case?","ignore-case?",-956106212),true);
return cljs.core.re_pattern.call(null,[cljs.core.str((cljs.core.truth_(ignore_case_QMARK_)?"(?i)":null)),cljs.core.str(goog.string.regExpEscape(query_string))].join(''));
});

chimera.js_interop.safe_regex.cljs$lang$maxFixedArity = (1);

chimera.js_interop.safe_regex.cljs$lang$applyTo = (function (seq10564){
var G__10565 = cljs.core.first.call(null,seq10564);
var seq10564__$1 = cljs.core.next.call(null,seq10564);
return chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic(G__10565,seq10564__$1);
});
