// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.ona.stream');
goog.require('cljs.core');
goog.require('cljs.core.async');
hatti.ona.stream.small_delay = (10);
/**
 * Calls callback on aggregated data that come via messages in channel.
 * Callback accepts two arguments: data (cljs list), and completed? (bool)
 *   If there is a parser in message, resume it after a timeout.
 */
hatti.ona.stream.process_aggregated_data_BANG_ = (function hatti$ona$stream$process_aggregated_data_BANG_(agg_data_channel,callback){
var c__7694__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto__){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto__){
return (function (state_8259){
var state_val_8260 = (state_8259[(1)]);
if((state_val_8260 === (7))){
var inst_8216 = (state_8259[(7)]);
var inst_8216__$1 = (state_8259[(2)]);
var inst_8218 = (inst_8216__$1 == null);
var inst_8219 = cljs.core.not.call(null,inst_8218);
var state_8259__$1 = (function (){var statearr_8261 = state_8259;
(statearr_8261[(7)] = inst_8216__$1);

return statearr_8261;
})();
if(inst_8219){
var statearr_8262_8299 = state_8259__$1;
(statearr_8262_8299[(1)] = (8));

} else {
var statearr_8263_8300 = state_8259__$1;
(statearr_8263_8300[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8260 === (20))){
var inst_8238 = (state_8259[(8)]);
var inst_8246 = (state_8259[(2)]);
var state_8259__$1 = (function (){var statearr_8264 = state_8259;
(statearr_8264[(9)] = inst_8246);

return statearr_8264;
})();
if(cljs.core.truth_(inst_8238)){
var statearr_8265_8301 = state_8259__$1;
(statearr_8265_8301[(1)] = (21));

} else {
var statearr_8266_8302 = state_8259__$1;
(statearr_8266_8302[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8260 === (1))){
var state_8259__$1 = state_8259;
var statearr_8267_8303 = state_8259__$1;
(statearr_8267_8303[(2)] = null);

(statearr_8267_8303[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8260 === (4))){
var state_8259__$1 = state_8259;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8259__$1,(7),agg_data_channel);
} else {
if((state_val_8260 === (15))){
var inst_8216 = (state_8259[(7)]);
var state_8259__$1 = state_8259;
var statearr_8268_8304 = state_8259__$1;
(statearr_8268_8304[(2)] = inst_8216);

(statearr_8268_8304[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8260 === (21))){
var inst_8248 = cljs.core.async.close_BANG_.call(null,agg_data_channel);
var state_8259__$1 = state_8259;
var statearr_8269_8305 = state_8259__$1;
(statearr_8269_8305[(2)] = inst_8248);

(statearr_8269_8305[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8260 === (13))){
var inst_8228 = (state_8259[(2)]);
var state_8259__$1 = state_8259;
var statearr_8270_8306 = state_8259__$1;
(statearr_8270_8306[(2)] = inst_8228);

(statearr_8270_8306[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8260 === (22))){
var state_8259__$1 = state_8259;
var statearr_8271_8307 = state_8259__$1;
(statearr_8271_8307[(2)] = null);

(statearr_8271_8307[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8260 === (6))){
var inst_8255 = (state_8259[(2)]);
var state_8259__$1 = state_8259;
var statearr_8272_8308 = state_8259__$1;
(statearr_8272_8308[(2)] = inst_8255);

(statearr_8272_8308[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8260 === (17))){
var inst_8237 = (state_8259[(10)]);
var inst_8238 = (state_8259[(8)]);
var inst_8240 = callback.call(null,inst_8237,inst_8238);
var state_8259__$1 = state_8259;
var statearr_8273_8309 = state_8259__$1;
(statearr_8273_8309[(2)] = inst_8240);

(statearr_8273_8309[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8260 === (3))){
var inst_8257 = (state_8259[(2)]);
var state_8259__$1 = state_8259;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8259__$1,inst_8257);
} else {
if((state_val_8260 === (12))){
var state_8259__$1 = state_8259;
var statearr_8274_8310 = state_8259__$1;
(statearr_8274_8310[(2)] = false);

(statearr_8274_8310[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8260 === (2))){
var state_8259__$1 = state_8259;
var statearr_8275_8311 = state_8259__$1;
(statearr_8275_8311[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8260 === (23))){
var inst_8251 = (state_8259[(2)]);
var state_8259__$1 = (function (){var statearr_8277 = state_8259;
(statearr_8277[(11)] = inst_8251);

return statearr_8277;
})();
var statearr_8278_8312 = state_8259__$1;
(statearr_8278_8312[(2)] = null);

(statearr_8278_8312[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8260 === (19))){
var inst_8243 = (state_8259[(2)]);
var inst_8244 = cljs.core.async.timeout.call(null,hatti.ona.stream.small_delay);
var state_8259__$1 = (function (){var statearr_8279 = state_8259;
(statearr_8279[(12)] = inst_8243);

return statearr_8279;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8259__$1,(20),inst_8244);
} else {
if((state_val_8260 === (11))){
var state_8259__$1 = state_8259;
var statearr_8280_8313 = state_8259__$1;
(statearr_8280_8313[(2)] = true);

(statearr_8280_8313[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8260 === (9))){
var state_8259__$1 = state_8259;
var statearr_8281_8314 = state_8259__$1;
(statearr_8281_8314[(2)] = false);

(statearr_8281_8314[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8260 === (5))){
var state_8259__$1 = state_8259;
var statearr_8282_8315 = state_8259__$1;
(statearr_8282_8315[(2)] = null);

(statearr_8282_8315[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8260 === (14))){
var inst_8216 = (state_8259[(7)]);
var inst_8233 = cljs.core.apply.call(null,cljs.core.hash_map,inst_8216);
var state_8259__$1 = state_8259;
var statearr_8283_8316 = state_8259__$1;
(statearr_8283_8316[(2)] = inst_8233);

(statearr_8283_8316[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8260 === (16))){
var inst_8237 = (state_8259[(10)]);
var inst_8236 = (state_8259[(2)]);
var inst_8237__$1 = cljs.core.get.call(null,inst_8236,new cljs.core.Keyword(null,"data","data",-232669377));
var inst_8238 = cljs.core.get.call(null,inst_8236,new cljs.core.Keyword(null,"completed?","completed?",946828354));
var state_8259__$1 = (function (){var statearr_8284 = state_8259;
(statearr_8284[(10)] = inst_8237__$1);

(statearr_8284[(8)] = inst_8238);

return statearr_8284;
})();
if(cljs.core.truth_(inst_8237__$1)){
var statearr_8285_8317 = state_8259__$1;
(statearr_8285_8317[(1)] = (17));

} else {
var statearr_8286_8318 = state_8259__$1;
(statearr_8286_8318[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8260 === (10))){
var inst_8231 = (state_8259[(2)]);
var state_8259__$1 = state_8259;
if(cljs.core.truth_(inst_8231)){
var statearr_8287_8319 = state_8259__$1;
(statearr_8287_8319[(1)] = (14));

} else {
var statearr_8288_8320 = state_8259__$1;
(statearr_8288_8320[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8260 === (18))){
var state_8259__$1 = state_8259;
var statearr_8289_8321 = state_8259__$1;
(statearr_8289_8321[(2)] = null);

(statearr_8289_8321[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8260 === (8))){
var inst_8216 = (state_8259[(7)]);
var inst_8221 = inst_8216.cljs$lang$protocol_mask$partition0$;
var inst_8222 = (inst_8221 & (64));
var inst_8223 = inst_8216.cljs$core$ISeq$;
var inst_8224 = (inst_8222) || (inst_8223);
var state_8259__$1 = state_8259;
if(cljs.core.truth_(inst_8224)){
var statearr_8290_8322 = state_8259__$1;
(statearr_8290_8322[(1)] = (11));

} else {
var statearr_8291_8323 = state_8259__$1;
(statearr_8291_8323[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto__))
;
return ((function (switch__7673__auto__,c__7694__auto__){
return (function() {
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__7674__auto__ = null;
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__7674__auto____0 = (function (){
var statearr_8295 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_8295[(0)] = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__7674__auto__);

(statearr_8295[(1)] = (1));

return statearr_8295;
});
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__7674__auto____1 = (function (state_8259){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_8259);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e8296){if((e8296 instanceof Object)){
var ex__7677__auto__ = e8296;
var statearr_8297_8324 = state_8259;
(statearr_8297_8324[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8259);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8296;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8325 = state_8259;
state_8259 = G__8325;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__7674__auto__ = function(state_8259){
switch(arguments.length){
case 0:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__7674__auto____0.call(this);
case 1:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__7674__auto____1.call(this,state_8259);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__7674__auto____0;
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__7674__auto____1;
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto__))
})();
var state__7696__auto__ = (function (){var statearr_8298 = f__7695__auto__.call(null);
(statearr_8298[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto__);

return statearr_8298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto__))
);

return c__7694__auto__;
});
/**
 * On each step of data, increment read-count atom, and put data in a list agg.
 * After a exponentially increasing # of steps have been processed,
 * the aggregated data gets flushed into a channel, and parser is paused.
 * The channel reader should resume the parser after processing the data.
 */
hatti.ona.stream.read_next_chunk_BANG_ = (function hatti$ona$stream$read_next_chunk_BANG_(data_chunk,read_count,agg,channel){
cljs.core.swap_BANG_.call(null,read_count,cljs.core.inc);

cljs.core.swap_BANG_.call(null,agg,cljs.core.conj,data_chunk);

if(((cljs.core.deref.call(null,read_count) >= (100))) && (cljs.core.integer_QMARK_.call(null,Math.log10(cljs.core.deref.call(null,read_count))))){
cljs.core.async.put_BANG_.call(null,channel,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.deref.call(null,agg)], null));

cljs.core.reset_BANG_.call(null,agg,cljs.core.PersistentVector.EMPTY);

return oboe.drop();
} else {
return null;
}
});
/**
 * Given url, a node pattern matcher, and a callback, streaming-read json.
 */
hatti.ona.stream.streamingly_read_json_BANG_ = (function hatti$ona$stream$streamingly_read_json_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___8332 = arguments.length;
var i__5628__auto___8333 = (0);
while(true){
if((i__5628__auto___8333 < len__5627__auto___8332)){
args__5634__auto__.push((arguments[i__5628__auto___8333]));

var G__8334 = (i__5628__auto___8333 + (1));
i__5628__auto___8333 = G__8334;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (url,stepfn,p__8329){
var map__8330 = p__8329;
var map__8330__$1 = ((((!((map__8330 == null)))?((((map__8330.cljs$lang$protocol_mask$partition0$ & (64))) || (map__8330.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8330):map__8330);
var oboe_headers = cljs.core.get.call(null,map__8330__$1,new cljs.core.Keyword(null,"oboe-headers","oboe-headers",-764778163));
var read_count = cljs.core.atom.call(null,(0));
var agg = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
var channel = cljs.core.async.chan.call(null);
var return_channel = cljs.core.async.chan.call(null);
var oboe_params = cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"headers","headers",-835030129),oboe_headers,new cljs.core.Keyword(null,"withCredentials","withCredentials",1719959454),true], null));
var step = ((function (read_count,agg,channel,return_channel,oboe_params,map__8330,map__8330__$1,oboe_headers){
return (function (line){
return hatti.ona.stream.read_next_chunk_BANG_.call(null,cljs.core.js__GT_clj.call(null,line),read_count,agg,channel);
});})(read_count,agg,channel,return_channel,oboe_params,map__8330,map__8330__$1,oboe_headers))
;
var done = ((function (read_count,agg,channel,return_channel,oboe_params,step,map__8330,map__8330__$1,oboe_headers){
return (function (){
cljs.core.async.put_BANG_.call(null,channel,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.deref.call(null,agg),new cljs.core.Keyword(null,"completed?","completed?",946828354),true], null));

return cljs.core.async.close_BANG_.call(null,return_channel);
});})(read_count,agg,channel,return_channel,oboe_params,step,map__8330,map__8330__$1,oboe_headers))
;
hatti.ona.stream.process_aggregated_data_BANG_.call(null,channel,stepfn);

window.oboe(oboe_params).node("!.*",step).done(done);

return return_channel;
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$applyTo = (function (seq8326){
var G__8327 = cljs.core.first.call(null,seq8326);
var seq8326__$1 = cljs.core.next.call(null,seq8326);
var G__8328 = cljs.core.first.call(null,seq8326__$1);
var seq8326__$2 = cljs.core.next.call(null,seq8326__$1);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__8327,G__8328,seq8326__$2);
});
