// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.ona.stream');
goog.require('cljs.core');
goog.require('cljs.core.async');
hatti.ona.stream.small_delay = (10);
/**
 * Calls callback on aggregated data that come via messages in channel.
 * Callback accepts two arguments: data (cljs list), and completed? (bool)
 *   If there is a parser in message, resume it after a timeout.
 */
hatti.ona.stream.process_aggregated_data_BANG_ = (function hatti$ona$stream$process_aggregated_data_BANG_(agg_data_channel,callback){
var c__9230__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto__){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto__){
return (function (state_12593){
var state_val_12594 = (state_12593[(1)]);
if((state_val_12594 === (7))){
var inst_12550 = (state_12593[(7)]);
var inst_12550__$1 = (state_12593[(2)]);
var inst_12552 = (inst_12550__$1 == null);
var inst_12553 = cljs.core.not.call(null,inst_12552);
var state_12593__$1 = (function (){var statearr_12595 = state_12593;
(statearr_12595[(7)] = inst_12550__$1);

return statearr_12595;
})();
if(inst_12553){
var statearr_12596_12633 = state_12593__$1;
(statearr_12596_12633[(1)] = (8));

} else {
var statearr_12597_12634 = state_12593__$1;
(statearr_12597_12634[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12594 === (20))){
var inst_12572 = (state_12593[(8)]);
var inst_12580 = (state_12593[(2)]);
var state_12593__$1 = (function (){var statearr_12598 = state_12593;
(statearr_12598[(9)] = inst_12580);

return statearr_12598;
})();
if(cljs.core.truth_(inst_12572)){
var statearr_12599_12635 = state_12593__$1;
(statearr_12599_12635[(1)] = (21));

} else {
var statearr_12600_12636 = state_12593__$1;
(statearr_12600_12636[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12594 === (1))){
var state_12593__$1 = state_12593;
var statearr_12601_12637 = state_12593__$1;
(statearr_12601_12637[(2)] = null);

(statearr_12601_12637[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12594 === (4))){
var state_12593__$1 = state_12593;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12593__$1,(7),agg_data_channel);
} else {
if((state_val_12594 === (15))){
var inst_12550 = (state_12593[(7)]);
var state_12593__$1 = state_12593;
var statearr_12602_12638 = state_12593__$1;
(statearr_12602_12638[(2)] = inst_12550);

(statearr_12602_12638[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12594 === (21))){
var inst_12582 = cljs.core.async.close_BANG_.call(null,agg_data_channel);
var state_12593__$1 = state_12593;
var statearr_12603_12639 = state_12593__$1;
(statearr_12603_12639[(2)] = inst_12582);

(statearr_12603_12639[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12594 === (13))){
var inst_12562 = (state_12593[(2)]);
var state_12593__$1 = state_12593;
var statearr_12604_12640 = state_12593__$1;
(statearr_12604_12640[(2)] = inst_12562);

(statearr_12604_12640[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12594 === (22))){
var state_12593__$1 = state_12593;
var statearr_12605_12641 = state_12593__$1;
(statearr_12605_12641[(2)] = null);

(statearr_12605_12641[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12594 === (6))){
var inst_12589 = (state_12593[(2)]);
var state_12593__$1 = state_12593;
var statearr_12606_12642 = state_12593__$1;
(statearr_12606_12642[(2)] = inst_12589);

(statearr_12606_12642[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12594 === (17))){
var inst_12572 = (state_12593[(8)]);
var inst_12571 = (state_12593[(10)]);
var inst_12574 = callback.call(null,inst_12571,inst_12572);
var state_12593__$1 = state_12593;
var statearr_12607_12643 = state_12593__$1;
(statearr_12607_12643[(2)] = inst_12574);

(statearr_12607_12643[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12594 === (3))){
var inst_12591 = (state_12593[(2)]);
var state_12593__$1 = state_12593;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12593__$1,inst_12591);
} else {
if((state_val_12594 === (12))){
var state_12593__$1 = state_12593;
var statearr_12608_12644 = state_12593__$1;
(statearr_12608_12644[(2)] = false);

(statearr_12608_12644[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12594 === (2))){
var state_12593__$1 = state_12593;
var statearr_12609_12645 = state_12593__$1;
(statearr_12609_12645[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12594 === (23))){
var inst_12585 = (state_12593[(2)]);
var state_12593__$1 = (function (){var statearr_12611 = state_12593;
(statearr_12611[(11)] = inst_12585);

return statearr_12611;
})();
var statearr_12612_12646 = state_12593__$1;
(statearr_12612_12646[(2)] = null);

(statearr_12612_12646[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12594 === (19))){
var inst_12577 = (state_12593[(2)]);
var inst_12578 = cljs.core.async.timeout.call(null,hatti.ona.stream.small_delay);
var state_12593__$1 = (function (){var statearr_12613 = state_12593;
(statearr_12613[(12)] = inst_12577);

return statearr_12613;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12593__$1,(20),inst_12578);
} else {
if((state_val_12594 === (11))){
var state_12593__$1 = state_12593;
var statearr_12614_12647 = state_12593__$1;
(statearr_12614_12647[(2)] = true);

(statearr_12614_12647[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12594 === (9))){
var state_12593__$1 = state_12593;
var statearr_12615_12648 = state_12593__$1;
(statearr_12615_12648[(2)] = false);

(statearr_12615_12648[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12594 === (5))){
var state_12593__$1 = state_12593;
var statearr_12616_12649 = state_12593__$1;
(statearr_12616_12649[(2)] = null);

(statearr_12616_12649[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12594 === (14))){
var inst_12550 = (state_12593[(7)]);
var inst_12567 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12550);
var state_12593__$1 = state_12593;
var statearr_12617_12650 = state_12593__$1;
(statearr_12617_12650[(2)] = inst_12567);

(statearr_12617_12650[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12594 === (16))){
var inst_12571 = (state_12593[(10)]);
var inst_12570 = (state_12593[(2)]);
var inst_12571__$1 = cljs.core.get.call(null,inst_12570,new cljs.core.Keyword(null,"data","data",-232669377));
var inst_12572 = cljs.core.get.call(null,inst_12570,new cljs.core.Keyword(null,"completed?","completed?",946828354));
var state_12593__$1 = (function (){var statearr_12618 = state_12593;
(statearr_12618[(8)] = inst_12572);

(statearr_12618[(10)] = inst_12571__$1);

return statearr_12618;
})();
if(cljs.core.truth_(inst_12571__$1)){
var statearr_12619_12651 = state_12593__$1;
(statearr_12619_12651[(1)] = (17));

} else {
var statearr_12620_12652 = state_12593__$1;
(statearr_12620_12652[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12594 === (10))){
var inst_12565 = (state_12593[(2)]);
var state_12593__$1 = state_12593;
if(cljs.core.truth_(inst_12565)){
var statearr_12621_12653 = state_12593__$1;
(statearr_12621_12653[(1)] = (14));

} else {
var statearr_12622_12654 = state_12593__$1;
(statearr_12622_12654[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12594 === (18))){
var state_12593__$1 = state_12593;
var statearr_12623_12655 = state_12593__$1;
(statearr_12623_12655[(2)] = null);

(statearr_12623_12655[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12594 === (8))){
var inst_12550 = (state_12593[(7)]);
var inst_12555 = inst_12550.cljs$lang$protocol_mask$partition0$;
var inst_12556 = (inst_12555 & (64));
var inst_12557 = inst_12550.cljs$core$ISeq$;
var inst_12558 = (inst_12556) || (inst_12557);
var state_12593__$1 = state_12593;
if(cljs.core.truth_(inst_12558)){
var statearr_12624_12656 = state_12593__$1;
(statearr_12624_12656[(1)] = (11));

} else {
var statearr_12625_12657 = state_12593__$1;
(statearr_12625_12657[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto__))
;
return ((function (switch__9165__auto__,c__9230__auto__){
return (function() {
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__9166__auto__ = null;
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__9166__auto____0 = (function (){
var statearr_12629 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12629[(0)] = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__9166__auto__);

(statearr_12629[(1)] = (1));

return statearr_12629;
});
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__9166__auto____1 = (function (state_12593){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_12593);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e12630){if((e12630 instanceof Object)){
var ex__9169__auto__ = e12630;
var statearr_12631_12658 = state_12593;
(statearr_12631_12658[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12593);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12630;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12659 = state_12593;
state_12593 = G__12659;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__9166__auto__ = function(state_12593){
switch(arguments.length){
case 0:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__9166__auto____0.call(this);
case 1:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__9166__auto____1.call(this,state_12593);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__9166__auto____0;
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__9166__auto____1;
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto__))
})();
var state__9232__auto__ = (function (){var statearr_12632 = f__9231__auto__.call(null);
(statearr_12632[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto__);

return statearr_12632;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto__))
);

return c__9230__auto__;
});
/**
 * On each step of data, increment read-count atom, and put data in a list agg.
 * After a exponentially increasing # of steps have been processed,
 * the aggregated data gets flushed into a channel, and parser is paused.
 * The channel reader should resume the parser after processing the data.
 */
hatti.ona.stream.read_next_chunk_BANG_ = (function hatti$ona$stream$read_next_chunk_BANG_(data_chunk,read_count,agg,channel){
cljs.core.swap_BANG_.call(null,read_count,cljs.core.inc);

cljs.core.swap_BANG_.call(null,agg,cljs.core.conj,data_chunk);

if(((cljs.core.deref.call(null,read_count) >= (100))) && (cljs.core.integer_QMARK_.call(null,Math.log10(cljs.core.deref.call(null,read_count))))){
cljs.core.async.put_BANG_.call(null,channel,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.deref.call(null,agg)], null));

cljs.core.reset_BANG_.call(null,agg,cljs.core.PersistentVector.EMPTY);

return oboe.drop();
} else {
return null;
}
});
/**
 * Given url, a node pattern matcher, and a callback, streaming-read json.
 */
hatti.ona.stream.streamingly_read_json_BANG_ = (function hatti$ona$stream$streamingly_read_json_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___12666 = arguments.length;
var i__5628__auto___12667 = (0);
while(true){
if((i__5628__auto___12667 < len__5627__auto___12666)){
args__5634__auto__.push((arguments[i__5628__auto___12667]));

var G__12668 = (i__5628__auto___12667 + (1));
i__5628__auto___12667 = G__12668;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (url,stepfn,p__12663){
var map__12664 = p__12663;
var map__12664__$1 = ((((!((map__12664 == null)))?((((map__12664.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12664.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12664):map__12664);
var oboe_headers = cljs.core.get.call(null,map__12664__$1,new cljs.core.Keyword(null,"oboe-headers","oboe-headers",-764778163));
var read_count = cljs.core.atom.call(null,(0));
var agg = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
var channel = cljs.core.async.chan.call(null);
var return_channel = cljs.core.async.chan.call(null);
var oboe_params = cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"headers","headers",-835030129),oboe_headers,new cljs.core.Keyword(null,"withCredentials","withCredentials",1719959454),true], null));
var step = ((function (read_count,agg,channel,return_channel,oboe_params,map__12664,map__12664__$1,oboe_headers){
return (function (line){
return hatti.ona.stream.read_next_chunk_BANG_.call(null,cljs.core.js__GT_clj.call(null,line),read_count,agg,channel);
});})(read_count,agg,channel,return_channel,oboe_params,map__12664,map__12664__$1,oboe_headers))
;
var done = ((function (read_count,agg,channel,return_channel,oboe_params,step,map__12664,map__12664__$1,oboe_headers){
return (function (){
cljs.core.async.put_BANG_.call(null,channel,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.deref.call(null,agg),new cljs.core.Keyword(null,"completed?","completed?",946828354),true], null));

return cljs.core.async.close_BANG_.call(null,return_channel);
});})(read_count,agg,channel,return_channel,oboe_params,step,map__12664,map__12664__$1,oboe_headers))
;
hatti.ona.stream.process_aggregated_data_BANG_.call(null,channel,stepfn);

window.oboe(oboe_params).node("!.*",step).done(done);

return return_channel;
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$applyTo = (function (seq12660){
var G__12661 = cljs.core.first.call(null,seq12660);
var seq12660__$1 = cljs.core.next.call(null,seq12660);
var G__12662 = cljs.core.first.call(null,seq12660__$1);
var seq12660__$2 = cljs.core.next.call(null,seq12660__$1);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12661,G__12662,seq12660__$2);
});
