// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.post_process');
goog.require('cljs.core');
goog.require('hatti.ona.forms');
goog.require('hatti.ona.urls');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.utils');
goog.require('hatti.utils.om.state');
/**
 * Given some data in Ona format, builds a data structure that we will use
 * to link osm data to Ona data.
 */
hatti.ona.post_process.ona_osm_link = (function hatti$ona$post_process$ona_osm_link(data,form){
var osmfields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.flatten((function (){var iter__5341__auto__ = ((function (osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__30751(s__30752){
return (new cljs.core.LazySeq(null,((function (osmfields){
return (function (){
var s__30752__$1 = s__30752;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__30752__$1);
if(temp__4425__auto__){
var s__30752__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__30752__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__30752__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__30754 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__30753 = (0);
while(true){
if((i__30753 < size__5340__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__30753);
cljs.core.chunk_append(b__30754,(function (){var iter__5341__auto__ = ((function (i__30753,datum,c__5339__auto__,size__5340__auto__,b__30754,s__30752__$2,temp__4425__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__30751_$_iter__30769(s__30770){
return (new cljs.core.LazySeq(null,((function (i__30753,datum,c__5339__auto__,size__5340__auto__,b__30754,s__30752__$2,temp__4425__auto__,osmfields){
return (function (){
var s__30770__$1 = s__30770;
while(true){
var temp__4425__auto____$1 = cljs.core.seq(s__30770__$1);
if(temp__4425__auto____$1){
var s__30770__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__30770__$2)){
var c__5339__auto____$1 = cljs.core.chunk_first(s__30770__$2);
var size__5340__auto____$1 = cljs.core.count(c__5339__auto____$1);
var b__30772 = cljs.core.chunk_buffer(size__5340__auto____$1);
if((function (){var i__30771 = (0);
while(true){
if((i__30771 < size__5340__auto____$1)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto____$1,i__30771);
cljs.core.chunk_append(b__30772,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__30781 = (i__30771 + (1));
i__30771 = G__30781;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30772),hatti$ona$post_process$ona_osm_link_$_iter__30751_$_iter__30769(cljs.core.chunk_rest(s__30770__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30772),null);
}
} else {
var field = cljs.core.first(s__30770__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__30751_$_iter__30769(cljs.core.rest(s__30770__$2)));
}
} else {
return null;
}
break;
}
});})(i__30753,datum,c__5339__auto__,size__5340__auto__,b__30754,s__30752__$2,temp__4425__auto__,osmfields))
,null,null));
});})(i__30753,datum,c__5339__auto__,size__5340__auto__,b__30754,s__30752__$2,temp__4425__auto__,osmfields))
;
return iter__5341__auto__(osmfields);
})());

var G__30782 = (i__30753 + (1));
i__30753 = G__30782;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30754),hatti$ona$post_process$ona_osm_link_$_iter__30751(cljs.core.chunk_rest(s__30752__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30754),null);
}
} else {
var datum = cljs.core.first(s__30752__$2);
return cljs.core.cons((function (){var iter__5341__auto__ = ((function (datum,s__30752__$2,temp__4425__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__30751_$_iter__30775(s__30776){
return (new cljs.core.LazySeq(null,((function (datum,s__30752__$2,temp__4425__auto__,osmfields){
return (function (){
var s__30776__$1 = s__30776;
while(true){
var temp__4425__auto____$1 = cljs.core.seq(s__30776__$1);
if(temp__4425__auto____$1){
var s__30776__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__30776__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__30776__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__30778 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__30777 = (0);
while(true){
if((i__30777 < size__5340__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__30777);
cljs.core.chunk_append(b__30778,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__30783 = (i__30777 + (1));
i__30777 = G__30783;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30778),hatti$ona$post_process$ona_osm_link_$_iter__30751_$_iter__30775(cljs.core.chunk_rest(s__30776__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30778),null);
}
} else {
var field = cljs.core.first(s__30776__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__30751_$_iter__30775(cljs.core.rest(s__30776__$2)));
}
} else {
return null;
}
break;
}
});})(datum,s__30752__$2,temp__4425__auto__,osmfields))
,null,null));
});})(datum,s__30752__$2,temp__4425__auto__,osmfields))
;
return iter__5341__auto__(osmfields);
})(),hatti$ona$post_process$ona_osm_link_$_iter__30751(cljs.core.rest(s__30752__$2)));
}
} else {
return null;
}
break;
}
});})(osmfields))
,null,null));
});})(osmfields))
;
return iter__5341__auto__(data);
})()));
});
/**
 * Takes OSM XML in string form, and returns cljs geojson.
 */
hatti.ona.post_process.osm_xml__GT_geojson = (function hatti$ona$post_process$osm_xml__GT_geojson(osm_xml_string){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic((function (){var G__30785 = jQuery.parseXML(osm_xml_string);
return osmtogeojson(G__30785);
})(),cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Given some data in OSM format, an Ona Form, and osm xml string,
 * return a map from OSM ID to each osm feature. The map contains:
 * :osm-id, :name, :tags from osm xml,
 * :type, :geom from osm feature's geojson equivalent.
 */
hatti.ona.post_process.osm_id__GT_osm_data = (function hatti$ona$post_process$osm_id__GT_osm_data(data,form,osm_xml){
var ona_osm_link = hatti.ona.post_process.ona_osm_link(data,form);
var osmgeo = hatti.ona.post_process.osm_xml__GT_geojson(osm_xml);
var featureset = (osmgeo.cljs$core$IFn$_invoke$arity$1 ? osmgeo.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$features) : osmgeo.call(null,cljs.core.cst$kw$features));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5341__auto__ = ((function (ona_osm_link,osmgeo,featureset){
return (function hatti$ona$post_process$osm_id__GT_osm_data_$_iter__30808(s__30809){
return (new cljs.core.LazySeq(null,((function (ona_osm_link,osmgeo,featureset){
return (function (){
var s__30809__$1 = s__30809;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__30809__$1);
if(temp__4425__auto__){
var s__30809__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__30809__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__30809__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__30811 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__30810 = (0);
while(true){
if((i__30810 < size__5340__auto__)){
var map__30822 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__30810);
var map__30822__$1 = ((((!((map__30822 == null)))?((((map__30822.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30822.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30822):map__30822);
var feature = map__30822__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30822__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30822__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30822__$1,cljs.core.cst$kw$geometry);
cljs.core.chunk_append(b__30811,(function (){var map__30824 = properties;
var map__30824__$1 = ((((!((map__30824 == null)))?((((map__30824.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30824.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30824):map__30824);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30824__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30824__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30824__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})());

var G__30830 = (i__30810 + (1));
i__30810 = G__30830;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30811),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__30808(cljs.core.chunk_rest(s__30809__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30811),null);
}
} else {
var map__30826 = cljs.core.first(s__30809__$2);
var map__30826__$1 = ((((!((map__30826 == null)))?((((map__30826.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30826.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30826):map__30826);
var feature = map__30826__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30826__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30826__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30826__$1,cljs.core.cst$kw$geometry);
return cljs.core.cons((function (){var map__30828 = properties;
var map__30828__$1 = ((((!((map__30828 == null)))?((((map__30828.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30828.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30828):map__30828);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30828__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30828__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30828__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})(),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__30808(cljs.core.rest(s__30809__$2)));
}
} else {
return null;
}
break;
}
});})(ona_osm_link,osmgeo,featureset))
,null,null));
});})(ona_osm_link,osmgeo,featureset))
;
return iter__5341__auto__(featureset);
})());
});
/**
 * Given some data post-processed from the ona server
 * (ie, containing _id, _rank), and a string of osm-xml, produce a version with
 * relevant osm data injected in.
 */
hatti.ona.post_process.integrate_osm_data_BANG_ = (function hatti$ona$post_process$integrate_osm_data_BANG_(app_state,form,osm_xml,app_state_keys){
var osm_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
if(cljs.core.seq(osm_fields)){
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(app_state,app_state_keys);
var osm_data = hatti.ona.post_process.osm_id__GT_osm_data(data,form,osm_xml);
var osm_val__GT_osm_id = ((function (data,osm_data,osm_fields){
return (function (p1__30831_SHARP_){
return cljs.core.re_find(/[-]?[0-9]+/,p1__30831_SHARP_);
});})(data,osm_data,osm_fields))
;
var osm_val__GT_osm_data = ((function (data,osm_data,osm_val__GT_osm_id,osm_fields){
return (function (osm_val){
if(typeof osm_val === 'string'){
var temp__4423__auto__ = (function (){var G__30843 = osm_val__GT_osm_id(osm_val);
return (osm_data.cljs$core$IFn$_invoke$arity$1 ? osm_data.cljs$core$IFn$_invoke$arity$1(G__30843) : osm_data.call(null,G__30843));
})();
if(cljs.core.truth_(temp__4423__auto__)){
var osm_submission_data = temp__4423__auto__;
return osm_submission_data;
} else {
return osm_val;
}
} else {
return osm_val;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_fields))
;
var updater = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (osm_key){
return ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (data__$1){
var iter__5341__auto__ = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function hatti$ona$post_process$integrate_osm_data_BANG__$_iter__30844(s__30845){
return (new cljs.core.LazySeq(null,((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (){
var s__30845__$1 = s__30845;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__30845__$1);
if(temp__4425__auto__){
var s__30845__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__30845__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__30845__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__30847 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__30846 = (0);
while(true){
if((i__30846 < size__5340__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__30846);
cljs.core.chunk_append(b__30847,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data));

var G__30854 = (i__30846 + (1));
i__30846 = G__30854;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30847),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__30844(cljs.core.chunk_rest(s__30845__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30847),null);
}
} else {
var datum = cljs.core.first(s__30845__$2);
return cljs.core.cons(cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__30844(cljs.core.rest(s__30845__$2)));
}
} else {
return null;
}
break;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
,null,null));
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
return iter__5341__auto__(data__$1);
});
;})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
var seq__30850 = cljs.core.seq(osm_fields);
var chunk__30851 = null;
var count__30852 = (0);
var i__30853 = (0);
while(true){
if((i__30853 < count__30852)){
var osm_field = chunk__30851.cljs$core$IIndexed$_nth$arity$2(null,i__30853);
hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__30855 = seq__30850;
var G__30856 = chunk__30851;
var G__30857 = count__30852;
var G__30858 = (i__30853 + (1));
seq__30850 = G__30855;
chunk__30851 = G__30856;
count__30852 = G__30857;
i__30853 = G__30858;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__30850);
if(temp__4425__auto__){
var seq__30850__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__30850__$1)){
var c__5372__auto__ = cljs.core.chunk_first(seq__30850__$1);
var G__30859 = cljs.core.chunk_rest(seq__30850__$1);
var G__30860 = c__5372__auto__;
var G__30861 = cljs.core.count(c__5372__auto__);
var G__30862 = (0);
seq__30850 = G__30859;
chunk__30851 = G__30860;
count__30852 = G__30861;
i__30853 = G__30862;
continue;
} else {
var osm_field = cljs.core.first(seq__30850__$1);
hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__30863 = cljs.core.next(seq__30850__$1);
var G__30864 = null;
var G__30865 = (0);
var G__30866 = (0);
seq__30850 = G__30863;
chunk__30851 = G__30864;
count__30852 = G__30865;
i__30853 = G__30866;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
/**
 * Calculate full image and thumbnail urls given attachment information.
 */
hatti.ona.post_process.url_obj = (function hatti$ona$post_process$url_obj(media_obj){
var media_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"id");
var fname = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"filename");
var file_url = hatti.ona.urls.media_url(media_id,fname);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$filename,fname,cljs.core.cst$kw$download_url,file_url,cljs.core.cst$kw$small_download_url,[cljs.core.str(file_url),cljs.core.str("&suffix=small")].join('')], null);
});
/**
 * Helper function for integrate attachments; returns a function from
 * a filename to a `url-obj` (see specs in `url-obj` function).
 */
hatti.ona.post_process.get_attach_map = (function hatti$ona$post_process$get_attach_map(record,attachments){
var attachments__$1 = (function (){var or__4569__auto__ = attachments;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,"_attachments");
}
})();
var fnames = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (attachments__$1){
return (function (p1__30867_SHARP_){
return hatti.utils.last_url_param(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__30867_SHARP_,"filename"));
});})(attachments__$1))
,attachments__$1);
var fname__GT_urlobj = cljs.core.zipmap(fnames,cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.ona.post_process.url_obj,attachments__$1));
return ((function (attachments__$1,fnames,fname__GT_urlobj){
return (function (fname){
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(fname__GT_urlobj,fname,fname);
});
;})(attachments__$1,fnames,fname__GT_urlobj))
});
/**
 * Inlines media data from within _attachments into each record.
 */
hatti.ona.post_process.integrate_attachments = (function hatti$ona$post_process$integrate_attachments(var_args){
var args__5634__auto__ = [];
var len__5627__auto___30880 = arguments.length;
var i__5628__auto___30881 = (0);
while(true){
if((i__5628__auto___30881 < len__5627__auto___30880)){
args__5634__auto__.push((arguments[i__5628__auto___30881]));

var G__30882 = (i__5628__auto___30881 + (1));
i__5628__auto___30881 = G__30882;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,data,p__30871){
var map__30872 = p__30871;
var map__30872__$1 = ((((!((map__30872 == null)))?((((map__30872.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30872.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30872):map__30872);
var attachments = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30872__$1,cljs.core.cst$kw$attachments);
var image_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.image_QMARK_,flat_form);
var iter__5341__auto__ = ((function (image_fields,map__30872,map__30872__$1,attachments){
return (function hatti$ona$post_process$iter__30874(s__30875){
return (new cljs.core.LazySeq(null,((function (image_fields,map__30872,map__30872__$1,attachments){
return (function (){
var s__30875__$1 = s__30875;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__30875__$1);
if(temp__4425__auto__){
var s__30875__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__30875__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__30875__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__30877 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__30876 = (0);
while(true){
if((i__30876 < size__5340__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__30876);
cljs.core.chunk_append(b__30877,(function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (i__30876,attach_map,record,c__5339__auto__,size__5340__auto__,b__30877,s__30875__$2,temp__4425__auto__,image_fields,map__30872,map__30872__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(i__30876,attach_map,record,c__5339__auto__,size__5340__auto__,b__30877,s__30875__$2,temp__4425__auto__,image_fields,map__30872,map__30872__$1,attachments))
,record,image_fields);
})());

var G__30883 = (i__30876 + (1));
i__30876 = G__30883;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30877),hatti$ona$post_process$iter__30874(cljs.core.chunk_rest(s__30875__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30877),null);
}
} else {
var record = cljs.core.first(s__30875__$2);
return cljs.core.cons((function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (attach_map,record,s__30875__$2,temp__4425__auto__,image_fields,map__30872,map__30872__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(attach_map,record,s__30875__$2,temp__4425__auto__,image_fields,map__30872,map__30872__$1,attachments))
,record,image_fields);
})(),hatti$ona$post_process$iter__30874(cljs.core.rest(s__30875__$2)));
}
} else {
return null;
}
break;
}
});})(image_fields,map__30872,map__30872__$1,attachments))
,null,null));
});})(image_fields,map__30872,map__30872__$1,attachments))
;
return iter__5341__auto__(data);
});

hatti.ona.post_process.integrate_attachments.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments.cljs$lang$applyTo = (function (seq30868){
var G__30869 = cljs.core.first(seq30868);
var seq30868__$1 = cljs.core.next(seq30868);
var G__30870 = cljs.core.first(seq30868__$1);
var seq30868__$2 = cljs.core.next(seq30868__$1);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(G__30869,G__30870,seq30868__$2);
});
/**
 * Inlines data from within _attachments into each datapoint within repeats.
 */
hatti.ona.post_process.integrate_attachments_in_repeats = (function hatti$ona$post_process$integrate_attachments_in_repeats(flat_form,data){
var repeat_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.repeat_QMARK_,flat_form);
var integrate = ((function (repeat_fields){
return (function (record,rpt_field){
var key = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(rpt_field);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(record,key,hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(rpt_field),cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,key),cljs.core.array_seq([cljs.core.cst$kw$attachments,cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,"_attachments")], 0)));
});})(repeat_fields))
;
var iter__5341__auto__ = ((function (repeat_fields,integrate){
return (function hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__30890(s__30891){
return (new cljs.core.LazySeq(null,((function (repeat_fields,integrate){
return (function (){
var s__30891__$1 = s__30891;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__30891__$1);
if(temp__4425__auto__){
var s__30891__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__30891__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__30891__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__30893 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__30892 = (0);
while(true){
if((i__30892 < size__5340__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__30892);
cljs.core.chunk_append(b__30893,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields));

var G__30896 = (i__30892 + (1));
i__30892 = G__30896;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30893),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__30890(cljs.core.chunk_rest(s__30891__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30893),null);
}
} else {
var record = cljs.core.first(s__30891__$2);
return cljs.core.cons(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__30890(cljs.core.rest(s__30891__$2)));
}
} else {
return null;
}
break;
}
});})(repeat_fields,integrate))
,null,null));
});})(repeat_fields,integrate))
;
return iter__5341__auto__(data);
});
/**
 * Inlines data from within _atatchments into each record within app-state.
 */
hatti.ona.post_process.integrate_attachments_BANG_ = (function hatti$ona$post_process$integrate_attachments_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___30904 = arguments.length;
var i__5628__auto___30905 = (0);
while(true){
if((i__5628__auto___30905 < len__5627__auto___30904)){
args__5634__auto__.push((arguments[i__5628__auto___30905]));

var G__30906 = (i__5628__auto___30905 + (1));
i__5628__auto___30905 = G__30906;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,flat_form,p__30901){
var map__30902 = p__30901;
var map__30902__$1 = ((((!((map__30902 == null)))?((((map__30902.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30902.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30902):map__30902);
var app_data_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__30902__$1,cljs.core.cst$kw$app_DASH_data_DASH_keys,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_data_keys,((function (map__30902,map__30902__$1,app_data_keys){
return (function (p1__30897_SHARP_){
return hatti.ona.post_process.integrate_attachments_in_repeats(flat_form,hatti.ona.post_process.integrate_attachments(flat_form,p1__30897_SHARP_));
});})(map__30902,map__30902__$1,app_data_keys))
);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$applyTo = (function (seq30898){
var G__30899 = cljs.core.first(seq30898);
var seq30898__$1 = cljs.core.next(seq30898);
var G__30900 = cljs.core.first(seq30898__$1);
var seq30898__$2 = cljs.core.next(seq30898__$1);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__30899,G__30900,seq30898__$2);
});
