// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.post_process');
goog.require('cljs.core');
goog.require('hatti.ona.forms');
goog.require('hatti.ona.urls');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.utils');
goog.require('hatti.utils.om.state');
/**
 * Given some data in Ona format, builds a data structure that we will use
 * to link osm data to Ona data.
 */
hatti.ona.post_process.ona_osm_link = (function hatti$ona$post_process$ona_osm_link(data,form){
var osmfields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.flatten((function (){var iter__5341__auto__ = ((function (osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__26919(s__26920){
return (new cljs.core.LazySeq(null,((function (osmfields){
return (function (){
var s__26920__$1 = s__26920;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__26920__$1);
if(temp__4425__auto__){
var s__26920__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__26920__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__26920__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__26922 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__26921 = (0);
while(true){
if((i__26921 < size__5340__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__26921);
cljs.core.chunk_append(b__26922,(function (){var iter__5341__auto__ = ((function (i__26921,datum,c__5339__auto__,size__5340__auto__,b__26922,s__26920__$2,temp__4425__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__26919_$_iter__26937(s__26938){
return (new cljs.core.LazySeq(null,((function (i__26921,datum,c__5339__auto__,size__5340__auto__,b__26922,s__26920__$2,temp__4425__auto__,osmfields){
return (function (){
var s__26938__$1 = s__26938;
while(true){
var temp__4425__auto____$1 = cljs.core.seq(s__26938__$1);
if(temp__4425__auto____$1){
var s__26938__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__26938__$2)){
var c__5339__auto____$1 = cljs.core.chunk_first(s__26938__$2);
var size__5340__auto____$1 = cljs.core.count(c__5339__auto____$1);
var b__26940 = cljs.core.chunk_buffer(size__5340__auto____$1);
if((function (){var i__26939 = (0);
while(true){
if((i__26939 < size__5340__auto____$1)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto____$1,i__26939);
cljs.core.chunk_append(b__26940,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__26949 = (i__26939 + (1));
i__26939 = G__26949;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__26940),hatti$ona$post_process$ona_osm_link_$_iter__26919_$_iter__26937(cljs.core.chunk_rest(s__26938__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__26940),null);
}
} else {
var field = cljs.core.first(s__26938__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__26919_$_iter__26937(cljs.core.rest(s__26938__$2)));
}
} else {
return null;
}
break;
}
});})(i__26921,datum,c__5339__auto__,size__5340__auto__,b__26922,s__26920__$2,temp__4425__auto__,osmfields))
,null,null));
});})(i__26921,datum,c__5339__auto__,size__5340__auto__,b__26922,s__26920__$2,temp__4425__auto__,osmfields))
;
return iter__5341__auto__(osmfields);
})());

var G__26950 = (i__26921 + (1));
i__26921 = G__26950;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__26922),hatti$ona$post_process$ona_osm_link_$_iter__26919(cljs.core.chunk_rest(s__26920__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__26922),null);
}
} else {
var datum = cljs.core.first(s__26920__$2);
return cljs.core.cons((function (){var iter__5341__auto__ = ((function (datum,s__26920__$2,temp__4425__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__26919_$_iter__26943(s__26944){
return (new cljs.core.LazySeq(null,((function (datum,s__26920__$2,temp__4425__auto__,osmfields){
return (function (){
var s__26944__$1 = s__26944;
while(true){
var temp__4425__auto____$1 = cljs.core.seq(s__26944__$1);
if(temp__4425__auto____$1){
var s__26944__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__26944__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__26944__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__26946 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__26945 = (0);
while(true){
if((i__26945 < size__5340__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__26945);
cljs.core.chunk_append(b__26946,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__26951 = (i__26945 + (1));
i__26945 = G__26951;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__26946),hatti$ona$post_process$ona_osm_link_$_iter__26919_$_iter__26943(cljs.core.chunk_rest(s__26944__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__26946),null);
}
} else {
var field = cljs.core.first(s__26944__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__26919_$_iter__26943(cljs.core.rest(s__26944__$2)));
}
} else {
return null;
}
break;
}
});})(datum,s__26920__$2,temp__4425__auto__,osmfields))
,null,null));
});})(datum,s__26920__$2,temp__4425__auto__,osmfields))
;
return iter__5341__auto__(osmfields);
})(),hatti$ona$post_process$ona_osm_link_$_iter__26919(cljs.core.rest(s__26920__$2)));
}
} else {
return null;
}
break;
}
});})(osmfields))
,null,null));
});})(osmfields))
;
return iter__5341__auto__(data);
})()));
});
/**
 * Takes OSM XML in string form, and returns cljs geojson.
 */
hatti.ona.post_process.osm_xml__GT_geojson = (function hatti$ona$post_process$osm_xml__GT_geojson(osm_xml_string){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic((function (){var G__26953 = jQuery.parseXML(osm_xml_string);
return osmtogeojson(G__26953);
})(),cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Given some data in OSM format, an Ona Form, and osm xml string,
 * return a map from OSM ID to each osm feature. The map contains:
 * :osm-id, :name, :tags from osm xml,
 * :type, :geom from osm feature's geojson equivalent.
 */
hatti.ona.post_process.osm_id__GT_osm_data = (function hatti$ona$post_process$osm_id__GT_osm_data(data,form,osm_xml){
var ona_osm_link = hatti.ona.post_process.ona_osm_link(data,form);
var osmgeo = hatti.ona.post_process.osm_xml__GT_geojson(osm_xml);
var featureset = (osmgeo.cljs$core$IFn$_invoke$arity$1 ? osmgeo.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$features) : osmgeo.call(null,cljs.core.cst$kw$features));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5341__auto__ = ((function (ona_osm_link,osmgeo,featureset){
return (function hatti$ona$post_process$osm_id__GT_osm_data_$_iter__26976(s__26977){
return (new cljs.core.LazySeq(null,((function (ona_osm_link,osmgeo,featureset){
return (function (){
var s__26977__$1 = s__26977;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__26977__$1);
if(temp__4425__auto__){
var s__26977__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__26977__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__26977__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__26979 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__26978 = (0);
while(true){
if((i__26978 < size__5340__auto__)){
var map__26990 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__26978);
var map__26990__$1 = ((((!((map__26990 == null)))?((((map__26990.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26990.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26990):map__26990);
var feature = map__26990__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26990__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26990__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26990__$1,cljs.core.cst$kw$geometry);
cljs.core.chunk_append(b__26979,(function (){var map__26992 = properties;
var map__26992__$1 = ((((!((map__26992 == null)))?((((map__26992.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26992.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26992):map__26992);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26992__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26992__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26992__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})());

var G__26998 = (i__26978 + (1));
i__26978 = G__26998;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__26979),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__26976(cljs.core.chunk_rest(s__26977__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__26979),null);
}
} else {
var map__26994 = cljs.core.first(s__26977__$2);
var map__26994__$1 = ((((!((map__26994 == null)))?((((map__26994.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26994.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26994):map__26994);
var feature = map__26994__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26994__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26994__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26994__$1,cljs.core.cst$kw$geometry);
return cljs.core.cons((function (){var map__26996 = properties;
var map__26996__$1 = ((((!((map__26996 == null)))?((((map__26996.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26996.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26996):map__26996);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26996__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26996__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26996__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})(),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__26976(cljs.core.rest(s__26977__$2)));
}
} else {
return null;
}
break;
}
});})(ona_osm_link,osmgeo,featureset))
,null,null));
});})(ona_osm_link,osmgeo,featureset))
;
return iter__5341__auto__(featureset);
})());
});
/**
 * Given some data post-processed from the ona server
 * (ie, containing _id, _rank), and a string of osm-xml, produce a version with
 * relevant osm data injected in.
 */
hatti.ona.post_process.integrate_osm_data_BANG_ = (function hatti$ona$post_process$integrate_osm_data_BANG_(app_state,form,osm_xml,app_state_keys){
var osm_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
if(cljs.core.seq(osm_fields)){
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(app_state,app_state_keys);
var osm_data = hatti.ona.post_process.osm_id__GT_osm_data(data,form,osm_xml);
var osm_val__GT_osm_id = ((function (data,osm_data,osm_fields){
return (function (p1__26999_SHARP_){
return cljs.core.re_find(/[-]?[0-9]+/,p1__26999_SHARP_);
});})(data,osm_data,osm_fields))
;
var osm_val__GT_osm_data = ((function (data,osm_data,osm_val__GT_osm_id,osm_fields){
return (function (osm_val){
if(typeof osm_val === 'string'){
var temp__4423__auto__ = (function (){var G__27011 = osm_val__GT_osm_id(osm_val);
return (osm_data.cljs$core$IFn$_invoke$arity$1 ? osm_data.cljs$core$IFn$_invoke$arity$1(G__27011) : osm_data.call(null,G__27011));
})();
if(cljs.core.truth_(temp__4423__auto__)){
var osm_submission_data = temp__4423__auto__;
return osm_submission_data;
} else {
return osm_val;
}
} else {
return osm_val;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_fields))
;
var updater = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (osm_key){
return ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (data__$1){
var iter__5341__auto__ = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function hatti$ona$post_process$integrate_osm_data_BANG__$_iter__27012(s__27013){
return (new cljs.core.LazySeq(null,((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (){
var s__27013__$1 = s__27013;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__27013__$1);
if(temp__4425__auto__){
var s__27013__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__27013__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__27013__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__27015 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__27014 = (0);
while(true){
if((i__27014 < size__5340__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__27014);
cljs.core.chunk_append(b__27015,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data));

var G__27022 = (i__27014 + (1));
i__27014 = G__27022;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__27015),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__27012(cljs.core.chunk_rest(s__27013__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__27015),null);
}
} else {
var datum = cljs.core.first(s__27013__$2);
return cljs.core.cons(cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__27012(cljs.core.rest(s__27013__$2)));
}
} else {
return null;
}
break;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
,null,null));
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
return iter__5341__auto__(data__$1);
});
;})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
var seq__27018 = cljs.core.seq(osm_fields);
var chunk__27019 = null;
var count__27020 = (0);
var i__27021 = (0);
while(true){
if((i__27021 < count__27020)){
var osm_field = chunk__27019.cljs$core$IIndexed$_nth$arity$2(null,i__27021);
hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__27023 = seq__27018;
var G__27024 = chunk__27019;
var G__27025 = count__27020;
var G__27026 = (i__27021 + (1));
seq__27018 = G__27023;
chunk__27019 = G__27024;
count__27020 = G__27025;
i__27021 = G__27026;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__27018);
if(temp__4425__auto__){
var seq__27018__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__27018__$1)){
var c__5372__auto__ = cljs.core.chunk_first(seq__27018__$1);
var G__27027 = cljs.core.chunk_rest(seq__27018__$1);
var G__27028 = c__5372__auto__;
var G__27029 = cljs.core.count(c__5372__auto__);
var G__27030 = (0);
seq__27018 = G__27027;
chunk__27019 = G__27028;
count__27020 = G__27029;
i__27021 = G__27030;
continue;
} else {
var osm_field = cljs.core.first(seq__27018__$1);
hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__27031 = cljs.core.next(seq__27018__$1);
var G__27032 = null;
var G__27033 = (0);
var G__27034 = (0);
seq__27018 = G__27031;
chunk__27019 = G__27032;
count__27020 = G__27033;
i__27021 = G__27034;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
/**
 * Calculate full image and thumbnail urls given attachment information.
 */
hatti.ona.post_process.url_obj = (function hatti$ona$post_process$url_obj(media_obj){
var media_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"id");
var fname = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"filename");
var file_url = hatti.ona.urls.media_url(media_id,fname);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$filename,fname,cljs.core.cst$kw$download_url,file_url,cljs.core.cst$kw$small_download_url,[cljs.core.str(file_url),cljs.core.str("&suffix=small")].join('')], null);
});
/**
 * Helper function for integrate attachments; returns a function from
 * a filename to a `url-obj` (see specs in `url-obj` function).
 */
hatti.ona.post_process.get_attach_map = (function hatti$ona$post_process$get_attach_map(record,attachments){
var attachments__$1 = (function (){var or__4569__auto__ = attachments;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,"_attachments");
}
})();
var fnames = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (attachments__$1){
return (function (p1__27035_SHARP_){
return hatti.utils.last_url_param(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__27035_SHARP_,"filename"));
});})(attachments__$1))
,attachments__$1);
var fname__GT_urlobj = cljs.core.zipmap(fnames,cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.ona.post_process.url_obj,attachments__$1));
return ((function (attachments__$1,fnames,fname__GT_urlobj){
return (function (fname){
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(fname__GT_urlobj,fname,fname);
});
;})(attachments__$1,fnames,fname__GT_urlobj))
});
/**
 * Inlines media data from within _attachments into each record.
 */
hatti.ona.post_process.integrate_attachments = (function hatti$ona$post_process$integrate_attachments(var_args){
var args__5634__auto__ = [];
var len__5627__auto___27048 = arguments.length;
var i__5628__auto___27049 = (0);
while(true){
if((i__5628__auto___27049 < len__5627__auto___27048)){
args__5634__auto__.push((arguments[i__5628__auto___27049]));

var G__27050 = (i__5628__auto___27049 + (1));
i__5628__auto___27049 = G__27050;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,data,p__27039){
var map__27040 = p__27039;
var map__27040__$1 = ((((!((map__27040 == null)))?((((map__27040.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27040.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27040):map__27040);
var attachments = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27040__$1,cljs.core.cst$kw$attachments);
var image_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.image_QMARK_,flat_form);
var iter__5341__auto__ = ((function (image_fields,map__27040,map__27040__$1,attachments){
return (function hatti$ona$post_process$iter__27042(s__27043){
return (new cljs.core.LazySeq(null,((function (image_fields,map__27040,map__27040__$1,attachments){
return (function (){
var s__27043__$1 = s__27043;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__27043__$1);
if(temp__4425__auto__){
var s__27043__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__27043__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__27043__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__27045 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__27044 = (0);
while(true){
if((i__27044 < size__5340__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__27044);
cljs.core.chunk_append(b__27045,(function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (i__27044,attach_map,record,c__5339__auto__,size__5340__auto__,b__27045,s__27043__$2,temp__4425__auto__,image_fields,map__27040,map__27040__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(i__27044,attach_map,record,c__5339__auto__,size__5340__auto__,b__27045,s__27043__$2,temp__4425__auto__,image_fields,map__27040,map__27040__$1,attachments))
,record,image_fields);
})());

var G__27051 = (i__27044 + (1));
i__27044 = G__27051;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__27045),hatti$ona$post_process$iter__27042(cljs.core.chunk_rest(s__27043__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__27045),null);
}
} else {
var record = cljs.core.first(s__27043__$2);
return cljs.core.cons((function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (attach_map,record,s__27043__$2,temp__4425__auto__,image_fields,map__27040,map__27040__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(attach_map,record,s__27043__$2,temp__4425__auto__,image_fields,map__27040,map__27040__$1,attachments))
,record,image_fields);
})(),hatti$ona$post_process$iter__27042(cljs.core.rest(s__27043__$2)));
}
} else {
return null;
}
break;
}
});})(image_fields,map__27040,map__27040__$1,attachments))
,null,null));
});})(image_fields,map__27040,map__27040__$1,attachments))
;
return iter__5341__auto__(data);
});

hatti.ona.post_process.integrate_attachments.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments.cljs$lang$applyTo = (function (seq27036){
var G__27037 = cljs.core.first(seq27036);
var seq27036__$1 = cljs.core.next(seq27036);
var G__27038 = cljs.core.first(seq27036__$1);
var seq27036__$2 = cljs.core.next(seq27036__$1);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(G__27037,G__27038,seq27036__$2);
});
/**
 * Inlines data from within _attachments into each datapoint within repeats.
 */
hatti.ona.post_process.integrate_attachments_in_repeats = (function hatti$ona$post_process$integrate_attachments_in_repeats(flat_form,data){
var repeat_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.repeat_QMARK_,flat_form);
var integrate = ((function (repeat_fields){
return (function (record,rpt_field){
var key = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(rpt_field);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(record,key,hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(rpt_field),cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,key),cljs.core.array_seq([cljs.core.cst$kw$attachments,cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,"_attachments")], 0)));
});})(repeat_fields))
;
var iter__5341__auto__ = ((function (repeat_fields,integrate){
return (function hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__27058(s__27059){
return (new cljs.core.LazySeq(null,((function (repeat_fields,integrate){
return (function (){
var s__27059__$1 = s__27059;
while(true){
var temp__4425__auto__ = cljs.core.seq(s__27059__$1);
if(temp__4425__auto__){
var s__27059__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s__27059__$2)){
var c__5339__auto__ = cljs.core.chunk_first(s__27059__$2);
var size__5340__auto__ = cljs.core.count(c__5339__auto__);
var b__27061 = cljs.core.chunk_buffer(size__5340__auto__);
if((function (){var i__27060 = (0);
while(true){
if((i__27060 < size__5340__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5339__auto__,i__27060);
cljs.core.chunk_append(b__27061,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields));

var G__27064 = (i__27060 + (1));
i__27060 = G__27064;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__27061),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__27058(cljs.core.chunk_rest(s__27059__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__27061),null);
}
} else {
var record = cljs.core.first(s__27059__$2);
return cljs.core.cons(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__27058(cljs.core.rest(s__27059__$2)));
}
} else {
return null;
}
break;
}
});})(repeat_fields,integrate))
,null,null));
});})(repeat_fields,integrate))
;
return iter__5341__auto__(data);
});
/**
 * Inlines data from within _atatchments into each record within app-state.
 */
hatti.ona.post_process.integrate_attachments_BANG_ = (function hatti$ona$post_process$integrate_attachments_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___27072 = arguments.length;
var i__5628__auto___27073 = (0);
while(true){
if((i__5628__auto___27073 < len__5627__auto___27072)){
args__5634__auto__.push((arguments[i__5628__auto___27073]));

var G__27074 = (i__5628__auto___27073 + (1));
i__5628__auto___27073 = G__27074;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,flat_form,p__27069){
var map__27070 = p__27069;
var map__27070__$1 = ((((!((map__27070 == null)))?((((map__27070.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27070.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27070):map__27070);
var app_data_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__27070__$1,cljs.core.cst$kw$app_DASH_data_DASH_keys,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
return hatti.utils.om.state.transact_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_data_keys,((function (map__27070,map__27070__$1,app_data_keys){
return (function (p1__27065_SHARP_){
return hatti.ona.post_process.integrate_attachments_in_repeats(flat_form,hatti.ona.post_process.integrate_attachments(flat_form,p1__27065_SHARP_));
});})(map__27070,map__27070__$1,app_data_keys))
);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$applyTo = (function (seq27066){
var G__27067 = cljs.core.first(seq27066);
var seq27066__$1 = cljs.core.next(seq27066);
var G__27068 = cljs.core.first(seq27066__$1);
var seq27066__$2 = cljs.core.next(seq27066__$1);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__27067,G__27068,seq27066__$2);
});
