// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Extra fields that will be displayed on the table.
 */
hatti.views.table.get_extra_fields = (function hatti$views$table$get_extra_fields(is_filtered_dataview_QMARK_){
var extra_field = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"full-name","full-name",408178550),hatti.constants._id,new cljs.core.Keyword(null,"label","label",1718410804),"id",new cljs.core.Keyword(null,"name","name",1843675177),hatti.constants._id,new cljs.core.Keyword(null,"type","type",1174270348),"integer"], null)], null);
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
return extra_field;
} else {
return cljs.core.conj.call(null,extra_field,hatti.ona.forms.submission_time_field);
}
});
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(var_args){
var args__5634__auto__ = [];
var len__5627__auto___10830 = arguments.length;
var i__5628__auto___10831 = (0);
while(true){
if((i__5628__auto___10831 < len__5627__auto___10830)){
args__5634__auto__.push((arguments[i__5628__auto___10831]));

var G__10832 = (i__5628__auto___10831 + (1));
i__5628__auto___10831 = G__10832;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__10827){
var map__10828 = p__10827;
var map__10828__$1 = ((((!((map__10828 == null)))?((((map__10828.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10828.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10828):map__10828);
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__10828__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
return cljs.core.distinct.call(null,cljs.core.filter.call(null,hatti.ona.forms.has_data_QMARK_,cljs.core.concat.call(null,hatti.views.table.get_extra_fields.call(null,is_filtered_dataview_QMARK_),hatti.ona.forms.non_meta_fields.call(null,form),hatti.ona.forms.meta_fields.call(null,form,new cljs.core.Keyword(null,"with-submission-details?","with-submission-details?",524960549),cljs.core.not.call(null,is_filtered_dataview_QMARK_)))));
});

hatti.views.table.all_fields.cljs$lang$maxFixedArity = (1);

hatti.views.table.all_fields.cljs$lang$applyTo = (function (seq10825){
var G__10826 = cljs.core.first.call(null,seq10825);
var seq10825__$1 = cljs.core.next.call(null,seq10825);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(G__10826,seq10825__$1);
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__10833_SHARP_){
if(typeof p1__10833_SHARP_ === 'string'){
return clojure.string.lower_case.call(null,p1__10833_SHARP_);
} else {
return p1__10833_SHARP_;
}
});})(col))
;
var aval = lower.call(null,(a[(col["field"])]));
var bval = lower.call(null,(b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not.call(null,args)){
return true;
} else {
var indexed_form = cljs.core.zipmap.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550),form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__10837){
var vec__10838 = p__10837;
var fname = cljs.core.nth.call(null,vec__10838,(0),null);
var answer = cljs.core.nth.call(null,vec__10838,(1),null);
return hatti.ona.forms.format_answer.call(null,cljs.core.get.call(null,indexed_form,fname),answer,null,true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map.call(null,((function (indexed_form,query,fmt_subitem){
return (function (p1__10834_SHARP_){
return cljs.core.re_find.call(null,hatti.utils.safe_regex.call(null,query),[cljs.core.str(p1__10834_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.call(null,fmt_subitem,cljs.core.js__GT_clj.call(null,item))));
return cljs.core.seq.call(null,filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.call(null,value,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return hatti.ona.forms.format_answer.call(null,field,clj_value,language,true);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args10839 = [];
var len__5627__auto___10861 = arguments.length;
var i__5628__auto___10862 = (0);
while(true){
if((i__5628__auto___10862 < len__5627__auto___10861)){
args10839.push((arguments[i__5628__auto___10862]));

var G__10863 = (i__5628__auto___10862 + (1));
i__5628__auto___10862 = G__10863;
continue;
} else {
}
break;
}

var G__10845 = args10839.length;
switch (G__10845) {
case 1:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args10839.slice((3)),(0)));
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5646__auto__);

}
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1 = (function (form){
return hatti.views.table.flat_form__GT_sg_columns.call(null,form,true);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2 = (function (form,get_label_QMARK_){
return hatti.views.table.flat_form__GT_sg_columns.call(null,form,get_label_QMARK_,null);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,get_label_QMARK_,language,p__10846){
var map__10847 = p__10846;
var map__10847__$1 = ((((!((map__10847 == null)))?((((map__10847.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10847.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10847):map__10847);
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__10847__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
return cljs.core.clj__GT_js.call(null,(function (){var iter__5341__auto__ = ((function (map__10847,map__10847__$1,is_filtered_dataview_QMARK_){
return (function hatti$views$table$iter__10849(s__10850){
return (new cljs.core.LazySeq(null,((function (map__10847,map__10847__$1,is_filtered_dataview_QMARK_){
return (function (){
var s__10850__$1 = s__10850;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__10850__$1);
if(temp__4425__auto__){
var s__10850__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__10850__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__10850__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__10852 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__10851 = (0);
while(true){
if((i__10851 < size__5340__auto__)){
var field = cljs.core._nth.call(null,c__5339__auto__,i__10851);
cljs.core.chunk_append.call(null,b__10852,(function (){var map__10857 = field;
var map__10857__$1 = ((((!((map__10857 == null)))?((((map__10857.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10857.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10857):map__10857);
var name = cljs.core.get.call(null,map__10857__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__10857__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__10857__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hatti.ona.forms.get_column_class.call(null,field),label,cljs.core.partial.call(null,hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class.call(null,field),label]);
})());

var G__10865 = (i__10851 + (1));
i__10851 = G__10865;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__10852),hatti$views$table$iter__10849.call(null,cljs.core.chunk_rest.call(null,s__10850__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__10852),null);
}
} else {
var field = cljs.core.first.call(null,s__10850__$2);
return cljs.core.cons.call(null,(function (){var map__10859 = field;
var map__10859__$1 = ((((!((map__10859 == null)))?((((map__10859.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10859.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10859):map__10859);
var name = cljs.core.get.call(null,map__10859__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__10859__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__10859__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hatti.ona.forms.get_column_class.call(null,field),label,cljs.core.partial.call(null,hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class.call(null,field),label]);
})(),hatti$views$table$iter__10849.call(null,cljs.core.rest.call(null,s__10850__$2)));
}
} else {
return null;
}
break;
}
});})(map__10847,map__10847__$1,is_filtered_dataview_QMARK_))
,null,null));
});})(map__10847,map__10847__$1,is_filtered_dataview_QMARK_))
;
return iter__5341__auto__.call(null,hatti.views.table.all_fields.call(null,form,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746),is_filtered_dataview_QMARK_));
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq10840){
var G__10841 = cljs.core.first.call(null,seq10840);
var seq10840__$1 = cljs.core.next.call(null,seq10840);
var G__10842 = cljs.core.first.call(null,seq10840__$1);
var seq10840__$2 = cljs.core.next.call(null,seq10840__$1);
var G__10843 = cljs.core.first.call(null,seq10840__$2);
var seq10840__$3 = cljs.core.next.call(null,seq10840__$2);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__10841,G__10842,G__10843,seq10840__$3);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (3);
hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,jQuery([cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join(''))));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = {"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false};
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__10874(s__10875){
return (new cljs.core.LazySeq(null,(function (){
var s__10875__$1 = s__10875;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__10875__$1);
if(temp__4425__auto__){
var s__10875__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__10875__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__10875__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__10877 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__10876 = (0);
while(true){
if((i__10876 < size__5340__auto__)){
var vec__10880 = cljs.core._nth.call(null,c__5339__auto__,i__10876);
var handler_key = cljs.core.nth.call(null,vec__10880,(0),null);
var handler_function = cljs.core.nth.call(null,vec__10880,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append.call(null,b__10877,event.subscribe(handler_function));

var G__10882 = (i__10876 + (1));
i__10876 = G__10882;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__10877),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__10874.call(null,cljs.core.chunk_rest.call(null,s__10875__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__10877),null);
}
} else {
var vec__10881 = cljs.core.first.call(null,s__10875__$2);
var handler_key = cljs.core.nth.call(null,vec__10881,(0),null);
var handler_function = cljs.core.nth.call(null,vec__10881,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__10874.call(null,cljs.core.rest.call(null,s__10875__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__10891(s__10892){
return (new cljs.core.LazySeq(null,(function (){
var s__10892__$1 = s__10892;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__10892__$1);
if(temp__4425__auto__){
var s__10892__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__10892__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__10892__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__10894 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__10893 = (0);
while(true){
if((i__10893 < size__5340__auto__)){
var vec__10897 = cljs.core._nth.call(null,c__5339__auto__,i__10893);
var handler_key = cljs.core.nth.call(null,vec__10897,(0),null);
var handler_function = cljs.core.nth.call(null,vec__10897,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append.call(null,b__10894,event.subscribe(handler_function));

var G__10899 = (i__10893 + (1));
i__10893 = G__10899;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__10894),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__10891.call(null,cljs.core.chunk_rest.call(null,s__10892__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__10894),null);
}
} else {
var vec__10898 = cljs.core.first.call(null,s__10892__$2);
var handler_key = cljs.core.nth.call(null,vec__10898,(0),null);
var handler_function = cljs.core.nth.call(null,vec__10898,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__10891.call(null,cljs.core.rest.call(null,s__10892__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,is_filtered_dataview_QMARK_,p__10900){
var map__10909 = p__10900;
var map__10909__$1 = ((((!((map__10909 == null)))?((((map__10909.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10909.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10909):map__10909);
var grid_event_handlers = cljs.core.get.call(null,map__10909__$1,new cljs.core.Keyword(null,"grid-event-handlers","grid-event-handlers",1413592355));
var dataview_event_handlers = cljs.core.get.call(null,map__10909__$1,new cljs.core.Keyword(null,"dataview-event-handlers","dataview-event-handlers",-916375885));
var columns = hatti.views.table.flat_form__GT_sg_columns.call(null,form,true,current_language,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746),is_filtered_dataview_QMARK_);
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
var map__10911 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__10911__$1 = ((((!((map__10911 == null)))?((((map__10911.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10911.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10911):map__10911);
var map__10912 = cljs.core.get.call(null,map__10911__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__10912__$1 = ((((!((map__10912 == null)))?((((map__10912.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10912.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10912):map__10912);
var map__10913 = cljs.core.get.call(null,map__10912__$1,new cljs.core.Keyword(null,"paging","paging",1716279728));
var map__10913__$1 = ((((!((map__10913 == null)))?((((map__10913.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10913.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10913):map__10913);
var num_displayed_records = cljs.core.get.call(null,map__10913__$1,new cljs.core.Keyword(null,"num-displayed-records","num-displayed-records",213046400));
var total_page_count = cljs.core.get.call(null,map__10913__$1,new cljs.core.Keyword(null,"total-page-count","total-page-count",582341740));
hatti.views.table.bind_external_sg_grid_event_handlers.call(null,grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers.call(null,dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__10911,map__10911__$1,map__10912,map__10912__$1,map__10913,map__10913__$1,num_displayed_records,total_page_count,map__10909,map__10909__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__10911,map__10911__$1,map__10912,map__10912__$1,map__10913,map__10913__$1,num_displayed_records,total_page_count,map__10909,map__10909__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__10911,map__10911__$1,map__10912,map__10912__$1,map__10913,map__10913__$1,num_displayed_records,total_page_count,map__10909,map__10909__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__10911,map__10911__$1,map__10912,map__10912__$1,map__10913,map__10913__$1,num_displayed_records,total_page_count,map__10909,map__10909__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__10911,map__10911__$1,map__10912,map__10912__$1,map__10913,map__10913__$1,num_displayed_records,total_page_count,map__10909,map__10909__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
});})(columns,SlickGrid,DataView,dataview,grid,map__10911,map__10911__$1,map__10912,map__10912__$1,map__10913,map__10913__$1,num_displayed_records,total_page_count,map__10909,map__10909__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager.call(null,grid,dataview);

dataview.setPagingOptions({"pageSize": (function (){var or__4569__auto__ = num_displayed_records;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count});

dataview.setFilter(cljs.core.partial.call(null,hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js.call(null,data),hatti.constants._id);

hatti.views.table.resizeColumns.call(null,grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap.call(null);
var c__7694__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto__,event_chan){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto__,event_chan){
return (function (state_11178){
var state_val_11179 = (state_11178[(1)]);
if((state_val_11179 === (7))){
var inst_11087 = (state_11178[(7)]);
var inst_11087__$1 = (state_11178[(2)]);
var inst_11089 = (inst_11087__$1 == null);
var inst_11090 = cljs.core.not.call(null,inst_11089);
var state_11178__$1 = (function (){var statearr_11180 = state_11178;
(statearr_11180[(7)] = inst_11087__$1);

return statearr_11180;
})();
if(inst_11090){
var statearr_11181_11248 = state_11178__$1;
(statearr_11181_11248[(1)] = (8));

} else {
var statearr_11182_11249 = state_11178__$1;
(statearr_11182_11249[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (20))){
var inst_11109 = (state_11178[(8)]);
var inst_11117 = (state_11178[(9)]);
var inst_11126 = inst_11117.call(null,inst_11109);
var state_11178__$1 = state_11178;
var statearr_11183_11250 = state_11178__$1;
(statearr_11183_11250[(2)] = inst_11126);

(statearr_11183_11250[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (27))){
var state_11178__$1 = state_11178;
var statearr_11184_11251 = state_11178__$1;
(statearr_11184_11251[(2)] = null);

(statearr_11184_11251[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (1))){
var state_11178__$1 = state_11178;
var statearr_11185_11252 = state_11178__$1;
(statearr_11185_11252[(2)] = null);

(statearr_11185_11252[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (24))){
var state_11178__$1 = state_11178;
var statearr_11186_11253 = state_11178__$1;
(statearr_11186_11253[(2)] = null);

(statearr_11186_11253[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (4))){
var state_11178__$1 = state_11178;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11178__$1,(7),event_chan);
} else {
if((state_val_11179 === (15))){
var inst_11087 = (state_11178[(7)]);
var state_11178__$1 = state_11178;
var statearr_11187_11254 = state_11178__$1;
(statearr_11187_11254[(2)] = inst_11087);

(statearr_11187_11254[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (21))){
var state_11178__$1 = state_11178;
var statearr_11188_11255 = state_11178__$1;
(statearr_11188_11255[(2)] = null);

(statearr_11188_11255[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (31))){
var inst_11113 = (state_11178[(10)]);
var inst_11151 = (state_11178[(2)]);
var inst_11152 = cljs.core._EQ_.call(null,inst_11113,new cljs.core.Keyword(null,"table","table",-564943036));
var state_11178__$1 = (function (){var statearr_11189 = state_11178;
(statearr_11189[(11)] = inst_11151);

return statearr_11189;
})();
if(inst_11152){
var statearr_11190_11256 = state_11178__$1;
(statearr_11190_11256[(1)] = (32));

} else {
var statearr_11191_11257 = state_11178__$1;
(statearr_11191_11257[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (32))){
var inst_11111 = (state_11178[(12)]);
var inst_11109 = (state_11178[(8)]);
var inst_11110 = (state_11178[(13)]);
var inst_11117 = (state_11178[(9)]);
var inst_11087 = (state_11178[(7)]);
var inst_11107 = (state_11178[(14)]);
var inst_11113 = (state_11178[(10)]);
var inst_11118 = (state_11178[(15)]);
var inst_11112 = (state_11178[(16)]);
var inst_11108 = (state_11178[(17)]);
var inst_11165 = cljs.core.async.chan.call(null,(1));
var inst_11166 = (function (){var new_columns = inst_11112;
var submission_clicked = inst_11109;
var submission_unclicked = inst_11110;
var get_submission_data = inst_11118;
var re_render = inst_11113;
var update_data_BANG_ = inst_11117;
var c__7694__auto____$1 = inst_11165;
var map__11085 = inst_11107;
var submission_to_rank = inst_11108;
var e = inst_11087;
var filter_by = inst_11111;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__7694__auto____$1,map__11085,submission_to_rank,e,filter_by,inst_11111,inst_11109,inst_11110,inst_11117,inst_11087,inst_11107,inst_11113,inst_11118,inst_11112,inst_11108,inst_11165,state_val_11179,c__7694__auto__,event_chan){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__7694__auto____$1,map__11085,submission_to_rank,e,filter_by,inst_11111,inst_11109,inst_11110,inst_11117,inst_11087,inst_11107,inst_11113,inst_11118,inst_11112,inst_11108,inst_11165,state_val_11179,c__7694__auto__,event_chan){
return (function (state_11163){
var state_val_11164 = (state_11163[(1)]);
if((state_val_11164 === (1))){
var inst_11154 = cljs.core.async.timeout.call(null,(20));
var state_11163__$1 = state_11163;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11163__$1,(2),inst_11154);
} else {
if((state_val_11164 === (2))){
var inst_11156 = (state_11163[(2)]);
var inst_11157 = grid.resizeCanvas();
var inst_11158 = grid.invalidateAllRows();
var inst_11159 = hatti.views.table.resizeColumns.call(null,grid);
var inst_11160 = grid.render();
var inst_11161 = hatti.views.table.init_sg_pager.call(null,grid,dataview);
var state_11163__$1 = (function (){var statearr_11192 = state_11163;
(statearr_11192[(7)] = inst_11157);

(statearr_11192[(8)] = inst_11160);

(statearr_11192[(9)] = inst_11159);

(statearr_11192[(10)] = inst_11158);

(statearr_11192[(11)] = inst_11156);

return statearr_11192;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11163__$1,inst_11161);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__7694__auto____$1,map__11085,submission_to_rank,e,filter_by,inst_11111,inst_11109,inst_11110,inst_11117,inst_11087,inst_11107,inst_11113,inst_11118,inst_11112,inst_11108,inst_11165,state_val_11179,c__7694__auto__,event_chan))
;
return ((function (switch__7673__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__7694__auto____$1,map__11085,submission_to_rank,e,filter_by,inst_11111,inst_11109,inst_11110,inst_11117,inst_11087,inst_11107,inst_11113,inst_11118,inst_11112,inst_11108,inst_11165,state_val_11179,c__7694__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__7674__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__7674__auto____0 = (function (){
var statearr_11196 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11196[(0)] = hatti$views$table$handle_table_events_$_state_machine__7674__auto__);

(statearr_11196[(1)] = (1));

return statearr_11196;
});
var hatti$views$table$handle_table_events_$_state_machine__7674__auto____1 = (function (state_11163){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_11163);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e11197){if((e11197 instanceof Object)){
var ex__7677__auto__ = e11197;
var statearr_11198_11258 = state_11163;
(statearr_11198_11258[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11163);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11197;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11259 = state_11163;
state_11163 = G__11259;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__7674__auto__ = function(state_11163){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__7674__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__7674__auto____1.call(this,state_11163);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__7674__auto____0;
hatti$views$table$handle_table_events_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__7674__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__7694__auto____$1,map__11085,submission_to_rank,e,filter_by,inst_11111,inst_11109,inst_11110,inst_11117,inst_11087,inst_11107,inst_11113,inst_11118,inst_11112,inst_11108,inst_11165,state_val_11179,c__7694__auto__,event_chan))
})();
var state__7696__auto__ = (function (){var statearr_11199 = f__7695__auto__.call(null);
(statearr_11199[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto____$1);

return statearr_11199;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__7694__auto____$1,map__11085,submission_to_rank,e,filter_by,inst_11111,inst_11109,inst_11110,inst_11117,inst_11087,inst_11107,inst_11113,inst_11118,inst_11112,inst_11108,inst_11165,state_val_11179,c__7694__auto__,event_chan))
})();
var inst_11167 = cljs.core.async.impl.dispatch.run.call(null,inst_11166);
var state_11178__$1 = (function (){var statearr_11200 = state_11178;
(statearr_11200[(18)] = inst_11167);

return statearr_11200;
})();
var statearr_11201_11260 = state_11178__$1;
(statearr_11201_11260[(2)] = inst_11165);

(statearr_11201_11260[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (33))){
var state_11178__$1 = state_11178;
var statearr_11202_11261 = state_11178__$1;
(statearr_11202_11261[(2)] = null);

(statearr_11202_11261[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (13))){
var inst_11099 = (state_11178[(2)]);
var state_11178__$1 = state_11178;
var statearr_11203_11262 = state_11178__$1;
(statearr_11203_11262[(2)] = inst_11099);

(statearr_11203_11262[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (22))){
var inst_11110 = (state_11178[(13)]);
var inst_11129 = (state_11178[(2)]);
var state_11178__$1 = (function (){var statearr_11204 = state_11178;
(statearr_11204[(19)] = inst_11129);

return statearr_11204;
})();
if(cljs.core.truth_(inst_11110)){
var statearr_11205_11263 = state_11178__$1;
(statearr_11205_11263[(1)] = (23));

} else {
var statearr_11206_11264 = state_11178__$1;
(statearr_11206_11264[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (29))){
var inst_11111 = (state_11178[(12)]);
var inst_11143 = [new cljs.core.Keyword(null,"query","query",-1288509510)];
var inst_11144 = [inst_11111];
var inst_11145 = cljs.core.PersistentHashMap.fromArrays(inst_11143,inst_11144);
var inst_11146 = cljs.core.clj__GT_js.call(null,inst_11145);
var inst_11147 = dataview.setFilterArgs(inst_11146);
var inst_11148 = dataview.refresh();
var state_11178__$1 = (function (){var statearr_11207 = state_11178;
(statearr_11207[(20)] = inst_11147);

return statearr_11207;
})();
var statearr_11208_11265 = state_11178__$1;
(statearr_11208_11265[(2)] = inst_11148);

(statearr_11208_11265[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (6))){
var inst_11174 = (state_11178[(2)]);
var state_11178__$1 = state_11178;
var statearr_11209_11266 = state_11178__$1;
(statearr_11209_11266[(2)] = inst_11174);

(statearr_11209_11266[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (28))){
var inst_11111 = (state_11178[(12)]);
var inst_11141 = (state_11178[(2)]);
var state_11178__$1 = (function (){var statearr_11210 = state_11178;
(statearr_11210[(21)] = inst_11141);

return statearr_11210;
})();
if(cljs.core.truth_(inst_11111)){
var statearr_11211_11267 = state_11178__$1;
(statearr_11211_11267[(1)] = (29));

} else {
var statearr_11212_11268 = state_11178__$1;
(statearr_11212_11268[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (25))){
var inst_11112 = (state_11178[(16)]);
var inst_11134 = (state_11178[(2)]);
var state_11178__$1 = (function (){var statearr_11213 = state_11178;
(statearr_11213[(22)] = inst_11134);

return statearr_11213;
})();
if(cljs.core.truth_(inst_11112)){
var statearr_11214_11269 = state_11178__$1;
(statearr_11214_11269[(1)] = (26));

} else {
var statearr_11215_11270 = state_11178__$1;
(statearr_11215_11270[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (34))){
var inst_11170 = (state_11178[(2)]);
var state_11178__$1 = (function (){var statearr_11216 = state_11178;
(statearr_11216[(23)] = inst_11170);

return statearr_11216;
})();
var statearr_11217_11271 = state_11178__$1;
(statearr_11217_11271[(2)] = null);

(statearr_11217_11271[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (17))){
var inst_11117 = (state_11178[(9)]);
var inst_11118 = (state_11178[(15)]);
var inst_11108 = (state_11178[(17)]);
var inst_11120 = inst_11118.call(null,hatti.constants._rank,inst_11108);
var inst_11121 = inst_11117.call(null,inst_11120);
var state_11178__$1 = state_11178;
var statearr_11218_11272 = state_11178__$1;
(statearr_11218_11272[(2)] = inst_11121);

(statearr_11218_11272[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (3))){
var inst_11176 = (state_11178[(2)]);
var state_11178__$1 = state_11178;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11178__$1,inst_11176);
} else {
if((state_val_11179 === (12))){
var state_11178__$1 = state_11178;
var statearr_11219_11273 = state_11178__$1;
(statearr_11219_11273[(2)] = false);

(statearr_11219_11273[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (2))){
var state_11178__$1 = state_11178;
var statearr_11220_11274 = state_11178__$1;
(statearr_11220_11274[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (23))){
var inst_11117 = (state_11178[(9)]);
var inst_11131 = inst_11117.call(null,null);
var state_11178__$1 = state_11178;
var statearr_11222_11275 = state_11178__$1;
(statearr_11222_11275[(2)] = inst_11131);

(statearr_11222_11275[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (19))){
var inst_11109 = (state_11178[(8)]);
var inst_11124 = (state_11178[(2)]);
var state_11178__$1 = (function (){var statearr_11223 = state_11178;
(statearr_11223[(24)] = inst_11124);

return statearr_11223;
})();
if(cljs.core.truth_(inst_11109)){
var statearr_11224_11276 = state_11178__$1;
(statearr_11224_11276[(1)] = (20));

} else {
var statearr_11225_11277 = state_11178__$1;
(statearr_11225_11277[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (11))){
var state_11178__$1 = state_11178;
var statearr_11226_11278 = state_11178__$1;
(statearr_11226_11278[(2)] = true);

(statearr_11226_11278[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (9))){
var state_11178__$1 = state_11178;
var statearr_11227_11279 = state_11178__$1;
(statearr_11227_11279[(2)] = false);

(statearr_11227_11279[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (5))){
var state_11178__$1 = state_11178;
var statearr_11228_11280 = state_11178__$1;
(statearr_11228_11280[(2)] = null);

(statearr_11228_11280[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (14))){
var inst_11087 = (state_11178[(7)]);
var inst_11104 = cljs.core.apply.call(null,cljs.core.hash_map,inst_11087);
var state_11178__$1 = state_11178;
var statearr_11229_11281 = state_11178__$1;
(statearr_11229_11281[(2)] = inst_11104);

(statearr_11229_11281[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (26))){
var inst_11112 = (state_11178[(16)]);
var inst_11136 = grid.setColumns(inst_11112);
var inst_11137 = hatti.views.table.resizeColumns.call(null,grid);
var inst_11138 = grid.render();
var state_11178__$1 = (function (){var statearr_11230 = state_11178;
(statearr_11230[(25)] = inst_11137);

(statearr_11230[(26)] = inst_11136);

return statearr_11230;
})();
var statearr_11231_11282 = state_11178__$1;
(statearr_11231_11282[(2)] = inst_11138);

(statearr_11231_11282[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (16))){
var inst_11111 = (state_11178[(12)]);
var inst_11109 = (state_11178[(8)]);
var inst_11110 = (state_11178[(13)]);
var inst_11117 = (state_11178[(9)]);
var inst_11087 = (state_11178[(7)]);
var inst_11107 = (state_11178[(14)]);
var inst_11113 = (state_11178[(10)]);
var inst_11112 = (state_11178[(16)]);
var inst_11108 = (state_11178[(17)]);
var inst_11107__$1 = (state_11178[(2)]);
var inst_11108__$1 = cljs.core.get.call(null,inst_11107__$1,new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797));
var inst_11109__$1 = cljs.core.get.call(null,inst_11107__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var inst_11110__$1 = cljs.core.get.call(null,inst_11107__$1,new cljs.core.Keyword(null,"submission-unclicked","submission-unclicked",-2099539520));
var inst_11111__$1 = cljs.core.get.call(null,inst_11107__$1,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
var inst_11112__$1 = cljs.core.get.call(null,inst_11107__$1,new cljs.core.Keyword(null,"new-columns","new-columns",-887765797));
var inst_11113__$1 = cljs.core.get.call(null,inst_11107__$1,new cljs.core.Keyword(null,"re-render","re-render",1133553258));
var inst_11114 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_11115 = [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.Keyword(null,"data","data",-232669377)];
var inst_11116 = (new cljs.core.PersistentVector(null,3,(5),inst_11114,inst_11115,null));
var inst_11117__$1 = cljs.core.partial.call(null,om.core.update_BANG_,app_state,inst_11116);
var inst_11118 = (function (){var e = inst_11087;
var map__11085 = inst_11107__$1;
var submission_to_rank = inst_11108__$1;
var submission_clicked = inst_11109__$1;
var submission_unclicked = inst_11110__$1;
var filter_by = inst_11111__$1;
var new_columns = inst_11112__$1;
var re_render = inst_11113__$1;
var update_data_BANG_ = inst_11117__$1;
return ((function (e,map__11085,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_11111,inst_11109,inst_11110,inst_11117,inst_11087,inst_11107,inst_11113,inst_11112,inst_11108,inst_11107__$1,inst_11108__$1,inst_11109__$1,inst_11110__$1,inst_11111__$1,inst_11112__$1,inst_11113__$1,inst_11114,inst_11115,inst_11116,inst_11117__$1,state_val_11179,c__7694__auto__,event_chan){
return (function (field,value){
return cljs.core.first.call(null,cljs.core.filter.call(null,((function (e,map__11085,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_11111,inst_11109,inst_11110,inst_11117,inst_11087,inst_11107,inst_11113,inst_11112,inst_11108,inst_11107__$1,inst_11108__$1,inst_11109__$1,inst_11110__$1,inst_11111__$1,inst_11112__$1,inst_11113__$1,inst_11114,inst_11115,inst_11116,inst_11117__$1,state_val_11179,c__7694__auto__,event_chan){
return (function (p1__10917_SHARP_){
return cljs.core._EQ_.call(null,value,cljs.core.get.call(null,p1__10917_SHARP_,field));
});})(e,map__11085,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_11111,inst_11109,inst_11110,inst_11117,inst_11087,inst_11107,inst_11113,inst_11112,inst_11108,inst_11107__$1,inst_11108__$1,inst_11109__$1,inst_11110__$1,inst_11111__$1,inst_11112__$1,inst_11113__$1,inst_11114,inst_11115,inst_11116,inst_11117__$1,state_val_11179,c__7694__auto__,event_chan))
,cljs.core.get_in.call(null,cljs.core.deref.call(null,app_state),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null))));
});
;})(e,map__11085,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_11111,inst_11109,inst_11110,inst_11117,inst_11087,inst_11107,inst_11113,inst_11112,inst_11108,inst_11107__$1,inst_11108__$1,inst_11109__$1,inst_11110__$1,inst_11111__$1,inst_11112__$1,inst_11113__$1,inst_11114,inst_11115,inst_11116,inst_11117__$1,state_val_11179,c__7694__auto__,event_chan))
})();
var state_11178__$1 = (function (){var statearr_11232 = state_11178;
(statearr_11232[(12)] = inst_11111__$1);

(statearr_11232[(8)] = inst_11109__$1);

(statearr_11232[(13)] = inst_11110__$1);

(statearr_11232[(9)] = inst_11117__$1);

(statearr_11232[(14)] = inst_11107__$1);

(statearr_11232[(10)] = inst_11113__$1);

(statearr_11232[(15)] = inst_11118);

(statearr_11232[(16)] = inst_11112__$1);

(statearr_11232[(17)] = inst_11108__$1);

return statearr_11232;
})();
if(cljs.core.truth_(inst_11108__$1)){
var statearr_11233_11283 = state_11178__$1;
(statearr_11233_11283[(1)] = (17));

} else {
var statearr_11234_11284 = state_11178__$1;
(statearr_11234_11284[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (30))){
var state_11178__$1 = state_11178;
var statearr_11235_11285 = state_11178__$1;
(statearr_11235_11285[(2)] = null);

(statearr_11235_11285[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (10))){
var inst_11102 = (state_11178[(2)]);
var state_11178__$1 = state_11178;
if(cljs.core.truth_(inst_11102)){
var statearr_11236_11286 = state_11178__$1;
(statearr_11236_11286[(1)] = (14));

} else {
var statearr_11237_11287 = state_11178__$1;
(statearr_11237_11287[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (18))){
var state_11178__$1 = state_11178;
var statearr_11238_11288 = state_11178__$1;
(statearr_11238_11288[(2)] = null);

(statearr_11238_11288[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11179 === (8))){
var inst_11087 = (state_11178[(7)]);
var inst_11092 = inst_11087.cljs$lang$protocol_mask$partition0$;
var inst_11093 = (inst_11092 & (64));
var inst_11094 = inst_11087.cljs$core$ISeq$;
var inst_11095 = (inst_11093) || (inst_11094);
var state_11178__$1 = state_11178;
if(cljs.core.truth_(inst_11095)){
var statearr_11239_11289 = state_11178__$1;
(statearr_11239_11289[(1)] = (11));

} else {
var statearr_11240_11290 = state_11178__$1;
(statearr_11240_11290[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7694__auto__,event_chan))
;
return ((function (switch__7673__auto__,c__7694__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__7674__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__7674__auto____0 = (function (){
var statearr_11244 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11244[(0)] = hatti$views$table$handle_table_events_$_state_machine__7674__auto__);

(statearr_11244[(1)] = (1));

return statearr_11244;
});
var hatti$views$table$handle_table_events_$_state_machine__7674__auto____1 = (function (state_11178){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_11178);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e11245){if((e11245 instanceof Object)){
var ex__7677__auto__ = e11245;
var statearr_11246_11291 = state_11178;
(statearr_11246_11291[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11178);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11245;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11292 = state_11178;
state_11178 = G__11292;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__7674__auto__ = function(state_11178){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__7674__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__7674__auto____1.call(this,state_11178);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__7674__auto____0;
hatti$views$table$handle_table_events_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__7674__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto__,event_chan))
})();
var state__7696__auto__ = (function (){var statearr_11247 = f__7695__auto__.call(null);
(statearr_11247[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto__);

return statearr_11247;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto__,event_chan))
);

return c__7694__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208),k);

return colset_BANG_.call(null,k);
});
var iter__5341__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__11301(s__11302){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__11302__$1 = s__11302;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__11302__$1);
if(temp__4425__auto__){
var s__11302__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11302__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__11302__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__11304 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__11303 = (0);
while(true){
if((i__11303 < size__5340__auto__)){
var vec__11307 = cljs.core._nth.call(null,c__5339__auto__,i__11303);
var k = cljs.core.nth.call(null,vec__11307,(0),null);
var v = cljs.core.nth.call(null,vec__11307,(1),null);
cljs.core.chunk_append.call(null,b__11304,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (i__11303,vec__11307,k,v,c__5339__auto__,size__5340__auto__,b__11304,s__11302__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(i__11303,vec__11307,k,v,c__5339__auto__,size__5340__auto__,b__11304,s__11302__$2,temp__4425__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null));

var G__11309 = (i__11303 + (1));
i__11303 = G__11309;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11304),hatti$views$table$render_options_$_iter__11301.call(null,cljs.core.chunk_rest.call(null,s__11302__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11304),null);
}
} else {
var vec__11308 = cljs.core.first.call(null,s__11302__$2);
var k = cljs.core.nth.call(null,vec__11308,(0),null);
var v = cljs.core.nth.call(null,vec__11308,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (vec__11308,k,v,s__11302__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(vec__11308,k,v,s__11302__$2,temp__4425__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__11301.call(null,cljs.core.rest.call(null,s__11302__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__5341__auto__.call(null,options);
});
cljs.core._add_method.call(null,hatti.views.label_changer,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table11311 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table11311 = (function (_,owner,meta11312){
this._ = _;
this.owner = owner;
this.meta11312 = meta11312;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table11311.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11313,meta11312__$1){
var self__ = this;
var _11313__$1 = this;
return (new hatti.views.table.t_hatti$views$table11311(self__._,self__.owner,meta11312__$1));
});

hatti.views.table.t_hatti$views$table11311.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11313){
var self__ = this;
var _11313__$1 = this;
return self__.meta11312;
});

hatti.views.table.t_hatti$views$table11311.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table11311.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208),new cljs.core.Keyword(null,"label","label",1718410804)], null);
});

hatti.views.table.t_hatti$views$table11311.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table11311.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__11314){
var self__ = this;
var map__11315 = p__11314;
var map__11315__$1 = ((((!((map__11315 == null)))?((((map__11315.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11315.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11315):map__11315);
var name_or_label = cljs.core.get.call(null,map__11315__$1,new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208));
var language = cljs.core.get.call(null,map__11315__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Label"], null),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Name"], null)], null);
var map__11317 = om.core.get_shared.call(null,self__.owner);
var map__11317__$1 = ((((!((map__11317 == null)))?((((map__11317.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11317.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11317):map__11317);
var flat_form = cljs.core.get.call(null,map__11317__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var new_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,self__.owner,hatti.shared.language_cursor.call(null)));
var colset_BANG_ = ((function (options,map__11317,map__11317__$1,flat_form,new_language,___$2,map__11315,map__11315__$1,name_or_label,language){
return (function (p1__11310_SHARP_){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"new-columns","new-columns",-887765797),hatti.views.table.flat_form__GT_sg_columns.call(null,flat_form,cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"label","label",1718410804),p1__11310_SHARP_),new_language)], null));
});})(options,map__11317,map__11317__$1,flat_form,new_language,___$2,map__11315,map__11315__$1,name_or_label,language))
;
if(cljs.core.not_EQ_.call(null,new_language,language)){
om.core.set_state_BANG_.call(null,self__.owner,new cljs.core.Keyword(null,"language","language",-1591107564),new_language);

colset_BANG_.call(null,name_or_label);
} else {
}

return React.DOM.div({"className": "label-changer"},React.DOM.span({"className": "label-changer-label"},"Show:"),React.DOM.div({"id": "header-display-dropdown", "className": "drop-hover"},(function (){var attrs11321 = options.call(null,name_or_label);
return cljs.core.apply.call(null,React.DOM.span,((cljs.core.map_QMARK_.call(null,attrs11321))?sablono.interpreter.attributes.call(null,attrs11321):null),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs11321))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [React.DOM.i({"className": "fa fa-angle-down"})], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs11321),React.DOM.i({"className": "fa fa-angle-down"})], null))));
})(),React.DOM.ul({"className": "submenu no-dot"},sablono.interpreter.interpret.call(null,hatti.views.table.render_options.call(null,options,self__.owner,colset_BANG_)))));
});

hatti.views.table.t_hatti$views$table11311.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta11312","meta11312",1828105669,null)], null);
});

hatti.views.table.t_hatti$views$table11311.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table11311.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table11311";

hatti.views.table.t_hatti$views$table11311.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"hatti.views.table/t_hatti$views$table11311");
});

hatti.views.table.__GT_t_hatti$views$table11311 = (function hatti$views$table$__GT_t_hatti$views$table11311(___$1,owner__$1,meta11312){
return (new hatti.views.table.t_hatti$views$table11311(___$1,owner__$1,meta11312));
});

}

return (new hatti.views.table.t_hatti$views$table11311(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__7694__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7694__auto__,query){
return (function (){
var f__7695__auto__ = (function (){var switch__7673__auto__ = ((function (c__7694__auto__,query){
return (function (state_11368){
var state_val_11369 = (state_11368[(1)]);
if((state_val_11369 === (1))){
var inst_11354 = cljs.core.async.timeout.call(null,(150));
var state_11368__$1 = state_11368;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11368__$1,(2),inst_11354);
} else {
if((state_val_11369 === (2))){
var inst_11356 = (state_11368[(2)]);
var inst_11357 = input.value;
var inst_11358 = cljs.core._EQ_.call(null,query,inst_11357);
var state_11368__$1 = (function (){var statearr_11370 = state_11368;
(statearr_11370[(7)] = inst_11356);

return statearr_11370;
})();
if(inst_11358){
var statearr_11371_11382 = state_11368__$1;
(statearr_11371_11382[(1)] = (3));

} else {
var statearr_11372_11383 = state_11368__$1;
(statearr_11372_11383[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11369 === (3))){
var inst_11360 = [query_event_key];
var inst_11361 = [query];
var inst_11362 = cljs.core.PersistentHashMap.fromArrays(inst_11360,inst_11361);
var inst_11363 = cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,inst_11362);
var state_11368__$1 = state_11368;
var statearr_11373_11384 = state_11368__$1;
(statearr_11373_11384[(2)] = inst_11363);

(statearr_11373_11384[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11369 === (4))){
var state_11368__$1 = state_11368;
var statearr_11374_11385 = state_11368__$1;
(statearr_11374_11385[(2)] = null);

(statearr_11374_11385[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11369 === (5))){
var inst_11366 = (state_11368[(2)]);
var state_11368__$1 = state_11368;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11368__$1,inst_11366);
} else {
return null;
}
}
}
}
}
});})(c__7694__auto__,query))
;
return ((function (switch__7673__auto__,c__7694__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__7674__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__7674__auto____0 = (function (){
var statearr_11378 = [null,null,null,null,null,null,null,null];
(statearr_11378[(0)] = hatti$views$table$delayed_search_$_state_machine__7674__auto__);

(statearr_11378[(1)] = (1));

return statearr_11378;
});
var hatti$views$table$delayed_search_$_state_machine__7674__auto____1 = (function (state_11368){
while(true){
var ret_value__7675__auto__ = (function (){try{while(true){
var result__7676__auto__ = switch__7673__auto__.call(null,state_11368);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7676__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7676__auto__;
}
break;
}
}catch (e11379){if((e11379 instanceof Object)){
var ex__7677__auto__ = e11379;
var statearr_11380_11386 = state_11368;
(statearr_11380_11386[(5)] = ex__7677__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11368);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11379;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7675__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11387 = state_11368;
state_11368 = G__11387;
continue;
} else {
return ret_value__7675__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__7674__auto__ = function(state_11368){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__7674__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__7674__auto____1.call(this,state_11368);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__7674__auto____0;
hatti$views$table$delayed_search_$_state_machine__7674__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__7674__auto____1;
return hatti$views$table$delayed_search_$_state_machine__7674__auto__;
})()
;})(switch__7673__auto__,c__7694__auto__,query))
})();
var state__7696__auto__ = (function (){var statearr_11381 = f__7695__auto__.call(null);
(statearr_11381[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7694__auto__);

return statearr_11381;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7696__auto__);
});})(c__7694__auto__,query))
);

return c__7694__auto__;
});
cljs.core._add_method.call(null,hatti.views.table_search,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table11389 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table11389 = (function (_,owner,meta11390){
this._ = _;
this.owner = owner;
this.meta11390 = meta11390;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table11389.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11391,meta11390__$1){
var self__ = this;
var _11391__$1 = this;
return (new hatti.views.table.t_hatti$views$table11389(self__._,self__.owner,meta11390__$1));
});

hatti.views.table.t_hatti$views$table11389.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11391){
var self__ = this;
var _11391__$1 = this;
return self__.meta11390;
});

hatti.views.table.t_hatti$views$table11389.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table11389.prototype.om$core$IRender$render$arity$1 = (function (this__6323__auto__){
var self__ = this;
var this__6323__auto____$1 = this;
return React.DOM.div({"className": "table-search"},React.DOM.i({"className": "fa fa-search"}),sablono.interpreter.input.call(null,{"type": "text", "placeholder": "Search", "onChange": ((function (this__6323__auto____$1){
return (function (p1__11388_SHARP_){
return hatti.views.table.delayed_search.call(null,p1__11388_SHARP_.target,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
});})(this__6323__auto____$1))
}));
});

hatti.views.table.t_hatti$views$table11389.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta11390","meta11390",1936034016,null)], null);
});

hatti.views.table.t_hatti$views$table11389.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table11389.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table11389";

hatti.views.table.t_hatti$views$table11389.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"hatti.views.table/t_hatti$views$table11389");
});

hatti.views.table.__GT_t_hatti$views$table11389 = (function hatti$views$table$__GT_t_hatti$views$table11389(___$1,owner__$1,meta11390){
return (new hatti.views.table.t_hatti$views$table11389(___$1,owner__$1,meta11390));
});

}

return (new hatti.views.table.t_hatti$views$table11389(_,owner,null));
}));
cljs.core._add_method.call(null,hatti.views.table_header,new cljs.core.Keyword(null,"default","default",-1987822328),(function (app_state,owner){
if(typeof hatti.views.table.t_hatti$views$table11394 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table11394 = (function (app_state,owner,meta11395){
this.app_state = app_state;
this.owner = owner;
this.meta11395 = meta11395;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table11394.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11396,meta11395__$1){
var self__ = this;
var _11396__$1 = this;
return (new hatti.views.table.t_hatti$views$table11394(self__.app_state,self__.owner,meta11395__$1));
});

hatti.views.table.t_hatti$views$table11394.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11396){
var self__ = this;
var _11396__$1 = this;
return self__.meta11395;
});

hatti.views.table.t_hatti$views$table11394.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table11394.prototype.om$core$IRender$render$arity$1 = (function (this__6323__auto__){
var self__ = this;
var this__6323__auto____$1 = this;
return React.DOM.div({"className": "topbar"},React.DOM.div({"id": hatti.views.table.pager_id}),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.label_changer,null)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_search,self__.app_state)),React.DOM.div({"style": {"clear": "both"}}));
});

hatti.views.table.t_hatti$views$table11394.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"app-state","app-state",130568249,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta11395","meta11395",1085403801,null)], null);
});

hatti.views.table.t_hatti$views$table11394.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table11394.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table11394";

hatti.views.table.t_hatti$views$table11394.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"hatti.views.table/t_hatti$views$table11394");
});

hatti.views.table.__GT_t_hatti$views$table11394 = (function hatti$views$table$__GT_t_hatti$views$table11394(app_state__$1,owner__$1,meta11395){
return (new hatti.views.table.t_hatti$views$table11394(app_state__$1,owner__$1,meta11395));
});

}

return (new hatti.views.table.t_hatti$views$table11394(app_state,owner,null));
}));
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){

if(cljs.core.seq.call(null,data)){
var map__11402 = om.core.get_shared.call(null,owner);
var map__11402__$1 = ((((!((map__11402 == null)))?((((map__11402.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11402.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11402):map__11402);
var flat_form = cljs.core.get.call(null,map__11402__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__11402__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
var current_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,owner,hatti.shared.language_cursor.call(null)));
var vec__11403 = hatti.views.table.sg_init.call(null,data,flat_form,current_language,is_filtered_dataview_QMARK_,slick_grid_event_handlers);
var grid = cljs.core.nth.call(null,vec__11403,(0),null);
var dataview = cljs.core.nth.call(null,vec__11403,(1),null);
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"grid","grid",402978600),grid);

om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"dataview","dataview",91765671),dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
cljs.core._add_method.call(null,hatti.views.table_page,new cljs.core.Keyword(null,"default","default",-1987822328),(function (app_state,owner,p__11406){
var map__11407 = p__11406;
var map__11407__$1 = ((((!((map__11407 == null)))?((((map__11407.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11407.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11407):map__11407);
var opts = map__11407__$1;
var slick_grid_event_handlers = cljs.core.get.call(null,map__11407__$1,new cljs.core.Keyword(null,"slick-grid-event-handlers","slick-grid-event-handlers",1990034724));

if(typeof hatti.views.table.t_hatti$views$table11409 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table11409 = (function (app_state,owner,p__11406,map__11407,opts,slick_grid_event_handlers,meta11410){
this.app_state = app_state;
this.owner = owner;
this.p__11406 = p__11406;
this.map__11407 = map__11407;
this.opts = opts;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.meta11410 = meta11410;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table11409.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__11407,map__11407__$1,opts,slick_grid_event_handlers){
return (function (_11411,meta11410__$1){
var self__ = this;
var _11411__$1 = this;
return (new hatti.views.table.t_hatti$views$table11409(self__.app_state,self__.owner,self__.p__11406,self__.map__11407,self__.opts,self__.slick_grid_event_handlers,meta11410__$1));
});})(map__11407,map__11407__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table11409.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__11407,map__11407__$1,opts,slick_grid_event_handlers){
return (function (_11411){
var self__ = this;
var _11411__$1 = this;
return self__.meta11410;
});})(map__11407,map__11407__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table11409.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table11409.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__11407,map__11407__$1,opts,slick_grid_event_handlers){
return (function (_,___$1){
var self__ = this;
var ___$2 = this;
var no_data_QMARK_ = cljs.core.empty_QMARK_.call(null,cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null)));
var map__11412 = new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(self__.app_state);
var map__11412__$1 = ((((!((map__11412 == null)))?((((map__11412.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11412.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11412):map__11412);
var dataset_info = map__11412__$1;
var num_of_submissions = cljs.core.get.call(null,map__11412__$1,new cljs.core.Keyword(null,"num_of_submissions","num_of_submissions",-1720943091));
var with_info = ((function (no_data_QMARK_,map__11412,map__11412__$1,dataset_info,num_of_submissions,___$2,map__11407,map__11407__$1,opts,slick_grid_event_handlers){
return (function (p1__11405_SHARP_){
return cljs.core.merge.call(null,p1__11405_SHARP_,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563),dataset_info], null));
});})(no_data_QMARK_,map__11412,map__11412__$1,dataset_info,num_of_submissions,___$2,map__11407,map__11407__$1,opts,slick_grid_event_handlers))
;
var attrs11414 = om.core.build.call(null,hatti.views.submission_view,with_info.call(null,cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855)], null))),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge.call(null,cljs.core.select_keys.call(null,self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"role","role",-736691072),null,new cljs.core.Keyword(null,"delete-record!","delete-record!",1411848194),null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"table","table",-564943036)], null))], null));
return cljs.core.apply.call(null,React.DOM.div,((cljs.core.map_QMARK_.call(null,attrs11414))?sablono.interpreter.attributes.call(null,sablono.util.merge_with_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["table-view"], null)], null),attrs11414)):{"className": "table-view"}),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs11414))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.app_state)),React.DOM.div({"id": hatti.views.table.table_id, "className": "slickgrid"},(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.span({"className": "empty-state"},"No data"):React.DOM.span(null,React.DOM.i({"className": "fa fa-spinner fa-pulse"}),"Loading...")))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs11414),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.app_state)),React.DOM.div({"id": hatti.views.table.table_id, "className": "slickgrid"},(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.span({"className": "empty-state"},"No data"):React.DOM.span(null,React.DOM.i({"className": "fa fa-spinner fa-pulse"}),"Loading...")))], null))));
});})(map__11407,map__11407__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table11409.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table11409.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (map__11407,map__11407__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
var data = cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_.call(null,data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__11423 = temp__4425__auto__;
var grid = cljs.core.nth.call(null,vec__11423,(0),null);
var dataview = cljs.core.nth.call(null,vec__11423,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.app_state,grid,dataview);
} else {
return null;
}
});})(map__11407,map__11407__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table11409.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table11409.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (map__11407,map__11407__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

var old_data = cljs.core.get_in.call(null,om.core.get_props.call(null,self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var new_data = cljs.core.get_in.call(null,next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var map__11424 = om.core.get_state.call(null,self__.owner);
var map__11424__$1 = ((((!((map__11424 == null)))?((((map__11424.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11424.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11424):map__11424);
var grid = cljs.core.get.call(null,map__11424__$1,new cljs.core.Keyword(null,"grid","grid",402978600));
var dataview = cljs.core.get.call(null,map__11424__$1,new cljs.core.Keyword(null,"dataview","dataview",91765671));
if(cljs.core.not_EQ_.call(null,old_data,new_data)){
if(cljs.core.empty_QMARK_.call(null,old_data)){
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_.call(null,new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__11426 = temp__4425__auto__;
var grid__$1 = cljs.core.nth.call(null,vec__11426,(0),null);
var dataview__$1 = cljs.core.nth.call(null,vec__11426,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.app_state,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js.call(null,new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
});})(map__11407,map__11407__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table11409.getBasis = ((function (map__11407,map__11407__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"app-state","app-state",130568249,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__11406","p__11406",-1514088523,null),new cljs.core.Symbol(null,"map__11407","map__11407",907796352,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"slick-grid-event-handlers","slick-grid-event-handlers",-664401045,null),new cljs.core.Symbol(null,"meta11410","meta11410",-389748368,null)], null);
});})(map__11407,map__11407__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table11409.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table11409.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table11409";

hatti.views.table.t_hatti$views$table11409.cljs$lang$ctorPrWriter = ((function (map__11407,map__11407__$1,opts,slick_grid_event_handlers){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"hatti.views.table/t_hatti$views$table11409");
});})(map__11407,map__11407__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table11409 = ((function (map__11407,map__11407__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table11409(app_state__$1,owner__$1,p__11406__$1,map__11407__$2,opts__$1,slick_grid_event_handlers__$1,meta11410){
return (new hatti.views.table.t_hatti$views$table11409(app_state__$1,owner__$1,p__11406__$1,map__11407__$2,opts__$1,slick_grid_event_handlers__$1,meta11410));
});})(map__11407,map__11407__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table11409(app_state,owner,p__11406,map__11407__$1,opts,slick_grid_event_handlers,cljs.core.PersistentArrayMap.EMPTY));
}));
