// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('c2.svg');
goog.require('cljs.core');
goog.require('c2.core');
goog.require('c2.maths');
goog.require('c2.dom');
/**
 * Ensure that coordinates (potentially map of `{:x :y}`) are a seq or vector pair.
 */
c2.svg.__GT_xy = (function c2$svg$__GT_xy(coordinates){
if((cljs.core.sequential_QMARK_(coordinates)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),cljs.core.count(coordinates)))){
return coordinates;
} else {
if(cljs.core.map_QMARK_(coordinates)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$x.cljs$core$IFn$_invoke$arity$1(coordinates),cljs.core.cst$kw$y.cljs$core$IFn$_invoke$arity$1(coordinates)], null);
} else {
return null;
}
}
});
c2.svg.translate = (function c2$svg$translate(coordinates){
var vec__42187 = c2.svg.__GT_xy(coordinates);
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42187,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42187,(1),null);
return [cljs.core.str("translate("),cljs.core.str(x),cljs.core.str(","),cljs.core.str(y),cljs.core.str(")")].join('');
});
c2.svg.scale = (function c2$svg$scale(coordinates){
if(typeof coordinates === 'number'){
return [cljs.core.str("scale("),cljs.core.str(coordinates),cljs.core.str(")")].join('');
} else {
var vec__42189 = c2.svg.__GT_xy(coordinates);
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42189,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42189,(1),null);
return [cljs.core.str("scale("),cljs.core.str(x),cljs.core.str(","),cljs.core.str(y),cljs.core.str(")")].join('');
}
});
c2.svg.rotate = (function c2$svg$rotate(var_args){
var args42190 = [];
var len__5627__auto___42194 = arguments.length;
var i__5628__auto___42195 = (0);
while(true){
if((i__5628__auto___42195 < len__5627__auto___42194)){
args42190.push((arguments[i__5628__auto___42195]));

var G__42196 = (i__5628__auto___42195 + (1));
i__5628__auto___42195 = G__42196;
continue;
} else {
}
break;
}

var G__42192 = args42190.length;
switch (G__42192) {
case 1:
return c2.svg.rotate.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.svg.rotate.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42190.length)].join('')));

}
});

c2.svg.rotate.cljs$core$IFn$_invoke$arity$1 = (function (angle){
return c2.svg.rotate.cljs$core$IFn$_invoke$arity$2(angle,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null));
});

c2.svg.rotate.cljs$core$IFn$_invoke$arity$2 = (function (angle,coordinates){
var vec__42193 = c2.svg.__GT_xy(coordinates);
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42193,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42193,(1),null);
return [cljs.core.str("rotate("),cljs.core.str(angle),cljs.core.str(","),cljs.core.str(x),cljs.core.str(","),cljs.core.str(y),cljs.core.str(")")].join('');
});

c2.svg.rotate.cljs$lang$maxFixedArity = 2;
/**
 * Returns map of `{:x :y :width :height}` containing SVG element bounding box.
 * All coordinates are in userspace. Ref [SVG spec](http://www.w3.org/TR/SVG/types.html#InterfaceSVGLocatable)
 */
c2.svg.get_bounds = (function c2$svg$get_bounds($svg_el){
var b = $svg_el.getBBox();
return new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$x,b.x,cljs.core.cst$kw$y,b.y,cljs.core.cst$kw$width,b.width,cljs.core.cst$kw$height,b.height], null);
});
/**
 * Returns a transform string that will scale and center provided element `{:width :height :x :y}` within container `{:width :height}`.
 */
c2.svg.transform_to_center = (function c2$svg$transform_to_center(element,container){
var map__42202 = element;
var map__42202__$1 = ((((!((map__42202 == null)))?((((map__42202.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42202.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42202):map__42202);
var ew = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42202__$1,cljs.core.cst$kw$width);
var eh = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42202__$1,cljs.core.cst$kw$height);
var x = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42202__$1,cljs.core.cst$kw$x);
var y = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42202__$1,cljs.core.cst$kw$y);
var map__42203 = container;
var map__42203__$1 = ((((!((map__42203 == null)))?((((map__42203.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42203.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42203):map__42203);
var w = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42203__$1,cljs.core.cst$kw$width);
var h = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42203__$1,cljs.core.cst$kw$height);
var s = (function (){var x__4907__auto__ = (h / eh);
var y__4908__auto__ = (w / ew);
return ((x__4907__auto__ < y__4908__auto__) ? x__4907__auto__ : y__4908__auto__);
})();
return [cljs.core.str(c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((w / (2)) - (s * (ew / (2)))),((h / (2)) - (s * (eh / (2))))], null))),cljs.core.str(" "),cljs.core.str(c2.svg.scale(s)),cljs.core.str(" "),cljs.core.str(c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(- x),(- y)], null)))].join('');
});
/**
 * Scales and centers `$svg-el` within its parent SVG container.
 * Uses parent's width and height attributes only.
 */
c2.svg.transform_to_center_BANG_ = (function c2$svg$transform_to_center_BANG_($svg_el){
var $svg = $svg_el.ownerSVGElement;
var t = c2.svg.transform_to_center(c2.svg.get_bounds($svg_el),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$width,(function (){var G__42208 = c2.dom.attr.cljs$core$IFn$_invoke$arity$2($svg,cljs.core.cst$kw$width);
return parseFloat(G__42208);
})(),cljs.core.cst$kw$height,(function (){var G__42209 = c2.dom.attr.cljs$core$IFn$_invoke$arity$2($svg,cljs.core.cst$kw$height);
return parseFloat(G__42209);
})()], null));
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3($svg_el,cljs.core.cst$kw$transform,t);
});
/**
 * Returns axis <g> hiccup vector for provided input `scale` and collection of `ticks` (numbers).
 * Direction away from the data frame is defined to be positive; use negative margins and widths to render axis inside of data frame.
 * 
 * Kwargs:
 * 
 * > *:orientation* &in; (`:top`, `:bottom`, `:left`, `:right`), where the axis should be relative to the data frame, defaults to `:left`
 * 
 * > *:formatter* fn run on tick values, defaults to `str`
 * 
 * > *:major-tick-width* width of ticks (minor ticks not yet implemented), defaults to 6
 * 
 * > *:text-margin* distance between axis and start of text, defaults to 9
 * 
 * > *:label* axis label, centered on axis; :left and :right orientation labels are rotated by +/- pi/2, respectively
 * 
 * > *:label-margin* distance between axis and label, defaults to 28
 */
c2.svg.axis = (function c2$svg$axis(var_args){
var args__5634__auto__ = [];
var len__5627__auto___42222 = arguments.length;
var i__5628__auto___42223 = (0);
while(true){
if((i__5628__auto___42223 < len__5627__auto___42222)){
args__5634__auto__.push((arguments[i__5628__auto___42223]));

var G__42224 = (i__5628__auto___42223 + (1));
i__5628__auto___42223 = G__42224;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return c2.svg.axis.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

c2.svg.axis.cljs$core$IFn$_invoke$arity$variadic = (function (scale,ticks,p__42213){
var map__42214 = p__42213;
var map__42214__$1 = ((((!((map__42214 == null)))?((((map__42214.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42214.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42214):map__42214);
var orientation = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__42214__$1,cljs.core.cst$kw$orientation,cljs.core.cst$kw$left);
var formatter = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__42214__$1,cljs.core.cst$kw$formatter,cljs.core.str);
var major_tick_width = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__42214__$1,cljs.core.cst$kw$major_DASH_tick_DASH_width,(6));
var text_margin = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__42214__$1,cljs.core.cst$kw$text_DASH_margin,(9));
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42214__$1,cljs.core.cst$kw$label);
var label_margin = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__42214__$1,cljs.core.cst$kw$label_DASH_margin,(28));
var vec__42216 = (function (){var G__42217 = (((orientation instanceof cljs.core.Keyword))?orientation.fqn:null);
switch (G__42217) {
case "left":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$x,cljs.core.cst$kw$y,cljs.core.cst$kw$x1,cljs.core.cst$kw$x2,cljs.core.cst$kw$y1,cljs.core.cst$kw$y2], null);

break;
case "right":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$x,cljs.core.cst$kw$y,cljs.core.cst$kw$x1,cljs.core.cst$kw$x2,cljs.core.cst$kw$y1,cljs.core.cst$kw$y2], null);

break;
case "top":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$y,cljs.core.cst$kw$x,cljs.core.cst$kw$y1,cljs.core.cst$kw$y2,cljs.core.cst$kw$x1,cljs.core.cst$kw$x2], null);

break;
case "bottom":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$y,cljs.core.cst$kw$x,cljs.core.cst$kw$y1,cljs.core.cst$kw$y2,cljs.core.cst$kw$x1,cljs.core.cst$kw$x2], null);

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(orientation)].join('')));

}
})();
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42216,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42216,(1),null);
var x1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42216,(2),null);
var x2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42216,(3),null);
var y1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42216,(4),null);
var y2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42216,(5),null);
var parity = (function (){var G__42218 = (((orientation instanceof cljs.core.Keyword))?orientation.fqn:null);
switch (G__42218) {
case "left":
return (-1);

break;
case "top":
return (-1);

break;
case "right":
return (1);

break;
case "bottom":
return (1);

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(orientation)].join('')));

}
})();
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,[cljs.core.str("axis "),cljs.core.str(cljs.core.name(orientation))].join('')], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$line$rule,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [y1,y2], null),cljs.core.cst$kw$range.cljs$core$IFn$_invoke$arity$1(scale)))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$ticks,c2.core.unify(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,ticks,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(scale)),((function (vec__42216,x,y,x1,x2,y1,y2,parity,map__42214,map__42214__$1,orientation,formatter,major_tick_width,text_margin,label,label_margin){
return (function (p__42219){
var vec__42220 = p__42219;
var d = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42220,(0),null);
var scale__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42220,(1),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$tick$major_DASH_tick,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(cljs.core.PersistentArrayMap.fromArray([x,(0),y,(scale__$1.cljs$core$IFn$_invoke$arity$1 ? scale__$1.cljs$core$IFn$_invoke$arity$1(d) : scale__$1.call(null,d))], true, false))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$text,cljs.core.PersistentArrayMap.fromArray([x,(parity * text_margin)], true, false),(formatter.cljs$core$IFn$_invoke$arity$1 ? formatter.cljs$core$IFn$_invoke$arity$1(d) : formatter.call(null,d))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$line,cljs.core.PersistentArrayMap.fromArray([x1,(0),x2,(parity * major_tick_width)], true, false)], null)], null);
});})(vec__42216,x,y,x1,x2,y1,y2,parity,map__42214,map__42214__$1,orientation,formatter,major_tick_width,text_margin,label,label_margin))
)], null),(cljs.core.truth_(label)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$text$label,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,[cljs.core.str(c2.svg.translate(cljs.core.PersistentArrayMap.fromArray([x,(parity * label_margin),y,c2.maths.mean(cljs.core.cst$kw$range.cljs$core$IFn$_invoke$arity$1(scale))], true, false))),cljs.core.str(" "),cljs.core.str((function (){var G__42221 = (((orientation instanceof cljs.core.Keyword))?orientation.fqn:null);
switch (G__42221) {
case "left":
return c2.svg.rotate.cljs$core$IFn$_invoke$arity$1((-90));

break;
case "right":
return c2.svg.rotate.cljs$core$IFn$_invoke$arity$1((90));

break;
default:
return "";

}
})())].join('')], null),label], null):null)], null);
});

c2.svg.axis.cljs$lang$maxFixedArity = (2);

c2.svg.axis.cljs$lang$applyTo = (function (seq42210){
var G__42211 = cljs.core.first(seq42210);
var seq42210__$1 = cljs.core.next(seq42210);
var G__42212 = cljs.core.first(seq42210__$1);
var seq42210__$2 = cljs.core.next(seq42210__$1);
return c2.svg.axis.cljs$core$IFn$_invoke$arity$variadic(G__42211,G__42212,seq42210__$2);
});
c2.svg.ArcMax = (c2.maths.Tau - 1.0E-7);
/**
 * Calculate SVG path data for a circle of `radius` starting at 3 o'clock and sweeping in positive y.
 */
c2.svg.circle = (function c2$svg$circle(var_args){
var args42228 = [];
var len__5627__auto___42232 = arguments.length;
var i__5628__auto___42233 = (0);
while(true){
if((i__5628__auto___42233 < len__5627__auto___42232)){
args42228.push((arguments[i__5628__auto___42233]));

var G__42234 = (i__5628__auto___42233 + (1));
i__5628__auto___42233 = G__42234;
continue;
} else {
}
break;
}

var G__42230 = args42228.length;
switch (G__42230) {
case 1:
return c2.svg.circle.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.svg.circle.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42228.length)].join('')));

}
});

c2.svg.circle.cljs$core$IFn$_invoke$arity$1 = (function (radius){
return c2.svg.circle.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),radius);
});

c2.svg.circle.cljs$core$IFn$_invoke$arity$2 = (function (coordinates,radius){
var vec__42231 = c2.svg.__GT_xy(coordinates);
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42231,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42231,(1),null);
return [cljs.core.str("M"),cljs.core.str((x + radius)),cljs.core.str(","),cljs.core.str(y),cljs.core.str("A"),cljs.core.str((x + radius)),cljs.core.str(","),cljs.core.str((y + radius)),cljs.core.str(" 0 1,1"),cljs.core.str((- (x + radius))),cljs.core.str(","),cljs.core.str(y),cljs.core.str("A"),cljs.core.str((x + radius)),cljs.core.str(","),cljs.core.str((y + radius)),cljs.core.str(" 0 1,1"),cljs.core.str((x + radius)),cljs.core.str(","),cljs.core.str(y)].join('');
});

c2.svg.circle.cljs$lang$maxFixedArity = 2;
/**
 * Calculate SVG path data for an arc.
 */
c2.svg.arc = (function c2$svg$arc(var_args){
var args__5634__auto__ = [];
var len__5627__auto___42241 = arguments.length;
var i__5628__auto___42242 = (0);
while(true){
if((i__5628__auto___42242 < len__5627__auto___42241)){
args__5634__auto__.push((arguments[i__5628__auto___42242]));

var G__42243 = (i__5628__auto___42242 + (1));
i__5628__auto___42242 = G__42243;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return c2.svg.arc.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

c2.svg.arc.cljs$core$IFn$_invoke$arity$variadic = (function (p__42237){
var map__42238 = p__42237;
var map__42238__$1 = ((((!((map__42238 == null)))?((((map__42238.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42238.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42238):map__42238);
var inner_radius = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__42238__$1,cljs.core.cst$kw$inner_DASH_radius,(0));
var outer_radius = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__42238__$1,cljs.core.cst$kw$outer_DASH_radius,(1));
var start_angle = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__42238__$1,cljs.core.cst$kw$start_DASH_angle,(0));
var end_angle = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__42238__$1,cljs.core.cst$kw$end_DASH_angle,c2.maths.Pi);
var angle_offset = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__42238__$1,cljs.core.cst$kw$angle_DASH_offset,(0));
var r0 = inner_radius;
var r1 = outer_radius;
var vec__42240 = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(angle_offset + start_angle),(angle_offset + end_angle)], null));
var a0 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42240,(0),null);
var a1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42240,(1),null);
var da = (a1 - a0);
var large_arc_flag = (((da < c2.maths.Pi))?"0":"1");
var s0 = c2.maths.sin(a0);
var c0 = c2.maths.cos(a0);
var s1 = c2.maths.sin(a1);
var c1 = c2.maths.cos(a1);
if((da >= c2.svg.ArcMax)){
return [cljs.core.str("M0,"),cljs.core.str(r1),cljs.core.str("A"),cljs.core.str(r1),cljs.core.str(","),cljs.core.str(r1),cljs.core.str(" 0 1,1 0,"),cljs.core.str((- r1)),cljs.core.str("A"),cljs.core.str(r1),cljs.core.str(","),cljs.core.str(r1),cljs.core.str(" 0 1,1 0,"),cljs.core.str(r1),cljs.core.str(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),r0))?[cljs.core.str("M0,"),cljs.core.str(r0),cljs.core.str("A"),cljs.core.str(r0),cljs.core.str(","),cljs.core.str(r0),cljs.core.str(" 0 1,0 0,"),cljs.core.str((- r0)),cljs.core.str("A"),cljs.core.str(r0),cljs.core.str(","),cljs.core.str(r0),cljs.core.str(" 0 1,0 0,"),cljs.core.str(r0)].join(''):null)),cljs.core.str("Z")].join('');
} else {
return [cljs.core.str("M"),cljs.core.str((r1 * c0)),cljs.core.str(","),cljs.core.str((r1 * s0)),cljs.core.str("A"),cljs.core.str(r1),cljs.core.str(","),cljs.core.str(r1),cljs.core.str(" 0 "),cljs.core.str(large_arc_flag),cljs.core.str(",1 "),cljs.core.str((r1 * c1)),cljs.core.str(","),cljs.core.str((r1 * s1)),cljs.core.str(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),r0))?[cljs.core.str("L"),cljs.core.str((r0 * c1)),cljs.core.str(","),cljs.core.str((r0 * s1)),cljs.core.str("A"),cljs.core.str(r0),cljs.core.str(","),cljs.core.str(r0),cljs.core.str(" 0 "),cljs.core.str(large_arc_flag),cljs.core.str(",0 "),cljs.core.str((r0 * c0)),cljs.core.str(","),cljs.core.str((r0 * s0))].join(''):"L0,0")),cljs.core.str("Z")].join('');
}
});

c2.svg.arc.cljs$lang$maxFixedArity = (0);

c2.svg.arc.cljs$lang$applyTo = (function (seq42236){
return c2.svg.arc.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42236));
});
