// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.utils');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string.format');
goog.require('goog.string');
goog.require('inflections.core');
hatti.utils.url = (function hatti$utils$url(var_args){
var args__5634__auto__ = [];
var len__5627__auto___6338 = arguments.length;
var i__5628__auto___6339 = (0);
while(true){
if((i__5628__auto___6339 < len__5627__auto___6338)){
args__5634__auto__.push((arguments[i__5628__auto___6339]));

var G__6340 = (i__5628__auto___6339 + (1));
i__5628__auto___6339 = G__6340;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return hatti.utils.url.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

hatti.utils.url.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return clojure.string.join.call(null,"/",args);
});

hatti.utils.url.cljs$lang$maxFixedArity = (0);

hatti.utils.url.cljs$lang$applyTo = (function (seq6337){
return hatti.utils.url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq6337));
});
/**
 * Get last parameter form url
 */
hatti.utils.last_url_param = (function hatti$utils$last_url_param(url){
var last_param = cljs.core.last.call(null,clojure.string.split.call(null,[cljs.core.str(url)].join(''),/\//));
return cljs.core.first.call(null,clojure.string.split.call(null,[cljs.core.str(last_param)].join(''),/.json/));
});
/**
 * Convert json to js using JSON.parse
 */
hatti.utils.json__GT_js = (function hatti$utils$json__GT_js(s){
return JSON.parse(s);
});
/**
 * Convert json string to cljs object.
 * Fast, but doesn't preserve keywords.
 */
hatti.utils.json__GT_cljs = (function hatti$utils$json__GT_cljs(s){
return cljs.core.js__GT_clj.call(null,hatti.utils.json__GT_js.call(null,s));
});
/**
 * Convert json string to cljs via js.
 * Slow method, but preserves keywords, and appropriate for small json.
 */
hatti.utils.json__GT_js__GT_cljs = (function hatti$utils$json__GT_js__GT_cljs(s){
return cljs.core.js__GT_clj.call(null,hatti.utils.json__GT_js.call(null,s),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});
/**
 * Formats a string using goog.string.format, so we can use format in cljx.
 */
hatti.utils.format = (function hatti$utils$format(var_args){
var args__5634__auto__ = [];
var len__5627__auto___6343 = arguments.length;
var i__5628__auto___6344 = (0);
while(true){
if((i__5628__auto___6344 < len__5627__auto___6343)){
args__5634__auto__.push((arguments[i__5628__auto___6344]));

var G__6345 = (i__5628__auto___6344 + (1));
i__5628__auto___6344 = G__6345;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.utils.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.utils.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return cljs.core.apply.call(null,goog.string.format,fmt,args);
});

hatti.utils.format.cljs$lang$maxFixedArity = (1);

hatti.utils.format.cljs$lang$applyTo = (function (seq6341){
var G__6342 = cljs.core.first.call(null,seq6341);
var seq6341__$1 = cljs.core.next.call(null,seq6341);
return hatti.utils.format.cljs$core$IFn$_invoke$arity$variadic(G__6342,seq6341__$1);
});
/**
 * Create a safe (escaped) js regex out of a string.
 * By default, creates regex with ignore case option.
 */
hatti.utils.safe_regex = (function hatti$utils$safe_regex(var_args){
var args__5634__auto__ = [];
var len__5627__auto___6351 = arguments.length;
var i__5628__auto___6352 = (0);
while(true){
if((i__5628__auto___6352 < len__5627__auto___6351)){
args__5634__auto__.push((arguments[i__5628__auto___6352]));

var G__6353 = (i__5628__auto___6352 + (1));
i__5628__auto___6352 = G__6353;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.utils.safe_regex.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.utils.safe_regex.cljs$core$IFn$_invoke$arity$variadic = (function (s,p__6348){
var map__6349 = p__6348;
var map__6349__$1 = ((((!((map__6349 == null)))?((((map__6349.cljs$lang$protocol_mask$partition0$ & (64))) || (map__6349.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6349):map__6349);
var ignore_case_QMARK_ = cljs.core.get.call(null,map__6349__$1,new cljs.core.Keyword(null,"ignore-case?","ignore-case?",-956106212),true);
var s__$1 = s.replace(/\/[\-\[\]\\/\{\}\(\)\*\+\?\.\\\^\$\|]\//,"\\$&");
return (new RegExp(s__$1,"i"));

});

hatti.utils.safe_regex.cljs$lang$maxFixedArity = (1);

hatti.utils.safe_regex.cljs$lang$applyTo = (function (seq6346){
var G__6347 = cljs.core.first.call(null,seq6346);
var seq6346__$1 = cljs.core.next.call(null,seq6346);
return hatti.utils.safe_regex.cljs$core$IFn$_invoke$arity$variadic(G__6347,seq6346__$1);
});
/**
 * Given a seq, produces a two-el seq. [a b c] => [[0 a] [1 b] [2 c]].
 */
hatti.utils.indexed = (function hatti$utils$indexed(coll){
return cljs.core.map_indexed.call(null,cljs.core.vector,coll);
});
/**
 * Helper function to create a click function that prevents default
 */
hatti.utils.click_fn = (function hatti$utils$click_fn(f){
return (function (event){
event.preventDefault();

return f.call(null);
});
});
/**
 * Create an appropriately pluralized string prefix by number.
 */
hatti.utils.pluralize_number = (function hatti$utils$pluralize_number(number,kind){
return clojure.string.join.call(null," ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [number,((cljs.core._EQ_.call(null,(1),number))?kind:inflections.core.plural.call(null,kind))], null));
});
/**
 * True if substring is a substring of string
 */
hatti.utils.substring_QMARK_ = (function hatti$utils$substring_QMARK_(var_args){
var args6354 = [];
var len__5627__auto___6363 = arguments.length;
var i__5628__auto___6364 = (0);
while(true){
if((i__5628__auto___6364 < len__5627__auto___6363)){
args6354.push((arguments[i__5628__auto___6364]));

var G__6365 = (i__5628__auto___6364 + (1));
i__5628__auto___6364 = G__6365;
continue;
} else {
}
break;
}

var G__6359 = args6354.length;
switch (G__6359) {
case 2:
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args6354.slice((2)),(0)));
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (substring,string){
return cljs.core.complement.call(null,cljs.core.nil_QMARK_).call(null,cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,substring),string));
});

hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (substring,string,p__6360){
var map__6361 = p__6360;
var map__6361__$1 = ((((!((map__6361 == null)))?((((map__6361.cljs$lang$protocol_mask$partition0$ & (64))) || (map__6361.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6361):map__6361);
var case_sensitive_QMARK_ = cljs.core.get.call(null,map__6361__$1,new cljs.core.Keyword(null,"case-sensitive?","case-sensitive?",-2133754107));
if(cljs.core.truth_(case_sensitive_QMARK_)){
return hatti.utils.substring_QMARK_.call(null,substring,string);
} else {
return hatti.utils.substring_QMARK_.call(null,clojure.string.lower_case.call(null,substring),clojure.string.lower_case.call(null,string));
}
});

hatti.utils.substring_QMARK_.cljs$lang$applyTo = (function (seq6355){
var G__6356 = cljs.core.first.call(null,seq6355);
var seq6355__$1 = cljs.core.next.call(null,seq6355);
var G__6357 = cljs.core.first.call(null,seq6355__$1);
var seq6355__$2 = cljs.core.next.call(null,seq6355__$1);
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__6356,G__6357,seq6355__$2);
});

hatti.utils.substring_QMARK_.cljs$lang$maxFixedArity = (2);
hatti.utils.hyphen__GT_camel_case = (function hatti$utils$hyphen__GT_camel_case(source_string){
return clojure.string.replace.call(null,source_string,/(-)(.)/,(function (p1__6367_SHARP_){
var vec__6369 = p1__6367_SHARP_;
var _ = cljs.core.nth.call(null,vec__6369,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__6369,(1),null);
var letter_to_uppercase = cljs.core.nth.call(null,vec__6369,(2),null);
return clojure.string.upper_case.call(null,letter_to_uppercase);
}));
});
