// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('inflections.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('no.en.core');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
inflections.core.Rule = (function (pattern,replacement,__meta,__extmap,__hash){
this.pattern = pattern;
this.replacement = replacement;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
inflections.core.Rule.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5183__auto__,k__5184__auto__){
var self__ = this;
var this__5183__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__5183__auto____$1,k__5184__auto__,null);
});

inflections.core.Rule.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5185__auto__,k34775,else__5186__auto__){
var self__ = this;
var this__5185__auto____$1 = this;
var G__34777 = (((k34775 instanceof cljs.core.Keyword))?k34775.fqn:null);
switch (G__34777) {
case "pattern":
return self__.pattern;

break;
case "replacement":
return self__.replacement;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k34775,else__5186__auto__);

}
});

inflections.core.Rule.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5197__auto__,writer__5198__auto__,opts__5199__auto__){
var self__ = this;
var this__5197__auto____$1 = this;
var pr_pair__5200__auto__ = ((function (this__5197__auto____$1){
return (function (keyval__5201__auto__){
return cljs.core.pr_sequential_writer(writer__5198__auto__,cljs.core.pr_writer,""," ","",opts__5199__auto__,keyval__5201__auto__);
});})(this__5197__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__5198__auto__,pr_pair__5200__auto__,"#inflections.core.Rule{",", ","}",opts__5199__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$pattern,self__.pattern],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$replacement,self__.replacement],null))], null),self__.__extmap));
});

inflections.core.Rule.prototype.cljs$core$IIterable$ = true;

inflections.core.Rule.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__34774){
var self__ = this;
var G__34774__$1 = this;
return (new cljs.core.RecordIter((0),G__34774__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pattern,cljs.core.cst$kw$replacement], null),cljs.core._iterator(self__.__extmap)));
});

inflections.core.Rule.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5181__auto__){
var self__ = this;
var this__5181__auto____$1 = this;
return self__.__meta;
});

inflections.core.Rule.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5177__auto__){
var self__ = this;
var this__5177__auto____$1 = this;
return (new inflections.core.Rule(self__.pattern,self__.replacement,self__.__meta,self__.__extmap,self__.__hash));
});

inflections.core.Rule.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5187__auto__){
var self__ = this;
var this__5187__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

inflections.core.Rule.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5178__auto__){
var self__ = this;
var this__5178__auto____$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_imap(this__5178__auto____$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

inflections.core.Rule.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__5179__auto__,other__5180__auto__){
var self__ = this;
var this__5179__auto____$1 = this;
if(cljs.core.truth_((function (){var and__4557__auto__ = other__5180__auto__;
if(cljs.core.truth_(and__4557__auto__)){
var and__4557__auto____$1 = (this__5179__auto____$1.constructor === other__5180__auto__.constructor);
if(and__4557__auto____$1){
return cljs.core.equiv_map(this__5179__auto____$1,other__5180__auto__);
} else {
return and__4557__auto____$1;
}
} else {
return and__4557__auto__;
}
})())){
return true;
} else {
return false;
}
});

inflections.core.Rule.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5192__auto__,k__5193__auto__){
var self__ = this;
var this__5192__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$replacement,null,cljs.core.cst$kw$pattern,null], null), null),k__5193__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5192__auto____$1),self__.__meta),k__5193__auto__);
} else {
return (new inflections.core.Rule(self__.pattern,self__.replacement,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5193__auto__)),null));
}
});

inflections.core.Rule.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5190__auto__,k__5191__auto__,G__34774){
var self__ = this;
var this__5190__auto____$1 = this;
var pred__34778 = cljs.core.keyword_identical_QMARK_;
var expr__34779 = k__5191__auto__;
if(cljs.core.truth_((pred__34778.cljs$core$IFn$_invoke$arity$2 ? pred__34778.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$pattern,expr__34779) : pred__34778.call(null,cljs.core.cst$kw$pattern,expr__34779)))){
return (new inflections.core.Rule(G__34774,self__.replacement,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__34778.cljs$core$IFn$_invoke$arity$2 ? pred__34778.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$replacement,expr__34779) : pred__34778.call(null,cljs.core.cst$kw$replacement,expr__34779)))){
return (new inflections.core.Rule(self__.pattern,G__34774,self__.__meta,self__.__extmap,null));
} else {
return (new inflections.core.Rule(self__.pattern,self__.replacement,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5191__auto__,G__34774),null));
}
}
});

inflections.core.Rule.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5195__auto__){
var self__ = this;
var this__5195__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$pattern,self__.pattern],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$replacement,self__.replacement],null))], null),self__.__extmap));
});

inflections.core.Rule.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5182__auto__,G__34774){
var self__ = this;
var this__5182__auto____$1 = this;
return (new inflections.core.Rule(self__.pattern,self__.replacement,G__34774,self__.__extmap,self__.__hash));
});

inflections.core.Rule.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5188__auto__,entry__5189__auto__){
var self__ = this;
var this__5188__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5189__auto__)){
return cljs.core._assoc(this__5188__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5189__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5189__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5188__auto____$1,entry__5189__auto__);
}
});

inflections.core.Rule.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pattern,cljs.core.cst$sym$replacement], null);
});

inflections.core.Rule.cljs$lang$type = true;

inflections.core.Rule.cljs$lang$ctorPrSeq = (function (this__5217__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"inflections.core/Rule");
});

inflections.core.Rule.cljs$lang$ctorPrWriter = (function (this__5217__auto__,writer__5218__auto__){
return cljs.core._write(writer__5218__auto__,"inflections.core/Rule");
});

inflections.core.__GT_Rule = (function inflections$core$__GT_Rule(pattern,replacement){
return (new inflections.core.Rule(pattern,replacement,null,null,null));
});

inflections.core.map__GT_Rule = (function inflections$core$map__GT_Rule(G__34776){
return (new inflections.core.Rule(cljs.core.cst$kw$pattern.cljs$core$IFn$_invoke$arity$1(G__34776),cljs.core.cst$kw$replacement.cljs$core$IFn$_invoke$arity$1(G__34776),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__34776,cljs.core.cst$kw$pattern,cljs.core.array_seq([cljs.core.cst$kw$replacement], 0)),null));
});

inflections.core.add_rule_BANG_ = (function inflections$core$add_rule_BANG_(rules,rule){
if(!(cljs.core.contains_QMARK_(cljs.core.set((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(rules) : cljs.core.deref.call(null,rules))),rule))){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(rules,cljs.core.conj,rule);
} else {
return null;
}
});
inflections.core.make_rule = (function inflections$core$make_rule(pattern,replacement){
return inflections.core.__GT_Rule(pattern,replacement);
});
/**
 * Returns a seq of rules, where the pattern and replacement must be
 *   given in pairs of two elements.
 */
inflections.core.slurp_rules = (function inflections$core$slurp_rules(var_args){
var args__5634__auto__ = [];
var len__5627__auto___34784 = arguments.length;
var i__5628__auto___34785 = (0);
while(true){
if((i__5628__auto___34785 < len__5627__auto___34784)){
args__5634__auto__.push((arguments[i__5628__auto___34785]));

var G__34786 = (i__5628__auto___34785 + (1));
i__5628__auto___34785 = G__34786;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return inflections.core.slurp_rules.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

inflections.core.slurp_rules.cljs$core$IFn$_invoke$arity$variadic = (function (patterns_and_replacements){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34782_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(inflections.core.make_rule,p1__34782_SHARP_);
}),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),patterns_and_replacements));
});

inflections.core.slurp_rules.cljs$lang$maxFixedArity = (0);

inflections.core.slurp_rules.cljs$lang$applyTo = (function (seq34783){
return inflections.core.slurp_rules.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34783));
});
inflections.core.resolve_rule = (function inflections$core$resolve_rule(rule,word){
var pattern = cljs.core.cst$kw$pattern.cljs$core$IFn$_invoke$arity$1(rule);
var replacement = cljs.core.cst$kw$replacement.cljs$core$IFn$_invoke$arity$1(rule);
if(cljs.core.truth_(cljs.core.re_find(pattern,word))){
return clojure.string.replace(word,pattern,replacement);
} else {
return null;
}
});
inflections.core.resolve_rules = (function inflections$core$resolve_rules(rules,word){
return cljs.core.first(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34787_SHARP_){
return inflections.core.resolve_rule(p1__34787_SHARP_,word);
}),rules)));
});
/**
 * Resets the list of plural rules.
 */
inflections.core.reset_rules_BANG_ = (function inflections$core$reset_rules_BANG_(rules){
var G__34790 = rules;
var G__34791 = cljs.core.PersistentVector.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__34790,G__34791) : cljs.core.reset_BANG_.call(null,G__34790,G__34791));
});
inflections.core._STAR_uncountable_words_STAR_ = (function (){var G__34792 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 81, ["gossip",null,"sadness",null,"space",null,"happiness",null,"blood",null,"silver",null,"cotton",null,"species",null,"mist",null,"paper",null,"education",null,"wine",null,"up",null,"food",null,"sugar",null,"gold",null,"literature",null,"pork",null,"lightning",null,"sheep",null,"shopping",null,"fresh",null,"news",null,"pepper",null,"experience",null,"milk",null,"honey",null,"oxygen",null,"fiction",null,"luck",null,"vinegar",null,"coffee",null,"ground",null,"peanut",null,"confusion",null,"tennis",null,"power",null,"meat",null,"butter",null,"music",null,"luggage",null,"love",null,"grass",null,"knowledge",null,"time",null,"cheese",null,"jam",null,"thunder",null,"electricity",null,"gum",null,"sunshine",null,"history",null,"snow",null,"money",null,"wool",null,"rice",null,"series",null,"liquid",null,"equipment",null,"pressure",null,"oil",null,"information",null,"steam",null,"chewing",null,"petrol",null,"research",null,"patience",null,"toothpaste",null,"speed",null,"entertainment",null,"wood",null,"tea",null,"art",null,"washing",null,"forgiveness",null,"traffic",null,"alcohol",null,"ice",null,"homework",null,"fish",null,"air",null], null), null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__34792) : cljs.core.atom.call(null,G__34792));
})();

/**
 * @interface
 */
inflections.core.IUncountable = function(){};

/**
 * Returns true if obj is countable, otherwise false.
 */
inflections.core.countable_QMARK_ = (function inflections$core$countable_QMARK_(obj){
if((!((obj == null))) && (!((obj.inflections$core$IUncountable$countable_QMARK_$arity$1 == null)))){
return obj.inflections$core$IUncountable$countable_QMARK_$arity$1(obj);
} else {
var x__5224__auto__ = (((obj == null))?null:obj);
var m__5225__auto__ = (inflections.core.countable_QMARK_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(obj) : m__5225__auto__.call(null,obj));
} else {
var m__5225__auto____$1 = (inflections.core.countable_QMARK_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(obj) : m__5225__auto____$1.call(null,obj));
} else {
throw cljs.core.missing_protocol("IUncountable.countable?",obj);
}
}
}
});

/**
 * Returns true if obj is uncountable, otherwise false.
 */
inflections.core.uncountable_QMARK_ = (function inflections$core$uncountable_QMARK_(obj){
if((!((obj == null))) && (!((obj.inflections$core$IUncountable$uncountable_QMARK_$arity$1 == null)))){
return obj.inflections$core$IUncountable$uncountable_QMARK_$arity$1(obj);
} else {
var x__5224__auto__ = (((obj == null))?null:obj);
var m__5225__auto__ = (inflections.core.uncountable_QMARK_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(obj) : m__5225__auto__.call(null,obj));
} else {
var m__5225__auto____$1 = (inflections.core.uncountable_QMARK_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(obj) : m__5225__auto____$1.call(null,obj));
} else {
throw cljs.core.missing_protocol("IUncountable.uncountable?",obj);
}
}
}
});

/**
 * Adds `word` to the set of `*uncountable-words*`.
 */
inflections.core.add_uncountable_BANG_ = (function inflections$core$add_uncountable_BANG_(word){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(inflections.core._STAR_uncountable_words_STAR_,cljs.core.conj,clojure.string.lower_case(cljs.core.name(word)));
});
/**
 * Delete `word` from the set of `*uncountable-words*`.
 */
inflections.core.delete_uncountable_BANG_ = (function inflections$core$delete_uncountable_BANG_(word){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(inflections.core._STAR_uncountable_words_STAR_,cljs.core.disj,clojure.string.lower_case(cljs.core.name(word)));
});
cljs.core.Keyword.prototype.inflections$core$IUncountable$ = true;

cljs.core.Keyword.prototype.inflections$core$IUncountable$countable_QMARK_$arity$1 = (function (s){
var s__$1 = this;
return cljs.core.not(inflections.core.uncountable_QMARK_(s__$1));
});

cljs.core.Keyword.prototype.inflections$core$IUncountable$uncountable_QMARK_$arity$1 = (function (k){
var k__$1 = this;
return inflections.core.uncountable_QMARK_(cljs.core.name(k__$1));
});

cljs.core.Symbol.prototype.inflections$core$IUncountable$ = true;

cljs.core.Symbol.prototype.inflections$core$IUncountable$countable_QMARK_$arity$1 = (function (s){
var s__$1 = this;
return cljs.core.not(inflections.core.uncountable_QMARK_(s__$1));
});

cljs.core.Symbol.prototype.inflections$core$IUncountable$uncountable_QMARK_$arity$1 = (function (k){
var k__$1 = this;
return inflections.core.uncountable_QMARK_([cljs.core.str(k__$1)].join(''));
});

(inflections.core.IUncountable["string"] = true);

(inflections.core.countable_QMARK_["string"] = (function (s){
return cljs.core.not(inflections.core.uncountable_QMARK_(s));
}));

(inflections.core.uncountable_QMARK_["string"] = (function (s){
return cljs.core.contains_QMARK_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inflections.core._STAR_uncountable_words_STAR_) : cljs.core.deref.call(null,inflections.core._STAR_uncountable_words_STAR_)),clojure.string.lower_case(s));
}));
inflections.core._STAR_plural_rules_STAR_ = (function (){var G__34793 = cljs.core.PersistentVector.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__34793) : cljs.core.atom.call(null,G__34793));
})();

/**
 * @interface
 */
inflections.core.Plural = function(){};

/**
 * Returns the plural of obj.
 */
inflections.core.plural = (function inflections$core$plural(obj){
if((!((obj == null))) && (!((obj.inflections$core$Plural$plural$arity$1 == null)))){
return obj.inflections$core$Plural$plural$arity$1(obj);
} else {
var x__5224__auto__ = (((obj == null))?null:obj);
var m__5225__auto__ = (inflections.core.plural[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(obj) : m__5225__auto__.call(null,obj));
} else {
var m__5225__auto____$1 = (inflections.core.plural["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(obj) : m__5225__auto____$1.call(null,obj));
} else {
throw cljs.core.missing_protocol("Plural.plural",obj);
}
}
}
});

cljs.core.Keyword.prototype.inflections$core$Plural$ = true;

cljs.core.Keyword.prototype.inflections$core$Plural$plural$arity$1 = (function (k){
var k__$1 = this;
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inflections.core.plural(cljs.core.name(k__$1)));
});

cljs.core.Symbol.prototype.inflections$core$Plural$ = true;

cljs.core.Symbol.prototype.inflections$core$Plural$plural$arity$1 = (function (k){
var k__$1 = this;
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(inflections.core.plural(cljs.core.name(k__$1)));
});

(inflections.core.Plural["string"] = true);

(inflections.core.plural["string"] = (function (s){
if(cljs.core.truth_((function (){var or__4569__auto__ = clojure.string.blank_QMARK_(s);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return inflections.core.uncountable_QMARK_(s);
}
})())){
return s;
} else {
return inflections.core.resolve_rules(cljs.core.rseq((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inflections.core._STAR_plural_rules_STAR_) : cljs.core.deref.call(null,inflections.core._STAR_plural_rules_STAR_))),s);
}
}));
/**
 * Define rule(s) to map words from singular to plural.
 * 
 *   Examples: (plural! #"$(?i)" "s")
 *          (plural! #"(ax|test)is$(?i)" "$1es"
 *                   #"(octop|vir)us$(?i)" "$1i")
 */
inflections.core.plural_BANG_ = (function inflections$core$plural_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___34799 = arguments.length;
var i__5628__auto___34800 = (0);
while(true){
if((i__5628__auto___34800 < len__5627__auto___34799)){
args__5634__auto__.push((arguments[i__5628__auto___34800]));

var G__34801 = (i__5628__auto___34800 + (1));
i__5628__auto___34800 = G__34801;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return inflections.core.plural_BANG_.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

inflections.core.plural_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (patterns_and_replacements){
var seq__34795 = cljs.core.seq(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(inflections.core.slurp_rules,patterns_and_replacements));
var chunk__34796 = null;
var count__34797 = (0);
var i__34798 = (0);
while(true){
if((i__34798 < count__34797)){
var rule = chunk__34796.cljs$core$IIndexed$_nth$arity$2(null,i__34798);
inflections.core.add_rule_BANG_(inflections.core._STAR_plural_rules_STAR_,rule);

var G__34802 = seq__34795;
var G__34803 = chunk__34796;
var G__34804 = count__34797;
var G__34805 = (i__34798 + (1));
seq__34795 = G__34802;
chunk__34796 = G__34803;
count__34797 = G__34804;
i__34798 = G__34805;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__34795);
if(temp__4425__auto__){
var seq__34795__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34795__$1)){
var c__5372__auto__ = cljs.core.chunk_first(seq__34795__$1);
var G__34806 = cljs.core.chunk_rest(seq__34795__$1);
var G__34807 = c__5372__auto__;
var G__34808 = cljs.core.count(c__5372__auto__);
var G__34809 = (0);
seq__34795 = G__34806;
chunk__34796 = G__34807;
count__34797 = G__34808;
i__34798 = G__34809;
continue;
} else {
var rule = cljs.core.first(seq__34795__$1);
inflections.core.add_rule_BANG_(inflections.core._STAR_plural_rules_STAR_,rule);

var G__34810 = cljs.core.next(seq__34795__$1);
var G__34811 = null;
var G__34812 = (0);
var G__34813 = (0);
seq__34795 = G__34810;
chunk__34796 = G__34811;
count__34797 = G__34812;
i__34798 = G__34813;
continue;
}
} else {
return null;
}
}
break;
}
});

inflections.core.plural_BANG_.cljs$lang$maxFixedArity = (0);

inflections.core.plural_BANG_.cljs$lang$applyTo = (function (seq34794){
return inflections.core.plural_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34794));
});
inflections.core.init_plural_rules_BANG_ = (function inflections$core$init_plural_rules_BANG_(){
return inflections.core.plural_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([/$/i,"s",/s$/i,"s",/(ax|test)is$/i,"$1es",/(octop|vir)us$/i,"$1i",/(alias|status)$/i,"$1es",/(bu)s$/i,"$1ses",/(buffal|tomat)o$/i,"$1oes",/([ti])um$/i,"$1a",/sis$/i,"ses",/(?:([^f])fe|([lr])f)$/i,"$1$2ves",/(hive)$/i,"$1s",/([^aeiouy]|qu)y$/i,"$1ies",/(x|ch|ss|sh)$/i,"$1es",/(matr|vert|ind)(?:ix|ex)$/i,"$1ices",/([m|l])ouse$/i,"$1ice",/^(ox)$/i,"$1en",/(quiz)$/i,"$1zes"], 0));
});
inflections.core._STAR_singular_rules_STAR_ = (function (){var G__34814 = cljs.core.PersistentVector.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__34814) : cljs.core.atom.call(null,G__34814));
})();

/**
 * @interface
 */
inflections.core.Singular = function(){};

/**
 * Returns the singular of obj.
 */
inflections.core.singular = (function inflections$core$singular(obj){
if((!((obj == null))) && (!((obj.inflections$core$Singular$singular$arity$1 == null)))){
return obj.inflections$core$Singular$singular$arity$1(obj);
} else {
var x__5224__auto__ = (((obj == null))?null:obj);
var m__5225__auto__ = (inflections.core.singular[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(obj) : m__5225__auto__.call(null,obj));
} else {
var m__5225__auto____$1 = (inflections.core.singular["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(obj) : m__5225__auto____$1.call(null,obj));
} else {
throw cljs.core.missing_protocol("Singular.singular",obj);
}
}
}
});

cljs.core.Keyword.prototype.inflections$core$Singular$ = true;

cljs.core.Keyword.prototype.inflections$core$Singular$singular$arity$1 = (function (k){
var k__$1 = this;
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inflections.core.singular(cljs.core.name(k__$1)));
});

cljs.core.Symbol.prototype.inflections$core$Singular$ = true;

cljs.core.Symbol.prototype.inflections$core$Singular$singular$arity$1 = (function (k){
var k__$1 = this;
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(inflections.core.singular(cljs.core.name(k__$1)));
});

(inflections.core.Singular["string"] = true);

(inflections.core.singular["string"] = (function (s){
if(cljs.core.truth_(inflections.core.uncountable_QMARK_(s))){
return s;
} else {
var or__4569__auto__ = inflections.core.resolve_rules(cljs.core.rseq((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inflections.core._STAR_singular_rules_STAR_) : cljs.core.deref.call(null,inflections.core._STAR_singular_rules_STAR_))),s);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return s;
}
}
}));
/**
 * Define rule(s) to map words from singular to plural.
 * 
 *   Examples: (singular! #"(n)ews$(?i)" "$1ews")
 *          (singular! #"(m)ovies$(?i)" "$1ovie"
 *                     #"([m|l])ice$(?i)" "$1ouse")
 */
inflections.core.singular_BANG_ = (function inflections$core$singular_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___34820 = arguments.length;
var i__5628__auto___34821 = (0);
while(true){
if((i__5628__auto___34821 < len__5627__auto___34820)){
args__5634__auto__.push((arguments[i__5628__auto___34821]));

var G__34822 = (i__5628__auto___34821 + (1));
i__5628__auto___34821 = G__34822;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return inflections.core.singular_BANG_.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

inflections.core.singular_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (patterns_and_replacements){
var seq__34816 = cljs.core.seq(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(inflections.core.slurp_rules,patterns_and_replacements));
var chunk__34817 = null;
var count__34818 = (0);
var i__34819 = (0);
while(true){
if((i__34819 < count__34818)){
var rule = chunk__34817.cljs$core$IIndexed$_nth$arity$2(null,i__34819);
inflections.core.add_rule_BANG_(inflections.core._STAR_singular_rules_STAR_,rule);

var G__34823 = seq__34816;
var G__34824 = chunk__34817;
var G__34825 = count__34818;
var G__34826 = (i__34819 + (1));
seq__34816 = G__34823;
chunk__34817 = G__34824;
count__34818 = G__34825;
i__34819 = G__34826;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__34816);
if(temp__4425__auto__){
var seq__34816__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34816__$1)){
var c__5372__auto__ = cljs.core.chunk_first(seq__34816__$1);
var G__34827 = cljs.core.chunk_rest(seq__34816__$1);
var G__34828 = c__5372__auto__;
var G__34829 = cljs.core.count(c__5372__auto__);
var G__34830 = (0);
seq__34816 = G__34827;
chunk__34817 = G__34828;
count__34818 = G__34829;
i__34819 = G__34830;
continue;
} else {
var rule = cljs.core.first(seq__34816__$1);
inflections.core.add_rule_BANG_(inflections.core._STAR_singular_rules_STAR_,rule);

var G__34831 = cljs.core.next(seq__34816__$1);
var G__34832 = null;
var G__34833 = (0);
var G__34834 = (0);
seq__34816 = G__34831;
chunk__34817 = G__34832;
count__34818 = G__34833;
i__34819 = G__34834;
continue;
}
} else {
return null;
}
}
break;
}
});

inflections.core.singular_BANG_.cljs$lang$maxFixedArity = (0);

inflections.core.singular_BANG_.cljs$lang$applyTo = (function (seq34815){
return inflections.core.singular_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34815));
});
inflections.core.init_singular_rules_BANG_ = (function inflections$core$init_singular_rules_BANG_(){
return inflections.core.singular_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([/s$/i,"",/(ss)$/i,"$1",/(n)ews$/i,"$1ews",/([ti])a$/i,"$1um",/((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)(sis|ses)$/i,"$1$2sis",/(^analy)(sis|ses)$/i,"$1sis",/([^f])ves$/i,"$1fe",/(hive)s$/i,"$1",/(tive)s$/i,"$1",/([lr])ves$/i,"$1f",/([^aeiouy]|qu)ies$/i,"$1y",/(s)eries$/i,"$1eries",/(m)ovies$/i,"$1ovie",/(x|ch|ss|sh)es$/i,"$1",/([m|l])ice$/i,"$1ouse",/(bus)(es)?$/i,"$1",/(o)es$/i,"$1",/(shoe)s$/i,"$1",/(cris|ax|test)(is|es)$/i,"$1is",/(octop|vir)(us|i)$/i,"$1us",/(alias|status)(es)?$/i,"$1",/^(ox)en/i,"$1",/(vert|ind)ices$/i,"$1ex",/(matr)ices$/i,"$1ix",/(quiz)zes$/i,"$1",/(database)s$/i,"$1"], 0));
});
inflections.core._STAR_irregular_words_STAR_ = (function (){var G__34835 = cljs.core.sorted_set();
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__34835) : cljs.core.atom.call(null,G__34835));
})();

/**
 * @interface
 */
inflections.core.Irregular = function(){};

/**
 * Returns true if obj is an irregular word, otherwise false.
 */
inflections.core.irregular_QMARK_ = (function inflections$core$irregular_QMARK_(obj){
if((!((obj == null))) && (!((obj.inflections$core$Irregular$irregular_QMARK_$arity$1 == null)))){
return obj.inflections$core$Irregular$irregular_QMARK_$arity$1(obj);
} else {
var x__5224__auto__ = (((obj == null))?null:obj);
var m__5225__auto__ = (inflections.core.irregular_QMARK_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(obj) : m__5225__auto__.call(null,obj));
} else {
var m__5225__auto____$1 = (inflections.core.irregular_QMARK_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(obj) : m__5225__auto____$1.call(null,obj));
} else {
throw cljs.core.missing_protocol("Irregular.irregular?",obj);
}
}
}
});

/**
 * Add `singular` and `plural` to the set of `*irregular-words*`.
 */
inflections.core.add_irregular_BANG_ = (function inflections$core$add_irregular_BANG_(singular,plural){
var singular__$1 = clojure.string.lower_case(cljs.core.name(singular));
var plural__$1 = clojure.string.lower_case(cljs.core.name(plural));
inflections.core.delete_uncountable_BANG_(singular__$1);

inflections.core.delete_uncountable_BANG_(plural__$1);

inflections.core.singular_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.re_pattern([cljs.core.str("^"),cljs.core.str(plural__$1),cljs.core.str("$")].join('')),singular__$1], 0));

inflections.core.plural_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.re_pattern([cljs.core.str("^"),cljs.core.str(singular__$1),cljs.core.str("$")].join('')),plural__$1], 0));

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(inflections.core._STAR_irregular_words_STAR_,cljs.core.conj,singular__$1);

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(inflections.core._STAR_irregular_words_STAR_,cljs.core.conj,plural__$1);
});
/**
 * Delete `singular` and `plural` from the set of *irregular-words*.
 */
inflections.core.delete_irregular_BANG_ = (function inflections$core$delete_irregular_BANG_(singular,plural){
var singular__$1 = clojure.string.lower_case(cljs.core.name(singular));
var plural__$1 = clojure.string.lower_case(cljs.core.name(plural));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(inflections.core._STAR_irregular_words_STAR_,cljs.core.disj,singular__$1);

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(inflections.core._STAR_irregular_words_STAR_,cljs.core.disj,plural__$1);
});
cljs.core.Keyword.prototype.inflections$core$Irregular$ = true;

cljs.core.Keyword.prototype.inflections$core$Irregular$irregular_QMARK_$arity$1 = (function (k){
var k__$1 = this;
return inflections.core.irregular_QMARK_(cljs.core.name(k__$1));
});

cljs.core.Symbol.prototype.inflections$core$Irregular$ = true;

cljs.core.Symbol.prototype.inflections$core$Irregular$irregular_QMARK_$arity$1 = (function (k){
var k__$1 = this;
return inflections.core.irregular_QMARK_(cljs.core.name(k__$1));
});

(inflections.core.Irregular["string"] = true);

(inflections.core.irregular_QMARK_["string"] = (function (s){
return cljs.core.contains_QMARK_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inflections.core._STAR_irregular_words_STAR_) : cljs.core.deref.call(null,inflections.core._STAR_irregular_words_STAR_)),clojure.string.lower_case(s));
}));
inflections.core.init_irregular_words_BANG_ = (function inflections$core$init_irregular_words_BANG_(){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34836_SHARP_){
return inflections.core.add_irregular_BANG_(cljs.core.first(p1__34836_SHARP_),cljs.core.second(p1__34836_SHARP_));
}),new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["amenity","amenities"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["child","children"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["cow","kine"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["foot","feet"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["louse","lice"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["mailman","mailmen"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["man","men"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["mouse","mice"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["move","moves"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ox","oxen"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["person","people"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["sex","sexes"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["tooth","teeth"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["woman","women"], null)], null)));
});

/**
 * @interface
 */
inflections.core.ICamelize = function(){};

/**
 * Camelize an object.
 */
inflections.core._camelize = (function inflections$core$_camelize(object,mode){
if((!((object == null))) && (!((object.inflections$core$ICamelize$_camelize$arity$2 == null)))){
return object.inflections$core$ICamelize$_camelize$arity$2(object,mode);
} else {
var x__5224__auto__ = (((object == null))?null:object);
var m__5225__auto__ = (inflections.core._camelize[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(object,mode) : m__5225__auto__.call(null,object,mode));
} else {
var m__5225__auto____$1 = (inflections.core._camelize["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(object,mode) : m__5225__auto____$1.call(null,object,mode));
} else {
throw cljs.core.missing_protocol("ICamelize.-camelize",object);
}
}
}
});

(inflections.core.ICamelize["null"] = true);

(inflections.core._camelize["null"] = (function (_,___$1){
return null;
}));

cljs.core.Keyword.prototype.inflections$core$ICamelize$ = true;

cljs.core.Keyword.prototype.inflections$core$ICamelize$_camelize$arity$2 = (function (obj,mode){
var obj__$1 = this;
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inflections.core._camelize(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.rest([cljs.core.str(obj__$1)].join(''))),mode));
});

cljs.core.Symbol.prototype.inflections$core$ICamelize$ = true;

cljs.core.Symbol.prototype.inflections$core$ICamelize$_camelize$arity$2 = (function (obj,mode){
var obj__$1 = this;
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(inflections.core._camelize([cljs.core.str(obj__$1)].join(''),mode));
});

(inflections.core.ICamelize["string"] = true);

(inflections.core._camelize["string"] = (function (obj,mode){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$lower)){
return inflections.core._camelize(obj,clojure.string.lower_case);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$upper)){
return inflections.core._camelize(obj,clojure.string.upper_case);
} else {
if(cljs.core.fn_QMARK_(mode)){
return [cljs.core.str((function (){var G__34839 = [cljs.core.str(cljs.core.first(obj))].join('');
return (mode.cljs$core$IFn$_invoke$arity$1 ? mode.cljs$core$IFn$_invoke$arity$1(G__34839) : mode.call(null,G__34839));
})()),cljs.core.str(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.rest(inflections.core._camelize(obj,null))))].join('');
} else {
return clojure.string.replace(clojure.string.replace([cljs.core.str(obj)].join(''),/\/(.?)/,(function (p1__34837_SHARP_){
return [cljs.core.str("::"),cljs.core.str(clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__34837_SHARP_,(1))))].join('');
})),/(^|_|-)(.)/,(function (p1__34838_SHARP_){
var vec__34840 = p1__34838_SHARP_;
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34840,(0),null);
var r = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34840,(1),null);
return [cljs.core.str(((cljs.core.not(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["-",null,"_",null], null), null).call(null,f)))?clojure.string.upper_case(f):null)),cljs.core.str((cljs.core.truth_(r)?clojure.string.upper_case(r):null))].join('');
}));

}
}
}
}));
/**
 * Convert obj to camel case. By default, camelize converts to
 *   UpperCamelCase. If the argument to camelize is set to :lower then
 *   camelize produces lowerCamelCase. The camelize fn will also convert
 *   "/" to "::" which is useful for converting paths to namespaces.
 * 
 *   Examples:
 * 
 *  (camelize "active_record")
 *  ;=> "ActiveRecord"
 * 
 *  (camelize "active_record" :lower)
 *  ;=> "activeRecord"
 * 
 *  (camelize "active_record/errors")
 *  ;=> "ActiveRecord::Errors"
 * 
 *  (camelize "active_record/errors" :lower)
 *  ;=> "activeRecord::Errors"
 */
inflections.core.camelize = (function inflections$core$camelize(var_args){
var args__5634__auto__ = [];
var len__5627__auto___34845 = arguments.length;
var i__5628__auto___34846 = (0);
while(true){
if((i__5628__auto___34846 < len__5627__auto___34845)){
args__5634__auto__.push((arguments[i__5628__auto___34846]));

var G__34847 = (i__5628__auto___34846 + (1));
i__5628__auto___34846 = G__34847;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return inflections.core.camelize.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

inflections.core.camelize.cljs$core$IFn$_invoke$arity$variadic = (function (obj,p__34843){
var vec__34844 = p__34843;
var mode = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34844,(0),null);
return inflections.core._camelize(obj,mode);
});

inflections.core.camelize.cljs$lang$maxFixedArity = (1);

inflections.core.camelize.cljs$lang$applyTo = (function (seq34841){
var G__34842 = cljs.core.first(seq34841);
var seq34841__$1 = cljs.core.next(seq34841);
return inflections.core.camelize.cljs$core$IFn$_invoke$arity$variadic(G__34842,seq34841__$1);
});

/**
 * @interface
 */
inflections.core.ICapitalize = function(){};

/**
 * Capitalize an object.
 */
inflections.core._capitalize = (function inflections$core$_capitalize(object){
if((!((object == null))) && (!((object.inflections$core$ICapitalize$_capitalize$arity$1 == null)))){
return object.inflections$core$ICapitalize$_capitalize$arity$1(object);
} else {
var x__5224__auto__ = (((object == null))?null:object);
var m__5225__auto__ = (inflections.core._capitalize[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(object) : m__5225__auto__.call(null,object));
} else {
var m__5225__auto____$1 = (inflections.core._capitalize["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(object) : m__5225__auto____$1.call(null,object));
} else {
throw cljs.core.missing_protocol("ICapitalize.-capitalize",object);
}
}
}
});

(inflections.core.ICapitalize["null"] = true);

(inflections.core._capitalize["null"] = (function (_){
return null;
}));

cljs.core.Keyword.prototype.inflections$core$ICapitalize$ = true;

cljs.core.Keyword.prototype.inflections$core$ICapitalize$_capitalize$arity$1 = (function (obj){
var obj__$1 = this;
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inflections.core._capitalize(cljs.core.name(obj__$1)));
});

cljs.core.Symbol.prototype.inflections$core$ICapitalize$ = true;

cljs.core.Symbol.prototype.inflections$core$ICapitalize$_capitalize$arity$1 = (function (obj){
var obj__$1 = this;
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(inflections.core._capitalize([cljs.core.str(obj__$1)].join('')));
});

(inflections.core.ICapitalize["string"] = true);

(inflections.core._capitalize["string"] = (function (obj){
return [cljs.core.str(clojure.string.upper_case([cljs.core.str(cljs.core.first(obj))].join(''))),cljs.core.str(clojure.string.lower_case(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.rest(obj))))].join('');
}));
/**
 * Convert the first letter in obj to upper case.
 * 
 *   Examples:
 * 
 *  (capitalize "hello")
 *  ;=> "Hello"
 * 
 *  (capitalize "HELLO")
 *  ;=> "Hello"
 * 
 *  (capitalize "abc123")
 *  ;=> "Abc123"
 */
inflections.core.capitalize = (function inflections$core$capitalize(obj){
return inflections.core._capitalize(obj);
});

/**
 * @interface
 */
inflections.core.IDasherize = function(){};

/**
 * Dasherize an object.
 */
inflections.core._dasherize = (function inflections$core$_dasherize(object){
if((!((object == null))) && (!((object.inflections$core$IDasherize$_dasherize$arity$1 == null)))){
return object.inflections$core$IDasherize$_dasherize$arity$1(object);
} else {
var x__5224__auto__ = (((object == null))?null:object);
var m__5225__auto__ = (inflections.core._dasherize[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(object) : m__5225__auto__.call(null,object));
} else {
var m__5225__auto____$1 = (inflections.core._dasherize["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(object) : m__5225__auto____$1.call(null,object));
} else {
throw cljs.core.missing_protocol("IDasherize.-dasherize",object);
}
}
}
});

(inflections.core.IDasherize["null"] = true);

(inflections.core._dasherize["null"] = (function (_){
return null;
}));

cljs.core.Keyword.prototype.inflections$core$IDasherize$ = true;

cljs.core.Keyword.prototype.inflections$core$IDasherize$_dasherize$arity$1 = (function (obj){
var obj__$1 = this;
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inflections.core._dasherize(cljs.core.name(obj__$1)));
});

cljs.core.Symbol.prototype.inflections$core$IDasherize$ = true;

cljs.core.Symbol.prototype.inflections$core$IDasherize$_dasherize$arity$1 = (function (obj){
var obj__$1 = this;
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(inflections.core._dasherize([cljs.core.str(obj__$1)].join('')));
});

(inflections.core.IDasherize["string"] = true);

(inflections.core._dasherize["string"] = (function (obj){
return clojure.string.replace(obj,/_/,"-");
}));
/**
 * Replaces all underscores in obj with dashes.
 * 
 *   Examples:
 * 
 *  (dasherize "puni_puni")
 *  ;=> "puni-puni"
 */
inflections.core.dasherize = (function inflections$core$dasherize(obj){
return inflections.core._dasherize(obj);
});

/**
 * @interface
 */
inflections.core.IDemodulize = function(){};

/**
 * Demodulize an object.
 */
inflections.core._demodulize = (function inflections$core$_demodulize(object){
if((!((object == null))) && (!((object.inflections$core$IDemodulize$_demodulize$arity$1 == null)))){
return object.inflections$core$IDemodulize$_demodulize$arity$1(object);
} else {
var x__5224__auto__ = (((object == null))?null:object);
var m__5225__auto__ = (inflections.core._demodulize[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(object) : m__5225__auto__.call(null,object));
} else {
var m__5225__auto____$1 = (inflections.core._demodulize["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(object) : m__5225__auto____$1.call(null,object));
} else {
throw cljs.core.missing_protocol("IDemodulize.-demodulize",object);
}
}
}
});

(inflections.core.IDemodulize["null"] = true);

(inflections.core._demodulize["null"] = (function (_){
return null;
}));

cljs.core.Keyword.prototype.inflections$core$IDemodulize$ = true;

cljs.core.Keyword.prototype.inflections$core$IDemodulize$_demodulize$arity$1 = (function (obj){
var obj__$1 = this;
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inflections.core._demodulize(cljs.core.name(obj__$1)));
});

cljs.core.Symbol.prototype.inflections$core$IDemodulize$ = true;

cljs.core.Symbol.prototype.inflections$core$IDemodulize$_demodulize$arity$1 = (function (obj){
var obj__$1 = this;
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(inflections.core._demodulize([cljs.core.str(obj__$1)].join('')));
});

(inflections.core.IDemodulize["string"] = true);

(inflections.core._demodulize["string"] = (function (obj){
return clojure.string.replace(obj,/^.*(::|\.)/,"");
}));
/**
 * Removes the module part from obj.
 * 
 *   Examples:
 * 
 *  (demodulize "inflections.MyRecord")
 *  ;=> "MyRecord"
 * 
 *  (demodulize "ActiveRecord::CoreExtensions::String::Inflections")
 *  ;=> "Inflections"
 * 
 *  (demodulize "Inflections")
 *  ;=> "Inflections"
 */
inflections.core.demodulize = (function inflections$core$demodulize(obj){
return inflections.core._demodulize(obj);
});

/**
 * @interface
 */
inflections.core.IHyphenize = function(){};

/**
 * Hyphenize an object.
 */
inflections.core._hyphenize = (function inflections$core$_hyphenize(object){
if((!((object == null))) && (!((object.inflections$core$IHyphenize$_hyphenize$arity$1 == null)))){
return object.inflections$core$IHyphenize$_hyphenize$arity$1(object);
} else {
var x__5224__auto__ = (((object == null))?null:object);
var m__5225__auto__ = (inflections.core._hyphenize[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(object) : m__5225__auto__.call(null,object));
} else {
var m__5225__auto____$1 = (inflections.core._hyphenize["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(object) : m__5225__auto____$1.call(null,object));
} else {
throw cljs.core.missing_protocol("IHyphenize.-hyphenize",object);
}
}
}
});

(inflections.core.IHyphenize["null"] = true);

(inflections.core._hyphenize["null"] = (function (_){
return null;
}));

cljs.core.Keyword.prototype.inflections$core$IHyphenize$ = true;

cljs.core.Keyword.prototype.inflections$core$IHyphenize$_hyphenize$arity$1 = (function (obj){
var obj__$1 = this;
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inflections.core._hyphenize(cljs.core.name(obj__$1)));
});

cljs.core.Symbol.prototype.inflections$core$IHyphenize$ = true;

cljs.core.Symbol.prototype.inflections$core$IHyphenize$_hyphenize$arity$1 = (function (obj){
var obj__$1 = this;
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(inflections.core._hyphenize([cljs.core.str(obj__$1)].join('')));
});

(inflections.core.IHyphenize["string"] = true);

(inflections.core._hyphenize["string"] = (function (obj){
return clojure.string.lower_case(clojure.string.replace(clojure.string.replace(clojure.string.replace(clojure.string.replace(clojure.string.replace(obj,/::/,"/"),/([A-Z]+)([A-Z][a-z])/,"$1-$2"),/([a-z\d])([A-Z])/,"$1-$2"),/\s+/,"-"),/_/,"-"));
}));
/**
 * Hyphenize obj, which is the same as threading obj through the str,
 *   underscore and dasherize fns.
 * 
 *   Examples:
 * 
 *  (hyphenize 'Continent)
 *  ; => "continent"
 * 
 *  (hyphenize "CountryFlag")
 *  ; => "country-flag"
 */
inflections.core.hyphenize = (function inflections$core$hyphenize(obj){
return inflections.core._hyphenize(obj);
});

/**
 * @interface
 */
inflections.core.IOrdinalize = function(){};

/**
 * Ordinalize an object.
 */
inflections.core._ordinalize = (function inflections$core$_ordinalize(object){
if((!((object == null))) && (!((object.inflections$core$IOrdinalize$_ordinalize$arity$1 == null)))){
return object.inflections$core$IOrdinalize$_ordinalize$arity$1(object);
} else {
var x__5224__auto__ = (((object == null))?null:object);
var m__5225__auto__ = (inflections.core._ordinalize[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(object) : m__5225__auto__.call(null,object));
} else {
var m__5225__auto____$1 = (inflections.core._ordinalize["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(object) : m__5225__auto____$1.call(null,object));
} else {
throw cljs.core.missing_protocol("IOrdinalize.-ordinalize",object);
}
}
}
});

(inflections.core.IOrdinalize["null"] = true);

(inflections.core._ordinalize["null"] = (function (_){
return null;
}));

cljs.core.Keyword.prototype.inflections$core$IOrdinalize$ = true;

cljs.core.Keyword.prototype.inflections$core$IOrdinalize$_ordinalize$arity$1 = (function (obj){
var obj__$1 = this;
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inflections.core._ordinalize(cljs.core.name(obj__$1)));
});

cljs.core.Symbol.prototype.inflections$core$IOrdinalize$ = true;

cljs.core.Symbol.prototype.inflections$core$IOrdinalize$_ordinalize$arity$1 = (function (obj){
var obj__$1 = this;
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(inflections.core._ordinalize([cljs.core.str(obj__$1)].join('')));
});

(inflections.core.IOrdinalize["number"] = true);

(inflections.core._ordinalize["number"] = (function (obj){
return inflections.core._ordinalize([cljs.core.str(obj)].join(''));
}));

(inflections.core.IOrdinalize["string"] = true);

(inflections.core._ordinalize["string"] = (function (obj){
var temp__4423__auto__ = no.en.core.parse_integer(obj);
if(cljs.core.truth_(temp__4423__auto__)){
var number = temp__4423__auto__;
if(cljs.core.contains_QMARK_(cljs.core.set(cljs.core.range.cljs$core$IFn$_invoke$arity$2((11),(14))),cljs.core.mod(number,(100)))){
return [cljs.core.str(number),cljs.core.str("th")].join('');
} else {
var modulus = cljs.core.mod(number,(10));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(modulus,(1))){
return [cljs.core.str(number),cljs.core.str("st")].join('');
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(modulus,(2))){
return [cljs.core.str(number),cljs.core.str("nd")].join('');
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(modulus,(3))){
return [cljs.core.str(number),cljs.core.str("rd")].join('');
} else {
return [cljs.core.str(number),cljs.core.str("th")].join('');

}
}
}
}
} else {
return null;
}
}));
/**
 * Turns obj into an ordinal string used to denote the position in an
 *   ordered sequence such as 1st, 2nd, 3rd, 4th, etc.
 * 
 *   Examples:
 * 
 *  (ordinalize "1")
 *  ;=> "1st"
 * 
 *  (ordinalize "23")
 *  ;=> "23rd"
 */
inflections.core.ordinalize = (function inflections$core$ordinalize(obj){
return inflections.core._ordinalize(obj);
});

/**
 * @interface
 */
inflections.core.IParameterize = function(){};

/**
 * Parameterize an object.
 */
inflections.core._parameterize = (function inflections$core$_parameterize(object,sep){
if((!((object == null))) && (!((object.inflections$core$IParameterize$_parameterize$arity$2 == null)))){
return object.inflections$core$IParameterize$_parameterize$arity$2(object,sep);
} else {
var x__5224__auto__ = (((object == null))?null:object);
var m__5225__auto__ = (inflections.core._parameterize[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(object,sep) : m__5225__auto__.call(null,object,sep));
} else {
var m__5225__auto____$1 = (inflections.core._parameterize["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(object,sep) : m__5225__auto____$1.call(null,object,sep));
} else {
throw cljs.core.missing_protocol("IParameterize.-parameterize",object);
}
}
}
});

(inflections.core.IParameterize["null"] = true);

(inflections.core._parameterize["null"] = (function (_,___$1){
return null;
}));

cljs.core.Keyword.prototype.inflections$core$IParameterize$ = true;

cljs.core.Keyword.prototype.inflections$core$IParameterize$_parameterize$arity$2 = (function (obj,sep){
var obj__$1 = this;
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inflections.core._parameterize(cljs.core.name(obj__$1),sep));
});

cljs.core.Symbol.prototype.inflections$core$IParameterize$ = true;

cljs.core.Symbol.prototype.inflections$core$IParameterize$_parameterize$arity$2 = (function (obj,sep){
var obj__$1 = this;
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(inflections.core._parameterize([cljs.core.str(obj__$1)].join(''),sep));
});

(inflections.core.IParameterize["string"] = true);

(inflections.core._parameterize["string"] = (function (obj,sep){
var sep__$1 = (function (){var or__4569__auto__ = sep;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return "-";
}
})();
return clojure.string.lower_case(clojure.string.replace(clojure.string.replace(clojure.string.replace(clojure.string.replace(obj,/[^A-Za-z0-9]+/,sep__$1),/\++/,sep__$1),cljs.core.re_pattern([cljs.core.str(sep__$1),cljs.core.str("{2,}")].join('')),sep__$1),cljs.core.re_pattern([cljs.core.str("(?i)(^"),cljs.core.str(sep__$1),cljs.core.str(")|("),cljs.core.str(sep__$1),cljs.core.str("$)")].join('')),""));
}));
/**
 * Replaces special characters in obj with the default separator
 *   "-". so that it may be used as part of a pretty URL.
 * 
 *   Examples:
 * 
 *  (parameterize "Donald E. Knuth")
 *  ; => "donald-e-knuth"
 * 
 *  (parameterize "Donald E. Knuth" "_")
 *  ; => "donald_e_knuth"
 */
inflections.core.parameterize = (function inflections$core$parameterize(var_args){
var args__5634__auto__ = [];
var len__5627__auto___34852 = arguments.length;
var i__5628__auto___34853 = (0);
while(true){
if((i__5628__auto___34853 < len__5627__auto___34852)){
args__5634__auto__.push((arguments[i__5628__auto___34853]));

var G__34854 = (i__5628__auto___34853 + (1));
i__5628__auto___34853 = G__34854;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return inflections.core.parameterize.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

inflections.core.parameterize.cljs$core$IFn$_invoke$arity$variadic = (function (obj,p__34850){
var vec__34851 = p__34850;
var separator = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34851,(0),null);
return inflections.core._parameterize(obj,separator);
});

inflections.core.parameterize.cljs$lang$maxFixedArity = (1);

inflections.core.parameterize.cljs$lang$applyTo = (function (seq34848){
var G__34849 = cljs.core.first(seq34848);
var seq34848__$1 = cljs.core.next(seq34848);
return inflections.core.parameterize.cljs$core$IFn$_invoke$arity$variadic(G__34849,seq34848__$1);
});
/**
 * Attempts to pluralize the word unless count is 1. If plural is
 *   supplied, it will use that when count is > 1, otherwise it will use
 *   the inflector to determine the plural form.
 */
inflections.core.pluralize = (function inflections$core$pluralize(var_args){
var args__5634__auto__ = [];
var len__5627__auto___34860 = arguments.length;
var i__5628__auto___34861 = (0);
while(true){
if((i__5628__auto___34861 < len__5627__auto___34860)){
args__5634__auto__.push((arguments[i__5628__auto___34861]));

var G__34862 = (i__5628__auto___34861 + (1));
i__5628__auto___34861 = G__34862;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return inflections.core.pluralize.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

inflections.core.pluralize.cljs$core$IFn$_invoke$arity$variadic = (function (count,singular,p__34858){
var vec__34859 = p__34858;
var plural = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34859,(0),null);
return [cljs.core.str(count),cljs.core.str(" "),cljs.core.str(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),count))?singular:(function (){var or__4569__auto__ = plural;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return inflections.core.plural(singular);
}
})()))].join('');
});

inflections.core.pluralize.cljs$lang$maxFixedArity = (2);

inflections.core.pluralize.cljs$lang$applyTo = (function (seq34855){
var G__34856 = cljs.core.first(seq34855);
var seq34855__$1 = cljs.core.next(seq34855);
var G__34857 = cljs.core.first(seq34855__$1);
var seq34855__$2 = cljs.core.next(seq34855__$1);
return inflections.core.pluralize.cljs$core$IFn$_invoke$arity$variadic(G__34856,G__34857,seq34855__$2);
});

/**
 * @interface
 */
inflections.core.IUnderscore = function(){};

/**
 * Underscore an object.
 */
inflections.core._underscore = (function inflections$core$_underscore(object){
if((!((object == null))) && (!((object.inflections$core$IUnderscore$_underscore$arity$1 == null)))){
return object.inflections$core$IUnderscore$_underscore$arity$1(object);
} else {
var x__5224__auto__ = (((object == null))?null:object);
var m__5225__auto__ = (inflections.core._underscore[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(object) : m__5225__auto__.call(null,object));
} else {
var m__5225__auto____$1 = (inflections.core._underscore["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(object) : m__5225__auto____$1.call(null,object));
} else {
throw cljs.core.missing_protocol("IUnderscore.-underscore",object);
}
}
}
});

(inflections.core.IUnderscore["null"] = true);

(inflections.core._underscore["null"] = (function (_){
return null;
}));

cljs.core.Keyword.prototype.inflections$core$IUnderscore$ = true;

cljs.core.Keyword.prototype.inflections$core$IUnderscore$_underscore$arity$1 = (function (obj){
var obj__$1 = this;
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inflections.core._underscore(cljs.core.name(obj__$1)));
});

cljs.core.Symbol.prototype.inflections$core$IUnderscore$ = true;

cljs.core.Symbol.prototype.inflections$core$IUnderscore$_underscore$arity$1 = (function (obj){
var obj__$1 = this;
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(inflections.core._underscore([cljs.core.str(obj__$1)].join('')));
});

(inflections.core.IUnderscore["string"] = true);

(inflections.core._underscore["string"] = (function (obj){
return clojure.string.lower_case(clojure.string.replace(clojure.string.replace(clojure.string.replace(clojure.string.replace(obj,/::/,"/"),/([A-Z\d]+)([A-Z][a-z])/,"$1_$2"),/([a-z\d])([A-Z])/,"$1_$2"),/-/,"_"));
}));
/**
 * The reverse of camelize. Makes an underscored, lowercase form from
 *   the expression in the string. Changes "::" to "/" to convert
 *   namespaces to paths.
 * 
 *   Examples:
 * 
 *  (underscore "ActiveRecord")
 *  ;=> "active_record"
 * 
 *  (underscore "ActiveRecord::Errors")
 *  ;=> "active_record/errors"
 */
inflections.core.underscore = (function inflections$core$underscore(obj){
return inflections.core._underscore(obj);
});

/**
 * @interface
 */
inflections.core.IForeignKey = function(){};

/**
 * Demodulize an object.
 */
inflections.core._foreign_key = (function inflections$core$_foreign_key(object,sep){
if((!((object == null))) && (!((object.inflections$core$IForeignKey$_foreign_key$arity$2 == null)))){
return object.inflections$core$IForeignKey$_foreign_key$arity$2(object,sep);
} else {
var x__5224__auto__ = (((object == null))?null:object);
var m__5225__auto__ = (inflections.core._foreign_key[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(object,sep) : m__5225__auto__.call(null,object,sep));
} else {
var m__5225__auto____$1 = (inflections.core._foreign_key["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(object,sep) : m__5225__auto____$1.call(null,object,sep));
} else {
throw cljs.core.missing_protocol("IForeignKey.-foreign-key",object);
}
}
}
});

(inflections.core.IForeignKey["null"] = true);

(inflections.core._foreign_key["null"] = (function (_,___$1){
return null;
}));

cljs.core.Keyword.prototype.inflections$core$IForeignKey$ = true;

cljs.core.Keyword.prototype.inflections$core$IForeignKey$_foreign_key$arity$2 = (function (obj,sep){
var obj__$1 = this;
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inflections.core._foreign_key(cljs.core.name(obj__$1),sep));
});

cljs.core.Symbol.prototype.inflections$core$IForeignKey$ = true;

cljs.core.Symbol.prototype.inflections$core$IForeignKey$_foreign_key$arity$2 = (function (obj,sep){
var obj__$1 = this;
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(inflections.core._foreign_key([cljs.core.str(obj__$1)].join(''),sep));
});

(inflections.core.IForeignKey["string"] = true);

(inflections.core._foreign_key["string"] = (function (obj,sep){
if(cljs.core.not(clojure.string.blank_QMARK_(obj))){
return [cljs.core.str(inflections.core.underscore(inflections.core.hyphenize(inflections.core.singular(inflections.core.demodulize(obj))))),cljs.core.str((function (){var or__4569__auto__ = sep;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return "_";
}
})()),cljs.core.str("id")].join('');
} else {
return null;
}
}));
/**
 * Converts obj into a foreign key. The default separator "_" is
 *   placed between the name and "id".
 * 
 * 
 *   Examples:
 * 
 *  (foreign-key "Message")
 *  ;=> "message_id"
 * 
 *  (foreign-key "Message" false)
 *  ;=> "messageid"
 * 
 *  (foreign-key "Admin::Post")
 *  ;=> "post_id"
 */
inflections.core.foreign_key = (function inflections$core$foreign_key(var_args){
var args__5634__auto__ = [];
var len__5627__auto___34867 = arguments.length;
var i__5628__auto___34868 = (0);
while(true){
if((i__5628__auto___34868 < len__5627__auto___34867)){
args__5634__auto__.push((arguments[i__5628__auto___34868]));

var G__34869 = (i__5628__auto___34868 + (1));
i__5628__auto___34868 = G__34869;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return inflections.core.foreign_key.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

inflections.core.foreign_key.cljs$core$IFn$_invoke$arity$variadic = (function (obj,p__34865){
var vec__34866 = p__34865;
var separator = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34866,(0),null);
return inflections.core._foreign_key(obj,separator);
});

inflections.core.foreign_key.cljs$lang$maxFixedArity = (1);

inflections.core.foreign_key.cljs$lang$applyTo = (function (seq34863){
var G__34864 = cljs.core.first(seq34863);
var seq34863__$1 = cljs.core.next(seq34863);
return inflections.core.foreign_key.cljs$core$IFn$_invoke$arity$variadic(G__34864,seq34863__$1);
});
/**
 * Recursively transform all keys in the map `m` by applying `f` on them.
 */
inflections.core.transform_keys = (function inflections$core$transform_keys(m,f){
if(cljs.core.map_QMARK_(m)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (memo,key){
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,key);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(memo,key),(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(key) : f.call(null,key)),((cljs.core.map_QMARK_(value))?inflections$core$transform_keys(value,f):((cljs.core.sequential_QMARK_(value))?cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (value){
return (function (p1__34870_SHARP_){
return inflections$core$transform_keys(p1__34870_SHARP_,f);
});})(value))
,value):value
)));
}),m,cljs.core.keys(m));
} else {
return m;
}
});
/**
 * Recursively transform all map values of m by applying f on them.
 */
inflections.core.transform_values = (function inflections$core$transform_values(m,f){
if(cljs.core.map_QMARK_(m)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (memo,key){
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,key);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(memo,key,((cljs.core.map_QMARK_(value))?inflections$core$transform_values(value,f):(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(value) : f.call(null,value))));
}),m,cljs.core.keys(m));
} else {
return m;
}
});
/**
 * Recursively apply camelize on all keys of m.
 */
inflections.core.camelize_keys = (function inflections$core$camelize_keys(var_args){
var args__5634__auto__ = [];
var len__5627__auto___34876 = arguments.length;
var i__5628__auto___34877 = (0);
while(true){
if((i__5628__auto___34877 < len__5627__auto___34876)){
args__5634__auto__.push((arguments[i__5628__auto___34877]));

var G__34878 = (i__5628__auto___34877 + (1));
i__5628__auto___34877 = G__34878;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return inflections.core.camelize_keys.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

inflections.core.camelize_keys.cljs$core$IFn$_invoke$arity$variadic = (function (m,p__34874){
var vec__34875 = p__34874;
var mode = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34875,(0),null);
return inflections.core.transform_keys(m,((function (vec__34875,mode){
return (function (p1__34871_SHARP_){
return inflections.core.camelize.cljs$core$IFn$_invoke$arity$variadic(p1__34871_SHARP_,cljs.core.array_seq([mode], 0));
});})(vec__34875,mode))
);
});

inflections.core.camelize_keys.cljs$lang$maxFixedArity = (1);

inflections.core.camelize_keys.cljs$lang$applyTo = (function (seq34872){
var G__34873 = cljs.core.first(seq34872);
var seq34872__$1 = cljs.core.next(seq34872);
return inflections.core.camelize_keys.cljs$core$IFn$_invoke$arity$variadic(G__34873,seq34872__$1);
});
/**
 * Recursively apply hyphenize on all keys of m.
 */
inflections.core.hyphenize_keys = (function inflections$core$hyphenize_keys(m){
return inflections.core.transform_keys(m,inflections.core.hyphenize);
});
/**
 * Recursively apply hyphenize on all values of m.
 */
inflections.core.hyphenize_values = (function inflections$core$hyphenize_values(m){
return inflections.core.transform_values(m,inflections.core.hyphenize);
});
/**
 * Recursively transform all keys of m into strings.
 */
inflections.core.stringify_keys = (function inflections$core$stringify_keys(m){
return inflections.core.transform_keys(m,(function (p1__34879_SHARP_){
if((p1__34879_SHARP_ instanceof cljs.core.Keyword)){
return cljs.core.name(p1__34879_SHARP_);
} else {
return [cljs.core.str(p1__34879_SHARP_)].join('');
}
}));
});
/**
 * Recursively transform all values of m into strings.
 */
inflections.core.stringify_values = (function inflections$core$stringify_values(m){
return inflections.core.transform_values(m,(function (p1__34880_SHARP_){
if((p1__34880_SHARP_ instanceof cljs.core.Keyword)){
return cljs.core.name(p1__34880_SHARP_);
} else {
return [cljs.core.str(p1__34880_SHARP_)].join('');
}
}));
});
/**
 * Recursively apply underscore on all keys of m.
 */
inflections.core.underscore_keys = (function inflections$core$underscore_keys(m){
return inflections.core.transform_keys(m,inflections.core.underscore);
});
/**
 * Initialize the Inflections library with defaults.
 */
inflections.core.init_inflections_BANG_ = (function inflections$core$init_inflections_BANG_(){
inflections.core.init_plural_rules_BANG_();

inflections.core.init_singular_rules_BANG_();

return inflections.core.init_irregular_words_BANG_();
});
inflections.core.init_inflections_BANG_();
