// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('hatti.map.style');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('hatti.ona.forms');
hatti.map.style.user_customizable_styles = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["color",null], null), null);
/**
 * Saturated qualitative palette from colorbrewer.
 * Saturated red+brown disabled due to clash with the :clicked color.
 */
hatti.map.style.qualitative_palette = new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, ["#1f78b4","#33a02c","#6a3d9a","#ffff99","#b15928","#a6cee3","#b2df8a","#fb9a99","#fdbf6f","#cab2d6"], null);
/**
 * Color palette of YlGnBl from colorbrewer.
 */
hatti.map.style.sequential_palette = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["#ffffcc","#bdd7e7","#6baed6","#3182bd","#08519c"], null);
/**
 * A Grey Color for deselected points.
 */
hatti.map.style.grey = "#d9d9d9";
hatti.map.style.customizable_style_QMARK_ = (function hatti$map$style$customizable_style_QMARK_(p__22861){
var vec__22863 = p__22861;
var style_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22863,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22863,(1),null);
return cljs.core.contains_QMARK_(hatti.map.style.user_customizable_styles,style_name);
});
/**
 * Return a map of a form field answer name to CSS rules
 */
hatti.map.style.get_css_rule_map = (function hatti$map$style$get_css_rule_map(appearance_attribute){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__22867){
var vec__22868 = p__22867;
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22868,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22868,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(key),value], null);
}),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.map.style.customizable_style_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__22864_SHARP_){
return clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__22864_SHARP_,/:/);
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(appearance_attribute,/;/)))));
});
/**
 * Return a map 
 */
hatti.map.style.group_user_defined_styles_by_answer = (function hatti$map$style$group_user_defined_styles_by_answer(p__22869){
var map__22875 = p__22869;
var map__22875__$1 = ((((!((map__22875 == null)))?((((map__22875.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22875.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22875):map__22875);
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22875__$1,cljs.core.cst$kw$children);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.merge,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__22875,map__22875__$1,children){
return (function (p__22877){
var map__22878 = p__22877;
var map__22878__$1 = ((((!((map__22878 == null)))?((((map__22878.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22878.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22878):map__22878);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22878__$1,cljs.core.cst$kw$name);
var appearance = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22878__$1,cljs.core.cst$kw$appearance);
return cljs.core.PersistentArrayMap.fromArray([name,hatti.map.style.get_css_rule_map(appearance)], true, false);
});})(map__22875,map__22875__$1,children))
,children));
});
hatti.map.style.style_map__GT_color_map = (function hatti$map$style$style_map__GT_color_map(p__22880){
var vec__22882 = p__22880;
var answer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22882,(0),null);
var style = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22882,(1),null);
return cljs.core.PersistentArrayMap.fromArray([answer,cljs.core.cst$kw$color.cljs$core$IFn$_invoke$arity$1(style)], true, false);
});
hatti.map.style.group_user_defined_colors_by_answer = (function hatti$map$style$group_user_defined_colors_by_answer(field){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.map.style.style_map__GT_color_map,hatti.map.style.group_user_defined_styles_by_answer(field)));
});
/**
 * Return the appropriate set of colors given the field. For a select_one,
 * returns a mapping of answer to color. Returns a string for all other field
 * types
 */
hatti.map.style.field__GT_colors = (function hatti$map$style$field__GT_colors(field){
if(cljs.core.truth_(hatti.ona.forms.select_one_QMARK_(field))){
if((cljs.core.count(cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(field)) <= cljs.core.count(hatti.map.style.qualitative_palette))){
return hatti.map.style.qualitative_palette;
} else {
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("#f30");
}
} else {
if(cljs.core.truth_(hatti.ona.forms.calculate_QMARK_(field))){
return hatti.map.style.qualitative_palette;
} else {
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))){
return hatti.map.style.sequential_palette;
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))){
return hatti.map.style.sequential_palette;
} else {
if(cljs.core.truth_(hatti.ona.forms.text_QMARK_(field))){
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("#f30");
} else {
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_(field))){
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("#f30");
} else {
return null;
}
}
}
}
}
}
});
hatti.map.style.answer__GT_color = (function hatti$map$style$answer__GT_color(p__22883,answers){
var map__22886 = p__22883;
var map__22886__$1 = ((((!((map__22886 == null)))?((((map__22886.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22886.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22886):map__22886);
var field = map__22886__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22886__$1,cljs.core.cst$kw$children);
if(cljs.core.truth_((function (){var and__4557__auto__ = hatti.ona.forms.select_one_QMARK_(field);
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.every_QMARK_(cljs.core.cst$kw$appearance,children);
} else {
return and__4557__auto__;
}
})())){
return hatti.map.style.group_user_defined_colors_by_answer(field);
} else {
return cljs.core.zipmap(answers,hatti.map.style.field__GT_colors(field));

}
});
