// Compiled by ClojureScript 1.7.145 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t_cljs$core$async36064 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async36064 = (function (fn_handler,f,meta36065){
this.fn_handler = fn_handler;
this.f = f;
this.meta36065 = meta36065;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async36064.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_36066,meta36065__$1){
var self__ = this;
var _36066__$1 = this;
return (new cljs.core.async.t_cljs$core$async36064(self__.fn_handler,self__.f,meta36065__$1));
});

cljs.core.async.t_cljs$core$async36064.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_36066){
var self__ = this;
var _36066__$1 = this;
return self__.meta36065;
});

cljs.core.async.t_cljs$core$async36064.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async36064.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async36064.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async36064.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$fn_DASH_handler,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f], null)))], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$meta36065], null);
});

cljs.core.async.t_cljs$core$async36064.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async36064.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async36064";

cljs.core.async.t_cljs$core$async36064.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async36064");
});

cljs.core.async.__GT_t_cljs$core$async36064 = (function cljs$core$async$fn_handler_$___GT_t_cljs$core$async36064(fn_handler__$1,f__$1,meta36065){
return (new cljs.core.async.t_cljs$core$async36064(fn_handler__$1,f__$1,meta36065));
});

}

return (new cljs.core.async.t_cljs$core$async36064(cljs$core$async$fn_handler,f,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args36069 = [];
var len__5627__auto___36072 = arguments.length;
var i__5628__auto___36073 = (0);
while(true){
if((i__5628__auto___36073 < len__5627__auto___36072)){
args36069.push((arguments[i__5628__auto___36073]));

var G__36074 = (i__5628__auto___36073 + (1));
i__5628__auto___36073 = G__36074;
continue;
} else {
}
break;
}

var G__36071 = args36069.length;
switch (G__36071) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36069.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$sym$buf_DASH_or_DASH_n], 0)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args36076 = [];
var len__5627__auto___36079 = arguments.length;
var i__5628__auto___36080 = (0);
while(true){
if((i__5628__auto___36080 < len__5627__auto___36079)){
args36076.push((arguments[i__5628__auto___36080]));

var G__36081 = (i__5628__auto___36080 + (1));
i__5628__auto___36080 = G__36081;
continue;
} else {
}
break;
}

var G__36078 = args36076.length;
switch (G__36078) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36076.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(ret)){
var val_36083 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_36083) : fn1.call(null,val_36083));
} else {
cljs.core.async.impl.dispatch.run(((function (val_36083,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_36083) : fn1.call(null,val_36083));
});})(val_36083,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args36084 = [];
var len__5627__auto___36087 = arguments.length;
var i__5628__auto___36088 = (0);
while(true){
if((i__5628__auto___36088 < len__5627__auto___36087)){
args36084.push((arguments[i__5628__auto___36088]));

var G__36089 = (i__5628__auto___36088 + (1));
i__5628__auto___36088 = G__36089;
continue;
} else {
}
break;
}

var G__36086 = args36084.length;
switch (G__36086) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36084.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4423__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5472__auto___36091 = n;
var x_36092 = (0);
while(true){
if((x_36092 < n__5472__auto___36091)){
(a[x_36092] = (0));

var G__36093 = (x_36092 + (1));
x_36092 = G__36093;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__36094 = (i + (1));
i = G__36094;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async36098 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async36098 = (function (alt_flag,flag,meta36099){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta36099 = meta36099;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async36098.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_36100,meta36099__$1){
var self__ = this;
var _36100__$1 = this;
return (new cljs.core.async.t_cljs$core$async36098(self__.alt_flag,self__.flag,meta36099__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async36098.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_36100){
var self__ = this;
var _36100__$1 = this;
return self__.meta36099;
});})(flag))
;

cljs.core.async.t_cljs$core$async36098.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async36098.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async36098.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async36098.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_flag,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$meta36099], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async36098.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async36098.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async36098";

cljs.core.async.t_cljs$core$async36098.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async36098");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async36098 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async36098(alt_flag__$1,flag__$1,meta36099){
return (new cljs.core.async.t_cljs$core$async36098(alt_flag__$1,flag__$1,meta36099));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async36098(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async36104 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async36104 = (function (alt_handler,flag,cb,meta36105){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta36105 = meta36105;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async36104.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_36106,meta36105__$1){
var self__ = this;
var _36106__$1 = this;
return (new cljs.core.async.t_cljs$core$async36104(self__.alt_handler,self__.flag,self__.cb,meta36105__$1));
});

cljs.core.async.t_cljs$core$async36104.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_36106){
var self__ = this;
var _36106__$1 = this;
return self__.meta36105;
});

cljs.core.async.t_cljs$core$async36104.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async36104.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async36104.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async36104.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_handler,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb], null)))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta36105], null);
});

cljs.core.async.t_cljs$core$async36104.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async36104.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async36104";

cljs.core.async.t_cljs$core$async36104.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async36104");
});

cljs.core.async.__GT_t_cljs$core$async36104 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async36104(alt_handler__$1,flag__$1,cb__$1,meta36105){
return (new cljs.core.async.t_cljs$core$async36104(alt_handler__$1,flag__$1,cb__$1,meta36105));
});

}

return (new cljs.core.async.t_cljs$core$async36104(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__36107_SHARP_){
var G__36111 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__36107_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__36111) : fret.call(null,G__36111));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__36108_SHARP_){
var G__36112 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__36108_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__36112) : fret.call(null,G__36112));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__4569__auto__ = wport;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return port;
}
})()], null));
} else {
var G__36113 = (i + (1));
i = G__36113;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4569__auto__ = ret;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__4425__auto__ = (function (){var and__4557__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___36119 = arguments.length;
var i__5628__auto___36120 = (0);
while(true){
if((i__5628__auto___36120 < len__5627__auto___36119)){
args__5634__auto__.push((arguments[i__5628__auto___36120]));

var G__36121 = (i__5628__auto___36120 + (1));
i__5628__auto___36120 = G__36121;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__36116){
var map__36117 = p__36116;
var map__36117__$1 = ((((!((map__36117 == null)))?((((map__36117.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36117.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36117):map__36117);
var opts = map__36117__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq36114){
var G__36115 = cljs.core.first(seq36114);
var seq36114__$1 = cljs.core.next(seq36114);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__36115,seq36114__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args36122 = [];
var len__5627__auto___36172 = arguments.length;
var i__5628__auto___36173 = (0);
while(true){
if((i__5628__auto___36173 < len__5627__auto___36172)){
args36122.push((arguments[i__5628__auto___36173]));

var G__36174 = (i__5628__auto___36173 + (1));
i__5628__auto___36173 = G__36174;
continue;
} else {
}
break;
}

var G__36124 = args36122.length;
switch (G__36124) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36122.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__8429__auto___36176 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8429__auto___36176){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___36176){
return (function (state_36148){
var state_val_36149 = (state_36148[(1)]);
if((state_val_36149 === (7))){
var inst_36144 = (state_36148[(2)]);
var state_36148__$1 = state_36148;
var statearr_36150_36177 = state_36148__$1;
(statearr_36150_36177[(2)] = inst_36144);

(statearr_36150_36177[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36149 === (1))){
var state_36148__$1 = state_36148;
var statearr_36151_36178 = state_36148__$1;
(statearr_36151_36178[(2)] = null);

(statearr_36151_36178[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36149 === (4))){
var inst_36127 = (state_36148[(7)]);
var inst_36127__$1 = (state_36148[(2)]);
var inst_36128 = (inst_36127__$1 == null);
var state_36148__$1 = (function (){var statearr_36152 = state_36148;
(statearr_36152[(7)] = inst_36127__$1);

return statearr_36152;
})();
if(cljs.core.truth_(inst_36128)){
var statearr_36153_36179 = state_36148__$1;
(statearr_36153_36179[(1)] = (5));

} else {
var statearr_36154_36180 = state_36148__$1;
(statearr_36154_36180[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36149 === (13))){
var state_36148__$1 = state_36148;
var statearr_36155_36181 = state_36148__$1;
(statearr_36155_36181[(2)] = null);

(statearr_36155_36181[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36149 === (6))){
var inst_36127 = (state_36148[(7)]);
var state_36148__$1 = state_36148;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36148__$1,(11),to,inst_36127);
} else {
if((state_val_36149 === (3))){
var inst_36146 = (state_36148[(2)]);
var state_36148__$1 = state_36148;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36148__$1,inst_36146);
} else {
if((state_val_36149 === (12))){
var state_36148__$1 = state_36148;
var statearr_36156_36182 = state_36148__$1;
(statearr_36156_36182[(2)] = null);

(statearr_36156_36182[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36149 === (2))){
var state_36148__$1 = state_36148;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36148__$1,(4),from);
} else {
if((state_val_36149 === (11))){
var inst_36137 = (state_36148[(2)]);
var state_36148__$1 = state_36148;
if(cljs.core.truth_(inst_36137)){
var statearr_36157_36183 = state_36148__$1;
(statearr_36157_36183[(1)] = (12));

} else {
var statearr_36158_36184 = state_36148__$1;
(statearr_36158_36184[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36149 === (9))){
var state_36148__$1 = state_36148;
var statearr_36159_36185 = state_36148__$1;
(statearr_36159_36185[(2)] = null);

(statearr_36159_36185[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36149 === (5))){
var state_36148__$1 = state_36148;
if(cljs.core.truth_(close_QMARK_)){
var statearr_36160_36186 = state_36148__$1;
(statearr_36160_36186[(1)] = (8));

} else {
var statearr_36161_36187 = state_36148__$1;
(statearr_36161_36187[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36149 === (14))){
var inst_36142 = (state_36148[(2)]);
var state_36148__$1 = state_36148;
var statearr_36162_36188 = state_36148__$1;
(statearr_36162_36188[(2)] = inst_36142);

(statearr_36162_36188[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36149 === (10))){
var inst_36134 = (state_36148[(2)]);
var state_36148__$1 = state_36148;
var statearr_36163_36189 = state_36148__$1;
(statearr_36163_36189[(2)] = inst_36134);

(statearr_36163_36189[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36149 === (8))){
var inst_36131 = cljs.core.async.close_BANG_(to);
var state_36148__$1 = state_36148;
var statearr_36164_36190 = state_36148__$1;
(statearr_36164_36190[(2)] = inst_36131);

(statearr_36164_36190[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto___36176))
;
return ((function (switch__8364__auto__,c__8429__auto___36176){
return (function() {
var cljs$core$async$state_machine__8365__auto__ = null;
var cljs$core$async$state_machine__8365__auto____0 = (function (){
var statearr_36168 = [null,null,null,null,null,null,null,null];
(statearr_36168[(0)] = cljs$core$async$state_machine__8365__auto__);

(statearr_36168[(1)] = (1));

return statearr_36168;
});
var cljs$core$async$state_machine__8365__auto____1 = (function (state_36148){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_36148);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e36169){if((e36169 instanceof Object)){
var ex__8368__auto__ = e36169;
var statearr_36170_36191 = state_36148;
(statearr_36170_36191[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36148);

return cljs.core.cst$kw$recur;
} else {
throw e36169;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__36192 = state_36148;
state_36148 = G__36192;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$state_machine__8365__auto__ = function(state_36148){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8365__auto____1.call(this,state_36148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8365__auto____0;
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8365__auto____1;
return cljs$core$async$state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___36176))
})();
var state__8431__auto__ = (function (){var statearr_36171 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_36171[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___36176);

return statearr_36171;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});})(c__8429__auto___36176))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(cljs.core.cst$sym$pos_QMARK_,cljs.core.cst$sym$n)], 0)))].join('')));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__36376){
var vec__36377 = p__36376;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36377,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36377,(1),null);
var job = vec__36377;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__8429__auto___36559 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8429__auto___36559,res,vec__36377,v,p,job,jobs,results){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___36559,res,vec__36377,v,p,job,jobs,results){
return (function (state_36382){
var state_val_36383 = (state_36382[(1)]);
if((state_val_36383 === (1))){
var state_36382__$1 = state_36382;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36382__$1,(2),res,v);
} else {
if((state_val_36383 === (2))){
var inst_36379 = (state_36382[(2)]);
var inst_36380 = cljs.core.async.close_BANG_(res);
var state_36382__$1 = (function (){var statearr_36384 = state_36382;
(statearr_36384[(7)] = inst_36379);

return statearr_36384;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_36382__$1,inst_36380);
} else {
return null;
}
}
});})(c__8429__auto___36559,res,vec__36377,v,p,job,jobs,results))
;
return ((function (switch__8364__auto__,c__8429__auto___36559,res,vec__36377,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0 = (function (){
var statearr_36388 = [null,null,null,null,null,null,null,null];
(statearr_36388[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__);

(statearr_36388[(1)] = (1));

return statearr_36388;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1 = (function (state_36382){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_36382);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e36389){if((e36389 instanceof Object)){
var ex__8368__auto__ = e36389;
var statearr_36390_36560 = state_36382;
(statearr_36390_36560[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36382);

return cljs.core.cst$kw$recur;
} else {
throw e36389;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__36561 = state_36382;
state_36382 = G__36561;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__ = function(state_36382){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1.call(this,state_36382);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___36559,res,vec__36377,v,p,job,jobs,results))
})();
var state__8431__auto__ = (function (){var statearr_36391 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_36391[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___36559);

return statearr_36391;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});})(c__8429__auto___36559,res,vec__36377,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__36392){
var vec__36393 = p__36392;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36393,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36393,(1),null);
var job = vec__36393;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__5472__auto___36562 = n;
var __36563 = (0);
while(true){
if((__36563 < n__5472__auto___36562)){
var G__36394_36564 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__36394_36564) {
case "compute":
var c__8429__auto___36566 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__36563,c__8429__auto___36566,G__36394_36564,n__5472__auto___36562,jobs,results,process,async){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (__36563,c__8429__auto___36566,G__36394_36564,n__5472__auto___36562,jobs,results,process,async){
return (function (state_36407){
var state_val_36408 = (state_36407[(1)]);
if((state_val_36408 === (1))){
var state_36407__$1 = state_36407;
var statearr_36409_36567 = state_36407__$1;
(statearr_36409_36567[(2)] = null);

(statearr_36409_36567[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36408 === (2))){
var state_36407__$1 = state_36407;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36407__$1,(4),jobs);
} else {
if((state_val_36408 === (3))){
var inst_36405 = (state_36407[(2)]);
var state_36407__$1 = state_36407;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36407__$1,inst_36405);
} else {
if((state_val_36408 === (4))){
var inst_36397 = (state_36407[(2)]);
var inst_36398 = process(inst_36397);
var state_36407__$1 = state_36407;
if(cljs.core.truth_(inst_36398)){
var statearr_36410_36568 = state_36407__$1;
(statearr_36410_36568[(1)] = (5));

} else {
var statearr_36411_36569 = state_36407__$1;
(statearr_36411_36569[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36408 === (5))){
var state_36407__$1 = state_36407;
var statearr_36412_36570 = state_36407__$1;
(statearr_36412_36570[(2)] = null);

(statearr_36412_36570[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36408 === (6))){
var state_36407__$1 = state_36407;
var statearr_36413_36571 = state_36407__$1;
(statearr_36413_36571[(2)] = null);

(statearr_36413_36571[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36408 === (7))){
var inst_36403 = (state_36407[(2)]);
var state_36407__$1 = state_36407;
var statearr_36414_36572 = state_36407__$1;
(statearr_36414_36572[(2)] = inst_36403);

(statearr_36414_36572[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__36563,c__8429__auto___36566,G__36394_36564,n__5472__auto___36562,jobs,results,process,async))
;
return ((function (__36563,switch__8364__auto__,c__8429__auto___36566,G__36394_36564,n__5472__auto___36562,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0 = (function (){
var statearr_36418 = [null,null,null,null,null,null,null];
(statearr_36418[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__);

(statearr_36418[(1)] = (1));

return statearr_36418;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1 = (function (state_36407){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_36407);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e36419){if((e36419 instanceof Object)){
var ex__8368__auto__ = e36419;
var statearr_36420_36573 = state_36407;
(statearr_36420_36573[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36407);

return cljs.core.cst$kw$recur;
} else {
throw e36419;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__36574 = state_36407;
state_36407 = G__36574;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__ = function(state_36407){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1.call(this,state_36407);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__;
})()
;})(__36563,switch__8364__auto__,c__8429__auto___36566,G__36394_36564,n__5472__auto___36562,jobs,results,process,async))
})();
var state__8431__auto__ = (function (){var statearr_36421 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_36421[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___36566);

return statearr_36421;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});})(__36563,c__8429__auto___36566,G__36394_36564,n__5472__auto___36562,jobs,results,process,async))
);


break;
case "async":
var c__8429__auto___36575 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__36563,c__8429__auto___36575,G__36394_36564,n__5472__auto___36562,jobs,results,process,async){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (__36563,c__8429__auto___36575,G__36394_36564,n__5472__auto___36562,jobs,results,process,async){
return (function (state_36434){
var state_val_36435 = (state_36434[(1)]);
if((state_val_36435 === (1))){
var state_36434__$1 = state_36434;
var statearr_36436_36576 = state_36434__$1;
(statearr_36436_36576[(2)] = null);

(statearr_36436_36576[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36435 === (2))){
var state_36434__$1 = state_36434;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36434__$1,(4),jobs);
} else {
if((state_val_36435 === (3))){
var inst_36432 = (state_36434[(2)]);
var state_36434__$1 = state_36434;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36434__$1,inst_36432);
} else {
if((state_val_36435 === (4))){
var inst_36424 = (state_36434[(2)]);
var inst_36425 = async(inst_36424);
var state_36434__$1 = state_36434;
if(cljs.core.truth_(inst_36425)){
var statearr_36437_36577 = state_36434__$1;
(statearr_36437_36577[(1)] = (5));

} else {
var statearr_36438_36578 = state_36434__$1;
(statearr_36438_36578[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36435 === (5))){
var state_36434__$1 = state_36434;
var statearr_36439_36579 = state_36434__$1;
(statearr_36439_36579[(2)] = null);

(statearr_36439_36579[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36435 === (6))){
var state_36434__$1 = state_36434;
var statearr_36440_36580 = state_36434__$1;
(statearr_36440_36580[(2)] = null);

(statearr_36440_36580[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36435 === (7))){
var inst_36430 = (state_36434[(2)]);
var state_36434__$1 = state_36434;
var statearr_36441_36581 = state_36434__$1;
(statearr_36441_36581[(2)] = inst_36430);

(statearr_36441_36581[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__36563,c__8429__auto___36575,G__36394_36564,n__5472__auto___36562,jobs,results,process,async))
;
return ((function (__36563,switch__8364__auto__,c__8429__auto___36575,G__36394_36564,n__5472__auto___36562,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0 = (function (){
var statearr_36445 = [null,null,null,null,null,null,null];
(statearr_36445[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__);

(statearr_36445[(1)] = (1));

return statearr_36445;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1 = (function (state_36434){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_36434);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e36446){if((e36446 instanceof Object)){
var ex__8368__auto__ = e36446;
var statearr_36447_36582 = state_36434;
(statearr_36447_36582[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36434);

return cljs.core.cst$kw$recur;
} else {
throw e36446;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__36583 = state_36434;
state_36434 = G__36583;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__ = function(state_36434){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1.call(this,state_36434);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__;
})()
;})(__36563,switch__8364__auto__,c__8429__auto___36575,G__36394_36564,n__5472__auto___36562,jobs,results,process,async))
})();
var state__8431__auto__ = (function (){var statearr_36448 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_36448[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___36575);

return statearr_36448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});})(__36563,c__8429__auto___36575,G__36394_36564,n__5472__auto___36562,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__36584 = (__36563 + (1));
__36563 = G__36584;
continue;
} else {
}
break;
}

var c__8429__auto___36585 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8429__auto___36585,jobs,results,process,async){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___36585,jobs,results,process,async){
return (function (state_36470){
var state_val_36471 = (state_36470[(1)]);
if((state_val_36471 === (1))){
var state_36470__$1 = state_36470;
var statearr_36472_36586 = state_36470__$1;
(statearr_36472_36586[(2)] = null);

(statearr_36472_36586[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36471 === (2))){
var state_36470__$1 = state_36470;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36470__$1,(4),from);
} else {
if((state_val_36471 === (3))){
var inst_36468 = (state_36470[(2)]);
var state_36470__$1 = state_36470;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36470__$1,inst_36468);
} else {
if((state_val_36471 === (4))){
var inst_36451 = (state_36470[(7)]);
var inst_36451__$1 = (state_36470[(2)]);
var inst_36452 = (inst_36451__$1 == null);
var state_36470__$1 = (function (){var statearr_36473 = state_36470;
(statearr_36473[(7)] = inst_36451__$1);

return statearr_36473;
})();
if(cljs.core.truth_(inst_36452)){
var statearr_36474_36587 = state_36470__$1;
(statearr_36474_36587[(1)] = (5));

} else {
var statearr_36475_36588 = state_36470__$1;
(statearr_36475_36588[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36471 === (5))){
var inst_36454 = cljs.core.async.close_BANG_(jobs);
var state_36470__$1 = state_36470;
var statearr_36476_36589 = state_36470__$1;
(statearr_36476_36589[(2)] = inst_36454);

(statearr_36476_36589[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36471 === (6))){
var inst_36451 = (state_36470[(7)]);
var inst_36456 = (state_36470[(8)]);
var inst_36456__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_36457 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36458 = [inst_36451,inst_36456__$1];
var inst_36459 = (new cljs.core.PersistentVector(null,2,(5),inst_36457,inst_36458,null));
var state_36470__$1 = (function (){var statearr_36477 = state_36470;
(statearr_36477[(8)] = inst_36456__$1);

return statearr_36477;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36470__$1,(8),jobs,inst_36459);
} else {
if((state_val_36471 === (7))){
var inst_36466 = (state_36470[(2)]);
var state_36470__$1 = state_36470;
var statearr_36478_36590 = state_36470__$1;
(statearr_36478_36590[(2)] = inst_36466);

(statearr_36478_36590[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36471 === (8))){
var inst_36456 = (state_36470[(8)]);
var inst_36461 = (state_36470[(2)]);
var state_36470__$1 = (function (){var statearr_36479 = state_36470;
(statearr_36479[(9)] = inst_36461);

return statearr_36479;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36470__$1,(9),results,inst_36456);
} else {
if((state_val_36471 === (9))){
var inst_36463 = (state_36470[(2)]);
var state_36470__$1 = (function (){var statearr_36480 = state_36470;
(statearr_36480[(10)] = inst_36463);

return statearr_36480;
})();
var statearr_36481_36591 = state_36470__$1;
(statearr_36481_36591[(2)] = null);

(statearr_36481_36591[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__8429__auto___36585,jobs,results,process,async))
;
return ((function (switch__8364__auto__,c__8429__auto___36585,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0 = (function (){
var statearr_36485 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_36485[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__);

(statearr_36485[(1)] = (1));

return statearr_36485;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1 = (function (state_36470){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_36470);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e36486){if((e36486 instanceof Object)){
var ex__8368__auto__ = e36486;
var statearr_36487_36592 = state_36470;
(statearr_36487_36592[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36470);

return cljs.core.cst$kw$recur;
} else {
throw e36486;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__36593 = state_36470;
state_36470 = G__36593;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__ = function(state_36470){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1.call(this,state_36470);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___36585,jobs,results,process,async))
})();
var state__8431__auto__ = (function (){var statearr_36488 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_36488[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___36585);

return statearr_36488;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});})(c__8429__auto___36585,jobs,results,process,async))
);


var c__8429__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8429__auto__,jobs,results,process,async){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto__,jobs,results,process,async){
return (function (state_36526){
var state_val_36527 = (state_36526[(1)]);
if((state_val_36527 === (7))){
var inst_36522 = (state_36526[(2)]);
var state_36526__$1 = state_36526;
var statearr_36528_36594 = state_36526__$1;
(statearr_36528_36594[(2)] = inst_36522);

(statearr_36528_36594[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36527 === (20))){
var state_36526__$1 = state_36526;
var statearr_36529_36595 = state_36526__$1;
(statearr_36529_36595[(2)] = null);

(statearr_36529_36595[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36527 === (1))){
var state_36526__$1 = state_36526;
var statearr_36530_36596 = state_36526__$1;
(statearr_36530_36596[(2)] = null);

(statearr_36530_36596[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36527 === (4))){
var inst_36491 = (state_36526[(7)]);
var inst_36491__$1 = (state_36526[(2)]);
var inst_36492 = (inst_36491__$1 == null);
var state_36526__$1 = (function (){var statearr_36531 = state_36526;
(statearr_36531[(7)] = inst_36491__$1);

return statearr_36531;
})();
if(cljs.core.truth_(inst_36492)){
var statearr_36532_36597 = state_36526__$1;
(statearr_36532_36597[(1)] = (5));

} else {
var statearr_36533_36598 = state_36526__$1;
(statearr_36533_36598[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36527 === (15))){
var inst_36504 = (state_36526[(8)]);
var state_36526__$1 = state_36526;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36526__$1,(18),to,inst_36504);
} else {
if((state_val_36527 === (21))){
var inst_36517 = (state_36526[(2)]);
var state_36526__$1 = state_36526;
var statearr_36534_36599 = state_36526__$1;
(statearr_36534_36599[(2)] = inst_36517);

(statearr_36534_36599[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36527 === (13))){
var inst_36519 = (state_36526[(2)]);
var state_36526__$1 = (function (){var statearr_36535 = state_36526;
(statearr_36535[(9)] = inst_36519);

return statearr_36535;
})();
var statearr_36536_36600 = state_36526__$1;
(statearr_36536_36600[(2)] = null);

(statearr_36536_36600[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36527 === (6))){
var inst_36491 = (state_36526[(7)]);
var state_36526__$1 = state_36526;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36526__$1,(11),inst_36491);
} else {
if((state_val_36527 === (17))){
var inst_36512 = (state_36526[(2)]);
var state_36526__$1 = state_36526;
if(cljs.core.truth_(inst_36512)){
var statearr_36537_36601 = state_36526__$1;
(statearr_36537_36601[(1)] = (19));

} else {
var statearr_36538_36602 = state_36526__$1;
(statearr_36538_36602[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36527 === (3))){
var inst_36524 = (state_36526[(2)]);
var state_36526__$1 = state_36526;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36526__$1,inst_36524);
} else {
if((state_val_36527 === (12))){
var inst_36501 = (state_36526[(10)]);
var state_36526__$1 = state_36526;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36526__$1,(14),inst_36501);
} else {
if((state_val_36527 === (2))){
var state_36526__$1 = state_36526;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36526__$1,(4),results);
} else {
if((state_val_36527 === (19))){
var state_36526__$1 = state_36526;
var statearr_36539_36603 = state_36526__$1;
(statearr_36539_36603[(2)] = null);

(statearr_36539_36603[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36527 === (11))){
var inst_36501 = (state_36526[(2)]);
var state_36526__$1 = (function (){var statearr_36540 = state_36526;
(statearr_36540[(10)] = inst_36501);

return statearr_36540;
})();
var statearr_36541_36604 = state_36526__$1;
(statearr_36541_36604[(2)] = null);

(statearr_36541_36604[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36527 === (9))){
var state_36526__$1 = state_36526;
var statearr_36542_36605 = state_36526__$1;
(statearr_36542_36605[(2)] = null);

(statearr_36542_36605[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36527 === (5))){
var state_36526__$1 = state_36526;
if(cljs.core.truth_(close_QMARK_)){
var statearr_36543_36606 = state_36526__$1;
(statearr_36543_36606[(1)] = (8));

} else {
var statearr_36544_36607 = state_36526__$1;
(statearr_36544_36607[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36527 === (14))){
var inst_36504 = (state_36526[(8)]);
var inst_36506 = (state_36526[(11)]);
var inst_36504__$1 = (state_36526[(2)]);
var inst_36505 = (inst_36504__$1 == null);
var inst_36506__$1 = cljs.core.not(inst_36505);
var state_36526__$1 = (function (){var statearr_36545 = state_36526;
(statearr_36545[(8)] = inst_36504__$1);

(statearr_36545[(11)] = inst_36506__$1);

return statearr_36545;
})();
if(inst_36506__$1){
var statearr_36546_36608 = state_36526__$1;
(statearr_36546_36608[(1)] = (15));

} else {
var statearr_36547_36609 = state_36526__$1;
(statearr_36547_36609[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36527 === (16))){
var inst_36506 = (state_36526[(11)]);
var state_36526__$1 = state_36526;
var statearr_36548_36610 = state_36526__$1;
(statearr_36548_36610[(2)] = inst_36506);

(statearr_36548_36610[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36527 === (10))){
var inst_36498 = (state_36526[(2)]);
var state_36526__$1 = state_36526;
var statearr_36549_36611 = state_36526__$1;
(statearr_36549_36611[(2)] = inst_36498);

(statearr_36549_36611[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36527 === (18))){
var inst_36509 = (state_36526[(2)]);
var state_36526__$1 = state_36526;
var statearr_36550_36612 = state_36526__$1;
(statearr_36550_36612[(2)] = inst_36509);

(statearr_36550_36612[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36527 === (8))){
var inst_36495 = cljs.core.async.close_BANG_(to);
var state_36526__$1 = state_36526;
var statearr_36551_36613 = state_36526__$1;
(statearr_36551_36613[(2)] = inst_36495);

(statearr_36551_36613[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto__,jobs,results,process,async))
;
return ((function (switch__8364__auto__,c__8429__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0 = (function (){
var statearr_36555 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36555[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__);

(statearr_36555[(1)] = (1));

return statearr_36555;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1 = (function (state_36526){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_36526);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e36556){if((e36556 instanceof Object)){
var ex__8368__auto__ = e36556;
var statearr_36557_36614 = state_36526;
(statearr_36557_36614[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36526);

return cljs.core.cst$kw$recur;
} else {
throw e36556;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__36615 = state_36526;
state_36526 = G__36615;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__ = function(state_36526){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1.call(this,state_36526);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto__,jobs,results,process,async))
})();
var state__8431__auto__ = (function (){var statearr_36558 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_36558[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto__);

return statearr_36558;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});})(c__8429__auto__,jobs,results,process,async))
);

return c__8429__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args36616 = [];
var len__5627__auto___36619 = arguments.length;
var i__5628__auto___36620 = (0);
while(true){
if((i__5628__auto___36620 < len__5627__auto___36619)){
args36616.push((arguments[i__5628__auto___36620]));

var G__36621 = (i__5628__auto___36620 + (1));
i__5628__auto___36620 = G__36621;
continue;
} else {
}
break;
}

var G__36618 = args36616.length;
switch (G__36618) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36616.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args36623 = [];
var len__5627__auto___36626 = arguments.length;
var i__5628__auto___36627 = (0);
while(true){
if((i__5628__auto___36627 < len__5627__auto___36626)){
args36623.push((arguments[i__5628__auto___36627]));

var G__36628 = (i__5628__auto___36627 + (1));
i__5628__auto___36627 = G__36628;
continue;
} else {
}
break;
}

var G__36625 = args36623.length;
switch (G__36625) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36623.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args36630 = [];
var len__5627__auto___36683 = arguments.length;
var i__5628__auto___36684 = (0);
while(true){
if((i__5628__auto___36684 < len__5627__auto___36683)){
args36630.push((arguments[i__5628__auto___36684]));

var G__36685 = (i__5628__auto___36684 + (1));
i__5628__auto___36684 = G__36685;
continue;
} else {
}
break;
}

var G__36632 = args36630.length;
switch (G__36632) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36630.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__8429__auto___36687 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8429__auto___36687,tc,fc){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___36687,tc,fc){
return (function (state_36658){
var state_val_36659 = (state_36658[(1)]);
if((state_val_36659 === (7))){
var inst_36654 = (state_36658[(2)]);
var state_36658__$1 = state_36658;
var statearr_36660_36688 = state_36658__$1;
(statearr_36660_36688[(2)] = inst_36654);

(statearr_36660_36688[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36659 === (1))){
var state_36658__$1 = state_36658;
var statearr_36661_36689 = state_36658__$1;
(statearr_36661_36689[(2)] = null);

(statearr_36661_36689[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36659 === (4))){
var inst_36635 = (state_36658[(7)]);
var inst_36635__$1 = (state_36658[(2)]);
var inst_36636 = (inst_36635__$1 == null);
var state_36658__$1 = (function (){var statearr_36662 = state_36658;
(statearr_36662[(7)] = inst_36635__$1);

return statearr_36662;
})();
if(cljs.core.truth_(inst_36636)){
var statearr_36663_36690 = state_36658__$1;
(statearr_36663_36690[(1)] = (5));

} else {
var statearr_36664_36691 = state_36658__$1;
(statearr_36664_36691[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36659 === (13))){
var state_36658__$1 = state_36658;
var statearr_36665_36692 = state_36658__$1;
(statearr_36665_36692[(2)] = null);

(statearr_36665_36692[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36659 === (6))){
var inst_36635 = (state_36658[(7)]);
var inst_36641 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_36635) : p.call(null,inst_36635));
var state_36658__$1 = state_36658;
if(cljs.core.truth_(inst_36641)){
var statearr_36666_36693 = state_36658__$1;
(statearr_36666_36693[(1)] = (9));

} else {
var statearr_36667_36694 = state_36658__$1;
(statearr_36667_36694[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36659 === (3))){
var inst_36656 = (state_36658[(2)]);
var state_36658__$1 = state_36658;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36658__$1,inst_36656);
} else {
if((state_val_36659 === (12))){
var state_36658__$1 = state_36658;
var statearr_36668_36695 = state_36658__$1;
(statearr_36668_36695[(2)] = null);

(statearr_36668_36695[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36659 === (2))){
var state_36658__$1 = state_36658;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36658__$1,(4),ch);
} else {
if((state_val_36659 === (11))){
var inst_36635 = (state_36658[(7)]);
var inst_36645 = (state_36658[(2)]);
var state_36658__$1 = state_36658;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36658__$1,(8),inst_36645,inst_36635);
} else {
if((state_val_36659 === (9))){
var state_36658__$1 = state_36658;
var statearr_36669_36696 = state_36658__$1;
(statearr_36669_36696[(2)] = tc);

(statearr_36669_36696[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36659 === (5))){
var inst_36638 = cljs.core.async.close_BANG_(tc);
var inst_36639 = cljs.core.async.close_BANG_(fc);
var state_36658__$1 = (function (){var statearr_36670 = state_36658;
(statearr_36670[(8)] = inst_36638);

return statearr_36670;
})();
var statearr_36671_36697 = state_36658__$1;
(statearr_36671_36697[(2)] = inst_36639);

(statearr_36671_36697[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36659 === (14))){
var inst_36652 = (state_36658[(2)]);
var state_36658__$1 = state_36658;
var statearr_36672_36698 = state_36658__$1;
(statearr_36672_36698[(2)] = inst_36652);

(statearr_36672_36698[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36659 === (10))){
var state_36658__$1 = state_36658;
var statearr_36673_36699 = state_36658__$1;
(statearr_36673_36699[(2)] = fc);

(statearr_36673_36699[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36659 === (8))){
var inst_36647 = (state_36658[(2)]);
var state_36658__$1 = state_36658;
if(cljs.core.truth_(inst_36647)){
var statearr_36674_36700 = state_36658__$1;
(statearr_36674_36700[(1)] = (12));

} else {
var statearr_36675_36701 = state_36658__$1;
(statearr_36675_36701[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto___36687,tc,fc))
;
return ((function (switch__8364__auto__,c__8429__auto___36687,tc,fc){
return (function() {
var cljs$core$async$state_machine__8365__auto__ = null;
var cljs$core$async$state_machine__8365__auto____0 = (function (){
var statearr_36679 = [null,null,null,null,null,null,null,null,null];
(statearr_36679[(0)] = cljs$core$async$state_machine__8365__auto__);

(statearr_36679[(1)] = (1));

return statearr_36679;
});
var cljs$core$async$state_machine__8365__auto____1 = (function (state_36658){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_36658);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e36680){if((e36680 instanceof Object)){
var ex__8368__auto__ = e36680;
var statearr_36681_36702 = state_36658;
(statearr_36681_36702[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36658);

return cljs.core.cst$kw$recur;
} else {
throw e36680;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__36703 = state_36658;
state_36658 = G__36703;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$state_machine__8365__auto__ = function(state_36658){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8365__auto____1.call(this,state_36658);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8365__auto____0;
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8365__auto____1;
return cljs$core$async$state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___36687,tc,fc))
})();
var state__8431__auto__ = (function (){var statearr_36682 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_36682[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___36687);

return statearr_36682;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});})(c__8429__auto___36687,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__8429__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8429__auto__){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto__){
return (function (state_36750){
var state_val_36751 = (state_36750[(1)]);
if((state_val_36751 === (1))){
var inst_36736 = init;
var state_36750__$1 = (function (){var statearr_36752 = state_36750;
(statearr_36752[(7)] = inst_36736);

return statearr_36752;
})();
var statearr_36753_36768 = state_36750__$1;
(statearr_36753_36768[(2)] = null);

(statearr_36753_36768[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36751 === (2))){
var state_36750__$1 = state_36750;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36750__$1,(4),ch);
} else {
if((state_val_36751 === (3))){
var inst_36748 = (state_36750[(2)]);
var state_36750__$1 = state_36750;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36750__$1,inst_36748);
} else {
if((state_val_36751 === (4))){
var inst_36739 = (state_36750[(8)]);
var inst_36739__$1 = (state_36750[(2)]);
var inst_36740 = (inst_36739__$1 == null);
var state_36750__$1 = (function (){var statearr_36754 = state_36750;
(statearr_36754[(8)] = inst_36739__$1);

return statearr_36754;
})();
if(cljs.core.truth_(inst_36740)){
var statearr_36755_36769 = state_36750__$1;
(statearr_36755_36769[(1)] = (5));

} else {
var statearr_36756_36770 = state_36750__$1;
(statearr_36756_36770[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36751 === (5))){
var inst_36736 = (state_36750[(7)]);
var state_36750__$1 = state_36750;
var statearr_36757_36771 = state_36750__$1;
(statearr_36757_36771[(2)] = inst_36736);

(statearr_36757_36771[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36751 === (6))){
var inst_36736 = (state_36750[(7)]);
var inst_36739 = (state_36750[(8)]);
var inst_36743 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_36736,inst_36739) : f.call(null,inst_36736,inst_36739));
var inst_36736__$1 = inst_36743;
var state_36750__$1 = (function (){var statearr_36758 = state_36750;
(statearr_36758[(7)] = inst_36736__$1);

return statearr_36758;
})();
var statearr_36759_36772 = state_36750__$1;
(statearr_36759_36772[(2)] = null);

(statearr_36759_36772[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36751 === (7))){
var inst_36746 = (state_36750[(2)]);
var state_36750__$1 = state_36750;
var statearr_36760_36773 = state_36750__$1;
(statearr_36760_36773[(2)] = inst_36746);

(statearr_36760_36773[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__8429__auto__))
;
return ((function (switch__8364__auto__,c__8429__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__8365__auto__ = null;
var cljs$core$async$reduce_$_state_machine__8365__auto____0 = (function (){
var statearr_36764 = [null,null,null,null,null,null,null,null,null];
(statearr_36764[(0)] = cljs$core$async$reduce_$_state_machine__8365__auto__);

(statearr_36764[(1)] = (1));

return statearr_36764;
});
var cljs$core$async$reduce_$_state_machine__8365__auto____1 = (function (state_36750){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_36750);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e36765){if((e36765 instanceof Object)){
var ex__8368__auto__ = e36765;
var statearr_36766_36774 = state_36750;
(statearr_36766_36774[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36750);

return cljs.core.cst$kw$recur;
} else {
throw e36765;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__36775 = state_36750;
state_36750 = G__36775;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__8365__auto__ = function(state_36750){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__8365__auto____1.call(this,state_36750);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__8365__auto____0;
cljs$core$async$reduce_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__8365__auto____1;
return cljs$core$async$reduce_$_state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto__))
})();
var state__8431__auto__ = (function (){var statearr_36767 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_36767[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto__);

return statearr_36767;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});})(c__8429__auto__))
);

return c__8429__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args36776 = [];
var len__5627__auto___36828 = arguments.length;
var i__5628__auto___36829 = (0);
while(true){
if((i__5628__auto___36829 < len__5627__auto___36828)){
args36776.push((arguments[i__5628__auto___36829]));

var G__36830 = (i__5628__auto___36829 + (1));
i__5628__auto___36829 = G__36830;
continue;
} else {
}
break;
}

var G__36778 = args36776.length;
switch (G__36778) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36776.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__8429__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8429__auto__){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto__){
return (function (state_36803){
var state_val_36804 = (state_36803[(1)]);
if((state_val_36804 === (7))){
var inst_36785 = (state_36803[(2)]);
var state_36803__$1 = state_36803;
var statearr_36805_36832 = state_36803__$1;
(statearr_36805_36832[(2)] = inst_36785);

(statearr_36805_36832[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36804 === (1))){
var inst_36779 = cljs.core.seq(coll);
var inst_36780 = inst_36779;
var state_36803__$1 = (function (){var statearr_36806 = state_36803;
(statearr_36806[(7)] = inst_36780);

return statearr_36806;
})();
var statearr_36807_36833 = state_36803__$1;
(statearr_36807_36833[(2)] = null);

(statearr_36807_36833[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36804 === (4))){
var inst_36780 = (state_36803[(7)]);
var inst_36783 = cljs.core.first(inst_36780);
var state_36803__$1 = state_36803;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36803__$1,(7),ch,inst_36783);
} else {
if((state_val_36804 === (13))){
var inst_36797 = (state_36803[(2)]);
var state_36803__$1 = state_36803;
var statearr_36808_36834 = state_36803__$1;
(statearr_36808_36834[(2)] = inst_36797);

(statearr_36808_36834[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36804 === (6))){
var inst_36788 = (state_36803[(2)]);
var state_36803__$1 = state_36803;
if(cljs.core.truth_(inst_36788)){
var statearr_36809_36835 = state_36803__$1;
(statearr_36809_36835[(1)] = (8));

} else {
var statearr_36810_36836 = state_36803__$1;
(statearr_36810_36836[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36804 === (3))){
var inst_36801 = (state_36803[(2)]);
var state_36803__$1 = state_36803;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36803__$1,inst_36801);
} else {
if((state_val_36804 === (12))){
var state_36803__$1 = state_36803;
var statearr_36811_36837 = state_36803__$1;
(statearr_36811_36837[(2)] = null);

(statearr_36811_36837[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36804 === (2))){
var inst_36780 = (state_36803[(7)]);
var state_36803__$1 = state_36803;
if(cljs.core.truth_(inst_36780)){
var statearr_36812_36838 = state_36803__$1;
(statearr_36812_36838[(1)] = (4));

} else {
var statearr_36813_36839 = state_36803__$1;
(statearr_36813_36839[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36804 === (11))){
var inst_36794 = cljs.core.async.close_BANG_(ch);
var state_36803__$1 = state_36803;
var statearr_36814_36840 = state_36803__$1;
(statearr_36814_36840[(2)] = inst_36794);

(statearr_36814_36840[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36804 === (9))){
var state_36803__$1 = state_36803;
if(cljs.core.truth_(close_QMARK_)){
var statearr_36815_36841 = state_36803__$1;
(statearr_36815_36841[(1)] = (11));

} else {
var statearr_36816_36842 = state_36803__$1;
(statearr_36816_36842[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36804 === (5))){
var inst_36780 = (state_36803[(7)]);
var state_36803__$1 = state_36803;
var statearr_36817_36843 = state_36803__$1;
(statearr_36817_36843[(2)] = inst_36780);

(statearr_36817_36843[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36804 === (10))){
var inst_36799 = (state_36803[(2)]);
var state_36803__$1 = state_36803;
var statearr_36818_36844 = state_36803__$1;
(statearr_36818_36844[(2)] = inst_36799);

(statearr_36818_36844[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36804 === (8))){
var inst_36780 = (state_36803[(7)]);
var inst_36790 = cljs.core.next(inst_36780);
var inst_36780__$1 = inst_36790;
var state_36803__$1 = (function (){var statearr_36819 = state_36803;
(statearr_36819[(7)] = inst_36780__$1);

return statearr_36819;
})();
var statearr_36820_36845 = state_36803__$1;
(statearr_36820_36845[(2)] = null);

(statearr_36820_36845[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto__))
;
return ((function (switch__8364__auto__,c__8429__auto__){
return (function() {
var cljs$core$async$state_machine__8365__auto__ = null;
var cljs$core$async$state_machine__8365__auto____0 = (function (){
var statearr_36824 = [null,null,null,null,null,null,null,null];
(statearr_36824[(0)] = cljs$core$async$state_machine__8365__auto__);

(statearr_36824[(1)] = (1));

return statearr_36824;
});
var cljs$core$async$state_machine__8365__auto____1 = (function (state_36803){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_36803);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e36825){if((e36825 instanceof Object)){
var ex__8368__auto__ = e36825;
var statearr_36826_36846 = state_36803;
(statearr_36826_36846[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36803);

return cljs.core.cst$kw$recur;
} else {
throw e36825;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__36847 = state_36803;
state_36803 = G__36847;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$state_machine__8365__auto__ = function(state_36803){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8365__auto____1.call(this,state_36803);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8365__auto____0;
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8365__auto____1;
return cljs$core$async$state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto__))
})();
var state__8431__auto__ = (function (){var statearr_36827 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_36827[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto__);

return statearr_36827;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});})(c__8429__auto__))
);

return c__8429__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5224__auto__ = (((_ == null))?null:_);
var m__5225__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5225__auto__.call(null,_));
} else {
var m__5225__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__5225__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5225__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__5225__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5225__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto__.call(null,m,ch));
} else {
var m__5225__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5225__auto__.call(null,m));
} else {
var m__5225__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__5225__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__37072 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__37072) : cljs.core.atom.call(null,G__37072));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async37073 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37073 = (function (mult,ch,cs,meta37074){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta37074 = meta37074;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async37073.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_37075,meta37074__$1){
var self__ = this;
var _37075__$1 = this;
return (new cljs.core.async.t_cljs$core$async37073(self__.mult,self__.ch,self__.cs,meta37074__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async37073.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_37075){
var self__ = this;
var _37075__$1 = this;
return self__.meta37074;
});})(cs))
;

cljs.core.async.t_cljs$core$async37073.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async37073.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async37073.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async37073.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async37073.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async37073.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__37076_37296 = self__.cs;
var G__37077_37297 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__37076_37296,G__37077_37297) : cljs.core.reset_BANG_.call(null,G__37076_37296,G__37077_37297));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async37073.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mult,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta37074], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async37073.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async37073.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37073";

cljs.core.async.t_cljs$core$async37073.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async37073");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async37073 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async37073(mult__$1,ch__$1,cs__$1,meta37074){
return (new cljs.core.async.t_cljs$core$async37073(mult__$1,ch__$1,cs__$1,meta37074));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async37073(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__8429__auto___37298 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8429__auto___37298,cs,m,dchan,dctr,done){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___37298,cs,m,dchan,dctr,done){
return (function (state_37208){
var state_val_37209 = (state_37208[(1)]);
if((state_val_37209 === (7))){
var inst_37204 = (state_37208[(2)]);
var state_37208__$1 = state_37208;
var statearr_37210_37299 = state_37208__$1;
(statearr_37210_37299[(2)] = inst_37204);

(statearr_37210_37299[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (20))){
var inst_37109 = (state_37208[(7)]);
var inst_37119 = cljs.core.first(inst_37109);
var inst_37120 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37119,(0),null);
var inst_37121 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37119,(1),null);
var state_37208__$1 = (function (){var statearr_37211 = state_37208;
(statearr_37211[(8)] = inst_37120);

return statearr_37211;
})();
if(cljs.core.truth_(inst_37121)){
var statearr_37212_37300 = state_37208__$1;
(statearr_37212_37300[(1)] = (22));

} else {
var statearr_37213_37301 = state_37208__$1;
(statearr_37213_37301[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (27))){
var inst_37151 = (state_37208[(9)]);
var inst_37156 = (state_37208[(10)]);
var inst_37149 = (state_37208[(11)]);
var inst_37080 = (state_37208[(12)]);
var inst_37156__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_37149,inst_37151);
var inst_37157 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_37156__$1,inst_37080,done);
var state_37208__$1 = (function (){var statearr_37214 = state_37208;
(statearr_37214[(10)] = inst_37156__$1);

return statearr_37214;
})();
if(cljs.core.truth_(inst_37157)){
var statearr_37215_37302 = state_37208__$1;
(statearr_37215_37302[(1)] = (30));

} else {
var statearr_37216_37303 = state_37208__$1;
(statearr_37216_37303[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (1))){
var state_37208__$1 = state_37208;
var statearr_37217_37304 = state_37208__$1;
(statearr_37217_37304[(2)] = null);

(statearr_37217_37304[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (24))){
var inst_37109 = (state_37208[(7)]);
var inst_37126 = (state_37208[(2)]);
var inst_37127 = cljs.core.next(inst_37109);
var inst_37089 = inst_37127;
var inst_37090 = null;
var inst_37091 = (0);
var inst_37092 = (0);
var state_37208__$1 = (function (){var statearr_37218 = state_37208;
(statearr_37218[(13)] = inst_37090);

(statearr_37218[(14)] = inst_37126);

(statearr_37218[(15)] = inst_37089);

(statearr_37218[(16)] = inst_37091);

(statearr_37218[(17)] = inst_37092);

return statearr_37218;
})();
var statearr_37219_37305 = state_37208__$1;
(statearr_37219_37305[(2)] = null);

(statearr_37219_37305[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (39))){
var state_37208__$1 = state_37208;
var statearr_37223_37306 = state_37208__$1;
(statearr_37223_37306[(2)] = null);

(statearr_37223_37306[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (4))){
var inst_37080 = (state_37208[(12)]);
var inst_37080__$1 = (state_37208[(2)]);
var inst_37081 = (inst_37080__$1 == null);
var state_37208__$1 = (function (){var statearr_37224 = state_37208;
(statearr_37224[(12)] = inst_37080__$1);

return statearr_37224;
})();
if(cljs.core.truth_(inst_37081)){
var statearr_37225_37307 = state_37208__$1;
(statearr_37225_37307[(1)] = (5));

} else {
var statearr_37226_37308 = state_37208__$1;
(statearr_37226_37308[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (15))){
var inst_37090 = (state_37208[(13)]);
var inst_37089 = (state_37208[(15)]);
var inst_37091 = (state_37208[(16)]);
var inst_37092 = (state_37208[(17)]);
var inst_37105 = (state_37208[(2)]);
var inst_37106 = (inst_37092 + (1));
var tmp37220 = inst_37090;
var tmp37221 = inst_37089;
var tmp37222 = inst_37091;
var inst_37089__$1 = tmp37221;
var inst_37090__$1 = tmp37220;
var inst_37091__$1 = tmp37222;
var inst_37092__$1 = inst_37106;
var state_37208__$1 = (function (){var statearr_37227 = state_37208;
(statearr_37227[(13)] = inst_37090__$1);

(statearr_37227[(15)] = inst_37089__$1);

(statearr_37227[(16)] = inst_37091__$1);

(statearr_37227[(18)] = inst_37105);

(statearr_37227[(17)] = inst_37092__$1);

return statearr_37227;
})();
var statearr_37228_37309 = state_37208__$1;
(statearr_37228_37309[(2)] = null);

(statearr_37228_37309[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (21))){
var inst_37130 = (state_37208[(2)]);
var state_37208__$1 = state_37208;
var statearr_37232_37310 = state_37208__$1;
(statearr_37232_37310[(2)] = inst_37130);

(statearr_37232_37310[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (31))){
var inst_37156 = (state_37208[(10)]);
var inst_37160 = done(null);
var inst_37161 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_37156);
var state_37208__$1 = (function (){var statearr_37233 = state_37208;
(statearr_37233[(19)] = inst_37160);

return statearr_37233;
})();
var statearr_37234_37311 = state_37208__$1;
(statearr_37234_37311[(2)] = inst_37161);

(statearr_37234_37311[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (32))){
var inst_37148 = (state_37208[(20)]);
var inst_37151 = (state_37208[(9)]);
var inst_37150 = (state_37208[(21)]);
var inst_37149 = (state_37208[(11)]);
var inst_37163 = (state_37208[(2)]);
var inst_37164 = (inst_37151 + (1));
var tmp37229 = inst_37148;
var tmp37230 = inst_37150;
var tmp37231 = inst_37149;
var inst_37148__$1 = tmp37229;
var inst_37149__$1 = tmp37231;
var inst_37150__$1 = tmp37230;
var inst_37151__$1 = inst_37164;
var state_37208__$1 = (function (){var statearr_37235 = state_37208;
(statearr_37235[(20)] = inst_37148__$1);

(statearr_37235[(9)] = inst_37151__$1);

(statearr_37235[(21)] = inst_37150__$1);

(statearr_37235[(11)] = inst_37149__$1);

(statearr_37235[(22)] = inst_37163);

return statearr_37235;
})();
var statearr_37236_37312 = state_37208__$1;
(statearr_37236_37312[(2)] = null);

(statearr_37236_37312[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (40))){
var inst_37176 = (state_37208[(23)]);
var inst_37180 = done(null);
var inst_37181 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_37176);
var state_37208__$1 = (function (){var statearr_37237 = state_37208;
(statearr_37237[(24)] = inst_37180);

return statearr_37237;
})();
var statearr_37238_37313 = state_37208__$1;
(statearr_37238_37313[(2)] = inst_37181);

(statearr_37238_37313[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (33))){
var inst_37167 = (state_37208[(25)]);
var inst_37169 = cljs.core.chunked_seq_QMARK_(inst_37167);
var state_37208__$1 = state_37208;
if(inst_37169){
var statearr_37239_37314 = state_37208__$1;
(statearr_37239_37314[(1)] = (36));

} else {
var statearr_37240_37315 = state_37208__$1;
(statearr_37240_37315[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (13))){
var inst_37099 = (state_37208[(26)]);
var inst_37102 = cljs.core.async.close_BANG_(inst_37099);
var state_37208__$1 = state_37208;
var statearr_37241_37316 = state_37208__$1;
(statearr_37241_37316[(2)] = inst_37102);

(statearr_37241_37316[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (22))){
var inst_37120 = (state_37208[(8)]);
var inst_37123 = cljs.core.async.close_BANG_(inst_37120);
var state_37208__$1 = state_37208;
var statearr_37242_37317 = state_37208__$1;
(statearr_37242_37317[(2)] = inst_37123);

(statearr_37242_37317[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (36))){
var inst_37167 = (state_37208[(25)]);
var inst_37171 = cljs.core.chunk_first(inst_37167);
var inst_37172 = cljs.core.chunk_rest(inst_37167);
var inst_37173 = cljs.core.count(inst_37171);
var inst_37148 = inst_37172;
var inst_37149 = inst_37171;
var inst_37150 = inst_37173;
var inst_37151 = (0);
var state_37208__$1 = (function (){var statearr_37243 = state_37208;
(statearr_37243[(20)] = inst_37148);

(statearr_37243[(9)] = inst_37151);

(statearr_37243[(21)] = inst_37150);

(statearr_37243[(11)] = inst_37149);

return statearr_37243;
})();
var statearr_37244_37318 = state_37208__$1;
(statearr_37244_37318[(2)] = null);

(statearr_37244_37318[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (41))){
var inst_37167 = (state_37208[(25)]);
var inst_37183 = (state_37208[(2)]);
var inst_37184 = cljs.core.next(inst_37167);
var inst_37148 = inst_37184;
var inst_37149 = null;
var inst_37150 = (0);
var inst_37151 = (0);
var state_37208__$1 = (function (){var statearr_37245 = state_37208;
(statearr_37245[(20)] = inst_37148);

(statearr_37245[(9)] = inst_37151);

(statearr_37245[(21)] = inst_37150);

(statearr_37245[(11)] = inst_37149);

(statearr_37245[(27)] = inst_37183);

return statearr_37245;
})();
var statearr_37246_37319 = state_37208__$1;
(statearr_37246_37319[(2)] = null);

(statearr_37246_37319[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (43))){
var state_37208__$1 = state_37208;
var statearr_37247_37320 = state_37208__$1;
(statearr_37247_37320[(2)] = null);

(statearr_37247_37320[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (29))){
var inst_37192 = (state_37208[(2)]);
var state_37208__$1 = state_37208;
var statearr_37248_37321 = state_37208__$1;
(statearr_37248_37321[(2)] = inst_37192);

(statearr_37248_37321[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (44))){
var inst_37201 = (state_37208[(2)]);
var state_37208__$1 = (function (){var statearr_37249 = state_37208;
(statearr_37249[(28)] = inst_37201);

return statearr_37249;
})();
var statearr_37250_37322 = state_37208__$1;
(statearr_37250_37322[(2)] = null);

(statearr_37250_37322[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (6))){
var inst_37140 = (state_37208[(29)]);
var inst_37139 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_37140__$1 = cljs.core.keys(inst_37139);
var inst_37141 = cljs.core.count(inst_37140__$1);
var inst_37142 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_37141) : cljs.core.reset_BANG_.call(null,dctr,inst_37141));
var inst_37147 = cljs.core.seq(inst_37140__$1);
var inst_37148 = inst_37147;
var inst_37149 = null;
var inst_37150 = (0);
var inst_37151 = (0);
var state_37208__$1 = (function (){var statearr_37251 = state_37208;
(statearr_37251[(20)] = inst_37148);

(statearr_37251[(30)] = inst_37142);

(statearr_37251[(9)] = inst_37151);

(statearr_37251[(21)] = inst_37150);

(statearr_37251[(29)] = inst_37140__$1);

(statearr_37251[(11)] = inst_37149);

return statearr_37251;
})();
var statearr_37252_37323 = state_37208__$1;
(statearr_37252_37323[(2)] = null);

(statearr_37252_37323[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (28))){
var inst_37148 = (state_37208[(20)]);
var inst_37167 = (state_37208[(25)]);
var inst_37167__$1 = cljs.core.seq(inst_37148);
var state_37208__$1 = (function (){var statearr_37253 = state_37208;
(statearr_37253[(25)] = inst_37167__$1);

return statearr_37253;
})();
if(inst_37167__$1){
var statearr_37254_37324 = state_37208__$1;
(statearr_37254_37324[(1)] = (33));

} else {
var statearr_37255_37325 = state_37208__$1;
(statearr_37255_37325[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (25))){
var inst_37151 = (state_37208[(9)]);
var inst_37150 = (state_37208[(21)]);
var inst_37153 = (inst_37151 < inst_37150);
var inst_37154 = inst_37153;
var state_37208__$1 = state_37208;
if(cljs.core.truth_(inst_37154)){
var statearr_37256_37326 = state_37208__$1;
(statearr_37256_37326[(1)] = (27));

} else {
var statearr_37257_37327 = state_37208__$1;
(statearr_37257_37327[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (34))){
var state_37208__$1 = state_37208;
var statearr_37258_37328 = state_37208__$1;
(statearr_37258_37328[(2)] = null);

(statearr_37258_37328[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (17))){
var state_37208__$1 = state_37208;
var statearr_37259_37329 = state_37208__$1;
(statearr_37259_37329[(2)] = null);

(statearr_37259_37329[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (3))){
var inst_37206 = (state_37208[(2)]);
var state_37208__$1 = state_37208;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37208__$1,inst_37206);
} else {
if((state_val_37209 === (12))){
var inst_37135 = (state_37208[(2)]);
var state_37208__$1 = state_37208;
var statearr_37260_37330 = state_37208__$1;
(statearr_37260_37330[(2)] = inst_37135);

(statearr_37260_37330[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (2))){
var state_37208__$1 = state_37208;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37208__$1,(4),ch);
} else {
if((state_val_37209 === (23))){
var state_37208__$1 = state_37208;
var statearr_37261_37331 = state_37208__$1;
(statearr_37261_37331[(2)] = null);

(statearr_37261_37331[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (35))){
var inst_37190 = (state_37208[(2)]);
var state_37208__$1 = state_37208;
var statearr_37262_37332 = state_37208__$1;
(statearr_37262_37332[(2)] = inst_37190);

(statearr_37262_37332[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (19))){
var inst_37109 = (state_37208[(7)]);
var inst_37113 = cljs.core.chunk_first(inst_37109);
var inst_37114 = cljs.core.chunk_rest(inst_37109);
var inst_37115 = cljs.core.count(inst_37113);
var inst_37089 = inst_37114;
var inst_37090 = inst_37113;
var inst_37091 = inst_37115;
var inst_37092 = (0);
var state_37208__$1 = (function (){var statearr_37263 = state_37208;
(statearr_37263[(13)] = inst_37090);

(statearr_37263[(15)] = inst_37089);

(statearr_37263[(16)] = inst_37091);

(statearr_37263[(17)] = inst_37092);

return statearr_37263;
})();
var statearr_37264_37333 = state_37208__$1;
(statearr_37264_37333[(2)] = null);

(statearr_37264_37333[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (11))){
var inst_37089 = (state_37208[(15)]);
var inst_37109 = (state_37208[(7)]);
var inst_37109__$1 = cljs.core.seq(inst_37089);
var state_37208__$1 = (function (){var statearr_37265 = state_37208;
(statearr_37265[(7)] = inst_37109__$1);

return statearr_37265;
})();
if(inst_37109__$1){
var statearr_37266_37334 = state_37208__$1;
(statearr_37266_37334[(1)] = (16));

} else {
var statearr_37267_37335 = state_37208__$1;
(statearr_37267_37335[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (9))){
var inst_37137 = (state_37208[(2)]);
var state_37208__$1 = state_37208;
var statearr_37268_37336 = state_37208__$1;
(statearr_37268_37336[(2)] = inst_37137);

(statearr_37268_37336[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (5))){
var inst_37087 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_37088 = cljs.core.seq(inst_37087);
var inst_37089 = inst_37088;
var inst_37090 = null;
var inst_37091 = (0);
var inst_37092 = (0);
var state_37208__$1 = (function (){var statearr_37269 = state_37208;
(statearr_37269[(13)] = inst_37090);

(statearr_37269[(15)] = inst_37089);

(statearr_37269[(16)] = inst_37091);

(statearr_37269[(17)] = inst_37092);

return statearr_37269;
})();
var statearr_37270_37337 = state_37208__$1;
(statearr_37270_37337[(2)] = null);

(statearr_37270_37337[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (14))){
var state_37208__$1 = state_37208;
var statearr_37271_37338 = state_37208__$1;
(statearr_37271_37338[(2)] = null);

(statearr_37271_37338[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (45))){
var inst_37198 = (state_37208[(2)]);
var state_37208__$1 = state_37208;
var statearr_37272_37339 = state_37208__$1;
(statearr_37272_37339[(2)] = inst_37198);

(statearr_37272_37339[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (26))){
var inst_37140 = (state_37208[(29)]);
var inst_37194 = (state_37208[(2)]);
var inst_37195 = cljs.core.seq(inst_37140);
var state_37208__$1 = (function (){var statearr_37273 = state_37208;
(statearr_37273[(31)] = inst_37194);

return statearr_37273;
})();
if(inst_37195){
var statearr_37274_37340 = state_37208__$1;
(statearr_37274_37340[(1)] = (42));

} else {
var statearr_37275_37341 = state_37208__$1;
(statearr_37275_37341[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (16))){
var inst_37109 = (state_37208[(7)]);
var inst_37111 = cljs.core.chunked_seq_QMARK_(inst_37109);
var state_37208__$1 = state_37208;
if(inst_37111){
var statearr_37276_37342 = state_37208__$1;
(statearr_37276_37342[(1)] = (19));

} else {
var statearr_37277_37343 = state_37208__$1;
(statearr_37277_37343[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (38))){
var inst_37187 = (state_37208[(2)]);
var state_37208__$1 = state_37208;
var statearr_37278_37344 = state_37208__$1;
(statearr_37278_37344[(2)] = inst_37187);

(statearr_37278_37344[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (30))){
var state_37208__$1 = state_37208;
var statearr_37279_37345 = state_37208__$1;
(statearr_37279_37345[(2)] = null);

(statearr_37279_37345[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (10))){
var inst_37090 = (state_37208[(13)]);
var inst_37092 = (state_37208[(17)]);
var inst_37098 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_37090,inst_37092);
var inst_37099 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37098,(0),null);
var inst_37100 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37098,(1),null);
var state_37208__$1 = (function (){var statearr_37280 = state_37208;
(statearr_37280[(26)] = inst_37099);

return statearr_37280;
})();
if(cljs.core.truth_(inst_37100)){
var statearr_37281_37346 = state_37208__$1;
(statearr_37281_37346[(1)] = (13));

} else {
var statearr_37282_37347 = state_37208__$1;
(statearr_37282_37347[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (18))){
var inst_37133 = (state_37208[(2)]);
var state_37208__$1 = state_37208;
var statearr_37283_37348 = state_37208__$1;
(statearr_37283_37348[(2)] = inst_37133);

(statearr_37283_37348[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (42))){
var state_37208__$1 = state_37208;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37208__$1,(45),dchan);
} else {
if((state_val_37209 === (37))){
var inst_37176 = (state_37208[(23)]);
var inst_37080 = (state_37208[(12)]);
var inst_37167 = (state_37208[(25)]);
var inst_37176__$1 = cljs.core.first(inst_37167);
var inst_37177 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_37176__$1,inst_37080,done);
var state_37208__$1 = (function (){var statearr_37284 = state_37208;
(statearr_37284[(23)] = inst_37176__$1);

return statearr_37284;
})();
if(cljs.core.truth_(inst_37177)){
var statearr_37285_37349 = state_37208__$1;
(statearr_37285_37349[(1)] = (39));

} else {
var statearr_37286_37350 = state_37208__$1;
(statearr_37286_37350[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37209 === (8))){
var inst_37091 = (state_37208[(16)]);
var inst_37092 = (state_37208[(17)]);
var inst_37094 = (inst_37092 < inst_37091);
var inst_37095 = inst_37094;
var state_37208__$1 = state_37208;
if(cljs.core.truth_(inst_37095)){
var statearr_37287_37351 = state_37208__$1;
(statearr_37287_37351[(1)] = (10));

} else {
var statearr_37288_37352 = state_37208__$1;
(statearr_37288_37352[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto___37298,cs,m,dchan,dctr,done))
;
return ((function (switch__8364__auto__,c__8429__auto___37298,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__8365__auto__ = null;
var cljs$core$async$mult_$_state_machine__8365__auto____0 = (function (){
var statearr_37292 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37292[(0)] = cljs$core$async$mult_$_state_machine__8365__auto__);

(statearr_37292[(1)] = (1));

return statearr_37292;
});
var cljs$core$async$mult_$_state_machine__8365__auto____1 = (function (state_37208){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_37208);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e37293){if((e37293 instanceof Object)){
var ex__8368__auto__ = e37293;
var statearr_37294_37353 = state_37208;
(statearr_37294_37353[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37208);

return cljs.core.cst$kw$recur;
} else {
throw e37293;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__37354 = state_37208;
state_37208 = G__37354;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__8365__auto__ = function(state_37208){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__8365__auto____1.call(this,state_37208);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__8365__auto____0;
cljs$core$async$mult_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__8365__auto____1;
return cljs$core$async$mult_$_state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___37298,cs,m,dchan,dctr,done))
})();
var state__8431__auto__ = (function (){var statearr_37295 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_37295[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___37298);

return statearr_37295;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});})(c__8429__auto___37298,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args37355 = [];
var len__5627__auto___37358 = arguments.length;
var i__5628__auto___37359 = (0);
while(true){
if((i__5628__auto___37359 < len__5627__auto___37358)){
args37355.push((arguments[i__5628__auto___37359]));

var G__37360 = (i__5628__auto___37359 + (1));
i__5628__auto___37359 = G__37360;
continue;
} else {
}
break;
}

var G__37357 = args37355.length;
switch (G__37357) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37355.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto__.call(null,m,ch));
} else {
var m__5225__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto__.call(null,m,ch));
} else {
var m__5225__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5225__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5225__auto__.call(null,m));
} else {
var m__5225__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__5225__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5225__auto__.call(null,m,state_map));
} else {
var m__5225__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5225__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5225__auto__.call(null,m,mode));
} else {
var m__5225__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5225__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___37372 = arguments.length;
var i__5628__auto___37373 = (0);
while(true){
if((i__5628__auto___37373 < len__5627__auto___37372)){
args__5634__auto__.push((arguments[i__5628__auto___37373]));

var G__37374 = (i__5628__auto___37373 + (1));
i__5628__auto___37373 = G__37374;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((3) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5635__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__37366){
var map__37367 = p__37366;
var map__37367__$1 = ((((!((map__37367 == null)))?((((map__37367.cljs$lang$protocol_mask$partition0$ & (64))) || (map__37367.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37367):map__37367);
var opts = map__37367__$1;
var statearr_37369_37375 = state;
(statearr_37369_37375[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts(((function (map__37367,map__37367__$1,opts){
return (function (val){
var statearr_37370_37376 = state;
(statearr_37370_37376[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__37367,map__37367__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_37371_37377 = state;
(statearr_37371_37377[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq37362){
var G__37363 = cljs.core.first(seq37362);
var seq37362__$1 = cljs.core.next(seq37362);
var G__37364 = cljs.core.first(seq37362__$1);
var seq37362__$2 = cljs.core.next(seq37362__$1);
var G__37365 = cljs.core.first(seq37362__$2);
var seq37362__$3 = cljs.core.next(seq37362__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__37363,G__37364,G__37365,seq37362__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__37544 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__37544) : cljs.core.atom.call(null,G__37544));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute) : cljs.core.atom.call(null,cljs.core.cst$kw$mute));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async37545 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37545 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta37546){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta37546 = meta37546;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async37545.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_37547,meta37546__$1){
var self__ = this;
var _37547__$1 = this;
return (new cljs.core.async.t_cljs$core$async37545(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta37546__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37545.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_37547){
var self__ = this;
var _37547__$1 = this;
return self__.meta37546;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37545.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async37545.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37545.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async37545.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37545.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37545.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__37548_37710 = self__.cs;
var G__37549_37711 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__37548_37710,G__37549_37711) : cljs.core.reset_BANG_.call(null,G__37548_37710,G__37549_37711));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37545.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37545.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$mode)], 0)))].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37545.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.with_meta(cljs.core.cst$sym$mix,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out], null))),cljs.core.cst$kw$doc,"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta37546], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37545.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async37545.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37545";

cljs.core.async.t_cljs$core$async37545.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async37545");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async37545 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async37545(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta37546){
return (new cljs.core.async.t_cljs$core$async37545(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta37546));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async37545(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8429__auto___37712 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8429__auto___37712,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___37712,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_37647){
var state_val_37648 = (state_37647[(1)]);
if((state_val_37648 === (7))){
var inst_37565 = (state_37647[(2)]);
var state_37647__$1 = state_37647;
var statearr_37649_37713 = state_37647__$1;
(statearr_37649_37713[(2)] = inst_37565);

(statearr_37649_37713[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (20))){
var inst_37577 = (state_37647[(7)]);
var state_37647__$1 = state_37647;
var statearr_37650_37714 = state_37647__$1;
(statearr_37650_37714[(2)] = inst_37577);

(statearr_37650_37714[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (27))){
var state_37647__$1 = state_37647;
var statearr_37651_37715 = state_37647__$1;
(statearr_37651_37715[(2)] = null);

(statearr_37651_37715[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (1))){
var inst_37553 = (state_37647[(8)]);
var inst_37553__$1 = calc_state();
var inst_37555 = (inst_37553__$1 == null);
var inst_37556 = cljs.core.not(inst_37555);
var state_37647__$1 = (function (){var statearr_37652 = state_37647;
(statearr_37652[(8)] = inst_37553__$1);

return statearr_37652;
})();
if(inst_37556){
var statearr_37653_37716 = state_37647__$1;
(statearr_37653_37716[(1)] = (2));

} else {
var statearr_37654_37717 = state_37647__$1;
(statearr_37654_37717[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (24))){
var inst_37607 = (state_37647[(9)]);
var inst_37621 = (state_37647[(10)]);
var inst_37600 = (state_37647[(11)]);
var inst_37621__$1 = (inst_37600.cljs$core$IFn$_invoke$arity$1 ? inst_37600.cljs$core$IFn$_invoke$arity$1(inst_37607) : inst_37600.call(null,inst_37607));
var state_37647__$1 = (function (){var statearr_37655 = state_37647;
(statearr_37655[(10)] = inst_37621__$1);

return statearr_37655;
})();
if(cljs.core.truth_(inst_37621__$1)){
var statearr_37656_37718 = state_37647__$1;
(statearr_37656_37718[(1)] = (29));

} else {
var statearr_37657_37719 = state_37647__$1;
(statearr_37657_37719[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (4))){
var inst_37568 = (state_37647[(2)]);
var state_37647__$1 = state_37647;
if(cljs.core.truth_(inst_37568)){
var statearr_37658_37720 = state_37647__$1;
(statearr_37658_37720[(1)] = (8));

} else {
var statearr_37659_37721 = state_37647__$1;
(statearr_37659_37721[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (15))){
var inst_37594 = (state_37647[(2)]);
var state_37647__$1 = state_37647;
if(cljs.core.truth_(inst_37594)){
var statearr_37660_37722 = state_37647__$1;
(statearr_37660_37722[(1)] = (19));

} else {
var statearr_37661_37723 = state_37647__$1;
(statearr_37661_37723[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (21))){
var inst_37599 = (state_37647[(12)]);
var inst_37599__$1 = (state_37647[(2)]);
var inst_37600 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37599__$1,cljs.core.cst$kw$solos);
var inst_37601 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37599__$1,cljs.core.cst$kw$mutes);
var inst_37602 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37599__$1,cljs.core.cst$kw$reads);
var state_37647__$1 = (function (){var statearr_37662 = state_37647;
(statearr_37662[(12)] = inst_37599__$1);

(statearr_37662[(13)] = inst_37601);

(statearr_37662[(11)] = inst_37600);

return statearr_37662;
})();
return cljs.core.async.ioc_alts_BANG_(state_37647__$1,(22),inst_37602);
} else {
if((state_val_37648 === (31))){
var inst_37629 = (state_37647[(2)]);
var state_37647__$1 = state_37647;
if(cljs.core.truth_(inst_37629)){
var statearr_37663_37724 = state_37647__$1;
(statearr_37663_37724[(1)] = (32));

} else {
var statearr_37664_37725 = state_37647__$1;
(statearr_37664_37725[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (32))){
var inst_37606 = (state_37647[(14)]);
var state_37647__$1 = state_37647;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37647__$1,(35),out,inst_37606);
} else {
if((state_val_37648 === (33))){
var inst_37599 = (state_37647[(12)]);
var inst_37577 = inst_37599;
var state_37647__$1 = (function (){var statearr_37665 = state_37647;
(statearr_37665[(7)] = inst_37577);

return statearr_37665;
})();
var statearr_37666_37726 = state_37647__$1;
(statearr_37666_37726[(2)] = null);

(statearr_37666_37726[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (13))){
var inst_37577 = (state_37647[(7)]);
var inst_37584 = inst_37577.cljs$lang$protocol_mask$partition0$;
var inst_37585 = (inst_37584 & (64));
var inst_37586 = inst_37577.cljs$core$ISeq$;
var inst_37587 = (inst_37585) || (inst_37586);
var state_37647__$1 = state_37647;
if(cljs.core.truth_(inst_37587)){
var statearr_37667_37727 = state_37647__$1;
(statearr_37667_37727[(1)] = (16));

} else {
var statearr_37668_37728 = state_37647__$1;
(statearr_37668_37728[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (22))){
var inst_37607 = (state_37647[(9)]);
var inst_37606 = (state_37647[(14)]);
var inst_37605 = (state_37647[(2)]);
var inst_37606__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37605,(0),null);
var inst_37607__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37605,(1),null);
var inst_37608 = (inst_37606__$1 == null);
var inst_37609 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_37607__$1,change);
var inst_37610 = (inst_37608) || (inst_37609);
var state_37647__$1 = (function (){var statearr_37669 = state_37647;
(statearr_37669[(9)] = inst_37607__$1);

(statearr_37669[(14)] = inst_37606__$1);

return statearr_37669;
})();
if(cljs.core.truth_(inst_37610)){
var statearr_37670_37729 = state_37647__$1;
(statearr_37670_37729[(1)] = (23));

} else {
var statearr_37671_37730 = state_37647__$1;
(statearr_37671_37730[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (36))){
var inst_37599 = (state_37647[(12)]);
var inst_37577 = inst_37599;
var state_37647__$1 = (function (){var statearr_37672 = state_37647;
(statearr_37672[(7)] = inst_37577);

return statearr_37672;
})();
var statearr_37673_37731 = state_37647__$1;
(statearr_37673_37731[(2)] = null);

(statearr_37673_37731[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (29))){
var inst_37621 = (state_37647[(10)]);
var state_37647__$1 = state_37647;
var statearr_37674_37732 = state_37647__$1;
(statearr_37674_37732[(2)] = inst_37621);

(statearr_37674_37732[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (6))){
var state_37647__$1 = state_37647;
var statearr_37675_37733 = state_37647__$1;
(statearr_37675_37733[(2)] = false);

(statearr_37675_37733[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (28))){
var inst_37617 = (state_37647[(2)]);
var inst_37618 = calc_state();
var inst_37577 = inst_37618;
var state_37647__$1 = (function (){var statearr_37676 = state_37647;
(statearr_37676[(7)] = inst_37577);

(statearr_37676[(15)] = inst_37617);

return statearr_37676;
})();
var statearr_37677_37734 = state_37647__$1;
(statearr_37677_37734[(2)] = null);

(statearr_37677_37734[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (25))){
var inst_37643 = (state_37647[(2)]);
var state_37647__$1 = state_37647;
var statearr_37678_37735 = state_37647__$1;
(statearr_37678_37735[(2)] = inst_37643);

(statearr_37678_37735[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (34))){
var inst_37641 = (state_37647[(2)]);
var state_37647__$1 = state_37647;
var statearr_37679_37736 = state_37647__$1;
(statearr_37679_37736[(2)] = inst_37641);

(statearr_37679_37736[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (17))){
var state_37647__$1 = state_37647;
var statearr_37680_37737 = state_37647__$1;
(statearr_37680_37737[(2)] = false);

(statearr_37680_37737[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (3))){
var state_37647__$1 = state_37647;
var statearr_37681_37738 = state_37647__$1;
(statearr_37681_37738[(2)] = false);

(statearr_37681_37738[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (12))){
var inst_37645 = (state_37647[(2)]);
var state_37647__$1 = state_37647;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37647__$1,inst_37645);
} else {
if((state_val_37648 === (2))){
var inst_37553 = (state_37647[(8)]);
var inst_37558 = inst_37553.cljs$lang$protocol_mask$partition0$;
var inst_37559 = (inst_37558 & (64));
var inst_37560 = inst_37553.cljs$core$ISeq$;
var inst_37561 = (inst_37559) || (inst_37560);
var state_37647__$1 = state_37647;
if(cljs.core.truth_(inst_37561)){
var statearr_37682_37739 = state_37647__$1;
(statearr_37682_37739[(1)] = (5));

} else {
var statearr_37683_37740 = state_37647__$1;
(statearr_37683_37740[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (23))){
var inst_37606 = (state_37647[(14)]);
var inst_37612 = (inst_37606 == null);
var state_37647__$1 = state_37647;
if(cljs.core.truth_(inst_37612)){
var statearr_37684_37741 = state_37647__$1;
(statearr_37684_37741[(1)] = (26));

} else {
var statearr_37685_37742 = state_37647__$1;
(statearr_37685_37742[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (35))){
var inst_37632 = (state_37647[(2)]);
var state_37647__$1 = state_37647;
if(cljs.core.truth_(inst_37632)){
var statearr_37686_37743 = state_37647__$1;
(statearr_37686_37743[(1)] = (36));

} else {
var statearr_37687_37744 = state_37647__$1;
(statearr_37687_37744[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (19))){
var inst_37577 = (state_37647[(7)]);
var inst_37596 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37577);
var state_37647__$1 = state_37647;
var statearr_37688_37745 = state_37647__$1;
(statearr_37688_37745[(2)] = inst_37596);

(statearr_37688_37745[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (11))){
var inst_37577 = (state_37647[(7)]);
var inst_37581 = (inst_37577 == null);
var inst_37582 = cljs.core.not(inst_37581);
var state_37647__$1 = state_37647;
if(inst_37582){
var statearr_37689_37746 = state_37647__$1;
(statearr_37689_37746[(1)] = (13));

} else {
var statearr_37690_37747 = state_37647__$1;
(statearr_37690_37747[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (9))){
var inst_37553 = (state_37647[(8)]);
var state_37647__$1 = state_37647;
var statearr_37691_37748 = state_37647__$1;
(statearr_37691_37748[(2)] = inst_37553);

(statearr_37691_37748[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (5))){
var state_37647__$1 = state_37647;
var statearr_37692_37749 = state_37647__$1;
(statearr_37692_37749[(2)] = true);

(statearr_37692_37749[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (14))){
var state_37647__$1 = state_37647;
var statearr_37693_37750 = state_37647__$1;
(statearr_37693_37750[(2)] = false);

(statearr_37693_37750[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (26))){
var inst_37607 = (state_37647[(9)]);
var inst_37614 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_37607);
var state_37647__$1 = state_37647;
var statearr_37694_37751 = state_37647__$1;
(statearr_37694_37751[(2)] = inst_37614);

(statearr_37694_37751[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (16))){
var state_37647__$1 = state_37647;
var statearr_37695_37752 = state_37647__$1;
(statearr_37695_37752[(2)] = true);

(statearr_37695_37752[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (38))){
var inst_37637 = (state_37647[(2)]);
var state_37647__$1 = state_37647;
var statearr_37696_37753 = state_37647__$1;
(statearr_37696_37753[(2)] = inst_37637);

(statearr_37696_37753[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (30))){
var inst_37607 = (state_37647[(9)]);
var inst_37601 = (state_37647[(13)]);
var inst_37600 = (state_37647[(11)]);
var inst_37624 = cljs.core.empty_QMARK_(inst_37600);
var inst_37625 = (inst_37601.cljs$core$IFn$_invoke$arity$1 ? inst_37601.cljs$core$IFn$_invoke$arity$1(inst_37607) : inst_37601.call(null,inst_37607));
var inst_37626 = cljs.core.not(inst_37625);
var inst_37627 = (inst_37624) && (inst_37626);
var state_37647__$1 = state_37647;
var statearr_37697_37754 = state_37647__$1;
(statearr_37697_37754[(2)] = inst_37627);

(statearr_37697_37754[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (10))){
var inst_37553 = (state_37647[(8)]);
var inst_37573 = (state_37647[(2)]);
var inst_37574 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37573,cljs.core.cst$kw$solos);
var inst_37575 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37573,cljs.core.cst$kw$mutes);
var inst_37576 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37573,cljs.core.cst$kw$reads);
var inst_37577 = inst_37553;
var state_37647__$1 = (function (){var statearr_37698 = state_37647;
(statearr_37698[(16)] = inst_37575);

(statearr_37698[(17)] = inst_37574);

(statearr_37698[(7)] = inst_37577);

(statearr_37698[(18)] = inst_37576);

return statearr_37698;
})();
var statearr_37699_37755 = state_37647__$1;
(statearr_37699_37755[(2)] = null);

(statearr_37699_37755[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (18))){
var inst_37591 = (state_37647[(2)]);
var state_37647__$1 = state_37647;
var statearr_37700_37756 = state_37647__$1;
(statearr_37700_37756[(2)] = inst_37591);

(statearr_37700_37756[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (37))){
var state_37647__$1 = state_37647;
var statearr_37701_37757 = state_37647__$1;
(statearr_37701_37757[(2)] = null);

(statearr_37701_37757[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37648 === (8))){
var inst_37553 = (state_37647[(8)]);
var inst_37570 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37553);
var state_37647__$1 = state_37647;
var statearr_37702_37758 = state_37647__$1;
(statearr_37702_37758[(2)] = inst_37570);

(statearr_37702_37758[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto___37712,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__8364__auto__,c__8429__auto___37712,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__8365__auto__ = null;
var cljs$core$async$mix_$_state_machine__8365__auto____0 = (function (){
var statearr_37706 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37706[(0)] = cljs$core$async$mix_$_state_machine__8365__auto__);

(statearr_37706[(1)] = (1));

return statearr_37706;
});
var cljs$core$async$mix_$_state_machine__8365__auto____1 = (function (state_37647){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_37647);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e37707){if((e37707 instanceof Object)){
var ex__8368__auto__ = e37707;
var statearr_37708_37759 = state_37647;
(statearr_37708_37759[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37647);

return cljs.core.cst$kw$recur;
} else {
throw e37707;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__37760 = state_37647;
state_37647 = G__37760;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__8365__auto__ = function(state_37647){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__8365__auto____1.call(this,state_37647);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__8365__auto____0;
cljs$core$async$mix_$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__8365__auto____1;
return cljs$core$async$mix_$_state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___37712,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__8431__auto__ = (function (){var statearr_37709 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_37709[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___37712);

return statearr_37709;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});})(c__8429__auto___37712,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5225__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__5225__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5225__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5225__auto__.call(null,p,v,ch));
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5225__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args37761 = [];
var len__5627__auto___37764 = arguments.length;
var i__5628__auto___37765 = (0);
while(true){
if((i__5628__auto___37765 < len__5627__auto___37764)){
args37761.push((arguments[i__5628__auto___37765]));

var G__37766 = (i__5628__auto___37765 + (1));
i__5628__auto___37765 = G__37766;
continue;
} else {
}
break;
}

var G__37763 = args37761.length;
switch (G__37763) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37761.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5225__auto__.call(null,p));
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__5225__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5225__auto__.call(null,p,v));
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__5225__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args37769 = [];
var len__5627__auto___37897 = arguments.length;
var i__5628__auto___37898 = (0);
while(true){
if((i__5628__auto___37898 < len__5627__auto___37897)){
args37769.push((arguments[i__5628__auto___37898]));

var G__37899 = (i__5628__auto___37898 + (1));
i__5628__auto___37898 = G__37899;
continue;
} else {
}
break;
}

var G__37771 = args37769.length;
switch (G__37771) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37769.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__37772 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__37772) : cljs.core.atom.call(null,G__37772));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__4569__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__4569__auto__,mults){
return (function (p1__37768_SHARP_){
if(cljs.core.truth_((p1__37768_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__37768_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__37768_SHARP_.call(null,topic)))){
return p1__37768_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__37768_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__4569__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async37773 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37773 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta37774){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta37774 = meta37774;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async37773.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_37775,meta37774__$1){
var self__ = this;
var _37775__$1 = this;
return (new cljs.core.async.t_cljs$core$async37773(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta37774__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37773.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_37775){
var self__ = this;
var _37775__$1 = this;
return self__.meta37774;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37773.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async37773.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37773.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async37773.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37773.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37773.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__37776 = self__.mults;
var G__37777 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__37776,G__37777) : cljs.core.reset_BANG_.call(null,G__37776,G__37777));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37773.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37773.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta37774], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37773.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async37773.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37773";

cljs.core.async.t_cljs$core$async37773.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async37773");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async37773 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async37773(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta37774){
return (new cljs.core.async.t_cljs$core$async37773(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta37774));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async37773(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8429__auto___37901 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8429__auto___37901,mults,ensure_mult,p){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___37901,mults,ensure_mult,p){
return (function (state_37849){
var state_val_37850 = (state_37849[(1)]);
if((state_val_37850 === (7))){
var inst_37845 = (state_37849[(2)]);
var state_37849__$1 = state_37849;
var statearr_37851_37902 = state_37849__$1;
(statearr_37851_37902[(2)] = inst_37845);

(statearr_37851_37902[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37850 === (20))){
var state_37849__$1 = state_37849;
var statearr_37852_37903 = state_37849__$1;
(statearr_37852_37903[(2)] = null);

(statearr_37852_37903[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37850 === (1))){
var state_37849__$1 = state_37849;
var statearr_37853_37904 = state_37849__$1;
(statearr_37853_37904[(2)] = null);

(statearr_37853_37904[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37850 === (24))){
var inst_37828 = (state_37849[(7)]);
var inst_37837 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_37828);
var state_37849__$1 = state_37849;
var statearr_37854_37905 = state_37849__$1;
(statearr_37854_37905[(2)] = inst_37837);

(statearr_37854_37905[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37850 === (4))){
var inst_37780 = (state_37849[(8)]);
var inst_37780__$1 = (state_37849[(2)]);
var inst_37781 = (inst_37780__$1 == null);
var state_37849__$1 = (function (){var statearr_37855 = state_37849;
(statearr_37855[(8)] = inst_37780__$1);

return statearr_37855;
})();
if(cljs.core.truth_(inst_37781)){
var statearr_37856_37906 = state_37849__$1;
(statearr_37856_37906[(1)] = (5));

} else {
var statearr_37857_37907 = state_37849__$1;
(statearr_37857_37907[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37850 === (15))){
var inst_37822 = (state_37849[(2)]);
var state_37849__$1 = state_37849;
var statearr_37858_37908 = state_37849__$1;
(statearr_37858_37908[(2)] = inst_37822);

(statearr_37858_37908[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37850 === (21))){
var inst_37842 = (state_37849[(2)]);
var state_37849__$1 = (function (){var statearr_37859 = state_37849;
(statearr_37859[(9)] = inst_37842);

return statearr_37859;
})();
var statearr_37860_37909 = state_37849__$1;
(statearr_37860_37909[(2)] = null);

(statearr_37860_37909[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37850 === (13))){
var inst_37804 = (state_37849[(10)]);
var inst_37806 = cljs.core.chunked_seq_QMARK_(inst_37804);
var state_37849__$1 = state_37849;
if(inst_37806){
var statearr_37861_37910 = state_37849__$1;
(statearr_37861_37910[(1)] = (16));

} else {
var statearr_37862_37911 = state_37849__$1;
(statearr_37862_37911[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37850 === (22))){
var inst_37834 = (state_37849[(2)]);
var state_37849__$1 = state_37849;
if(cljs.core.truth_(inst_37834)){
var statearr_37863_37912 = state_37849__$1;
(statearr_37863_37912[(1)] = (23));

} else {
var statearr_37864_37913 = state_37849__$1;
(statearr_37864_37913[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37850 === (6))){
var inst_37830 = (state_37849[(11)]);
var inst_37828 = (state_37849[(7)]);
var inst_37780 = (state_37849[(8)]);
var inst_37828__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_37780) : topic_fn.call(null,inst_37780));
var inst_37829 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_37830__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37829,inst_37828__$1);
var state_37849__$1 = (function (){var statearr_37865 = state_37849;
(statearr_37865[(11)] = inst_37830__$1);

(statearr_37865[(7)] = inst_37828__$1);

return statearr_37865;
})();
if(cljs.core.truth_(inst_37830__$1)){
var statearr_37866_37914 = state_37849__$1;
(statearr_37866_37914[(1)] = (19));

} else {
var statearr_37867_37915 = state_37849__$1;
(statearr_37867_37915[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37850 === (25))){
var inst_37839 = (state_37849[(2)]);
var state_37849__$1 = state_37849;
var statearr_37868_37916 = state_37849__$1;
(statearr_37868_37916[(2)] = inst_37839);

(statearr_37868_37916[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37850 === (17))){
var inst_37804 = (state_37849[(10)]);
var inst_37813 = cljs.core.first(inst_37804);
var inst_37814 = cljs.core.async.muxch_STAR_(inst_37813);
var inst_37815 = cljs.core.async.close_BANG_(inst_37814);
var inst_37816 = cljs.core.next(inst_37804);
var inst_37790 = inst_37816;
var inst_37791 = null;
var inst_37792 = (0);
var inst_37793 = (0);
var state_37849__$1 = (function (){var statearr_37869 = state_37849;
(statearr_37869[(12)] = inst_37790);

(statearr_37869[(13)] = inst_37815);

(statearr_37869[(14)] = inst_37791);

(statearr_37869[(15)] = inst_37792);

(statearr_37869[(16)] = inst_37793);

return statearr_37869;
})();
var statearr_37870_37917 = state_37849__$1;
(statearr_37870_37917[(2)] = null);

(statearr_37870_37917[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37850 === (3))){
var inst_37847 = (state_37849[(2)]);
var state_37849__$1 = state_37849;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37849__$1,inst_37847);
} else {
if((state_val_37850 === (12))){
var inst_37824 = (state_37849[(2)]);
var state_37849__$1 = state_37849;
var statearr_37871_37918 = state_37849__$1;
(statearr_37871_37918[(2)] = inst_37824);

(statearr_37871_37918[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37850 === (2))){
var state_37849__$1 = state_37849;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37849__$1,(4),ch);
} else {
if((state_val_37850 === (23))){
var state_37849__$1 = state_37849;
var statearr_37872_37919 = state_37849__$1;
(statearr_37872_37919[(2)] = null);

(statearr_37872_37919[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37850 === (19))){
var inst_37830 = (state_37849[(11)]);
var inst_37780 = (state_37849[(8)]);
var inst_37832 = cljs.core.async.muxch_STAR_(inst_37830);
var state_37849__$1 = state_37849;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37849__$1,(22),inst_37832,inst_37780);
} else {
if((state_val_37850 === (11))){
var inst_37790 = (state_37849[(12)]);
var inst_37804 = (state_37849[(10)]);
var inst_37804__$1 = cljs.core.seq(inst_37790);
var state_37849__$1 = (function (){var statearr_37873 = state_37849;
(statearr_37873[(10)] = inst_37804__$1);

return statearr_37873;
})();
if(inst_37804__$1){
var statearr_37874_37920 = state_37849__$1;
(statearr_37874_37920[(1)] = (13));

} else {
var statearr_37875_37921 = state_37849__$1;
(statearr_37875_37921[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37850 === (9))){
var inst_37826 = (state_37849[(2)]);
var state_37849__$1 = state_37849;
var statearr_37876_37922 = state_37849__$1;
(statearr_37876_37922[(2)] = inst_37826);

(statearr_37876_37922[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37850 === (5))){
var inst_37787 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_37788 = cljs.core.vals(inst_37787);
var inst_37789 = cljs.core.seq(inst_37788);
var inst_37790 = inst_37789;
var inst_37791 = null;
var inst_37792 = (0);
var inst_37793 = (0);
var state_37849__$1 = (function (){var statearr_37877 = state_37849;
(statearr_37877[(12)] = inst_37790);

(statearr_37877[(14)] = inst_37791);

(statearr_37877[(15)] = inst_37792);

(statearr_37877[(16)] = inst_37793);

return statearr_37877;
})();
var statearr_37878_37923 = state_37849__$1;
(statearr_37878_37923[(2)] = null);

(statearr_37878_37923[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37850 === (14))){
var state_37849__$1 = state_37849;
var statearr_37882_37924 = state_37849__$1;
(statearr_37882_37924[(2)] = null);

(statearr_37882_37924[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37850 === (16))){
var inst_37804 = (state_37849[(10)]);
var inst_37808 = cljs.core.chunk_first(inst_37804);
var inst_37809 = cljs.core.chunk_rest(inst_37804);
var inst_37810 = cljs.core.count(inst_37808);
var inst_37790 = inst_37809;
var inst_37791 = inst_37808;
var inst_37792 = inst_37810;
var inst_37793 = (0);
var state_37849__$1 = (function (){var statearr_37883 = state_37849;
(statearr_37883[(12)] = inst_37790);

(statearr_37883[(14)] = inst_37791);

(statearr_37883[(15)] = inst_37792);

(statearr_37883[(16)] = inst_37793);

return statearr_37883;
})();
var statearr_37884_37925 = state_37849__$1;
(statearr_37884_37925[(2)] = null);

(statearr_37884_37925[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37850 === (10))){
var inst_37790 = (state_37849[(12)]);
var inst_37791 = (state_37849[(14)]);
var inst_37792 = (state_37849[(15)]);
var inst_37793 = (state_37849[(16)]);
var inst_37798 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_37791,inst_37793);
var inst_37799 = cljs.core.async.muxch_STAR_(inst_37798);
var inst_37800 = cljs.core.async.close_BANG_(inst_37799);
var inst_37801 = (inst_37793 + (1));
var tmp37879 = inst_37790;
var tmp37880 = inst_37791;
var tmp37881 = inst_37792;
var inst_37790__$1 = tmp37879;
var inst_37791__$1 = tmp37880;
var inst_37792__$1 = tmp37881;
var inst_37793__$1 = inst_37801;
var state_37849__$1 = (function (){var statearr_37885 = state_37849;
(statearr_37885[(12)] = inst_37790__$1);

(statearr_37885[(14)] = inst_37791__$1);

(statearr_37885[(15)] = inst_37792__$1);

(statearr_37885[(16)] = inst_37793__$1);

(statearr_37885[(17)] = inst_37800);

return statearr_37885;
})();
var statearr_37886_37926 = state_37849__$1;
(statearr_37886_37926[(2)] = null);

(statearr_37886_37926[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37850 === (18))){
var inst_37819 = (state_37849[(2)]);
var state_37849__$1 = state_37849;
var statearr_37887_37927 = state_37849__$1;
(statearr_37887_37927[(2)] = inst_37819);

(statearr_37887_37927[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37850 === (8))){
var inst_37792 = (state_37849[(15)]);
var inst_37793 = (state_37849[(16)]);
var inst_37795 = (inst_37793 < inst_37792);
var inst_37796 = inst_37795;
var state_37849__$1 = state_37849;
if(cljs.core.truth_(inst_37796)){
var statearr_37888_37928 = state_37849__$1;
(statearr_37888_37928[(1)] = (10));

} else {
var statearr_37889_37929 = state_37849__$1;
(statearr_37889_37929[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto___37901,mults,ensure_mult,p))
;
return ((function (switch__8364__auto__,c__8429__auto___37901,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__8365__auto__ = null;
var cljs$core$async$state_machine__8365__auto____0 = (function (){
var statearr_37893 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37893[(0)] = cljs$core$async$state_machine__8365__auto__);

(statearr_37893[(1)] = (1));

return statearr_37893;
});
var cljs$core$async$state_machine__8365__auto____1 = (function (state_37849){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_37849);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e37894){if((e37894 instanceof Object)){
var ex__8368__auto__ = e37894;
var statearr_37895_37930 = state_37849;
(statearr_37895_37930[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37849);

return cljs.core.cst$kw$recur;
} else {
throw e37894;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__37931 = state_37849;
state_37849 = G__37931;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$state_machine__8365__auto__ = function(state_37849){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8365__auto____1.call(this,state_37849);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8365__auto____0;
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8365__auto____1;
return cljs$core$async$state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___37901,mults,ensure_mult,p))
})();
var state__8431__auto__ = (function (){var statearr_37896 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_37896[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___37901);

return statearr_37896;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});})(c__8429__auto___37901,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args37932 = [];
var len__5627__auto___37935 = arguments.length;
var i__5628__auto___37936 = (0);
while(true){
if((i__5628__auto___37936 < len__5627__auto___37935)){
args37932.push((arguments[i__5628__auto___37936]));

var G__37937 = (i__5628__auto___37936 + (1));
i__5628__auto___37936 = G__37937;
continue;
} else {
}
break;
}

var G__37934 = args37932.length;
switch (G__37934) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37932.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args37939 = [];
var len__5627__auto___37942 = arguments.length;
var i__5628__auto___37943 = (0);
while(true){
if((i__5628__auto___37943 < len__5627__auto___37942)){
args37939.push((arguments[i__5628__auto___37943]));

var G__37944 = (i__5628__auto___37943 + (1));
i__5628__auto___37943 = G__37944;
continue;
} else {
}
break;
}

var G__37941 = args37939.length;
switch (G__37941) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37939.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args37946 = [];
var len__5627__auto___38017 = arguments.length;
var i__5628__auto___38018 = (0);
while(true){
if((i__5628__auto___38018 < len__5627__auto___38017)){
args37946.push((arguments[i__5628__auto___38018]));

var G__38019 = (i__5628__auto___38018 + (1));
i__5628__auto___38018 = G__38019;
continue;
} else {
}
break;
}

var G__37948 = args37946.length;
switch (G__37948) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37946.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__8429__auto___38021 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8429__auto___38021,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___38021,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_37987){
var state_val_37988 = (state_37987[(1)]);
if((state_val_37988 === (7))){
var state_37987__$1 = state_37987;
var statearr_37989_38022 = state_37987__$1;
(statearr_37989_38022[(2)] = null);

(statearr_37989_38022[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37988 === (1))){
var state_37987__$1 = state_37987;
var statearr_37990_38023 = state_37987__$1;
(statearr_37990_38023[(2)] = null);

(statearr_37990_38023[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37988 === (4))){
var inst_37951 = (state_37987[(7)]);
var inst_37953 = (inst_37951 < cnt);
var state_37987__$1 = state_37987;
if(cljs.core.truth_(inst_37953)){
var statearr_37991_38024 = state_37987__$1;
(statearr_37991_38024[(1)] = (6));

} else {
var statearr_37992_38025 = state_37987__$1;
(statearr_37992_38025[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37988 === (15))){
var inst_37983 = (state_37987[(2)]);
var state_37987__$1 = state_37987;
var statearr_37993_38026 = state_37987__$1;
(statearr_37993_38026[(2)] = inst_37983);

(statearr_37993_38026[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37988 === (13))){
var inst_37976 = cljs.core.async.close_BANG_(out);
var state_37987__$1 = state_37987;
var statearr_37994_38027 = state_37987__$1;
(statearr_37994_38027[(2)] = inst_37976);

(statearr_37994_38027[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37988 === (6))){
var state_37987__$1 = state_37987;
var statearr_37995_38028 = state_37987__$1;
(statearr_37995_38028[(2)] = null);

(statearr_37995_38028[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37988 === (3))){
var inst_37985 = (state_37987[(2)]);
var state_37987__$1 = state_37987;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37987__$1,inst_37985);
} else {
if((state_val_37988 === (12))){
var inst_37973 = (state_37987[(8)]);
var inst_37973__$1 = (state_37987[(2)]);
var inst_37974 = cljs.core.some(cljs.core.nil_QMARK_,inst_37973__$1);
var state_37987__$1 = (function (){var statearr_37996 = state_37987;
(statearr_37996[(8)] = inst_37973__$1);

return statearr_37996;
})();
if(cljs.core.truth_(inst_37974)){
var statearr_37997_38029 = state_37987__$1;
(statearr_37997_38029[(1)] = (13));

} else {
var statearr_37998_38030 = state_37987__$1;
(statearr_37998_38030[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37988 === (2))){
var inst_37950 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_37951 = (0);
var state_37987__$1 = (function (){var statearr_37999 = state_37987;
(statearr_37999[(9)] = inst_37950);

(statearr_37999[(7)] = inst_37951);

return statearr_37999;
})();
var statearr_38000_38031 = state_37987__$1;
(statearr_38000_38031[(2)] = null);

(statearr_38000_38031[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37988 === (11))){
var inst_37951 = (state_37987[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_37987,(10),Object,null,(9));
var inst_37960 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_37951) : chs__$1.call(null,inst_37951));
var inst_37961 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_37951) : done.call(null,inst_37951));
var inst_37962 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_37960,inst_37961);
var state_37987__$1 = state_37987;
var statearr_38001_38032 = state_37987__$1;
(statearr_38001_38032[(2)] = inst_37962);


cljs.core.async.impl.ioc_helpers.process_exception(state_37987__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_37988 === (9))){
var inst_37951 = (state_37987[(7)]);
var inst_37964 = (state_37987[(2)]);
var inst_37965 = (inst_37951 + (1));
var inst_37951__$1 = inst_37965;
var state_37987__$1 = (function (){var statearr_38002 = state_37987;
(statearr_38002[(10)] = inst_37964);

(statearr_38002[(7)] = inst_37951__$1);

return statearr_38002;
})();
var statearr_38003_38033 = state_37987__$1;
(statearr_38003_38033[(2)] = null);

(statearr_38003_38033[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37988 === (5))){
var inst_37971 = (state_37987[(2)]);
var state_37987__$1 = (function (){var statearr_38004 = state_37987;
(statearr_38004[(11)] = inst_37971);

return statearr_38004;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37987__$1,(12),dchan);
} else {
if((state_val_37988 === (14))){
var inst_37973 = (state_37987[(8)]);
var inst_37978 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_37973);
var state_37987__$1 = state_37987;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37987__$1,(16),out,inst_37978);
} else {
if((state_val_37988 === (16))){
var inst_37980 = (state_37987[(2)]);
var state_37987__$1 = (function (){var statearr_38005 = state_37987;
(statearr_38005[(12)] = inst_37980);

return statearr_38005;
})();
var statearr_38006_38034 = state_37987__$1;
(statearr_38006_38034[(2)] = null);

(statearr_38006_38034[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37988 === (10))){
var inst_37955 = (state_37987[(2)]);
var inst_37956 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_37987__$1 = (function (){var statearr_38007 = state_37987;
(statearr_38007[(13)] = inst_37955);

return statearr_38007;
})();
var statearr_38008_38035 = state_37987__$1;
(statearr_38008_38035[(2)] = inst_37956);


cljs.core.async.impl.ioc_helpers.process_exception(state_37987__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_37988 === (8))){
var inst_37969 = (state_37987[(2)]);
var state_37987__$1 = state_37987;
var statearr_38009_38036 = state_37987__$1;
(statearr_38009_38036[(2)] = inst_37969);

(statearr_38009_38036[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto___38021,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__8364__auto__,c__8429__auto___38021,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__8365__auto__ = null;
var cljs$core$async$state_machine__8365__auto____0 = (function (){
var statearr_38013 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38013[(0)] = cljs$core$async$state_machine__8365__auto__);

(statearr_38013[(1)] = (1));

return statearr_38013;
});
var cljs$core$async$state_machine__8365__auto____1 = (function (state_37987){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_37987);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e38014){if((e38014 instanceof Object)){
var ex__8368__auto__ = e38014;
var statearr_38015_38037 = state_37987;
(statearr_38015_38037[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37987);

return cljs.core.cst$kw$recur;
} else {
throw e38014;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__38038 = state_37987;
state_37987 = G__38038;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$state_machine__8365__auto__ = function(state_37987){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8365__auto____1.call(this,state_37987);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8365__auto____0;
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8365__auto____1;
return cljs$core$async$state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___38021,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__8431__auto__ = (function (){var statearr_38016 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_38016[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___38021);

return statearr_38016;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});})(c__8429__auto___38021,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args38040 = [];
var len__5627__auto___38096 = arguments.length;
var i__5628__auto___38097 = (0);
while(true){
if((i__5628__auto___38097 < len__5627__auto___38096)){
args38040.push((arguments[i__5628__auto___38097]));

var G__38098 = (i__5628__auto___38097 + (1));
i__5628__auto___38097 = G__38098;
continue;
} else {
}
break;
}

var G__38042 = args38040.length;
switch (G__38042) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38040.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__8429__auto___38100 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8429__auto___38100,out){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___38100,out){
return (function (state_38072){
var state_val_38073 = (state_38072[(1)]);
if((state_val_38073 === (7))){
var inst_38052 = (state_38072[(7)]);
var inst_38051 = (state_38072[(8)]);
var inst_38051__$1 = (state_38072[(2)]);
var inst_38052__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38051__$1,(0),null);
var inst_38053 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38051__$1,(1),null);
var inst_38054 = (inst_38052__$1 == null);
var state_38072__$1 = (function (){var statearr_38074 = state_38072;
(statearr_38074[(7)] = inst_38052__$1);

(statearr_38074[(8)] = inst_38051__$1);

(statearr_38074[(9)] = inst_38053);

return statearr_38074;
})();
if(cljs.core.truth_(inst_38054)){
var statearr_38075_38101 = state_38072__$1;
(statearr_38075_38101[(1)] = (8));

} else {
var statearr_38076_38102 = state_38072__$1;
(statearr_38076_38102[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38073 === (1))){
var inst_38043 = cljs.core.vec(chs);
var inst_38044 = inst_38043;
var state_38072__$1 = (function (){var statearr_38077 = state_38072;
(statearr_38077[(10)] = inst_38044);

return statearr_38077;
})();
var statearr_38078_38103 = state_38072__$1;
(statearr_38078_38103[(2)] = null);

(statearr_38078_38103[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38073 === (4))){
var inst_38044 = (state_38072[(10)]);
var state_38072__$1 = state_38072;
return cljs.core.async.ioc_alts_BANG_(state_38072__$1,(7),inst_38044);
} else {
if((state_val_38073 === (6))){
var inst_38068 = (state_38072[(2)]);
var state_38072__$1 = state_38072;
var statearr_38079_38104 = state_38072__$1;
(statearr_38079_38104[(2)] = inst_38068);

(statearr_38079_38104[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38073 === (3))){
var inst_38070 = (state_38072[(2)]);
var state_38072__$1 = state_38072;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38072__$1,inst_38070);
} else {
if((state_val_38073 === (2))){
var inst_38044 = (state_38072[(10)]);
var inst_38046 = cljs.core.count(inst_38044);
var inst_38047 = (inst_38046 > (0));
var state_38072__$1 = state_38072;
if(cljs.core.truth_(inst_38047)){
var statearr_38081_38105 = state_38072__$1;
(statearr_38081_38105[(1)] = (4));

} else {
var statearr_38082_38106 = state_38072__$1;
(statearr_38082_38106[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38073 === (11))){
var inst_38044 = (state_38072[(10)]);
var inst_38061 = (state_38072[(2)]);
var tmp38080 = inst_38044;
var inst_38044__$1 = tmp38080;
var state_38072__$1 = (function (){var statearr_38083 = state_38072;
(statearr_38083[(10)] = inst_38044__$1);

(statearr_38083[(11)] = inst_38061);

return statearr_38083;
})();
var statearr_38084_38107 = state_38072__$1;
(statearr_38084_38107[(2)] = null);

(statearr_38084_38107[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38073 === (9))){
var inst_38052 = (state_38072[(7)]);
var state_38072__$1 = state_38072;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38072__$1,(11),out,inst_38052);
} else {
if((state_val_38073 === (5))){
var inst_38066 = cljs.core.async.close_BANG_(out);
var state_38072__$1 = state_38072;
var statearr_38085_38108 = state_38072__$1;
(statearr_38085_38108[(2)] = inst_38066);

(statearr_38085_38108[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38073 === (10))){
var inst_38064 = (state_38072[(2)]);
var state_38072__$1 = state_38072;
var statearr_38086_38109 = state_38072__$1;
(statearr_38086_38109[(2)] = inst_38064);

(statearr_38086_38109[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38073 === (8))){
var inst_38052 = (state_38072[(7)]);
var inst_38044 = (state_38072[(10)]);
var inst_38051 = (state_38072[(8)]);
var inst_38053 = (state_38072[(9)]);
var inst_38056 = (function (){var cs = inst_38044;
var vec__38049 = inst_38051;
var v = inst_38052;
var c = inst_38053;
return ((function (cs,vec__38049,v,c,inst_38052,inst_38044,inst_38051,inst_38053,state_val_38073,c__8429__auto___38100,out){
return (function (p1__38039_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__38039_SHARP_);
});
;})(cs,vec__38049,v,c,inst_38052,inst_38044,inst_38051,inst_38053,state_val_38073,c__8429__auto___38100,out))
})();
var inst_38057 = cljs.core.filterv(inst_38056,inst_38044);
var inst_38044__$1 = inst_38057;
var state_38072__$1 = (function (){var statearr_38087 = state_38072;
(statearr_38087[(10)] = inst_38044__$1);

return statearr_38087;
})();
var statearr_38088_38110 = state_38072__$1;
(statearr_38088_38110[(2)] = null);

(statearr_38088_38110[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto___38100,out))
;
return ((function (switch__8364__auto__,c__8429__auto___38100,out){
return (function() {
var cljs$core$async$state_machine__8365__auto__ = null;
var cljs$core$async$state_machine__8365__auto____0 = (function (){
var statearr_38092 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38092[(0)] = cljs$core$async$state_machine__8365__auto__);

(statearr_38092[(1)] = (1));

return statearr_38092;
});
var cljs$core$async$state_machine__8365__auto____1 = (function (state_38072){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_38072);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e38093){if((e38093 instanceof Object)){
var ex__8368__auto__ = e38093;
var statearr_38094_38111 = state_38072;
(statearr_38094_38111[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38072);

return cljs.core.cst$kw$recur;
} else {
throw e38093;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__38112 = state_38072;
state_38072 = G__38112;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$state_machine__8365__auto__ = function(state_38072){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8365__auto____1.call(this,state_38072);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8365__auto____0;
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8365__auto____1;
return cljs$core$async$state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___38100,out))
})();
var state__8431__auto__ = (function (){var statearr_38095 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_38095[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___38100);

return statearr_38095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});})(c__8429__auto___38100,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args38113 = [];
var len__5627__auto___38162 = arguments.length;
var i__5628__auto___38163 = (0);
while(true){
if((i__5628__auto___38163 < len__5627__auto___38162)){
args38113.push((arguments[i__5628__auto___38163]));

var G__38164 = (i__5628__auto___38163 + (1));
i__5628__auto___38163 = G__38164;
continue;
} else {
}
break;
}

var G__38115 = args38113.length;
switch (G__38115) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38113.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__8429__auto___38166 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8429__auto___38166,out){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___38166,out){
return (function (state_38139){
var state_val_38140 = (state_38139[(1)]);
if((state_val_38140 === (7))){
var inst_38121 = (state_38139[(7)]);
var inst_38121__$1 = (state_38139[(2)]);
var inst_38122 = (inst_38121__$1 == null);
var inst_38123 = cljs.core.not(inst_38122);
var state_38139__$1 = (function (){var statearr_38141 = state_38139;
(statearr_38141[(7)] = inst_38121__$1);

return statearr_38141;
})();
if(inst_38123){
var statearr_38142_38167 = state_38139__$1;
(statearr_38142_38167[(1)] = (8));

} else {
var statearr_38143_38168 = state_38139__$1;
(statearr_38143_38168[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38140 === (1))){
var inst_38116 = (0);
var state_38139__$1 = (function (){var statearr_38144 = state_38139;
(statearr_38144[(8)] = inst_38116);

return statearr_38144;
})();
var statearr_38145_38169 = state_38139__$1;
(statearr_38145_38169[(2)] = null);

(statearr_38145_38169[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38140 === (4))){
var state_38139__$1 = state_38139;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38139__$1,(7),ch);
} else {
if((state_val_38140 === (6))){
var inst_38134 = (state_38139[(2)]);
var state_38139__$1 = state_38139;
var statearr_38146_38170 = state_38139__$1;
(statearr_38146_38170[(2)] = inst_38134);

(statearr_38146_38170[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38140 === (3))){
var inst_38136 = (state_38139[(2)]);
var inst_38137 = cljs.core.async.close_BANG_(out);
var state_38139__$1 = (function (){var statearr_38147 = state_38139;
(statearr_38147[(9)] = inst_38136);

return statearr_38147;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38139__$1,inst_38137);
} else {
if((state_val_38140 === (2))){
var inst_38116 = (state_38139[(8)]);
var inst_38118 = (inst_38116 < n);
var state_38139__$1 = state_38139;
if(cljs.core.truth_(inst_38118)){
var statearr_38148_38171 = state_38139__$1;
(statearr_38148_38171[(1)] = (4));

} else {
var statearr_38149_38172 = state_38139__$1;
(statearr_38149_38172[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38140 === (11))){
var inst_38116 = (state_38139[(8)]);
var inst_38126 = (state_38139[(2)]);
var inst_38127 = (inst_38116 + (1));
var inst_38116__$1 = inst_38127;
var state_38139__$1 = (function (){var statearr_38150 = state_38139;
(statearr_38150[(8)] = inst_38116__$1);

(statearr_38150[(10)] = inst_38126);

return statearr_38150;
})();
var statearr_38151_38173 = state_38139__$1;
(statearr_38151_38173[(2)] = null);

(statearr_38151_38173[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38140 === (9))){
var state_38139__$1 = state_38139;
var statearr_38152_38174 = state_38139__$1;
(statearr_38152_38174[(2)] = null);

(statearr_38152_38174[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38140 === (5))){
var state_38139__$1 = state_38139;
var statearr_38153_38175 = state_38139__$1;
(statearr_38153_38175[(2)] = null);

(statearr_38153_38175[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38140 === (10))){
var inst_38131 = (state_38139[(2)]);
var state_38139__$1 = state_38139;
var statearr_38154_38176 = state_38139__$1;
(statearr_38154_38176[(2)] = inst_38131);

(statearr_38154_38176[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38140 === (8))){
var inst_38121 = (state_38139[(7)]);
var state_38139__$1 = state_38139;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38139__$1,(11),out,inst_38121);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto___38166,out))
;
return ((function (switch__8364__auto__,c__8429__auto___38166,out){
return (function() {
var cljs$core$async$state_machine__8365__auto__ = null;
var cljs$core$async$state_machine__8365__auto____0 = (function (){
var statearr_38158 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38158[(0)] = cljs$core$async$state_machine__8365__auto__);

(statearr_38158[(1)] = (1));

return statearr_38158;
});
var cljs$core$async$state_machine__8365__auto____1 = (function (state_38139){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_38139);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e38159){if((e38159 instanceof Object)){
var ex__8368__auto__ = e38159;
var statearr_38160_38177 = state_38139;
(statearr_38160_38177[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38139);

return cljs.core.cst$kw$recur;
} else {
throw e38159;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__38178 = state_38139;
state_38139 = G__38178;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$state_machine__8365__auto__ = function(state_38139){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8365__auto____1.call(this,state_38139);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8365__auto____0;
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8365__auto____1;
return cljs$core$async$state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___38166,out))
})();
var state__8431__auto__ = (function (){var statearr_38161 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_38161[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___38166);

return statearr_38161;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});})(c__8429__auto___38166,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async38188 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38188 = (function (map_LT_,f,ch,meta38189){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta38189 = meta38189;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async38188.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38190,meta38189__$1){
var self__ = this;
var _38190__$1 = this;
return (new cljs.core.async.t_cljs$core$async38188(self__.map_LT_,self__.f,self__.ch,meta38189__$1));
});

cljs.core.async.t_cljs$core$async38188.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38190){
var self__ = this;
var _38190__$1 = this;
return self__.meta38189;
});

cljs.core.async.t_cljs$core$async38188.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async38188.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async38188.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async38188.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async38188.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async38191 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38191 = (function (map_LT_,f,ch,meta38189,_,fn1,meta38192){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta38189 = meta38189;
this._ = _;
this.fn1 = fn1;
this.meta38192 = meta38192;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async38191.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_38193,meta38192__$1){
var self__ = this;
var _38193__$1 = this;
return (new cljs.core.async.t_cljs$core$async38191(self__.map_LT_,self__.f,self__.ch,self__.meta38189,self__._,self__.fn1,meta38192__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async38191.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_38193){
var self__ = this;
var _38193__$1 = this;
return self__.meta38192;
});})(___$1))
;

cljs.core.async.t_cljs$core$async38191.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async38191.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async38191.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__38179_SHARP_){
var G__38194 = (((p1__38179_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__38179_SHARP_) : self__.f.call(null,p1__38179_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__38194) : f1.call(null,G__38194));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async38191.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta38189,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async38188], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta38192], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async38191.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38191.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38191";

cljs.core.async.t_cljs$core$async38191.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async38191");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async38191 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async38191(map_LT___$1,f__$1,ch__$1,meta38189__$1,___$2,fn1__$1,meta38192){
return (new cljs.core.async.t_cljs$core$async38191(map_LT___$1,f__$1,ch__$1,meta38189__$1,___$2,fn1__$1,meta38192));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async38191(self__.map_LT_,self__.f,self__.ch,self__.meta38189,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4557__auto__ = ret;
if(cljs.core.truth_(and__4557__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__4557__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__38195 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__38195) : self__.f.call(null,G__38195));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async38188.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async38188.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async38188.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta38189], null);
});

cljs.core.async.t_cljs$core$async38188.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38188.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38188";

cljs.core.async.t_cljs$core$async38188.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async38188");
});

cljs.core.async.__GT_t_cljs$core$async38188 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async38188(map_LT___$1,f__$1,ch__$1,meta38189){
return (new cljs.core.async.t_cljs$core$async38188(map_LT___$1,f__$1,ch__$1,meta38189));
});

}

return (new cljs.core.async.t_cljs$core$async38188(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async38199 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38199 = (function (map_GT_,f,ch,meta38200){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta38200 = meta38200;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async38199.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38201,meta38200__$1){
var self__ = this;
var _38201__$1 = this;
return (new cljs.core.async.t_cljs$core$async38199(self__.map_GT_,self__.f,self__.ch,meta38200__$1));
});

cljs.core.async.t_cljs$core$async38199.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38201){
var self__ = this;
var _38201__$1 = this;
return self__.meta38200;
});

cljs.core.async.t_cljs$core$async38199.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async38199.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async38199.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async38199.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async38199.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async38199.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async38199.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta38200], null);
});

cljs.core.async.t_cljs$core$async38199.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38199.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38199";

cljs.core.async.t_cljs$core$async38199.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async38199");
});

cljs.core.async.__GT_t_cljs$core$async38199 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async38199(map_GT___$1,f__$1,ch__$1,meta38200){
return (new cljs.core.async.t_cljs$core$async38199(map_GT___$1,f__$1,ch__$1,meta38200));
});

}

return (new cljs.core.async.t_cljs$core$async38199(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async38205 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38205 = (function (filter_GT_,p,ch,meta38206){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta38206 = meta38206;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async38205.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38207,meta38206__$1){
var self__ = this;
var _38207__$1 = this;
return (new cljs.core.async.t_cljs$core$async38205(self__.filter_GT_,self__.p,self__.ch,meta38206__$1));
});

cljs.core.async.t_cljs$core$async38205.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38207){
var self__ = this;
var _38207__$1 = this;
return self__.meta38206;
});

cljs.core.async.t_cljs$core$async38205.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async38205.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async38205.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async38205.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async38205.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async38205.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async38205.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async38205.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$filter_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta38206], null);
});

cljs.core.async.t_cljs$core$async38205.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38205.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38205";

cljs.core.async.t_cljs$core$async38205.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core.async/t_cljs$core$async38205");
});

cljs.core.async.__GT_t_cljs$core$async38205 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async38205(filter_GT___$1,p__$1,ch__$1,meta38206){
return (new cljs.core.async.t_cljs$core$async38205(filter_GT___$1,p__$1,ch__$1,meta38206));
});

}

return (new cljs.core.async.t_cljs$core$async38205(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args38208 = [];
var len__5627__auto___38252 = arguments.length;
var i__5628__auto___38253 = (0);
while(true){
if((i__5628__auto___38253 < len__5627__auto___38252)){
args38208.push((arguments[i__5628__auto___38253]));

var G__38254 = (i__5628__auto___38253 + (1));
i__5628__auto___38253 = G__38254;
continue;
} else {
}
break;
}

var G__38210 = args38208.length;
switch (G__38210) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38208.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__8429__auto___38256 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8429__auto___38256,out){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___38256,out){
return (function (state_38231){
var state_val_38232 = (state_38231[(1)]);
if((state_val_38232 === (7))){
var inst_38227 = (state_38231[(2)]);
var state_38231__$1 = state_38231;
var statearr_38233_38257 = state_38231__$1;
(statearr_38233_38257[(2)] = inst_38227);

(statearr_38233_38257[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38232 === (1))){
var state_38231__$1 = state_38231;
var statearr_38234_38258 = state_38231__$1;
(statearr_38234_38258[(2)] = null);

(statearr_38234_38258[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38232 === (4))){
var inst_38213 = (state_38231[(7)]);
var inst_38213__$1 = (state_38231[(2)]);
var inst_38214 = (inst_38213__$1 == null);
var state_38231__$1 = (function (){var statearr_38235 = state_38231;
(statearr_38235[(7)] = inst_38213__$1);

return statearr_38235;
})();
if(cljs.core.truth_(inst_38214)){
var statearr_38236_38259 = state_38231__$1;
(statearr_38236_38259[(1)] = (5));

} else {
var statearr_38237_38260 = state_38231__$1;
(statearr_38237_38260[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38232 === (6))){
var inst_38213 = (state_38231[(7)]);
var inst_38218 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_38213) : p.call(null,inst_38213));
var state_38231__$1 = state_38231;
if(cljs.core.truth_(inst_38218)){
var statearr_38238_38261 = state_38231__$1;
(statearr_38238_38261[(1)] = (8));

} else {
var statearr_38239_38262 = state_38231__$1;
(statearr_38239_38262[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38232 === (3))){
var inst_38229 = (state_38231[(2)]);
var state_38231__$1 = state_38231;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38231__$1,inst_38229);
} else {
if((state_val_38232 === (2))){
var state_38231__$1 = state_38231;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38231__$1,(4),ch);
} else {
if((state_val_38232 === (11))){
var inst_38221 = (state_38231[(2)]);
var state_38231__$1 = state_38231;
var statearr_38240_38263 = state_38231__$1;
(statearr_38240_38263[(2)] = inst_38221);

(statearr_38240_38263[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38232 === (9))){
var state_38231__$1 = state_38231;
var statearr_38241_38264 = state_38231__$1;
(statearr_38241_38264[(2)] = null);

(statearr_38241_38264[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38232 === (5))){
var inst_38216 = cljs.core.async.close_BANG_(out);
var state_38231__$1 = state_38231;
var statearr_38242_38265 = state_38231__$1;
(statearr_38242_38265[(2)] = inst_38216);

(statearr_38242_38265[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38232 === (10))){
var inst_38224 = (state_38231[(2)]);
var state_38231__$1 = (function (){var statearr_38243 = state_38231;
(statearr_38243[(8)] = inst_38224);

return statearr_38243;
})();
var statearr_38244_38266 = state_38231__$1;
(statearr_38244_38266[(2)] = null);

(statearr_38244_38266[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38232 === (8))){
var inst_38213 = (state_38231[(7)]);
var state_38231__$1 = state_38231;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38231__$1,(11),out,inst_38213);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto___38256,out))
;
return ((function (switch__8364__auto__,c__8429__auto___38256,out){
return (function() {
var cljs$core$async$state_machine__8365__auto__ = null;
var cljs$core$async$state_machine__8365__auto____0 = (function (){
var statearr_38248 = [null,null,null,null,null,null,null,null,null];
(statearr_38248[(0)] = cljs$core$async$state_machine__8365__auto__);

(statearr_38248[(1)] = (1));

return statearr_38248;
});
var cljs$core$async$state_machine__8365__auto____1 = (function (state_38231){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_38231);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e38249){if((e38249 instanceof Object)){
var ex__8368__auto__ = e38249;
var statearr_38250_38267 = state_38231;
(statearr_38250_38267[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38231);

return cljs.core.cst$kw$recur;
} else {
throw e38249;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__38268 = state_38231;
state_38231 = G__38268;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$state_machine__8365__auto__ = function(state_38231){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8365__auto____1.call(this,state_38231);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8365__auto____0;
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8365__auto____1;
return cljs$core$async$state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___38256,out))
})();
var state__8431__auto__ = (function (){var statearr_38251 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_38251[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___38256);

return statearr_38251;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});})(c__8429__auto___38256,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args38269 = [];
var len__5627__auto___38272 = arguments.length;
var i__5628__auto___38273 = (0);
while(true){
if((i__5628__auto___38273 < len__5627__auto___38272)){
args38269.push((arguments[i__5628__auto___38273]));

var G__38274 = (i__5628__auto___38273 + (1));
i__5628__auto___38273 = G__38274;
continue;
} else {
}
break;
}

var G__38271 = args38269.length;
switch (G__38271) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38269.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__8429__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8429__auto__){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto__){
return (function (state_38441){
var state_val_38442 = (state_38441[(1)]);
if((state_val_38442 === (7))){
var inst_38437 = (state_38441[(2)]);
var state_38441__$1 = state_38441;
var statearr_38443_38484 = state_38441__$1;
(statearr_38443_38484[(2)] = inst_38437);

(statearr_38443_38484[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38442 === (20))){
var inst_38407 = (state_38441[(7)]);
var inst_38418 = (state_38441[(2)]);
var inst_38419 = cljs.core.next(inst_38407);
var inst_38393 = inst_38419;
var inst_38394 = null;
var inst_38395 = (0);
var inst_38396 = (0);
var state_38441__$1 = (function (){var statearr_38444 = state_38441;
(statearr_38444[(8)] = inst_38393);

(statearr_38444[(9)] = inst_38395);

(statearr_38444[(10)] = inst_38396);

(statearr_38444[(11)] = inst_38418);

(statearr_38444[(12)] = inst_38394);

return statearr_38444;
})();
var statearr_38445_38485 = state_38441__$1;
(statearr_38445_38485[(2)] = null);

(statearr_38445_38485[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38442 === (1))){
var state_38441__$1 = state_38441;
var statearr_38446_38486 = state_38441__$1;
(statearr_38446_38486[(2)] = null);

(statearr_38446_38486[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38442 === (4))){
var inst_38382 = (state_38441[(13)]);
var inst_38382__$1 = (state_38441[(2)]);
var inst_38383 = (inst_38382__$1 == null);
var state_38441__$1 = (function (){var statearr_38447 = state_38441;
(statearr_38447[(13)] = inst_38382__$1);

return statearr_38447;
})();
if(cljs.core.truth_(inst_38383)){
var statearr_38448_38487 = state_38441__$1;
(statearr_38448_38487[(1)] = (5));

} else {
var statearr_38449_38488 = state_38441__$1;
(statearr_38449_38488[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38442 === (15))){
var state_38441__$1 = state_38441;
var statearr_38453_38489 = state_38441__$1;
(statearr_38453_38489[(2)] = null);

(statearr_38453_38489[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38442 === (21))){
var state_38441__$1 = state_38441;
var statearr_38454_38490 = state_38441__$1;
(statearr_38454_38490[(2)] = null);

(statearr_38454_38490[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38442 === (13))){
var inst_38393 = (state_38441[(8)]);
var inst_38395 = (state_38441[(9)]);
var inst_38396 = (state_38441[(10)]);
var inst_38394 = (state_38441[(12)]);
var inst_38403 = (state_38441[(2)]);
var inst_38404 = (inst_38396 + (1));
var tmp38450 = inst_38393;
var tmp38451 = inst_38395;
var tmp38452 = inst_38394;
var inst_38393__$1 = tmp38450;
var inst_38394__$1 = tmp38452;
var inst_38395__$1 = tmp38451;
var inst_38396__$1 = inst_38404;
var state_38441__$1 = (function (){var statearr_38455 = state_38441;
(statearr_38455[(8)] = inst_38393__$1);

(statearr_38455[(9)] = inst_38395__$1);

(statearr_38455[(10)] = inst_38396__$1);

(statearr_38455[(12)] = inst_38394__$1);

(statearr_38455[(14)] = inst_38403);

return statearr_38455;
})();
var statearr_38456_38491 = state_38441__$1;
(statearr_38456_38491[(2)] = null);

(statearr_38456_38491[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38442 === (22))){
var state_38441__$1 = state_38441;
var statearr_38457_38492 = state_38441__$1;
(statearr_38457_38492[(2)] = null);

(statearr_38457_38492[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38442 === (6))){
var inst_38382 = (state_38441[(13)]);
var inst_38391 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_38382) : f.call(null,inst_38382));
var inst_38392 = cljs.core.seq(inst_38391);
var inst_38393 = inst_38392;
var inst_38394 = null;
var inst_38395 = (0);
var inst_38396 = (0);
var state_38441__$1 = (function (){var statearr_38458 = state_38441;
(statearr_38458[(8)] = inst_38393);

(statearr_38458[(9)] = inst_38395);

(statearr_38458[(10)] = inst_38396);

(statearr_38458[(12)] = inst_38394);

return statearr_38458;
})();
var statearr_38459_38493 = state_38441__$1;
(statearr_38459_38493[(2)] = null);

(statearr_38459_38493[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38442 === (17))){
var inst_38407 = (state_38441[(7)]);
var inst_38411 = cljs.core.chunk_first(inst_38407);
var inst_38412 = cljs.core.chunk_rest(inst_38407);
var inst_38413 = cljs.core.count(inst_38411);
var inst_38393 = inst_38412;
var inst_38394 = inst_38411;
var inst_38395 = inst_38413;
var inst_38396 = (0);
var state_38441__$1 = (function (){var statearr_38460 = state_38441;
(statearr_38460[(8)] = inst_38393);

(statearr_38460[(9)] = inst_38395);

(statearr_38460[(10)] = inst_38396);

(statearr_38460[(12)] = inst_38394);

return statearr_38460;
})();
var statearr_38461_38494 = state_38441__$1;
(statearr_38461_38494[(2)] = null);

(statearr_38461_38494[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38442 === (3))){
var inst_38439 = (state_38441[(2)]);
var state_38441__$1 = state_38441;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38441__$1,inst_38439);
} else {
if((state_val_38442 === (12))){
var inst_38427 = (state_38441[(2)]);
var state_38441__$1 = state_38441;
var statearr_38462_38495 = state_38441__$1;
(statearr_38462_38495[(2)] = inst_38427);

(statearr_38462_38495[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38442 === (2))){
var state_38441__$1 = state_38441;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38441__$1,(4),in$);
} else {
if((state_val_38442 === (23))){
var inst_38435 = (state_38441[(2)]);
var state_38441__$1 = state_38441;
var statearr_38463_38496 = state_38441__$1;
(statearr_38463_38496[(2)] = inst_38435);

(statearr_38463_38496[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38442 === (19))){
var inst_38422 = (state_38441[(2)]);
var state_38441__$1 = state_38441;
var statearr_38464_38497 = state_38441__$1;
(statearr_38464_38497[(2)] = inst_38422);

(statearr_38464_38497[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38442 === (11))){
var inst_38393 = (state_38441[(8)]);
var inst_38407 = (state_38441[(7)]);
var inst_38407__$1 = cljs.core.seq(inst_38393);
var state_38441__$1 = (function (){var statearr_38465 = state_38441;
(statearr_38465[(7)] = inst_38407__$1);

return statearr_38465;
})();
if(inst_38407__$1){
var statearr_38466_38498 = state_38441__$1;
(statearr_38466_38498[(1)] = (14));

} else {
var statearr_38467_38499 = state_38441__$1;
(statearr_38467_38499[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38442 === (9))){
var inst_38429 = (state_38441[(2)]);
var inst_38430 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_38441__$1 = (function (){var statearr_38468 = state_38441;
(statearr_38468[(15)] = inst_38429);

return statearr_38468;
})();
if(cljs.core.truth_(inst_38430)){
var statearr_38469_38500 = state_38441__$1;
(statearr_38469_38500[(1)] = (21));

} else {
var statearr_38470_38501 = state_38441__$1;
(statearr_38470_38501[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38442 === (5))){
var inst_38385 = cljs.core.async.close_BANG_(out);
var state_38441__$1 = state_38441;
var statearr_38471_38502 = state_38441__$1;
(statearr_38471_38502[(2)] = inst_38385);

(statearr_38471_38502[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38442 === (14))){
var inst_38407 = (state_38441[(7)]);
var inst_38409 = cljs.core.chunked_seq_QMARK_(inst_38407);
var state_38441__$1 = state_38441;
if(inst_38409){
var statearr_38472_38503 = state_38441__$1;
(statearr_38472_38503[(1)] = (17));

} else {
var statearr_38473_38504 = state_38441__$1;
(statearr_38473_38504[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38442 === (16))){
var inst_38425 = (state_38441[(2)]);
var state_38441__$1 = state_38441;
var statearr_38474_38505 = state_38441__$1;
(statearr_38474_38505[(2)] = inst_38425);

(statearr_38474_38505[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38442 === (10))){
var inst_38396 = (state_38441[(10)]);
var inst_38394 = (state_38441[(12)]);
var inst_38401 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_38394,inst_38396);
var state_38441__$1 = state_38441;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38441__$1,(13),out,inst_38401);
} else {
if((state_val_38442 === (18))){
var inst_38407 = (state_38441[(7)]);
var inst_38416 = cljs.core.first(inst_38407);
var state_38441__$1 = state_38441;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38441__$1,(20),out,inst_38416);
} else {
if((state_val_38442 === (8))){
var inst_38395 = (state_38441[(9)]);
var inst_38396 = (state_38441[(10)]);
var inst_38398 = (inst_38396 < inst_38395);
var inst_38399 = inst_38398;
var state_38441__$1 = state_38441;
if(cljs.core.truth_(inst_38399)){
var statearr_38475_38506 = state_38441__$1;
(statearr_38475_38506[(1)] = (10));

} else {
var statearr_38476_38507 = state_38441__$1;
(statearr_38476_38507[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto__))
;
return ((function (switch__8364__auto__,c__8429__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__8365__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__8365__auto____0 = (function (){
var statearr_38480 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38480[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__8365__auto__);

(statearr_38480[(1)] = (1));

return statearr_38480;
});
var cljs$core$async$mapcat_STAR__$_state_machine__8365__auto____1 = (function (state_38441){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_38441);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e38481){if((e38481 instanceof Object)){
var ex__8368__auto__ = e38481;
var statearr_38482_38508 = state_38441;
(statearr_38482_38508[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38441);

return cljs.core.cst$kw$recur;
} else {
throw e38481;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__38509 = state_38441;
state_38441 = G__38509;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__8365__auto__ = function(state_38441){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__8365__auto____1.call(this,state_38441);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__8365__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__8365__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto__))
})();
var state__8431__auto__ = (function (){var statearr_38483 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_38483[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto__);

return statearr_38483;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});})(c__8429__auto__))
);

return c__8429__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args38510 = [];
var len__5627__auto___38513 = arguments.length;
var i__5628__auto___38514 = (0);
while(true){
if((i__5628__auto___38514 < len__5627__auto___38513)){
args38510.push((arguments[i__5628__auto___38514]));

var G__38515 = (i__5628__auto___38514 + (1));
i__5628__auto___38514 = G__38515;
continue;
} else {
}
break;
}

var G__38512 = args38510.length;
switch (G__38512) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38510.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args38517 = [];
var len__5627__auto___38520 = arguments.length;
var i__5628__auto___38521 = (0);
while(true){
if((i__5628__auto___38521 < len__5627__auto___38520)){
args38517.push((arguments[i__5628__auto___38521]));

var G__38522 = (i__5628__auto___38521 + (1));
i__5628__auto___38521 = G__38522;
continue;
} else {
}
break;
}

var G__38519 = args38517.length;
switch (G__38519) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38517.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args38524 = [];
var len__5627__auto___38575 = arguments.length;
var i__5628__auto___38576 = (0);
while(true){
if((i__5628__auto___38576 < len__5627__auto___38575)){
args38524.push((arguments[i__5628__auto___38576]));

var G__38577 = (i__5628__auto___38576 + (1));
i__5628__auto___38576 = G__38577;
continue;
} else {
}
break;
}

var G__38526 = args38524.length;
switch (G__38526) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38524.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__8429__auto___38579 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8429__auto___38579,out){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___38579,out){
return (function (state_38550){
var state_val_38551 = (state_38550[(1)]);
if((state_val_38551 === (7))){
var inst_38545 = (state_38550[(2)]);
var state_38550__$1 = state_38550;
var statearr_38552_38580 = state_38550__$1;
(statearr_38552_38580[(2)] = inst_38545);

(statearr_38552_38580[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38551 === (1))){
var inst_38527 = null;
var state_38550__$1 = (function (){var statearr_38553 = state_38550;
(statearr_38553[(7)] = inst_38527);

return statearr_38553;
})();
var statearr_38554_38581 = state_38550__$1;
(statearr_38554_38581[(2)] = null);

(statearr_38554_38581[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38551 === (4))){
var inst_38530 = (state_38550[(8)]);
var inst_38530__$1 = (state_38550[(2)]);
var inst_38531 = (inst_38530__$1 == null);
var inst_38532 = cljs.core.not(inst_38531);
var state_38550__$1 = (function (){var statearr_38555 = state_38550;
(statearr_38555[(8)] = inst_38530__$1);

return statearr_38555;
})();
if(inst_38532){
var statearr_38556_38582 = state_38550__$1;
(statearr_38556_38582[(1)] = (5));

} else {
var statearr_38557_38583 = state_38550__$1;
(statearr_38557_38583[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38551 === (6))){
var state_38550__$1 = state_38550;
var statearr_38558_38584 = state_38550__$1;
(statearr_38558_38584[(2)] = null);

(statearr_38558_38584[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38551 === (3))){
var inst_38547 = (state_38550[(2)]);
var inst_38548 = cljs.core.async.close_BANG_(out);
var state_38550__$1 = (function (){var statearr_38559 = state_38550;
(statearr_38559[(9)] = inst_38547);

return statearr_38559;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38550__$1,inst_38548);
} else {
if((state_val_38551 === (2))){
var state_38550__$1 = state_38550;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38550__$1,(4),ch);
} else {
if((state_val_38551 === (11))){
var inst_38530 = (state_38550[(8)]);
var inst_38539 = (state_38550[(2)]);
var inst_38527 = inst_38530;
var state_38550__$1 = (function (){var statearr_38560 = state_38550;
(statearr_38560[(10)] = inst_38539);

(statearr_38560[(7)] = inst_38527);

return statearr_38560;
})();
var statearr_38561_38585 = state_38550__$1;
(statearr_38561_38585[(2)] = null);

(statearr_38561_38585[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38551 === (9))){
var inst_38530 = (state_38550[(8)]);
var state_38550__$1 = state_38550;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38550__$1,(11),out,inst_38530);
} else {
if((state_val_38551 === (5))){
var inst_38527 = (state_38550[(7)]);
var inst_38530 = (state_38550[(8)]);
var inst_38534 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38530,inst_38527);
var state_38550__$1 = state_38550;
if(inst_38534){
var statearr_38563_38586 = state_38550__$1;
(statearr_38563_38586[(1)] = (8));

} else {
var statearr_38564_38587 = state_38550__$1;
(statearr_38564_38587[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38551 === (10))){
var inst_38542 = (state_38550[(2)]);
var state_38550__$1 = state_38550;
var statearr_38565_38588 = state_38550__$1;
(statearr_38565_38588[(2)] = inst_38542);

(statearr_38565_38588[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38551 === (8))){
var inst_38527 = (state_38550[(7)]);
var tmp38562 = inst_38527;
var inst_38527__$1 = tmp38562;
var state_38550__$1 = (function (){var statearr_38566 = state_38550;
(statearr_38566[(7)] = inst_38527__$1);

return statearr_38566;
})();
var statearr_38567_38589 = state_38550__$1;
(statearr_38567_38589[(2)] = null);

(statearr_38567_38589[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto___38579,out))
;
return ((function (switch__8364__auto__,c__8429__auto___38579,out){
return (function() {
var cljs$core$async$state_machine__8365__auto__ = null;
var cljs$core$async$state_machine__8365__auto____0 = (function (){
var statearr_38571 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38571[(0)] = cljs$core$async$state_machine__8365__auto__);

(statearr_38571[(1)] = (1));

return statearr_38571;
});
var cljs$core$async$state_machine__8365__auto____1 = (function (state_38550){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_38550);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e38572){if((e38572 instanceof Object)){
var ex__8368__auto__ = e38572;
var statearr_38573_38590 = state_38550;
(statearr_38573_38590[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38550);

return cljs.core.cst$kw$recur;
} else {
throw e38572;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__38591 = state_38550;
state_38550 = G__38591;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$state_machine__8365__auto__ = function(state_38550){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8365__auto____1.call(this,state_38550);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8365__auto____0;
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8365__auto____1;
return cljs$core$async$state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___38579,out))
})();
var state__8431__auto__ = (function (){var statearr_38574 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_38574[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___38579);

return statearr_38574;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});})(c__8429__auto___38579,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args38592 = [];
var len__5627__auto___38662 = arguments.length;
var i__5628__auto___38663 = (0);
while(true){
if((i__5628__auto___38663 < len__5627__auto___38662)){
args38592.push((arguments[i__5628__auto___38663]));

var G__38664 = (i__5628__auto___38663 + (1));
i__5628__auto___38663 = G__38664;
continue;
} else {
}
break;
}

var G__38594 = args38592.length;
switch (G__38594) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38592.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__8429__auto___38666 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8429__auto___38666,out){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___38666,out){
return (function (state_38632){
var state_val_38633 = (state_38632[(1)]);
if((state_val_38633 === (7))){
var inst_38628 = (state_38632[(2)]);
var state_38632__$1 = state_38632;
var statearr_38634_38667 = state_38632__$1;
(statearr_38634_38667[(2)] = inst_38628);

(statearr_38634_38667[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38633 === (1))){
var inst_38595 = (new Array(n));
var inst_38596 = inst_38595;
var inst_38597 = (0);
var state_38632__$1 = (function (){var statearr_38635 = state_38632;
(statearr_38635[(7)] = inst_38597);

(statearr_38635[(8)] = inst_38596);

return statearr_38635;
})();
var statearr_38636_38668 = state_38632__$1;
(statearr_38636_38668[(2)] = null);

(statearr_38636_38668[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38633 === (4))){
var inst_38600 = (state_38632[(9)]);
var inst_38600__$1 = (state_38632[(2)]);
var inst_38601 = (inst_38600__$1 == null);
var inst_38602 = cljs.core.not(inst_38601);
var state_38632__$1 = (function (){var statearr_38637 = state_38632;
(statearr_38637[(9)] = inst_38600__$1);

return statearr_38637;
})();
if(inst_38602){
var statearr_38638_38669 = state_38632__$1;
(statearr_38638_38669[(1)] = (5));

} else {
var statearr_38639_38670 = state_38632__$1;
(statearr_38639_38670[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38633 === (15))){
var inst_38622 = (state_38632[(2)]);
var state_38632__$1 = state_38632;
var statearr_38640_38671 = state_38632__$1;
(statearr_38640_38671[(2)] = inst_38622);

(statearr_38640_38671[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38633 === (13))){
var state_38632__$1 = state_38632;
var statearr_38641_38672 = state_38632__$1;
(statearr_38641_38672[(2)] = null);

(statearr_38641_38672[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38633 === (6))){
var inst_38597 = (state_38632[(7)]);
var inst_38618 = (inst_38597 > (0));
var state_38632__$1 = state_38632;
if(cljs.core.truth_(inst_38618)){
var statearr_38642_38673 = state_38632__$1;
(statearr_38642_38673[(1)] = (12));

} else {
var statearr_38643_38674 = state_38632__$1;
(statearr_38643_38674[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38633 === (3))){
var inst_38630 = (state_38632[(2)]);
var state_38632__$1 = state_38632;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38632__$1,inst_38630);
} else {
if((state_val_38633 === (12))){
var inst_38596 = (state_38632[(8)]);
var inst_38620 = cljs.core.vec(inst_38596);
var state_38632__$1 = state_38632;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38632__$1,(15),out,inst_38620);
} else {
if((state_val_38633 === (2))){
var state_38632__$1 = state_38632;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38632__$1,(4),ch);
} else {
if((state_val_38633 === (11))){
var inst_38612 = (state_38632[(2)]);
var inst_38613 = (new Array(n));
var inst_38596 = inst_38613;
var inst_38597 = (0);
var state_38632__$1 = (function (){var statearr_38644 = state_38632;
(statearr_38644[(7)] = inst_38597);

(statearr_38644[(8)] = inst_38596);

(statearr_38644[(10)] = inst_38612);

return statearr_38644;
})();
var statearr_38645_38675 = state_38632__$1;
(statearr_38645_38675[(2)] = null);

(statearr_38645_38675[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38633 === (9))){
var inst_38596 = (state_38632[(8)]);
var inst_38610 = cljs.core.vec(inst_38596);
var state_38632__$1 = state_38632;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38632__$1,(11),out,inst_38610);
} else {
if((state_val_38633 === (5))){
var inst_38597 = (state_38632[(7)]);
var inst_38596 = (state_38632[(8)]);
var inst_38605 = (state_38632[(11)]);
var inst_38600 = (state_38632[(9)]);
var inst_38604 = (inst_38596[inst_38597] = inst_38600);
var inst_38605__$1 = (inst_38597 + (1));
var inst_38606 = (inst_38605__$1 < n);
var state_38632__$1 = (function (){var statearr_38646 = state_38632;
(statearr_38646[(12)] = inst_38604);

(statearr_38646[(11)] = inst_38605__$1);

return statearr_38646;
})();
if(cljs.core.truth_(inst_38606)){
var statearr_38647_38676 = state_38632__$1;
(statearr_38647_38676[(1)] = (8));

} else {
var statearr_38648_38677 = state_38632__$1;
(statearr_38648_38677[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38633 === (14))){
var inst_38625 = (state_38632[(2)]);
var inst_38626 = cljs.core.async.close_BANG_(out);
var state_38632__$1 = (function (){var statearr_38650 = state_38632;
(statearr_38650[(13)] = inst_38625);

return statearr_38650;
})();
var statearr_38651_38678 = state_38632__$1;
(statearr_38651_38678[(2)] = inst_38626);

(statearr_38651_38678[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38633 === (10))){
var inst_38616 = (state_38632[(2)]);
var state_38632__$1 = state_38632;
var statearr_38652_38679 = state_38632__$1;
(statearr_38652_38679[(2)] = inst_38616);

(statearr_38652_38679[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38633 === (8))){
var inst_38596 = (state_38632[(8)]);
var inst_38605 = (state_38632[(11)]);
var tmp38649 = inst_38596;
var inst_38596__$1 = tmp38649;
var inst_38597 = inst_38605;
var state_38632__$1 = (function (){var statearr_38653 = state_38632;
(statearr_38653[(7)] = inst_38597);

(statearr_38653[(8)] = inst_38596__$1);

return statearr_38653;
})();
var statearr_38654_38680 = state_38632__$1;
(statearr_38654_38680[(2)] = null);

(statearr_38654_38680[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto___38666,out))
;
return ((function (switch__8364__auto__,c__8429__auto___38666,out){
return (function() {
var cljs$core$async$state_machine__8365__auto__ = null;
var cljs$core$async$state_machine__8365__auto____0 = (function (){
var statearr_38658 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38658[(0)] = cljs$core$async$state_machine__8365__auto__);

(statearr_38658[(1)] = (1));

return statearr_38658;
});
var cljs$core$async$state_machine__8365__auto____1 = (function (state_38632){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_38632);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e38659){if((e38659 instanceof Object)){
var ex__8368__auto__ = e38659;
var statearr_38660_38681 = state_38632;
(statearr_38660_38681[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38632);

return cljs.core.cst$kw$recur;
} else {
throw e38659;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__38682 = state_38632;
state_38632 = G__38682;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$state_machine__8365__auto__ = function(state_38632){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8365__auto____1.call(this,state_38632);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8365__auto____0;
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8365__auto____1;
return cljs$core$async$state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___38666,out))
})();
var state__8431__auto__ = (function (){var statearr_38661 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_38661[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___38666);

return statearr_38661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});})(c__8429__auto___38666,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args38683 = [];
var len__5627__auto___38757 = arguments.length;
var i__5628__auto___38758 = (0);
while(true){
if((i__5628__auto___38758 < len__5627__auto___38757)){
args38683.push((arguments[i__5628__auto___38758]));

var G__38759 = (i__5628__auto___38758 + (1));
i__5628__auto___38758 = G__38759;
continue;
} else {
}
break;
}

var G__38685 = args38683.length;
switch (G__38685) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38683.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__8429__auto___38761 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8429__auto___38761,out){
return (function (){
var f__8430__auto__ = (function (){var switch__8364__auto__ = ((function (c__8429__auto___38761,out){
return (function (state_38727){
var state_val_38728 = (state_38727[(1)]);
if((state_val_38728 === (7))){
var inst_38723 = (state_38727[(2)]);
var state_38727__$1 = state_38727;
var statearr_38729_38762 = state_38727__$1;
(statearr_38729_38762[(2)] = inst_38723);

(statearr_38729_38762[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38728 === (1))){
var inst_38686 = [];
var inst_38687 = inst_38686;
var inst_38688 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_38727__$1 = (function (){var statearr_38730 = state_38727;
(statearr_38730[(7)] = inst_38687);

(statearr_38730[(8)] = inst_38688);

return statearr_38730;
})();
var statearr_38731_38763 = state_38727__$1;
(statearr_38731_38763[(2)] = null);

(statearr_38731_38763[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38728 === (4))){
var inst_38691 = (state_38727[(9)]);
var inst_38691__$1 = (state_38727[(2)]);
var inst_38692 = (inst_38691__$1 == null);
var inst_38693 = cljs.core.not(inst_38692);
var state_38727__$1 = (function (){var statearr_38732 = state_38727;
(statearr_38732[(9)] = inst_38691__$1);

return statearr_38732;
})();
if(inst_38693){
var statearr_38733_38764 = state_38727__$1;
(statearr_38733_38764[(1)] = (5));

} else {
var statearr_38734_38765 = state_38727__$1;
(statearr_38734_38765[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38728 === (15))){
var inst_38717 = (state_38727[(2)]);
var state_38727__$1 = state_38727;
var statearr_38735_38766 = state_38727__$1;
(statearr_38735_38766[(2)] = inst_38717);

(statearr_38735_38766[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38728 === (13))){
var state_38727__$1 = state_38727;
var statearr_38736_38767 = state_38727__$1;
(statearr_38736_38767[(2)] = null);

(statearr_38736_38767[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38728 === (6))){
var inst_38687 = (state_38727[(7)]);
var inst_38712 = inst_38687.length;
var inst_38713 = (inst_38712 > (0));
var state_38727__$1 = state_38727;
if(cljs.core.truth_(inst_38713)){
var statearr_38737_38768 = state_38727__$1;
(statearr_38737_38768[(1)] = (12));

} else {
var statearr_38738_38769 = state_38727__$1;
(statearr_38738_38769[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38728 === (3))){
var inst_38725 = (state_38727[(2)]);
var state_38727__$1 = state_38727;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38727__$1,inst_38725);
} else {
if((state_val_38728 === (12))){
var inst_38687 = (state_38727[(7)]);
var inst_38715 = cljs.core.vec(inst_38687);
var state_38727__$1 = state_38727;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38727__$1,(15),out,inst_38715);
} else {
if((state_val_38728 === (2))){
var state_38727__$1 = state_38727;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38727__$1,(4),ch);
} else {
if((state_val_38728 === (11))){
var inst_38695 = (state_38727[(10)]);
var inst_38691 = (state_38727[(9)]);
var inst_38705 = (state_38727[(2)]);
var inst_38706 = [];
var inst_38707 = inst_38706.push(inst_38691);
var inst_38687 = inst_38706;
var inst_38688 = inst_38695;
var state_38727__$1 = (function (){var statearr_38739 = state_38727;
(statearr_38739[(11)] = inst_38707);

(statearr_38739[(12)] = inst_38705);

(statearr_38739[(7)] = inst_38687);

(statearr_38739[(8)] = inst_38688);

return statearr_38739;
})();
var statearr_38740_38770 = state_38727__$1;
(statearr_38740_38770[(2)] = null);

(statearr_38740_38770[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38728 === (9))){
var inst_38687 = (state_38727[(7)]);
var inst_38703 = cljs.core.vec(inst_38687);
var state_38727__$1 = state_38727;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38727__$1,(11),out,inst_38703);
} else {
if((state_val_38728 === (5))){
var inst_38695 = (state_38727[(10)]);
var inst_38691 = (state_38727[(9)]);
var inst_38688 = (state_38727[(8)]);
var inst_38695__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_38691) : f.call(null,inst_38691));
var inst_38696 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38695__$1,inst_38688);
var inst_38697 = cljs.core.keyword_identical_QMARK_(inst_38688,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_38698 = (inst_38696) || (inst_38697);
var state_38727__$1 = (function (){var statearr_38741 = state_38727;
(statearr_38741[(10)] = inst_38695__$1);

return statearr_38741;
})();
if(cljs.core.truth_(inst_38698)){
var statearr_38742_38771 = state_38727__$1;
(statearr_38742_38771[(1)] = (8));

} else {
var statearr_38743_38772 = state_38727__$1;
(statearr_38743_38772[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38728 === (14))){
var inst_38720 = (state_38727[(2)]);
var inst_38721 = cljs.core.async.close_BANG_(out);
var state_38727__$1 = (function (){var statearr_38745 = state_38727;
(statearr_38745[(13)] = inst_38720);

return statearr_38745;
})();
var statearr_38746_38773 = state_38727__$1;
(statearr_38746_38773[(2)] = inst_38721);

(statearr_38746_38773[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38728 === (10))){
var inst_38710 = (state_38727[(2)]);
var state_38727__$1 = state_38727;
var statearr_38747_38774 = state_38727__$1;
(statearr_38747_38774[(2)] = inst_38710);

(statearr_38747_38774[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38728 === (8))){
var inst_38695 = (state_38727[(10)]);
var inst_38687 = (state_38727[(7)]);
var inst_38691 = (state_38727[(9)]);
var inst_38700 = inst_38687.push(inst_38691);
var tmp38744 = inst_38687;
var inst_38687__$1 = tmp38744;
var inst_38688 = inst_38695;
var state_38727__$1 = (function (){var statearr_38748 = state_38727;
(statearr_38748[(14)] = inst_38700);

(statearr_38748[(7)] = inst_38687__$1);

(statearr_38748[(8)] = inst_38688);

return statearr_38748;
})();
var statearr_38749_38775 = state_38727__$1;
(statearr_38749_38775[(2)] = null);

(statearr_38749_38775[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8429__auto___38761,out))
;
return ((function (switch__8364__auto__,c__8429__auto___38761,out){
return (function() {
var cljs$core$async$state_machine__8365__auto__ = null;
var cljs$core$async$state_machine__8365__auto____0 = (function (){
var statearr_38753 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38753[(0)] = cljs$core$async$state_machine__8365__auto__);

(statearr_38753[(1)] = (1));

return statearr_38753;
});
var cljs$core$async$state_machine__8365__auto____1 = (function (state_38727){
while(true){
var ret_value__8366__auto__ = (function (){try{while(true){
var result__8367__auto__ = switch__8364__auto__(state_38727);
if(cljs.core.keyword_identical_QMARK_(result__8367__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__8367__auto__;
}
break;
}
}catch (e38754){if((e38754 instanceof Object)){
var ex__8368__auto__ = e38754;
var statearr_38755_38776 = state_38727;
(statearr_38755_38776[(5)] = ex__8368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38727);

return cljs.core.cst$kw$recur;
} else {
throw e38754;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8366__auto__,cljs.core.cst$kw$recur)){
var G__38777 = state_38727;
state_38727 = G__38777;
continue;
} else {
return ret_value__8366__auto__;
}
break;
}
});
cljs$core$async$state_machine__8365__auto__ = function(state_38727){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8365__auto____1.call(this,state_38727);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8365__auto____0;
cljs$core$async$state_machine__8365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8365__auto____1;
return cljs$core$async$state_machine__8365__auto__;
})()
;})(switch__8364__auto__,c__8429__auto___38761,out))
})();
var state__8431__auto__ = (function (){var statearr_38756 = (f__8430__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8430__auto__.cljs$core$IFn$_invoke$arity$0() : f__8430__auto__.call(null));
(statearr_38756[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8429__auto___38761);

return statearr_38756;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8431__auto__);
});})(c__8429__auto___38761,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
